; sumema/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
	PAGE
;
	SUBTTL	'<SUMEMA/ASM - Memory Section A>'
;
;	$DISMEM - display memory
;
DISMEM	LD	BC,BUFFER	;default address
	LD	(DEFADDR),BC	;save it
	CALL	GETADDR		;get user address
;
DOADDR	LD	HL,DISRETM	;return from modify
	LD	(VECTOR1),HL	;save for UPDATE
	LD	(VECTOR2),HL	;save for CANCEL
	LD	HL,DISMCN1	;continue
	LD	(VECTOR3),HL	;save for base change
;
	LD	(ADDRESS),BC	;save display address
;
DISRETM	RST	@08		;clear screen
;
	DEFB	CLSA
	DEFB	ETX
;
DISMCON	CALL	SHOW		;display buffer data
;
DISMCN1	CALL	SHOWLF		;show addresses, etc.
	LD	HL,SPACES	;clear top portion
	LD	DE,VIDEO	;of video from last entry
	LD	BC,3		;3 chars long
	LDIR			;fill with spaces
;
	LD	A,12		;flash counter
	LD	BC,20B0H	;off, on display bytes
	LD	HL,VIDEO	;where to flash it
	CALL	FLICKS		;special flicker routine
;
	PUSH	AF		;save input key
	CALL	UCASE		;make it upper case
	CP	SPACE		;check for control code
	JR	NC,HASDMXX	;OK
	LD	A,8FH		;use block instead
HASDMXX	LD	(HL),A		;to video
	POP	AF		;restore char
;
;	since CLEAR key is also the table terminator
;	byte, check for it special
;
	CP	CLEAR		;clear key?
	JP	Z,NEWDMEM	;new memory address
;
	LD	HL,(ADDRESS)	;fetch display address
	LD	DE,DISMTBL	;jump table
	CALL	GOTABL		;is key there?
;
DISMRET	LD	(ADDRESS),HL	;save address
	JR	DISMCON		;continue
;
;	jump table for memory modify 'paging' mode
;
DISMTBL	DEFB	UARR		;up arrow
	DEFW	DMEMUP
	DEFB	DARR		;down arrow
	DEFW	DMEMDP
	DEFB	LARR		;left arrow
	DEFW	DMEMD
	DEFB	RARR		;right arrow
	DEFW	DMEMU
	DEFB	SLARR		;shift left arrow
	DEFW	DMEMDP
	DEFB	SRARR		;shift right arrow
	DEFW	DMEMUP
	DEFB	SDARR		;shift down arrow
	DEFW	DMEMB
	DEFB	SUARR		;shift up arrow
	DEFW	DMEMT
	DEFB	'A'		;ascii modify
	DEFW	ASCIT
	DEFB	'B'		;binary modify
	DEFW	BINIT
	DEFB	'D'		;decimal modify
	DEFW	DECIT
	DEFB	'H'		;hex modify
	DEFW	HEXIT
	DEFB	'O'		;octal modify
	DEFW	OCTIT
	DEFB	'Q'		;octal modify
	DEFW	OCTIT
	DEFB	'M'		;enter modify mode
	DEFW	MODIFY
	DEFB	'@'		;enter decode mode
	DEFW	DECODE
	DEFB	ETBL		;table terminator
;
DMEMU	INC	HL		;right arrow
	JR	DISMRET		;continue
;
DMEMD	DEC	HL		;left arrow
	JR	DISMRET		;continue
;
DMEMUP	INC	H		;up/shift right arrow's
	JR	DISMRET		;continue
;
DMEMT	LD	HL,(TOPMEM)	;shift up arrow
;
DMEMDP	DEC	H		;down/shift left arrow's
	JR	DISMRET		;continue
;
DMEMB	LD	HL,0		;shift down arrow
	JR	DISMRET		;continue
;
	PAGE
;
;	$GETADDR - fetch address into BC
;
GETADDR	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
GETADR1	RST	@08		;display prompt
;
	DEFB	EOL
	DEFM	'Address ? '
	DEFB	ETX
;
	LD	B,30		;30 char input
	RST	@10		;get key input
	LD	BC,(DEFADDR)	;default to end program
	RET	Z		;default if no input
	CALL	UCASE		;make it upper case
	CP	'L'		;last address?
	LD	BC,(ADDRESS)	;get last
	RET	Z		;yes, return
	CALL	VALUE		;get the value
	JR	C,GETADR1	;bad value, ask again
	RET			;else have it
;
;	clear key, re-prompt for new input
;
NEWDMEM	RST	@08		;clear screen
;
	DEFB	CLSF
	DEFB	ETX
;
	JP	DISMEM		;start over again
;
	PAGE
;
;	$DOBUILD - build format track in memory
;
DOBUILD	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	HL,BUFFER	;set format buff address
	LD	(FMTBUFF),HL	;save it
	LD	(ADDRESS),HL	;set as display buffer
	LD	A,7		;use drive 7 for dummy
	CALL	SETDRV		;set it up
;
DOBLD	RST	@08		;display prompt
;
	DEFB	EOL
	DEFM	'Dos Type ? '
	DEFB	ETX
;
	LD	B,10		;10 char input
	RST	@10		;get from keyboard
	CALL	POSHL		;any input?
	JR	Z,DOBLD		;nope, ask again
;
	CALL	CKCONF		;check for configuration
	JR	C,DOBLD		;bad input, ask again
;
DECBLD	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
BDTK	RST	@08		;ask which track
;
	DEFB	EOL
	DEFM	'Track ? '
	DEFB	ETX
;
	LD	B,20		;20 char input
	RST	@10		;get from keyboard
	LD	C,0		;default to track 0
	CALL	POSHL		;any input?
	JR	Z,BTKD		;nope, use default
;
	CALL	VALUE		;get string value
	JR	C,BDTK		;invalid, ask again
;
BTKD	LD	(IY+3),C	;set as current track
	XOR	A		;set table as invalid
	LD	(TASKDRV),A	;save it!
;
;	setup sides as current side for build
;
	CALL	SETSIDX		;setup side
	CALL	CLRBUFF		;clear buffer
	CALL	BUILD		;build the track
;
;	display address of buffer
;
	PUSH	BC		;save buffer
	LD	HL,BTA		;string to hold value
	CALL	PUTHEX		;to hex ascii
	POP	BC		;restore buffer address
	RST	@08		;display message
;
	DEFB	LF
	DEFM	'<KEY> to display buffer at '
BTA	DEFM	'xxxxH: '
	DEFB	ETX
;
	CALL	ONEKEY		;wait for single key
	JP	DOADDR		;display it
;
	PAGE
;
;	$GETSES - get start,end,start addresses
;
GETSES	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	HL,PGMEND	;first free byte
	LD	(TEMP0),HL	;save start 1
	LD	(TEMP2),HL	;save start 2
	LD	HL,(TOPMEM)	;get top memory
	DEC	HL		;last actual byte
	LD	(TEMP1),HL	;save end
;
GETSES1	RST	@08		;display prompt
;
	DEFB	EOL
	DEFM	'Start, End, Start ? '
	DEFB	ETX
;
	LD	B,30		;30 char input
	RST	@10		;get from keyboard
	CALL	POSHL		;position to input
	RET	Z		;nil, use defaults
;
;	get start 1 value
;
	CALL	VALUE		;get value
	JR	C,GETSES1	;error, ask again
	LD	(TEMP0),BC	;save start 1 address
;
;	get end value
;
	CALL	POSHL		;any more input?
	RET	Z		;nope, use defaults
	CALL	VALUE		;get numeric value
	JR	C,GETSES1	;error, ask again
	LD	(TEMP1),BC	;save end address
;
;	get start address 2
;
	CALL	POSHL		;any more input?
	RET	Z		;nope, use default
	CALL	VALUE		;fetch value from string
	JR	C,GETSES1	;error, ask again
	LD	(TEMP2),BC	;save start 2 address
	RET			;all values fetched!
;
	PAGE
;
;	$GETSE - get start and end addresses
;
GETSE	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	BC,PGMEND	;end of program +1
	LD	(TEMP0),BC	;default to this
	LD	BC,(TOPMEM)	;last byte +1
	DEC	BC		;last actual byte
	LD	(TEMP1),BC	;default here
;
GETSED	RST	@08		;display prompt
;
	DEFB	EOL
	DEFM	'Start, End ? '
	DEFB	ETX
;
	LD	B,30		;30 char input
	RST	@10		;get from keyboard
	CALL	POSHL		;any input?
	RET	Z		;nope, use defaults
;
;	get start value
;
	CALL	VALUE		;get string value
	JR	C,GETSED	;invalid, ask again
	LD	(TEMP0),BC	;save address
;
;	get end address
;
	CALL	POSHL		;any more input?
	RET	Z		;nope, use default
	CALL	VALUE		;get value
	JR	C,GETSED	;invalid, ask again
	LD	(TEMP1),BC	;else save value
	RET			;done, return!
;
	PAGE
;
;	$MOVMEM - move memory entry point
;
MOVMEM	CALL	INTCNT		;zero the counter
	CALL	GETSES		;start,end,start
	CALL	BYTECNT		;setup registers
;
MOVMEML	LD	A,(HL)		;get source byte
	LD	(DE),A		;save here
	CALL	ADDCNT		;bump counter
	INC	HL		;bump address
	INC	DE		;point to next
	DEC	BC		;less this byte moved
	LD	A,B		;any more to do?
	OR	C		;any bits on?
	JR	NZ,MOVMEML	;continue till end
;
	CALL	SHOCNT		;display counter
	RST	@08		;display message
;
	DEFM	'bytes moved'
	DEFB	ETX
;
	JP	GOBACK		;back to sub-menu
;
	PAGE
;
;	$BYTECNT - setup registers on start/end/counter
;
BYTECNT	LD	HL,(TEMP1)	;get end address
	LD	BC,(TEMP0)	;start address
	OR	A		;clear carry
	SBC	HL,BC		;get byte count between
	INC	HL		;true count for inclusive
	LD	B,H		;give to BC
	LD	C,L		;BC = default count
	LD	HL,(TEMP0)	;get start
	LD	DE,(TEMP2)	;get new start
	RET
;
	PAGE
;
;	$EXCMEM - exchange memory entry point
;
EXCMEM	CALL	INTCNT		;clear counter
	CALL	GETSES		;get start/end/start
	CALL	BYTECNT		;setup registers
;
EXCMEML	LD	A,(HL)		;get a byte from here
	EX	AF,AF'		;save here
	LD	A,(DE)		;get this one
	LD	(HL),A		;swap it
	EX	AF,AF'		;get old first byte
	LD	(DE),A		;pass to other
	CALL	ADDCNT		;bump counter
	INC	HL		;bump buffer 1
	INC	DE		;bump buffer 2
	DEC	BC		;less byte count
	LD	A,B		;any more
	OR	C		;any bits on?
	JR	NZ,EXCMEML	;go if more
	CALL	SHOCNT		;display counter
	RST	@08		;display message
;
	DEFM	'bytes exchanged'
	DEFB	ETX
;
	JP	GOBACK		;back to sub-menu
;
	PAGE
;
;	$REVMEM - reverse memory entry point
;
REVMEM	CALL	INTCNT		;clear counter
	CALL	GETSE		;start/end
	CALL	BYTECNT		;setup registers
;
	PUSH	BC		;save count
;
REVMEM0	CALL	ADDCNT		;bump counter
	DEC	BC		;count it
	LD	A,B		;any more
	OR	C		;any bits on?
	JR	NZ,REVMEM0	;keep counting if yes
	POP	BC		;count back
;
	SRL	B		;divide BC in half
	RR	C		;BC = BC/2
	LD	DE,(TEMP1)	;get end address
;
REVMEML	LD	A,(HL)		;get one byte
	EX	AF,AF'		;save in alt A
	LD	A,(DE)		;get second byte
	LD	(HL),A		;put into first buffer
	EX	AF,AF'		;get first byte
	LD	(DE),A		;put into second buffer
	INC	HL		;bump buffer 1
	DEC	DE		;bump buffer 2
	DEC	BC		;less counter
	LD	A,B		;any more
	OR	C		;any bits on?
	JR	NZ,REVMEML	;go if any more left
;
	CALL	SHOCNT		;display counter
	RST	@08		;display message
;
	DEFM	'bytes reversed'
	DEFB	ETX
;
	JP	GOBACK		;back to sub-menu
;
	PAGE
;
;	$JUMPMEM - jump to memory entry point
;
JUMPMEM	LD	BC,SUBMENU	;sub-menu return
	LD	(DEFADDR),BC	;default address
	CALL	GETADDR		;get user address
;
;	if user did not enter address, do not
;	disable interrupts and checksum
;
	LD	HL,SUBMENU	;default supplied
	OR	A		;clear carry
	SBC	HL,BC		;compare to input
	JP	Z,SUBMENU	;go if nil input!
;
;	leave program return vector on stack
;	and also in alternate HL
;	User may return to SU by a simple RET
;	or EXX, JP (HL)
;
	PUSH	BC		;put address on stack
	LD	HL,MASTER	;main menu vector
	PUSH	HL		;pass to alt HL
	EXX			;vector in HL'
	POP	HL		;HL = return address
	EX	(SP),HL		;leave on stack, get user
;
;	protect against program re-running after exit
;	this is nominal protection again /CMD programs
;
JUMPROT	DI			;disable interrupts
	LD	BC,0C9FBH	;EI RET  opcodes
	LD	(4013H),BC	;save new interrupt
	XOR	A		;load zero
	LD	I,A		;clear checksum for exit
	EI			;enable now
;
	JP	(HL)		;go user address
;
	PAGE
;
;	$FILLMEM - fill memory entry point
;
FILLMEM	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	HL,PGMEND	;program end
	LD	(TEMP0),HL	;save start
	LD	HL,(TOPMEM)	;get topmem
	DEC	HL		;last real byte
	LD	(TEMP1),HL	;save end
	XOR	A		;load zero
	LD	(TEMP2),A	;set default fill byte
;
FILMEM1	RST	@08		;display prompt
;
	DEFB	EOL
	DEFM	'Start, End, Fill ? '
	DEFB	ETX
;
	LD	B,30		;30 char input
	RST	@10		;get from keyboard
	CALL	POSHL		;any input?
	JR	Z,FILLDEF	;nope, use defaults
;
;	get start address
;
	CALL	VALUE		;get numeric value
	JR	C,FILMEM1	;error, ask again
	LD	(TEMP0),BC	;save start
;
;	get end address
;
	CALL	POSHL		;any more input?
	JR	Z,FILLDEF	;nope, use defaults
	CALL	VALUE		;else get value
	JR	C,FILMEM1	;error, ask again
	LD	(TEMP1),BC	;else save end address
;
;	get fill byte from string
;
	CALL	POSHL		;any more input?
	JR	Z,FILLDEF	;nope, use default 00H
	CALL	VALUE		;else fetch value
	JR	C,FILMEM1	;invalid, ask again
	LD	A,C		;get LSB value
	LD	(TEMP2),A	;save it
;
FILLDEF	CALL	BYTECNT		;setup registers to go
	LD	D,H		;pass start to DE
	LD	E,L		;DE = HL = start address
	INC	DE		;start +1
	LD	A,(TEMP2)	;get fill byte
	PUSH	BC		;save count
	DEC	BC		;adjust to length -1
	LD	(HL),A		;load one byte
	PUSH	AF		;save fill byte
	LDIR			;load all bytes
	POP	AF		;get fill byte
	RST	@20		;to hex ascii
	LD	(FILM4),BC	;to the string
	POP	HL		;get length back
;
	PUSH	IY		;save DCT
	LD	IY,FILM3	;string pointer
	CALL	BINASC		;convert to decimal ascii
	POP	IY		;restore
;
	RST	@08		;display message
;
	DEFB	LF
FILM3	DEFM	'xxxxx bytes filled with '
FILM4	DEFM	'xxH'
	DEFB	ETX
;
	JP	GOBACK		;back to sub-menu
;
	PAGE
;
;	$COMMEM - compare memory entry point
;
COMMEM	CALL	INTCNT		;initialize counter
	CALL	GETSES		;start, end, start
	CALL	BYTECNT		;setup registers
;
COMMEML	LD	A,(DE)		;get source byte
	CP	(HL)		;same as dest?
	CALL	NZ,COMMEMB	;display address if bad
	INC	HL		;bump source
	INC	DE		;bump dest
	DEC	BC		;less this byte
	LD	A,B		;any more
	OR	C		;any bits on?
	JR	NZ,COMMEML	;continue through loop
;
	CALL	SHOCNT		;display counter
	RST	@08		;display message
;
	DEFM	'Non-Compares'
	DEFB	ETX
;
	JP	GOBACK		;back to sub-menu
;
;	mismatch - display addresses
;
COMMEMB	PUSH	BC		;save remaining count
	PUSH	HL		;save on stack
;
	LD	B,H		;pass HL to BC
	LD	C,L		;BC = address 1
	LD	HL,CMM1		;address #1
	CALL	PUTHEX		;insert hex ascii
;
	LD	B,D		;pass DE to BC
	LD	C,E		;BC = address 2
	LD	HL,CMM2		;string to hold it
	CALL	PUTHEX		;load hex ascii
;
	POP	HL		;unstack
	POP	BC		;all done
;
	RST	@08		;display message
;
	DEFB	LF
CMM1	DEFM	'xxxxH and '
CMM2	DEFM	'xxxxH DO NOT MATCH'
	DEFB	ETX
;
	CALL	ADDCNT		;bump counter
	JP	PAUSE		;check for pause
;
