; suinit/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
	PAGE
;
	SUBTTL	'<SUINIT/ASM - Program Initialization>'
;
ENTRY	DI			;disable interrupts
	IM	1		;interrupt mode 1
	LD	SP,STACK	;reset stack to top
;
	LD	HL,BUFFPRT	;get printer buffer
	LD	(PRBUFF),HL	;pass to data area
	LD	HL,MIDPNT	;get midpoint buffer
	LD	L,0		;set even page
	LD	(MIDMEM),HL	;save it
;
	CALL	INTFDC		;interrupt & clear FDC
;
;	clear cassette latch, reset drive 1
;
;i*
	IF	MODI
	XOR	A
	LD	(37E4H),A	;set cassette #1
	ENDIF
;i*
;
;iii*
	IF	MODIII
	XOR	A		;load zero
	OUT	(0E4H),A	;disable NMI's
	LD	A,4		;enable RTC
	OUT	(0E0H),A	;enabled
	LD	A,28H		;video flags
	OUT	(0ECH),A	;enabled
	ENDIF
;iii*
;
;	automatic doubler recognition for Mod I only
;
;i*
	IF	MODI
;
	LD	HL,37EDH	;FDC track register
	LD	DE,37ECH	;FDC command register
	LD	A,-1		;turn on double density
	LD	(DE),A		;select doubler
	LD	(HL),A		;give to track register
	LD	A,-2		;turn on single density
	LD	(DE),A		;select doubler
	XOR	A		;load zero
	LD	(HL),A		;into track register
;
	LD	A,-1		;back to double density
	LD	(DE),A		;to FDC
	LD	A,(HL)		;is it -1?
	INC	A		;FF?
	LD	B,00000100B	;percom doubler
	JR	Z,HAVDBLR	;have it, go!
;
;	check for radio shack doubler
;
	LD	DE,37EEH	;FDC sector register
	LD	A,80H		;select double density
	LD	(DE),A		;select doubler
	LD	A,-1		;load track register
	LD	(HL),A		;to track reg
	LD	A,0A0H		;select single density
	LD	(DE),A		;single on
	XOR	A		;load zero
	LD	(HL),A		;set track register
	LD	A,80H		;back to double den
	LD	(DE),A		;select it
	LD	A,(HL)		;get track register
	INC	A		;is it -1?
	LD	B,00000000B	;radio shack doubler
	JR	Z,HAVDBLR	;go if found
	LD	B,00010000B	;no doubler
;
HAVDBLR	LD	A,(FLAGB)	;get system flag
	AND	11101011B	;remove pertaining bits
	OR	B		;merge with new
	LD	(FLAGB),A	;update doubler flags
	CALL	RESFDC		;reset FDC
;
	ENDIF
;i*
;
;	fetch program serial # and load into I register
;
CLEARX	LD	HL,SERSAVE	;start of serial #
	LD	BC,1E00H	;length + checksum
;
CLEARY	LD	A,(HL)		;fetch a byte
	NEG			;two's complement
	ADD	A,C		;add to checksum
	LD	C,A		;update
	INC	HL		;bump pointer
	DJNZ	CLEARY		;go for length
	LD	I,A		;pass to I register
;
;	clear checksum instructions
;
	LD	B,$-CLEARX	;fetch length
	LD	HL,CLEARX	;start of code
	XOR	A		;load zero
	CALL	FILL		;clear it out
;
;	setup jumps in page 0 memory in case program
;	is running in pure RAM machine
;	if ROM is there, then no effect
;	else RST vectors will be established
;
	LD	HL,0008H	;first restart
	LD	DE,4000H	;restart jump table
	LD	B,7		;7 to do
;
RSTLP	LD	(HL),0C3H	;JP opcode
	INC	L		;bump table
;
	LD	(HL),E		;lsb address
	INC	L		;bump ram
	LD	(HL),D		;msb address
	INC	E		;bump by 3
	INC	E
	INC	E
;
	LD	A,L		;get LSB ram
	ADD	A,6		;remainder offset to next
	LD	L,A		;HL => next restart
	DJNZ	RSTLP		;go till done
;
	EI			;can enable now, all set
	LD	HL,MASTER	;program entry
	LD	(TEMP2),HL	;save it for vector
;
	XOR	A		;load zero
	CALL	SETDRV		;setup for I/O
	LD	A,(IY+6)	;get type
	LD	(TEMP0),A	;save it
	RES	7,(IY+6)	;set single density
	LD	A,(3880H)	;read keyboard
	AND	2		;bit 1 right shift?
;	CALL	Z,LOADCON	;load configuration
	LD	A,(3880H)	;read again
	AND	1		;bit 0 left shift?
;	CALL	Z,LOADPAT	;load patch data
;
	LD	A,(TEMP0)	;fetch dos type
	LD	(IY+6),A	;reset it
;
	CALL	TURNSPD		;set hispeed clock
	DI			;disable for display
	CALL	LOGO		;display logo
	EI			;enable now
	LD	HL,(TEMP2)	;get program vector
	JP	(HL)		;go entry!
;
LOADCON	LD	BC,BUFFER	;I/O buffer to use
	PUSH	BC		;save it
;i*
	IF	MODI
	LD	DE,0002H	;config I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	DE,0003H	;config III
	ENDIF
;iii*
;
	CALL	READ		;read it
	POP	HL		;HL => data
	RET	NZ		;error, skip it
;
;	check for header in sector
;
	LD	DE,HEADCON	;header for config
	LD	B,HEADCOL	;length of header
	CALL	COMPARE		;match?
	RET	NZ		;nope, not valid sector
;
;	load data
;
	LD	A,(HL)		;get flag A
	INC	HL		;bump pointer
	LD	(FLAGA),A	;save flag A
	LD	A,(HL)		;get flag B
	INC	HL		;bump pointer
	LD	(FLAGB),A	;save flag B
	LD	DE,DCT0		;DCT table
	LD	BC,88		;length
	LDIR			;move it in
	LD	DE,SPDOFF	;speed off table
	LD	BC,18		;length
	LDIR			;pass it
	LD	A,(IY+6)	;get new configuration
	LD	(TEMP0),A	;pass for reset
	RES	7,(IY+6)	;re-set single density
	XOR	A		;return Z
	RET			;done!
;
;	read patch information from disk
;
LOADPAT	EQU	$		;read patch
;
;i*
	IF	MODI
	LD	DE,0004H	;patch I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	DE,0007H	;patch III
	ENDIF
;iii*
;
	LD	L,-1		;pointer to data
	LD	B,4		;max patch sectors+1
	EXX			;save here
;
PATLP	CALL	PAT1B		;get a byte
	OR	A		;terminator?
	RET	Z		;yes, done!
	DEC	A		;1 loader?
	JR	Z,PAT1		;yes, go!
	DEC	A		;2 entry?
	JR	Z,PAT2		;yes, go!
	CP	1EH		;1-1FH?
	RET	NC		;nope, error, return!
;
;	remove remark block
;
	CALL	PAT1B		;get a byte
	LD	B,A		;pass length
PATREM	CALL	PAT1B		;get a byte
	DJNZ	PATREM		;finish remark
	JR	PATLP		;go next block
;
;	load block
;
PAT1	CALL	PATLD		;get load address
;
PAT1L	CALL	PAT1B		;get a byte
	LD	(HL),A		;to buffer
	INC	HL		;bump buffer
	DJNZ	PAT1L		;go for block length
	JR	PATLP		;go next block
;
;	entry block
;
PAT2	CALL	PATLD		;get load address
	LD	(TEMP2),HL	;save vector
	RET			;done!
;
;	fetch load address
;
PATLD	CALL	PAT1B		;get a byte
	SUB	2		;less 2
	LD	B,A		;pass length
	CALL	PAT1B		;get LSB address
	LD	L,A		;pass it
	CALL	PAT1B		;get MSB address
	LD	H,A		;HL = address
	RET			;done!
;
;	fetch 1 byte from patch file
;
PAT1B	EXX			;swap registers
	INC	L		;bump buffer
	JR	NZ,PAT1H	;have it, go!
;
	PUSH	BC		;save count
	LD	BC,BUFFER	;I/O buffer
	PUSH	BC		;save on stack
	CALL	READ		;read the sector
	POP	HL		;restore buffer
	POP	BC		;restore BC
	JR	NZ,PATCAN	;abort if error!
	DEC	B		;less this sector
	JR	Z,PATCAN	;too many!
	INC	E		;bump sector
;
PAT1H	LD	A,(HL)		;get buffer byte
	EXX			;swap back
	RET			;done, A = byte
;
PATCAN	POP	HL		;unstack caller address
	RET			;done!
;
