; suformd/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
	PAGE
;
	SUBTTL	'<SUFORMD/ASM - Format section D>'
;
;
;	special disk format entry point
;
UFMT	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
;	fetch track count
;
UFT0	RST	@08		;display prompt
;
	DEFB	EOL
	DEFM	'Tracks ? '
	DEFB	ETX
;
	LD	B,20		;input length
	RST	@10		;fetch from keyboard
	CALL	POSHL		;position to input
	JR	Z,UFT0		;no defaults here!
;
	CALL	VALUE		;fetch input value
	JR	C,UFT0		;go if invalid
	LD	A,C		;fetch input
	LD	(TEMP0),A	;save track count
	LD	IX,DAMBUFF	;use this buffer
	XOR	A		;load zero
	LD	(TEMP1),A	;set current track
;
;	looper to fetch sector definitions
;
UFT2	XOR	A		;load zero
	LD	(TEMP2),A	;clear DD flag
	LD	(IX+0),A	;0 single den this track
	LD	(IX+1),A	;0 double den this track
	PUSH	IX		;pass to IY
	POP	IY		;IY => current table
	INC	IY		;bump past length bytes
	INC	IY		;2 bytes long
;
UFT3	LD	A,(TEMP1)	;fetch current track
	RST	@18		;to decimal ascii
	LD	(UFTT),A	;to the string
	LD	(UFTT+1),BC	;rest of it
	LD	A,(IX)		;get # sectors single den
	RST	@18		;to decimal ascii
	LD	(UFSS),A	;to the string
	LD	(UFSS+1),BC	;rest of it
	LD	A,(IX+1)	;get # sectors double den
	RST	@18		;to decimal ascii
	LD	(UFSD),A	;to the string
	LD	(UFSD+1),BC	;rest
	LD	BC,3A20H	;colon / space
	LD	A,(TEMP2)	;get flag
	OR	A		;entering single den?
	JR	Z,$+5		;go if yes
	LD	BC,203AH	;reverse flags
	LD	A,B		;get SD flag
	LD	(UFSSF),A	;to the string
	LD	A,C		;get DD flag
	LD	(UFSDF),A	;to the string
;
	RST	@08		;display message
;
	DEFB	LF
	DEFM	'Track '
UFTT	DEFM	'xxx, '
UFSSF	DEFM	'xSingle '
UFSS	DEFM	'xxx, '
UFSDF	DEFM	'xDouble '
UFSD	DEFM	'xxx'
	DEFB	LF
	DEFM	':'		;prompt char
	DEFB	ETX
;
	LD	B,58		;input length
	RST	@10		;fetch from keyboard
	CALL	POSHL		;position to input
	JP	Z,UFTNT		;nothing input, adv trak
;
;	setup defaults
;
	LD	A,(TEMP1)	;get track
	LD	(IY+0),A	;set current track
	LD	(IY+1),0	;set head 0
	LD	(IY+2),0	;set sector 0
	LD	(IY+3),1	;set length 1
	LD	A,(TEMP2)	;get flag
	LD	(IY+6),A	;simulate DCT density
	CALL	FIXSET		;load B with IBM flag
	RRCA			;move 1 bit in
	AND	4		;save bit 2 only
	LD	(IY+4),A	;save as default
;
UPARSE	CALL	POSHL		;position to input
	JP	Z,UFTNS		;next sector
	LD	DE,UPARSE	;return vector
	PUSH	DE		;leave on stack
	LD	DE,UFTBL	;valid command table
	INC	HL		;bump to next char
	CALL	GOTABL		;go jump vector
;
UFTINV	RST	@08		;unrecognized command
;
	DEFB	LF
	DEFM	'Invalid Command Line'
	DEFB	ETX
;
	POP	DE		;remove vector
	JP	UFT3		;ask again
;
UFTBL	DEFB	'R'		;random?
	DEFW	UFRAND
	DEFB	'T'		;track?
	DEFW	UFTRAK
	DEFB	'H'		;head?
	DEFW	UFHEAD
	DEFB	'S'		;sector?
	DEFW	UFSECT
	DEFB	'L'		;length?
	DEFW	UFLENG
	DEFB	'I'		;ibm flag?
	DEFW	UFIBM
	DEFB	'N'		;non-ibm flag?
	DEFW	UFNONI
	DEFB	'C'		;crc generator?
	DEFW	UFCRC
	DEFB	'A'		;address mark?
	DEFW	UFADDR
	DEFB	'D'		;double density?
	DEFW	UFDEN
	DEFB	ETBL
;
;	enter track number
;
UFTRAK	XOR	A		;table offset
	JR	UFCMM		;go common
;
;	enter head number
;
UFHEAD	LD	A,1		;table offset
	JR	UFCMM		;go common
;
;	enter sector number
;
UFSECT	LD	A,2		;table offset
	JR	UFCMM		;go common
;
;	enter sector length
;
UFLENG	LD	A,3		;table offset
;
UFCMM	LD	(UFCMX),A	;save offset
	LD	A,(HL)		;fetch next char
	CALL	UCASE		;make upper case
	CP	'R'		;random?
	JR	Z,UFCRND	;yes, go!
	CALL	VALUE		;fetch input value
	JR	C,UFTINV	;invalid command!
	JR	UFCPUT		;load into table
UFCRND	CALL	RANDOM		;generate 'random' numb.
	INC	HL		;bump pointer
UFCPUT	LD	(IY+'$'),A	;load into table
UFCMX	EQU	$-1		;loaded above
	RET			;done, loaded!
;
;	enter IBM flag
;
UFIBM	LD	A,(TEMP2)	;get density flag
	LD	(IY+6),A	;setup dummy DCT
	CALL	FIXSET		;compute IBM mark
	LD	A,(IY+4)	;get current setting
	RES	2,A		;turn off IBM flag
	SRL	B		;align bit
	OR	B		;combine it
	LD	(IY+4),A	;back to table
	INC	HL		;bump input pointer
	RET			;to next command
;
;	enter NON-IBM flag
;
UFNONI	LD	A,(TEMP2)	;get density flag
	LD	(IY+6),A	;setup dummy DCT
	CALL	FIXSET		;compute IBM mark
	LD	A,(IY+4)	;get current setting
	RES	2,A		;turn off current flag
	SRL	B		;align mask bit
	XOR	B		;reverse it if set
	LD	(IY+4),A	;update flags
	INC	HL		;bump input pointer
	RET			;go next command
;
;	enter CRC type
;
UFCRC	LD	A,(HL)		;get input
	INC	HL		;bump input pointer
	SUB	'0'		;remove ascii
	JP	C,UFTINV	;invalid
	CP	4		;0-3?
	JP	NC,UFTINV	;invalid!
	ADD	A,A		;align bits 0-1
	ADD	A,A		;to bits 3-4
	ADD	A,A		;shift left 3 times
	RES	4,(IY+4)	;reset current flags
	RES	3,(IY+4)
	OR	(IY+4)		;combine bits
	LD	(IY+4),A	;update flags
	RET			;to next command
;
;	fetch address mark type
;
UFADDR	LD	A,(HL)		;fetch mark
	INC	HL		;bump pointer
	CALL	UCASE		;make upper case
	LD	B,0		;standard?
	CP	'S'
	JR	Z,UFADDS	;yes, go!
	INC	B		;read protect?
	CP	'R'
	JR	Z,UFADDS	;go if yes
	INC	B		;deleted data?
	CP	'D'
	JR	Z,UFADDS	;go if yes
	INC	B		;user defined?
	CP	'U'
	JP	NZ,UFTINV	;go if non of above!
;
UFADDS	PUSH	BC		;save B flag
	LD	A,(TEMP2)	;get density flags
	LD	(IY+6),A	;setup dummy DCT density
	CALL	FIXSET		;compute valid dam's
	POP	AF		;fetch user flags
	AND	C		;force into range!
	RES	1,(IY+4)	;turn off current flags
	RES	0,(IY+4)
	OR	(IY+4)		;combine bits
	LD	(IY+4),A	;update table
	RET			;done!
;
;	fetch sector density
;
UFDEN	LD	A,-1		;set all bits
	LD	(TEMP2),A	;set double density now
	RET			;done!
;
;	generate random information
;
UFRAND	PUSH	HL		;save input pointer
	LD	HL,TEMP4	;use temp storage
	LD	(HL),'R'	;setup for calls
	PUSH	HL		;save pointer
	CALL	UFTRAK		;random track
	POP	HL		;restore
;
	PUSH	HL		;save
	CALL	UFHEAD		;random head
	POP	HL		;restore
;
	PUSH	HL		;save
	CALL	UFSECT		;random sector
	POP	HL		;restore
;
	CALL	UFLENG		;random length
	POP	HL		;restore input pointer
	RET			;done
;
;	track completed, advance table and track
;
UFTNT	CALL	UCTBL		;move IX to next track
	LD	A,(TEMP1)	;fetch current track
	INC	A		;+1
	LD	(TEMP1),A	;re-save it
	LD	B,A		;save here
	LD	A,(TEMP0)	;fetch track count
	CP	B		;at end?
	JP	NZ,UFT2		;next track loop
;
;	all information entered, table created
;	setup params for special formatter
;
	PUSH	IX		;pass table end to DE
	POP	DE		;DE => end of table +1
	LD	A,-1		;set flag
	LD	(SDRIVE),A	;disable prompting
	JP	UTFMT		;go formatter!
;
;	sector entered, log information into table
;
UFTNS	LD	A,(TEMP2)	;get density flag
	OR	A		;single density?
	JR	NZ,UFTNS1	;go if not
	INC	(IX+0)		;bump single den count
	JR	UFTNS2		;continue
UFTNS1	INC	(IX+1)		;bump double den count
UFTNS2	LD	BC,5		;length of each entry
	ADD	IY,BC		;IY => next sector data
	JP	UFT3		;get next data line
;
;	generate pseudo 'random' number
;
RANDOM	LD	A,R		;get initial 'seed'
	XOR	37H
RAND1	EQU	$-1
	LD	(RAND3),A	;re-seed
	RRCA
	RRCA
	XOR	2FH
RAND2	EQU	$-1
	LD	(RAND1),A	;re-seed
	RLA
	XOR	77H
RAND3	EQU	$-1
	LD	(RAND2),A	;re-seed
	RET
;
