; sufileb/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
	PAGE
;
	SUBTTL	'<SUFILEB/ASM - Files Section B>'
;
;	$DISFILE - display file entry point
;
DFILCNX	RST	@08		;clear screen
;
	DEFB	CLSF		;with frame
	DEFB	ETX
;
	JP	DFILCON		;continue
;
DISFILE	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	A,3		;save type of modify
	LD	(TYPE),A	;store it
	LD	A,-1		;allow Mod III sys files
	LD	(MOD3FIL),A	;as valid filespec
;
;	setup vectors for modify mode
;
	LD	HL,TRIFLWR	;write sector
	LD	(VECTOR1),HL	;save for UPDATE
	LD	HL,FFILCON	;read sector
	LD	(VECTOR2),HL	;save for CANCEL
	LD	HL,DFILWTX	;re-display left side
	LD	(VECTOR3),HL	;for base change
;
DISFIL1	CALL	ASKFILE		;get filespec
	LD	(IXSAVX),IX	;save pointer in memory
	LD	(TEMP4),IY	;save DCT
	JR	DFILCON		;continue
;
;	invalid filespec encountered
;
BADFILE	RST	@08		;display message
;
	DEFB	EOL
	DEFM	'Invalid Filespec'
	DEFB	LF
	DEFB	ETX
;
	RET			;return with flags
;
;	file not found
;
NOFILE	RST	@08		;display message
;
	DEFB	EOL
	DEFM	'File NOT FOUND'
	DEFB	LF
	DEFB	ETX
;
	RET			;return with flags
;
;	compute length of file, fetch relative sector
;
TRIFLWR	LD	DE,(SECTOR)	;get track/sector
	LD	BC,(ADDRESS)	;data buffer
	LD	IY,(TEMP4)	;get DCT
	CALL	DSTAT		;drive is ready?
	JP	NZ,SUBMENU	;abort!
	CALL	WRITE		;write the sector
	CALL	NZ,BDWTCLS	;error monitor if bad
	JR	NZ,TRIFLWR	;try again (RETRY)
	JR	FFILCON		;continue
;
DFILCON	LD	DE,FILBUFF	;start of filenames
	LD	IX,0		;get pointer to file
IXSAVX	EQU	$-2
	LD	IY,(TEMP4)	;get DCT pointer
	CALL	RELSEC		;fetch rel sector
FFILCON	RST	@08		;clear screen
;
	DEFB	CLSA
	DEFB	ETX
;
FILECT	LD	DE,FILBUFF	;start of filespecs
	LD	IX,(IXSAVX)	;start of this file
	LD	IY,(TEMP4)	;get DCT address
	CALL	POSIT		;position DE to record
	JP	C,OUTRNG	;sector out of range!
;
	LD	BC,BUFFER	;read sector here
	LD	(ADDRESS),BC	;save modify address
	LD	(SECTOR),DE	;save track/sector
;
TRIFLRD	CALL	READ		;read the sector
	CALL	NZ,BDRDCLS	;error monitor if bad
	JR	NZ,TRIFLRD	;go if retry to read
;
DFILELP	CALL	SHOW		;show hex/ascii data
;
DFILWTX	CALL	SHOWLF		;display data source
	CALL	SHOWFL		;display current filespec
;
DFILEWT	LD	A,12		;flash counter
	LD	BC,20B0H	;on/off characters
	LD	HL,VIDEO	;where to flash it
	CALL	FLICKS		;wait for a key
;
;	display char on video
;
	PUSH	AF		;save char
	CALL	UCASE		;make upper case
	CP	SPACE		;displayable?
	JR	NC,PTFWV	;yes, put on video
	LD	A,8FH		;else use this
PTFWV	LD	(VIDEO),A	;to video
	POP	AF		;A = input char
;
DIFFLWT	LD	DE,DISFLTB	;'paging' mode table
	LD	HL,(TEMP9)	;get curr rel sector
;
;	clear key and ETBL are same, special check
;
	CP	CLEAR		;clear key?
	JP	Z,DFILCNX	;yes, new relative sec
;
	CALL	GOTABL		;go vector if valid
	JR	DFILEWT		;else wait some more
;
	PAGE
;
;	$SHOWFL - display filespec in paging mode
;
SHOWFL	LD	DE,FILEDCB	;filespec here
	LD	HL,VIDEO+4	;start it here
	LD	BC,40H		;offset between lines
	LD	A,8		;8 chars in name
;
SHOWFL1	PUSH	AF		;save count
	LD	A,(DE)		;fetch name byte
	INC	DE		;bump pointer
	CP	SPACE		;nil?
	JR	Z,SHOWFL2	;yes, skip it
	LD	(HL),A		;to video
	ADD	HL,BC		;next row
;
SHOWFL2	POP	AF		;restore counter
	DEC	A		;less this byte
	JR	NZ,SHOWFL1	;go till done with name
;
	LD	A,(DE)		;get next byte
	CP	SPACE		;any extension?
	JR	Z,SHOWFL5	;nope, go!
	LD	(HL),'/'	;extension to video
	ADD	HL,BC		;next row
	LD	A,3		;3 bytes in extension
;
SHOWFL3	PUSH	AF		;save count
	LD	A,(DE)		;get a byte
	INC	DE		;bump pointer
	CP	SPACE		;blank?
	JR	Z,SHOWFL4	;yes, go!
	LD	(HL),A		;to video
	ADD	HL,BC		;next row on video
;
SHOWFL4	POP	AF		;restore count
	DEC	A		;less this byte
	JR	NZ,SHOWFL3	;go for all 3
;
;	display current relative sector
;
SHOWFL5	LD	HL,(TEMP9)	;get relative sector
;
	PUSH	IY		;save DCT pointer
	LD	IY,VIDEO+895	;where to load on video
	LD	A,(IY)		;fetch char from video
	PUSH	AF		;on stack
	CALL	BINASC		;load relative byte
	POP	AF		;restore video byte
	LD	(VIDEO+895),A	;re-install it
	POP	IY		;restore stack
;
;	install header
;
	LD	HL,VIDEO+832	;video pointer
	LD	(HL),'R'
	INC	HL
	LD	(HL),'S'
	INC	HL
	LD	(HL),'E'
	INC	HL
	LD	(HL),'C'
;
;	check if in FPDE or FXDE this displayed sector
;
	LD	A,(TEMP8)	;get flag
	DEC	A		;1 = primary
	LD	A,'P'		;load ascii
	JR	Z,TT88		;go if primary
	LD	A,'X'		;else extended
TT88	LD	HL,VIDEO+768	;where it goes
	LD	(HL),'F'	;insert reset
	INC	HL
	LD	(HL),A		;X or P
	INC	HL
	LD	(HL),'D'
	INC	HL
	LD	(HL),'E'
;
;	get current relative sector
;
	LD	HL,(TEMP9)	;current sector
	LD	BC,(EOFS)	;end of file sector
	OR	A		;clear carry
	SBC	HL,BC		;compare
	LD	BC,2020H	;space space
	JR	Z,AEOFS		;go if AT end of file
	JR	C,B4E0FS	;before EOF sector
;
;	beyond end of file sector
;
	LD	A,'+'		;beyond EOF
	JR	PUTEOFS		;go common
;
;	before end of file sector
;
B4E0FS	LD	A,'-'		;before end
	JR	PUTEOFS		;go common
;
;	at end of file sector
;
AEOFS	LD	A,(EOFB)	;end of file byte
	RST	@20		;to hex ascii
	LD	A,'@'		;load AT symbol
;
PUTEOFS	LD	DE,40H		;row offset
	LD	HL,VIDEO+768+4	;where on video it goes
	LD	(HL),C		;relative MSB ascii
	ADD	HL,DE
	LD	(HL),B		;relative LSB ascii
	ADD	HL,DE
	ADD	HL,DE
	LD	(HL),A		;@ sign to display
	RET			;done!
;
	PAGE
;
;	$DISFLTB - lookup table for paging mode
;		   of display file sectors
;
DISFLTB	DEFB	RARR		;right arrow
	DEFW	UPFILE		;advance rel sec
;
	DEFB	UARR		;up arrow
	DEFW	UPFILE		;advance rel sec
;
	DEFB	LARR		;left arrow
	DEFW	DOWNFIL		;decrement rel sec
;
	DEFB	DARR		;down arrow
	DEFW	DOWNFIL		;decrement rel sec
;
	DEFB	'E'		;EOF sector
	DEFW	ENDFILE
	DEFB	'A'		;ASCII modify
	DEFW	ASCIT
;
	DEFB	'B'		;BINARY modify
	DEFW	BINIT
;
	DEFB	'H'		;HEX modify
	DEFW	HEXIT
;
	DEFB	'O'		;OCTAL modify
	DEFW	OCTIT
	DEFB	'Q'
	DEFW	OCTIT
;
	DEFB	'D'		;DECIMAL modify
	DEFW	DECIT
;
	DEFB	SLARR		;sh left arrow
	DEFW	BOTOFIL		;rel sector 0
;
	DEFB	SRARR		;sh right arrow
	DEFW	TOPOFIL		;EOF sector
;
	DEFB	SUARR		;sh up arrow
	DEFW	TOPOFIL		;EOF sector
;
	DEFB	SDARR		;sh down arrow
	DEFW	BOTOFIL		;rel sector 0
;
	DEFB	'F'		;EOA sector
	DEFW	ALLOCFI
;
	DEFB	'M'		;modify mode
	DEFW	MODIFY
;
	DEFB	'@'		;decrypt mode
	DEFW	DECODE
;
	DEFB	ETBL		;end of table
;
;	file paging mode commands
;	HL = current relative sector
;
UPFILE	INC	HL		;bump rel sector
	JR	FPCRET		;paging return common
;
DOWNFIL	LD	A,H		;at rel 0 now?
	OR	L		;any bits on?
	JP	Z,DFILEWT	;nope, can't dec it
	DEC	HL		;else OK to do it
	JR	FPCRET		;else go common
;
ENDFILE	LD	HL,(EOFS)	;get end of file sector
	JR	FPCRET		;go common
;
ALLOCFI	LD	HL,(EOAS)	;end of allocation
	JR	FPCRET		;continue
;
TOPOFIL	LD	HL,(EOAS)	;end of file sector
	JR	FPCRET		;go common
;
BOTOFIL	LD	HL,0		;rel sector zero
;
FPCRET	LD	(TEMP9),HL	;save new rel sector
	JP	FILECT		;do new sector
;
	PAGE
;
;	$OUTRNG - sector attempt beyond file limits
;
OUTRNG	RST	@08		;display message
;
	DEFB	CLSF		;clear screen
	DEFM	'Sector OUT OF RANGE'
	DEFB	ETX
;
	CALL	POSSHOW		;show EOA/EOF sectors
	LD	HL,(TEMP9)	;get current sector
;
	PUSH	IY		;save DCT
	LD	IY,RNG		;string pointer
	CALL	BINASC		;convert to decimal ascii
	POP	IY		;restore IY
;
	RST	@08		;display message
;
	DEFB	LF
	DEFM	'Positioned to Relative Sector '
RNG	DEFM	'xxxxx   '
	DEFB	ETX
;
;	wait for a key, then continue
;
	LD	A,12		;flash counter
	LD	BC,20B0H	;on/off graphics
	LD	HL,VIDEO	;where to flash
	CALL	FLICKS		;wait for a key
	RST	@08		;clear screen
;
	DEFB	CLSA		;clear entire
	DEFB	ETX
;
	JP	DIFFLWT		;interpret key
;
	PAGE
;
;	$CKASCI - check for valid filespec char
;
CKASCI	CP	20H		;control code?
	RET	C		;invalid already
	PUSH	BC		;save BC
	PUSH	HL		;and HL
	LD	HL,INVTBL	;invalid char table
	LD	BC,14		;14 chars to check
	OR	A		;clear carry flag
	CPIR			;compare to table
	POP	HL		;unstack
	POP	BC		;BC & HL original
	RET	NZ		;OK, return NC
	SCF			;else set for error
	RET			;C = invalid char
;
;	invalid chars for filespec
;
INVTBL	DEFM	'('
	DEFM	')'
	DEFM	','
	DEFM	'.'
	DEFM	'/'
	DEFM	';'
	DEFM	' '
	DEFM	':'
	DEFM	'@'
	DEFM	'='
	DEFM	'"'
	DEFB	27H
	DEFB	03H
	DEFB	0DH
;
	PAGE
;
;	$MOVFILE - 'crack' filespec and check valid
;
MOVFILE	PUSH	HL		;save input pointer
	LD	HL,PASSWRD	;password storage
	LD	B,8		;8 chars in password
	LD	A,SPACE		;spaces
	CALL	FILL		;fill it
	LD	HL,FILEDCB	;filespec storage
	LD	B,12		;12 long
	CALL	FILL		;fill with spaces too
	POP	HL		;restore input pointer
	XOR	A		;allow drive scan
	LD	(SCANFLG),A	;save it
	CALL	SETDRV		;use 0 as default drive
;
	LD	DE,FILEDCB	;place filespec here
;
	DEC	HL		;adjust field
	CALL	MOVBLK8		;move 8 bytes
	RET	C		;error!
;
	CP	'/'		;extension?
	JR	NZ,FSPEC1	;nope, check password
	LD	DE,FILEDCB+8	;point to extension
	LD	B,3		;3 char extension
	CALL	MOVBLK-1	;move it in
	RET	C		;error!
;
FSPEC1	CP	'.'		;password?
	JR	NZ,FSPEC2	;nope, continue
	LD	DE,PASSWRD	;string to hold it
	CALL	MOVBLK8		;move it in
	RET	C		;error, return
;
FSPEC2	CP	':'		;drive?
	JR	NZ,FSPEC3	;go if not
	LD	A,-1		;set true
	LD	(SCANFLG),A	;search one drive only
	INC	HL		;bump past ':'
	JP	FIGDRV		;compute drive & return
;
FSPEC3	CP	CR		;terminator?
	RET	Z		;yes, return Z
	SCF			;else error
	RET			;back with it
;
;	extract filespec field
;
MOVBLK8	LD	B,8		;8 chars to do
;
	INC	HL		;bump to next field
MOVBLK	SCF			;set error
	EX	AF,AF'		;save flag
;
MOVBLK1	LD	A,(HL)		;get a byte
	CALL	CKASCI		;valid?
	JR	C,MOVBLK5	;go if bad
;
	INC	HL		;bump pointer
	CALL	UCASE		;make upper case
	LD	(DE),A		;put in buffer
	INC	DE		;bump pointer
	XOR	A		;set no error
	EX	AF,AF'		;no carry in AF'
	DJNZ	MOVBLK1		;finish the block
;
MOVBLK5	EX	AF,AF'		;get flags
	LD	A,(HL)		;but return with char
	RET			;back to caller
;
	PAGE
;
;	$FNDFILE - locate filespec on disk
;
FNDFILE	CALL	STAT		;check drive status
	JP	NZ,FNDFIL3	;go if not ready
	CALL	RDDIR		;read the directory
	JP	NZ,FNDFIL3	;go if can't read it
;
	CALL	FIGTKS		;compute track count
	LD	A,(MOD3FIL)	;see if *xx filespecs
	OR	A		;Z = no
	JP	Z,FNDFIL0	;can't, continue
;
;	since TRSDOS I/III DD system files are not
;	encoded in the directory entries, we will
;	allow the form *xx, where xx = the numeric
;	value of the relative system file (from 0).
;	this will only be allowed in display files
;
	LD	A,(IY+7)	;get dos type
	CP	02		;I dd?
	JP	C,FNDFIL0	;nope, go!
	CP	04		;III dd?
	JP	NC,FNDFIL0	;go if neither
;
	LD	A,(FILEDCB)	;get first byte of DCB
	CP	'*'		;was '*' issued?
	JP	NZ,FNDFIL0	;nope, go!
;
;	* type issued, build a dummy directory record
;	  for file positioning purposes
;
	LD	HL,FILBUFF	;use first file area
	LD	B,48		;in case of Mod III
	XOR	A		;fill with zeroes
	CALL	FILL		;fill it up
;
;	use temporary storage to compute system number
;
	LD	HL,(FILEDCB+1)	;get ascii value
	LD	(TEMP0),HL	;save in temp storage
	LD	HL,TEMP0	;point to it
	LD	A,CR		;insert CR at end
	LD	(TEMP1),A	;into following byte
	CALL	VALUE		;fetch numeric value
	RET	C		;error! return
;
	LD	B,0		;load MSB with zero
	SLA	C		;double the LSB
	LD	HL,HITBUFF+0D0H	;start for Mod I DD
	LD	A,(IY+7)	;get dos type
	CP	02		;trsdos I dd?
	JR	Z,HVHTO		;have hit offset, go!
	LD	L,0E0H		;else adjust for III
HVHTO	ADD	HL,BC		;HL => two byte descript
	LD	IX,FILBUFF	;point to entry
	LD	A,(HL)		;get gran offset/#grans
	CALL	TSYSFIX		;adjust for Mod I DD
	LD	(IX+23),A	;to dummy FCB
	INC	L		;bump data pointer
	LD	A,(HL)		;fetch next byte
	LD	(IX+22),A	;start track to dummy fcb
	LD	(IX+24),-1	;insert extent terminator
	SET	4,(IX)		;set as active file
;
	PUSH	HL		;save entry start
	LD	HL,FILEDCB	;stored filespec
	LD	DE,FILBUFF+5	;move ascii here
	LD	BC,11		;8 name + 3 extension
	LDIR			;move for $SHOWFL
	XOR	A		;set end of file byte
	LD	(EOFB),A	;save it
	LD	A,(IX+23)	;get extent element
	AND	1FH		;low 5 bits only
	LD	HL,0		;start with zero
	JR	Z,GOXEOF	;nil file, go!
	LD	B,A		;pass # grans contiguous
	LD	DE,3		;# sectors / gran
;
GOZEOF	ADD	HL,DE		;count this gran
	DJNZ	GOZEOF		;go for # grans
;
GOXEOF	LD	(EOFS),HL	;save end of file sector
	POP	HL		;restore pointer
	LD	A,(IY+7)	;get dos type
	CP	03		;trsdos III dd?
	JR	Z,GOYEOF	;go if yes
	DEC	L		;point back
	LD	A,(HL)		;get length byte
	LD	(EOFS),A	;save as end of file
	XOR	A		;load zero
	LD	(EOFS+1),A	;save MSB
;
GOYEOF	LD	A,(IX+22)	;get primary extent
	INC	A		;nil system file?
	SCF			;carry = nil
	RET	Z		;return if nil system
	XOR	A		;else set as OK
	RET			;return
;
;	normal file, locate string in directory
;
FNDFIL0	CALL	ENTRIES		;get # dir records
;
FNDFIL1	LD	IX,FILBUFF	;start of records
;
FDFILE1	BIT	4,(IX)		;active entry?
	JR	NZ,FNDFIL2	;yes, check it out!
;
FNDFIL4	CALL	IXDIR		;move IX to next enry
	DEC	E		;less this record
	JR	NZ,FDFILE1	;go if more to do
;
;	not found on this drive, see if global allowed
;
FNDFIL3	LD	A,(SCANFLG)	;get scan flag
	OR	A		;zero?
	SCF
	RET	NZ		;one drive only allowed!
;
	LD	A,(DRIV)	;get current drive
	INC	A		;+1
	PUSH	BC		;save
	LD	BC,(DRIVES)	;C = # drives
	CP	C		;all done?
	POP	BC		;restore
	CCF			;reverse carry flag
	RET	C		;return error if yes
	CALL	SETDRV		;else setup for I/O
	JP	FNDFILE		;try next drive
;
;	active file found, check if match
;
FNDFIL2	BIT	7,(IX)		;extension?
	JR	NZ,FNDFIL4	;yes, don't try it
;
	PUSH	IX		;pass IX to HL
	POP	HL		;HL => record start
	LD	BC,5		;offset to name
	ADD	HL,BC		;HL => name in directory
;
	PUSH	DE		;save counter
	LD	DE,FILEDCB	;point to requested name
	LD	B,11		;11 chars to check
	CALL	COMPARE		;got it?
	POP	DE		;restore counter
;
	JR	NZ,FNDFIL4	;nope, continue checking
;
	LD	A,(IX+3)	;get end of file byte
	LD	(EOFB),A	;save it
	LD	L,(IX+20)	;get end of file sector
	LD	H,(IX+21)	;HL = EOFS
	LD	(EOFS),HL	;save it
	OR	A		;end of file byte = 0?
	RET	Z		;yes, return
;
	DEC	HL		;correct end of file
	LD	(EOFS),HL	;re-save it
	RET			;done!
;
	PAGE
;
;	$RELSEC - fetch relative sector from user
;
RELSEC	LD	BC,(EOFS)	;get end of file sector
;
;	check for nil file
;
	LD	A,B		;get MSB
	OR	C		;any bits on?
	JR	Z,POSYYY+1	;go if nil
	DEC	BC		;else adjust to relative
;
;	locate the end of allocation sector
;
POSXXX	PUSH	DE		;save counter
	LD	DE,FILBUFF	;start of files
	CALL	POSITBC		;position to BC
	POP	DE		;restore DE
;
	JR	C,POSYYY	;have it, go!
	INC	BC		;else bump sector
	JR	POSXXX		;try next one
;
;	have relative end of allocation sector in BC
;
POSYYY	DEC	BC		;adjust to last real
	LD	(EOAS),BC	;save end of allocation
	CALL	POSSHOW		;display data
	JR	POCONT		;continue
;
;	display relative EOAS and EOFS sectors
;
POSSHOW	LD	HL,(EOAS)	;end of allocation sector
;
	PUSH	IY		;save IY from use
	LD	IY,RESA		;point to text
	CALL	BINASC		;convert to decimal ascii
	LD	HL,(EOFS)	;end of file sector
	LD	IY,RESB		;point to text
	CALL	BINASC		;convert decimal ascii
	POP	IY		;restore DCT
;
RSSSST	RST	@08		;display data
;
	DEFB	LF
	DEFM	'EOA Sector = '
RESA	DEFM	'xxxxx, EOF Sector = '
RESB	DEFM	'xxxxx'
	DEFB	ETX
;
	RET
;
RSSSS	CALL	RSSSST		;redisplay if error
;
POCONT	RST	@08		;display prompt
;
	DEFM	'  Choice ? '
	DEFB	ETX
;
	LD	B,10		;10 char input
	RST	@10		;get from keyboard
	JR	Z,POSNOPE	;go if nil input (0000H)
	DEC	B		;only one char input?
	JR	NZ,GEODE	;nope, fetch value
;
;	check for special commands
;
	CALL	UCASE		;make char upper case
	CP	'E'		;end of file sector?
	JR	Z,GOEOFS	;yes, go EOFS
	CP	'A'		;end of allocation sector
	JR	Z,GOEOAS	;yes, go!
	CP	'L'		;last sector?
	JR	Z,GEOLAST	;yes, go!
;
GEODE	CALL	VALUE		;fetch value from string
	JR	C,RSSSS		;invalid, re-prompt
;
GOEO	LD	(TEMP9),BC	;save relative sector
;
GEOLAST	OR	A		;clear carry flag
	RET
;
POSNOPE	LD	BC,0		;set as sector 0
	JR	GOEO		;continue
;
GOEOFS	LD	BC,(EOFS)	;end of file sect
	JR	GOEO		;go common
;
GOEOAS	LD	BC,(EOAS)	;end of allocation sect
	JR	GOEO		;go common
;
	PAGE
;
;	$POSIT - $POSITBC - file positioning
;
POSIT	LD	BC,(TEMP9)	;get position from data
;
POSITBC	LD	(PUTADE),DE	;save offset for extents
;
	PUSH	IX		;save IX
	PUSH	BC		;save BC on stack
	INC	BC		;adjust for positioning
	LD	A,1		;setup primary FPDE
	LD	(TEMP8),A	;save it
	CALL	POSIT0		;position to BC
	POP	BC		;restore it
	POP	IX		;restore IX
	RET			;DE = track/sector
;
;	position file via extent elements
;
POSIT0	LD	A,(IX+22)	;get start track
	CP	-1		;terminator?
	SCF			;carry = end of file
	RET	Z		;yes, out of range!
;
	CP	-2		;extension DEC?
	JR	Z,POSEXT	;yes, fetch it
;
	LD	D,A		;D = start track
	CALL	FIRSTS		;get first sector
;
;	compute sector # for starting gran
;
	LD	A,(IX+23)	;get gran offset
	RLCA			;align bits 7-5 to
	RLCA			;to bits 2-0
	RLCA
	AND	7		;low 3 bits only
	JR	Z,POSLP0	;have starting gran
	LD	H,A		;save counter
	LD	A,E		;get start sector
;
POSLP00	ADD	A,(IY+10)	;add offset to next gran
	DEC	H		;less this gran
	JR	NZ,POSLP00	;go if more
	LD	E,A		;DE = start track/sector
;
POSLP0	LD	A,(IX+23)	;fetch again
	AND	1FH		;low 5 bits only
	CALL	COMPADD		;does it need adjust?
	LD	H,A		;H = # contig grans
	LD	L,(IY+10)	;# sectors/gran
;
POSLP1	DEC	BC		;less rel sector
	LD	A,B		;done?
	OR	C		;yes?
	RET	Z		;yes, return with DE
;
	CALL	NEXSEC		;advance DE to next
	DEC	L		;less sectors / gran
	JR	NZ,POSLP1	;go for this gran
	LD	L,(IY+10)	;get sectors/gran back
	DEC	H		;less contiguous grans
	JR	NZ,POSLP1	;go if any more
	INC	IX		;bump to next extent
	INC	IX		;2 bytes each
	JR	POSIT0		;continue
;
;	extension found, fetch it
;
POSEXT	LD	A,2		;set FXDE position
	LD	(TEMP8),A	;save it
	LD	A,(IX+23)	;get DEC of extension
	LD	L,A		;save a second
	AND	1FH		;relative sector offset
	LD	H,A		;H = relative sector
	LD	A,L		;re-fetch start
	AND	0E0H		;relative byte offset
	LD	L,A		;HL = offset to extension
	LD	DE,0		;fetch start of records
PUTADE	EQU	$-2
	ADD	HL,DE		;HL => next record
	PUSH	HL		;pass to IX
	POP	IX		;IX => extension
	JR	POSIT0		;continue positioning
;
