; sudata/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
	PAGE
;
	SUBTTL	'<SUDATA/ASM - Equivalences>'
;
@00	EQU	00H		;RST 00H
@08	EQU	08H		;RST 08H
@10	EQU	10H		;RST 10H
@18	EQU	18H		;RST 18H
@20	EQU	20H		;RST 20H
@28	EQU	28H		;RST 28H
@30	EQU	30H		;RST 30H
@38	EQU	38H		;RST 38H
;
VIDEO	EQU	3C00H		;start of video memory
ETX	EQU	00H		;end of text
CR	EQU	0DH		;carriage return
LF	EQU	0AH		;line feed
BLANK	EQU	20H		;blank char
BOL	EQU	1DH		;cursor to line beginning
EOL	EQU	1EH		;clear to end of line
ETBL	EQU	00H		;end of table
CLSF	EQU	05H		;clear screen and frame
CLSA	EQU	06H		;clear all screen
CLSB	EQU	07H		;clear bottom screen
TAB	EQU	09H		;tab
BACKSP	EQU	08H		;backspace
UFEED	EQU	0BH		;up linefeed
PROMPT	EQU	5FH		;prompt char
ULINE	EQU	5FH		;underlined space
CURCHR	EQU	98H		;cursor on character
CURCHRO	EQU	0A4H		;cursor off char
BLOCK	EQU	0BFH		;block character
COMMA	EQU	','		;comma
;
ENTER	EQU	0DH		;enter key
SENTER	EQU	0EH		;shift enter key
CLEAR	EQU	03H		;clear key
SCLEAR	EQU	04H		;shift clear key
BREAK	EQU	01H		;break key
SBREAK	EQU	02H		;shift break key
UARR	EQU	5BH		;up arrow
SUARR	EQU	1BH		;shift up arrow
DARR	EQU	5CH		;down arrow
SDARR	EQU	1AH		;shift down arrow
LARR	EQU	5DH		;left arrow
SLARR	EQU	18H		;shift left arrow
RARR	EQU	5EH		;right arrow
SRARR	EQU	19H		;shift right arrow
SPACE	EQU	20H		;space bar
SSPACE	EQU	80H		;shift space bar
;
	PAGE
;
	SUBTTL	'<SUDATA/ASM - Data Storage Area>'
;
	PAGE
;
;	RST vector table
;
RST08	JP	DISPLY		;string to video
RST10	JP	GETSTR		;keyboard line input
RST18	JP	ASCII		;binary => ascii DECIMAL
RST20	JP	HEXCV		;binary => ascii HEX
RST28	JP	SHOREAD		;sector read / display
RST30	JP	SHOWRIT		;sector write / display
RST38	JP	TASK		;interrupt service
;
;	2 additional vectors for program entry
;
MASTER	JP	MENU		;return main menu
SUBMENU	JP	RETURN		;return sub-menu
;
;	flag bytes
;
WHERE	DEFB	0		;sub-menu return flag
;	0 = main menu
;	1 = disk zap
;	2 = disk purge
;	3 = disk format
;	4 = disk backup
;	5 = disk repair
;	6 = tape utility
;	7 = memory utility
;	8 = file utility
;	9 = configuration
;
MODE	DEFB	0		;modify mode base
;	0 = HEX modify
;	1 = DECIMAL modify
;	2 = BINARY modify
;	3 = OCTAL modify
;	4 = ASCII modify
;
TYPE	DEFB	0		;source of modify data
;	1 = data from direct disk sector
;	2 = data from memory
;	3 = data from file sector
;
;	data
;
SECTOR	DEFB	0		;relative sector
TRAK	DEFB	0		;relative track
TRUE	DEFB	0		;real track
;
CURSOR	DEFW	3C00H		;video cursor location
;
EOFB	DEFB	0		;file end of file byte
EOFS	DEFW	0		;end of file sector
EOAS	DEFW	0		;end of allocation sector
;
FREEG	DEFW	0		;free granules
FREEF	DEFB	0		;free files
CGRANS	DEFW	0		;gran counter
;
ADDRESS	DEFW	BUFFER		;memory display address
DEFADDR	DEFW	MENU		;default address vector
FMTBUFF	DEFW	FBUFF		;buffer for build track
;
DIRSCNT	DEFB	0		;directory sector count
DIRPAGE	DEFB	0		;curr dir display page
;
TOPMEM	DEFW	0000H		;top of memory +1
MIDMEM	DEFW	MIDPNT		;middle free memory
BOTMEM	DEFW	BUFFER		;free memory start
;
;	printer data storage
;
PRSIZE	DEFW	400H		;size of buffer
PRBUFF	DEFW	0000H		;start of buffer
PRADDO	DEFW	0		;add to buffer offset
PRTAKO	DEFW	0		;take from buffer offset
;
NUMTYPE	DEFB	0		;number type for value
RESULT	DEFW	0		;result of disk I/O
;
;	NMI disk vector for Mod III at 4049H
;
DRIVES	DEFB	4		;# drives in system
	DEFW	0000H		;get to 4049H
;
NMIVECT	JP	RETNMI		;NMI disk vector
RETNMI	RETN			;non-disk vector
;
;	temporary storage block for subroutine use
;
TEMP0	DEFW	0		;temporary storage
TEMP1	DEFW	0
TEMP2	DEFW	0
TEMP3	DEFW	0
TEMP4	DEFW	0
TEMP5	DEFW	0
TEMP6	DEFW	0
TEMP7	DEFW	0
TEMP8	DEFW	0
TEMP9	DEFW	0
;
;	return vector table
;
VECTOR0	DEFW	0		;#0
VECTOR1	DEFW	0		;#1
VECTOR2	DEFW	0		;#2
VECTOR3	DEFW	0		;#3
VECTOR4	DEFW	0		;#4
;
;	system operation flag
;
FLAGA	DEFB	0		;system flag A
;	7 = 1 = DUAL ACTIVE
;	6 = 1 = HISPEED clock ON
;	5 = 1 = DUAL ON
;	4 = 1 = Task Spooler De-Activated
;	3 = 1 = Extended ID Marks Mode (from ZAP)
;	2 = 1 = String Replace Flag
;	1 = 1 = Alive OFF
;	0 = 1 = Keyboard case lock switch ON
;
FLAGB	DEFB	0		;system flag B
;	7 = 1 = printer graphics ON
;	6 = 1 = printer lower case ON
;	5 = 1 = adjust printer graphics for MX80
;	4 = 1 = NO double density available
;	3 = 1 = send linefeeds on carriage returns
;	2 = 1 = Radio Shack Doubler Installed
;	1 = 1 = attempt non-standard disk read @ $DISDSK
;	0 = 1 = trace OFF
;
ZAPFLAG	DEFB	0		;ZAP error flag
MOD3FIL	DEFB	0		;filespec eval flag
SCANFLG	DEFB	0		;allow multiple drives
;
SDRIVE	DEFB	0		;source drive
DDRIVE	DEFB	0		;destination drive
MFLAG	DEFB	0		;disk mount prompts?
;
DRIV	DEFB	0		;binary drive number
DRIVE	DEFB	1		;bit pattern set for drv
POSA	DEFB	0		;curr drive for mult rout
RSECT	DEFW	0		;relative sector storage
;
RDTYPE	DEFB	88H		;sector read byte
WRTYPE	DEFB	0A8H		;sector write byte
;
BUFPAS	DEFW	0		;buffer save address
SECPAS	DEFW	0		;track/sector saver
TEMPFF	DEFW	0		;address of last byte I/O
;
STRLEN	DEFB	0		;string length
REPLEN	DEFB	0		;replacement length
HASDAT	DEFB	0		;if format over data
;
TCOUNT	DEFW	0000H		;counter for tape
TSUM	DEFW	0000H		;checksum for tape
TADDR	DEFW	0000H		;address end tape
TADDS	DEFW	0000H		;address start tape
;
;	keyboard mask area for new key detect
;
KEYBRD	DEFB	0,0,0,0,0,0,0	;one byte each key row
;
;	keyboard lookup table for special keys
;
KEYTABL	DEFB	ENTER		;enter
	DEFB	SENTER		;sh enter
	DEFB	CLEAR		;clear
	DEFB	SCLEAR		;sh clear
	DEFB	BREAK		;break
	DEFB	SBREAK		;sh break
	DEFB	UARR		;u arr
	DEFB	SUARR		;sh u arr
	DEFB	DARR		;d arr
	DEFB	SDARR		;sh d arr
	DEFB	LARR		;l arr
	DEFB	SLARR		;sh l arr
	DEFB	RARR		;r arr
	DEFB	SRARR		;sh r arr
	DEFB	SPACE		;space
	DEFB	SSPACE		;sh space
;
;	displacement offsets for 'decrypt' mode
;
DISP1	DEFB	'+'		;type flag
DISP2	DEFB	20H		;type modifier
DISP3	DEFB	0		;type value
SHFLG	DEFB	0		;hex side adjust flag
;
COUNT	DEFW	0		;counter word
XCOUNT	DEFW	0		;disk error counter
XACOUNT	DEFW	0		;alternate counter
;
;	keyboard input area (70 bytes)
;
STRING	DEFM	'String String String String String '
	DEFM	'String String String String String '
;
;	system stack area (216 bytes)
;
	DEFM	'Stack Stack Stack Stack Stack Stack '
	DEFM	'Stack Stack Stack Stack Stack Stack '
	DEFM	'Stack Stack Stack Stack Stack Stack '
	DEFM	'Stack Stack Stack Stack Stack Stack '
	DEFM	'Stack Stack Stack Stack Stack Stack '
	DEFM	'Stack Stack Stack Stack Stack Stack '
STACK	EQU	$
;
;	filename storage area
;
FILEDCB	DEFM	'FilenameExt'
PASSWRD	DEFM	'Password'
;
;	checker string to make sure
;	my name doesn't get changed in the program
;
KIMCHK	DEFB	'K'.XOR.'*'
	DEFB	'i'.XOR.'*'
	DEFB	'm'.XOR.'*'
	DEFB	' '.XOR.'*'
	DEFB	'W'.XOR.'*'
	DEFB	'a'.XOR.'*'
	DEFB	't'.XOR.'*'
	DEFB	't'.XOR.'*'
;
;	disk drive data storage area, 13 bytes each
;	8 contiguous drive code tables (DCT's)
;
;	+0 = physical track count
;	+1 = relative track count
;	+2 = directory track
;	+3 = current head location
;	+4 = resident flags
;		7 = 1 = drive NOT IN SYSTEM
;		6 = 1 = software write protected
;		5&4   = read motor delay in 1/4 secs
;		3&2   = write motor delay in 1/4 secs
;		1&0   = drive step rate (0-3)
;	+5 = resident flags
;		7 = 1 = current operation is WRITE
;		6 = 1 = double step this drive
;		5 = 1 = drive active in multiple commands
;		4 = 1 = auto dos detect next access
;		3 = 1 = attempt non-standard I/O
;		2 = unused
;		1 = 1 = current access to side 2
;		0 = 1 = double sided disk available
;	+6 = disk description flags
;		7 = 1 = double den track 0
;		6 = 1 = double den disk
;		5 = 1 = track 0 unavailable for files
;		4 = 1 = relative sectoring available
;		3 = 1 = relative sectoring engaged
;		2 = 1 = disk ID marks reversed
;		1 = 1 = start sector track 0
;		0 = 1 = start sector disk
;	+7 = dos type (see following list)
;	+8 = highest sector track 0
;	+9 = highest sector disk
;	+10 = sectors / granule
;	+11 = granules / track
;	+12 = directory length in sectors
;
;	NOTE:	if 2 sided media (bit 0@+5 set)
;		then highest sectors - grans/track
;		& dir length must be adjusted
;
;i*
	IF	MODI
DCT0	DEFB	35		;00
	DEFB	35		;01
	DEFB	17		;02
	DEFB	00		;03
	DEFB	00000011B	;04
	DEFB	00000000B	;05
	DEFB	00000000B	;06
	DEFB	01		;07
	DEFB	09		;08
	DEFB	09		;09
	DEFB	05		;10
	DEFB	02		;11
	DEFB	10		;12
;
DCT1	DEFB	35		;00
	DEFB	35		;01
	DEFB	17		;02
	DEFB	00		;03
	DEFB	00000011B	;04
	DEFB	00000000B	;05
	DEFB	00000000B	;06
	DEFB	01		;07
	DEFB	09		;08
	DEFB	09		;09
	DEFB	05		;10
	DEFB	02		;11
	DEFB	10		;12
;
DCT2	DEFB	35		;00
	DEFB	35		;01
	DEFB	17		;02
	DEFB	00		;03
	DEFB	00000011B	;04
	DEFB	00000000B	;05
	DEFB	00000000B	;06
	DEFB	01		;07
	DEFB	09		;08
	DEFB	09		;09
	DEFB	05		;10
	DEFB	02		;11
	DEFB	10		;12
;
DCT3	DEFB	35		;00
	DEFB	35		;01
	DEFB	17		;02
	DEFB	00		;03
	DEFB	00000011B	;04
	DEFB	00000000B	;05
	DEFB	00000000B	;06
	DEFB	01		;07
	DEFB	09		;08
	DEFB	09		;09
	DEFB	05		;10
	DEFB	02		;11
	DEFB	10		;12
;
DCT4	DEFB	35		;00
	DEFB	35		;01
	DEFB	17		;02
	DEFB	00		;03
	DEFB	10000011B	;04
	DEFB	00000000B	;05
	DEFB	00000000B	;06
	DEFB	01		;07
	DEFB	09		;08
	DEFB	09		;09
	DEFB	05		;10
	DEFB	02		;11
	DEFB	10		;12
;
DCT5	DEFB	35		;00
	DEFB	35		;01
	DEFB	17		;02
	DEFB	00		;03
	DEFB	10000011B	;04
	DEFB	00000000B	;05
	DEFB	00000000B	;06
	DEFB	01		;07
	DEFB	09		;08
	DEFB	09		;09
	DEFB	05		;10
	DEFB	02		;11
	DEFB	10		;12
;
DCT6	DEFB	35		;00
	DEFB	35		;01
	DEFB	17		;02
	DEFB	00		;03
	DEFB	10000011B	;04
	DEFB	00000000B	;05
	DEFB	00000000B	;06
	DEFB	01		;07
	DEFB	09		;08
	DEFB	09		;09
	DEFB	05		;10
	DEFB	02		;11
	DEFB	10		;12
;
DCT7	DEFB	35		;00
	DEFB	35		;01
	DEFB	17		;02
	DEFB	00		;03
	DEFB	10000011B	;04
	DEFB	00000000B	;05
	DEFB	00000000B	;06
	DEFB	01		;07
	DEFB	09		;08
	DEFB	09		;09
	DEFB	05		;10
	DEFB	02		;11
	DEFB	10		;12
	ENDIF
;i*
;
;iii*
	IF	MODIII
DCT0	DEFB	40		;00
	DEFB	40		;01
	DEFB	17		;02
	DEFB	00		;03
	DEFB	00000011B	;04
	DEFB	00000000B	;05
	DEFB	11000111B	;06
	DEFB	03		;07
	DEFB	18		;08
	DEFB	18		;09
	DEFB	03		;10
	DEFB	06		;11
	DEFB	18		;12
;
DCT1	DEFB	40		;00
	DEFB	40		;01
	DEFB	17		;02
	DEFB	00		;03
	DEFB	00000011B	;04
	DEFB	00000000B	;05
	DEFB	11000111B	;06
	DEFB	03		;07
	DEFB	18		;08
	DEFB	18		;09
	DEFB	03		;10
	DEFB	06		;11
	DEFB	18		;12
;
DCT2	DEFB	40		;00
	DEFB	40		;01
	DEFB	17		;02
	DEFB	00		;03
	DEFB	00000011B	;04
	DEFB	00000000B	;05
	DEFB	11000111B	;06
	DEFB	03		;07
	DEFB	18		;08
	DEFB	18		;09
	DEFB	03		;10
	DEFB	06		;11
	DEFB	18		;12
;
DCT3	DEFB	40		;00
	DEFB	40		;01
	DEFB	17		;02
	DEFB	00		;03
	DEFB	00000011B	;04
	DEFB	00000000B	;05
	DEFB	11000111B	;06
	DEFB	03		;07
	DEFB	18		;08
	DEFB	18		;09
	DEFB	03		;10
	DEFB	06		;11
	DEFB	18		;12
;
DCT4	DEFB	40		;00
	DEFB	40		;01
	DEFB	17		;02
	DEFB	00		;03
	DEFB	10000011B	;04
	DEFB	00000000B	;05
	DEFB	11000111B	;06
	DEFB	03		;07
	DEFB	18		;08
	DEFB	18		;09
	DEFB	03		;10
	DEFB	06		;11
	DEFB	18		;12
;
DCT5	DEFB	40		;00
	DEFB	40		;01
	DEFB	17		;02
	DEFB	00		;03
	DEFB	10000011B	;04
	DEFB	00000000B	;05
	DEFB	11000111B	;06
	DEFB	03		;07
	DEFB	18		;08
	DEFB	18		;09
	DEFB	03		;10
	DEFB	06		;11
	DEFB	18		;12
;
DCT6	DEFB	40		;00
	DEFB	40		;01
	DEFB	17		;02
	DEFB	00		;03
	DEFB	10000011B	;04
	DEFB	00000000B	;05
	DEFB	11000111B	;06
	DEFB	03		;07
	DEFB	18		;08
	DEFB	18		;09
	DEFB	03		;10
	DEFB	06		;11
	DEFB	18		;12
;
DCT7	DEFB	40		;00
	DEFB	40		;01
	DEFB	17		;02
	DEFB	00		;03
	DEFB	10000011B	;04
	DEFB	00000000B	;05
	DEFB	11000111B	;06
	DEFB	03		;07
	DEFB	18		;08
	DEFB	18		;09
	DEFB	03		;10
	DEFB	06		;11
	DEFB	18		;12
	ENDIF
;iii*
;
;	lookup table to locate a DCT
;
DCTTBL	DEFW	DCT0
	DEFW	DCT1
	DEFW	DCT2
	DEFW	DCT3
	DEFW	DCT4
	DEFW	DCT5
	DEFW	DCT6
	DEFW	DCT7
;
;	equate table for dos/type symbols
;	lookup table to locate DOS particulars
;	data loaded into DCT from +6 - +12
;
; UNKNOWN
;	U, U1, U3, US, UD, U1S, U1D, U3S, U3D
;
$U	DEFB	00000000B,00,255,255,32,08,255
;
; TRSDOS
;	Mod 1/SD - T, T1, TS, T1S
;	Mod 1/DD - T1D
;	Mod 3/SD - invalid
;	Mod 3/DD - T3, TD, T3D
;
$T	DEFB	00000000B,01,09,09,05,02,10
$T1D	DEFB	01100001B,02,09,18,03,06,18
$T3	DEFB	11000111B,03,18,18,03,06,18
;
; LDOS
;	Mod 1/3/SD - L, L1, LS, L1S, L3S
;	Mod 1/DD (sole) - L1D
;	Mod 3/DD - L3, LD, L3D
;
$L	DEFB	00000000B,04,09,09,05,02,10
$L1D	DEFB	01100000B,05,09,17,06,03,18
$L3	DEFB	11000000B,06,17,17,06,03,18
;
; DOSPLUS
;	Mod 1/3/SD - D, D1, DS, D1S, D3S
;	Mod 1/DD(system) - D1D
;	Mod 1/DD(data)/3/DD - D3, DD, D3D
;
$D	DEFB	00000000B,07,09,09,05,02,10
$D1D	DEFB	01100000B,08,09,17,06,03,18
$D3	DEFB	11000000B,09,17,17,06,03,18
;
; MULTIDOS (+ relative sectoring)
;	Mod 1/3/SD - M, M1, MS, M1S, M3S
;	Mod 1/DD(system) - M1D
;	Mod 1/DD(data)/3/DD - M3, MD, M3D
;
$M	DEFB	00000000B,10,09,09,05,02,10
$M1D	DEFB	01110000B,11,09,17,06,03,18
$M3	DEFB	11000000B,12,17,17,06,03,18
;
; NEWDOS (+ relative sectoring)
;	Mod 1/3/SD - N, N1, NS, N1S, N3S
;	Mod 1/DD(tk 0 reversed) - N1D
;	Mod 1/DD(tk 0 normal)/3/DD - N3, ND, N3D
;
$N	DEFB	00000000B,13,09,09,05,02,10
$N1D	DEFB	01110000B,14,09,17,05,02,10
$N3	DEFB	11010000B,15,17,17,05,02,10
;
; DOUBLEDOS (relative sectoring mandatory)
;	Mod 1/3/SD - invalid
;	Mod 1/DD - B, B1, BD, B1D
;	Mod 3/DD - invalid
;
$B	DEFB	01111000B,16,09,17,05,02,10
;
; XTRA
;	Mod 1/SD - X, X1, XS, X1S
;	Mod 1/DD - X1D
;	Mod 3/SD - X3S
;	Mod 3/DD - X3, XD, X3D
;
$X	DEFB	00000000B,17,09,09,05,02,10
$X1D	DEFB	01100000B,18,09,17,06,03,18
$X3S	DEFB	00000000B,19,09,09,05,02,10
$X3	DEFB	11000000B,20,17,17,06,03,18
;
DNAMES	DEFM	'U**'
	DEFM	'T1S'
	DEFM	'T1D'
	DEFM	'T3D'
	DEFM	'L1S'
	DEFM	'L1D'
	DEFM	'L3D'
	DEFM	'D1S'
	DEFM	'D1D'
	DEFM	'D3D'
	DEFM	'M1S'
	DEFM	'M1D'
	DEFM	'M3D'
	DEFM	'N1S'
	DEFM	'N1D'
	DEFM	'N3D'
	DEFM	'B1D'
	DEFM	'X1S'
	DEFM	'X1D'
	DEFM	'X3S'
	DEFM	'X3D'
;
;	serial number storage area (30 bytes)
;
SERSAVE	DEFB	0,0,0,0,0,0,0,0,0,0
	DEFB	0,0,0,0,0,0,0,0,0,0
	DEFB	0,0,0,0,0,0,0,0,0,0
;
