; sufilee/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
	PAGE
;
	SUBTTL	'<SUFILEE/ASM - Files Section E>'
;
;	$ASKFILE - fetch filespec from user
;
ASKFILE	RST	@08		;display prompt
;
	DEFB	EOL
	DEFM	'Filename ? '
	DEFB	ETX
;
	LD	B,40		;40 char input
	RST	@10		;get from keyboard
	CALL	POSHL		;position to input
	JR	Z,ASKFILE	;nil, ask again
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	MOVFILE		;'crack' into FCB
	CALL	C,BADFILE	;invalid filespec
	JR	C,ASKFILE	;ask again
;
	CALL	FNDFILE		;locate the file
	CALL	C,NOFILE	;file not found
	JR	C,ASKFILE	;ask again
;
;	file found, IX => dir entry, (DRIVE) valid
;
	XOR	A		;return no error
	RET			;back to caller
;
	PAGE
;
;	$CLEARFL - clear file entry point
;
CLEARFL	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	ASKFILE		;ask/locate file
	LD	(IXSAVX),IX	;save dir pointer
;
;	better double check, this is deadly
;
	RST	@08		;double prompt
;
	DEFB	LF
	DEFM	'Are you sure ? '
	DEFB	ETX
;
	LD	B,3		;don't inkey this one
	RST	@10		;get from keyboard
	CALL	POSHL		;fetch first char
	JP	Z,SUBMENU	;abort if nil!
	CALL	UCASE		;make upper case
	CP	'Y'		;yes?
	JP	NZ,SUBMENU	;nope, back to menu!
;
	LD	HL,0		;set starting rel sector
	LD	(TEMP9),HL	;save for POSIT
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	DSTAT		;check drive status
	JP	NZ,SUBMENU	;go if not ready!
;
CLRFLP	LD	DE,FILBUFF	;start of file buffer
	LD	IX,(IXSAVX)	;fetch current file ptr
	CALL	POSIT		;position the file
	JP	C,GOBACK	;done! return to menu
;
	LD	BC,BUFFER	;I/O buffer
	CALL	ZBUFF		;clear to zeroes
	RST	@30		;write the sector!
	JP	NZ,GOBACK	;abort if CANCEL
;
;	advance relative sector
;
	LD	HL,(TEMP9)	;get current rel sector
	INC	HL		;+1
	LD	(TEMP9),HL	;put it back
	JR	CLRFLP		;finish it off!
;
;	locate end of file relative sector
;
FINDEOF	LD	DE,FILBUFF	;filename buffer
	CALL	POSITBC		;position file
	DEC	BC		;adjust to last sector
	RET	C		;back with BC = last good
	INC	BC		;else adjust back
	INC	BC		;+1
	JR	FINDEOF		;continue
;
;	write current sector to file ($OFSFILE)
;
WRITSEC	LD	IX,(IXSAVX)	;get IX pointer to file
	LD	DE,FILBUFF	;start of records
	CALL	POSIT		;position the file
	LD	BC,BUFFER	;data is here
	JP	@30		;write sector to disk
;
	PAGE
;
;	$COPFILE - copy files entry point
;
COPFILE	LD	A,5		;setup format type
	LD	(FMTYPE),A	;save it
	CALL	ONEDRIV		;fetch source drive
	LD	A,1		;disable drive scanning
	LD	(SCANFLG),A	;for filespec search
	DEC	A		;load zero
	LD	(LINEC),A	;line counter
	LD	A,(DRIV)	;get input drive number
	LD	(SDRIVE),A	;save as source drive
;
	CALL	DIRLSTC		;list filenames
;
	CALL	ENTRIES		;load E with # records
	LD	(DIRX),DE	;save E as # records
	LD	IX,FILBUFF	;start of file records
	RST	@08		;couple of linefeeds
;
	DEFB	LF
	DEFB	LF
	DEFB	ETX
;
;	setup files to be copied
;
COPFLP	BIT	4,(IX)		;active file?
	CALL	NZ,IFCOPY	;if yes, ask if to go
	CALL	IXDIR		;move IX to next record
	DEC	E		;less this file
	JR	NZ,COPFLP	;go if more to do
;
	CALL	INSGTC		;compute grans/sectors
	LD	(USEGR),HL	;# sectors to copy
	RST	@08		;up linefeed
;
	DEFB	UFEED
	DEFB	ETX
;
;	move source directory to storage at $FBUFF
;
	LD	BC,1000H	;16 sectors of directory
	LD	HL,FILBUFF	;directory is here
	LD	DE,FBUFF	;move it here
	LDIR			;move source directory
;
	CALL	GETDRVS		;ask for dest drives
	RST	@08		;display banner
;
	DEFB	LF
	DEFB	LF
	DEFM	'Files to be copied:'
	DEFB	LF
	DEFB	ETX
;
	LD	A,(SDRIVE)	;fetch source drive
	CALL	SETDRV		;fetch DCT address
	LD	HL,(CURSOR)	;get cursor
	LD	IX,FBUFF	;file buffer
	LD	DE,(DIRX)	;# entries in directory
	XOR	A		;load zero
	LD	(LINEC),A	;clear line counter
	CALL	DIRLSTO		;display files to copy
	RST	@08		;couple of linefeeds
;
	DEFB	LF
	DEFB	LF
	DEFB	ETX
;
	LD	DE,COPY1	;subroutine vector
	LD	BC,GOBACK	;sub-menu when done
	JP	DRVCOMM		;do all requested drives
;
;	check if file is to be copied
;
IFCOPY	BIT	7,(IX)		;file extension?
	RET	NZ		;yes, don't do it
;
	CALL	SAVEREG		;save registers
	BIT	6,(IX)		;system file?
	LD	HL,FILBUFF	;start of records
	LD	(KILLW),HL	;save for $KILL
	JP	NZ,KILLIT	;remove from list if yes
WIFC1	RST	@08		;clear current line
;
	DEFB	EOL
	DEFB	ETX
;
	LD	HL,(CURSOR)	;fetch cursor
	CALL	SHOWIT		;display filename
	LD	HL,FILBUFF	;start of records
	LD	(TEMP5),HL	;save it
	LD	(KILLW),HL	;save here also
	CALL	DSPSECS		;display sectors in file
	RST	@08		;display prompt
;
	DEFM	', Copy ? '
	DEFB	ETX
;
	LD	B,1		;fetch one key
	RST	@10		;fetch from keyboard
	CALL	UCASE		;convert to upper case
	CP	'N'		;don't copy?
	JP	Z,KILLIT	;yes, kill file
	CP	'Y'		;do copy?
	JR	NZ,WIFC1	;neither, ask again
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	RET			;return for next file
;
;	loop for file copy
;
COPY1	LD	A,-1		;set no prompts
	LD	(MFLAG),A	;save mount flag
	LD	A,(SDRIVE)	;get source drive
	CALL	SETDRV		;setup for I/O
	BIT	5,(IY+5)	;setup for dest also?
	JR	Z,HGHG81	;nope, continue
	XOR	A		;turn on mount prompts
	LD	(MFLAG),A	;save prompt flag
;
HGHG81	LD	A,(POSA)	;get current drive #
	LD	(DDRIVE),A	;save it as dest drive
	CALL	DSETUP		;setup for dest drive
	CALL	RDDIR		;read the directory
	JP	NZ,NOTDIR	;can't find, skip drive
	CALL	DIRPART		;display name/date/etc
	LD	DE,(FREEG)	;free grans this dir
	LD	A,(IY+10)	;get sectors/gran
	LD	HL,0		;init counter
;
CMPQE	ADD	HL,DE		;add free grans
	DEC	A		;less this sector
	JR	NZ,CMPQE	;compute # free sectors
;
	PUSH	HL		;save free on stack
	PUSH	IY		;save from BINASC
	LD	IY,AFGMG	;point to text
	CALL	BINASC		;convert HL to dec ascii
	LD	HL,0		;# sectors to copy
USEGR	EQU	$-2
	PUSH	HL		;save on stack
	LD	IY,AGGMG	;point to text
	CALL	BINASC		;convert to decimal ascii
	POP	DE		;DE = needed sectors
	POP	IY		;restore DCT pointer
	POP	HL		;HL = available sectors
;
	RST	@08		;display message
;
	DEFB	LF
	DEFM	'Sectors to copy = '
AGGMG	DEFM	'xxxxx, Sectors not allocated = '
AFGMG	DEFM	'xxxxx'
	DEFB	LF
	DEFB	LF
	DEFB	ETX
;
;	HL = available, DE = needed, compare if enough
;
	OR	A		;clear carry flag
	SBC	HL,DE		;compare HL & DE
	JR	NC,USEGROK	;go if HL is = or >
	RST	@08		;display message
;
	DEFM	'Insufficient disk space '
	DEFM	'for complete file set'
	DEFB	LF
	DEFB	ETX
;
;	RET			;on to next drive
;
USEGROK	CALL	ENTRIES		;get # dir records
	LD	(DIRY),DE	;save E count
	LD	DE,0		;get # source records
DIRX	EQU	$-2
	LD	IX,FBUFF	;source directory here
;
;	copy looper
;
COPY1L	LD	A,(SDRIVE)	;get source drive
	CALL	SETDRV		;setup for I/O
	BIT	4,(IX)		;active file?
	CALL	NZ,IFCOPY1	;yes, copy it!
	LD	A,(SDRIVE)	;get source drive back
	CALL	SETDRV		;setup again
	CALL	IXDIR		;move IX to next entry
	DEC	E		;less this file
	JR	NZ,COPY1L	;go if more to do
;
;	all files copied, write back directory
;
	CALL	DSETUP		;setup for dest drive
	CALL	MAKEGAT		;create GAT table
	CALL	MAKEHIT		;create HIT table
	JP	WRDIR		;write back directory
;
;	copy a single file
;
IFCOPY1	BIT	7,(IX)		;extended entry?
	RET	NZ		;yes, skip it
	BIT	6,(IX)		;system file?
	RET	NZ		;yes, skip it
;
	CALL	SAVEREG		;save registers
	LD	A,(POSA)	;get current drive
	LD	(DDRIVE),A	;save as dest drive
	PUSH	IX		;must save IX
	CALL	PERCOPY		;create/allocate space
	POP	IX		;restore pointer
;
	JP	EXECOPY		;copy the file
;
;	allocate disk space / create needed extensions
;
PERCOPY	RST	@08		;display message
;
	DEFB	EOL
	DEFM	'Copying: '
	DEFB	ETX
;
	LD	HL,(CURSOR)	;get cursor position
	CALL	SHOWIT		;display filespec
	LD	A,(SDRIVE)	;get source drive
	CALL	SETDRV		;fetch DCT
;
	LD	HL,FBUFF	;stored source dir
	LD	(TEMP5),HL	;save it
;
	PUSH	IX		;save on stack for HL
	CALL	DSPSECS		;display # sectors
	POP	HL		;HL => dir record
;
	LD	BC,5		;offset to name
	ADD	HL,BC		;HL => filename
	LD	DE,FILEDCB	;point to file DCB
	LD	BC,11		;save it there
	LDIR			;8 name + 3 extension
;
;	see if file currently exists
;
	LD	A,(DDRIVE)	;get dest drive
	CALL	SETDRV		;fetch DCT
	LD	DE,(DIRY)	;get # records in dir
	PUSH	IX		;save pointer
	CALL	FNDFIL1		;see if file exists
	CALL	NC,OVERWRT	;ask if to be overwritten
	POP	IX		;restore file ptr
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	FNDSPOT		;find free entry
	LD	D,H		;HL => space
	LD	E,L		;DE => free entry
;
	LD	(TEMP7),HL	;pointer to file
	CALL	INCPASS		;incompatable passwords?
	PUSH	IX		;pass IX to HL
	POP	HL		;HL => current record
	LD	BC,22		;length up to extents
	LDIR			;move into new record
;
	LD	BC,9		;remainder extent length
	LD	A,(IY+7)	;get dos type
	CP	03		;trsdos III?
	JR	NZ,I9478	;nope, go!
	LD	BC,25		;remainder extents trsIII
;
I9478	LD	H,D		;pass pointer to HL
	LD	L,E		;HL = DE
	INC	DE		;current place +1
	LD	(HL),-1		;set as nil
	LDIR			;fill extents with nil
;
	LD	A,(SDRIVE)	;get source drive
	CALL	SETDRV		;fetch DCT
	LD	BC,0		;init count
	LD	HL,FBUFF	;source dir buffer
	LD	(TEMP5),HL	;save it
;
;	fetch # sectors in file
;
	LD	L,(IX+20)	;get LSB EOFS
	LD	H,(IX+21)	;get MSB EOFS
	LD	A,(IX+3)	;get EOFB
	OR	H		;check for nil file
	OR	L		;AHL = 0?
	RET	Z		;yes, don't copy it
	OR	A		;zero EOFB?
	JR	Z,$+3		;go if yes
	INC	HL		;bump # sectors
;
;	HL = # sectors needed for this file
;
	LD	A,(DDRIVE)	;get current dest drive
	CALL	SETDRV		;fetch DCT
	LD	C,(IY+10)	;sectors / granule
	CALL	DIVD		;compute # grans needed
	LD	A,C		;get remainder
	LD	B,H		;pass # grans
	LD	C,L		;BC = # grans
	OR	A		;nil?
	JR	Z,ALLO00	;go if done
	INC	BC		;bump # grans for partial
;
;	allocate # sectors required, BC = needed
;
ALLO00	LD	IX,(TEMP7)	;get dir pointer
	LD	H,B		;pass to HL
	LD	L,C		;HL = # grans needed
;
ALLO0	LD	A,(IY+7)	;get dos type
	CP	03		;trsdos III?
	LD	A,4		;# extents non-trsIII
	JR	NZ,ALLOLP	;go if not
	LD	A,12		;else 12 trs III
;
ALLOLP	PUSH	AF		;save # extents
	PUSH	IX		;save dir pointer
	CALL	CHUNK		;allocate some space
	POP	IX		;restore pointer
	JR	C,OUTSPAC	;out of disk space
	LD	(IX+16H),D	;put track into entry
	LD	A,(IY+7)	;get dos type
	CP	2		;trsdos DD?
	JR	C,U9Z3		;go if not
	CP	4		;t3d?
	JR	NC,U9Z3		;go if not
	INC	C		;adjust
U9Z3	DEC	C		;else adjust to actual
	LD	A,C		;fetch result
	OR	E		;merge with start gran
	LD	(IX+17H),A	;insert extent element
	INC	IX		;bump to next element
	INC	IX		;by 2
	OR	A		;clear carry flag
	SBC	HL,BC		;less this chunk
	JR	Z,ALLODN	;go if done allocating
	POP	AF		;get # extents total
	DEC	A		;less this one
	JR	NZ,ALLOLP	;go if more available
	PUSH	HL		;save count
	CALL	NEWEXT		;create new extension
	POP	HL		;restore count
	JR	ALLO0		;continue allocating
;
;	allocation complete, return
;
ALLODN	POP	AF		;restore stack
	RET			;on to next file
;
;	create new extension in directory
;
NEWEXT	LD	A,(IY+7)	;trsdos III?
	CP	03		;yes?
	JP	Z,OUTSPAF	;out of file space!
;
;	trsdos III cannot have file extensions
;
	CALL	FNDSPOT		;find another free record
;
	LD	DE,FILBUFF	;start of names
	PUSH	HL		;save new record pointer
	OR	A		;clear carry flag
	SBC	HL,DE		;compute HIT
	LD	A,H		;get MSB
	OR	L		;A = hit offset
	LD	(IX+16H),0FEH	;insert extension marker
	LD	(IX+17H),A	;insert HIT extension
;
;	fetch start of record back
;
	LD	HL,(TEMP7)	;get FPDE pointer
	LD	A,(HL)		;get flags
;
	POP	HL		;HL => new record
	PUSH	HL		;pass to IX
	POP	IX		;IX points to new record
	OR	A		;clear carry flag
	SBC	HL,DE		;compute new HIT
;
	PUSH	AF		;save first byte
	LD	A,H		;get MSB
	OR	L		;A = new HIT
	LD	(HL),0		;load with zero
	LD	D,H		;pass to DE
	LD	E,L		;DE => new entry
	INC	DE		;start +1
	LDIR
	LD	(HL),-1		;start allocation table
	LD	BC,9		;length non-trs III
	PUSH	AF		;save HIT
	LD	A,(IY+7)	;trsdos III?
	CP	03		;yes?
	JR	NZ,UR94		;go if not
	LD	BC,25		;else length trsdos III
UR94	LDIR			;clear extents
	POP	AF		;restore HIT
	LD	(IX+1),A	;save new HIT
	POP	AF		;get flags byte
	OR	80H		;set extension bit
	LD	(IX),A		;save into record
	RET			;IX => new record
;
;	messages for out of file/disk space
;
OUTSPAC	CALL	OUTSPC		;'out of'
	RST	@08		;display rest
;
	DEFM	'Disk'
	DEFB	ETX
;
	JR	SPACOUT		;continue
;
OUTSPAF	CALL	OUTSPC		;'out of'
	RST	@08		;display rest
;
	DEFM	'File'
	DEFB	ETX
;
SPACOUT	RST	@08		;display rest
;
	DEFM	' Space'
	DEFB	ETX
;
	JP	GOBACK		;abort copy!
;
OUTSPC	RST	@08		;display
;
	DEFB	LF
	DEFM	'Out of '
	DEFB	ETX
;
	RET			;return
;
;
;	on file copy, if passwords incompatable
;	remove them!
;
INCPASS	CALL	SAVEREG		;save registers
	LD	A,(IY+5)	;get dos flags
	AND	3		;trsdos III?
	PUSH	AF		;save it
	LD	A,(SDRIVE)	;get source drive
	PUSH	IY		;save DCT
	CALL	SETDRV		;find source DCT
	LD	A,(IY+7)	;get dos flags
	POP	IY		;restore DCT
	POP	BC		;get dest DCT flag
	AND	03H		;trsdos III?
	CP	B		;same type?
	RET	Z		;yes, return
	CALL	DPASSU		;get nil password
	LD	(IX+16),L	;LSB
	LD	(IX+17),H	;MSB
	LD	(IX+18),L	;LSB
	LD	(IX+19),H
	RET
;
