; sudiska/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
	SUBTTL	'<SUDISKA/ASM - Disk I/O Section A>'
;
	PAGE
;
;	$XREAD	- sector read / reverse IBM type
;
;	ENT & EXT same as $READ
;
;	track and sector are stuffed into the FDC
;
XREAD	LD	A,(RDTYPE)	;get read type
;i*
	IF	MODI
	XOR	8		;reverse IBM type
	ENDIF
;i*
	LD	(RDTYPE),A	;put it back
;
;	$READNS	- sector read with NO SEEK
;
;	ENT & EXT same as $READ
;
READNS	LD	HL,READ1S	;entry vector to $READ
	RES	7,(IY+5)	;set READ operation
	JR	RDWTNS		;continue
;
;	$WRITENS - sector write with NO SEEK
;
;	ENT & EXT same as $WRITE
;
;	track and sector stuffed to FDC before write
;
WRITENS	LD	HL,WRITE1S	;vector into $WRITE
	SET	7,(IY+5)	;set WRITE operation
RDWTNS	EQU	$
;i*
	IF	MODI
	LD	(37EEH),DE	;give track/sect to FDC
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	A,D		;get track
	OUT	(0F3H),A	;to FDC
	LD	A,E		;get sector
	OUT	(0F2H),A	;to FDC
	ENDIF
;iii*
	JR	READWRT
;
;	$TREAD	- sector read with density reversal
;
;	ENT & EXT same as $READ
;
TREAD	CALL	FLIPDEN		;change density
;
;	$READ	- sector read
;
;	ENT	D  = track
;		E  = sector
;		BC = load address for data
;		(DRIVE) already setup for drive
;		IY => drive DCT
;
;	EXT	Z = OK
;		BC = load address of NEXT sector
;
;		NZ = ERROR, A = status byte
;		BC = unchanged if NZ
;
;		DE = unchanged
;		HL = destroyed
;
READ	LD	HL,READ1	;where to go
	RES	7,(IY+5)	;set READ operation
	JR	READWRT		;go common routine
;
;	$TWRITE	- sector write with density reversal
;
;	ENT & EXT same as $WRITE
;
TWRITE	CALL	FLIPDEN		;switch density
;
;	$WRITE	- sector write with seek
;
;	ENT	D  = track
;		E  = sector
;		BC = data address
;		(DRIVE) already set
;		IY => drive DCT
;
;	EXT	Z = OK
;		BC = address to load NEXT sector
;
;		NZ = A = error status byte
;		BC = unchanged
;
;		DE = unchanged
;		HL = destroyed
;
WRITE	LD	HL,WRITE1
	SET	7,(IY+5)	;set WRITE operation
;
;	$READWRT - common vector for sector read/write
;
;	ENT	HL => code to call for I/O
;		DE = track/sector
;
;	EXT	Z = OK
;		BC = address of NEXT sector
;
;		NZ = A = error status byte
;		BC = unchanged
;
;		DE = unchanged
;		HL = destroyed
;
;	NOTE	2 attempts made for successful I/O
;	NOTE	if the relative sectoring bit is set
;		the the PHYSICAL track/sector is
;		supplied and it will be adjusted to the
;		RELATIVE track and sector
;
READWRT	LD	(RWTCL1),HL	;put into code
	LD	(RWTCL2),HL	;here too for 2nd attempt
	LD	(RWTCL3),HL	;3rd attempt
;
	PUSH	BC		;save load address
;i*
	IF	MODI
	CALL	SELDEN		;select correct FDC chip
	ENDIF
;i*
	CALL	DDOSFIX		;adjust to rel sectoring
	CALL	0		;call read/write
RWTCL1	EQU	$-2
	POP	DE		;restore track/sector
	POP	HL		;get load address
	RET	Z		;return if OK
	LD	B,H		;pass buff back to BC
	LD	C,L		;BC = buffer start
;
;	BIT	4,A		;not found type error?
;	CALL	NZ,RESTORE	;restore drive
;	RET	NZ		;not in system!
;
	PUSH	BC		;save again
	CALL	DDOSFIX		;adjust track/sector
	CALL	0		;try again
RWTCL2	EQU	$-2
	POP	DE		;restore track/sector
	POP	HL		;load address
	RET	Z		;OK, return
;
	LD	B,H		;reset BC back to orig
	LD	C,L
	BIT	4,A		;not found?
	CALL	NZ,RESTORE	;restore drive
	RET	NZ		;not in system!
;
	PUSH	BC		;save again
	CALL	DDOSFIX		;adjust track/sector
	CALL	0		;try again
RWTCL3	EQU	$-2
	POP	DE		;restore track/sector
	POP	HL		;restore load address
	RET	Z		;no error, return
;
	LD	B,H		;reset buffer address
	LD	C,L		;BC = initial buffer
	RET			;return in error
;
;	$FLIPDEN - reverse density for current drive
;
FLIPDEN	LD	A,(FLAGB)	;get system flag
	BIT	4,A		;double den available?
	JR	Z,FLIPGO	;yes, OK
;
;	force single density if no double available
;
	RES	7,(IY+6)	;single track 0
	RES	6,(IY+6)	;single disk
	RET			;done
;
FLIPGO	LD	A,D		;get track
	OR	A		;check for 0
	LD	A,40H		;disk density
	JR	NZ,FLPDEN	;go if not track 0
	ADD	A,A		;track 0 density
FLPDEN	XOR	(IY+6)		;reverse bit in DCT
	LD	(IY+6),A	;put back into table
	RET			;done, back to caller
;
	PAGE
;
;	sector I/O logic for read/write
;
READ1	CALL	SEEK		;move the head to track
	RET	NZ		;bad, return NZ
;i*
	IF	MODI
READ1S	LD	HL,37ECH	;point to FDC cmd reg.
	CALL	SELECT		;select the drive
	RET	NZ		;error, return
	CALL	FIXREAD		;adjust read command
;
	DI			;must disable for xfer
	LD	A,(RDTYPE)	;get read type
	LD	(HL),A		;give read command to FDC
	PUSH	DE		;save track/sector
	LD	DE,37EFH	;data transfer address
	CALL	RXFER		;transfer the data
	POP	DE		;restore track/sector
	ENDIF
;i*
;
;iii*
	IF	MODIII
READ1S	CALL	SELECT		;activate drive
	RET	NZ		;error, return
	CALL	FIXREAD		;adjust read command
	CALL	SETNMI		;setup NMI vectors
	LD	A,(RDTYPE)	;get type of read
	OUT	(0F0H),A	;issue to FDC
	CALL	RXFER		;transfer the bytes
	ENDIF
;iii*
;
;	common exit vector for Mod I & III
;
	PUSH	AF		;save result
	RRCA			;align data address
	RRCA			;mark bits to low bits
	RRCA
	RRCA
	RRCA
	AND	3		;4 types of marks
	OR	0A0H		;make it a write command
	LD	L,A		;save it here
	LD	A,(RDTYPE)	;get type of read
	AND	8		;IBM or not?
	OR	L		;now have a write command
	LD	(WRTYPE),A	;that will produce the
	EX	AF,AF'		;same as this read.
	POP	AF		;put write byte in af'
;
	AND	9FH		;check for error
	RET			;no error on DAMS
;
;	read new track from FDC and put into DCT
;
IOCOMM	PUSH	AF		;save I/O result
;i*
	IF	MODI
	LD	A,(37EDH)	;get track
	ENDIF
;i*
;
;iii*
	IF	MODIII
	IN	A,(0F1H)	;III track register
	ENDIF
;iii*
	LD	(IY+3),A	;put into table
	POP	AF		;restore result
	RET			;done
;
;	sector write logic
;
WRITE1	CALL	SEEK		;move head
	RET	NZ		;error occured
;
WRITE1S	LD	A,(IY+4)	;get DCT flags
	AND	40H		;software WP?
	RET	NZ		;yes, return ERROR
	CALL	FIXWRIT		;adjust command
;i*
	IF	MODI
	LD	HL,37ECH	;point to FDC cmd reg.
	ENDIF
;i*
	CALL	SELECT		;select the drive
	RET	NZ		;error, return
;i*
	IF	MODI
	DI			;must disable for xfer
	LD	A,(WRTYPE)	;get type of write
	LD	(HL),A		;issue write command
	PUSH	DE		;save track/sector
	LD	DE,37EFH	;data transfer address
	CALL	WXFER		;write data to the disk
	POP	DE		;restore track/sector
	ENDIF
;i*
;
;iii*
	IF	MODIII
	CALL	SETNMI		;setup NMI return
	LD	A,(WRTYPE)	;write type
	OUT	(0F0H),A	;give to FDC
	CALL	WXFER		;transfer the bytes
	ENDIF
;iii*
	AND	0FFH		;any errors?
	RET			;return the status
;
	PAGE
;
;	$SEEK	- move head on drive to desired track
;
;	ENT	D  = track to seek
;
;	EXT	Z = OK
;		NZ = A = FDC status byte
;
;		FDC sector register also loaded
;
SEEK	EQU	$		;same for I/III
;i*
	IF	MODI
	LD	HL,37ECH	;point to FDC
	ENDIF
;i*
	CALL	SELECT		;select the drive
	RET	NZ		;error, return
;
	LD	A,(IY+3)	;get current track
	OR	A		;on track 0?
	JR	NZ,SEKCNT	;continue if not
;
	CALL	RESTORE		;restore drive to trk 0
	RET	NZ		;not in system
	XOR	A		;set track 0
;i*
	IF	MODI
SEKCNT	LD	(37EDH),A	;give to FDC track reg
	LD	A,D		;desired track
	CALL	SEEKWHT		;adjust for double step
	LD	(37EFH),A	;desired relative track
;
	LD	A,E		;get desired sector
	LD	(37EEH),A	;give to FDC sect reg
	ENDIF
;i*
;
;iii*
	IF	MODIII
SEKCNT	OUT	(0F1H),A	;give to FDC track reg
	LD	A,D		;get track desired
	CALL	SEEKWHT		;check if double step on
	OUT	(0F3H),A	;desired relative track
	LD	A,E		;get sector
	OUT	(0F2H),A	;set sector
	ENDIF
;iii*
	JP	DOSEEK		;move the head!
;
	PAGE
;
;	$SELECT	- select a disk drive
;
;	ENT	(DRIVE)
;
;	EXT	Z = drive on and ready to go
;		NZ = don't access, A = error status
;
SELECT	LD	A,(IY+4)	;get drive flag
	AND	80H		;active ?
	RET	NZ		;software inactive
;
SELLOOP	EQU	$
;i*
	IF	MODI
	LD	A,(37ECH)	;read FDC status
	ENDIF
;i*
;
;iii*
	IF	MODIII
	IN	A,(0F0H)	;FDC status III
	ENDIF
;iii*
	AND	80H		;check for motor on
	CALL	RESELEC		;select drive
	RET	Z		;return if motor on
;
;	motor was not on at beginning of command
;	check for motor speed delay
;
	LD	A,(IY+4)	;get delay byte
	RLCA			;move left 2 bits
	RLCA			;set for READ
	BIT	7,(IY+5)	;operation read?
	JR	Z,SELWRT	;read, go!
;
;	operation is WRITE, adjust delay
;
	RLCA			;move over 2 more
	RLCA			;bits aligned
;
SELWRT	AND	0C0H		;save bits 7&6 only
	PUSH	BC		;save it
	LD	B,A		;give to B for count
	LD	C,0		;BC = 1/2 or 1 second
	CALL	DELAY		;countdown till BC=0
	POP	BC		;restore
	JR	SELLOOP		;see if ready now
;
;	short wait for FDC to place valid status
;	on the bus after a command has been
;	issued to it
;
DSKSLO	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	RET
;
	PAGE
;
;	$DELAY	- countdown BC till zero
;
;	ENT	BC = value to decrement
;
;	EXT	BC = 0
;
;	NOTE	if high speed clock set, then the
;		delay is actually doubled to adjust
;
;	A is preserved
;
DELAY	PUSH	AF		;save it
;
	PUSH	BC		;save count
	LD	A,(FLAGA)	;get system flag A
	BIT	6,A		;highspeed ON?
	CALL	NZ,DELAYX	;yes, delay once
	POP	BC		;restore original
;
	CALL	DELAYX		;delay again (or first)
;
	POP	AF		;restore AF
	RET			;done, return
;
DELAYX	DEC	BC		;decrement once
	LD	A,B		;check for zero
	OR	C		;any bits on?
	JR	NZ,DELAYX	;if yes, go more
	RET			;else done
;
	PAGE
;
;	$GETDIR	- fetch directory data
;
;	ENT	none
;
;	EXT	DE => first sector in directory
;		A = number of sectors in directory
;
GETDIR	LD	D,(IY+2)	;fetch directory track
	CALL	FIRSTS		;get first sect on track
;
	LD	A,(IY+12)	;directory length
	BIT	0,(IY+5)	;double sided?
	RET	Z		;nope, return
	LD	A,(IY+7)	;get dos type
	CP	7		;dosplus?
	JR	C,GETDIRD	;go if not
	CP	10		;dosplus?
	JR	NC,GETDIRD	;go if not
	LD	A,(IY+12)	;get dir length
	RET			;return if dosplus
;
GETDIRD	LD	A,(IY+12)	;get dir length
	ADD	A,A		;double for side 2
	CP	35		;34 max dir length
	RET	C		;in range
	LD	A,34		;else set at max
	RET
;
	PAGE
;
;	$RESTORE - move a drive head to track 0
;
;	ENT	(DRIVE) setup
;
;	EXT	Z = drive ready, head at track 0
;		NZ = A = error status
;
RESTORE	XOR	A		;fast restore command
	CALL	MOVCOMM		;common head mover
	RET	NZ		;error, return NZ
;i*
	IF	MODI
	LD	A,(37ECH)	;fetch the FDC status
	ENDIF
;i*
;
;iii*
	IF	MODIII
	IN	A,(0F0H)	;FDC status III
	ENDIF
;iii*
	CPL			;reverse the bits
	RRCA			;align for special code
	AND	2		;check for head over 00
	RET	Z		;return if OK
	SET	7,(IY+4)	;set soft 'not in system'
	RET			;return NZ
;
;	common head move subroutine, A = command
;
MOVCOMM	LD	(SAVMOV),A	;save for later mask
;i*
	IF	MODI
	LD	HL,37ECH	;point to FDC
	ENDIF
;i*
	CALL	SELECT		;turn on drive
	RET	NZ		;error now, return
;
;	compute step rate for drive
;
	LD	A,(IY+4)	;get drive flag
	AND	3		;set step speed
	OR	0		;or with command mask
SAVMOV	EQU	$-1
	CALL	MOVHEAD		;move the head to track
	JP	Z,IOCOMM	;no error, update track
;
;	seek error, force a $RESTORE next access
;
SKERR	LD	(IY+3),0	;set curr track to 0
	RET			;ret NZ flag
;
;	issue head motion command to FDC and wait
;
MOVHEAD	EQU	$
;i*
	IF	MODI
	LD	(HL),A		;give to FDC I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	OUT	(0F0H),A	;give to FDC III
	ENDIF
;iii*
	CALL	DSKSLO		;wait for valid status
;
MOVWT	CALL	SELECT		;prevent time-out
	RET	NZ		;quit if drops ready
;i*
	IF	MODI
	LD	A,(HL)		;fetch status byte I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	IN	A,(0F0H)	;fetch status III
	ENDIF
;iii*
	AND	1		;command finished?
	JR	NZ,MOVWT	;wait some more if not
;
	RET			;done, NZ = error
;
	PAGE
;
;	$STEPIN	- step in the head one track
;
;	if double step is on, head moved 2 tracks
;
STEPIN	BIT	6,(IY+5)	;double step?
	CALL	NZ,GOSTPIN	;step twice if set
;
GOSTPIN	LD	A,58H		;fast step in command
	JR	MOVCOMM		;go common sub
;
;	$STEPOUT - step track out one track
;
;	step twice if double-step flag on
;
STEPOUT	BIT	6,(IY+5)	;flag on?
	CALL	NZ,GOSTPOT	;step out if yes
;
GOSTPOT	LD	A,78H		;fast step out command
	JR	MOVCOMM		;go common!
;
;	execute actual seek command here
;
DOSEEK	LD	A,18H		;fast seek command
	CALL	MOVCOMM		;move the head
	RET	NZ		;error, return
;
	LD	A,D		;fetch track
;i*
	IF	MODI
	LD	(37EDH),A	;give to FDC track reg
	ENDIF
;i*
;
;iii*
	IF	MODIII
	OUT	(0F1H),A	;FDC track reg III
	ENDIF
;
	RET			;done, FDC updated
;
	PAGE
;
;	$SETDRV	- setup a drive for disk I/O
;
;	ENT	A = binary drive number (0-7)
;
;	EXT	(DRIVE) bit pattern set for $SELECT
;		IY => drives DCT
;		A = drive number in ASCII
;
SETDRV	PUSH	BC		;save it
	LD	BC,(DRIVES)	;C = # drives
	DEC	C		;C = highest drive #
	AND	C		;drive 0-3(7) valid only
	LD	(DRIV),A	;save binary drive
;
	LD	C,1		;start with bit 0
;
	JR	Z,SETDDN	;have bit if yes
SETDLP	SLA	C		;move drive bit left
	DEC	A		;binary -1
	JR	NZ,SETDLP	;go again if more
;
SETDDN	LD	A,C		;get bit pattern
;i*
	IF	MODI
	LD	A,(IY+5)	;get side bit
	RLCA			;move over 3 bits
	RLCA
	AND	08		;save bit 3 only
	OR	C		;combine it
	ENDIF
;i*
	LD	(DRIVE),A	;save for $SELECT
;
;	fetch DCT address
;
	LD	A,(DRIV)	;get binary back
	ADD	A,A		;times 2 for table
	LD	BC,DCTTBL	;table of DCT's
	ADD	A,C		;add offset to LSB
	LD	C,A		;put it back
	JR	NC,DCTFF	;did not cross page
	INC	B		;else bump the page
;
DCTFF	PUSH	BC		;pass it to IY
	POP	IY		;DCT entry
	LD	C,(IY+0)	;get indirect address
	LD	B,(IY+1)
	PUSH	BC		;pass to IY
	POP	IY		;IY => DCT
;
	POP	BC		;restore it
;
;	$DRVASC	- fetch drive number in ascii
;
;	ENT	(DRIV) = binary drive number
;
;	EXT	A = ascii for drive number
;
DRVASC	LD	A,(DRIV)	;get binary drive
	ADD	A,'0'		;make it ascii
	RET			;that's all
;
	PAGE
;
;	$SETNMI	- setup for non-maskable disk interrupts
;
;	ENT	BC = disk buffer
;		DE = track sector
;
;	EXT	NMI set for I/O
;		HL = buffer address
;
;	NOTE	this if for the Mod III ONLY!
;
;iii*
	IF	MODIII
SETNMI	LD	(BUFPAS),BC	;save buffer pointer
	LD	(SECPAS),DE	;save track/sector
;
	LD	HL,NMIRET	;non-maskable return
	LD	(404AH),HL	;set NMI vector
;
	LD	H,B		;pass buffer to HL
	LD	L,C
;
	LD	A,(DRIVE)	;get drive bits
	AND	0FH		;mask low bits
	LD	C,A		;save it here
;
;	check for double density
;
	LD	A,(FLAGB)	;get system flag B
	BIT	4,A		;double den available?
	JR	NZ,GETNMIB	;go if none
;
	BIT	6,(IY+6)	;double den disk?
	JR	Z,GETNMIB	;go if not
;
	LD	A,D		;get track
	OR	A		;on track 0?
	JR	NZ,SETNMIP	;set double den
;
;	double density track 0?
;
	BIT	7,(IY+6)	;double den 0?
	JR	Z,GETNMIB	;go if not
;
;	set double density bit
;
SETNMIP	SET	7,C		;double den bit
;
;	check for selection of second side
;
GETNMIB	LD	A,(IY+5)	;side 2 this access?
	RLCA			;align bit
	RLCA
	RLCA
	AND	10H		;bit 4 only
	OR	C		;combine head select
	LD	C,A		;update
;
;	check for write pre-comp
;
	LD	A,D		;check track?
	CP	16H		;for write pre-comp
	JR	C,GETNMIC	;go if below
;
	SET	5,C		;set write pre-comp
;
;	save resulting byte
;
GETNMIC	LD	A,C		;get result
	LD	(DRIVE),A	;setup for drive select
	OUT	(0F4H),A	;give to FDC select
;
;	setup registers for I/O
;
	OR	40H		;set wait states
	LD	D,A		;pass here
	LD	BC,00F3H	;B=counter, C=xfer port
	LD	E,2		;for bit 1 test on I/O
;
	LD	A,0C0H		;activate nmi
	OUT	(0E4H),A	;ON!
;
	IN	A,(0F0H)	;clear FDC status reg.
	DI			;disable for transfer
	RET			;done!
;
;	return vector for NMI interrupt on disk I/O
;
NMIRET	XOR	A		;disable NMI
	OUT	(0E4H),A	;OFF!
	LD	(TEMPFF),HL	;save last byte address+1
	LD	HL,RETNMI	;point to RETN
	LD	(404AH),HL	;for non-disk NMI's
;
	POP	HL		;dummy to restore stack
	LD	BC,(BUFPAS)	;restore buffer
	LD	DE,(SECPAS)	;restore track/sector
	INC	B		;bump buffer pointer
;
	IN	A,(0F0H)	;read status
	LD	(RESULT),A	;save the direct result
;
	CALL	RESFDC		;reset FDC
	EI			;can enable now
	RET			;done, A = I/O status
	ENDIF
;iii*
;
RESELEC	LD	A,(DRIVE)	;get bit pattern
;i*
	IF	MODI
	LD	(37E1H),A	;FDC select reg I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	OUT	(0F4H),A	;FDC select reg III
	ENDIF
;iii*
	RET			;done
;
;	assure fdc READ/WRITE command is in range
;
FIXREAD	PUSH	BC		;save
	CALL	FIXSET		;get IBM flag in B
	LD	A,B		;get result
	OR	80H		;create command
	LD	(RDTYPE),A	;save it
	POP	BC		;unstack
	RET			;done
;
FIXWRIT	PUSH	BC		;save
	CALL	FIXSET		;get IBM flag in B
	LD	A,(WRTYPE)	;get write type
	AND	3		;low 2 bits
	AND	C		;set bit 1/0
	OR	B		;adjust it
	OR	0A0H		;create command
	LD	(WRTYPE),A	;save it
	POP	BC		;unstack
	RET			;done
;
FIXSET	EQU	$
;i*
	IF	MODI
	LD	BC,0803H	;B=IBM bit, C=AM bits
	BIT	6,(IY+6)	;double density disk?
	RET	Z		;nope, return
	BIT	7,(IY+6)	;double track 0?
	JR	NZ,FIXSETD	;yes, go!
	INC	D		;on track 0?
	DEC	D
	RET	Z		;yes, have flags
	ENDIF
;i*
;
FIXSETD	LD	BC,0001H	;B=IBM bit, C=AM bit
	RET			;done
;
;	adjust DE for relative sectoring
;	leave original on stack below last call
;
DDOSFIX	POP	AF		;get caller address
	PUSH	DE		;save track/sector
	PUSH	AF		;leave vector back
;
	BIT	4,(IY+6)	;available?
	JP	Z,SETSIDE	;nope, setup for side
	BIT	3,(IY+6)	;engaged?
	JP	Z,SETSIDE	;nope, continue
;
	PUSH	HL		;need for math
	PUSH	BC
	LD	L,D		;get track
	LD	H,0		;HL = track
	LD	D,H		;MSB = 0
	LD	A,10		;10 sectors / track rel.
	CALL	DMULT		;multiply it
	ADD	HL,DE		;add sector
	LD	A,18		;18 sector / track phys.
	CALL	DDIVD		;divide it
	LD	D,L		;pass track
	LD	E,A		;pass sector
;
	POP	BC		;unstack
	POP	HL
	BIT	5,(IY+6)	;track 0 available?
	JR	Z,SETSIDE	;yes, go!
	INC	D		;else bump over it
	JR	SETSIDE		;continue
;
;	setup side depending on # sides
;
SETSIDX	RES	1,(IY+5)	;set side 0
	LD	A,(IY+5)	;get result
	ADD	A,A		;shift left one
	AND	2		;save bit 1 only
	OR	(IY+5)		;combine mask
	LD	(IY+5),A	;re-save result
	RET			;done
;
SETSIDE	RES	1,(IY+5)	;set side 0 this access
	INC	D		;on track 0?
	DEC	D
	LD	A,(IY+8)	;highest sector 0
	JR	Z,SETSIDA	;continue if yes
	LD	A,(IY+9)	;highest sector disk
SETSIDA	CP	E		;beyond side 0?
	JR	NC,SETSIDB	;go if not
	INC	A		;adjust to # sectors/trk
	LD	(SETSIDX),A	;save it
	LD	A,E		;get sector
	SUB	'$'		;adjust to side 2
SETSIDX	EQU	$-1
	LD	E,A		;resulting sector
	SET	1,(IY+5)	;set side 2 this access
;
SETSIDB	EQU	$
;i*
	IF	MODI
	LD	A,(DRIV)	;get binary drive
	CALL	SETDRV		;setup for side 2
	ENDIF
;i*
	JP	RESFDC		;reset fdc
;
;	compute relative tracks from physical tracks
;
RELTKS	LD	A,(IY+0)	;get physical track count
	LD	(IY+1),A	;save as relative
	BIT	4,(IY+6)	;relative available?
	RET	Z		;nope, done!
	BIT	3,(IY+6)	;relative engaged?
	RET	Z		;nope, done!
;
	PUSH	HL		;save it
	PUSH	BC		;save
	LD	C,A		;pass phys tracks
	LD	L,(IY+9)	;get highest sector disk
	INC	L		;L = # sectors
	LD	H,0		;HL = # sectors
	CALL	MULT		;HL = # sectors*# tracks
	LD	C,10		;divide by 10
	CALL	DIVD		;divide by it double prec
	BIT	5,(IY+6)	;track 0 available?
	JR	Z,RELTKSA	;go if yes
	DEC	L		;less track 0
RELTKSA	LD	(IY+1),L	;save rel tracks
	POP	BC		;restore
	POP	HL		;restore
	RET			;done, adjusted
;
