SUU4   ; suu4/asm
 SFMTW	XOR	A		;format without erase
 	LD	(PUT10),A	;allow reading
 	LD	(GET10),A	;allow writing
 	LD	(STARTTRK),A	;start track of 0
 	INC	A
 	LD	(FMTYPE),A	;indicate without erase
 	LD	(HASDATFLG),A	;don't pause if data
 	CALL	GETDRIVES	;ask for drives
 	LD	BC,CKFMT0	;routine
 	LD	DE,SFMT2	;exit vector
 	JP	DRVCOMM		;do all drives
 CKFMT0	OR	A
 	CALL	GETTYPEA	;get drive type A
 	RES	4,A		;turn off relative secs
 	SCF
 	JP	GETTYPEA	;put back in table
 SFMT	XOR	A
 	LD	(FMTYPE),A	;standard format
 	LD	(HASDATFLG),A	;allow pause if data
 	CALL	INITGAT		;zero out the gat table
 	CALL	GETDRIVES	;ask for drives
 	LD	A,(FMTYPE)	;get type
 	DEC	A
 	CALL	NZ,GETNAMEDATE	;ask for name, date, etc
 SFMT2	LD	DE,FMTLOOP	;routine for all drives
 	LD	BC,SFMT3	;exit vector
 	JP	DRVCOMM		;do all drives
 GETDVH	LD	A,(TYPEB)
 	SET	3,A		;default to drive 0
 	LD	(TYPEB),A
 	RET
 GETDRIVES	RST	8
 	DB	10,0
 	CALL	INITDRV		;de-activate drives
 GETDVB	RST	8
 	DB	1EH,'Drive(s) ? ',0
 	LD	B,30		;30 char input
 	RST	10H		;from keyboard
 	JR	Z,GETDVH	;nill
 	CALL	POSHL		;position to input
 	JR	C,GETDVH	;nill
 GETDLP	CALL	POSHL
 	RET	C
 	CALL	FIGDRV		;see if drive type
 	JR	C,GETDVB	;invalid
 	PUSH	HL
 	LD	HL,TYPEB
 	LD	A,(DRIV)	;activate this drive
 	ADD	A,L
 	LD	L,A
 	SET	3,(HL)
 	POP	HL
 	JR	GETDLP
 GETNAMEDATE	RST	8
 	DB	10,0
 ANAME	RST	8
 	DB	1EH,'Name ? ',0
 	LD	B,8
 	RST	10H
 	JR	Z,ANAME1
 	PUSH	HL
 	PUSH	BC
 	LD	HL,SPACES
 	LD	DE,GATBUFF+0D0H
 	LD	BC,8
 	LDIR
 	POP	BC
 	POP	HL
 	LD	DE,GATBUFF+0D0H
 	LD	C,B
 	LD	B,0
 	LDIR
 ANAME1	RST	8
 	DB	10,0
 ADATE	RST	8
 	DB	1EH,'Date ? ',0
 	LD	B,8
 	RST	10H
 	JR	Z,ADATE1
 	PUSH	HL
 	PUSH	BC
 	LD	HL,SPACES
 	LD	DE,GATBUFF+0D8H
 	LD	BC,8
 	LDIR
 	POP	BC
 	POP	HL
 	LD	DE,GATBUFF+0D8H
 	LD	C,B
 	LD	B,0
 	LDIR
 ADATE1	RST	8
 	DB	10,0
 APASS	RST	8
 	DB	1EH,'Master Password ? ',0
 	LD	B,8
 	RST	10H
 	JR	Z,APASS1
 	PUSH	HL
 	PUSH	BC
 FXPS	LD	A,(HL)
 	CALL	UCASE
 	LD	(HL),A
 	INC	HL
 	DJNZ	FXPS
 	POP	BC
 	POP	HL
 	CALL	CODE
 	LD	(GATBUFF+0CEH),HL
 APASS1	RST	8
 	DB	10,0
 	OR	A
 	CALL	GETDIR		;load DE with dir trak
 	CALL	GETTKS		;get A with total tracks
 	CP	D		;is dir within ?
 	JR	C,FORCONF	;go if yes
 	JR	Z,FORCONF	;go if equal
 ACONF	RST	8
 	DB	1EH,'Use Configuration ? ',0
 	XOR	A
 	LD	(IFVERF),A
 	LD	(IFACONF),A
 	LD	(STARTTRK),A
 	LD	B,3
 	RST	10H
 	RET	Z
 	CALL	POSHL
 	RET	C
 ACONFF	CALL	POSHL
 	JR	C,FORCONF
 	CALL	UCASE
 	CP	'!'		;overwrite existing data
 	JR	Z,ACONFG
 	CP	'Y'
 	JR	Z,ACONFYES
 	CP	'N'
 	JR	Z,ACONFNO
 	CP	'*'
 	JR	Z,ACONFVN	;skip verify cycle
 	JR	ACONF
 ACONFYES	LD	A,1
 	LD	(IFACONF),A
 	INC	HL
 	JR	ACONFF
 ACONFNO	XOR	A
 	LD	(IFACONF),A
 	JR	ACONFYES+5
 ACONFVN	LD	A,1
 	LD	(IFVERF),A
 	JR	ACONFYES+5
 FORCONF	LD	A,0
 IFACONF	EQU	$-1
 	DEC	A
 	RET	Z
 	LD	DE,CONFC
 	LD	BC,RET
 	JP	DRVCOMM
 ACONFG	LD	A,1
 	LD	(HASDATFLG),A	;has data prompt
 	JR	ACONFYES
 CONFC	RST	8
 	DB	10,0
 	CALL	DRVASC
 	LD	(CONFCD),A
 CONFC1	RST	8
 	DB	1EH,':'
 CONFCD	DB	'x Dos, Tks, Dir, St Tk ? ',0
 	XOR	A
 	LD	(STARTTRK),A
 	CALL	GETTKS		;get track count
 	SRL	A		;half it
 	SCF			;indicate this as the
 	CALL	GETDIR		;default directory trak
 	LD	B,20
 	RST	10H
 	RET	Z
 	CALL	POSHL
 	RET	C
 	CALL	SETSIDE		;see if 2'nd side
 	CALL	CKCONF		;see if dos specifier
 	JR	NZ,CKTTKK	;go if no
 	CALL	DENSELSET	;put into table if yes
 	INC	HL
 	CALL	POSHL
 	JR	C,CKDIRTK
 	CALL	VALUE		;get track count
 	JR	C,CONFC1
 	JR	NZ,CONFC1
 	SCF
 	CALL	GETTKS		;put into table
 	CALL	POSHL
 	JR	C,CKDIRTK
 CKTTKK	CALL	VALUE		;get directory track
 	JR	C,CONFC1
 	JR	NZ,CONFC1
 	SCF
 	CALL	GETDIR		;put into table
 CKDIRTK	OR	A
 	CALL	GETDIR
 	CALL	DDOSTRACKS	;get relative tracks
 	CP	D
 	JR	C,CONFC1	;invalid track
 	JR	Z,CONFC1
 	CALL	POSHL
 	RET	C
 	CALL	VALUE
 	JR	C,CONFC1
 	JR	NZ,CONFC1
 	LD	(STARTTRK),A	;starting format track
 	RET
 INITGAT	LD	HL,GATBUFF
 	OR	A
 	CALL	GETTYPEA
 	BIT	2,A
 	LD	A,0FFH		;fill with FF for non
 	JR	Z,IGH		;trs iii
 	XOR	A		;fill with 0 for trsiii
 IGH	LD	B,0
 	CALL	FILL
 	LD	HL,DEFGAT	;default bytes
 	LD	DE,GATBUFF+0CBH	;where they go
 	LD	BC,21
 	LDIR
 	LD	A,13		;auto command nil
 	LD	(DE),A
 	CALL	DPASSV		;default master password
 	LD	(GATBUFF+0CEH),HL	;to the gat
 RET	RET
 DEFGAT	DB	22H,0,0
 	DW	42E0H
 FMTNAME	DB	'DataDisk'
 FMTDATE	DB	'00/00/00'
 SPACES	DB	'                '
 FMTLOOP	OR	A
 	CALL	GETTYPEA
 	BIT	5,A
 	JR	Z,CMTFMTLOOP
 	LD	A,17
 	SCF
 	CALL	GETDIR
 CMTFMTLOOP	LD	HL,GATBUFF
 	CALL	FILLGAT
 FORMIT	CALL	INITCOUNT	;clear counter A
 	CALL	INITACOUNT	;clear counter B
 	CALL	DSTAT		;check disk status
 	RET	NZ		;bad if drive not ready
 	LD	BC,BUFFER+2
 	LD	(PS91X),BC	;dir track locate in boot
 	LD	DE,0
 	OR	A
 	CALL	GETTYPEA
 	BIT	2,A
 	JR	Z,IYCV
 	LD	E,1
 	LD	BC,BUFFER+1
 	LD	(PS91X),BC	;for trsiii
 IYCV	OR	A
 	CALL	GETTYPEA
 	LD	(TYPSAVEI),A	;save type of dos
 	RST	8
 	DB	10,0
 	LD	BC,BUFFER
 	CALL	READ		;read the lowest sector
 	JR	Z,ISTHRD	;go if good
 	CALL	FLIPDEN		;try other density
 	CALL	READ		;read this sector
 ISTHRD	CALL	Z,HASDATA	;if has data
 	RET	C		;C = skip this drive
 	CALL	RESTORE		;move head to track 0
 	RET	NZ		;error in seek
 	LD	HL,FBUFF	;format buffer
 	LD	(FMTBUFF),HL	;save for build
 	XOR	A
 	LD	(TEMP0),A
 	CALL	CLRBUFF		;zero the whole buffer
 	LD	A,(TYPSAVEI)
 	RES	4,A		;turn off relative sects
 	SCF
 	CALL	GETTYPEA	;put back in table
 	LD	A,0
 STARTTRK	EQU	$-1
 	OR	A		;see if start at 0
 	JR	Z,FMTLP		;go if yes
 	LD	D,A		;else put here for seek
 	LD	(TEMP0),A
 	CALL	SEEK		;move the head
 	RET	NZ		;error on seek
 FMTLP	LD	A,0
 FMTYPE	EQU	$-1
 	DEC	A
 	CALL	Z,GET10		;read all sectors on trak
 	LD	HL,FBUFF
 	LD	(FMTBUFF),HL
 	CALL	BUILDTRK	;create the format image
 	CALL	SHOFMT		;write to disk
 	RET	NZ		;error
 	LD	A,(FMTYPE)
 	DEC	A
 	CALL	Z,PUT10		;write sectors back
 	CALL	GETTKS		;get track count
 	LD	E,A		;save for compare
 ;i*
 	IF	MODI
 	LD	A,(37EDH)	;get FDC track reg
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0F1H)	;track reg mod III
 	ENDIF
 ;
 	DEC	E
 	CP	E		;end of disk?
 	JR	Z,FMTDONEY	;finished, verify
 	CALL	STEPIN		;move head in
 	LD	A,(TEMP0)
 	INC	A
 	LD	(TEMP0),A	;real track
 	IF	MODI
 	LD	(37EDH),A	;put into FDC reg
 	ENDIF
 	IF	MODIII
 	OUT	(0F1H),A	;FDC mod III
 	ENDIF
 	JR	FMTLP		;else continue
 FMTDONEY	LD	A,0
 TYPSAVEI	EQU	$-1
 	SCF
 	CALL	GETTYPEA	;restore type for verify
 	LD	A,(FMTYPE)	;backup ?
 	CP	2
 	RET	Z		;return if yes
 	CP	5
 	RET	Z
 	LD	A,0
 IFVERF	EQU	$-1
 	DEC	A
 	JR	Z,IFVERFSKP	;if to be verified
 	LD	A,(STARTTRK)	;get starting track
 	LD	D,A		;give to DE
 	LD	E,0
 	OR	A
 	CALL	GETTYPEA
 	BIT	2,A
 	JR	Z,FMTDONEL
 	LD	E,1
 FMTDONEL	LD	BC,BUFF1	;I/O buffer
 	CALL	SHOVERIFYX	;read it twice
 	SCF			;clear carry
 	CCF
 	CALL	NZ,LOKIT	;lockout the gran
 	CALL	NEXSEC		;do next sector
 DSKND	JR	NC,FMTDONEL	;do some more
 	LD	A,(FMTYPE)
 	CP	1
 	JP	Z,FMTWDON	;don't write directory
 IFVERFSKP	LD	A,(STARTTRK)
 	OR	A
 	JR	Z,CONFSK	;write the directory
 	RST	8
 	DB	10,0
 AKSHR	RST	8
 	DB	1EH,'Write Directory and Boot ? ',0
 	LD	B,3
 	RST	10H
 	JR	Z,CONFSK
 	CALL	UCASE
 	CP	'Y'
 	JR	Z,CONFSK
 	CP	'N'
 	JR	NZ,AKSHR
 	RET
 CONFSK	LD	BC,BUFF1
 	CALL	ZBUFF		;zero it out
 	PUSH	BC		;save for a minute
 	LD	D,B		;give to HL
 	LD	E,C
 	LD	HL,NSBOOT	;non-system boot
 	LD	BC,42		;length of boot
 	LDIR
 	POP	BC		;get buffer back
 	OR	A
 	CALL	GETDIR
 	LD	A,D
 	LD	(BUFF1+2),A
 	OR	A
 	CALL	GETTYPEA
 	BIT	1,A
 	JR	Z,CUBP
 	BIT	7,A
 	JR	Z,CUBP
 	LD	A,(BUFF1+2)
 	OR	80H		;set for dos+
 	LD	(BUFF1+2),A
 CUBP	LD	DE,0
 	OR	A
 	CALL	GETTYPEA
 	BIT	2,A
 	JR	Z,CUBPZ
 	LD	E,1
 	LD	A,(BUFF1+2)
 	LD	(BUFF1+1),A
 	XOR	A
 	LD	(BUFF1+2),A
 	LD	A,0FEH
 	LD	(BUFF1),A
 CUBPZ	CALL	COMPDATA	;data write byte
 	LD	(WRTYPE),A
 	RST	30H		;write the sector
 	CALL	C,SKPBOOT	;couldn't write the boot
 	OR	A
 	CALL	GETTYPEA
 	BIT	4,A		;adjust?
 	JR	Z,SKP913
 	SCF
 	PUSH	AF		;save type
 	RES	4,A		;turn off relative secs
 	CALL	GETTYPEA
 	LD	BC,BUFF1
 	RST	30H		;write real boot
 	POP	AF
 	CALL	GETTYPEA
 SKP913	OR	A
 	CALL	GETDIR
 	PUSH	AF		;save sector count
 	LD	HL,GATBUFF	;GAT buffer
 	SET	0,(HL)		;allocate boot sector
 	PUSH	HL		;save for BC
 	LD	L,D		;point to directory track
 	LD	(HL),0FFH	;allocated
 	OR	A
 	CALL	GETTYPEA
 	BIT	2,A
 	JR	Z,GOTZDHR
 	LD	(HL),3FH
 GOTZDHR	POP	BC		;BC => I/O buffer
 	CALL	COMPDIR
 	LD	(WRTYPE),A
 	RST	30H		;do it
 	JP	C,SKPDIR	;restore stack
 	LD	BC,BUFF1	;now use buffer1
 	CALL	ZBUFF		;clear it out
 	OR	A
 	CALL	GETTYPEA
 	BIT	2,A
 	JR	NZ,SKPHTT
 	LD	A,0A2H		;boot code
 	LD	(BC),A
 	LD	A,0C4H		;directory hit byte
 	LD	(BUFF1+1),A	;save this
 	JR	SKPHTIT
 SKPHTT	EXX
 	LD	HL,BUFF1+0E0H	;clear out the system
 	LD	DE,BUFF1+0E1H	;area used by trsiii
 	LD	(HL),-1
 	LD	BC,1FH		;32 bytes in table
 	LDIR
 	LD	A,1		;for BOOT allocation
 	LD	(BUFF1+0E0H),A
 	XOR	A		;location of dir
 	LD	(BUFF1+0E1H),A
 	EXX
 SKPHTIT	CALL	NEXSEC
 	RST	30H		;write the sector
 	JP	C,SKPDIR	;error
 	PUSH	DE		;save track/sector
 	LD	DE,BUFF1
 	LD	BC,BUFF1
 	CALL	ZBUFF
 	PUSH	DE
 	OR	A
 	CALL	GETTYPEA
 	BIT	2,A
 	JR	NZ,NOTENTZ
 	LD	HL,BOOTENT	;BOOT/SYS entry
 	LD	BC,20H		;32 bytes long
 	LDIR
 NOTENTZ	POP	BC
 	POP	DE
 	CALL	NEXSEC
 	RST	30H		;write the sector
 	JR	C,SKPDIR	;error
 	PUSH	DE
 	LD	A,D		;get track
 	LD	(DIRTKK),A	;put into directory entry
 	OR	A
 	CALL	GETTYPEA
 	LD	B,1
 	BIT	7,A
 	JR	Z,DTYDIR
 	BIT	4,A
 	JR	NZ,DTYDIR
 	LD	B,5
 	BIT	2,A
 	JR	NZ,DTYDIR
 	LD	B,2
 DTYDIR	CALL	GETTYPEB
 	BIT	2,A
 	JR	Z,DYTDIR
 	INC	B
 	SLA	B
 	DEC	B
 DYTDIR	LD	A,B
 	LD	(DIRTKK+1),A
 	LD	DE,BUFF1
 	LD	BC,BUFF1
 	CALL	ZBUFF
 	OR	A
 	CALL	GETTYPEA
 	BIT	2,A
 	JR	NZ,SKZYR
 	PUSH	DE
 	LD	HL,DIRENT	;directory entry
 	LD	BC,20H		;32 bytes
 	LDIR
 	POP	BC
 SKZYR	POP	DE
 	CALL	NEXSEC		;next sector
 	RST	30H		;write it out
 	JR	C,SKPDIR	;error
 	POP	AF		;get counter
 	DEC	A		;-4 for sectors written
 	DEC	A
 	DEC	A
 	DEC	A
 PDIRL	PUSH	AF
 	CALL	NEXSEC		;advance sector
 	LD	BC,BUFF1	;use this buffer
 	CALL	ZBUFF		;zero the buffer
 	RST	30H		;write the sector
 	JR	C,SKPDIR	;error
 	POP	AF
 	DEC	A
 	JR	NZ,PDIRL
 SKPDD	CALL	SHOCOUNT	;display error counter
 	RST	8
 	DB	'Granules LOCKED OUT.',0
 	RET
 SKPDIR	RST	8
 	DB	1EH,'Cannot Write Directory !',0
 	JR	SKPDRD
 SKPBOOT	RST	8
 	DB	1EH,'Cannot Write BOOT !',10,0
 	RET
 SKPBOOT1	RST	8
 	DB	1EH,'Cannot Write ALTERNATE BOOT !',10,0
 	RET
 FMTWDON	CALL	SHOCOUNT	;show counter
 	RST	8
 	DB	'sectors lost.',0
 	CALL	SHOACOUNT	;show 2nd counter
 	RST	8
 	DB	'sectors could NOT be verified.',10,0
 	JP	UPDIRX		;update the directory
 SKPDRD	CALL	DRVASC		;drive to ascii
 	LD	(SKD),A		;save in the string
 	RST	8
 	DB	' on Drive '
 SKD	DB	'0.',0
 	JP	SKPDD
 BUILDTRK	OR	A
 	CALL	GETTYPEA
 	BIT	7,A		;check which density
 	JR	Z,GOTORD88
 	LD	BC,DPATTERN	;double density
 	LD	HL,DORDER2	;trs-dos III order
 	BIT	2,A
 	JR	NZ,GOTORD
 	LD	HL,DORDER
 	BIT	3,A
 	JR	NZ,GOTORD
 ;i*
 	IF	MODI
 	LD	A,(37EDH)
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0F1H)
 	ENDIF
 ;
 	OR	A
 	JR	NZ,GOTORD
 GOTORD88	LD	HL,ORDER	;s density
 	LD	BC,SPATTERN	;s den pattern
 GOTORD	LD	(PATTUSE),BC	;save pattern pointer
 	LD	C,(HL)		;get sectors/track
 	INC	HL
 	LD	E,(HL)		;get sector order table
 	INC	HL
 	LD	D,(HL)
 	INC	HL
 	CALL	ORDNEW		;3 rotations
 	PUSH	DE		;save it
 	LD	DE,(FMTBUFF)	;format buffer
 	EX	DE,HL		;hl => buffer, de =>table
 	CALL	MOVEIN		;move the bytes in
 	LD	(DESVE),DE	;save DE position
 SECLP	CALL	MOVEIN
 	CALL	MOVEIN
 	LD	(HL),0FEH	;ID header
 	INC	HL
 ;i*
 	IF	MODI
 	LD	A,(37EDH)
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0F1H)
 	ENDIF
 ;
 	LD	(HL),A		;track
 	INC	HL
 	LD	(HL),0		;head
 	INC	HL
 	EX	(SP),HL		;get sector order
 	LD	A,(HL)		;get sector number
 	INC	HL
 	EX	(SP),HL		;put it back
 	LD	(HL),A		;put in buffer
 	INC	HL
 	LD	(HL),1		;length of sector
 	INC	HL
 	LD	(HL),0F7H	;generate CRC
 	INC	HL
 	CALL	MOVEIN
 	CALL	MOVEIN
 	CALL	MOVEIN
 	OR	A		;clear carry
 	CALL	GETTYPEA
 	BIT	2,A
 	LD	A,0FBH		;data address mark
 	JR	Z,AO103
 	LD	A,0F8H		;DAM for trsiii
 AO103	LD	(HL),A
 	INC	HL
 	PUSH	DE
 	EX	DE,HL		;DE => buffer
 	LD	HL,0		;pattern pointer
 PATTUSE	EQU	$-2
 	LD	B,16		;16 lines * 16 bytes
 PATTPUT	PUSH	BC		;save it
 	PUSH	HL		;save pattern
 	LD	BC,16		;16 bytes each
 	LDIR			;move to buffer
 	POP	HL		;back
 	POP	BC
 	DJNZ	PATTPUT
 	EX	DE,HL		;HL back to buffer
 	POP	DE
 	LD	(HL),0F7H	;CRC for data
 	INC	HL
 	CALL	MOVEIN
 	LD	DE,0
 DESVE	EQU	$-2
 	DEC	C		;sector count -1
 	JR	NZ,SECLP	;sector loop
 	INC	SP		;adjust stack
 	INC	SP
 	DEC	DE
 	LD	A,(DE)
 	CALL	FILL		;fill to end byte
 	LD	BC,(FMTBUFF)	;point to the buffer
 	RET			;done
 MOVEIN	LD	A,(DE)		;get table byte
 	LD	B,A		;# bytes to go
 	INC	DE
 	LD	A,(DE)		;byte to fill with
 	INC	DE		;point to next one
 FILL	LD	(HL),A		;put in buffer
 	INC	HL
 	DJNZ	FILL
 	RET
 ORDER	DB	10		;sectors/track
 	DW	ORDERS		;single sector order
 	DB	1FH,0FFH	;count,byte
 	DB	3,0
 	DB	3,0
 	DB	0BH,0FFH
 	DB	3,0
 	DB	3,0
 	DB	0BH,0FFH	;gaps
 DORDER	DB	18		;sectors/track
 	DW	ORDERD		;double sector order
 	DB	3EH,4EH
 	DB	0CH,0
 	DB	3,0F5H
 	DB	16H,4EH
 	DB	0CH,0
 	DB	3,0F5H
 	DB	16H,4EH
 DORDER2	DB	18
 	DW	ORDERD2
 	DB	3EH,4EH
 	DB	0CH,0
 	DB	3,0F5H
 	DB	16H,4EH
 	DB	0CH,0
 	DB	3,0F5H
 	DB	16H,4EH
 ORDERS	DB	0,5,1,6,2,7,3,8,4,9
 ORDERD	DB	0,6,12,1,7,13,2,8,14
 	DB	3,9,15,4,10,16,5,11,17
 ORDERD2	DB	1,4,7,0AH,0DH,10H,2,5,8
 	DB	0BH,0EH,11H,3,6,9,0CH,0FH,12H
 HASDATA	CALL	DRVASC		;get ascii drive
 	LD	(NXW1),A	;save in string
 	RST	8
 	DB	'Drive '
 NXW1	DB	'x HAS DATA !',10,0
 	LD	A,0		;if ok to overwrite
 HASDATFLG	EQU	$-1
 	OR	A		;Z = continue
 	RET	NZ		;write anyway
 	LD	B,0		;setup single den
 	CALL	DENSELSET
 	LD	BC,BUFFER	;where to read data
 	LD	A,(BUFFER+2)	;where dir track is
 PS91X	EQU	$-2
 	LD	D,A		;pass here
 	LD	E,0		;read sector 0
 	OR	A
 	CALL	DDOSTRACKS
 	CP	D
 	CCF
 	CALL	NC,GETDIR
 	CALL	READ		;read it
 	JR	NZ,TRYHV0
 	EX	AF,AF'		;check DAM
 	AND	3
 	JP	NZ,TRYHAV	;have a directory
 	JP	TRYHAVZ
 TRYHV0	LD	B,8CH		;try TRSIII
 	CALL	DENSELSET
 	LD	BC,BUFFER
 	CALL	READ		;try this one
 	JR	NZ,TRYHV1	;no good
 	EX	AF,AF'		;check for read protect
 	AND	3		;1 bit must be set
 	JP	NZ,TRYHAV	;have it
 	JP	TRYHAVZ
 TRYHV1	LD	B,89H		;ldos double
 	CALL	DENSELSET
 	LD	BC,BUFFER
 	CALL	READ
 	JR	NZ,TRYHV2	;try again
 	EX	AF,AF'
 	AND	3
 	JP	NZ,TRYHAV
 	JP	TRYHAVZ
 TRYHV2	LD	B,8CH
 	CALL	DENSELSET	;setup this dos type
 	LD	E,1
 	LD	BC,BUFFER
 	CALL	READ		;read the sector
 	JR	NZ,TRYHV3
 	EX	AF,AF'
 	AND	1
 	JP	Z,TRYHAV
 	JP	TRYHAVZ
 TRYHV3	LD	B,90H
 	CALL	DENSELSET
 	LD	E,0
 	LD	BC,BUFFER
 	CALL	READ
 	JR	NZ,TRYHV4
 	EX	AF,AF'
 	AND	3
 	JR	NZ,TRYHAV
 	JR	TRYHAVZ
 TRYHV4	LD	B,98H
 	CALL	DENSELSET
 	LD	BC,BUFFER
 	CALL	READ
 	JR	NZ,TRYHV5
 	EX	AF,AF'
 	AND	3
 	JR	NZ,TRYHAV
 TRYHAVZ	RST	8
 	DB	10,'Non-Standard Format.',0
 	JP	TRYHV6
 TRYHV5	RST	8
 	DB	10,'Directory unreadable.',0
 	JR	TRYHV6
 TRYHAV	RST	8
 	DB	10,0
 	LD	HL,GATBUFF+0D0H
 	LD	BC,16
 	LD	DE,BUFFER
 	LDIR
 	LD	HL,BUFFER+0D0H
 	LD	BC,16
 	LD	DE,GATBUFF+0D0H
 	LDIR
 	CALL	DISPNAMEDATE
 	LD	HL,BUFFER
 	LD	DE,GATBUFF+0D0H
 	LD	BC,16
 	LDIR
 TRYHV6	RST	8
 	DB	10,0
 TRYHV7	RST	8
 	DB	1EH,'C>ontinue, or Q>uit ? ',0
 	LD	B,1
 	RST	10H
 	RET	Z
 	CALL	UCASE
 	CP	'C'
 	RET	Z
 	CP	'Q'
 	JP	Z,4018H		;cancel
 	JR	TRYHV7		;re-ask
 	LDIR
 TRYHV6	RST	8
 	DB	10,0
 TRYHV7	RST	8
 	DB	1EH,'C>ontinue, or Q>uit ? ',0
 	LD