SUU2   ; suu2/asm
 DISPNAMEDATE	PUSH	HL	;save these
 	PUSH	DE
 	PUSH	BC
 	LD	HL,GET		;unstacker address
 	PUSH	HL		;to the stack
 	LD	HL,GATBUFF+0D0H	;where name is in GAT
 	LD	DE,DISPN	;point to the string
 	LD	BC,8		;8 chars in name
 	PUSH	BC		;save for date
 	LDIR			;move the name
 	POP	BC		;BC = 8
 	LD	DE,DISPD	;point to date string
 	LDIR			;move it there
 	LD	HL,GATBUFF+0D0H	;name again
 	LD	B,8		;length
 DISPXNX	LD	A,(HL)		;check for ascii name
 	INC	HL		;point to next
 	CP	20H		;control code ?
 	JR	C,DISPNONO	;bad if yes
 	CP	0C0H		;tab character ?
 	JR	NC,DISPNONO	;bad if yes
 	DJNZ	DISPXNX		;do all 8
 	RST	8		;display the name/date
 	DB	'Name = '
 DISPN	DB	'xxxxxxxx, Date = '
 DISPD	DB	'xxxxxxxx.',0
 	RET
 DISPNONO	RST	8
 	DB	1EH,'Invalid Name/Date.',0
 	RET
 WHEREDIR	OR	A	;clear carry
 	CALL	GETTYPEA	;drive type table A
 	BIT	7,A		;double den?
 	JR	Z,WHEDIR	;go if no
 	BIT	4,A		;relative secs
 	JR	Z,WHEDIR	;go if no
 	BIT	5,A		;d sided
 	JR	Z,WHEDIR	;go if no
 	SCF
 	JR	WHIDIR		;force default setting
 WHEDIR	LD	DE,0		;point to BOOT sector
 	BIT	2,A		;TRS III?
 	JR	Z,WHEDIRX	;go if no
 	INC	E		;sec 1 is boot sector
 WHEDIRX	LD	BC,BUFFER	;where to load it
 	RST	28H		;read the sector
 	LD	HL,BUFFER+1	;point to 2'nd byte
 	PUSH	AF		;save result of I/O
 	OR	A		;clear carry
 	CALL	GETTYPEA	;get type again
 	BIT	2,A		;TRSIII
 	JR	NZ,WHIDIRZ	;go if yes
 	INC	HL		;else 3'rd byte is it
 WHIDIRZ	POP	AF		;restore error code
 	OR	A		;clear carry
 	CALL	GETTYPEA	;get drive typeA
 	BIT	1,A		;dos+
 	LD	A,(HL)		;read dir track
 	JR	Z,WHIDIR	;go if no
 	RES	7,A		;reset hi bit for dos+
 WHIDIR	CALL	C,DDFFDIR	;if error, get default
 	CP	96+96		;max gat table can hold
 	CCF			;<96+96 is OK
 	CALL	C,DDFFDIR
 	SCF
 	JP	GETDIR		;put dir in table
 DDFFDIR	LD	A,17		;default
 	RET
 RDDIR	LD	BC,GATBUFF	;start of dir read
 	XOR	A		;set z flag to allow boot
 	LD	(RDDIR0),A	;to be read to find dir
 	LD	(BFSAV),BC	;save current buffer
 	CALL	DSTAT		;check drive status
 	SCF			;C = error
 	RET	NZ		;go back if bad
 RDDIRO	LD	HL,0		;start buffer
 BFSAV	EQU	$-2
 	XOR	A		;0
 	LD	(DIRCOUNT),A	;the sector count of dir
 	CALL	GETDIR		;load DE with track sect
 	LD	BC,(BFSAV)	;get buffer
 	LD	IX,DAMBUFF	;store id marks here
 RDDIRI	RST	28H		;read a sector
 	JP	C,RDDIRD	;skip this sector
 	EX	AF,AF'		;save it
 	LD	(IX),A		;get ID type, save here
 	INC	IX		;bump pointer
 ;i*
 	IF	MODI
 	AND	3
 	ENDIF
 ;iii*
 	IF	MODIII
 	AND	1
 	ENDIF
 ;
 	PUSH	AF		;save result
 	OR	A		;clear carry
 	CALL	GETTYPEA	;get type A
 	BIT	2,A		;trsIII?
 	JR	Z,TYS1		;go if no
 	POP	AF		;get DAM back
 	JR	NZ,RDDIRD	;done if not RPT ID
 	JR	TYSCN		;else continue
 TYS1	POP	AF		;get DAM back
 	JR	Z,RDDIRD	;go if not RPT ID
 TYSCN	LD	A,(DIRCOUNT)	;get sector counter
 	INC	A		;add one
 	LD	(DIRCOUNT),A	;put it back
 	LD	(DIRCMP),A	;save for compare
 	OR	A		;clear carry
 	CALL	GETTYPEA	;get type A byte
 	BIT	4,A		;relative sectors ?
 	JR	NZ,CMDCNT7	;check for extended dir
 	BIT	7,A		;double den?
 	JR	Z,CMDCNT7	;go if no, else check
 	PUSH	DE		;save track sector
 	CALL	GETDIR		;A = sectors in dir
 	POP	DE		;restore tk,sec
 	CP	0		;total number in dir?
 DIRCMP	EQU	$-1
 	JR	NZ,CMDCNT7	;read more if not enough
 	OR	1		;else set NZ flag
 	RET
 CMDCNT7	CALL	NEXSEC		;bump the sector
 	JR	NC,RDDIRI	;C = end of disk reached
 RDDIRD	OR	A		;clear carry
 	PUSH	DE		;save track/sec
 	CALL	GETDIR		;get A for sec count
 	POP	DE		;restore track,sec
 	LD	L,A		;save for compare
 	LD	A,(DIRCOUNT)	;get current count
 	CP	L		;test for end
 	JR	C,RDDIR0	;read more if less
 	OR	A		;else clear carry
 RDDIR0	NOP			;RET put here
 	RET	NC		;C = error on 1st try
 	LD	A,0C9H		;disable this for next
 	LD	(RDDIR0),A	;put above
 	CALL	WHEREDIR	;read boot to find dir
 	RET	C		;C = error already
 	JR	RDDIRO		;try to read again
 WRDIR	CALL	COMPDIR		;compute dir write byte
 WRDIRTT	LD	HL,DAMBUFF	;dam for mwrite
 	LD	DE,DAMBUFF+1	;+1 for block move
 	LD	BC,0FFH
 	LD	(HL),A		;fill the buffer
 	LDIR			;do it
 	LD	BC,GATBUFF	;buffer start
 	OR	A		;clear carry
 	CALL	GETDIR		;get DE with trk,sec
 	LD	A,(DIRCOUNT)	;get # sectors
 	LD	L,A		;pass to L for mwrite
 	LD	H,0		;L only needed
 	CALL	DSTAT		;check disk status
 	SCF
 	RET	NZ		;error on status
 	JP	MWRITE		;else multiple write
 SHOWDIR	RST	8
 	DB	7,0		;clear screen
 	LD	A,(DIRPAGE)	;start of 8 sector disply
 	LD	B,A		;for looper
 	LD	C,0		;for even page add
 	LD	HL,GATBUFF+200H	;start of filenames
 	ADD	HL,BC		;point to sector
 	PUSH	HL		;pass to IX
 	POP	IX
 	LD	HL,3C00H	;start of video
 	CALL	SHOFIXDIR
 DIRILP	BIT	4,(IX)		;active entry
 	CALL	Z,ACTIVE1X	;Z = dead file
 	CALL	NZ,ACTIVE1	;NZ = active entry
 	INC	HL		;space to video
 	CALL	SHOWIT		;display filename
 	PUSH	AF		;save if good or not
 	LD	DE,12		;skip over name start
 	ADD	HL,DE		;point to end of name
 	BIT	4,(IX)		;check again
 	CALL	Z,ACTIVE2X	;if dead, show it
 	CALL	NZ,ACTIVE2	;if alive, show different
 	POP	AF		;NZ = invalid filename
 	JR	Z,DDTCON	;go if good
 	PUSH	HL		;save video position
 	LD	E,14		;go back
 DDTXXC	LD	(HL),20H	;erase the erroneous
 	DEC	HL		;data placed there
 	DEC	E
 	JR	NZ,DDTXXC
 	POP	HL		;new cursor posit
 DDTCON	INC	HL		;add some spaces
 	INC	HL
 	INC	HL
 	PUSH	BC		;save from add
 	CALL	IXDIR		;advance IX to next file
 	POP	BC
 	DJNZ	DIRILP		;do 'em all
 	RET
 ACTIVE1
 	IF	MODI
 	LD	(HL),5EH	;arrows mod I
 	ENDIF
 	IF	MODIII
 	LD	(HL),5BH	;brackets mod III
 	ENDIF
 	RET
 ACTIVE2	LD	(HL),5DH
 	RET
 ACTIVE1X	LD	(HL),85H
 	RET
 ACTIVE2X	LD	(HL),8AH
 	RET
 SHOWIT	PUSH	IX		;show a filename
 	PUSH	BC
 	PUSH	HL
 	LD	(CURSOR),HL	;HL enters as cursor
 	LD	HL,STRINGIN	;for display use
 	PUSH	HL
 	LD	B,12		;12 chars long
 	LD	A,20H		;fill with blanks
 	CALL	FILL
 	POP	HL		;start of string
 	LD	B,8		;8 chars in name
 	BIT	4,(IX)		;see if active
 	JR	Z,SHOWL1	;go if dead entry
 	BIT	7,(IX)		;extension?
 	JR	NZ,SHOWLX1	;go if yes
 SHOWL1	LD	A,(IX+5)	;get first name byte
 	CP	20H		;check for displayable
 	JR	Z,SHCON		;skip if blank
 	CALL	CKASCI		;check for valid
 	JR	C,SHBAD		;C = no good
 	LD	(HL),A		;else put in string
 	INC	HL		;bump pointer
 SHCON	INC	IX		;bump name pointer
 	DJNZ	SHOWL1		;do all 8
 	LD	A,(IX+5)	;check for any extension
 	CP	20H		;any?
 	JR	Z,SHOKOX	;go if not
 	CALL	CKASCI		;check for valid char
 	JR	C,SHBAD		;go if no
 	LD	(HL),'/'	;insert extension header
 	INC	HL
 	LD	B,3		;3 chars in extension
 EXTLP	LD	A,(IX+5)	;get a byte
 	CP	20H		;blank?
 	JR	Z,SHOKOX	;skip if yes
 	CALL	CKASCI		;valid
 	JR	C,SHBAD		;go if no
 	LD	(HL),A		;else put in string
 	INC	HL		;bump pointer
 	INC	IX
 	DJNZ	EXTLP		;do all 3
 SHOKOX	RST	8		;display the string
 STRINGIN	DB	'xxxxxxxxxxxx',0
 SHOK	XOR	A		;set Z for OK
 	POP	HL		;restore stack
 	POP	BC
 	POP	IX
 	RET
 SHOWLX1	PUSH	DE		;must save
 	EX	DE,HL		;DE => video
 	LD	HL,SHWTLL	;point to string
 	LD	BC,12		;12 char in filename
 	LDIR			;move it there
 	EX	DE,HL		;HL => end of string
 	POP	DE		;restore now
 	DEC	HL		;point to string msg
 	DEC	HL
 	LD	A,(IX+1)	;get backward link
 	RST	20H		;hex ascii
 	LD	(HL),B		;put on video
 	DEC	HL
 	LD	(HL),C
 	JR	SHOKOX		;finished
 SHBAD	OR	1		;set NZ
 	JR	SHOK+1		;finished
 SHWTLL	DB	'Back DEC=xxH'
 DSKDIR	CALL	GETDRIVES	;ask for several drives
 	LD	DE,DSKDIRGO	;common subroutine
 	LD	BC,GOBACK	;exit vector
 	JP	DRVCOMM		;do all indicated drives
 DSKDIRGO	RST	8
 	DB	10,10,0
 	CALL	RDDIR		;read the directory
 	JP	C,NOTDIR	;error on reading it
 	JP	Z,NOTDIR	;no sectors read
 	XOR	A		;starting 8 sector block
 	LD	(DIRPAGE),A	;save here for showdir
 	CALL	DIRPART		;display name,date,etc
 	CALL	PRESS		;"press enter to continue
 MODIRBAK	RST	8
 	DB	7,0		;clear screen
 	LD	HL,3FC0H	;bottom video line
 	LD	(CURSOR),HL	;stuff the cursor here
 	JP	MODIFYDIR	;full screen dir editor
 DIRDWN	LD	A,(DIRPAGE)	;get current block
 	OR	A		;on 0
 	JP	Z,MODDIRM	;can't go lower
 	SUB	8		;back an 8 sector block
 	LD	(DIRPAGE),A
 	CALL	SHOWDIR		;show new directory
 	JP	MODIFYDIR+3	;continue
 DIRUP	LD	A,(DIRCOUNT)	;going up
 	SUB	10		;8 + gat and hit
 	LD	B,A		;for compare
 	LD	A,(DIRPAGE)	;get current position
 	CP	B		;compare
 	JP	NC,MODDIRM	;no more to show
 	ADD	A,8		;next 8 sector block
 	LD	(DIRPAGE),A
 	CALL	SHOWDIR		;display new entries
 	JP	MODIFYDIR+3	;go editor
 NOTDIR	PUSH	AF
 	CALL	DRVASC		;ascii drive number
 	LD	(NOTDIRDR),A	;to the message
 	RST	8
 	DB	10,'Cannot locate directory on Drive '
 NOTDIRDR	DB	'x.',10,0
 	POP	AF		;save error message
 	RET
 DIRPART	CALL	DRVASC		;ascii drive #
 	LD	(DXTTX),A	;to message
 	RST	8
 	DB	10,10,'Drive '
 DXTTX	DB	'x.  ',0
 	CALL	DISPNAMEDATE	;disk name and date
 	CALL	FIGTRAKS	;get track cnt from gat
 	RST	18H		;to ascii
 	LD	(DE1),A		;to the message
 	LD	(DE1+1),BC
 	OR	A		;clear carry
 	CALL	DDOSTRACKS	;get relative track cnt
 	LD	B,A		;save for count
 	LD	HL,GATBUFF	;start of GAT table
 	LD	A,0D4H		;OPCODE
 	CALL	GETGATCOUNT	;count the bits
 	LD	IY,DE2		;point to string
 	EX	DE,HL		;HL = number
 	CALL	WRLNO		;write 5 char dec ascii
 	CALL	GETENTRIES	;total # of dir records
 	LD	B,0		;counter
 	LD	HL,GATBUFF+200H	;start of filenames
 DE3LOOP	BIT	4,(HL)		;bit 4 set = used
 	CALL	Z,BUMPBBB	;count it if 0
 	PUSH	BC
 	CALL	HLDIR		;advance to next record
 	POP	BC		;bc used by hldir
 	DEC	DE		;# records total -1
 	LD	A,D		;check if done
 	OR	E
 	JR	NZ,DE3LOOP	;go if not
 	LD	A,B		;get total
 	LD	(FREEF),A	;save # free files
 	RST	18H		;to ascii
 	LD	(DE3),A		;to the message
 	LD	(DE3+1),BC
 	RST	8
 	DB	10
 DE1	DB	'xxx Tracks.  '
 DE2	DB	'xxxxx Free Grans.  '
 DE3	DB	'xxx Free Files.',10,0
 	RET
 BUMPB	EXX
 	INC	DE
 	EXX
 	RET
 GETGATCOUNT	LD	C,B	;save counter
 	EXX			;alt set
 	LD	DE,0		;starting count
 	EXX
 	LD	(GETGAT1),A	;pass NC or C opcode
 GETGAT2	LD	D,8		;# bits / byte
 	LD	A,(HL)		;get a byte
 	INC	HL		;point to the next one
 GETGAT3	OR	A		;clear carry first
 	RRA			;rotate out 1 bit
 GETGAT1	CALL	C,BUMPB		;if set,reset, do add
 	DEC	D		;bit counter
 	JR	NZ,GETGAT3	;go if more
 	DEC	C		;byte counter
 	JR	NZ,GETGAT2	;go if more
 	EXX
 	LD	(FREEG),DE	;save total bits
 	RET			;done, DE has it
 CHDNAME	CALL	GETDRIVES	;ask which drives
 	RST	8
 	DB	10,0		;linefeed
 	LD	DE,CHDNAMEGO	;common subroutine
 	LD	BC,GOBACK	;exit vector
 	JP	DRVCOMM		;do all drives specified
 CHDNAMEGO	CALL	RDDIR	;read the directory
 	JP	C,NOTDIR	;go if error
 	JP	Z,NOTDIR	;go if not whole thing
 GOTAGAT	RST	8
 	DB	10,0		;linefeed
 	CALL	DISPNAMEDATE	;show name,date
 	RST	8
 	DB	10,'Name ? ',0
 	LD	B,8		;8 char name
 	RST	10H		;get from keyboard
 	JR	Z,ASKNEWDATE	;skip if nill
 	EXX
 	LD	HL,GATBUFF+0D0H	;put into GAT table
 	LD	A,20H		;zero out previous
 	LD	B,8		;for 8 chars
 	CALL	FILL		;clear it
 	EXX
 	LD	DE,GATBUFF+0D0H	;where in GAT it goes
 	LD	C,B		;B = count
 	LD	B,0		;BC = count
 	LDIR			;move new name
 ASKNEWDATE	RST	8
 	DB	10,'Date ? ',0
 	LD	B,8
 	RST	10H		;ask for new one
 	JR	Z,ASKPASSWD
 	EXX
 	LD	HL,GATBUFF+0D8H	;where this one goes
 	LD	B,8
 	LD	A,20H
 	CALL	FILL
 	EXX
 	LD	DE,GATBUFF+0D8H
 	LD	C,B
 	LD	B,0
 	LDIR
 ASKPASSWD	RST	8
 	DB	10,'Master Password ? ',0
 	LD	B,8		;8 char password too
 	RST	10H		;from keyboard
 	JR	Z,ASKAUTOC	;go if nill
 	CALL	CODE		;code it
 	LD	(GATBUFF+0CEH),HL	;HL = password
 ASKAUTOC	RST	8
 	DB	10,'Auto Command ? ',0
 	LD	B,31		;31 char in auto
 	RST	10H
 	JR	Z,PUTNAMEDATE	;update to disk if nil
 	EXX
 	LD	HL,GATBUFF+0E0H	;where auto goes
 	LD	A,20H		;fill with blanks
 	LD	B,32
 	CALL	FILL
 	EXX
 	LD	DE,GATBUFF+0E0H	;start again
 	LD	C,B
 	INC	C
 	LD	B,0
 	LDIR			;move this one
 PUTNAMEDATE	CALL	COMPDIR	;get dir write byte
 	LD	(WRTYPE),A	;save for sec write
 	OR	A		;clear carry
 	CALL	GETDIR		;load DE with tk,sec
 	LD	BC,GATBUFF	;where GAT is
 	RST	8
 	DB	10,0
 	CALL	DSTAT		;check if drive ready
 	RET	NZ		;cancel if not
 	JP	30H		;write the sector and ret
 ZUNUSE	CALL	GETDRIVES	;ask for drives
 	LD	DE,ZUNUSEGO	;routine
 	LD	BC,GOBACK	;exit vector
 	JP	DRVCOMM		;do all drives indicated
 ZUNUSEGO	RST	8
 	DB	10,0
 	CALL	RDDIR		;read the directory
 	JP	C,NOTDIR	;error
 	JP	Z,NOTDIR	;bad sector count
 	CALL	DIRPART		;display name date
 	CALL	CLEARUNUSE	;clear unused entries
 	CALL	SHOCOUNT	;show the counter
 	RST	8
 	DB	'clear entries.',10,0
 	JP	WRDIR		;write directory back
 ZUNUSEX	PUSH	HL		;zero a single entry
 	PUSH	BC
 	LD	B,20H		;with 32 bytes
 	XOR	A		;of 0's
 	CALL	FILL
 	CALL	ADDCOUNT	;bump counter of empty
 	POP	BC
 	POP	HL
 	RET
 DIRLIST	CALL	GETDRIVES	;ask for which drives
 	RST	8
 	DB	10,0
 	XOR	A		;zero the line counter
 	LD	(LINEC),A
 	LD	DE,DIRLISTGO	;routine
 	LD	BC,GOBACK	;exit vector
 	JP	DRVCOMM		;do all requested drives
 DIRLISTGO	CALL	STAT	;check if drive ready
 	SCF
 	RET	NZ		;return if not
 	RST	8		;linefeed
 	DB	10,10,0		;make it a couple
 	CALL	RDDIR		;read the directory
 	JP	C,NOTDIR	;can't find the bugger
 	SCF
 	JP	Z,NOTDIR	;not enough secs read
 	CALL	DIRPART		;show name etc
 	CALL	ALINE		;advance line counter
 	CALL	ALINE		;for the pause routine
 	CALL	GETENTRIES	;load DE with # files
 	LD	IX,GATBUFF+200H	;start of names
 	LD	HL,(CURSOR)	;where to display it
 	LD	A,3		;# / line counter
 	EX	AF,AF'		;save here
 DIRLISTI	BIT	4,(IX)	;active?
 	JR	Z,DIRLISTD	;nope
 	BIT	7,(IX)		;extension?
 	JR	NZ,DIRLISTD
 	CALL	SHOWIT		;display it
 	JR	NZ,DIRLISTD
 	CALL	PAUSE
 	LD	BC,13		;move over
 	ADD	HL,BC
 	BIT	6,(IX)		;system file?
 	JR	Z,DDAA1
 	LD	(HL),'S'
 DDAA1	INC	HL
 	BIT	3,(IX)		;invisible?
 	JR	Z,DDAA2
 	LD	(HL),'I'
 DDAA2	INC	HL
 	LD	A,(IX)		;password?
 	AND	7
 	JR	Z,DDAA3
 	LD	(HL),'P'
 	INC	HL
 	LD	(HL),'='
 	INC	HL
 	ADD	A,30H		;make it ascii
 	LD	(HL),A		;display prot level
 	JR	DDAA3+2
 DDAA3	INC	HL		;gap between files
 	INC	HL
 	INC	HL
 	INC	HL
 	INC	HL
 	EX	AF,AF'		;one more displayed
 	DEC	A
 	JR	NZ,DIRLISTD-1	;stay on this line
 	LD	(CURSOR),HL	;update cursor position
 	RST	8
 	DB	10,0		;do a linefeed
 	CALL	ALINE		;check for pause
 	LD	HL,(CURSOR)	;new position
 	LD	A,3		;start fresh
 	EX	AF,AF'
 DIRLISTD	CALL	IXDIR	;point to next entry
 	DEC	DE		;total counter -1
 	LD	A,D		;any more left?
 	OR	E
 	JR	NZ,DIRLISTI	;go if any bits on
 	LD	(CURSOR),HL	;save current cursor
 	RET
 ALINE	LD	A,0		;get line count
 LINEC	EQU	$-1
 	INC	A		;bump it
 	LD	(LINEC),A	;save new
 	CP	13		;video almost full?
 	RET	C		;return if not
 	XOR	A		;zero the counter
 	LD	(LINEC),A
 HOLPAU	CALL	INKEY		;wait for enter key
 	CP	13
 	RET	Z		;return if pressed
 	CP	14		;or shift enter
 	RET	Z		;return with this too
 	JR	HOLPAU		;else keep waiting
 MODIFYDIR	CALL	SHOWDIR+3
 	LD	A,(DIRPAGE)	;get current 8 sectors
 	LD	B,A		;save for count
 	LD	C,0		;c = position
 	LD	HL,GATBUFF+200H	;start of filenames
 	ADD	HL,BC		;point to start sector
 	PUSH	HL		;pass to IX
 	POP	IX
 	LD	HL,3C00H	;start of video
 MODDIRO	LD	E,(HL)		;get a character
 MODDIRM	LD	A,8FH		;cursor on
 MODDIRI	LD	(HL),A		;blink it
 	LD	A,12		;counter
 	LD	(MODDIRC),A
 MODDIRW	CALL	INKEY		;any keys?
 	JR	NZ,MODDIRH
 	LD	A,0
 MODDIRC	EQU	$-1
 	DEC	A
 	LD	(MODDIRC),A
 	JR	NZ,MODDIRW
 	LD	A,(HL)
 	CP	8FH
 	JR	NZ,MODDIRM
 	LD	A,E		;put original back
 	JR	MODDIRI
 MODDIRH	LD	(HL),E		;original back
 	CALL	UCASE		;strip lower case
 	CP	'A'		;next drive?
 	RET	Z		;return to next drive
 	CP	'C'		;clear this entry?
 	JR	Z,CLRTHIS	;this one only
 	CP	'K'		;kill it?
 	JR	Z,MODKILL
 	CP	'R'		;restore it
 	JR	Z,MODREST
 	CP	'W'		;write dir back
 	JP	Z,PUTBAKDIR
 	CP	19H		;next 8 sectors up
 	JP	Z,MODIRR
 	CP	18H		;next 8 sectors back
 	JP	Z,MODIRL
 	CP	5DH
 	JP	Z,MODIRLN
 	CP	5EH
 	JP	Z,MODIRRN
 	CP	'N'		;skip over
 	JP	Z,MODIRRN
 	CP	5CH
 	JP	Z,MODIRD
 	CP	5BH
 	JP	Z,MODIRU
 	CP	1AH
 	JP	Z,DIRDWN
 	CP	1BH
 	JP	Z,DIRUP
 	CP	3		;clear key?
 	JP	Z,NOTUNUSED	;zero unused entries
 	JR	MODDIRW		;else wait some more
 CLRTHIS	PUSH	HL
 	LD	HL,GATBUFF+200H
 	LD	(KILLW),HL	;for extension releases
 	POP	HL
 	CALL	KILLIT		;kill the file
 	PUSH	HL
 	CALL	CLRFILEX	;zero it out
 	POP	HL
 	JR	MODREST+3	;move to next one
 MODKILL	PUSH	HL
 	LD	HL,GATBUFF+200H
 	LD	(KILLW),HL	;where it is
 	POP	HL
 	CALL	KILLIT		;kill this
 	JR	MODREST+3
 MODREST	CALL	RESTOREIT	;bring it back
 	PUSH	IX
 	EXX
 	CALL	SHOWDIR		;display it again
 	EXX
 	POP	IX
 	JR	MODIRRN
 MODIRR	PUSH	HL		;save original
 	LD	BC,16		;next video spot
 	ADD	HL,BC
 	LD	A,H
 	CP	40H		;still on the screen
 	JR	NC,MODIRXT
 	CALL	IXDIR		;next dir record
 	EX	(SP),HL
 MODIRXT	POP	HL		;get it back
 	JP	MODDIRO		;continue
 MDABAD	POP	IX		;restore original
 	JR	MODIRXT		;back to wait mode
 MODIRRN	PUSH	HL
 	PUSH	IX
 	LD	BC,16
 	ADD	HL,BC
 	LD	A,H
 	CP	40H
 	JR	NC,MDABAD
 	CALL	IXDIR
 	LD	A,(HL)
 	CP	20H		;on anything?
 	JR	Z,MODIRRN+3	;try next one
 	POP	BC		;remove old IX
 	EX	(SP),HL		;put new HL there
 	JR	MODIRXT
 MODIRL	PUSH	HL
 	LD	BC,-16
 	ADD	HL,BC
 	LD	A,H
 	CP	3CH
 	JR	C,MODIRXT
 	EX	(SP),HL
 	CALL	IXDIRB		;move back to next record
 MODIRLB	JR	MODIRXT
 MODIRLN	PUSH	HL
 	PUSH	IX
 	LD	BC,-16
 	ADD	HL,BC
 	LD	A,H
 	CP	3CH
 	JR	C,MDABAD
 	CALL	IXDIRB
 	LD	A,(HL)
 	CP	20H
 	JR	Z,MODIRLN+3
 	POP	BC
 	EX	(SP),HL
 	JR	MODIRLB
 MODIRU	PUSH	HL
 	LD	BC,-64
 	ADD	HL,BC
 	LD	A,H
 	CP	3CH
 	JR	C,MODIRLB
 	EX	(SP),HL
 MODIRDB	CALL	IXDIRB
 	CALL	IXDIRB
 	CALL	IXDIRB
 	CALL	IXDIRB
 	JR	MODIRLB
 MODIRD	PUSH	HL
 	LD	BC,64
 	ADD	HL,BC
 	LD	A,H
 	CP	40H
 	JR	NC,MODIRLB
 	EX	(SP),HL
 	CALL	IXDIR
 	CALL	IXDIR
 	CALL	IXDIR
 	CALL	IXDIR
 	JR	MODIRLB
 PUTBAKDIR	RST	8
 	DB	7,0		;clear screen
 	CALL	MAKEGAT		;create a GAT
 	CALL	DIRPART		;show name date
 	RST	8
 	DB	10,10,0
 PUTBAKDIRBAD	RST	8
 	DB	1EH,'Write Directory ? ',0
 	LD	B,3
 	RST	10H
 	JR	Z,PUTBAKDIRBAD	;must enter Y
 	CALL	UCASE		;make it upper case
 	CP	'N'
 	JP	Z,MODIRBAK	;skip if No
 	CP	'Y'
 	JR	NZ,PUTBAKDIRBAD
 	RST	8
 	DB	10,0
 	CALL	MAKEGAT		;build the GAT table
 	CALL	MAKEHIT		;build the HIT table
 	CALL	WRDIR		;write the directory
 	JP	MODIRBAK	;finished
 KILLIT	BIT	4,(IX)		;live entry?
 	RET	Z		;already dead
 	BIT	7,(IX)		;extension?
 	RET	NZ		;can't kill that
 	PUSH	IX		;save this
 	POP	IY		;use this one
 KILLOP	RES	4,(IY)		;kill it
 	LD	B,5
 	OR	A
 	CALL	GETTYPEA
 	BIT	2,A
 	JR	Z,KILLLP
 	LD	B,13
 KILLLP	LD	A,(IY+16H)	;get a byte
 	CP	0FFH		;terminator?
 	RET	Z
 	CP	0FEH		;extension?
 	JR	Z,EXTENDS	;get that one too
 	INC	IY		;look at next space
 	INC	IY
 	DJNZ	KILLLP		;go for all 5
 	RET			;bad directory entry
 EXTENDS	LD	A,(IY+17H)	;get DEC of extension
 	AND	1FH		;page displacement
 	PUSH	DE
 	PUSH	HL
 	LD	D,A
 	LD	A,(IY+17H)	;get it again
 	AND	0E0H		;where in the sector
 	LD	E,A
 	LD	HL,GATBUFF+200H
 KILLW	EQU	$-2
 	ADD	HL,DE		;point to it
 	PUSH	HL
 	POP	IY		;next one
 	POP	HL
 	POP	DE
 	JR	KILLOP		;continue
 RESTOREIT	BIT	4,(IX)	;live already?
 	RET	NZ
 	PUSH	IX
 	POP	IY
 RESTOP	SET	4,(IY)		;liven it up
 	LD	B,5		;5 records per extent
 	OR	A
 	CALL	GETTYPEA
 	BIT	2,A		;trsiii?
 	JR	Z,RESLLLP	;go if no
 	LD	B,13		;13 for trsiii
 RESLLLP	LD	A,(IY+16H)	;get first record byte
 	CP	0FFH		;terminator?
 	RET	Z		;done if yes
 	CP	0FEH		;extension ?
 	JR	Z,EXTENDX	;compute it if yes
 	INC	IY		;point to next extent
 	INC	IY
 	DJNZ	RESLLLP		;finish off this record
 	RET
 EXTENDX	LD	A,(IY+17H)	;get forward DEC
 	AND	1FH		;low 5 bits
 	LD	D,A		;sector offset
 	LD	A,(IY+17H)	;get again
 	AND	0E0H		;high 3 bits
 	LD	E,A		;offset within sector
 	LD	HL,GATBUFF+200H	;start of records
 	ADD	HL,DE		;point to record
 	PUSH	HL		;pass to IY
 	POP	IY
 	JR	RESTOP		;continue
offset
 	LD	A,(IY+17H)	;get again
 	AND	0E0H		;high 3 bits
 	LD	E,A		;offset within sector
 	LD	HL,GATBUFF+200H	;start of records
 	ADD	HL,DE		;point to record
 	PUSH	HL		;pass to IY
 	POP	IY
