SUU0C  ;suu0c/asm
 MENU00	XOR	A		;this re-sets when "lost"
 	CALL	SETUPS		;and stack etc.
 	JP	RETURN		;exit to MENU, finish up
 MENU	XOR	A		;this vector is "normal"
 	CALL	SETUPS
 	RST	8		;display menu
 	DB	7,'**  SUPER-UTILITY +  **  version 2.3 ('
 ;i*
 	IF	MODI
 	DB	'I'		;show 'em as separate
 	ENDIF
 ;iii*
 	IF	MODIII
 	DB	'III'
 	ENDIF
 ;
 	DB	')  -  by '
 KIM	DB	'Kim Watt  -'	;(that's me)
 	DB	10,'(c)(p) 1981 Breeze/QSD, Inc. - (214) 484-9428',10,0
 	LD	A,0		;tricky routine to add an
 FLAGINIT	EQU	$-1
 	OR	A		;extra line of display
 	JR	NZ,DEFGIN	;then relaim the memory
 	LD	A,1		;but only do it ONCE!
 	LD	(FLAGINIT),A	;turn it off now
 	CALL	WHEREBUY	;show the mailing address
 DEFGIN	RST	8		;finish it off now
 	DB	10,10,'1.  Disk Zap',9,'6.  Tape Utilities',10
 	DB	'2.  Disk Purge',9,'7.  Memory Utilities',10
 	DB	'3.  Disk Format',9,'8.  File Utilities',10
 	DB	'4.  Disk Backup',9,'9.  Configure System',10
 	DB	'5.  Disk Repair',9,'0.  Exit Program',0
 	LD	DE,MENUGO	;table of selections
 	JP	GETSEL		;common to all menus
 MENUGO	DB	'1'		;if this key is pressed
 	DW	ZAP		;jump to this address
 	DB	'2'
 	DW	PURGE
 	DB	'3'
 	DW	FORMAT
 	DB	'4'
 	DW	COPY
 	DB	'5'
 	DW	REPAIR
 	DB	'6'
 	DW	TAPE
 	DB	'7'
 	DW	MEMORY
 	DB	'8'
 	DW	FILES
 	DB	'9'
 	DW	CONFIG
 	DB	'0'
 	DW	EXIT
 	DB	0		;terminator
 GETSEL	RST	8		;couple extra lines
 	DB	10,10,0
 BADSEL	RST	8
 	DB	1EH,'Selection ? ',0
 	LD	B,1		;just one key needed
 	RST	10H		;get it
 	JR	Z,CKTBLX	;nothing, use default
 	CALL	UCASE		;convert to upper case
 	CP	'L'		;last command?
 	JR	Z,CKTBLXX
 	JR	CKTBL		;check the table
 CKTBLX	LD	A,(DE)		;get first table entry
 	JR	CKTBL		;check for this one
 CKTBLXX	LD	A,0		;get "last" command
 LCMD	EQU	$-1
 CKTBL	LD	(LCMD),A	;save new cmd. in "last"
 	CALL	GOTABL		;see if key is there
 	JR	BADSEL		;if return, not there
 GOTABL	PUSH	BC		;pass the registers
 	PUSH	DE
 	PUSH	AF
 	EX	AF,AF'		;save true case here
 	POP	AF		;work with this for cvt.
 	CALL	UCASE		;make it upper case
 	LD	C,A		;save character for comp.
 TABLP	LD	A,(DE)		;get table byte
 	OR	A		;terminator?
 	JR	Z,NOTINT	;not here
 	CP	C		;same as one looking for?
 	JR	Z,HAVTAB	;have the table if Z
 	INC	DE		;bump to next character
 	INC	DE		;pass over 2 byte addr.
 	INC	DE
 	JR	TABLP		;go again
 NOTINT	EX	AF,AF'		;restore original char.
 	POP	DE		;restore table start
 	POP	BC
 	RET			;not here
 HAVTAB	EX	(SP),HL		;save HL, discard caller
 	EX	DE,HL		;HL => table compare
 	INC	HL		;point to jump address
 	LD	A,(HL)		;get LSB
 	INC	HL		;bump table
 	LD	H,(HL)		;load MSB
 	LD	L,A		;load LSB, HL = addr.
 	POP	AF		;restore HL
 	POP	BC		;restore rest
 	EX	(SP),HL		;save vector address
 	PUSH	AF		;give HL back
 	POP	HL
 	RET			;go to vector
 ZAP	LD	A,1		;sub-menu for ZAP
 	LD	(TYPE),A	;for modify update
 	CALL	SETUPS		;setup stack, etc.
 	RST	8		;display following
 	IF	MODI
 	DB	7,140,183,'  ZAP Utilities  ',187,140,10,10
 	ENDIF
 	IF	MODIII
 	DB	7,244,245,246,'  ZAP Utilities',10,10
 	ENDIF
 	DB	'1.  Display Sectors',9,'7.  Reverse Sector Data',10
 	DB	'2.  Verify Sectors',9,'8.  Exchange Sectors',10
 	DB	'3.  Compare Sectors',9,'9.  String Search',10
 	DB	'4.  Copy Sectors',9,'0.  Sector Search',10
 	DB	'5.  Copy Sector Data',9,'A.  Read ID Address Marks',10
 	DB	'6.  Zero Sectors',9,'B.  Alter DATA Address Marks',0
 	LD	DE,ZAPWHR	;zap lookup table
 	JP	GETSEL		;go to common
 ZAPWHR	DB	'1'		;pressing this key
 	DW	DISDSK		;jumps to this address
 	DB	'2'
 	DW	VERSEC
 	DB	'3'
 	DW	COMSEC
 	DB	'4'
 	DW	COPSEC
 	DB	'5'
 	DW	SECDATA
 	DB	'6'
 	DW	ZERSEC
 	DB	'7'
 	DW	REVSEC
 	DB	'8'
 	DW	EXCSEC
 	DB	'9'
 	DW	STRSER
 	DB	'0'
 	DW	SECSER
 	DB	'A'
 	DW	IDMARKS
 	DB	'B'
 	DW	DAMARKS
 	DB	0
 SETUPS	DI			;disable for stack rel
 	POP	HL		;get caller address
 	LD	SP,STACK	;initialize the stack
 	LD	(WHERE),A	;A = sub-menu vector
 	EI			;all done
 	JP	(HL)		;back to caller
 INKEY	CALL	KEY		;quick strobe of kybd.
 	PUSH	BC		;save from debounce
 	LD	BC,500H		;about 1/32 second
 	CALL	DELAY		;count till BC = 0
 	POP	BC
 	OR	A		;set flags on inkey
 	RET
 GOBACK	LD	SP,STACK	;set to clear xtra pushs
 	CALL	PRESS		;"enter to continue"
 ; these vectors are a common branch for ALL routine
 ;	completion
 ; because the BREAK key is checked under interrupt
 ;	service, the stack could be left in an
 ;	unknown state.  therefore, by branching here
 ;	all conditions are re-initialized to a
 ;	known default setting.
 ; also, due to the fact that the code is constantly being
 ;	self modified, this routine will replace the
 ;	correct initial values for everything.
 RETURN	LD	SP,STACK	;initialize stack area
 	CALL	DLON		;re-activate dual if disb
 	LD	HL,4015H	;leave vector on stack
 	PUSH	HL
 	EXX			;also in HL'
 ;i*
 	IF	MODI
 	LD	A,88H		;init. read sector cmd
 	LD	(RDTYPE),A
 	LD	A,0A8H		;write sector command
 	LD	(WRTYPE),A
 	ENDIF
 ;iii*
 	IF	MODIII
 	LD	A,80H		;default diff for I/III
 	LD	(RDTYPE),A
 	LD	A,0A0H
 	LD	(WRTYPE),A
 	LD	A,20H		;read track alters this
 	LD	(RDIIIFIX),A	;to enable >256 on read
 	ENDIF
 ;
 	XOR	A		;initialize @BADRD
 	LD	(HOLDIN),A
 	LD	(ZAPFLAG),A	;set no-error last I/O
 	DEC	A
 	LD	(MOD3FILE),A	;turn off TRSIII sysfiles
 	LD	A,(FLAGA)	;turn on "alive"
 	RES	1,A
 	LD	(FLAGA),A
 	IF	MODI
 	LD	A,(37ECH)	;read FDC status
 	ENDIF
 	IF	MODIII
 	IN	A,(0F0H)	;FDC Mod III
 	ENDIF
 	BIT	0,A		;command active now?
 	JR	Z,NOTAXT	;skip if not
 	XOR	A		;force re-seek next I/O
 	LD	(TASKDRV),A
 ; the above is in case the break key is pressed during
 ;	a head motion command.  The seek type moves
 ;	all run with interrupts on, and therefore, the
 ;	current track table may not have been updated
 ;	at the time of BREAK key detection.  SU+ does
 ;	not re-seek on read errors, as the head can
 ;	never get 'lost' unless the user actually
 ;	moves the head location physically.  Every
 ;	time that the current track table indicates that
 ;	the head is over track 0, it ALWAYS issues a
 ;	RESTORE command which gets everything back
 ;	in unison.  By reading the FDC current status
 ;	and checking for a command in progress as
 ;	indicated by bit 1 being set, chances are
 ;	that a seek type command is active, as all
 ;	I/O read/write transfers must run with
 ;	interrupts off.
 NOTAXT	CALL	TASKDRV		;set it up in table
 	CALL	IFSAVCONF	;set if save config ON
 	CALL	TURNSPEED	;reinstate hispeed if on
 	CALL	DLON		;turn on dual if 'off'
 	LD	A,14		;get sub-menu #
 WHERE	EQU	$-1
 	INC	A		;add for table
 	LD	DE,RETADD	;lookup table for menus
 	CALL	GOTABL		;jump to it
 	JP	4015H		;byte got 'lost', go main
 RETADD	DB	1
 	DW	MENU
 	DB	2
 	DW	ZAP
 	DB	3
 	DW	PURGE
 	DB	4
 	DW	FORMAT
 	DB	5
 	DW	COPY
 	DB	6
 	DW	REPAIR
 	DB	7
 	DW	TAPE
 	DB	8
 	DW	MEMORY
 	DB	9
 	DW	FILES
 	DB	10
 	DW	CONFIG
 	DB	11
 	DW	EXIT
 	DB	15	;this is used to initialize the
 	DW	INITBACK	;stack at init time
 	DB	0
 PRESS	RST	8	;"enter to continue"
 	DB	10,'Key <ENTER>. ',0
 	JP	ONEKEY
 DISDSK	CALL	GETDAT		;drive, track, sector
 	RST	8		;clear screen
 	DB	7,0
 	CALL	INITBAD1	;setup bad read/write
 	XOR	A		;clear disk command
 	LD	(TASKDRV),A
 	CALL	GETTRK		;get current track
 	LD	(TRUE),A	;reset TRUE track
 DISKLP	CALL	DSTAT		;check drive status
 	JP	NZ,4018H	;exit sub-menu if bad
 	XOR	A		;set no-errors on I/O
 	LD	(ZAPFLAG),A	;error type flag
 	LD	A,(TRUE)	;save true track in table
 	SCF
 	CALL	GETTRK
 	LD	(SECTOR),DE	;save current track/sect
 	CALL	DDOSFIX		;adjust for relative secs
 	LD	A,E		;save 'illogical' sector
 	LD	(PASSEE),A
 	CALL	SEEK		;move head to track
 	POP	DE		;get REAL track/sec back
 	JP	NZ,XBADRD	;if error, go
 	OR	A		;get TRUE track
 	CALL	GETTRK		;from the table
 	LD	(TRUE),A	;save here from read
 	CALL	ADDR		;read ID marks from disk
 	JR	Z,GODSKLL	;OK if Z
 	LD	D,1		;set non track 0
 	BIT	4,A		;check for NOT FOUND
 	CALL	NZ,FLIPDEN	;flip density if yes
 	CALL	ADDR		;read address marks agn
 	JP	NZ,XBADRDX	;go if bad
 GODSKLL	LD	D,(HL)		;get track # from disk
 	LD	A,D		;get here for load
 ;i*
 	IF	MODI
 	LD	(37EDH),A	;give to FDC track reg I
 	ENDIF
 ;iii*
 	IF	MODIII
 	OUT	(0F1H),A	;FDC track III
 	ENDIF
 ;
 	LD	E,0		;get 'illogical' sector
 PASSEE	EQU	$-1
 	CALL	INITBAD		;clear nonstop
 DKSRT	LD	BC,BUFFER	;read it here
 	LD	(ADDRESS),BC	;save for @MODIFY
 	CALL	ZBUFF		;zero out before reading
 	CALL	READNS		;read without seeking
 	JP	Z,ZAPO		;go if OK
 	BIT	4,A		;check for NOT FOUND
 	LD	A,(TRUE)	;get REAL track
 	LD	D,A		;back to D
 	CALL	NZ,FLIPDEN	;change density
 	CALL	READNS		;read again, no seek
 	JP	Z,ZAPO		;go if OK
 	BIT	4,A		;check for NOT FOUND
 	LD	A,(TRUE)
 	LD	D,A
 	CALL	NZ,FLIPDEN	;change if NF error
 	CALL	XREAD		;change IBM type read
 	CALL	NZ,XREAD	;again if bad
 	JP	Z,ZAPO		;go if OK now
 	JP	XBADRD		;tried everything
 XBADRDX	LD	A,(TRUE)	;could not read the
 	LD	DE,(SECTOR)	;ID marks from the disk
 	RST	18H		;make the REAL track asci
 	LD	(XBADRDX1),A	;put into the message
 	LD	(XBADRDX1+1),BC
 	RST	8		;display it
 	DB	7,10,'Track '
 XBADRDX1	DB	'xxx FLAWED or NOT FORMATTED !',0
 	LD	A,1		;set ERROR on I/O
 	LD	(ZAPFLAG),A
 DIDWXT	LD	A,12		;flash counter
 	LD	(DISFL),A
 DIDWWT	CALL	INKEY		;check for a key
 	JR	NZ,DISHVTT	;go if yes
 	LD	A,(DISFL)	;see if it's flash time
 	DEC	A
 	LD	(DISFL),A
 	JR	NZ,DIDWWT	;wait if not
 	LD	A,(3C00H)	;get current video char
 	CP	20H		;blank?
 	LD	A,20H		;make it blank if not
 	JR	NZ,DISSYU
 	LD	A,0B0H		;else a cursor char
 DISSYU	LD	(3C00H),A	;put it on the video
 	JR	DIDWXT
 DISHVTT	RST	8
 	DB	7,0		;clear screen
 	JR	DISHV
 XBADRD	CALL	BADRDCLS	;bad read routine
 	JP	NZ,DKSRT	;retry if NZ
 	JR	ZAPN		;else got it with skip
 ZAPO	XOR	A		;if OK, clear I/O error
 	LD	(ZAPFLAG),A
 	JR	DKOK
 ZAPN	LD	A,1		;set I/O error
 	LD	(ZAPFLAG),A
 ;i*
 	IF	MODI
 	LD	A,88H		;reset READ command if
 	ENDIF
 ;iii*
 	IF	MODIII
 	LD	A,80H		;an error was found
 	ENDIF
 ;
 	LD	(RDTYPE),A
 DKOK	LD	DE,(SECTOR)	;this is current track
 	LD	A,(PASSEE)	;this is current sector
 	LD	E,A
 DISCON	CALL	SHOW		;display hex/ascii
 DISCON1	CALL	SHOWLF		;display source of data
 DISWT	LD	A,12		;flash counter
 	LD	(DISFL),A
 DISWTX	CALL	INKEY		;wait for a key
 	JR	NZ,DISHV
 	LD	A,0
 DISFL	EQU	$-1
 	DEC	A
 	LD	(DISFL),A
 	JR	NZ,DISWTX
 	LD	A,(3C00H)
 	CP	20H
 	LD	A,20H
 	JR	NZ,DISSW
 	LD	A,0B0H
 DISSW	LD	(3C00H),A
 	JR	DISWT
 DISHV	PUSH	AF		;save original
 	CALL	UCASE		;make it upper case
 	CP	20H		;check for 'control' byte
 	JR	NC,DISHVXX
 	LD	A,8FH		;use this for display
 DISHVXX	LD	(3C00H),A
 	POP	AF		;get char back
 	CP	30H		;check for 0-9 for
 	JR	C,GOTTT		;direct sector paging
 	CP	3AH
 	JR	NC,GOTTT
 	SUB	30H		;remove the ascii
 	LD	E,A		;give to the sector reg
 	JP	DISKLP		;go again
 GOTTT	EX	DE,HL		;HL = track sector
 	LD	DE,DISTBL	;need DE for table
 	CALL	GOTABL		;check if defined
 BADDISRET	EX	DE,HL	;not found, restore DE
 	JR	DISWT		;loop some more
 DISTBL	DB	'R'		;if this key is pressed
 	DW	GOREST		;jump here
 	DB	'M'
 	DW	MODIFY
 	DB	'@'
 	DW	DECODE
 	DB	'H'
 	DW	HEXIT
 	DB	'A'
 	DW	ASCIT
 	DB	'B'
 	DW	BINIT
 	DB	'D'
 	DW	DECIT
 	DB	'O'
 	DW	OCTIT
 	DB	5BH
 	DW	TRKUP
 	DB	5CH
 	DW	TRKDN
 	DB	5DH
 	DW	SECDN
 	DB	5EH
 	DW	SECUP
 	DB	18H
 	DW	SECBOT
 	DB	19H
 	DW	SECTOP
 	DB	1AH
 	DW	TRKBOT
 	DB	1BH
 	DW	TRKTOP
 	DB	','
 	DW	BAKSEC
 	DB	'.'
 	DW	FORSEC
 	DB	'<'
 	DW	BAKSEC
 	DB	'>'
 	DW	FORSEC
 	DB	'('
 	DW	LOSEC
 	DB	')'
 	DW	HISEC
 	DB	3
 	DW	NEWDTS	;new drive,track,sector
 	DB	'T'
 	DW	NEWTS	;new track,sector
 	DB	'S'
 	DW	NEWS	;new sector
 	DB	0
 NEWDTS	RST	8
 	DB	7,0		;clear screen
 	JP	DISDSK		;back to display disk
 NEWS	EX	DE,HL
 	RST	8
 	DB	7,'Sector ? ',0
 	LD	B,30
 	RST	10H		;get keyboard input
 	JP	Z,LSDIR		;go to last if null
 	CALL	POSHL		;position to input
 	JP	C,LSDIR		;nothing
 	CALL	VALUE		;get the sector # wanted
 	JR	C,NEWS+1	;invalid number
 	JR	NZ,NEWS+1	;>255
 	LD	E,A		;pass new sector
 	JP	DISDSK+3
 NEWTS	EX	DE,HL
 	RST	8
 	DB	7,'Track, Sector ? ',0
 	LD	B,30
 	RST	10H
 	JR	Z,LSDIR		;last if nill input
 	CALL	POSHL
 	JR	C,LSDIR
 	CALL	UCASE
 	CP	'D'		;directory track?
 	JR	Z,USDIR
 	CP	5CH		;bottom track
 	JR	Z,BSDIR
 	CP	5BH		;top track
 	JR	Z,TSDIR
 	CP	'L'		;last track
 	JR	Z,LSDIR
 	LD	DE,0		;default lowest sector
 	OR	A
 	CALL	GETTYPEA
 	BIT	2,A
 	JR	Z,HERIO
 	INC	E		;trsiii has 1 as lowest
 HERIO	CALL	VALUE
 	JR	C,NEWTS+1	;invalid number
 	JR	NZ,NEWTS+1	;too big
 	LD	D,A		;save track
 NXDIR	CALL	POSHL		;check for more
 	JP	C,DISDSK+3	;nothing, continue
 	CALL	VALUE		;get the number
 	JR	C,NEWTS+1	;invalid
 	JR	NZ,NEWTS+1	;too big
 	LD	E,A		;save sector
 	JP	DISDSK+3	;continue
 LSDIR	LD	DE,(SECTOR)
 	JP	DISDSK+3
 TSDIR	OR	A
 	CALL	DDOSTRACKS	;RELATIVE track count
 	DEC	A		;highest track
 	LD	D,A		;need it here
 CSDIRZ	LD	E,0		;lowest sector
 	INC	HL
 	OR	A
 	CALL	GETTYPEA
 	BIT	2,A
 	JR	Z,NXDIR
 	LD	E,1		;TRSIII sectors 1-18
 	JR	NXDIR
 BSDIR	LD	D,0
 	JR	CSDIRZ
 USDIR	OR	A
 	CALL	GETDIR		;directory track
 	JR	CSDIRZ+2
 DECIT	LD	A,1		;set decimal
 ITCONT	LD	(MODE),A
 	EX	DE,HL
 	LD	A,(TYPE)
 	CP	1		;zap sectors
 	JP	Z,DISCON1
 	CP	2		;zap memory
 	JP	Z,DISMCON1
 	CP	3		;zap file
 	JP	Z,DFILEWTX
 	JP	DISMCON1	;invalid, go to memory
 HEXIT	XOR	A		;set HEX modify
 	JR	ITCONT
 BINIT	LD	A,2		;set BINARY modify
 	JR	ITCONT
 OCTIT	LD	A,3		;set OCTAL modify
 	JR	ITCONT
 ASCIT	LD	A,4		;set ASCII modify
 	JR	ITCONT
 HISEC	LD	A,0DCH		;get higest sector
 	JR	LOSEC+2
 LOSEC	LD	A,0D4H		;lowest sector on track
 	LD	(HLPWAY),A
 	EX	DE,HL		;DE = track sector
 	LD	B,20		;20 iterations
 LOSECL	CALL	ADDR		;read address marks
 	JP	NZ,DISKLP	;error
 	INC	HL		;head #
 	INC	HL		;sector #
 	LD	A,E		;get current sec
 	CP	(HL)		;compare to that from dsk
 HLPWAY	CALL	C,GETE		;check for highest,lowest
 	DJNZ	LOSECL		;do 20 times
 	JP	DISKLP		;back to the display sect
 GETE	LD	E,(HL)		;save new sector as hi/lo
 	RET
 GOREST	LD	HL,0		;set lowest sec on disk
 	OR	A
 	CALL	GETTYPEA
 	BIT	2,A		;check for TRSIII
 	JR	Z,DISRET
 	LD	L,1
 DISRET	EX	DE,HL		;put DE back with tk/sc
 	JP	DISKLP		;display and wait more
 TRKUP	INC	H		;bump track
 	JR	DISRET
 TRKDN	LD	A,H		;see if on track 0 now
 	OR	A
 	JP	Z,BADDISRET	;can't decrement from 0
 	DEC	H
 	JR	DISRET
 TRKTOP	OR	A
 	CALL	DDOSTRACKS	;track count (relative)
 	DEC	A		;highest track
 	LD	H,A
 	JR	DISRET
 TRKBOT	LD	H,0		;lowest track
 	JR	DISRET
 SECTOP	INC	L
 	JR	DISRET
 SECBOT	DEC	L
 	JR	DISRET
 SECUP	EX	DE,HL
 	CALL	NEXSEC		;bump to next sector
 	EX	DE,HL
 	JR	NC,DISRET
 SECDN	EX	DE,HL
 	CALL	RETSEC		;bump to previous sector
 	EX	DE,HL
 	JR	DISRET
 NEXSEC	CALL	TRKEND		;get highest sect on trak
 	INC	E		;bump sector
 	CP	E		;past the sector end?
 	JR	NC,NEXTUI	;go if not
 	INC	D		;else bump track
 	LD	E,0		;starting sec next trak
 	OR	A		;check for TRSIII
 	CALL	GETTYPEA
 	BIT	2,A
 	JR	Z,NEXTUI
 	LD	E,1		;start sec trsiii
 NEXTUI	OR	A
 	CALL	DDOSTRACKS	;get track count
 	CP	D		;check for disk boundry
 	RET	C		;C = exceeded disk limit
 	SCF
 	RET	Z		;Z = at disk limit
 	CCF
 	RET			;else NC,NZ = OK
 RETSEC	OR	A
 	CALL	GETTYPEA
 	BIT	2,A
 	LD	A,0
 	JR	Z,RETSECX
 	LD	A,1
 RETSECX	CP	E		;check for low sec now
 	JR	Z,DOWNSEC	;next track if there
 	DEC	E		;else reduce sector #
 	RET
 DOWNSEC	LD	A,D		;get track
 	OR	A		;on 0 now?
 	RET	Z		;can't decrement if yes
 	DEC	D
 	CALL	TRKEND		;get highest sector
 	LD	E,A		;going backwards, have it
 	RET
 TRKEND	LD	A,D		;check for track 0
 	OR	A
 	JR	NZ,TKEND	;NZ = nope
 	CALL	GETTYPEA
 	BIT	4,A		;relative sects?
 	JR	NZ,TKDNE	;go if yes
 	BIT	3,A		;track 0 double den?
 	JR	Z,TKDNE		;go if no
 TKCNT34	BIT	2,A		;sectors start at 1?
 	LD	A,17		;highest sector non trs3
 	RET	Z
 	LD	A,18		;highest trs3
 	RET
 TKDNE	LD	A,9		;highest single, relative
 	RET
 TKEND	CALL	GETTYPEA
 	BIT	7,A		;double den?
 	JR	Z,TKDNE
 	BIT	4,A		;relative secs
 	JR	NZ,TKDNE
 	JR	TKCNT34
 BAKLPG	LD	E,(HL)
 	JP	DISKLP
 BAKSEC	EX	DE,HL
 	CALL	ADDR20		;read 20 address marks
 	JP	NZ,DISKLP
 	LD	A,E
 	JR	BAKLP3
 BAKLP1	LD	HL,DAMBUFF	;where the id marks are
 	LD	B,20		;20 of 'em
 BAKLP2	CP	(HL)		;check the track
 	JR	Z,BAKLPG	;go if match
 	INC	HL		;check next
 	DJNZ	BAKLP2		;do 20 times
 BAKLP3	DEC	A
 	CP	0FFH
 	JR	NZ,BAKLP1
 	JP	DISKLP
 FORSEC	EX	DE,HL
 	CALL	ADDR20		;20 id marks
 	JP	NZ,DISKLP
 	LD	A,E
 	JR	FORLP3
 FORLP1	LD	HL,DAMBUFF
 	LD	B,20
 FORLP2	CP	(HL)
 	JR	Z,BAKLPG
 	INC	HL
 	DJNZ	FORLP2
 FORLP3	INC	A
 	JR	NZ,FORLP1
 	JP	DISKLP
 ADDR20	LD	B,20		;20 loops of reads
 	LD	IX,DAMBUFF	;where to store data
 ADDR20A	CALL	ADDR		;read 1 ID field
 	RET	NZ		;error
 	INC	HL		;point to head
 	INC	HL		;point to sector
 	LD	A,(HL)		;get the sector
 	LD	(IX),A		;save in buffer
 	INC	IX		;bump pointer
 	DJNZ	ADDR20A		;do the rest
 	RET			;done
 GETDAT	RST	8
 	DB	10,0
 BADDAT	RST	8
 	DB	1EH,'Drive, Track, Sector ? ',0
 	XOR	A
 	CALL	SETDRV		;default to drive 0
 	LD	DE,0
 	OR	A
 	CALL	GETTYPEA
 	BIT	2,A
 	JR	Z,DD710
 	LD	E,1		;and lowest sector
 DD710	LD	B,35		;35 char input
 	RST	10H		;get from keyboard
 	RET	Z		;nill, use defaults
 	CALL	POSHL		;position to input
 	RET	C		;nothing
 	CALL	FIGDRV		;check if a dos spec
 	JR	C,BADDAT	;invalid data
 	LD	DE,0		;default to lowest sect
 	OR	A
 	CALL	GETTYPEA
 	BIT	2,A
 	JR	Z,GEDTA
 	INC	E		;trsiii sector 1
 GEDTA	CALL	POSHL		;check for more
 	RET	C		;done if not
 NOTSDG	CALL	UCASE
 	CP	'L'
 	JR	Z,LSECT
 	CP	5CH
 	JR	Z,ULKSEC
 	CP	'D'
 	JR	Z,DEFDIR
 	CP	5BH
 	JR	Z,DEFUPT
 	CALL	VALUE
 	JR	C,BADDAT
 	JR	NZ,BADDAT
 	LD	D,C
 LKSEC	CALL	POSHL
 	RET	C
 	CALL	VALUE
 	JP	C,BADDAT
 	JP	NZ,BADDAT
 	LD	E,A
 	RET
 LSECT	LD	DE,(SECTOR)
 	RET
 DEFDIR	OR	A		;default to dir track
 	CALL	GETDIR
 	JR	ULKSEC
 DEFUPT	OR	A
 	CALL	DDOSTRACKS
 	DEC	A
 	LD	D,A		;highest track #
 ULKSEC	INC	HL
 	JR	LKSEC
 ASCII	PUSH	HL		;binary => decimal ascii
 	CALL	ASCI		;convert to 2 digit
 	LD	H,B		;save LSB in H
 	PUSH	HL		;save on stack
 	LD	A,C		;get MSB
 	SUB	30H		;remove the ascii
 	CALL	ASCI		;convert to 2 digit
 	LD	A,C		;A = MSB
 	CP	'0'		;check for 0 lead
 	JR	NZ,ASCIGO1	;go if not
 	LD	A,20H		;change leading 0 to spac
 ASCIGO1	POP	HL		;get NMB
 	LD	C,B		;C = NMB
 	LD	B,H		;B = LSB
 	POP	HL		;restore it
 	RET			;ACB = decimal ascii
 ASCI	LD	C,'0'		;start with 0
 ASCII1	SUB	10		;-10
 	JR	C,ASCII2	;go if done
 	INC	C		;bump MSB
 	JR	ASCII1		;do some more
 ASCII2	ADD	A,3AH		;add ascii back
 	LD	B,A		;save in LSB
 	RET
 POSHL	LD	A,(HL)		;get a byte
 	INC	HL		;point to next
 	CP	13		;terminator??
 	SCF			;C = yes
 	RET	Z
 	CP	20H		;space?
 	JR	Z,POSHL		;skip if yes
 	CP	','		;skip these too
 	JR	Z,POSHL
 	OR	A		;clear carry
 	DEC	HL		;point to byte
 	RET			;A = first non-blank char
 MOVE	PUSH	HL		;move data from HL>DE
 	OR	A		;clear carry
 	SBC	HL,DE		;compare for overlap
 	POP	HL		;restore start
 	JR	C,MOVBAK	;move backwards
 	LDIR			;else block move direct
 	RET			;done
 MOVBAK	ADD	HL,BC		;point to last byte
 	DEC	HL		;-1
 	EX	DE,HL		;DE = last -1
 	ADD	HL,BC		;HL = dest end
 	DEC	HL		;dec for move
 	EX	DE,HL		;HL=source, DE=dest
 	LDDR			;block move backwards
 	RET			;done, overlap handled
 VALUE	CALL	POSHL		;move to next character
 	RET	C		;nothing here, invalid
 	LD	IX,NUMTYPE	;point to number type flg
 	LD	A,10		;default base
 DEFALTBASE	EQU	$-1
 	LD	(IX),A		;save here
 	PUSH	HL		;save start pointer
 	CALL	POSEND		;position to last char
 	POP	HL		;restore start
 	CP	40H		;check for letter
 	JR	C,GOVAL		;nope
 	CALL	UCASE		;make it upper case
 	LD	(IX),2		;save binary
 	CP	'B'		;what they want?
 	JR	Z,GOVAL1	;go if yes
 	LD	(IX),8		;octal
 	CP	'O'
 	JR	Z,GOVAL1
 	LD	(IX),16		;hex
 	CP	'H'
 	JR	Z,GOVAL1
 	LD	(IX),10		;decimal
 	CP	'D'
 	JR	NZ,GOVAL	;decimal if bad
 GOVAL1	PUSH	HL		;save start
 	CALL	POSEND		;position to last
 	LD	(HL),20H	;zero out specifier
 	POP	HL
 GOVAL	LD	BC,0		;start value
 	JR	MULTLP+5	;compute value
 MULTLP	CALL	CHKNXT		;check next char valid
 	JR	C,HAVNUMB	;C = non-numeric
 	CALL	MAKNUM		;remove the ascii
 	RET	C		;C = invalid char on base
 	CALL	MULTIPLY	;multiply times base
 	JR	MULTLP		;continue
 HAVNUMB	LD	A,B		;get the MSB
 	OR	A		;set flags for this
 	LD	A,C		;A = LSB
 	RET			;NZ = 2 byte number
 POSEND	CALL	CHKNXT		;check for next char
 	JR	NC,POSEND	;continue if valid
 	DEC	HL		;point to last one
 	LD	A,(HL)		;get it
 	RET			;A = value end
 CHKNXT	INC	HL		;point to next char
 	LD	A,(HL)		;fetch it
 	CALL	UCASE		;convert to upper case
 	CP	30H		;less than 0?
 	RET	C		;invalid if yes
 	CP	3AH		;0-9?
 	CCF			;reverse carry flag
 	RET	NC		;NC = 0-9
 	CP	'A'		;check for :-@
 	RET	C		;invalid chars
 	CP	5BH		;check for >z
 	CCF
 	RET
 MAKNUM	LD	A,(HL)		;get a character
 	CALL	UCASE		;make it upper
 	SUB	30H		;remove ascii
 	RET	C		;C = bad
 	CP	10		;check for 0-9
 	JR	C,MAKNUM1	;ok if yes
 	SUB	7		;adjust for a-z
 MAKNUM1	CP	(IX)		;(IX) = max digit 4 base
 	CCF			;reverse, C = bad
 	RET
 MULTIPLY	PUSH	HL	;save pointer
 	PUSH	DE
 	PUSH	AF
 	PUSH	BC
 	POP	DE
 	LD	B,(IX)		;get base here
 	CALL	MULT		;multiply prev * base
 	POP	AF
 	LD	C,A		;new number
 	LD	B,0
 	ADD	HL,BC		;add to total
 	PUSH	HL
 	POP	BC		;BC = prev*base + new
 	POP	DE
 	POP	HL		;everything else back
 	RET
 MULT	LD	HL,0		;start
 MULOOP	SRL	B		;even or odd number?
 	JR	NC,MUCONT	;continue if even
 	ADD	HL,DE		;*2
 MUCONT	RET	Z
 	EX	DE,HL
 	ADD	HL,HL		;*3
 	EX	DE,HL
 	JR	MULOOP		;continue
 PURGE	LD	A,2		;sub-menu number
 	CALL	SETUPS		;setup stack etc
 	RST	8		;display menu
 	IF	MODI
 	DB	7,140,183,'  PURGE Utilities  ',187,140,10,10
 	ENDIF
 	IF	MODIII
 	DB	7,244,245,246,'  PURGE Utilities',10,10
 	ENDIF
 	DB	'1.  Kill Selected Files',9,'6.  Zero Unused Entries',10
 	DB	'2.  Kill by Category',9,'7.  Zero Unused Granules',10
 	DB	'3.  Remove System Files',9,'8.  Change Disk Name',10
 	DB	'4.  Remove All Passwords',9,'9.  Change File Parameters',10
 	DB	'5.  Disk Directory',9,'0.  Check Directory',0
 	LD	DE,PURWHR	;data lookup table
 	JP	GETSEL		;go menu common
'3.  Remove System Files',9,'8.  Change Disk Name',10
 	DB	'4.  Remove All Password