SUU0A  ; SUU0A/ASM
 CONFIG	LD	A,9		;sub-menu specifier
 	CALL	SETUPS		;set it up
 	RST	8		;display following
 	IF	MODI
 	DB	7,'  ',140,183,'  Configuration  ',187,140,10,10
 	ENDIF
 	IF	MODIII
 	DB	7,'  ',244,245,246,'  Configuration',10,10
 	ENDIF
 	DB	'  HiSpeed=x, Dual=x, Save=x, On=xxxxxxxxxxxx, Off=xxxxxxxxxxxx',10
 	DB	'  Printer Graphics=x, LoCase=x, MX80=x, Parallel=x, LFeeds=x',10,10,0
 	LD	BC,0430H	;B=4 drive loop, C=drive
 FIGLP1	LD	A,C		;get ascii drive #
 	LD	(DVSHOW),A	;put in string
 	RST	8		;display
 	DB	'  x:'
 DVSHOW	DB	'xx=xxx, Tks=xxx, Dir=xxx, Step=x, Delay=x/2, WP=x',10
 	DB	'            Density=x, x-Grans, Track0=x, SS=x, DAM=x',10,0
 	INC	C		;bump drive
 	DEC	B		;do all 4 drives
 	JP	NZ,FIGLP1
 ASK1	CALL	SHOCONFIG	;display values
 	LD	HL,3C00H+128	;3rd video line display
 	CALL	ASKFIG		;get keyboard input
 	CALL	POSHL		;move HL to input
 	JR	C,ASK2		;nothing more
 	CALL	YESNO		;check for Y/N (hispeed)
 	JR	C,ASK1		;invalid input
 	LD	B,40H		;bit 6 mask
 	JR	Z,ASK1A		;have it
 	LD	B,0		;bit 6 reset mask
 ASK1A	LD	A,(FLAGA)	;read flag
 	AND	0BFH		;reset bit 6
 	OR	B		;set new condition
 	LD	(FLAGA),A	;save new flag
 	INC	HL		;bump string pointer
 	CALL	POSHL		;position to next
 	JR	C,ASK2		;nothing more
 	CALL	YESNO		;yes or no (dual)
 	JR	C,ASK1		;invalid
 	LD	B,20H		;bit 5 mask
 	JR	Z,ASK1B
 	LD	B,0
 ASK1B	LD	A,(FLAGA)
 	AND	0DFH		;mask off bit 5
 	OR	B
 	LD	(FLAGA),A
 	INC	HL
 	CALL	POSHL
 	JR	C,ASK2		;nothing more
 	CALL	YESNO		;(save config)
 	JR	C,ASK1
 	LD	B,10H		;bit 4 mask
 	JR	Z,ASK1C
 	LD	B,0
 ASK1C	LD	A,(FLAGA)
 	AND	0EFH		;mask off bit 4
 	OR	B
 	LD	(FLAGA),A
 	INC	HL
 	CALL	POSHL
 	JR	C,ASK2
 	LD	IY,SPEEDON	;hispeed ON code
 	CALL	FIXSPEED	;insert into code
 	JR	C,ASK1		;invalid
 	CALL	POSHL		;position to next
 	JR	C,ASK2		;no more
 	LD	IY,SPEEDOFF	;off code
 	CALL	FIXSPEED	;put it there
 	JR	C,ASK1		;invalid input
 ASK2	CALL	TURNSPEED	;turn speed on/off
 	CALL	SHOCONFIG	;display config values
 	LD	HL,3C00H+192	;where "arrow" goes
 	CALL	ASKFIG		;display, and prompt
 	CALL	POSHL		;check for anything
 	JR	C,ASK3		;nothing input
 	LD	DE,FLAGB	;point to printer flag
 	CALL	YESNO		;check Y/N (graphics)
 	JR	C,ASK2		;invalid
 	LD	BC,807FH	;B=bit 7, C=mask byte
 	JR	Z,ASK2A		;Z = "yes" input
 	LD	B,0
 ASK2A	CALL	FIXFLG		;insert into flag
 	JR	C,ASK3
 	CALL	YESNO		;(locase printer)
 	JR	C,ASK2
 	LD	BC,40BFH
 	JR	Z,ASK2B
 	LD	B,0
 ASK2B	CALL	FIXFLG
 	JR	C,ASK3
 	CALL	YESNO		;(mx80 adjust)
 	JR	C,ASK2
 	LD	BC,20DFH
 	JR	Z,ASK2C
 	LD	B,0
 ASK2C	CALL	FIXFLG
 	JR	C,ASK3
 	CALL	YESNO		;(serial trs232)
 	JR	C,ASK2
 	LD	BC,00EFH
 	JR	Z,ASK2D
 	LD	B,10H
 ASK2D	CALL	FIXFLG
 	JR	C,ASK3
 	CALL	YESNO		;(linefeeds)
 	JR	C,ASK2
 	LD	BC,08F7H
 	JR	Z,ASK2E
 	LD	B,0
 ASK2E	CALL	FIXFLG
 ASK3	LD	HL,3C00H+192	;for drive questions
 	LD	(TEMP4),HL	;save pointer
 	CALL	INITDRVO	;all drives active
 	LD	DE,GETCF	;input routine
 	LD	BC,GETCFX81	;exit vector
 	JP	DRVCOMM		;do all drives
 GETCFX81	LD	HL,DRVSAVE	;drive table
 	LD	DE,SAVEDRV	;point to alternate table
 	LD	BC,16		;16 bytes long
 	LDIR			;save in alt table
 	JP	4015H		;back to main menu
 GETCF	XOR	A		;set track 0
 	SCF			;C = put in table
 	CALL	GETTRK		;save this track
 	LD	HL,(TEMP4)	;get cursor position
 	LD	BC,80H		;move down 2 lines
 	ADD	HL,BC		;new position
 	LD	(TEMP4),HL	;put it back
 GETCNF	LD	A,(DRIV)	;get current drive
 	PUSH	AF		;save
 	CALL	SHOCONFIG	;display settings
 	POP	AF		;drive back
 	CALL	SETDRV		;set it up for tables
 	LD	HL,(TEMP4)	;get pointer
 	CALL	ASKFIG		;get response
 	CALL	POSHL		;anything
 	RET	C		;C = nothing
 	LD	B,10H
 	CP	'='		;double step?
 	JR	Z,GETCNFA
 	LD	B,0
 	CP	'+'		;active drive?
 	JR	Z,GETCNFA
 	LD	B,80H
 	CP	'-'		;inactive drive?
 	JR	NZ,GETCNFB+1
 GETCNFA	OR	A		;clear carry
 	CALL	GETTYPEB	;get type B
 	AND	6FH		;mask bits 7,4
 	OR	B		;set with input
 	SCF			;put back into table
 	CALL	GETTYPEB
 GETCNFB	INC	HL		;bump pointer
 	CALL	POSHL		;more?
 	RET	C
 	CALL	CKCONF		;check for dos specifier
 	JR	NZ,GETCNF	;invalid specifier
 	SCF			;put into table
 	LD	A,B		;B = table byte
 	CALL	GETTYPEA	;save it
 	INC	HL
 	CALL	POSHL		;more?
 	RET	C
 	CALL	VALUE		;get track count
 	JR	C,GETCNF	;invalid input
 	SCF
 	CALL	GETTKS		;put into track table
 	CALL	POSHL		;more?
 	RET	C
 	CALL	VALUE		;directory track
 	JR	C,GETCNF	;invalid
 	SCF			;put in table
 	CALL	GETDIR		;directory track
 	CALL	POSHL		;more?
 	RET	C		;no more
 	CALL	VALUE		;step rate
 	JR	C,GETCNF	;invalid
 	CP	4		;must be 0-3
 	JR	NC,GETCNF
 	LD	B,A
 	OR	A
 	CALL	GETTYPEB
 	AND	0FCH		;mask bits 0,1
 	OR	B		;set with input
 	SCF
 	CALL	GETTYPEB	;put new step back
 	CALL	POSHL		;more?
 	RET	C
 	CALL	VALUE		;motor on delay
 	JR	C,GETCNF
 	OR	A
 	JP	Z,GETCNF	;invalid
 	CP	3		;must be 1-2
 	JP	NC,GETCNF
 	AND	1
 	RLCA
 	RLCA
 	RLCA
 	RLCA			;align to bits 5,4
 	RLCA
 	LD	B,A		;save here
 	OR	A
 	CALL	GETTYPEB	;carry is clear
 	AND	0DFH		;remove 5
 	OR	B
 	SCF
 	CALL	GETTYPEB	;is set now
 	CALL	POSHL		;any more?
 	RET	C		;nope if C
 	CALL	YESNO		;must be yes/no for WP
 	JP	C,GETCNF	;invalid input
 	LD	B,40H
 	JR	Z,GETCNFC
 	LD	B,0
 GETCNFC	OR	A
 	CALL	GETTYPEB
 	AND	0BFH		;mask off bit 6
 	OR	B		;set with input
 	SCF
 	JP	GETTYPEB	;insert and return
 FIXFLG	LD	A,(DE)		;get the flag
 	AND	C		;remove test bit
 	OR	B		;set if active
 	LD	(DE),A		;put it back
 	INC	HL		;bump pointer
 	JP	POSHL		;check for more
 ASKFIG	PUSH	HL		;save cursor posit
 	LD	HL,3C00H	;video start
 	LD	DE,63		;line displace -1
 	LD	B,16		;16 video lines
 ASKFIXX	LD	(HL),20H	;turn off previous arrow
 	INC	HL
 	LD	(HL),20H
 	ADD	HL,DE		;point to next row
 	DJNZ	ASKFIXX		;do 'em all
 	POP	HL		;cursor position
 	LD	(HL),'='	;display arrow
 	INC	HL
 	LD	(HL),'>'
 	LD	HL,3C00H+896	;prompt address
 	LD	(CURSOR),HL	;move cursor to bottom
 	RST	8		;display prompt
 	DB	1EH,'? ',0	;prompt
 	LD	B,60		;length of input
 	RST	10H		;get keyboard input
 	RET			;done here
 YESNO	CALL	UCASE		;convert to upper case
 	CP	'Y'		;test for YES
 	RET	Z		;Z = yes
 	CP	'N'		;test for NO
 	SCF			;carry = bad
 	RET	NZ
 	OR	1		;set NZ, NC
 	RET
 FIXSPEED	LD	B,6	;6 iterations
 	PUSH	BC		;save counter
 	EX	DE,HL		;DE=> input
 	LD	HL,0D48H	;H=terminator, L='H'
 	LD	(TEMP1),HL	;save for @VALUE
 	LD	HL,TEMP0	;workspace
 	LD	A,(DE)		;get a byte
 	LD	(HL),A		;workspace
 	INC	DE
 	LD	A,(DE)
 	INC	HL
 	LD	(HL),A
 	DEC	HL
 	INC	DE		;point to next
 	CALL	VALUE		;get the value
 	POP	BC
 	RET	C		;no good
 	LD	(IY),A		;put into code
 	INC	IY		;point to next
 	EX	DE,HL		;restore pointer
 	DJNZ	FIXSPEED+2	;continue for 6
 	RET
 SHOW	PUSH	HL		;save registers
 	PUSH	DE
 	PUSH	BC
 	LD	HL,GET		;un-stacker return addr.
 	PUSH	HL		;to the stack
 	LD	A,(FLAGA)	;get flag A
 	SET	1,A		;de-activate "alive"
 	LD	(FLAGA),A	;put it back
 	LD	A,(DISP1)	;get "decrypt" type
 	LD	(3C00H+960),A	;to the video
 	CP	'R'		;"rotate" ?
 	JR	Z,SHRTT
 	CP	'S'		;"shift" ?
 	JR	Z,SHRTT
 	LD	A,(DISP3)	;get displacement
 	RST	20H		;hex ascii
 	LD	(3C00H+961),BC	;to the video
 	JR	SJRTT
 SHRTT	LD	A,(DISP2)	;get shift/rotate direct.
 	LD	(3C00H+961),A	;to the video
 	LD	A,(DISP3)	;get value 1-8
 	CP	8
 	JR	C,SHUGH
 	LD	A,1		;if 8, make it 1
 	LD	(DISP3),A	;save new
 SHUGH	ADD	A,30H		;make it ascii
 	LD	(3C00H+962),A	;to the video
 SJRTT	LD	IX,(ADDRESS)	;data address in memory
 	LD	IY,3C00H+8	;video address
 	LD	C,16		;16 video lines
 SHOWLP	PUSH	BC		;save it
 	PUSH	IY
 	PUSH	IX
 	LD	L,8		;8 loops of
 SHOWPL1	LD	H,2		;2 bytes = 16 byte line
 SHOWPL	LD	A,'*'		;check for hex "decrypt"
 SHFLG	EQU	$-1
 	CP	':'
 	LD	A,(IX)		;get buffer byte
 	CALL	Z,ADJBYTE	;adjust if specified
 	RST	20H		;convert to hex ascii
 	LD	(IY),C		;to the video
 	INC	IY
 	LD	(IY),B
 	INC	IY
 	INC	IX		;bump buffer
 	DEC	H		;decrement counter 1
 	JR	NZ,SHOWPL
 	INC	IY		;space between byte pairs
 	DEC	L		;counter 2
 	JR	NZ,SHOWPL1	;finish this row
 	POP	IX		;restore data pointer
 	LD	B,16		;16 bytes for ascii side
 SHOWPP	LD	A,(IX)		;get it
 	CALL	M00		;adjust ascii and display
 SHCCC	INC	IY		;bump video
 	INC	IX		;bump buffer
 	DJNZ	SHOWPP		;finish this line
 	POP	IY		;start of line
 	LD	DE,40H		;64 char per line
 	ADD	IY,DE		;point to next video line
 	POP	BC		;get counter
 	DEC	C		;finish all rows
 	JR	NZ,SHOWLP
 	RET			;done with hex and ascii
 ; following is the encoded program serial number
 SERSAVE	DB	0F3H,0F7H,0FFH,38H,0F3H,0F7H,0FFH
 HEXCV	LD	B,A		;A = binary value
 	SRL	A		;align to low 4 bits
 	SRL	A
 	SRL	A
 	SRL	A
 	CALL	HEXTST		;convert to ascii
 	LD	C,A		;save MSB here
 	LD	A,B		;get original back
 	AND	0FH		;mask upper 4 bits
 	CALL	HEXTST		;convert to ascii
 	LD	B,A		;save LSB
 	RET			;CB = hex ascii
 HEXTST	ADD	A,30H		;make it ascii
 	CP	3AH		;is it 0-9
 	RET	M		;go if yes
 	ADD	A,7		;convert to A-F
 	RET			;done
 SHOWST	BIT	7,A		;display error status
 	JR	Z,BIT6		;7 = dropped ready
 	RST	8		;display
 	DB	10,'Drive TIME OUT !',10,0
 BIT6	JR	C,BIT4		;C = read operation
 	BIT	6,A		;check for write protect
 	JR	Z,BIT5
 	RST	8
 	DB	10,'WRITE PROTECTED Disk !',10,0
 BIT5	BIT	5,A		;check for hardware fault
 	JR	Z,BIT4
 	RST	8
 	DB	10,'HARDWARE Write Fault !',10,0
 BIT4	BIT	4,A		;not found error
 	JR	Z,BIT3
 	RST	8
 	DB	10,'Sector NOT FOUND !',10,0
 BIT3	BIT	3,A		;crc error
 	JR	Z,BIT2
 	BIT	4,A		;in ID field?
 	JR	Z,DATERR
 	RST	8
 	DB	10,'ID CRC Error !',10,0
 	JR	BIT2
 DATERR	RST	8
 	DB	10,'DATA CRC Error !',10,0
 BIT2	BIT	2,A		;data lost?
 	JR	Z,BIT1Z
 	RST	8
 	DB	10,'DATA LOST !',10,0
 BIT1Z	BIT	1,A		;drive not in system
 	RET	Z
 	RST	8
 	DB	10,'Drive DROPPED READY.',10,0
 	RET
 SHOWWH	PUSH	AF		;show data source
 	PUSH	BC
 	CALL	DRVASC		;ascii drive number
 	LD	(WHDR),A	;to the message
 	LD	A,E		;get sector
 	RST	18H		;decimal ascii
 	LD	(WHSC),A	;to the message
 	LD	(WHSC+1),BC
 	LD	A,D		;get track
 	RST	18H
 	LD	(WHTR),A
 	LD	(WHTR+1),BC
 	RST	8		;display data source
 	DB	'Drive '
 WHDR	DB	'x, Track '
 WHTR	DB	'xxx, Sector '
 WHSC	DB	'xxx.',0
 	POP	BC
 	POP	AF
 	RET
 SHOWMODE	LD	A,(MODE)	;show modify mode
 	PUSH	BC
 	LD	B,A		;save for test
 	SLA	A		;*2
 	ADD	A,B		;*3 (3 bytes per entry)
 	LD	C,A		;save for add
 	LD	B,0		;BC = table position
 	LD	HL,MODTYP	;table start
 	ADD	HL,BC		;point to modify base
 	PUSH	DE		;save from move
 	LD	DE,3C40H	;where it goes on video
 	LD	BC,3		;3 byte message
 	LDIR			;move to the video
 	POP	DE
 	POP	BC
 	RET
 SHOWLF	CALL	SHOWMODE	;show modify mode
 	PUSH	BC
 	LD	BC,3
 	PUSH	DE
 	LD	HL,MODDRV	;DRV message
 	LD	A,(TYPE)
 	CP	2
 	PUSH	AF
 	JR	NZ,TYUT
 	LD	HL,MODMEM	;MEM message
 TYUT	LD	DE,3C00H+128	;where it goes on video
 	PUSH	BC
 	LDIR
 	POP	BC
 	POP	AF
 	JP	Z,SHOWNUMB	;show addresses if memory
 	LD	HL,MODTRK	;TRK message
 	LD	DE,3C00H+256
 	PUSH	BC
 	LDIR
 	POP	BC
 	LD	HL,MODTRU	;TRU message
 	LD	DE,3C00H+384
 	PUSH	BC
 	LDIR
 	POP	BC
 	LD	HL,MODSEC	;SEC message
 	LD	DE,3C00H+512
 	PUSH	BC
 	LDIR
 	LD	A,(WRTYPE)	;get type of read (ind)
 	AND	3		;bits 0,1 only
 	LD	B,A		;save here
 	SLA	A		;*2
 	ADD	A,B		;*3 for table
 	LD	C,A
 	LD	B,0		;BC = table position
 	LD	HL,MODDAT	;start of text
 	ADD	HL,BC		;point to data message
 	POP	BC		;BC = 3
 	PUSH	BC
 	LD	DE,3C00H+640	;where it goes
 	LDIR
 	LD	A,(RDTYPE)	;check for IBM type form.
 	AND	8		;bit 3 = IBM type
 ;i*
 	IF	MODI
 	LD	A,'N'		;Mod I and III backwards
 	JR	Z,HAIBM
 	LD	A,'I'
 	ENDIF
 ;iii*
 	IF	MODIII
 	LD	A,'I'
 	JR	Z,HAIBM
 	LD	A,'N'
 	ENDIF
 ;
 HAIBM	LD	(MXDDE),A	;to the message
 	OR	A		;clear carry
 	CALL	GETTYPEA
 	BIT	7,A		;double den?
 	LD	A,'S'
 	JR	Z,HASD
 	LD	A,'D'
 HASD	LD	(MXDDE+1),A
 	LD	HL,MXDDE	;message
 	LD	DE,3C00H+704
 	POP	BC
 	LDIR
 	POP	DE
 	CALL	DRVASC		;ascii drive #
 	LD	(3C00H+193),A
 	OR	A
 	CALL	GETTYPEB
 	BIT	2,A		;double side?
 	LD	A,27H		;' marker
 	JR	NZ,XIYR
 	LD	A,20H
 XIYR	LD	(3C00H+194),A
 	LD	A,(SECTOR+1)	;get track
 	RST	18H		;decimal ascii
 	LD	(3C00H+320),A
 	LD	(3C00H+321),BC
 	LD	A,(SECTOR)	;sector
 	RST	18H
 	LD	(3C00H+576),A
 	LD	(3C00H+577),BC
 	OR	A
 	CALL	GETTRK		;current track
 	RST	18H
 	LD	(3C00H+448),A
 	LD	(3C00H+449),BC
 	LD	A,(ADDRESS)	;LSB data address
 	LD	IY,3C00H+5
 NBLP	PUSH	AF
 	RST	20H		;hex ascii
 	LD	(IY),C
 	LD	(IY+1),B
 	LD	BC,40H		;line displacement
 	ADD	IY,BC
 	POP	AF
 	ADD	A,16		;do 16 lines
 	JR	NZ,NBLP
 	POP	BC
 	RET
 SHOWNUMB	LD	HL,(ADDRESS)	;data address
 	LD	DE,40H		;line displacement
 	LD	IY,3C00H+3	;where on video it goes
 	LD	A,16		;16 video lines
 SHOWNUMBL	PUSH	AF
 	LD	A,H		;get MSB
 	RST	20H		;hex ascii
 	LD	(IY),C
 	LD	(IY+1),B
 	LD	A,L		;get LSB
 	RST	20H
 	LD	(IY+2),C
 	LD	(IY+3),B
 	ADD	IY,DE		;next position
 	POP	AF
 	LD	BC,10H		;address + 16
 	ADD	HL,BC
 	DEC	A		;do 16 lines
 	JR	NZ,SHOWNUMBL
 	POP	DE
 	POP	BC
 	RET
 ; HEX, DECimal, BINary, OCTal, ASCii
 MODTYP	DB	'HEXDECBINOCTASC'
 MODDRV	DB	'DRV'
 MODMEM	DB	'MEM'
 MODTRK	DB	'TRK'
 MODTRU	DB	'TRU'
 MODSEC	DB	'SEC'
 ; STanDard, Read ProTected, Deleted DaTa, User DeFined
 MODDAT	DB	'STDRPTDDTUDF'
 ; Ibm, Single Density
 MXDDE	DB	'ISD'
 MODIFY	PUSH	HL		;modify mode entry point
 	LD	IX,3C00H+8	;first byte to modify
 	LD	IY,3C00H+48	;ascii side of display
 	LD	DE,(ADDRESS)	;data address
 	LD	A,8FH		;cursor character
 	LD	(CRTPE),A	;save it
 MODWT	PUSH	DE
 	LD	HL,(ADDRESS)	;get address
 	EX	DE,HL
 	OR	A
 	SBC	HL,DE		;compute relative posit.
 	LD	A,L		;get LSB position
 	LD	(TEMP2),A	;save here
 	PUSH	BC
 	RST	20H		;hex ascii
 	LD	(3C00H),BC
 	LD	A,5DH		;arrow
 	LD	(3C00H+2),A
 	POP	BC
 	POP	DE
 MODWTXXX	LD	A,(CRTPE)	;cursor char.
 	LD	(IX),A		;to the hex side
 	LD	(IX+1),A
 	LD	(IY),A		;to the ascii side
 MOXLX	LD	A,12		;flash counter
 	LD	(MODCT),A
 MODLP	CALL	INKEY		;strobe keyboard
 	JR	NZ,MODGOT	;NZ = have a key
 	LD	A,0
 MODCT	EQU	$-1
 	DEC	A
 	LD	(MODCT),A
 	JR	NZ,MODLP
 	LD	A,0
 CRTPE	EQU	$-1
 	CP	(IX)		;cursor ON?
 	JR	NZ,MODWTXXX	;turn it on if no
 	CALL	MODFIX		;restore characters
 	JR	MOXLX		;wait some more
 MODFIX	LD	A,(SHFLG)	;get flag byte
 	CP	':'		;adjust hex side?
 	LD	A,(DE)		;get buffer byte
 	CALL	Z,ADJBYTE	;adjust if necessary
 	RST	20H		;make it hex ascii
 	LD	(IX),C		;display
 	LD	(IX+1),B
 	LD	A,(DE)
 M00	CALL	ADJBYTE		;adjust again
 	CP	20H		;check for <20H
 	JR	NC,N000		;can display it
 	LD	A,'.'		;else make it a period
 N000	LD	(IY),A		;to the video
 	CP	(IY)		;still there?
 	RET	Z		;all OK
 	SUB	20H		;make it upper case
 	LD	(IY),A		;put it back
 	RET
 MODGOT	PUSH	AF		;have a key
 	CALL	MODFIX		;turn off cursor
 	POP	AF
 	EX	DE,HL		;HL => data
 	LD	DE,MODWT	;where to return
 	PUSH	DE
 	PUSH	AF		;save key
 	LD	A,(MODE)	;check for ascii modify
 	CP	4
 	JR	Z,MODCONT	;skip commands if yes
 	POP	AF
 	CP	'P'
 	JP	Z,FILLBYTES	;fill following bytes
 	CP	'G'
 	JP	Z,GOBYTE	;go to relative byte
 	CP	'p'
 	JP	Z,FILLBYTES
 	CP	'g'
 	JP	Z,GOBYTE
 	CP	'l'		;locate a byte
 	JP	Z,FINDBYTE
 	CP	'L'
 	JP	Z,FINDBYTE
 	PUSH	AF
 MODCONT	POP	AF		;check table
 	LD	DE,MODTBL	;lookup table of response
 	CALL	GOTABL		;jump to associated vectr
 	JP	NUMBER		;if not there, it's a num
 MODTBL	DB	5DH		;if this key pressed
 	DW	MODL		;go to this address
 	DB	'>'
 	DW	INSBYTE
 	DB	'<'
 	DW	DELBYTE
 	DB	5EH
 	DW	MODR
 	DB	5BH
 	DW	MODU
 	DB	5CH
 	DW	MODD
 	DB	19H
 	DW	MODRE
 	DB	18H
 	DW	MODLE
 	DB	1AH
 	DW	MODDE
 	DB	1BH
 	DW	MODUE
 	DB	3
 	DW	MODTOP
 	DB	13
 	DW	UPDATE
 	DB	14
 	DW	CHWT
 	DB	0		;terminator
 BLKS	DB	8FH,8FH,8FH	;cursor characters
 CHWT	EX	DE,HL		;save HL data address
 CHWT1	LD	HL,BLKS		;point to cursor
 CHWT2	PUSH	DE
 	LD	DE,3C40H	;where it goes
 	LD	BC,3
 	LDIR
 	POP	DE
 	LD	A,12		;flash counter
 	LD	(CHWT4),A
 CHWT3	CALL	INKEY		;get a key
 	JR	NZ,CHWT5	;have one
 	LD	A,0
 CHWT4	EQU	$-1
 	DEC	A
 	LD	(CHWT4),A
 	JR	NZ,CHWT3
 	LD	A,(3C40H)
 	CP	8FH
 	JR	NZ,CHWT1
 	LD	HL,SPACES	;turn off cursor
 	JR	CHWT2
 CHWT5	CALL	UCASE		;make it upper case
 	CP	'H'		;hex?
 	LD	B,0
 	JR	Z,CHAVE
 	INC	B
 	CP	'D'		;decimal?
 	JR	Z,CHAVE
 	INC	B
 	CP	'B'		;binary?
 	JR	Z,CHAVE
 	INC	B
 	CP	'O'		;octal?
 	JR	Z,CHAVE
 	INC	B
 	CP	'A'		;ascii?
 	JR	NZ,CHAVE1
 CHAVE	LD	A,B
 	LD	(MODE),A
 CHAVE1	JP	SHOWMODE	;display new mode
 DECODE	PUSH	HL		;decode routine
 	LD	HL,DECTXT	;prompt
 	LD	DE,3C00H+768
 	LD	BC,4
 	LDIR
 	JR	DECOKG
 DECBAD	LD	HL,DECBTXT	;invalid message
 	LD	DE,3C00H+896
 	LD	BC,4
 	LDIR
 	LD	A,'+'		;reset decrypt to nill
 	LD	(DISP1),A
 	LD	A,20H
 	LD	(DISP2),A
 	XOR	A
 	LD	(DISP3),A
 DECOKG	LD	HL,3C00H+832
 	LD	(CURSOR),HL	;set cursor
 	LD	B,16		;16 key input
 	RST	10H		;get it
 	PUSH	HL
 	EX	AF,AF'
 	LD	HL,SPACES	;turn off prompt
 	LD	BC,16
 	PUSH	HL
 	PUSH	BC
 	LD	DE,3C00H+832
 	LDIR
 	POP	BC
 	POP	HL
 	LD	DE,3C00H+896
 	LDIR
 	POP	HL
 	EX	AF,AF'		;get key back
 	JR	Z,MNOTH		;nothing if Z
 	CALL	UCASE		;make it upper
 	CP	'!'		;special command?
 	JP	Z,PERMDEC
 	CP	':'
 	CALL	Z,SETDEC
 	CP	'*'
 	CALL	Z,SETDEC
 	CP	5BH
 	JP	Z,DECCUP
 	CP	5CH
 	JP	Z,DECCDN
 	CP	'A'		;and?
 	JR	Z,DOAND
 	CP	'O'		;or?
 	JR	Z,DOAND
 	CP	'X'		;xor?
 	JR	Z,DOAND
 	CP	'R'		;rotate?
 	JR	Z,DOROT
 	CP	'S'		;shift?
 	JR	Z,DOROT
 	CP	'+'		;add?
 	JR	Z,MEXEX
 	CP	'-'		;subtract?
 	JR	NZ,MEXXE
 MEXEX	LD	(DISP1),A	;save input
 	INC	HL
 MEXXE	CALL	VALUE		;get numeric input
 	JR	C,DECBAD	;invalid
 	LD	(DISP3),A
 MDONEY	LD	A,20H
 	LD	(DISP2),A
 MDONE	LD	HL,SPACES
 	LD	DE,3C00H+768
 	LD	BC,16
 	LDIR
 	POP	DE
 	JP	RETMOD		;back to modify mode
 MNOTH	LD	A,'+'		;disable "decrypt"
 	LD	(DISP1),A
 	XOR	A
 	LD	(DISP3),A
 	LD	A,'*'
 	LD	(SHFLG),A
 	JR	MDONEY
 DOAND	LD	(DISP1),A	;setup for AND
 	INC	HL
 	CALL	VALUE
 	JP	C,DECBAD
 	LD	(DISP3),A
 	JR	MDONEY
 DOROT	LD	(DISP1),A	;setup for ROTATE
 	INC	HL
 	LD	A,(HL)
 	CALL	UCASE
 	CP	'R'
 	JR	Z,DOROT1
 	CP	'L'
 	JP	NZ,DECBAD
 DOROT1	LD	(DISP2),A
 	INC	HL
 	CALL	VALUE
 	JP	C,DECBAD
 	CP	8
 	JP	NC,DECBAD
 	LD	(DISP3),A
 	JR	MDONE
 FGST	CALL	SHOWLF
 	LD	A,(DISP1)
 	LD	B,8
 	CP	'R'
 	RET	Z
 	CP	'S'
 	RET	Z
 	LD	B,0
 	RET
 GFST	LD	A,(DISP3)
 	ADD	A,C
 	CP	B
 	LD	(DISP3),A
 	RET
 SETDEC	LD	(SHFLG),A	;set decrement time
 	INC	HL
 	CALL	POSHL
 	RET	NC
 	POP	HL
 	JP	MDONE
 DECCUP	CALL	GCOUNT
 	JP	C,DECBAD
 	CALL	FGST
 	LD	C,1
 DECCUP1	PUSH	BC
 	CALL	SHOW
 	CALL	DOSPEED
 	POP	BC
 	CALL	GFST
 	JR	NZ,DECCUP1
 	JP	MDONE
 DECCDN	CALL	GCOUNT
 	JP	C,DECBAD
 	POP	DE
 	PUSH	DE
 	CALL	FGST
 	LD	BC,0FFH
 DECCDN1	PUSH	BC
 	CALL	SHOW
 	CALL	DOSPEED
 	POP	BC
 	CALL	GFST
 	JR	NZ,DECCDN1
 	JP	MDONE
 GCOUNT	INC	HL
 	LD	BC,8000H
 	CALL	POSHL
 	JR	C,GCOUNT1
 	CALL	VALUE
 	RET	C
 	LD	B,C
 	LD	C,0
 GCOUNT1	LD	(DLYCNT),BC	;delay count for "auto"
 	OR	A		;clear carry
 	RET
 DOSPEED	LD	BC,0		;timer counter
 DLYCNT	EQU	$-2
 	CALL	DELAY		;countdown
 	CALL	PAUSE		;check for space pause
 	LD	A,(3801H)	;check for CLEAR
 	BIT	0,A
 	RET	Z		;not pressed
 	POP	DE
 	JP	MDONE		;turn off "auto" mode
 DECBTXT	DB	'ERR '
 DECTXT	DB	'DCR '
 PERMDEC	LD	HL,(ADDRESS)	;get address
 	LD	B,0		;do 256 bytes
 PERMLXP	LD	A,(HL)		;get a byte
 	CALL	ADJBYTE		;adjust to "decrypt"
 	LD	(HL),A		;make it permanent
 	INC	HL
 	DJNZ	PERMLXP		;do 'em all
 	JP	MNOTH		;turn off decrypt
 MODR	EX	DE,HL		;modify right arrow
 	CALL	MODRX		;move to right
 	RET	NC		;not at end
 	CALL	MODDX		;move down
 	JR	NC,MODLE+1	;move to left end
 MODRCONT	LD	A,(TYPE)
 	CP	2		;from memory?
 	SCF
 	RET	NZ
 	LD	HL,(ADDRESS)	;bring in more data if Y
 	LD	BC,16
 	ADD	HL,BC
 	LD	(ADDRESS),HL
 	EX	DE,HL
 	ADD	HL,BC
 	EX	DE,HL
 	CALL	AASHOW		;re-display whole screen
 	JP	MODLE+1		;move to left end next
 MODTOP	EX	DE,HL		;move to top row
 	LD	A,(TEMP2)
 	LD	B,A
 	OR	A
 	RET	Z
 MODTOPL	PUSH	BC
 	CALL	MODL+1
 	POP	BC
 	DJNZ	MODTOPL
 	RET
 MODRX	PUSH	IX		;move right
 	POP	HL
 	LD	A,L
 	AND	3FH
 	CP	2DH
 	SCF
 	RET	Z		;at end now
 	INC	IX
 	INC	IX
 	INC	IY
 	INC	DE
 	LD	A,(IX)		;check for quad "gap"
 	CP	20H
 	SCF
 	CCF
 	RET	NZ
 	INC	IX
 	RET
 MODRE	EX	DE,HL		;move to right end
 	LD	A,16
 MODREX	EX	AF,AF'
 	CALL	MODRX
 	EX	AF,AF'
 	DEC	A
 	JR	NZ,MODREX
 	RET
 MODL	EX	DE,HL		;move left 1
 	CALL	MODLX
 	RET	NC		;not at end
 	CALL	MODUX		;move up
 	JR	NC,MODRE+1	;move to right end
 MODLCONT	LD	A,(TYPE)
 	CP	2		;from memory?
 	SCF
 	RET	NZ		;done if not
 	LD	HL,(ADDRESS)
 	LD	BC,16		;bring in more data
 	OR	A
 	SBC	HL,BC
 	LD	(ADDRESS),HL
 	EX	DE,HL
 	OR	A
 	SBC	HL,BC
 	EX	DE,HL
 	CALL	AASHOW		;re-display
 	JP	MODRE+1
 MODLE	EX	DE,HL
 	LD	A,16
 MODLEX	EX	AF,AF'
 	CALL	MODLX
 	EX	AF,AF'
 	DEC	A
 	JR	NZ,MODLEX
 	RET
 MODLX	PUSH	IX
 	POP	HL
 	LD	A,L
 	AND	3FH
 	CP	8
 	SCF
 	RET	Z
 	DEC	IX
 	DEC	IX
 	DEC	IY
 	DEC	DE
 	LD	A,(IX+1)
 	CP	20H
 	SCF
 	CCF
 	RET	NZ
 	DEC	IX
 	RET
 MODU	EX	DE,HL
 	CALL	MODUX
 	RET	NC
 	JP	MODLCONT
 MODUE	EX	DE,HL
 	LD	A,16
 MODUEX	EX	AF,AF'
 	CALL	MODUX
 	EX	AF,AF'
 	DEC	A
 	JR	NZ,MODUEX
 	RET
 MODUX	PUSH	IX
 	POP	HL
 	LD	BC,-40H
 	ADD	HL,BC
 	LD	A,H
 	CP	3CH
 	JR	C,MY
 	PUSH	HL
 	POP	IX
 	EX	DE,HL
 	LD	DE,-16
 	ADD	HL,DE
 	EX	DE,HL
 	PUSH	IY
 	POP	HL
 	LD	BC,-40H
 	ADD	HL,BC
 	PUSH	HL
 	POP	IY
 	OR	A
 	RET
 MODD	EX	DE,HL
 	CALL	MODDX
 	RET	NC
 	JP	MODRCONT
 MODDE	EX	DE,HL
 	LD	A,16
 MODDEX	EX	AF,AF'
 	CALL	MODDX
 	EX	AF,AF'
 	DEC	A
 	JR	NZ,MODDEX
 	RET
 MODDX	PUSH	IX
 	POP	HL
 	LD	BC,40H
 	ADD	HL,BC
 	LD	A,H
 	CP	40H
 	CCF
 	RET	C
 	PUSH	HL
 	POP	IX
 	EX	DE,HL
 	LD	DE,16
 	ADD	HL,DE
 	EX	DE,HL
 	PUSH	IY
 	POP	HL
 	LD	BC,40H
 	ADD	HL,BC
 	PUSH	HL
 	POP	IY
 	OR	A
 	RET
 MY	SCF			;vector to return C
 	RET
 UPDATE	PUSH	DE		;ENTER pressed from mod.
 	PUSH	HL
 	LD	A,0		;check for read errors
 ZAPFLAG	EQU	$-1
 	DEC	A
 	JR	NZ,SKPZU	;FF = error
 	RST	8
 	DB	7,'ERROR on Read.  Specify IBM format.',10,0
 	CALL	SETIXIBM	;get IBM type
 	XOR	A
 	LD	(ZAPFLAG),A	;turn off error
 SKPZU	POP	DE
 	POP	HL
 	LD	A,(TYPE)
 	CP	2		;memory modify?
 	JP	Z,RETMODM	;back to paging mode if Y
 UPDATE1	RST	8
 	DB	7,'U>pdate, R>eturn to modify, C>ancel ? ',0
 	LD	B,1		;one key input
 	RST	10H		;keyboard
 	RST	8		;clear input line
 	DB	1EH,0
 	JR	Z,PUTDATA	;write it back
 	CALL	UCASE		;make upper case
 	CP	'U'		;update?
 	JR	Z,PUTDATA
 	CP	'R'		;return to modify?
 	JR	Z,BAKMOD
 	CP	'C'		;cancel and re-read?
 	JR	NZ,UPDATE1	;invalid
 	POP	DE
 	POP	DE
 REREAD	LD	A,(TYPE)
 	CP	1
 	LD	DE,(SECTOR)
 	JP	Z,DISKLP	;from "display disk sects
 	CP	3
 	JP	Z,FILECT	;from "display file sects
 RETMOD	LD	A,(TYPE)
 	CP	1
 	JP	Z,DISCON	;from disk
 	CP	2
 	JP	Z,DISMCON	;from memory
 	CP	3
 	JP	Z,DFILELP	;from files
 	JP	DISKLP		;can't get here
 RETMODM	POP	DE
 	JP	DISRETM
 BAKMOD	RST	8		;clear update prompt
 	DB	7,0
 	POP	HL
 	EXX
 	POP	DE
 	EXX
 	CALL	AASHOW		;re-display data
 	EXX
 	PUSH	DE
 	EXX
 	JP	(HL)		;back to caller
 PUTDATA	LD	BC,(ADDRESS)	;where data is
 	POP	HL
 	POP	DE
 	CALL	INITBAD		;turn off nonstop
 	CALL	INITBAD1
 RT1	CALL	DSTAT		;check disk status
 	JP	NZ,4018H	;SKIP, exit to menu
 	CALL	WRITENS		;write the sector
 	JR	Z,KUQP		;OK
 	CALL	NZ,BADWRT	;bad write
 	JR	NZ,RT1		;try again
 KUQP	RST	8		;clear screen
 	DB	7,0
 	JP	REREAD		;re-read the data
 BADRDCLS	LD	HL,BADRD
 	JR	BADWRTCLS+3
 BADWRTCLS	LD	HL,BADWRT
 	LD	(BADCLSD),HL
 	PUSH	AF
 	LD	A,(FLAGA)	;can enable "alive"
 	RES	1,A
 	LD	(FLAGA),A
 	POP	AF
 	RST	8		;clear screen
 	DB	7,0
 	CALL	0
 BADCLSD	EQU	$-2
 	RST	8		;clear after prompt
 	DB	7,0
 	RET
 BADRD	NOP			;can disable it here
 	RST	8
 	DB	10,10,'Disk READ ERROR !',10,0
 	SCF			;C = from read operation
 	JR	RWCNT1
 BADWRT	NOP
 	RST	8
 	DB	10,10,'Disk WRITE ERROR !',10,0
 	OR	A		;NC = write
 RWCNT1	PUSH	AF
 	CALL	SHOWWH		;show drive, track, sect.
 	POP	AF
 	CALL	SHOWST		;show error message
 	LD	A,(3840H)	;check for CLEAR
 	AND	2
 	JR	Z,RWCNT
 	XOR	A		;turn off nonstop
 	LD	(BWRTCPT),A
 	LD	(NONSTP),A
 RWCNT	OR	1
 	LD	(ZAPFLAG),A	;set read error
 BWRTCPT	NOP
 NONSTP	NOP
 RETRY	RST	8
 	DB	1EH,'R>etry, S>kip, C>ontinuous, N>onstop, Q>uit ? ',0
 	PUSH	BC
 	LD	B,1
 	PUSH	HL
 	RST	10H		;get response
 	POP	HL
 	POP	BC
 	JR	NZ,RETRY1	;nothing, default RETRY
 	LD	A,'R'
 RETRY1	CALL	UCASE
 	CP	'S'		;SKIP?
 	JR	Z,DOSKIP
 	CP	'R'		;RETRY?
 	JR	Z,DORETRY
 	CP	'N'		;NONSTOP?
 	JR	Z,NOSPT
 	CP	'Q'		;QUIT?
 	JP	Z,4018H		;back to sub-menu
 	CP	'C'		;CONTINUOUS?
 	JR	NZ,RETRY
 	LD	A,0C9H
 	LD	(BWRTCPT),A
 DORETRY	OR	1
 	RST	8		;send a linefeed
 	DB	10,0
 	RET
 NOSPT	LD	A,0C9H
 	LD	(NONSTP),A
 	JR	DORETRY
 DOSKIP	INC	B		;bump buffer pointer
 	XOR	A		;set Z for OK
 	SCF			;C = SKIPPED
 	JR	DORETRY+2
 INITBAD	XOR	A
 	LD	(BWRTCPT),A
 	RET
 INITBAD1	XOR	A
 	LD	(NONSTP),A
 INITBAD3	LD	(BADRD),A
 	LD	(BADWRT),A
 	RET
 INITBAD2	LD	A,0C9H
 	JR	INITBAD3
 NUMBER	EX	DE,HL		;get numerical input
 	PUSH	AF
 	LD	A,(MODE)	;get modify base
 	CP	4		;ascii?
 	JR	Z,ASCNUM	;insert ascii char.
 	LD	HL,MODELN
 	SLA	A
 	LD	C,A
 	LD	B,0
 	ADD	HL,BC
 	LD	B,(HL)		;get # input chars
 	INC	HL
 	LD	C,(HL)		;get ascii terminator
 	POP	AF
 	LD	HL,STRING	;input buffer
 	JR	NUMHAV
 MODELN	DB	2,'H'
 	DB	3,'D'
 	DB	8,'B'
 	DB	3,'O'
 	DB	1,'A'
 ASCNUM	POP	AF
 NUMRET	LD	(DE),A		;ascii text insert
 	CALL	MODFIX		;adjust if "decrypt"
 	JP	MODR+1		;move cursor right
 NUMON	LD	A,0B0H		;cursor char.
 NUMOFF	LD	(IX),A
 	LD	(IX+1),A
 	LD	(IY),A
 	LD	A,12		;flash counter
 	LD	(NUMCNT),A
 NUMBLP	CALL	INKEY		;get a key
 	JR	NZ,NUMBHV
 	LD	A,0
 NUMCNT	EQU	$-1
 	DEC	A
 	LD	(NUMCNT),A
 	JR	NZ,NUMBLP
 	LD	A,(IX)
 	CP	0B0H
 	JR	NZ,NUMON
 	LD	A,20H		;cursor off
 	JR	NUMOFF
 NUMBHV	CALL	UCASE
 	CP	13
 	JR	Z,DECNUM
 	CP	30H
 	RET	C
 	CP	3AH
 	JR	C,NUMHAV
 	CP	'A'
 	RET	C
 	CP	'G'
 	RET	NC
 NUMHAV	LD	(HL),A		;save numeric input
 	INC	HL
 	DJNZ	NUMON		;get 'em all
 DECNUM	LD	(HL),C		;ascii base terminator
 	INC	HL
 	LD	(HL),13		;line terminator
 	LD	HL,STRING	;start of input
 	PUSH	IX
 	CALL	VALUE		;get the value
 	POP	IX
 	RET	C		;invalid number
 	RET	NZ		;>255
 	JR	NUMRET
 ADJBYTE	EX	AF,AF'		;save the char
 	PUSH	BC
 	LD	A,(DISP3)
 	LD	B,A
 	LD	A,(DISP2)
 	LD	C,A
 	LD	A,(DISP1)
 	CP	'+'
 	JR	Z,SHODIS
 	CP	'-'
 	JR	Z,SHODISM
 	CP	'A'
 	JR	Z,EFAND
 	CP	'O'
 	JR	Z,EFOR
 	CP	'X'
 	JR	Z,EFXOR
 	CP	'R'
 	JR	Z,EFROT
 	CP	'S'
 	JR	Z,EFSHIFF
 	EX	AF,AF'
 ADJF	POP	BC
 	RET
 EFSHIFF	LD	A,C
 	LD	C,27H
 	CP	'L'
 	JR	Z,SIT
 	LD	C,2FH
 	JR	SIT
 EFROT	LD	A,C
 	LD	C,7
 	CP	'L'
 	JR	Z,SIT
 	LD	C,0FH
 SIT	LD	A,C
 	LD	(COMB2),A
 	EX	AF,AF'
 COMB1	DB	0CBH
 COMB2	DB	0
 	DJNZ	COMB1
 	JR	ADJF
 SHODIS	EX	AF,AF'
 	ADD	A,B		;add 'em
 	JR	ADJF
 SHODISM	EX	AF,AF'		;original
 	SUB	B		;subtract 'em
 	JR	ADJF
 EFAND	EX	AF,AF'
 	AND	B
 	JR	ADJF
 EFOR	EX	AF,AF'
 	OR	B
 	JR	ADJF
 EFXOR	EX	AF,AF'
 	XOR	B
 	JR	ADJF
 CKCONF	CALL	UCASE		;check for dos specifier
 	SUB	41H		;must be a-j
 	JR	C,CKBD
 	CP	10
 	JR	NC,CKBD
 	PUSH	HL
 	LD	HL,DTTBL	;lookup table
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)		;get the type
 	LD	B,A		;pass it here
 	XOR	A		;Z = OK
 	POP	HL
 	RET
 CKBD	OR	1		;NZ = invalid input
 	RET
 FINDBYTE	CALL	CHMODTYPE
 	INC	HL		;bumped each loop
 FBON	LD	A,191		;big block
 	LD	(IX),A
 	LD	(IX+1),A
 	LD	(IY),A
 FBOFF	LD	A,12		;flash counter
 	LD	(FBCOUNT),A
 FBLP	CALL	INKEY		;check keyboard
 	JR	NZ,FBHAV
 	LD	A,0
 FBCOUNT	EQU	$-1
 	DEC	A
 	LD	(FBCOUNT),A
 	JR	NZ,FBLP
 	LD	A,(IX)
 	CP	191
 	JR	NZ,FBON
 	PUSH	HL
 	PUSH	BC
 	CALL	MODFIX
 	POP	BC
 	POP	HL
 	JR	FBOFF
 FBHAV	PUSH	AF		;save key
 	PUSH	BC
 	CALL	MODFIX		;cursors off
 	POP	BC
 	POP	AF
 	CP	'L'
 	JP	Z,LASTBYTE	;use last byte
 	CP	'l'
 	JP	Z,LASTBYTE
 	LD	(HL),A		;else put in buffer
 	CP	13
 	DEC	HL
 	JR	Z,FBDECN
 	INC	HL
 	DJNZ	FBON-1
 FBDECN	LD	A,(MODE)	;ascii ?
 	CP	4
 	LD	A,(HL)
 	JR	Z,FBGO
 	INC	HL		;point to next byte
 	LD	(HL),C		;else put in term.
 	INC	HL
 	LD	(HL),13
 	LD	HL,STRING
 	PUSH	IX
 	CALL	VALUE
 	POP	IX
 	RET	C		;bad input
 	RET	NZ		;too big
 FBGO	PUSH	AF		;save character
 	CALL	MODFIX		;cursors off
 	POP	AF
 	LD	(LASTB),A	;save this byte
 	LD	C,A		;save byte in C
 	LD	A,(TEMP2)	;get position
 	LD	B,A
 	CP	0FFH
 	RET	Z		;at end already
 	XOR	A
 	SUB	B
 	DEC	A
 	LD	B,A
 FIGO1	PUSH	BC		;save counter
 	CALL	MODR+1		;check next char
 	POP	BC
 	LD	A,(DE)		;get buffer byte
 	CP	C		;same as one wanted?
 	RET	Z		;yep
 	DJNZ	FIGO1		;else continue
 	RET			;done
 LASTBYTE	LD	A,(LASTB)	;get last one
 	JR	FBGO		;find it
 AASHOW	PUSH	IX		;display data, save regs
 	PUSH	IY
 	EXX
 	CALL	SHOW
 	CALL	SHOWLF
 	EXX
 	POP	IY
 	POP	IX
 	RET
 INSBYTE	PUSH	HL		;HL=> buffer posit
 	EX	DE,HL		;to DE
 	LD	HL,(ADDRESS)	;start of buffer
 	DEC	L		;end of buffer
 	OR	A		;clear carry
 	SBC	HL,DE		;HL=length
 	LD	B,H		;give to BC
 	LD	C,L
 	LD	A,(TYPE)
 	CP	2
 	JR	Z,INSDOIT	;do ascii modify
 	LD	HL,200H
 	LD	B,H
 	LD	C,L
 	ADD	HL,DE
 	JR	INSDOIT0
 INSDOIT	LD	HL,(ADDRESS)
 	DEC	L
 INSDOIT0	LD	D,H
 	LD	E,L
 	DEC	HL
 	LDDR
 	POP	HL
 	LD	(HL),0
 	EX	DE,HL
 	JP	AASHOW
 DELBYTE	PUSH	HL		;delete a byte
 	EX	DE,HL
 	LD	HL,(ADDRESS)
 	DEC	L
 	OR	A
 	SBC	HL,DE
 	LD	B,H
 	LD	C,L
 	POP	HL
 	PUSH	HL
 	LD	D,H
 	LD	E,L
 	INC	HL
 	LD	A,(TYPE)
 	CP	2
 	JR	Z,DELDOIT
 	LD	BC,200H
 DELDOIT	PUSH	AF
 	LDIR
 	POP	AF
 	POP	DE
 	JP	NZ,AASHOW
 	LD	HL,(ADDRESS)
 	DEC	L
 	LD	(HL),0
 	JP	AASHOW
 FILLBYTES	EX	DE,HL	;fill byte vector
 	LD	HL,MODELN
 	LD	A,(MODE)
 	SLA	A
 	LD	C,A
 	LD	B,0
 	ADD	HL,BC
 	LD	B,(HL)
 	INC	HL
 	LD	C,(HL)
 	LD	HL,STRING-1
 	INC	HL
 FILLON	LD	A,0B3H
 	PUSH	HL
 	LD	HL,0B7BBH
 	LD	(IX),H
 	LD	(IX+1),L
 	POP	HL
 	LD	(IY),A
 FILLOFF	LD	A,12
 	LD	(FLXXCOUNT),A
 FLBLP	CALL	INKEY
 	JR	NZ,FLBHAV
 	LD	A,0
 FLXXCOUNT	EQU	$-1
 	DEC	A
 	LD	(FLXXCOUNT),A
 	JR	NZ,FLBLP
 	LD	A,(IY)
 	CP	0B3H
 	JR	NZ,FILLON
 	PUSH	HL
 	PUSH	BC
 	CALL	MODFIX
 	POP	BC
 	POP	HL
 	JR	FILLOFF
 FLBHAV	PUSH	AF
 	PUSH	BC
 	CALL	MODFIX
 	POP	BC
 	POP	AF
 	LD	(HL),A
 	CP	13
 	DEC	HL
 	JR	Z,FLBDECDN
 	INC	HL
 	DJNZ	FILLON-1
 FLBDECDN	LD	A,(MODE)
 	CP	4
 	LD	A,(HL)
 	JR	Z,FLGBO
 	INC	HL
 	LD	(HL),C
 	INC	HL
 	LD	(HL),13
 	LD	HL,STRING
 	PUSH	IX
 	CALL	VALUE
 	POP	IX
 	RET	C
 	RET	NZ
 	OR	A
 	RET	Z
 FLGBO	PUSH	AF
 	CALL	MODFIX
 	POP	AF
 	LD	C,A
 	LD	B,0
 	PUSH	DE
 	EX	DE,HL
 	LD	D,H
 	LD	E,L
 	INC	DE
 	LDIR
 	POP	DE
 	JP	AASHOW		;redisplay and return
 CHMODTYPE	EX	DE,HL	;DE=> buffer
 	LD	HL,MODELN	;length of input
 	LD	A,(MODE)
 	SLA	A
 	LD	C,A
 	LD	B,0
 	ADD	HL,BC
 	LD	B,(HL)		;keys to be input
 	INC	HL
 	LD	C,(HL)		;ascii terminator
 	LD	HL,STRING-1	;input buffer
 	RET			;done
 GOBYTE	CALL	CHMODTYPE	;setup
 	INC	HL
 GOBON	LD	A,5BH		;start cursor
 GOBOFF	LD	(IX),A
 	LD	(IX+1),A
 	LD	(IY),A
 	LD	A,5
 	LD	(GOBCOUNT),A
 GBLP	CALL	INKEY
 	JR	NZ,GOBHAV
 	LD	A,0
 GOBCOUNT	EQU	$-1
 	DEC	A
 	LD	(GOBCOUNT),A
 	JR	NZ,GBLP
 	LD	A,(IX)
 	INC	A
 	CP	5FH
 	JR	C,GOBOFF
 	JR	GOBON
 GOBHAV	PUSH	AF
 	PUSH	BC
 	CALL	MODFIX
 	POP	BC
 	POP	AF
 	LD	(HL),A
 	CP	13
 	JR	Z,GOBDECN+1
 	CP	'L'		;go to "last"
 	JR	Z,GOBLST
 	CP	'l'
 	JR	Z,GOBLST
 	DJNZ	GOBON-1
 GOBDECN	INC	HL
 	LD	(HL),C		;put number base
 	INC	HL
 	LD	(HL),13		;put terminator
 	LD	HL,STRING
 	PUSH	IX
 	CALL	VALUE
 	POP	IX
 	RET	C
 	RET	NZ		;too big
 GOBGO	PUSH	AF
 	CALL	MODFIX
 	POP	AF
 	LD	IX,3C00H+8
 	LD	IY,3C00H+48
 	LD	DE,(ADDRESS)
 	LD	C,A		;counter
 	LD	(GBLST),A
 	OR	A		;check if at 0
 	RET	Z		;done
 GOBGO1	PUSH	BC
 	CALL	MODR+1		;move right 1 space
 	POP	BC
 	DEC	C
 	JR	NZ,GOBGO1
 	RET			;done
 GOBLST	LD	A,0
 GBLST	EQU	$-1
 	JR	GOBGO
 CKTRAKS	LD	A,(HL)		;see if track count input
 	CP	'='
 	SCF
 	CCF
 	RET	NZ
 	INC	HL
 	CALL	VALUE		;get track count
 	RET	C		;C = bad
 	SCF
 	RET	NZ
 	CALL	GETTKS		;setup tracks
 	XOR	A
 	RET
 SETSIDE	PUSH	AF
 	XOR	A
 	CALL	GETTYPEB
 	RES	2,A
 	SCF
 	CALL	GETTYPEB
 	POP	AF
 	CP	27H		;check for ' for 2nd side
 	RET	NZ
 	OR	A
 	CALL	GETTYPEB
 	SET	2,A
 	SCF
 	CALL	GETTYPEB
 	INC	HL
 	LD	A,(HL)
 	JP	UCASE
LL	GETTYPEB
 	RES	2,A
 	SCF
 	CALL	GETTYPEB
 	POP	AF
 	CP	