SUU0   ;	SUU0/ASM
 KIMCHK	DB	'K'<1,'i'<1,'m'<1,' '<1
 	DB	'W'<1,'a'<1,'t'<1,'t'<1
 ; above is a comparison table to be sure that the
 ; authors name is not changed in the program
 ; the bytes are rotated so they will not be directly
 ; detectable by scanning memory
 ; the comparison is made under interrupt service
 ; every 25/33 milliseconds
 XREAD	LD	A,(RDTYPE)	;get read type
 	XOR	8		;reverse IBM type
 	LD	(RDTYPE),A	;put it back
 READNS	LD	HL,READ1S	;address of read routine
 ;i*
 	IF	MODI
 	LD	(37EEH),DE	;pass track/sector to FDC
 	ENDIF
 ;iii*
 	IF	MODIII
 	LD	A,D
 	OUT	(0F3H),A	;track to FDC
 	LD	A,E
 	OUT	(0F2H),A	;sector to FDC
 	ENDIF
 ;
 	JR	READWRT		;go common vector
 WRITENS	LD	HL,WRITE1S	;write sector routine
 ;i*
 	IF	MODI
 	LD	(37EEH),DE
 	ENDIF
 ;iii*
 	IF	MODIII
 	LD	A,D
 	OUT	(0F3H),A
 	LD	A,E
 	OUT	(0F2H),A
 	ENDIF
 ;
 	JR	READWRT
 TREAD	CALL	FLIPDEN		;change density
 READ	LD	HL,READ1	;where to go
 	JR	READWRT		;go common routine
 TWRITE	CALL	FLIPDEN		;switch density
 WRITE	LD	HL,WRITE1	;write sector
 READWRT	LD	(RWRTCALL),HL	;put into code
 	LD	(RWRTCALL2),HL	;here too
 	PUSH	BC		;save load address
 	CALL	DDOSFIX		;adjust relative sectors
 ;i*
 	IF	MODI
 	CALL	SELDEN		;select correct FDC Mod I
 	ENDIF
 ;
 	CALL	0		;call read/write
 RWRTCALL	EQU	$-2
 	POP	DE		;get track/sector back
 	POP	HL		;get load address
 	RET	Z		;return if OK
 	LD	B,H		;restore load address
 	LD	C,L
 	PUSH	BC		;save again
 	CALL	DDOSFIX		;adjust relative sectors
 	CALL	0
 RWRTCALL2	EQU	$-2
 	POP	DE		;track/sector
 	POP	HL		;load address
 	RET	Z		;Z = OK
 	LD	B,H		;put buffer address back
 	LD	C,L
 	RET			;buffer not changed
 FLIPDEN	LD	A,D		;get track
 	OR	A		;check for 0
 	LD	A,80H		;bit 7
 	JR	NZ,FLIPPDEN	;go
 	LD	A,8		;bit 3
 FLIPPDEN	LD	(FLIPXOR),A
 	CALL	GETTYPEA	;get drive type
 	XOR	80H		;reverse density
 FLIPXOR	EQU	$-1
 	SCF			;put back in table
 	JP	GETTYPEA	;insert it
 READ1	CALL	SEEK		;move the head to track
 	RET	NZ		;bad
 ;i*
 	IF	MODI
 READ1S	LD	HL,37ECH	;point to FDC
 	CALL	SELECT		;turn on the drive
 	RET	NZ		;dropped ready
 	DI			;can't interrupt here
 	LD	(HL),88H	;give read command to FDC
 RDTYPE	EQU	$-1
 	PUSH	DE		;save track/sector
 	LD	DE,37EFH	;data transfer address
 	CALL	RXFER		;transfer the data
 	POP	DE		;restore track/sector
 	ENDIF
 ;iii*
 	IF	MODIII
 READ1S	CALL	SELECT		;activate drive
 	RET	NZ		;deactivated
 	CALL	SETNMI		;setup NMI return
 	LD	A,0		;get read type
 RDTYPE	EQU	$-1
 	OUT	(0F0H),A	;give command to FDC
 	CALL	RXFER		;transfer the bytes
 	ENDIF
 ;
 	PUSH	AF		;save result
 	RRCA			;align bits 6,5 to 1,0
 	RRCA
 	RRCA
 	RRCA
 	RRCA
 ;i*
 	IF	MODI
 	AND	3		;mask all others off
 	ENDIF
 ;iii*
 	IF	MODIII
 	AND	1
 	ENDIF
 ;
 	OR	0A0H		;make it a write command
 	LD	L,A		;save it here
 	LD	A,(RDTYPE)	;get type of read
 	AND	8		;IBM or not?
 	OR	L		;now have a write command
 	LD	(WRTYPE),A	;that will produce the
 	EX	AF,AF'		;same as this read.
 	POP	AF		;put write byte in af'
 	AND	9CH		;check for error
 	RET			;Z = OK
 IOCOMM	PUSH	AF		;save it
 ;i*
 	IF	MODI
 	LD	A,(37EDH)	;get track
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0F1H)	;III track register
 	ENDIF
 ;
 	SCF			;carry = put in table
 	CALL	GETTRK		;save current track
 	POP	AF		;restore result
 	RET			;done
 WRITE1	CALL	SEEK		;move head
 	RET	NZ		;error occured
 WRITE1S
 ;i*
 	IF	MODI
 	LD	HL,37ECH	;point to FDC
 	ENDIF
 ;
 	CALL	SELECT		;turn on drive
 	RET	NZ		;dropped ready
 ;i*
 	IF	MODI
 	LD	A,(37ECH)	;read status Mod I
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0F0H)	;read status Mod III
 	ENDIF
 	AND	40H		;check for write protect
 	RET	NZ		;NZ = write protected
 	OR	A		;clear carry flag
 	CALL	GETTYPEB	;get drive specifer B
 	AND	40H		;software write protect?
 	RET	NZ		;NZ = yes
 ;i*
 	IF	MODI
 	DI			;can't be interrupted
 	LD	(HL),0A8H	;issue WRITE command
 WRTYPE	EQU	$-1
 	PUSH	DE		;save track/sector
 	LD	DE,37EFH	;FDC data register
 	CALL	WXFER		;write data to the disk
 	POP	DE		;restore track/sector
 	ENDIF
 ;iii*
 	IF	MODIII
 	CALL	SETNMI		;setup NMI return
 	LD	A,0		;write type
 WRTYPE	EQU	$-1
 	OUT	(0F0H),A	;issue command to FDC
 	CALL	WXFER		;transfer the bytes
 	ENDIF
 ;
 	AND	0FCH		;check for errors
 	RET			;Z = OK
 SEEK
 ;i*
 	IF	MODI
 	LD	HL,37ECH	;point to FDC
 	ENDIF
 ;
 	CALL	SELECT		;select desired drive
 	RET	NZ		;dropped ready
 	OR	A		;clear carry
 	CALL	GETTRK		;get track from table
 	JR	NZ,SEKCNT	;continue if not 0
 	CALL	RESTORE		;restore drive to track 0
 	RET	NZ		;not in system
 	XOR	A		;set track 0
 ;i*
 	IF	MODI
 SEKCNT	LD	(37EDH),A	;give to FDC track reg.
 	LD	A,D		;get desired track
 	CALL	SEEKWHAT	;adjust if double step ON
 	LD	(37EFH),A	;"logical" track to go to
 	LD	A,E		;get sector
 	LD	(37EEH),A	;give to FDC
 	ENDIF
 ;iii*
 	IF	MODIII
 SEKCNT	OUT	(0F1H),A	;give to track register
 	LD	A,D		;get track
 	CALL	SEEKWHAT	;check for double step
 	OUT	(0F3H),A	;track to seek
 	LD	A,E		;get sector
 	OUT	(0F2H),A	;give to FDC
 	ENDIF
 ;
 	JP	DOSEEK		;move head to track
 SELECT	OR	A		;clear carry
 	CALL	GETTYPEB	;check if active
 	AND	80H		;active ?
 	RET	NZ		;skip it
 SELLOOP
 ;i*
 	IF	MODI
 	LD	A,(37ECH)	;read FDC status Mod I
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0F0H)	;read FDC status Mod III
 	ENDIF
 ;
 	AND	80H		;see if motor already on
 	LD	A,0		;get bit pattern
 DRIVE	EQU	$-1
 ;i*
 	IF	MODI
 	LD	(37E1H),A	;give to FDC
 	ENDIF
 ;iii*
 	IF	MODIII
 	OUT	(0F4H),A	;give to III FDC
 	ENDIF
 ;
 	RET	Z		;done if motor already on
 	PUSH	BC		;save this
 	OR	A		;clear carry
 	CALL	GETTYPEB	;get drive type B
 	RLCA			;move bit 5 to bit 7
 	RLCA
 	AND	80H		;now have MSB motor delay
 	LD	B,A		;give to B for count
 	LD	C,0		;lsb = 0
 	CALL	DELAY		;countdown till BC=0
 	POP	BC		;restore original
 	JR	SELLOOP		;do again
 DSKSLO	EX	(SP),HL		;short delay to wait
 	EX	(SP),HL		;for FDC to put a valid
 	EX	(SP),HL		;status byte on the
 	EX	(SP),HL		;data bus
 	EX	(SP),HL
 	EX	(SP),HL
 	RET
 DELAY	PUSH	AF		;countdown till BC = 0
 	PUSH	BC		;save original
 	LD	A,(FLAGA)	;get flag byte
 	BIT	6,A		;check for hispeed
 	CALL	NZ,DELAYX	;countdown if ON
 	POP	BC		;restore count
 	CALL	DELAYX		;if hispeed, do twice
 	POP	AF
 	RET
 DELAYX	DEC	BC		;decrement till 0
 	LD	A,B
 	OR	C
 	JR	NZ,DELAYX
 	RET
 GETTRK	PUSH	HL		;save from use
 	LD	HL,TRACK	;current track table
 	JR	GETCOMM		;go common routine
 GETDIR	JR	C,GETDIR0	;put in table
 	CALL	GETTYPEA	;carry is clear
 	PUSH	AF		;save flags
 	CALL	GETDIR0		;get directory track
 	LD	D,A		;give to DE
 	LD	E,0
 	POP	AF		;get result back
 	BIT	7,A		;double density?
 	JR	Z,GETDIRS	;go if not
 	BIT	4,A		;disk relative sectors?
 	JR	NZ,GETDIRS	;go if yes
 	BIT	2,A		;TRSIII?
 	LD	A,18		;18 sectors / track
 	RET	Z		;have it
 	LD	E,1		;else start sector = 1
 	RET
 GETDIRS	LD	A,10		;10 sectors / track
 	RET
 GETDIR0	PUSH	HL
 	LD	HL,DIRTRK	;directory track table
 	JR	GETCOMM		;go common
 GETTYPEA	PUSH	HL
 	LD	HL,TYPEA	;drive descriptor A table
 	JR	GETCOMM
 GETTYPEB	PUSH	HL
 	LD	HL,TYPEB	;drive descriptor B table
 	JR	GETCOMM
 GETTKS	PUSH	HL
 	LD	HL,TRACKS	;track count table
 GETCOMM	PUSH	AF		;save carry flag
 	LD	A,0		;get binary drive
 DRIV	EQU	$-1
 	AND	3		;mask for drives 0-3
 	ADD	A,L		;point to right byte
 	LD	L,A		;HL => table byte
 	POP	AF		;restore this
 	JR	C,PUTIN		;C = put in table
 	LD	A,(HL)		;get it out
 PUTIN	LD	(HL),A		;put it right back
 	POP	HL		;stack is restored
 	OR	A		;set flags, clear carry
 	RET
 RESTORE	LD	A,8		;fast restore command
 	CALL	MOVCOMM		;call common
 	RET	NZ		;error if NZ
 ;i*
 	IF	MODI
 	LD	A,(37ECH)	;get FDC status I
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0F0H)	;get FDC status III
 	ENDIF
 ;
 	CPL			;complement all bits
 	RRCA			;move bit 2 => bit 1
 	AND	2		;check if on
 	RET			;NZ = drive not in system
 MOVCOMM	LD	(SAVMOV),A	;save for later mask
 ;i*
 	IF	MODI
 	LD	HL,37ECH	;point to FDC
 	ENDIF
 ;
 	CALL	SELECT		;turn on drive
 	RET	NZ		;dropped ready
 	OR	A		;clear carry
 	CALL	GETTYPEB	;get drive type
 	AND	3		;set step speed
 	OR	0		;or with command mask
 SAVMOV	EQU	$-1
 	CALL	MOVEHEAD	;move the head to track
 	JR	NZ,SKERR	;seek error
 ;i*
 	IF	MODI
 	LD	A,(37EDH)	;get FDC track register I
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0F1H)	;track register III
 	ENDIF
 ;
 	SCF			;for put in table
 	CALL	GETTRK		;put it in
 	XOR	A		;set Z flag
 	RET
 SKERR	XOR	A		;force a seek next time
 	SCF			;by indicating head over
 	CALL	GETTRK		;track 0
 	OR	8		;set seek error
 	RET			;ret NZ flag, bit 4 set
 MOVEHEAD
 ;i*
 	IF	MODI
 	LD	(HL),A		;command to FDC I
 	ENDIF
 ;iii*
 	IF	MODIII
 	OUT	(0F0H),A	;command to FDC III
 	ENDIF
 ;
 	CALL	DSKSLO		;wait for valid status
 MOVWT	CALL	SELECT		;prevent time-out
 	RET	NZ		;quit if drops ready
 ;i*
 	IF	MODI
 	LD	A,(HL)		;read status I
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0F0H)	;read status III
 	ENDIF
 ;
 	BIT	0,A		;command done?
 	JR	NZ,MOVWT	;wait some more if not
 	AND	18H		;check for not found/CRC
 	RET			;done
 STEPIN	OR	A		;clear carry
 	CALL	GETTYPEB	;get descriptor B
 	BIT	4,A		;double step on?
 	CALL	NZ,GOSTEPIN	;step twice if yes
 GOSTEPIN	LD	A,58H	;step command
 	JR	MOVCOMM		;go common
 STEPOUT	OR	A		;clear carry
 	CALL	GETTYPEB	;get drive type
 	BIT	4,A		;double step?
 	CALL	NZ,GOSTEPOUT	;do twice if yes
 GOSTEPOUT	LD	A,78H	;step out command
 	JR	MOVCOMM		;go common
 DOSEEK	LD	A,18H		;fast seek command
 	CALL	MOVCOMM		;go common
 	RET	NZ		;error
 	LD	A,D		;get requested track
 	IF	MODI
 	LD	(37EDH),A	;stuff into FDC I
 	ENDIF
 	IF	MODIII
 	OUT	(0F1H),A	;to FDC III
 	ENDIF
 	RET
 SETDRV	AND	3		;binary 0-3 only
 	LD	(DRIV),A	;save binary drive
 	PUSH	BC		;save this
 	LD	C,1		;start with bit 0
 SETDLP	OR	A		;binary 0?
 	JR	Z,SETDDN	;have bit if yes
 	SLA	C		;move drive bit left
 	DEC	A		;binary -1
 	JR	SETDLP+1	;zero now?
 SETDDN	LD	A,C		;get bit pattern
 	LD	(DRIVE),A	;save for select
 	POP	BC		;restore it
 DRVASC	LD	A,(DRIV)	;get binary drive
 	ADD	A,30H		;make it ascii
 	RET			;that's all
 ; interrupt services
 TASK	EX	(SP),HL		;get current PC
 	LD	(TRACEADD),HL	;save for TRACE
 	EX	(SP),HL		;put it back
 	PUSH	AF		;save registers
 	PUSH	BC		;int. MUST NOT CHANGE
 	PUSH	DE
 	PUSH	HL
 ;i*
 	IF	MODI
 	LD	A,(37E0H)	;get interrupt status I
 	BIT	6,A		;FDC making roster?
 	JP	NZ,FDCROST	;go if yes
 	BIT	7,A		;valid interrupt?
 	JP	Z,TASKDONE	;nothing if not set
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0E0H)	;get status III
 	BIT	2,A		;RTC interrupt?
 	JP	NZ,TASKDONE	;go if not
 	ENDIF
 ;
 	LD	A,(3840H)	;check for break key
 	AND	4		;bit 2 = BREAK
 	JR	Z,TASKDN	;go if NOT pressed
 	LD	HL,BRKMSG	;display BREAK message
 	LD	DE,3C00H+59	;put it here on video
 	LD	BC,5		;5 byte message
 	LDIR			;put on video
 	LD	A,(3880H)	;check for shift key
 	OR	A		;set flags
 	JR	Z,BRKCK2	;go if NOT shift
 BRKCK1	CALL	IFBREAK		;wait till released
 	JP	4015H		;return master menu
 BRKCK2	CALL	IFBREAK		;wait till key released
 	JP	4018H		;return sub-menu
 BRKMSG	DB	'BREAK'		;ascii text for message
 IFBREAK	LD	A,(3840H)	;read break key
 	AND	4
 	JR	NZ,IFBREAK	;loop till released
 	RET
 TASKDN	LD	A,(387FH)	;check for key pattern
 	CP	2EH		;KIMJ (activate joystick)
 	CALL	Z,JOYSTKON	;turn it on if yes
 	CP	3AH		;is KIM pressed ?
 	JP	NZ,TASKDNZ01	;go if not
 	LD	A,(387DH)	;check for others
 	CP	10H		;KIMT (trace on)
 	JP	Z,TRACEON	;go if yes
 	CP	3AH		;KIM up down shift
 	JP	NZ,TASKDNZ01	;go if not
 	LD	HL,SERSAVE	;serial number
 	LD	DE,SERSHOW	;ascii message
 	LD	BC,7		;7 bytes long
 	LDIR			;move to string
 	LD	HL,SERSTRT	;start of message
 SER87X	LD	A,(HL)		;get a byte
 	OR	A		;terminator?
 	JR	Z,SER917	;display if yes
 	XOR	44H		;make it readable
 	LD	(HL),A		;put it back
 	INC	HL		;point to next byte
 	JR	SER87X		;finish the message
 JOYSTKON	LD	A,(FLAGB)	;get current flag
 	SET	1,A		;activate joystick
 	LD	(FLAGB),A	;put it back
 	RET
 SER917	RST	8		;display following
 	DB	7		;clear screen
 SERSTRT	DB	13H,2DH,3EH,25H,36H,20H,64H,79H
 	DB	64H,0FH,2DH,29H,64H,13H,25H,30H
 	DB	30H,4EH,17H,21H,36H,2DH,25H,28H
 	DB	64H,67H,64H,79H,64H
 SERSHOW	DB	3CH,3CH,3CH,3CH,3CH,3CH,3CH,0
 WTK3	LD	A,(387FH)	;check keyboard
 	CP	3AH		;check if KIM pressed
 	JR	Z,WTK3		;wait till released
 	LD	HL,SERSTRT	;point to message
 SER085	LD	A,(HL)		;get a byte
 	OR	A		;terminator?
 	JP	Z,4018H		;go sub-menu if yes
 	XOR	44H		;re-code the message
 	LD	(HL),A		;put it back
 	INC	HL		;point to next one
 	JR	SER085		;finish it up
 TRACEON	LD	A,(387CH)	;trace OFF?
 	OR	A		;check it
 	JR	Z,TRACEOFF	;turn it off if yes
 	LD	A,(FLAGB)	;get the flag
 	SET	0,A		;turn trace on
 	JR	TRACEOFF+5	;continue
 TRACEOFF	LD	A,(FLAGB)	;get the flag
 	RES	0,A		;turn trace off
 	LD	(FLAGB),A	;put it back
 TASKDNZ01	LD	A,(WHERE)	;get sub-menu #
 	OR	A		;is it master menu?
 	JR	NZ,TASKCHK	;finished if not
 	LD	A,150		;get counter
 TSKCNT	EQU	$-1
 	DEC	A		;less 1
 	LD	(TSKCNT),A	;put it back
 	JR	NZ,TASKCHK	;go if not 0 yet
 	LD	A,(3C00H+18)	;get char from video
 	XOR	10		;change ! to + on menu
 	LD	(3C00H+18),A	;put it back
 	LD	A,150		;reset counter
 	LD	(TSKCNT),A	;re-save it
 TASKCHK	LD	A,(FLAGA)	;check for "alive"
 	BIT	1,A		;is it on?
 	JR	NZ,TASKCHKY	;go if not
 	LD	A,(FLAGB)	;see if "trace" is on
 	BIT	0,A		;set = on
 	CALL	NZ,PERTRACE	;display if active
 	LD	A,8		;else go for 8 loops
 TSKCNTX	EQU	$-1
 	DEC	A		;only allow 5 / second
 	LD	(TSKCNTX),A	;re-save counter
 	JR	NZ,TASKCHKY	;go if not time
 	LD	A,(3C3FH)	;get "alive character"
 	BIT	7,A		;is it graphic?
 	JR	Z,TSKCNT30X	;go if not
 	SLA	A		;shift the bits around
 	SLA	A
 	AND	3FH		;mask upper
 	JR	NZ,TSKCNTU	;go if not at end
 TSKCNT30X	LD	A,3	;starting character
 TSKCNTU	OR	80H		;make it graphics
 	LD	(3C3FH),A	;put it on the video
 ;i*
 	IF	MODI
 	LD	A,8		;mod I counter
 	ENDIF
 ;iii*
 	IF	MODIII
 	LD	A,7		;mod III counter
 	ENDIF
 ;
 	LD	(TSKCNTX),A	;reset counter byte
 TASKCHKY	LD	HL,KIM	;point to my name in menu
 	LD	DE,KIMCHK	;comparison table
 	LD	B,8		;8 bytes long
 TSKCK1	LD	A,(DE)		;get table byte
 	SRL	A		;adjust to normal ascii
 	CP	(HL)		;still there
 	JR	NZ,KILLPGM	;kill program if not
 	INC	DE		;bump table
 	INC	HL		;bump video
 	DJNZ	TSKCK1		;do all 8
 	LD	HL,SERSAVE	;serial number
 	LD	BC,0700H	;B = counter, C = cksum
 TKCKY	LD	A,(HL)		;get a byte
 	NEG			;twos complement
 	ADD	A,C		;add to total
 	LD	C,A		;re-save total
 	INC	HL		;bump pointer
 	DJNZ	TKCKY		;do all 7 characters
 	CP	0F6H		;compare to checksum byte
 SERCHECK	EQU	$-1
 	JR	Z,TASKDONE	;OK
 KILLPGM	LD	HL,3C00H	;kill the program
 	LD	DE,3C01H	;load ? into ALL 64K
 	LD	BC,0
 	LD	(HL),'?'
 	LDIR
 	IF	MODI
 	HALT			;re-boot (won't get here)
 	ENDIF
 	RST	0		;re-boot Mod III
 TASKDONE	CALL	IFPRINTER	;printer spooler
 ;i*
 	IF	MODI
 	LD	A,(37E0H)	;clear interrupt latch I
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0ECH)	;clear latch Mod III
 	ENDIF
 ;
 	POP	HL		;restore stack
 	POP	DE
 	POP	BC
 	POP	AF		;restore AF
 	EI			;re-enable now
 	RET			;done
 ;i*
 	IF	MODI
 FDCROST	LD	A,(37ECH)	;clear FDC
 	JR	TASKDONE	;return
 	ENDIF
 ;
 ;iii*
 	IF	MODIII
 SETNMI	LD	(BUFPAS),BC	;save buffer pointer
 	LD	(SECPAS),DE	;save track/sector
 	LD	HL,NMIRET	;non-maskable return
 	LD	(404AH),HL	;set NMI vector
 	LD	H,B		;pass buffer to HL
 	LD	L,C
 	LD	A,(DRIVE)	;get drive bits
 	AND	0FH		;mask low bits
 	LD	C,A		;save here
 	OR	A		;clear carry
 	CALL	GETTYPEA	;get drive descriptor
 	BIT	7,A		;double density?
 	JR	Z,SETNMIA	;go if not
 	BIT	2,A		;TRSIII flag?
 	JR	NZ,SETNMIP	;go if yes
 	BIT	3,A		;d den track 0?
 	JR	NZ,SETNMIP	;go if yes
 	BIT	4,A		;relative sectors?
 	JR	NZ,SETNMIP	;go if yes
 	LD	A,D		;get track
 	OR	A		;is it 0?
 	JR	NZ,SETNMIP	;go if not
 	JR	SETNMIA		;continue
 SETNMIP	SET	7,C		;set double density
 SETNMIA	OR	A		;clear carry
 	CALL	GETTYPEA	;get type again
 	BIT	6,A		;double sided?
 	JR	Z,GETNMIB	;go if not
 	CALL	GETTYPEB	;get flag B
 	BIT	2,A		;side 2 requested?
 	JR	Z,GETNMIB	;go if not
 	SET	4,C		;set side 2 selection
 GETNMIB	LD	A,D		;check track
 	CP	16H		;for write pre-comp
 	JR	C,GETNMIC	;if less, skip it
 	SET	5,C		;set pre-comp
 GETNMIC	LD	A,C		;get result
 	LD	(DRIVE),A	;setup for drive select
 	OUT	(0F4H),A	;give to FDC
 	OR	40H		;set wait states
 	LD	D,A		;pass here
 	LD	BC,0F3H		;B=counter, C=FDC port
 	LD	A,0C0H		;activate nmi
 	OUT	(0E4H),A	;DRQ and motor off
 	LD	E,2		;transfer mask for bit 1
 	IN	A,(0F0H)	;clear status byte
 	DI			;must disable for disk IO
 	RET			;done
 NMIRET	XOR	A		;disable NMI
 	OUT	(0E4H),A	;turn it off
 	LD	(TEMPFF),HL	;save current data addr.
 	LD	HL,RETNMI	;point to RETN instr.
 	LD	(404AH),HL	;non-disk nmi vector
 	POP	HL		;restore stack
 	LD	BC,0		;restore buffer
 BUFPAS	EQU	$-2
 	LD	DE,0		;restore track/sector
 SECPAS	EQU	$-2
 	INC	B		;bump buffer pointer
 	IN	A,(0F0H)	;read status
 	LD	(RESULT),A	;save non-masked result
 	PUSH	AF		;save status
 	LD	A,0D0H		;force interrupt
 	OUT	(0F0H),A	;to FDC
 	POP	AF
 	EI			;can enable now
 	RET			;done
 	ENDIF
 ;
 SEEKWHAT	OR	A	;clear carry
 	CALL	GETTYPEB	;get specifier B
 	BIT	4,A		;double step this drive?
 	LD	A,D		;get desired track
 	RET	Z		;not double step
 	SLA	A		;double the track
 	RET			;done
 PERTRACE	LD	HL,0	;get trace address
 TRACEADD	EQU	$-2
 	LD	A,H		;get MSB
 	RST	20H		;HEX ascii
 	LD	(3C00H+122),BC	;to the display
 	LD	A,L		;get LSB
 	RST	20H		;HEX ascii
 	LD	(3C00H+124),BC	;to the display
 	RET
 PERTRACE	LD	HL,0	;get trace address
 TRACEADD	EQU	$-2
 	LD	A,H		;get MSB
 	RST	20H		;HEX ascii
 	LD	(3C00H+122),BC	;to the display
 	LD	A,L		;get LSB
 	RST	20H		;HEX ascii
 	LD	(3C00