MASTER ; master/asm
 	ORG	4300H
 SELECT0	LD	A,D
 	CP	16H
 	LD	A,0
 	JR	C,SELECT1
 	LD	A,20H
 SELECT1	LD	(SELECT2),A
 	LD	A,(DRIV)
 	AND	0FH
 	OR	0
 SELECT2	EQU	$-1
 	OR	0
 DENSITY	EQU	$-1
 	LD	(DRIV),A
 SELECT	IN	A,(0F0H)	;read status
 	AND	80H
 	LD	A,1		;get drive bit
 DRIV	EQU	$-1
 	OUT	(0F4H),A
 	RET	Z
 	PUSH	BC
 	LD	BC,0
 	CALL	60H
 	POP	BC
 	JR	SELECT
 SEEK	CALL	SELECT0	;select drive, set den & precomp
 	CALL	GETTRK	;get track from table
 	OUT	(0F1H),A	;give to FDC
 	JR	NZ,SEEK1	;continue if not track 0
 	CALL	RESTORE		;restore to track 0
 	RET	NZ		;bad, return
 SEEK1	LD	A,D		;get track
 	OUT	(0F3H),A	;track to seek
 	LD	A,18H		;seek command
 	CALL	MOVE		;move the head
 	RET	NZ		;bad seek
 	IN	A,(0F1H)	;get track
 PUTTRK	PUSH	HL		;save this
 	LD	HL,CTRACK	;current track table
 	PUSH	AF
 	LD	A,0		;get binary drive
 DRIVE	EQU	$-1
 	ADD	A,L		;point to drive
 	LD	L,A
 	POP	AF		;get track back
 	LD	(HL),A		;put in table
 	POP	HL		;restore HL
 	LD	A,E		;set sector register
 	OUT	(0F2H),A
 	XOR	A
 	RET		;Z flag set
 RESTORE	LD	A,8	;restore command
 	CALL	MOVE
 	RET	NZ
 	CPL
 	BIT	2,A
 	RET
 MOVE	OR	0	;set step speed
 SPEED	EQU	$-1
 	OUT	(0F0H),A	;issue command to FDC
 MOVEWT	CALL	SELECT		;keep drive on
 	IN	A,(0F0H)	;read status
 	BIT	0,A		;still busy?
 	JR	NZ,MOVEWT	;wait till done
 	BIT	4,A		;not found?
 	RET			;Z flag set if OK
 STEPIN	CALL	SELECT
 	LD	A,58H
 	JP	MOVE
 DSKSLO	PUSH	BC
 	LD	B,4
 	DJNZ	$
 	POP	BC
 	RET
 R1	CALL	SETNMI		;setup return vectors
 	LD	A,80H
 	OUT	(0F0H),A
 	CALL	DSKSLO
 	LD	E,2
 R100	IN	A,(0F0H)
 	AND	E
 	JR	Z,R100
 	INI
 	LD	A,D
 R101	OUT	(0F4H),A
 	INI
 	JR	NZ,R101
 	JR	$
 W1	CALL	SETNMI
 	LD	A,0A0H
 TYPE	EQU	$-1
 W000	OUT	(0F0H),A
 	CALL	DSKSLO
 	LD	E,2
 WR100	IN	A,(0F0H)
 	AND	E
 	JR	Z,WR100
 	OUTI
 	LD	B,60H
 	DJNZ	$
 	LD	A,D
 WR101	OUT	(0F4H),A
 	OUTI
 	JR	WR101
 READ	LD	A,5
 	LD	(RCOUNT),A
 READGO	PUSH	BC
 	CALL	R1
 	POP	HL
 	AND	9CH
 	RET	Z
 	EX	AF,AF'
 	LD	B,H
 	LD	C,L
 	LD	A,0
 RCOUNT	EQU	$-1
 	DEC	A
 	LD	(RCOUNT),A
 	JR	NZ,READGO
 	EX	AF,AF'
 	RET
 WRITE	LD	A,5
 	LD	(WRCOUNT),A
 WRGO	PUSH	BC
 	CALL	W1
 	POP	HL
 	AND	0FCH
 	RET	Z
 	EX	AF,AF'
 	LD	B,H
 	LD	C,L
 	LD	A,0
 WRCOUNT	EQU	$-1
 	DEC	A
 	LD	(WRCOUNT),A
 	JR	NZ,WRGO
 	EX	AF,AF'
 	RET
 NMIRET	RETN
 GETTRK	PUSH	HL
 	LD	HL,CTRACK
 	LD	A,(DRIVE)
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	POP	HL
 	OR	A
 	RET
 SETNMI	LD	(BUFFSAVE),BC	;save buffer
 	LD	(SECSAVE),DE	;save track/sector
 	LD	H,B		;pass buffer to HL
 	LD	L,C
 	CALL	SEEK		;seek the track
 	RET	NZ		;not found
 SETNMI2	LD	A,(DRIV)	;get drive bit
 	OR	40H		;set wait state
 	LD	D,A		;save here
 	PUSH	HL
 	LD	A,0C3H
 	LD	(4049H),A
 	LD	HL,RETNMI
 	LD	(404AH),HL
 	POP	HL
 	IN	A,(0F0H)	;clear FDC latch
 	LD	BC,0F3H		;set C = data register
 	DI
 	LD	A,0C0H
 	OUT	(0E4H),A
 	XOR	A
 	RET
 RETNMI	POP	HL		;fix the stack
 	XOR	A		;reset NMI
 	OUT	(0E4H),A	;turn it off
 	LD	DE,0		;restore track/sector
 SECSAVE	EQU	$-2
 	LD	BC,0		;restore buffer
 BUFFSAVE	EQU	$-2
 	INC	B		;bump page pointer
 	LD	HL,NMIRET	;return vector now
 	LD	(404AH),HL
 	LD	A,0C3H
 	LD	(4049H),A
 	CALL	DSKSLO
 	IN	A,(0F0H)	;read status
 	LD	(RESULT),A	;save answer
 	PUSH	AF
 	LD	A,0D0H
 	OUT	(0F0H),A
 	POP	AF
 	RET
 CTRACK	DB	0,0,0,0
 RESULT	DB	0
 ENTRY	DI
 	LD	SP,4300H
 	XOR	A
 	OUT	(0E4H),A
 	OUT	(0E0H),A
 	LD	A,20H
 	OUT	(0ECH),A
 	LD	HL,3C00H
 	LD	DE,3C01H
 	LD	BC,1023
 	LD	(HL),20H
 	LDIR
 	LD	HL,3C00H
 	LD	(CURSOR),HL
 	LD	HL,PROMPT
 	CALL	PRINT
 	CALL	KEY
 	LD	BC,BUFFER
 	LD	DE,0005H
 	LD	A,160
 	CALL	SMREAD
 	LD	DE,1005H
 	LD	A,5
 	CALL	SMREAD
 	LD	BC,BUFFER
 	LD	DE,0600H
 	LD	A,165
 	CALL	SMWRITE
 	LD	BC,BUFFER
 	LD	DE,1100H
 	LD	A,160
 	CALL	SMREAD
 	LD	A,5
 	LD	DE,2100H
 	CALL	SMREAD
 	LD	BC,BUFFER
 	LD	DE,0601H
 	LD	A,165
 	CALL	DMWRITE
 	LD	HL,MSG2
 	CALL	PRINT
 	CALL	KEY
 	RST	0
 PRINT	LD	DE,0
 CURSOR	EQU	$-2
 PRTLP	LD	A,(HL)
 	OR	A
 	JR	Z,PRTDONE
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	JR	PRTLP
 PRTDONE	LD	DE,(CURSOR)
 	LD	HL,80H
 	ADD	HL,DE
 	LD	(CURSOR),HL
 	RET
 KEY	LD	A,(387FH)
 	OR	A
 	JR	Z,KEY
 	RET
 PROMPT	DB	'Source on Drive 2, Dest on Drive 1 ? ',0
 MSG2	DB	'Master complete, <Key> to BOOT. ',0
 ERROR	LD	HL,ERMSG
 	CALL	PRINT
 	CALL	KEY
 	JP	ENTRY
 ERMSG	DB	'ERROR, <Key> to restart. ',0
 SMREAD	PUSH	AF
 	LD	A,2
 	LD	(DRIVE),A
 	LD	A,4
 	LD	(DRIV),A
 	XOR	A
 	LD	(DENSITY),A
 	POP	AF
 SRDLP	PUSH	AF
 	CALL	READ
 	JP	NZ,ERROR
 	INC	E
 	LD	A,E
 	SUB	10
 	JR	NZ,SRDOK
 	LD	E,A
 	INC	D
 SRDOK	POP	AF
 	DEC	A
 	JR	NZ,SRDLP
 	RET
 SMWRITE	PUSH	AF
 	LD	A,1
 	LD	(DRIVE),A
 	LD	A,2
 	LD	(DRIV),A
 	XOR	A
 	LD	(DENSITY),A
 	POP	AF
 SWRLP	PUSH	AF
 	CALL	WRITE
 	JP	NZ,ERROR
 	INC	E
 	INC	E
 	LD	A,E
 	SUB	12
 	JR	NZ,SWROK
 	LD	E,A
 	INC	D
 SWROK	POP	AF
 	DEC	A
 	JR	NZ,SWRLP
 	RET
 DMWRITE	PUSH	AF
 	LD	A,1
 	LD	(DRIVE),A
 	LD	A,2
 	LD	(DRIV),A
 	LD	A,80H
 	LD	(DENSITY),A
 	POP	AF
 DMWRITLP	PUSH	AF
 	CALL	WRITE
 	JP	NZ,ERROR
 	INC	E
 	INC	E
 	LD	A,E
 	SUB	13
 	JR	NZ,DMWROK
 	LD	E,1
 	INC	D
 DMWROK	POP	AF
 	DEC	A
 	JR	NZ,DMWRITLP
 	RET
 DBUFF	EQU	$&0FF00H
 BUFFER	EQU	DBUFF+100H
 	END	ENTRY
