SUCOPY ;SUCOPY/ASM
 	ORG	5200H
 DELAY	EQU	60H
 SDRIVE	DB	0
 DDRIVE	DB	0,0,0
 TEMP	DB	0
 INKEY	EQU	2BH
 TRAK	DB	0
 TRAKS	DB	17
 GETSTR	EQU	40H
 STRING	DB	'stringstringstringstringstring'
 CTRACK	DB	0,0,0,0
 	DB	'stack stack stack stack stack '
 	DB	'stack stack stack stack stack '
 	DB	'stack stack stack stack stack '
 STACK	EQU	$
 BEGIN	DI
 	LD	SP,STACK
 	LD	A,32
 	OUT	(0FFH),A
 	LD	A,1
 	OUT	(0FEH),A
 	LD	A,0FEH
 	LD	(37ECH),A
 	LD	A,0D0H
 	LD	(37ECH),A
 	LD	HL,MSG1A	;testing
 	CALL	PRINT
 	LD	A,166
 	LD	(3C3FH),A
 	LD	HL,BUFFER-1	;start of buffer
 TEST	INC	HL		;bump buffer
 	LD	A,(3C3FH)
 	XOR	3FH
 	LD	(3C3FH),A
 	LD	A,H
 	OR	L
 	JR	Z,ENTRY		;end of test
 	LD	A,0FFH
 	LD	(HL),A
 	CP	(HL)
 	JR	NZ,BADMEM
 	XOR	A
 	LD	(HL),A
 	CP	(HL)
 	JR	Z,TEST
 BADMEM	LD	HL,MSG1B	;bad memory
 	CALL	PRINT
 	LD	HL,STRING
 	LD	B,1
 	CALL	40H
 	JP	BEGIN		;re-start program
 ENTRY	LD	SP,STACK	;setup stack area
 	LD	HL,MSG1		;title message
 	CALL	PRINT		;display it
 	CALL	ZBUFF		;clear buffer
 BAD1	LD	HL,MSG2		;source drive ?
 	CALL	PRINT
 	LD	B,1
 	LD	HL,STRING
 	CALL	40H
 	LD	A,(HL)
 	CP	'X'
 	JP	Z,ENTRY
 	CP	'x'
 	JP	Z,ENTRY
 	SUB	30H
 	JR	C,BAD1
 	CP	4
 	JR	NC,BAD1
 	LD	(SDRIVE),A
 	LD	HL,DDRIVE	;active dest drive table
 	LD	B,3
 	LD	A,-1		;fill with FFH
 	CALL	FILL
 	LD	HL,DDRIVE	;destination drive
 	LD	(DDSAV),HL	;save pointer
 BAD2	LD	HL,MSG3
 	CALL	PRINT
 	LD	B,1
 	LD	HL,STRING
 	CALL	40H
 	LD	A,B
 	OR	A		;any input ?
 	JR	Z,RESTART	;done with input
 	LD	A,(HL)
 	CP	'X'
 	JP	Z,ENTRY
 	CP	'x'
 	JP	Z,ENTRY		;restart source ask ?
 	SUB	30H
 	JR	C,BAD2
 	CP	4
 	JR	NC,BAD2
 	LD	HL,0		;dest table pointer
 DDSAV	EQU	$-2
 	LD	(HL),A		;save this drive
 	INC	HL		;point to next
 	LD	(DDSAV),HL	;update pointer
 	LD	HL,SDRIVE	;point to source drive
 	CP	(HL)		;same ?
 	JR	NZ,BAD2		;ask again if not same
 	JP	ENTRY		;ask source again
 RESTART	LD	SP,STACK
 	LD	HL,SERMSG	;get serial number
 	CALL	PRINT
 	LD	B,7
 	LD	HL,SERIAL
 	CALL	40H		;get it
 	LD	A,(HL)
 	CP	'X'
 	JP	Z,ENTRY
 	CP	'x'
 	JP	Z,ENTRY
 	LD	A,B
 	CP	7		;7 chars?
 	JR	NZ,RESTART
 	LD	HL,MSG4
 	CALL	PRINT
 	LD	B,1
 	LD	HL,STRING
 	CALL	40H
 	LD	A,(HL)
 	CP	'X'
 	JP	Z,ENTRY
 	CP	'x'
 	JP	Z,ENTRY
 	LD	HL,DOFORMAT	;format all dest drives
 	CALL	DODRIVES	;do all active dest.
 	JP	FMTRET		;back from formatting
 ;
 DOFORMAT	XOR	A
 	LD	(TRAK),A
 ;	LD	A,(DDRIVE)
 ;	CALL	DRIVESET
 	CALL	RESTORE
 	LD	HL,MSGB
 	JP	NZ,ERROR
 	LD	HL,MSG7
 	CALL	PRINT
 FMTLP	CALL	BUILD		;build the format track
 	CALL	WRITTR		;write it out
 	CALL	NZ,WRITTR	;2 attempts
 	LD	HL,MSGC
 	JP	NZ,ERROR
 	CALL	STEPIN
 	LD	HL,MSGF
 	JP	NZ,ERROR
 	LD	A,(TRAK)
 	INC	A
 	LD	(TRAK),A
 	LD	B,A
 	LD	A,(TRAKS)
 	CP	B
 	JR	NZ,FMTLP
 	RET			;back to do the rest
 FMTRET	XOR	A
 	LD	(TRAK),A
 	LD	A,(SDRIVE)
 	CALL	DRIVESET
 	CALL	RESTORE
 	LD	HL,MSGB
 	JP	NZ,ERROR
 	LD	HL,MSG8
 	CALL	PRINT
 	CALL	ZBUFF
 	LD	DE,0
 	LD	BC,BUFFER
 	LD	A,88H
 	LD	(READ+1),A
 COPY0	CALL	READ
 	LD	HL,MSGD
 	JP	NZ,ERROR
 	INC	E
 	LD	A,E
 	SUB	10
 	JR	NZ,COPY0
 	LD	HL,SERIAL
 	LD	DE,BUFFER+0D8H
 	LD	BC,7
 	LDIR
 	LD	HL,DOCOPY0	;copy track 0 routine
 	CALL	DODRIVES	;do all dest.
 	JP	DOCOPY0RET	;return
 ;	LD	A,(DDRIVE)
 ;	CALL	DRIVESET
 DOCOPY0	CALL	RESTORE
 	LD	HL,MSGB
 	JP	NZ,ERROR
 	LD	DE,0
 	LD	BC,BUFFER
 	LD	A,0ABH
 	LD	(WRITE+1),A
 COPY0D	CALL	WRITE
 	LD	HL,MSGE
 	JP	NZ,ERROR
 	INC	E
 	LD	A,E
 	SUB	10
 	JR	NZ,COPY0D
 	RET
 DOCOPY0RET	LD	A,(SDRIVE)
 	CALL	DRIVESET
 	CALL	ZBUFF
 	LD	DE,0100H
 	LD	BC,BUFFER
 	CALL	READ
 	LD	HL,MSGD
 	JP	NZ,ERROR
 	INC	E
 	CALL	READ
 	LD	HL,MSGD
 	JP	NZ,ERROR
 	INC	E
 	CALL	READ
 	LD	HL,MSGD
 	JP	NZ,ERROR
 	LD	HL,SERIAL
 	LD	DE,BUFFER+0CDH
 	LD	BC,0744H
 	CALL	PUTSER
 	LD	HL,SERIAL
 	LD	DE,BUFFER+23CH
 	LD	BC,07C7H
 	CALL	PUTSER
 	LD	HL,DOCOPY1
 	CALL	DODRIVES	;do all dest track 1
 	JP	DOCOPY1RET	;return
 ;	LD	A,(DDRIVE)
 ;	CALL	DRIVESET
 DOCOPY1	CALL	STEPIN
 	LD	HL,MSGF
 	JP	NZ,ERROR
 	LD	DE,3711H
 	LD	A,D
 	LD	(37EDH),A
 	SCF
 	CALL	GETTRK
 	LD	A,0A3H
 	LD	(WRITE+1),A
 	LD	BC,BUFFER
 	CALL	WRITE
 	LD	HL,MSGE
 	JP	NZ,ERROR
 	LD	A,88H
 	LD	(READ+1),A
 	LD	BC,BUFFER+4000H
 	CALL	READ
 	AND	18H
 	CP	8
 	LD	HL,MSGG
 	JP	NZ,ERROR
 	INC	E
 	LD	BC,BUFFER+4000H
 	CALL	READ
 	LD	HL,MSGH
 	AND	18H
 	CP	18H
 	JP	NZ,ERROR
 	INC	E
 	LD	BC,BUFFER+200H
 	CALL	WRITE
 	LD	HL,MSGE
 	JP	NZ,ERROR
 	LD	BC,BUFFER+4000H
 	CALL	READ
 	AND	18H
 	CP	8
 	LD	HL,MSGI
 	JP	NZ,ERROR
 	LD	A,1
 	SCF
 	JP	GETTRK		;return for rest
 DOCOPY1RET	LD	A,2
 	LD	(TRAK),A
 COPYL	LD	A,(SDRIVE)
 	CALL	DRIVESET
 	CALL	ZBUFF
 	LD	BC,BUFFER
 	LD	A,(TRAK)
 	LD	D,A
 	LD	E,0
 	LD	A,88H
 	LD	(READ+1),A
 COPYLL	CALL	READ
 	LD	HL,MSGD
 	JP	NZ,ERROR
 	INC	E
 	LD	A,E
 	SUB	10
 	JR	NZ,COPYLL
 	LD	HL,COPYREST
 	CALL	DODRIVES
 	JP	COPYRESTRET	;continue
 ;	LD	A,(DDRIVE)
 ;	CALL	DRIVESET
 COPYREST	LD	BC,BUFFER
 	LD	E,0
 COPYOL	CALL	WRITE
 	LD	HL,MSGE
 	JP	NZ,ERROR
 	RET
 COPYRESTRET	LD	A,(TRAK)
 	INC	A
 	LD	(TRAK),A
 	LD	B,A
 	LD	A,(TRAKS)
 	CP	B
 	JR	NZ,COPYL
 	LD	HL,MSG5
 	CALL	PRINT
 	JP	RESTART
 BUILD	LD	A,(TRAK)
 	OR	A
 	JR	NZ,BUILD1
 	CALL	ZBUFF
 	LD	HL,BUFFER
 	LD	(TEMP),A
 BUILD0	LD	B,1FH
 	LD	A,0FFH
 	CALL	FILL
 BUILD00	LD	B,6
 	XOR	A
 	CALL	FILL
 	LD	(HL),0FEH
 	INC	HL
 	LD	(HL),0
 	INC	HL
 	LD	(HL),3
 	INC	HL
 	LD	A,(TEMP)
 	LD	(HL),A
 	INC	HL
 	LD	(HL),1
 	INC	HL
 	LD	(HL),0F7H
 	INC	HL
 	LD	B,0BH
 	LD	A,-1
 	CALL	FILL
 	XOR	A
 	LD	B,6
 	CALL	FILL
 	LD	(HL),0F8H
 	INC	HL
 	XOR	A
 	LD	B,A
 	CALL	FILL
 	LD	(HL),0F7H
 	INC	HL
 	LD	A,(TEMP)
 	INC	A
 	LD	(TEMP),A
 	CP	10
 	JR	NZ,BUILD00
 	LD	B,0BH
 	LD	A,-1
 FILL	LD	(HL),A
 	INC	HL
 	DJNZ	FILL
 	RET
 BUILD1	CP	1
 	JP	NZ,BUILD2
 	CALL	ZBUFF
 	LD	HL,BUFFER
 	LD	B,1FH
 	LD	A,-1
 	CALL	FILL
 	LD	B,6
 	XOR	A
 	CALL	FILL
 	LD	(HL),0FEH
 	INC	HL
 	LD	(HL),37H
 	INC	HL
 	LD	(HL),9
 	INC	HL
 	LD	(HL),11H
 	INC	HL
 	LD	(HL),16
 	INC	HL
 	LD	(HL),0F7H
 	INC	HL
 	LD	B,0BH
 	LD	A,-1
 	CALL	FILL
 	XOR	A
 	LD	B,6
 	CALL	FILL
 	LD	(HL),0F8H
 	INC	HL
 	XOR	A
 	LD	B,A
 	CALL	FILL
 	LD	B,0DH
 	LD	A,-1
 	CALL	FILL
 	LD	B,6
 	XOR	A
 	CALL	FILL
 	LD	(HL),0FEH
 	INC	HL
 	LD	(HL),37H
 	INC	HL
 	LD	(HL),9
 	INC	HL
 	LD	(HL),12H
 	INC	HL
 	LD	(HL),32
 	INC	HL
 	LD	B,2
 	XOR	A
 	CALL	FILL
 	LD	B,0BH
 	LD	A,-1
 	CALL	FILL
 	LD	B,6
 	XOR	A
 	CALL	FILL
 	LD	(HL),0FEH
 	INC	HL
 	LD	(HL),37H
 	INC	HL
 	LD	(HL),9
 	INC	HL
 	LD	(HL),13H
 	INC	HL
 	LD	(HL),6
 	INC	HL
 	LD	(HL),0F7H
 	INC	HL
 	LD	B,0BH
 	LD	A,-1
 	CALL	FILL
 	LD	B,6
 	XOR	A
 	CALL	FILL
 	LD	(HL),0F8H
 	INC	HL
 	LD	B,96
 	XOR	A
 	CALL	FILL
 	LD	B,0DH
 	LD	A,-1
 	JP	FILL
 BUILD2	LD	HL,BUFFER
 	LD	B,1FH
 	LD	A,-1
 	CALL	FILL
 	LD	B,6
 	XOR	A
 	CALL	FILL
 	LD	(HL),0FEH
 	INC	HL
 	LD	A,(TRAK)
 	LD	(HL),A
 	INC	HL
 	LD	(HL),3
 	INC	HL
 	LD	(HL),0
 	INC	HL
 	LD	(HL),160
 	INC	HL
 	LD	(HL),0F7H
 	INC	HL
 	LD	B,0BH
 	LD	A,-1
 	CALL	FILL
 	LD	B,6
 	XOR	A
 	CALL	FILL
 	LD	(HL),0F8H
 	INC	HL
 	XOR	A
 	LD	B,A
 	CALL	FILL
 	CALL	FILL
 	CALL	FILL
 	CALL	FILL
 	CALL	FILL
 	CALL	FILL
 	CALL	FILL
 	CALL	FILL
 	CALL	FILL
 	CALL	FILL
 	LD	B,0EH
 	LD	A,-1
 	JP	FILL
 ERROR	PUSH	HL
 	CALL	ASCII
 	LD	(MG),A
 	LD	(MG+1),BC
 	POP	HL
 	CALL	PRINT
 	LD	HL,MSG6
 	CALL	PRINT
 	LD	HL,STRING
 	LD	B,1
 	CALL	40H
 	JP	ENTRY
 ASCII	PUSH	HL		;save from this
 	CALL	ASCI		;convert to ascii
 	LD	H,B		;save lsb here
 	PUSH	HL
 	LD	A,C		;get msb
 	SUB	30H		;remove ascii
 	CALL	ASCI
 	LD	A,C		;get msb
 	CP	'0'		;leading 0 ?
 	JR	NZ,ASCIGO1
 	LD	A,20H
 ASCIGO1	POP	HL		;restore hl
 	LD	C,B
 	LD	B,H		;ACB = ascii
 	POP	HL
 	RET
 ASCI	LD	C,'0'		;start with 0
 ASCII1	SUB	10		;repeat 10 subtract
 	JR	C,ASCII2
 	INC	C		;bump msb
 	JR	ASCII1
 ASCII2	ADD	A,3AH		;make this ascii
 	LD	B,A		;BC = ascii
 	RET
 WRITTR	LD	BC,BUFFER
 	LD	HL,37ECH
 	LD	DE,37EFH
 	CALL	SELECT
 	RET	NZ
 	DI
 	LD	(HL),0F4H
 	CALL	DSKSLO
 	JR	CKWR
 CKWR1	RRCA
 	JR	NC,CKWR2
 CKWR	LD	A,(HL)
 	BIT	1,A
 	JR	Z,CKWR1
 	LD	A,(BC)
 	LD	(DE),A
 	INC	BC
 	JR	CKWR
 CKWR2	LD	A,(HL)
 	LD	(HL),0D0H
 	AND	0E4H
 	RET
 GETTRK	PUSH	HL		;save HL
 	PUSH	AF		;save C flag
 	LD	HL,CTRACK	;current track table
 	LD	A,0		;binary drive
 DRIVE	EQU	$-1
 	ADD	A,L		;point to right byte
 	LD	L,A
 	POP	AF		;restore C flag
 	JR	C,PUTIN		;C = put in table
 	LD	A,(HL)		;get the byte
 PUTIN	LD	(HL),A		;put byte in table
 	POP	HL		;restore HL
 	OR	A		;set flags this byte
 	RET			;done
 WRITE	LD	A,0ABH		;data write
 	EX	AF,AF'
 	LD	HL,120AH	;transfer direction
 	LD	A,0FCH		;error mask byte
 	JR	IOCOMM		;go common
 READ	LD	A,88H		;IBM read command
 	EX	AF,AF'		;pass here
 	LD	A,9CH		;error mask
 	LD	HL,021AH	;direction
 IOCOMM	LD	(WAY),HL	;save direction
 	LD	(MASK),A	;save error mask
 	EX	AF,AF'		;get operation byte
 	LD	(IOTYPE),A	;save this
 	PUSH	BC		;save load address
 	CALL	TRYONE		;try it once
 	POP	HL		;HL = address
 	RET	Z		;OK first time
 	LD	B,H		;HL => BC
 	LD	C,L
 TRYONE	LD	HL,37ECH	;FDC address
 	CALL	SELECT		;turn on drive
 	RET	NZ		;bad already
 	CALL	SEEK		;move head to track
 	RET	NZ		;bad seek
 	DI
 	LD	(HL),0		;issue the command
 IOTYPE	EQU	$-1
 	PUSH	DE		;save track/sector
 	LD	DE,37EFH	;FDC transfer address
 	CALL	DSKSLO		;wait for valid status
 	JR	XFF2
 XFER1	RRCA
 	JR	NC,XFER3
 XFF2	LD	A,(HL)
 	BIT	1,A
 	JR	Z,XFER1
 WAY	LD	A,(DE)		;set from above
 	LD	(BC),A
 	INC	BC		;bump buffer pointer
 	JR	XFF2
 XFER3	LD	A,(HL)		;read result of I/O
 	POP	DE		;restore track/sector
 	AND	0		;check status bits
 MASK	EQU	$-1
 	LD	(HL),0D0H
 	RET			;now return
 DRVASC	LD	A,(DRIVE)	;get binary drive
 	ADD	A,30H		;add ascii
 	RET			;that's all
 DSKSLO	EX	(SP),HL		;wait for valid FDC
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	RET
 SEEK	OR	A		;clear carry
 	CALL	GETTRK		;get current track
 	JR	NZ,SEEK1	;continue if not 0
 	CALL	RESTORE		;restore to track 0
 	RET	NZ		;bad one
 SEEK1	LD	(37EDH),A	;give track to FDC
 	LD	(37EEH),DE	;desired track to 37EFH
 	CP	D		;already on the track?
 	JR	Z,SEEK2		;don't bother with it
 	LD	A,18H		;seek command
 	CALL	MOVE		;move the head
 	RET	NZ		;error in move
 SEEK2	LD	A,(37EDH)	;get current track
 	SCF			;carry = put in table
 	CALL	GETTRK		;put it in
 	XOR	A		;set Z flag
 	RET			;done OK
 STEPIN	LD	A,58H
 	LD	HL,37ECH
 	CALL	MOVE
 	LD	A,(HL)
 	BIT	4,A
 	RET	NZ
 	JR	SEEK2
 RESTORE	LD	A,08H		;drive restore command
 	LD	HL,37ECH
 	CALL	MOVE		;move the head
 	RET	NZ		;bad
 	LD	A,(HL)		;get the status byte
 	CPL			;reverse the bits
 	BIT	2,A		;head over track 0 ?
 	LD	A,0		;set track 0
 	RET	NZ
 	JP	SEEK2
 MOVE	LD	(HL),A		;give command to FDC
 MOVEWT	CALL	SELECT		;select the drive
 	RET	NZ		;dropped ready
 	BIT	0,(HL)		;command done?
 	RET	Z		;return if yes
 	JR	MOVEWT		;else wait some more
 DRIVESET	LD	(DRIVE),A	;save binary driv
 	LD	B,1		;which bit to set
 	OR	A		;set flags
 	JR	DRVCK		;have it
 DRVSET	SLA	B		;move drive bit left
 	DEC	A		;binary - 1
 DRVCK	JR	NZ,DRVSET	;continue loop
 	LD	A,B		;get bit
 	LD	(DRIV),A	;save for drive select
 	RET			;done
 SELECT	BIT	7,(HL)
 	LD	A,0		;get drive bit
 DRIV	EQU	$-1
 	LD	(37E1H),A	;select the drive
 	RET	Z		;already was on
 	PUSH	BC		;save this
 	LD	BC,0		;1 second delay time
 	CALL	DELAY		;decrement BC till 0
 	CALL	DELAY
 	POP	BC		;restore it
 	JR	SELECT
 ZBUFF	LD	HL,BUFFER
 	LD	DE,BUFFER+1
 	LD	BC,3000H
 	LD	(HL),0
 	LDIR
 	RET
 PUTSER	LD	A,(HL)		;get serial byte
 	XOR	C
 	LD	(DE),A		;put in buffer
 	INC	HL
 	INC	DE
 	DJNZ	PUTSER
 	RET
 PRINT	LD	A,(HL)
 	CP	3
 	RET	Z
 	CP	20H
 	JR	C,GOROM
 	PUSH	HL
 	LD	HL,(4020H)
 	LD	(HL),A
 	CP	(HL)
 	JR	Z,PRTOK
 	SUB	20H
 	LD	(HL),A
 PRTOK	INC	HL
 	LD	(4020H),HL
 	POP	HL
 	INC	HL
 	JR	PRINT
 GOROM	PUSH	IY
 	PUSH	DE
 	CALL	33H
 	POP	DE
 	POP	IY
 	CP	13
 	RET	Z
 	INC	HL
 	JR	PRINT
 ;*
 DODRIVES	LD	(DRVCODE),HL	;save call route
 	LD	BC,3		;3 byte loop
 	LD	(DDRVPOS),BC	;save position
 DODRVLP	LD	BC,0	;get position
 DDRVPOS	EQU	$-2		;save LSB
 	LD	HL,DDRIVE	;get pointer
 	DEC	C		;reduce by 1
 	LD	(DDRVPOS),BC	;save new position
 	PUSH	AF		;save Z flag
 	ADD	HL,BC		;point to table byte
 	LD	A,(HL)		;fetch it
 	CP	0FFH		;in use?
 	JR	Z,SKIPDRV	;skip this drive
 	CALL	DRIVESET	;set up the drive
 	CALL	0		;call the routine
 DRVCODE	EQU	$-2
 SKIPDRV	POP	AF		;restore Z flag
 	RET	Z		;done if yes
 	JR	DODRVLP		;else continue
 MSG1	DB	1CH,1FH,'**  SUPER-UTILITY + copy utility  ** - by Kim Watt',10,10
 	DB	'For INTERNAL use ONLY !!!!  DO NOT DUPLICATE !!!!',10,10,13
 MSG1A	DB	1CH,1FH,'**  SU+ Copy Utility  **',10,10
 	DB	'Testing Buffer Memory',3
 MSG1B	DB	10,10,'MEMORY BAD !!',10
 	DB	'Key <ENTER> to Restart. ',3
 MSG2	DB	'Source Drive ? ',3
 MSG3	DB	'Destination Drive ? ',3
 MSG4	DB	'Mount All Disks, Key <ENTER>. ',3
 MSG5	DB	'Finished, verify OK.',10,13
 MSG6	DB	'ERROR '
 MG	DB	'XXX, DO NOT use that disk !',10
 	DB	'Key <ENTER> to restart. ',3
 MSG7	DB	'Formatting.',13
 MSG8	DB	'Copying.',13
 MSGA	DB	'SEEK ERROR',13
 MSGB	DB	'RESTORE ERROR',13
 MSGC	DB	'WRITE TRACK ERROR',13
 MSGD	DB	'READ ERROR',13
 MSGE	DB	'WRITE ERROR',13
 MSGF	DB	'STEP ERROR',13
 MSGG	DB	'PROTECTION ERROR TYPE 1',13
 MSGH	DB	'PROTECTION ERROR TYPE 2',13
 MSGI	DB	'PROTECTION ERROR TYPE 3',13
 SERMSG	DB	10,'Serial Number (7 chars) ? ',3
 SERIAL	DB	'00000000'
 DBUFF	EQU	$&0FF00H
 BUFFER	EQU	DBUFF+100H
 	END	BEGIN
TION ERROR TYPE 1',13
 MSGH	DB	'PROTECTION ERROR TYPE 2',13
 MSGI	DB	'PROTECTION ERROR TYP