IODVR  ;	IODVR/ASM
 DISPLY	EX	(SP),HL
 	PUSH	DE
 	PUSH	BC
 PRINT	LD	A,(HL)		;GET BYTE FROM STRING
 	INC	HL		;BUMP STRING POINTER
 	CP	3		;TERMINATOR
 	JR	Z,DISPDONE
 	CALL	VOUT		;OUTPUT TO VIDEO
 	CP	0DH		;TERMINATOR ?
 	JR	NZ,PRINT		;GO SOME MORE
 DISPDONE	POP	BC
 	POP	DE
 	EX	(SP),HL
 	RET
 GETSTR	LD	DE,3C00H
 CURSOR	EQU	$-2
 	LD	HL,STRING
 	LD	C,0
 GETST1	LD	(CURSOR),DE
 	CALL	KISCAN
 	CP	1
 	JP	Z,ENTRY
 	CP	13
 	JR	Z,GETST2
 	CP	31
 	JR	Z,GETST3
 	EX	AF,AF'
 	LD	A,B
 	CP	C
 	JR	Z,GETST1
 	EX	AF,AF'
 	LD	(HL),A
 	LD	(DE),A
 	INC	DE
 	INC	HL
 	INC	C
 	LD	A,143
 	LD	(DE),A
 	JR	GETST1
 GETST2	LD	(HL),13
 	LD	A,20H
 	LD	(DE),A
 	LD	HL,STRING
 	LD	B,C
 	LD	A,C
 	OR	A
 	LD	A,(HL)
 	RET
 GETST3	LD	A,C
 	OR	A
 	JR	Z,GETST1
 	LD	A,20H
 	LD	(HL),A
 	LD	(DE),A
 	DEC	HL
 	DEC	DE
 	DEC	C
 	JR	GETST1
 VOUT	PUSH	HL
 	LD	HL,(CURSOR)	;GET CURSOR POSITION
 	CP	20H		;CONTROL BYTE ?
 	JR	C,GOCTL		;DO CONTROL IF <20H
 CTLRET	LD	(HL),A		;PUT ON VIDEO
 	INC	HL		;BUMP CURSOR
 VDONE	LD	(CURSOR),HL
 	PUSH	AF
 	LD	A,H
 	CP	3CH
 	CALL	C,NEWCUR
 	LD	A,H
 	CP	40H
 	CALL	NC,SCROLL
 	LD	(CURSOR),HL
 	POP	AF
 	POP	HL
 	RET
 NEWCUR	LD	HL,3D00H
 VIDTOP	EQU	$-2
 	RET
 GOCTL	CP	0DH		;CARRIAGE RETURN ?
 	JR	Z,LINFED	;DO IT
 	CP	10
 	JR	Z,LINFED
 	CP	1CH		;HOME CURSOR ?
 	JR	Z,HOME
 	CP	1FH		;CLEAR ?
 	JR	Z,CLEAR
 	CP	1DH		;BEGIN LINE
 	JR	Z,BLINE
 	CP	1EH		;ERASE LINE
 	JR	Z,ERASE
 	LD	A,5DH		;UNDEFINED BYTE DISPLY
 	JR	CTLRET		;CONTINUE
 LINFED	PUSH	DE		;SAVE DE
 	LD	DE,40H		;ONE LINE DOWN
 	PUSH	AF		;SAVE CHAR
 	LD	A,L		;GET LSB
 	AND	0C0H		;START OF LINE
 	LD	L,A		;PUT IT BACK
 	POP	AF		;RESTORE AF
 	ADD	HL,DE		;DROP DOWN A LINE
 	POP	DE		;RESTORE DE
 	JR	VDONE		;FINISHED
 HOME	LD	HL,(VIDTOP)
 	JR	VDONE
 CLEAR	PUSH	AF		;SAVE CHARACTER
 	PUSH	DE		;SAVE DE
 	EX	DE,HL		;DE=CURSOR
 	LD	HL,4000H	;END OF SCREEN
 CLICO	OR	A		;CLEAR CARRY
 	SBC	HL,DE		;# BYTES TO MOVE
 	EX	DE,HL		;HL=CURSOR,DE=NUMBER
 	PUSH	HL		;SAVE CURSOR
 CLINE	LD	(HL),20H	;PUT A SPACE
 	DEC	DE		;LESS COUNT
 	INC	HL
 	LD	A,D
 	OR	E		;ANY BITS LEFT ON ?
 	JR	NZ,CLINE	;CONTINUE
 	POP	HL		;RESTORE
 	POP	DE
 	POP	AF
 	JP	VDONE		;GO BACK
 ERASE	PUSH	AF		;SAVE BYTE
 	PUSH	DE
 	LD	A,L
 	AND	0C0H		;PUT CURSOR AT BOL
 	LD	L,A
 	EX	DE,HL		;DE=CURSOR
 	LD	H,D		;GET MSB
 	LD	A,E		;GET LSB
 	OR	3FH		;END OF LINE
 	LD	L,A
 	JR	CLICO		;CONTINUE
 BLINE	PUSH	AF		;SAVE BYTE
 	LD	A,L		;GET LSB
 	AND	0C0H		;BEGINNING OF LINE
 	LD	L,A		;PUT IT BACK
 	POP	AF		;RESTORE BYTE
 	JP	VDONE
 SCROLL	PUSH	BC
 	PUSH	DE
 	LD	DE,(VIDTOP)	;TOP LINE OF SCREEN
 	LD	HL,4000H	;END OF SCREEN
 	OR	A		;CLEAR CARRY
 	SBC	HL,DE		;SUBTRACT
 	LD	DE,40H		;LESS ONE MORE LINE
 	OR	A
 	SBC	HL,DE		;HL=LENGTH TO MOVE
 	PUSH	HL
 	POP	BC		;GIVE TO BC
 	LD	HL,(VIDTOP)	;GET VIDEO TOP
 	PUSH	HL		;SAVE FOR DE
 	ADD	HL,DE		;DOWN ONE LINE
 	POP	DE		;DE=TOPLINE/HL=DE+40H
 	LDIR			;MOVE THE BYTES
 	LD	HL,3FC0H
 VIDBOT	EQU	$-2
 	LD	B,40H		;ERASE IT
 SCR2	LD	(HL),20H
 	INC	HL
 	DJNZ	SCR2
 	POP	DE		;RESTORE REGS
 	POP	BC
 	LD	HL,(VIDBOT)	;CURSOR TO BOTTOM
 	RET			;DONE
 START0	CALL	CLEARS
 	JP	START
 ENTRY0	CALL	CLEARS
 	JP	ENTRY
 CLEARS	LD	A,1CH		;HOME CURSOR
 	CALL	VOUT		;PRINT IT
 	LD	A,1FH		;CLEAR TO EOF
 	CALL	VOUT		;DO IT
 	LD	A,4
 	RET
 UCASE	CP	60H
 	RET	C
 	AND	5FH
 	RET
 KIMASK	DB	0,0,0,0,0,0,0	;keyboard work area-mask
 INKEY	LD	HL,KIMASK	;mask area
 	LD	BC,3801H	;keyboard matrix
 	LD	D,0		;row counter
 INL1	LD	A,(BC)		;get a byte
 	LD	E,A		;save here
 	XOR	(HL)		;check with mask
 	LD	(HL),E		;save new key
 	AND	E		;same as last time?
 	JR	NZ,INL2		;go if new key
 	INC	D		;bump row counter
 	INC	L		;bump mask pointer
 	RLC	C		;point to next row
 	JP	P,INL1		;go till last row
 	XOR	A
 	RET			;no key pressed
 INL2	LD	E,A
 	LD	A,D
 	RLCA
 	RLCA
 	RLCA
 	LD	D,A
 	LD	C,1
 INL3	LD	A,C
 	AND	E
 	JR	NZ,INL4		;go if found
 	INC	D
 	RLC	C
 	JR	INL3
 INL4	LD	E,D
 	LD	D,0		;DE = location in matrix
 	LD	HL,KITABLE	;lookup table
 	LD	A,(3880H)
 	OR	A
 	JR	Z,UTKIT
 	LD	HL,KITABLE2
 UTKIT	ADD	HL,DE		;point to byte
 	LD	BC,800H
 	CALL	60H
 	LD	A,(HL)		;fetch it
 	OR	A
 	RET
 KITABLE	DB	'@ABCDEFG'
 	DB	'HIJKLMNO'
 	DB	'PQRSTUVW'
 	DB	'XYZ`````'
 	DB	'01234567'
 	DB	'89:;,-./'
 	DB	13,31,5FH,5BH,5CH,5DH,5EH,20H
 KITABLE2	DB	'`abcdefg'
 	DB	'hijklmno'
 	DB	'pqrstuvw'
 	DB	'xyz`````'
 	DB	' !"#$%&',27H
 	DB	'()*+<=>?'
 	DB	183,179,187,7BH,7CH,7DH,7EH,7FH
 KISCAN	LD	A,140
 	LD	(DE),A
 KISCAN0	PUSH	HL
 	PUSH	DE
 	PUSH	BC
 	CALL	INKEY		;check keyboard
 	POP	BC
 	POP	DE
 	POP	HL
 	RET	NZ
 	PUSH	BC
 	LD	BC,800H
 DLYCNT	EQU	$-2
 	DEC	BC
 	LD	(DLYCNT),BC
 	LD	A,B
 	OR	C
 	POP	BC
 	JR	NZ,KISCAN0
 	PUSH	BC
 	LD	BC,500H
 	LD	(DLYCNT),BC
 	POP	BC
 	LD	A,(DE)
 	CP	140
 	JR	NZ,KISCAN
 	LD	A,95
 	JR	KISCAN+2
