HOWDO  ;	HOWDO/ASM
 SOURCE	DB	0
 DEST	DB	1
 PREENTRY	DI
 	LD	SP,STACK
 	LD	A,(SOURCE)
 	ADD	A,30H
 	LD	(SRCDRV),A
 	LD	A,(DEST)
 	ADD	A,30H
 	LD	(DESDRV),A
 	LD	A,0D0H
 	OUT	(0F0H),A
 	XOR	A
 	OUT	(0E4H),A
 	LD	A,4
 	OUT	(0E0H),A
 	LD	A,20H
 	OUT	(0ECH),A
 	IM	1
 	EI
 	CALL	CLEARSCR
 	RST	8
 	DB	1CH,1FH,3
 	RST	18H
 	RST	20H
 STARTHERE	RST	8
 	DB	10,'Super-Utility Plus Copy Utility'
 	DB	10,'For Internal Use Only'
 	DB	10,'DO NOT DUPLICATE'
 	DB	10,10,'Testing Buffer Memory ...',13
 	CALL	TESTMEM
 	LD	A,H
 	DEC	HL
 	LD	(TMEM1),A
 	LD	(TMEM2),A
 	LD	(TMEM3),A
 	LD	A,H
 	PUSH	HL
 	RST	30H
 	LD	(TM1),HL
 	POP	HL
 	LD	A,L
 	RST	30H
 	LD	(TM1+2),HL
 	RST	8
 	DB	10,'Topmem = '
 TM1	DB	'xxxxH.',13
 ENTRY	LD	SP,STACK
 	EI
 	RST	8
 	DB	1EH,'Destination Drive (1-3) ? ',3
 	LD	B,1
 	RST	10H
 	JR	Z,GETSPDS
 	SUB	30H
 	JR	C,ENTRY
 	CP	1
 	JR	C,ENTRY
 	CP	4
 	JR	NC,ENTRY
 	LD	(DEST),A
 	ADD	A,30H
 	LD	(DESDRV),A
 	RST	18H
 	RST	20H
 GETSPDS	RST	8
 	DB	1EH,'Step Speed (0=6ms,1=12ms,2=20ms,3=40ms, default 0) ? ',3
 	LD	B,1
 	RST	10H
 	LD	A,0
 	LD	(SPEED),A
 	JR	Z,HSPD
 	LD	A,(HL)
 	SUB	30H
 	JR	C,GETSPDS
 	CP	4
 	JR	NC,GETSPDS
 	LD	(SPEED),A
 HSPD	ADD	A,30H
 	LD	(ST81),A
 	RST	20H
 ASKMOD	RST	8
 	DB	10,'A> Mod I, B> Mod III, C> Mod I&III ? ',3
 	LD	B,1
 	RST	10H
 	JR	Z,ASKMOD
 	CP	'A'
 	JR	C,ASKMOD
 	CP	'D'
 	JR	NC,ASKMOD
 	LD	(MODEL),A
 	RST	18H
 	RST	20H
 ASKSER	RST	8
 	DB	10,'Serial Number (7 chars) ? ',3
 	LD	B,7
 	RST	10H
 	JR	Z,ASKSER
 	LD	A,B
 	CP	7
 	JR	NZ,ASKSER
 	LD	C,B
 	LD	B,0
 	LD	DE,SERSAVE
 	LDIR
 START	LD	SP,STACK	;RESET STACK FROM BREAK
 	RST	20H		;TITLE
 	RST	18H		;HOWMANY COPIES
 	RST	8		;MESSAGE
 	DB	10,'Mount all disks, key <ENTER>. ',3
 	LD	B,1
 	RST	10H
 	XOR	A		;START WITH TRACK 0
 	SBC	HL,HL
 	LD	(TRACK),A	;SAVE IT
 	LD	(PLACE),HL
 	LD	(STEPFLAG),A
 	LD	A,(MODEL)
 	CP	'B'
 	JR	NZ,FORMAT
 	INC	L
 	LD	(PLACE),HL
 FORMAT	LD	IY,TRACKS
 	LD	A,(DEST)
 	CALL	DRVBIT		;SET BIT FOR DRIVE SELECT
 	XOR	A
 	LD	(STEPFLAG),A
 	LD	D,0
 	CALL	RESTORE		;RESTORE THE DRIVE
 	CALL	FORM
 BEGIN	XOR	A		;ZERO TRACK AGAIN
 	LD	(TRACK),A	;SAVE IT
 	LD	IY,TRACKS	;POINT TO TRACK COUNT
 COPY	LD	A,(SOURCE)
 	CALL	DRVBIT
 	LD	DE,0
 PLACE	EQU	$-2
 	LD	(TRAK),DE	;SAVE FOR WRITE
 	XOR	A
 	LD	(STEPFLAG),A
 	CALL	MREAD		;MULTIPLE SECTOR READ
 	LD	(PLACE),DE
 	LD	A,(DEST)
 	CALL	DRVBIT		;SET DRIVE BIT
 	LD	DE,(TRAK)	;GET TRACK
 	CALL	MWRITE		;MULTIPLE WRITE
 	CALL	VERIFY		;DO IT IF YES
 	LD	A,(PLACE+1)	;GET CURRENT TRACK
 	CP	(IY)		;END ?
 	JP	NZ,COPY		;CONTINUE
 	RST	8
 	DB	10,'Installing Serial Number',3
 	LD	A,(SOURCE)
 	CALL	DRVBIT
 	LD	BC,BUFFER
 	XOR	A
 	LD	(DENSITY),A
 	LD	DE,10
 	CALL	READ
 	JP	NZ,STOP
 	LD	A,(DEST)
 	CALL	DRVBIT
 	LD	BC,BUFFER
 	LD	DE,030AH
 	CALL	WRITE
 	JP	NZ,BADWRT
 	LD	A,80H
 	LD	(DENSITY),A
 	INC	E
 	LD	BC,BUFFER
 	CALL	WRITE
 	JP	NZ,BADWRT
 	LD	A,(MODEL)
 	CP	'A'
 	CALL	NZ,IIISERIAL
 	LD	A,(MODEL)
 	CP	'B'
 	CALL	NZ,ISERIAL
 	LD	A,(MODEL)
 	CP	'A'
 	CALL	Z,IBOOT
 	LD	A,(MODEL)
 	CP	'B'
 	CALL	Z,IIIBOOT
 	JP	ATEND
 IIIBOOT	LD	A,(SOURCE)
 	CALL	DRVBIT
 	XOR	A
 	LD	(DENSITY),A
 	LD	DE,030AH
 	LD	BC,BUFFER
 	CALL	READ
 	JP	NZ,STOP
 	LD	A,(DEST)
 	CALL	DRVBIT
 	LD	DE,0300H
 	LD	BC,BUFFER
 	CALL	WRITE
 	JP	NZ,BADWRT
 	LD	A,(SOURCE)
 	CALL	DRVBIT
 	LD	DE,0
 	LD	BC,BUFFER
 	CALL	READ
 	JP	NZ,STOP
 	LD	A,(DEST)
 	CALL	DRVBIT
 	LD	BC,BUFFER
 	CALL	WRITE
 	JP	NZ,BADWRT
 	RET
 IBOOT	LD	A,(SOURCE)
 	CALL	DRVBIT
 	LD	A,80H
 	LD	(DENSITY),A
 	LD	BC,BUFFER
 	LD	DE,030BH
 	CALL	READ
 	JP	NZ,STOP
 	LD	A,(DEST)
 	CALL	DRVBIT
 	LD	BC,BUFFER
 	LD	DE,0301H
 	CALL	WRITE
 	JP	NZ,BADWRT
 	LD	A,(SOURCE)
 	CALL	DRVBIT
 	LD	DE,1
 	LD	BC,BUFFER
 	CALL	READ
 	JP	NZ,STOP
 	LD	A,(DEST)
 	CALL	DRVBIT
 	LD	BC,BUFFER
 	CALL	WRITE
 	JP	NZ,BADWRT
 	RET
 ISERIAL	LD	A,(DEST)
 	CALL	DRVBIT
 	LD	BC,BUFFER
 	LD	DE,0302H
 	XOR	A
 	LD	(DENSITY),A
 	CALL	READ
 	JP	NZ,BADWRT
 	CALL	PUTSER
 	CALL	WRITE
 	JP	NZ,BADWRT
 	RET
 IIISERIAL	LD	A,(DEST)
 	CALL	DRVBIT
 	LD	A,80H
 	LD	(DENSITY),A
 	LD	BC,BUFFER
 	LD	DE,0303H
 	CALL	READ
 	JP	NZ,BADWRT
 	CALL	PUTSER
 	CALL	WRITE
 	JP	NZ,BADWRT
 	RET
 ATEND	RST	8
 	DB	13		;CARRIAGE RETURN
 	LD	HL,(CURSOR)	;GET CURSOR
 	PUSH	HL		;GIVE TO DE
 	POP	DE
 	INC	DE		;CURSOR +1
 	LD	(HL),140	;GRAPHIC BLOCK
 	LD	BC,63
 	LDIR			;DRAW LINE
 	RST	8		;DROP ANOTHER LINE
 	DB	13
 	LD	A,(DEST)
 	ADD	A,30H
 	LD	(GOODDRV),A
 	RST	8
 	DB	10,'Drive '
 GOODDRV	DB	'0 Copied OK.',3
 	LD	A,(MODEL)
 	CP	'A'
 	JR	Z,PRTMA
 	CP	'B'
 	JR	Z,PRTMB
 	RST	8
 	DB	10,'Mod I & III version installed.',13
 	JP	COPYBYE
 PRTMA	RST	8
 	DB	10,'Mod I version installed.',13
 	JP	COPYBYE
 PRTMB	RST	8
 	DB	10,'Mod III version installed.',13
 	JP	COPYBYE		;DONE
 DRVBIT	PUSH	DE		;SAVE DE
 	LD	(DRIVE),A
 	LD	E,1		;BIT 0
 BITLOOP	OR	A		;CHECK IF 0
 	JR	Z,BITFND	;FOUND IF 0
 	DEC	A		;DRIVE -1
 	SLA	E		;MOVE DRIVE BIT
 	JR	BITLOOP		;CONTINUE
 BITFND	LD	A,E		;GET BIT
 	POP	DE		;RESTORE DE
 	LD	(DRIV),A
 	RET			;DONE
 CLEARSCR	LD	HL,3C00H	;VIDEO
 	LD	DE,3C01H
 	LD	BC,1023
 	LD	(HL),20H	;SPACE
 	LDIR			;CLEAR SCREEN
 	LD	HL,3C80H
 	LD	DE,3C81H
 	LD	BC,63
 	LD	(HL),140
 	LDIR
 	LD	HL,3CC0H
 	LD	(CURSOR),HL
 	RET			;DONE
 MSG0	DB	'SPECIAL-DISK COPY III by Kim Watt - Source='
 SRCDRV	DB	'0, Dest='
 DESDRV	DB	'2 Type='
 MODEL	DB	'C       '
 HOWMANY	LD	A,35
 TRACKS	EQU	$-1
 	RST	28H
 	LD	(MANY3),A
 	LD	(MANY3+1),BC
 	LD	HL,MSG1		;POINT TO MESSAGE
 	LD	DE,3C40H	;VIDEO LINE 2
 	LD	B,64		;64 CHARS
 	JP	PUTITON		;PRINT IT
 MSG1	DB	'Step='
 ST81	DB	'0, Tracks='
 MANY3	DB	'000. Serial # ='
 SERSAVE	DB	'xxxxxxx.                                      '
 FORM	LD	A,(DRIVE)	;GET BINARY DRIVE
 	ADD	A,30H		;MAKE IT ASCII
 	LD	(FMTDRV),A	;PUT IN STRING
 	RST	8		;ONE CARRIAGE RETURN
 	DB	13
 FORMLP	LD	A,0
 TRACK	EQU	$-1
 	RST	28H		;MAKE IT ASCII
 	LD	(FMTTRK),A	;PUT IN STRING
 	LD	(FMTTRK+1),BC
 	RST	8
 	DB	1DH		;BEGINNING OF LINE
 	DB	'Formatting - Drive '
 FMTDRV	DB	'0, Track '
 FMTTRK	DB	'000.',3
 	LD	IY,TRACKS
 	CALL	FORMIT
 	JP	NZ,BADWRT
 	LD	A,(TRACK)	;GET TRACK
 	INC	A		;BUMP IT
 	LD	(TRACK),A	;SAVE IT
 	CP	(IY)		;END OF DISK ?
 	RET	Z		;FINISHED IF YES
 	CALL	STEPIN		;STEP IN DRIVE
 	JP	FORMLP		;GO LOOP
 MREAD	RST	8
 	DB	13
 	LD	A,(DRIVE)
 	ADD	A,30H
 	LD	(RDDR),A
 	LD	BC,BUFFER
 	LD	IX,POINTER	;TO SAVE READ TYPE
 READLP	PUSH	BC		;SAVE BUFFER
 	LD	A,B
 	RST	30H
 	LD	(BUFF1),HL
 	LD	A,E
 	RST	28H
 	LD	(RDSC),A
 	LD	(RDSC+1),BC
 	LD	A,D
 	RST	28H
 	LD	(RDTK),A
 	LD	(RDTK+1),BC
 	RST	8
 	DB	1DH,'Reading   Drive '
 RDDR	DB	'0, Track '
 RDTK	DB	'000, Sector '
 RDSC	DB	'000, Buffer '
 BUFF1	DB	'0000H.',3
 	POP	BC		;LOAD ADDRESS
 	CALL	SETDEN
 	CALL	READ
 	JR	NZ,STOP
 	LD	A,0
 RESULT	EQU	$-1
 	RRCA
 	RRCA
 	RRCA
 	RRCA
 	RRCA
 	AND	1
 	OR	0A0H
 	LD	(IX),A		;SAVE IN TABLE
 	INC	IX
 	CALL	NEXSEC
 READEN	LD	A,B		;GET BUFFER POINTER
 	CP	0		;end of memory?
 TMEM1	EQU	$-1
 	RET	Z
 	LD	A,D		;GET TRACK
 	CP	(IY)		;AT END ?
 	RET	NC
 	JP	READLP
 STOP2	RST	8
 	DB	10,'Key <ENTER> to restart. ',3
 	LD	B,1
 	RST	10H
 	JP	START
 STOP	RST	8
 	DB	10,'Source Read Error, <ENTER> to restart. ',3
 	LD	B,1
 	RST	10H
 	JP	BEGIN
 VERIFY	LD	BC,BUFFER	;READ BUFFER
 	LD	(BPOINT),BC	;SAVE IN BUFFER POINTER
 	LD	A,(DRIVE)
 	ADD	A,30H		;MAKE IT ASCII
 	LD	(VDR),A
 	RST	8
 	DB	13
 	LD	DE,0
 TRAK	EQU	$-2
 	LD	IX,POINTER	;READ TYPE POINTER
 VERLOOP	LD	BC,0
 BPOINT	EQU	$-2
 	LD	A,B		;GET BUFFER
 	RST	30H		;HEX ASCII
 	LD	(BUFF5),HL	;TO STRING
 	LD	A,E		;GET SECTOR
 	RST	28H
 	LD	(VSC),A
 	LD	(VSC+1),BC
 	LD	A,D
 	RST	28H
 	LD	(VRTK),A
 	LD	(VRTK+1),BC
 	RST	8
 	DB	1DH
 	DB	'Verifying Drive '
 VDR	DB	'0, Track '
 VRTK	DB	'000, Sector '
 VSC	DB	'000, Buffer '
 BUFF5	DB	'0000H.',3
 	LD	BC,VERBUFF	;VERIFY READ BUFFER
 	CALL	SETDEN
 	CALL	READ
 	JP	NZ,BADWRT
 	LD	A,(RESULT)	;GET READ RESULT
 	RRCA
 	RRCA
 	RRCA
 	RRCA
 	RRCA
 	AND	1
 	OR	0A0H
 	CP	(IX)		;SAME ?
 	INC	IX
 	JP	NZ,BADWRT
 	LD	HL,(BPOINT)	;GET BUFFER POINTER
 	PUSH	DE		;SAVE TRACK/SECTOR
 	LD	DE,VERBUFF	;VERIFY BUFFER
 	LD	B,0		;1 SECTOR
 	CALL	COMPARE		;COMPARE 'EM
 	POP	DE
 	JP	NZ,BADWRT
 VERIFGO	LD	HL,(BPOINT)	;BUMP IT
 	INC	H
 	LD	(BPOINT),HL	;PUT IT BACK
 	CALL	NEXSEC
 	LD	BC,(BPOINT)	;GET BUFFER POINTER
 	LD	A,B		;GET MSB
 	CP	0
 TMEM2	EQU	$-1
 	RET	Z
 	LD	A,D		;GET TRACK
 	CP	(IY)		;AT END ?
 	RET	NC
 	JP	VERLOOP		;GO LOOP
 COMPARE	LD	A,(DE)		;GET A BYTE
 	CP	(HL)		;SAME ?
 	RET	NZ		;NOPE IF NZ
 	INC	HL
 	INC	DE		;BUMP POINTERS
 	DJNZ	COMPARE		;CONTINUE 100H BYTES
 	RET			;Z FLAG SET
 MWRITE	LD	A,(DRIVE)
 	ADD	A,30H
 	LD	(WDR),A
 	RST	8
 	DB	13
 	LD	BC,BUFFER	;POINT TO BUFFER
 	LD	IX,POINTER	;FOR WRITE TYPE
 WRITELP	LD	A,(IX)		;GET TABLE BYTE
 	INC	IX		;BUMP POINTER
 	LD	(TYPE),A	;SAVE IN CODE
 	PUSH	BC
 	LD	A,B
 	RST	30H
 	LD	(BUFF3),HL
 	LD	A,E
 	RST	28H
 	LD	(WRSC),A
 	LD	(WRSC+1),BC
 	LD	A,D
 	RST	28H
 	LD	(WRTK),A
 	LD	(WRTK+1),BC
 	RST	8
 	DB	1DH
 	DB	'Writing   Drive '
 WDR	DB	'0, Track '
 WRTK	DB	'000, Sector '
 WRSC	DB	'000, Buffer '
 BUFF3	DB	'0000H.',3
 	POP	BC
 	CALL	SETDEN
 	CALL	WRITE
 	JP	NZ,BADWRT
 	CALL	NEXSEC
 	LD	A,B		;GET BUFFER POINTER
 	CP	0
 TMEM3	EQU	$-1
 	RET	Z
 	LD	A,D		;GET TRACK
 	CP	(IY)		;END OF DISK ?
 	RET	NC
 	JP	WRITELP		;ELSE CONTINUE
 BADWRT	LD	A,(DRIVE)
 	ADD	A,30H
 	LD	(BADDR),A
 	RST	8
 	DB	10,'Drive '
 BADDR	DB	'0 Faulty Copy !',13
 	JP	STOP2
 COPYBYE	RST	8		;DISPLAY DONE MESSG
 	DB	10,'Copy Completed, <ENTER> to restart. ',3
 	LD	B,1
 	RST	10H
 	JP	ENTRY
 ASCII	PUSH	HL		;SAVE IT
 	CALL	ASCI		;CONVERT LOW PART
 	LD	H,B
 	PUSH	HL
 	LD	A,C
 	SUB	30H
 	CALL	ASCI		;CONVERT HIGH PART
 	LD	A,C
 	POP	HL
 	LD	C,B
 	LD	B,H
 	POP	HL
 	RET
 ASCI	LD	C,30H
 ASCII1	SUB	0AH
 	JR	C,ASCII2
 	INC	C
 	JR	ASCII1
 ASCII2	ADD	A,3AH
 	LD	B,A
 	RET
 PTITLE	LD	HL,MSG0
 	LD	DE,3C00H
 	LD	B,64
 	JP	PUTITON
 VALUE	LD	A,B		;LENGTH
 	CP	3		;MAKE IT 3 BYTES
 	JR	Z,VALGO		;HAVE 3 CHAR
 	DEC	HL		;POINTER
 	LD	(HL),'0'	;MAKE IT ZERO
 	INC	B		;LENGTH + 1
 	JR	VALUE		;CONTINUE
 VALGO	LD	D,0		;0 START VALUE
 VALOOP	LD	A,(HL)		;GET A BYTE
 	CALL	MAKNUM
 	RET	C		;BAD NUMBER
 	CALL	BYTEN		;A * 10
 	CALL	BYTEN		;A * 100
 	ADD	A,D		;ADD TO TOTAL
 	LD	D,A
 	INC	HL
 	LD	A,(HL)
 	CALL	MAKNUM
 	RET	C
 	CALL	BYTEN		;A * 10
 	ADD	A,D		;RESULT
 	LD	D,A
 	INC	HL
 	LD	A,(HL)
 	CALL	MAKNUM
 	ADD	A,D
 	LD	C,A
 	LD	B,0		;BC=RESULT
 	SCF
 	CCF			;CLEAR CARRY
 	RET
 BYTEN	LD	B,10		;MULTIPLIER
 	PUSH	DE		;SAVE DE
 	LD	E,A
 	LD	D,0		;DE=MULTIPLICAND
 	PUSH	HL		;SAVE POINTER
 	LD	HL,0		;START VALUE
 BYLOOP	SRL	B		;MULTIPLIER BIT
 	JR	NC,BYCONT	;GO IF EVEN NUMBER
 	ADD	HL,DE		;ADD TO TOTAL
 BYCONT	JR	Z,BYDONE
 	EX	DE,HL
 	ADD	HL,HL
 	EX	DE,HL
 	JR	BYLOOP		;CONTINUE
 BYDONE	LD	A,L		;GET PRODUCT
 	POP	HL
 	POP	DE		;RESTORE PREVIOUS
 	RET			;A=NUMBER
 MAKNUM	SUB	30H		;REMOVE ASCII
 	RET	C		;BAD NUMBER
 	CP	0AH		;>9 ?
 	CCF			;REVERSE CARRY FLAG
 	RET			;FINISHED
 HEXCV	LD	C,A
 	SRL	A
 	SRL	A
 	SRL	A
 	SRL	A
 	CALL	HEXTST
 	LD	L,A
 	LD	A,C
 	AND	0FH
 	CALL	HEXTST
 	LD	H,A
 	RET
 HEXTST	ADD	A,30H
 	CP	3AH
 	RET	M
 	ADD	A,7
 	RET
 PUTITON	EX	DE,HL		;HL=VIDEO, DE=TEXT
 PUTITLP	LD	A,(DE)		;GET A TEXT BYTE
 	LD	(HL),A		;PRINT IT
 	INC	HL		;BUMP POINTERS
 	INC	DE
 	DJNZ	PUTITLP		;CONTINUE
 	RET			;DONE
 ADDC	INC	C
 	LD	A,7
 	ADD	A,B
 	LD	B,A
 	RET
 TESTMEM	LD	HL,TESTBUFF
 TESTLP1	LD	A,-1
 	LD	(HL),A
 	CP	(HL)
 	RET	NZ
 	XOR	A
 	LD	(HL),A
 	CP	(HL)
 	RET	NZ
 	INC	HL
 	JR	TESTLP1
 PUTSER	PUSH	DE
 	LD	HL,SERSAVE
 	LD	DE,BUFFER+0D5H
 	LD	BC,0700H
 PUTSERL	LD	A,(HL)
 	XOR	44H
 	LD	(DE),A
 	NEG
 	ADD	A,C
 	LD	C,A
 	INC	HL
 	INC	DE
 	DJNZ	PUTSERL
 	LD	(BUFFER+0D4H),A
 	LD	BC,BUFFER
 	POP	DE
 	RET
