BOOTL  ;bootL/asm
 	ORG	4200H
 	NOP
 	CP	20
 	CALL	1C9H
 	LD	HL,37ECH	;point to FDC
 	LD	(HL),-1		;set double density
 	LD	(HL),0D0H	;force interrupt
 	INC	L		;37EDH, track register
 	LD	(HL),0		;set track 0
 	LD	DE,0100H
 	LD	L,-1
 	EXX
 LOOP	CALL	GET1B
 	DEC	A
 	JR	Z,LOAD
 	DEC	A
 	JR	Z,START
 	CP	1EH
 	JP	NC,SERR
 	CALL	GET1B
 	LD	B,A
 LOOP2	CALL	GET1B
 	DJNZ	LOOP2
 	JR	LOOP
 START	CALL	GET1B
 	CALL	GETLOAD
 	JP	(HL)
 GETLOAD	CALL	GET1B
 	LD	L,A
 	CALL	GET1B
 	LD	H,A
 	RET
 LOAD	CALL	GET1B
 	LD	B,A
 	CALL	GETLOAD
 	DEC	B
 	DEC	B
 LOAD2	CALL	GET1B
 	LD	(HL),A
 	CP	(HL)
 	JP	NZ,MERR
 	INC	HL
 	DJNZ	LOAD2
 	JR	LOOP		;go again
 SELECT	LD	A,1
 	LD	(37E1H),A
 	RET
 GET1B	EXX
 	INC	L
 	JR	NZ,HAVE1B
 	LD	BC,6F00H
 	CALL	READ
 	JR	NZ,DERR
 	INC	E
 	LD	A,E
 	SUB	18
 	JR	NZ,HAVE1B
 	LD	E,A
 	INC	D
 HAVE1B	LD	A,(HL)
 	EXX
 	RET
 READ	PUSH	BC
 	CALL	READ1
 	POP	HL
 	RET	Z
 	LD	B,H
 	LD	C,L
 READ1	LD	HL,37ECH
 	CALL	SEEK
 	LD	(HL),88H
 	CALL	DSKSLO
 	PUSH	DE
 	LD	DE,37EFH
 RX0	LD	A,(HL)
 	AND	87H
 	JP	PO,RX0
 RX1	LD	A,(DE)		;get byte
 	LD	(BC),A		;put in buffer
 	INC	BC		;point to next one
 RX2	BIT	1,(HL)
 	JR	NZ,RX1
 	BIT	1,(HL)
 	JR	NZ,RX1
 	BIT	7,(HL)
 	JR	NZ,RD3		;error
 	BIT	1,(HL)
 	JR	NZ,RX1
 	BIT	0,(HL)
 	JR	NZ,RX2
 RD3	LD	A,(HL)
 	POP	DE
 	LD	(HL),0D0H
 	OR	A
 	RET
 DSKSLO	PUSH	BC
 	LD	B,12
 	DJNZ	$
 	POP	BC
 	NOP
 	RET
 SEEK	CALL	SELECT
 	LD	(37EEH),DE
 	LD	(HL),1BH
 	CALL	DSKSLO
 SEEKWT	BIT	0,(HL)
 	JR	NZ,SEEKWT
 	LD	IY,0
 	RET
 MERR	LD	HL,MERROR
 	JR	ERR
 DERR	LD	HL,DERROR
 	JR	ERR
 SERR	LD	HL,SERROR
 ERR	CALL	PRINT
 ERROR	LD	HL,MSG1
 	CALL	PRINT
 	CALL	40H
 	HALT
 PRINT	LD	A,(HL)
 	INC	HL
 	XOR	0
 XRR	EQU	$-1
 	RET	Z
 	CALL	33H
 	JR	PRINT
 DERROR	DB	'DSK',0
 MERROR	DB	'MEM',0
 SERROR	DB	'DATA',0
 MSG1	DB	' ERR'
 	DB	0
 	END	4200H
