SPOOLE ; #######################################################
 ; THIS INTERRUPT SERVICE ROUTINES STORES UP TO 255 CHAR-
 ; ACTERS IN A BUFFER, WHERE THEY MAY THEN BE OUTPUT TO
 ; A PRINTER.  THIS SPOOLER CHECKS FOR CHARACTERS AT THE
 ; PRINTER DRIVER ROUTINE, INTERCEPTS THEM, STASHES THEM,
 ; AND RETURNS TO THE MAIN PROGRAM WITHOUT DELAY.
 ; #######################################################
 ;
 	ORG	7E00H
 ;
 ; #######################################################
 ; SETUP ROUTINE CREATES A BUFFER AND PLACES ITS ADDRESS,
 ; ALONG WITH A JUMP TO REPLACE THE NORMAL RET, AT 4012H
 ; #######################################################
 ;
 SETUP	DI			; INT. OFF DURING SETUP
 	LD	A,0C3H		; GET JUMP VALUE INTO A
 	LD	(4012H),A	; PLACE INTO INT. VECTOR
 	XOR	A		; CLEAR ACCUMULATOR
 	LD	B,A		; PUT 100 HEX INTO B
 	LD	HL,BUFFER-1	; HL JUST AHEAD OF BUFFER
 CLEAR	INC	HL		; NEXT POSITION IN BUFFER
 	LD	(HL),A		; PLACE ZERO INTO BUFFER
 	DJNZ	CLEAR		; DO IT FULL 256 TIMES
 	LD	HL,SERVE	; GET SERVICE ROUT. ADDR.
 	LD	(4013H),HL	; PLACE INTO INT. VECTOR
 	LD	HL,SPOOL	; GET SPOOL ROUTINE
 	LD	(4026H),HL	; PLACE IN PRINTER DRIVER
 	LD	HL,1A19H	; RETURN TO BASIC INTO HL
 	PUSH	HL		; PLACE ON STACK
 	IM	1		; SET INTERRUPT MODE
 	EI			; INTERRUPTS READY TO GO
 	RET			; BACK TO BASIC READY
 ;
 ; #######################################################
 ; SPOOL ROUTINE STARTS HERE AND INTERCEPTS PRINTER DRIVER
 ; #######################################################
 ;
 SPOOL	DI			; INT. OFF DURING SPOOL
 	PUSH	HL		; SAVE HL REGISTER
 	LD	A,C		; GET CHARACTER INTO A
 	PUSH	AF		; SAVE CHAR. TO PRINT
 	LD	HL,BUFFER+1	; POINT TO BUFFER START
 	EI			; INTERRUPTS BACK ON NOW
 LOOP2	LD	A,(HL)		; GET BUFFER VALUE
 	AND	A		; IS IT A CHAR. OR ZERO?
 	JR	NZ,LOOP2	; WAIT IN LOOP IF FULL
 	DI			; INTERRUPTS BACK OFF
 	LD	B,0FDH		; GET PRESENT BUFFER SIZE
 LOOP3	INC	HL		; GET NEXT BUFFER POS'N
 	LD	A,(HL)		; BRING VALUE INTO A
 	AND	A		; TEST FOR CHAR. OR ZERO
 	JR	NZ,SAVEIT	; FOUND FREE SPACE - GO
 	DJNZ	LOOP3		; SEARCH THROUGH BUFFER
 SAVEIT	DEC	HL		; BACK OFF ONE POSITION
 	POP	AF		; RESTORE CHAR. TO PRINT
 	LD	(HL),A		; PUT IT IN BUFFER
 	POP	HL		; RESTORE FORMER VALUE
 	EI			; INTERRUPTS BACK ON
 	RET			; BACK TO MAIN ROUTINE
 ;
 ; #######################################################
 ; INTERRUPT SERVICE ROUTINE FIRST SAVES REGISTERS, THEN
 ; RESETS INTERRUPT FLIP-FLOPS IN E/I.  PRINTER STATUS
 ; IS EXAMINED, AND THE ROUTINE EXITED IF PRINTER BUSY.
 ; #######################################################
 ;
 SERVE	DI			; INT. OFF DURING DESPOOL
 	PUSH	AF		; SAVE VALUE IN ACCUM.
 	PUSH	HL		; SAVE VALUE IN HL
 	PUSH	DE		; SAVE VALUE IN DE
 	PUSH	BC		; SAVE VALUE IN BC
 	PUSH	IX		; SAVE VALUE IN IX
 	LD	IX,4025H	; PRINTER CONTROL BLOCK
 	LD	A,(37ECH)	; RESET INT. FLIP-FLOP
 	LD	A,(37E0H)	; RESET INT. FLIP-FLOP
 	LD	A,(37E8H)	; GET PRINTER STATUS TO A
 	AND	0F0H		; MASK OUT LOW BITS
 	CP	30H		; SEE IF PRINTER IS BUSY
 	JR	NZ,OUT		; GO OUT IF PRINTER BUSY
 ;
 ; #######################################################
 ; WHEN PRINTER IS READY, BUFFER IS MOVED UP, THE CHAR-
 ; ACTER IS TESTED, AND PRINTED IF A VALID CHARACTER.
 ; IF IT IS CARRIAGE RETURN, FORM FEED, LINE FEED, ETC.,
 ; APPROPRIATE TESTS ARE MADE IN THE PRINTER CONTROL BLOCK
 ; #######################################################
 ;
 	LD	HL,BUFFER+0FEH	; GET NEXT TO LAST CHAR.
 	LD	DE,BUFFER+0FFH	; GET NEXT CHAR. IN QUEUE
 	LD	BC,0FFH		; GET TOTAL BUFFER SIZE
 	LDDR			; MOVE IT UP ONE POS'N
 	LD	A,(BUFFER+0FFH)	; GET QUEUE CHAR TO PRINT
 	AND	A		; TEST TO SEE IF ZERO
 	JR	Z,OUT		; GO OUT IF NONE LEFT
 	CP	0BH		; CHECK IF TOP OF FORM
 	JR	Z,TEST1		; TEST IF CHAR. IS ONE
 	CP	0CH		; TEST IF CHAR = F.F.
 	JR	NZ,TEST2	; NEXT TEST IF NOT
 	XOR	A		; CLEAR ACCUMULATOR
 	OR	(IX+3)		; GET LINES PRINTED
 	JR	Z,TEST2		; OUT IF VALUE = 0
 TEST1	LD	A,(IX+3)	; GET LINES PRINTED
 	SUB	(IX+4)		; GET LINES PER PAGE
 	LD	B,A		; PUT LINES LEFT IN B
 LOOPA	LD	A,(37E8H)	; GET PRINTER STATUS
 	AND	0F0H		; MASK OUT LOW BITS
 	CP	30H		; CHECK STATUS BITS
 	JR	NZ,LOOPA	; LOOP IF PRINTER BUSY
 	LD	A,0AH		; GET LINE FEED CHAR.
 	LD	(37E8H),A	; SEND IT TO PRINTER
 	DJNZ	LOOPA		; DO IT TILL FORM IS FED
 	JR	EXIT		; GO OUT WHEN DONE
 TEST2	LD	B,A		; STASH CHAR. IN B REG.
 LOOPB	LD	A,(37E8H)	; GET PRINTER STATUS
 	AND	0F0H		; MASK OUT LOW BITS
 	CP	30H		; CHECK STATUS BITS
 	JR	NZ,LOOPB	; LOOP TILL PRINTER READY
 	LD	A,B		; GET CHAR. BACK INTO A
 	LD	(37E8H),A	; SEND IT TO PRINTER
 	CP	0DH		; CHECK IF CARRIAGE RET.
 	JR	NZ,OUT		; IF NOT THEN GO OUT
 	INC	(IX+4)		; ELSE INC. LINES COUNTER
 	LD	A,(IX+4)	; GET NEW LINES COUNTER
 	CP	(IX+3)		; CHECK WITH LINES/PAGE
 	LD	A,C		; GET CHARACTER BACK TO A
 	JR	NZ,OUT		; GO IF NOT PAGE END
 EXIT	LD	(IX+4),0	; RESET PAGE LINES TO 0
 ;
 ; #######################################################
 ; REGISTERS ARE RESTORED AND THE ROUTINE IS EXISTED.  THE
 ; LAST 255 BYTES OF SPACE ARE RESERVED FOR PRINTER BUFFER
 ; #######################################################
 ;
 OUT	POP	IX		; RESTORE IX REGISTER
 	POP	BC		; RESTORE BC REGISTER
 	POP	DE		; RESTORE DE REGISTER
 	POP	HL		; RESTORE HL REGISTER
 	POP	AF		; RESTORE AF REGISTER
 	EI			; INTERRUPTS BACK ON
 	RET			; BACK TO MAIN ROUTINE
 BUFFER	DEFS	255		; DEFINE 255-CHAR. BUFFER
 	DEFB	00		; END BUFFER WITH 0 BYTE
 ;
 ; #######################################################
 	END	SETUP
