;Split64k.asm:	Split a file into 64k chunks.
;
*GET	DOSCALLS
*GET	ASCII
;
	ORG	5200H
	DEFS	256
START
	LD	SP,START
;
	LD	DE,FCB_IN
	CALL	DOS_EXTRACT
;
	LD	DE,FCB_IN
	LD	HL,BUF_IN
	LD	B,0
	CALL	DOS_OPEN_EX
	JP	NZ,DOS_ERROR
;
LOOP
	CALL	COPYFILE
	LD	A,(SAW_EOF)
	OR	A
	JR	NZ,EXIT
;
	LD	A,(FILENR)
	INC	A
	LD	(FILENR),A
	JR	LOOP
;
EXIT
	JP	DOS
;
COPYFILE
	CALL	OPEN_OUT
	CALL	COPY64K
	CALL	CLOSE_OUT
	RET
;
OPEN_OUT
	LD	HL,OUTFILE
	LD	DE,FCB_OUT
	CALL	DOS_EXTRACT
;
	LD	HL,BUF_OUT
	LD	DE,FCB_OUT
	LD	B,0
	CALL	DOS_OPEN_NEW
	JP	NZ,DOS_ERROR
	RET
;
CLOSE_OUT
	LD	DE,FCB_OUT
	CALL	DOS_CLOSE
	JP	NZ,DOS_ERROR
	RET
;
COPY64K
	CALL	BBFILL
	LD	A,(SAW_EOF)
	OR	A
	CALL	Z,BBFILL
	RET
;
BBFILL
	LD	HL,0
	LD	(BBLEN),HL
	LD	DE,BBUFF
	LD	B,128
BB_01
	PUSH	BC
	PUSH	DE
;
	LD	DE,FCB_IN
	CALL	DOS_READ_SECT
	JP	NZ,BB_ERROR
;
	POP	DE
	LD	HL,BUF_IN
	LD	BC,256
	LDIR
;
	LD	HL,(BBLEN)
	INC	H
	LD	(BBLEN),HL
;
	POP	BC
	DJNZ	BB_01
;
BB_02
	LD	A,(BBLEN+1)
	LD	B,A
	LD	HL,BBUFF
BB_03
	PUSH	BC
;
	LD	DE,BUF_OUT
	LD	BC,256
	LDIR
	PUSH	HL
;
	LD	DE,FCB_OUT
	CALL	DOS_WRIT_SECT
	JP	NZ,DOS_ERROR
;
	POP	HL
	POP	BC
	DJNZ	BB_03
;
	LD	A,(BBLEN)
	OR	A
	RET	Z
;
	LD	B,A
BB_04
	PUSH	BC
	LD	A,(HL)
	PUSH	HL
	LD	DE,FCB_OUT
	CALL	$PUT
	JP	NZ,DOS_ERROR
;
	POP	HL
	INC	HL
	POP	BC
	DJNZ	BB_04
;
	RET
;
BB_ERROR
	POP	DE
	POP	BC
	CP	1CH
	JP	Z,EOF_1C
	CP	1DH
	JR	Z,EOF_1D
	JP	DOS_ERROR
;
EOF_1C
	LD	A,1
	LD	(SAW_EOF),A
	JP	BB_02
;
EOF_1D
	LD	A,1
	LD	(SAW_EOF),A
;
	LD	HL,BUF_IN
	LD	BC,256
	LDIR
;
	LD	A,(FCB_IN+5)
	LD	(BBLEN),A
	JP	BB_02
;
;
RET_NZ
	OR	A
	RET	NZ
	CP	1
	RET
;
;-------
;
OUTFILE	DEFM	'FILE'
FILENR	DEFB	'0'
	DEFM	CR,0
;
BBLEN	DEFW	0
SAW_EOF	DEFB	0
;
FCB_IN	DEFS	32
FCB_OUT	DEFS	32
;
BUF_IN	DEFS	256
BUF_OUT	DEFS	256
;
BBUFF	DEFS	32768
;
	END	START
                                                                            