TESTV  ; SPLIT-SCREEN DEMONSTRATION PROGRAM BY W4UCH/2
 ;
 	ORG	7D00H		;ORG = 32000 DECIMAL
 W4UCH	EQU	7D00H		;T/R SIGNPOST HERE
 	DEFW	0000H		;T/R SIGNPOST HERE
 	CALL	01C9H		;CLS ROM SUBROUTINE
 RCURS	EQU	7D05H		;RECEIVE CURSOR
 	DEFW	15936		;IN MEM LOCATION 7D05H
 VIDEND	EQU	7D07H		;END OF 8/16TH VIDEO LINE
 	DEFW	15871		;STASH HERE IN 7D07H
 TCURS	EQU	7D09H		;TRANSMIT CURSOR
 	DEFW	15424		;STASH HERE IN 7DO9H
 PLACE	EQU	7D0BH		;HI-MEM STORAGE LOCATION
 	DEFW	32768		;INITIALIZE STORAGE HERE
 COUNT	EQU	7D0DH		;NO. OF STORES 1 TO 5
 	DEFB	00		;INITIALIZE COUNT = 0
 	LD	HL,32768	;STORE MEM BEGINNING
 	LD	DE,32769	;PLUS ONE
 	LD	BC,2555		;BYTES TO CLEAR
 	LD	(HL),32		;CLEAR WITH ASCII SPACE
 	LDIR			;CLEAR MEM FOR STORAGE
 	LD	HL,XMIT		;XMIT STRING MEM ADDRESS
 	CALL	28A7H		;DISPLAY $ SUBROUTINE
 XMIT	DEFM	'TRANSMIT -------------------------------------------------------'
 	DEFB	00		;END OF MESSAGE DELIMITER
 	LD	HL,15872	;= BEGINNING OF 9TH LINE-
 	LD	(4020H),HL	;MOVE CURSOR TO 9TH LINE.
 	LD	HL,RECV		;STRING MEM ADDRESS
 	CALL	28A7H		;DISPLAY $ SUBROUTINE
 RECV	DEFM	'RECEIVE --------------------------------------------------------'
 	DEFB	00		;END OF MESSAGE DELIMITER
 	LD	HL,15424	;MOVE CURSOR TO 2ND LINE
 	LD	(4020H),HL	;DO IT
 KYBD	LD	A,95		;CURSOR CHARACTER
 	LD	HL,(4020H)	;CURSOR POSITION TO HL
 	LD	(HL),A		;DISPLAY CURSOR
 	CALL	0049H		;INKEY$ TO A REGISTER
 	CP	31		;T/R 'CLEAR' KEY PRESSED?
 	JR	Z,TRSW		;IF 0 GOTO T/R SUBROUTINE
 	CP	10		;IS DOWN-ARROW PRESSED?
 	JP	Z,RCLS 		;IF SO GOTO RECEIVE CLS
 	CP	91		;IS UP-ARROW PRESSED?
 	JP	Z,TCLS		;IF SO GOTO TRANSMIT CLS
 	CP	13		;IS IT 'ENTER' PRESSED?
 	JP	Z,STORE		;IF 0 STORE RECEIVE FRAME
 	CP	9		;IS RIGHT-ARROW PRESSED?
 	JP	Z,RESTOR	;IF SO RESTORE FM MEM
 	CALL	032AH		;DISPLAY A REG ON VIDEO
 	LD	HL,(4020H)	;CURSOR POS TO HL REG
 	LD	DE,(VIDEND)	;END OF 8/16TH VIDEO LINE
 	CALL	1C90H		;COMPARE HL-DE SET Z FLAG
 	JR	Z,SCROLL	;IF ZERO GOTO SCROLL
 	JR	KYBD		;BACK TO KEYBOARD
 SCROLL	LD	A,(W4UCH)	;T/R SIGNPOST 0=T & 1=R
 	CP	00		;SUBTRACT ZERO
 	JR	Z,TSCROL	;IF 0 GOTO XMIT SCROLL
 	LD	HL,16000	;RECV SCRL BEGIN LINE 11
 	LD	DE,15936	;MOVE TO LINE 10 VIDEO
 	LD	BC,384		;NUMBER BYTES TO MOVE
 	LDIR			;MOVE IT. DEC BC TO ZERO
 	LD	HL,16320	;BEGINNING LINE 16 VIDEO
 	LD	DE,16321	;PLUS ONE
 	LD	BC,63		;NUMBER OF BYTES TO MOVE
 	LD	(HL),32		;32 = ASCII SPACE
 	LDIR			;MOVE IT. DEC BC TO ZERO
 	LD	HL,16320	;BEGIN 16TH VIDEO LINE
 	LD	(4020H),HL	;RESET CURSOR
 	JR	KYBD		;BACK TO KEYBOARD
 TSCROL	LD	HL,15488	;BEGINNING 3RD LINE VIDEO
 	LD	DE,15424	;TO 2ND LINE OF VIDEO
 	LD	BC,384		;NUMBER OF BYTES TO MOVE
 	LDIR			;MOVE IT. DEC BC TO ZERO
 	LD	HL,15808	;BEGINNING 8TH VIDEO LINE
 	LD	DE,15809	;PLUS ONE
 	LD	BC,63		;NUMBER OF BYTES TO MOVE
 	LD	(HL),32		;32 = ASCII SPACE
 	LDIR			;DO IT. DEC BC TO ZERO
 	LD	HL,15808	;BEGIN 8TH RIDEO LINE
 	LD	(4020H),HL	;RESET CURSOR
 	JR	KYBD		;BACK TO KEYBOARD
 TRSW	LD	A,(W4UCH)	;SIGNPOST MEM ADDRESS
 	CP	0		;SUBTRACT ZERO
 	JR	Z,CHANGE	;IF 0 GOTO CHANGE
 	LD	A,0		;T/R SET TO TRANSMIT
 	LD	(W4UCH),A	;STASH IT IN MEM
 	LD	A,32		;= ASCII SPACE
 	LD	HL,(4020H)	;CURSOR POSITION
 	LD	(HL),A		;REMOVE CURSOR
 	LD	(RCURS),HL	;SAVE RECV CURS POSITION
 	LD	HL,(TCURS)	;XMIT CURSOR POSITION
 	LD	(4020H),HL	;LOAD INTO VIDEO DCB
 	LD	HL,15871	;END OF 8TH VIDEO LINE
 	LD	(VIDEND),HL	;UPDATE FOR TRANSMIT
 	JP	KYBD		;RETURN TO KEYBOARD
 CHANGE	LD	A,1		;T/R SET TO RECEIVE
 	LD	(W4UCH),A	;STASH IT IN MEM
 	LD	A,32		;= ASCII SPACE
 	LD	HL,(4020H)	;CURSOR POSITION
 	LD	(HL),A		;REMOVE CURSOR
 	LD	(TCURS),HL	;SAVE XMIT CURS POSITION
 	LD	HL,(RCURS)	;RECV CURSOR POSITION
 	LD	(4020H),HL	;LOAD INTO VIDEO DCB
 	LD	HL,16383	;END OF 16TH VIDEO LINE
 	LD	(VIDEND),HL	;UPDATE FOR RECEIVE
 	JP	KYBD		;RETURN TO KEYBOARD
 RCLS	LD	A,(W4UCH)	;T/R SIGNPOST 0=T & 1=R
 	CP	1		;SUBTRACT 1
 	JP	NZ,KYBD		;GOTO KYBD IF NOT RECEIVE
 	LD	HL,15936	;BEGINNING 9TH VIDEO LINE
 	LD	DE,15937	;PLUS ONE
 	LD	BC,446		;NUMBER BYTES TO MOVE
 	LD	(HL),32		;= ASCII SPACE
 	LDIR			;CLS RECEIVE VIDEO SECTOR
 	LD	HL,15936	;MOVE CURSOR TO 9TH LINE
 	LD	(4020H),HL	;DO IT
 	JP	KYBD		;GO BACK TO KEYBOARD
 TCLS	LD	A,(W4UCH)	;T/R SIGNPOST 0=T & 1=R
 	CP	0		;SUBTRACT ZERO
 	JP	NZ,KYBD		;GOTO KYBD IF RECEIVE
 	LD	HL,15424	;BEGINNING 2ND LINE VIDEO
 	LD	DE,15425	;PLUS ONE
 	LD	BC,446		;NUMBER BYTES TO MOVE
 	LD	(HL),32		;= ASCII SPACE
 	LDIR			;CLS TRANSMIT VIDEO SECT.
 	LD	HL,15424	;MOVE CURSOR TO 2ND LINE
 	LD	(4020H),HL	;DO IT
 	JP	KYBD		;GO BACK TO KYBD
 STORE	LD	A,(W4UCH)	;T/R SIGNPOST
 	CP	1		;IS IT RECEIVE?
 	JP	NZ,KYBD		;IF NOT RECV GOTO KYBD
 	LD	A,(COUNT)	;NUMBER OF STORES IN MEM
 	INC	A		;ADD 1 TO "A" REGISTER
 	CP	6		;SUBTRACT 6
 	JP	Z,OUT		;GOTO OUT IF ZERO & RESET
 	LD	(COUNT),A	;UPDATE STORE COUNTER
 	ADD	A,48		;CONVERT TO ASCII NUMBER
 	LD	(15423),A	;DISPLAY - 1ST LINE VIDEO
 	LD	HL,15872	;BEGINNING RECEIVE VIDEO
 	LD	DE,(PLACE)	;MEM 'STORE' LOCATION
 	LD	BC,511		;NUMBER OF BYTES TO MOVE
 	LDIR			;MOVE IT
 	LD	HL,(PLACE)	;LAST HI-MEM STORE PLACE
 	LD	DE,511		;FOR 511 BYTES
 	ADD	HL,DE		;ADD THEM UP
 	LD	(PLACE),HL	;PUT THEM IN PLACE MEM
 	JP	RCLS		;GOTO CLS RECEIVE SECT.
 RESTOR	LD	A,(W4UCH)	;T/R SIGNPOST
 	CP	0		;SUBTRACT ZERO
 	JP	NZ,KYBD		;GOTO KYBD IF RECEIVE
 	LD	A,63		;= ASCII ?
 	LD	(15424),A	;DISPLAY IN 1ST XMIT LINE
 	CALL	0049H		;KYBD INPUT A REGISTER
 	CP	49		;IS IT ASCII ONE?
 	JR	Z,ONE		;GOTO ONE FRAME LOCATION
 	CP	50		;IS IT ASCII TWO?
 	JR	Z,TWO		;GOTO TWO FRAME LOCATION
 	CP	51		;IS IT ASCII THREE?
 	JR	Z,THREE		;GOTO THREE FRAME LOCAT.
 	CP	52		;IS IT ASCII FOUR?
 	JR	Z,FOUR		;GOTO FOUR FRAME LOCATION
 	CP	53		;IS IT ASCII FIVE?
 	JR	Z,FIVE		;GOTO FIVE FRAME LOCATION
 	JP	KYBD		;IF NONE GOTO KEYBOARD
 TELL	LD	HL,(SHOW)	;STORE MEM LOCATION
 	LD	DE,15872	;RECV VIDEO ADDRESS
 	LD	BC,511		;NO. BYTES TO MOVE
 	LDIR			;MOVE THEM
 	JP	KYBD		;RETURN TO KEYBOARD
 SHOW	DEFS	2		;SAVE 2 BYTES
 ONE	LD	HL,32768	;FIRST MEM STORE
 	LD	(SHOW),HL	;PUT IT IN SHOW MEMORY
 	JR	TELL		;GOTO TELL
 TWO	LD	HL,33279	;SECOND MEM STORE
 	LD	(SHOW),HL	;PUT IT IN SHOW MEMORY
 	JR 	TELL		;GOTO TELL
 THREE	LD	HL,33790	;THIRD MEM STORE
 	LD	(SHOW),HL	;PUT IT IN SHOW MEMORY
 	JR	TELL		;GOTO TELL
 FOUR	LD	HL,34301	;FOURTH MEM STORE
 	LD	(SHOW),HL	;PUT IT IN SHOW MEMORY
 	JR	TELL		;GOTO TELL
 FIVE	LD	HL,34812	;FIFTH MEM STORE
 	LD	(SHOW),HL	;PUT IT IN SHOW MEMORY
 	JR	TELL		;GOTO TELL
 OUT	LD	A,0		;ZERO TO "A" REGISTER
 	LD	(COUNT),A	;RESET STORE COUNTER 0
 	LD	HL,32768	;BEGINNING STORE MEMORY
 	LD	(PLACE),HL	;RESET STORE MEMORY
 	JP	KYBD		;RETURN TO KEYBOARD
 	END	W4UCH		;AMATEUR CALL LETTERS
 ;
 ; PROGRAM UTILIZES 584 BYTES PLUS 2555 BYTES STORAGE
