;SPLIT --- by Mark Pruden
;     reprinted from 'Christchurch 80' newsletter
;     minor modifications by Rod Stevenson
;
;a program to break memory into two areas
;     switch memory by <left-shift><down-arrow>
;
;
DOS	EQU	402DH	;exit to DOS
HIMEM	EQU	4411H	;top of memory (Model 1 = 4049H)
VECTOR	EQU	4016H	;keyboard input pointer
DSPLY	EQU	4467H	;display on screen
CLS	EQU	01C9H	;clear screen
TOP	EQU	9900H	;approx half memory 
BOT	EQU	3C00H	;memory to save
COUNT	EQU	TOP-BOT-1
SHROW	EQU	3880H	;shift row
SHKEY	EQU	1	;shift key
DNROW	EQU	3840H	;down arrow row
DNKEY	EQU	10H	;down arrow key
;
	ORG	TOP+COUNT+1	;top of full memory
START	LD	HL,TOP-1	;point to top of lower
	LD	(HIMEM),HL	;   half of split memory
	LD	HL,(VECTOR)	;save original keyboard
	LD	(TMPKBD),HL	;   scan address
	LD	HL,SCAN		;insert new keyboard scan
	LD	(VECTOR),HL	;   routine before normal
	LD	DE,TOP		;copy lower half memory
	LD	HL,BOT		;   into upper half also
	LD	BC,COUNT
	LDIR
	LD	(STACK),SP	;save stack pointer
	CALL	CLS		;message first time only
	LD	HL,MSG
	CALL	DSPLY
	JP	DOS
;
SCAN	LD	A,(SHROW)	;test for shift key
	CP	SHKEY
	JP	NZ,CONT		;if not, do normal scan
	LD	A,(DNROW)	;test for down-arrow
	CP	DNKEY
	JP	NZ,CONT		;if not, do normal scan
	DI
	LD	DE,TOP		;swap top & bottom halves
	LD	BC,COUNT	;   of memory
	LD	HL,BOT
XCHNG	LD	A,(DE)
	LDI
	DEC	HL
	LD	(HL),A
	INC	HL
	JP	PE,XCHNG
	LD	HL,(STACK)	;swap stack too
	LD	(STACK),SP
	LD	SP,HL
	XOR	A		;don't return a character
	EI
	RET
;
CONT	LD	HL,(TMPKBD)	;original keyboard scan
	JP	(HL)
;
MSG	DEFM	10,10,10,'SPLIT --- by Mark Pruden',10,10
	DEFM	'<left-shift><down-arrow> to swap',10,13
;
STACK	DEFS	2
TMPKBD	DS	2
;
	END	START
                                                                                                                               