;SMART/ASM
TRUE	EQU	-1
FALSE	EQU	0
MODEL1	EQU	TRUE
MODEL3	EQU	FALSE
MODEL4	EQU	FALSE
	IF	MODEL1
	TITLE	<SMART1>
	ENDIF
	IF	MODEL3
	TITLE	<SMART3>
	ENDIF
	IF	MODEL4
	TITLE	<SMART4>
	ENDIF
	COM	'<Copyright (C) 1987 by Duane M. Saylor>'
;
;	Background task for system clock update
;	For use with Dallas Semiconductor DS 1216E Smart Watch
;       and a TRS-80 Model III,4 or 4P under LDOS 5.1.4 or LDOS 5.3
;
;
;	Operating System equates
	IF	MODEL1
@ADTSK	EQU	4410H
@DSPLY	EQU	4467H
@ICNFG	EQU	4303H
@LOGOT	EQU	447BH
@PARAM	EQU	4476H
@RMTSK	EQU	4413H
;
DATE$	EQU	4044H
HIGH$	EQU	4049H
TIME$	EQU	4041H
TCB$	EQU	4500H
	ENDIF
	IF	MODEL3
@ADTSK	EQU	403DH
@DSPLY	EQU	4467H
@ICNFG	EQU	421DH
@LOGOT	EQU	428AH
@PARAM	EQU	4454H
@RMTSK	EQU	4040H
IMAG84	EQU	40ADH
;
DATE$	EQU	421AH
HIGH$	EQU	4411H
TIME$	EQU	4217H
TCB$	EQU	4500H
	ENDIF
	IF	MODEL4
@ADTSK	EQU	1DH
@CKTSK	EQU	1CH
@DATE	EQU	12H
@DSPLY	EQU	0AH
@FLAGS	EQU	65H
@GTMOD	EQU	53H
@HIGH$	EQU	64H
@LOGOT	EQU	0CH
@PARAM	EQU	11H
@RMTSK	EQU	1EH
@TIME	EQU	13H
	ENDIF
;
	ORG	5200H
;
START
	LD	DE,PRMTBL
	IF	MODEL1.OR.MODEL3
	CALL	@PARAM
	ENDIF
	IF	MODEL4
	LD	A,@PARAM
	RST	28H
	ENDIF
	LD	HL,HELLO$
	IF	MODEL1.OR.MODEL3
	CALL	@DSPLY
	ENDIF
	IF	MODEL4
	LD	A,@DSPLY
	RST	28H
	ENDIF
	LD	B,4
SEARCH	PUSH	BC
	CALL	GETCLK		;Attempt clock read
	POP	BC
	LD	A,(DAY)
	CP	0FFH		;Check for all 1's
	JR	Z,NEXT		;Go if all 1's
	CP	0		;Check for al 0's
	JR	NZ,FOUND	;We have found the SmartWatch
NEXT	LD	HL,(BASE)	;Get last base address
	LD	DE,1000H	;Offset to next address to try
	ADD	HL,DE		;Calculate new base address
	LD	(BASE),HL	;And save it
	DJNZ	SEARCH
	JP	NOSWP		;Go display No SmartWatch present
;
	PAGE	OFF
;If  we get this far, we have found a SmartWatch
;Now check for presence of SMART module in memory
;
FOUND
	LD	DE,NAM$		;Point to module name
	IF	MODEL1.OR.MODEL3
	CALL	GTMOD
	ENDIF
	IF	MODEL4
	LD	A,@GTMOD
	RST	28H
	ENDIF
	JP	NZ,NOTRES	;SMART module not present
	LD	(BEGIN),HL	;Save start address of SMART
;
;	Test for Yank parameter
;
	LD	BC,$-$		;Default to YANK=NO
YANK	EQU	$-2
	LD	A,B
	OR	C
	JR	Z,CKACT		;Go and check if task active
;
;	If we fall through Yank has been specified.
;
;
;	Test if SMART is first module in high memory
;
	IF	MODEL1.OR.MODEL3
	LD	HL,(HIGH$)
	ENDIF
	IF	MODEL4
	LD	HL,0
	LD	B,L
	LD	A,@HIGH$
	RST	28H
	ENDIF
	INC	HL		;Point to start of first module
	LD	DE,(BEGIN)	;Get start address of SMART
	CALL	CPHLDE		;Compare HL, DE
	JR	NZ,RMOVTSK	;OK to remove task only
;
;	If we fall through, we can remove module and task
;
	LD	HL,(BEGIN)	;Start address of SMART
	LD	BC,TSKSLOT-MODULE
	ADD	HL,BC		;Point to TSKSLOT
	IF	MODEL1.OR.MODEL3
	LD	A,(HL)		;Get slot number
	CALL	@RMTSK
	ENDIF
	IF	MODEL4
	LD	C,(HL)
	LD	A,@RMTSK
	RST	28H
	ENDIF
;
;	Now unlink @ICNFG vector
;
	IF	MODEL1.OR.MODEL3
	LD	IY,@ICNFG
	ENDIF
	IF	MODEL4
	LD	A,@FLAGS
	RST	28H
	LD	BC,28		;Offset to @ICNFG
	ADD	IY,BC
	ENDIF
	LD	HL,(BEGIN)	;Start address of SMART
	LD	BC,LINK-MODULE+1
	ADD	HL,BC
	LD	A,(HL)		;Get LSB of next @ICNFG vector
	INC	HL
	LD	H,(HL)		;Get MSB of next @ICNFG vector
	LD	(IY+1),A	;Reset @ICNFG to next vector
	LD	(IY+2),H
;
;	Now restore previous HIGH$
;
	LD	HL,(BEGIN)	;Start address of SMART
	INC	HL
	INC	HL		;Point to OLDHI
	LD	A,(HL)		;Get LSB of OLDHI
	INC	HL
	LD	H,(HL)		;Get MSB of OLDHI
	LD	L,A		;HL now is old HIGH$
	IF	MODEL1.OR.MODEL3
	LD	(HIGH$),HL
	ENDIF
	IF	MODEL4
	LD	B,0
	LD	A,@HIGH$
	RST	28H
	ENDIF
	JP	MODYNK
;
;	Check if task active
;
CKACT
	LD	HL,(BEGIN)	;Start address of SMART
	LD	BC,TSKSLOT-MODULE
	ADD	HL,BC
	IF	MODEL1.OR.MODEL3
	LD	A,(HL)		;Get task slot number
	LD	C,A		;Save slot in C
	CALL	CKTSK
	ENDIF
	IF	MODEL4
	LD	C,(HL)
	LD	A,@CKTSK
	RST	28H
	ENDIF
	JR	NZ,UPD		;If active go to update
	PAGE	OFF
;
;	If we fall through we have to restore the task
;
	LD	HL,(BEGIN)	;Start address of SMART
	LD	DE,MODTCB-MODULE
	ADD	HL,DE		;Point to TCB
	EX	DE,HL		;DE = TCB
	IF	MODEL1.OR.MODEL3
	LD	A,C
	CALL	@ADTSK
	ENDIF
	IF	MODEL4
	LD	A,@ADTSK
	RST	28H
	ENDIF
;
;	Module is resident, change the time interval
;
UPD	LD	A,(TIME)	;Get Time interval
	SLA	A		; X 2
	SLA	A		; X 4
	OR	A		;Zero?
	JR	NZ,UPD1		;Go if not zero
	DEC	A		;Else make it 255
UPD1	LD	HL,(BEGIN)	;Start of SMART module
	LD	DE,NUM-MODULE	;Offset to time interval
	ADD	HL,DE		;HL no is pointing to time interval
	LD	(HL),A		;Update time interval
	JP	HAVMOD
;
;	Module not removable so just disable task
;
RMOVTSK
	LD	HL,(BEGIN)	;Start address of SMART
	LD	BC,TSKSLOT-MODULE
	ADD	HL,BC		;Point to TSKSLOT
	IF	MODEL1.OR.MODEL3
	LD	A,(HL)		;Get slot number of task
	CALL	@RMTSK
	ENDIF
	IF	MODEL4
	LD	C,(HL)
	LD	A,@RMTSK
	RST	28H
	ENDIF
	JP	TSKRM
	PAGE	OFF
;
;If we get here, we have not found the SMART module in memory
;   so we can proceed with installation.
;
NOTRES
	LD	BC,60		;Default to 60 second update
TIME	EQU	$-2
	LD	A,C
	SLA	A		; X 2
	SLA	A		; X 4
	OR	A
	JR	NZ,OK
	DEC	A
OK	LD	(NUM),A
;
	LD	BC,0		;Default to slot 0
SLOT$	EQU	$-2
	LD	A,C
	AND	7		;Allow only slots 0-7
	LD	(SLOT),A	;Stuff in program code
	LD	(TSKSLOT),A	;Save for YANK option
;
	IF	MODEL1.OR.MODEL3
	CALL	CKTSK
	ENDIF
	IF	MODEL4
	LD	C,A
	LD	A,@CKTSK
	RST	28H
	ENDIF
	JP	NZ,INUSE
;
	IF	MODEL1.OR.MODEL3
	LD	HL,(HIGH$)
	ENDIF
	IF	MODEL4
	LD	HL,0
	LD	B,L
	LD	A,@HIGH$
	RST	28H
	ENDIF
	LD	(SVEND+1),HL	;Save for relocator
	XOR	A		;Calc new start
	LD	BC,MODEND$-MODULE	;BC = module length
	SBC	HL,BC		;Calculate new High$
	IF	MODEL1.OR.MODEL3
	LD	(HIGH$),HL	;New high$
	ENDIF
	IF	MODEL4
	LD	B,0
	LD	A,@HIGH$
	RST	28H
	ENDIF
	INC	HL		;Point to new start
	EX	DE,HL		;DE = new start
	PUSH	DE		;Save new start on stack
;
;relocate
;
	PUSH	IX
	LD	IX,RELTAB	;Point to relocation table
SVEND	LD	HL,$-$		;New end address
	LD	(MODULE+2),HL	;Save in module header
	LD	DE,MODEND$-1	;Last byte of module
	OR	A		;Clear carry
	SBC	HL,DE		;Calculate offset
	LD	B,H		;Place offset 
	LD	C,L		;  in BC
	LD	A,TABLEN	;Get length of relocation table
RLOOP	LD	L,(IX+00H)	;Get address to relocate
	LD	H,(IX+01H)
	LD	E,(HL)		;P/u address
	INC	HL
	LD	D,(HL)
	EX	DE,HL		;Offset it
	ADD	HL,BC
	EX	DE,HL
	LD	(HL),D		;Put it back
	DEC	HL
	LD	(HL),E
	INC	IX		;Point to next address
	INC	IX
	DEC	A		;One less to relocate
	JR	NZ,RLOOP	;Continue until done
	POP	IX
	POP	DE		;Get new start address for module
	LD	(MODTCB+2),DE	;Save relocated module in TCB
	LD	BC,ENTRY-MODULE
	LD	H,D
	LD	L,E
	ADD	HL,BC
	LD	(MODTCB),HL	;Stuff entry address in TCB
	LD	BC,MODTCB-MODULE	;Get offset to TCB
	LD	H,D		;HL = Relocated module entry
	LD	L,E
	ADD	HL,BC		;HL now is Relocated TCB
	PUSH	HL		;Save for later
	IF	MODEL1.OR.MODEL3
	LD	IY,@ICNFG
	ENDIF
	IF	MODEL4
	LD	A,@FLAGS
	RST	28H
	LD	BC,28
	ADD	IY,BC
	ENDIF
	LD	A,(IY)		;Get opcode at @ICNFG vector
	LD	(LINK),A	;Store at end of module INIT
	LD	L,(IY+1)	;Get address LOW of @ICNFG vector
	LD	H,(IY+2)	;Get address HIGH of @ICNFG vector
	LD	(LINK+1),HL	;Store at end of module INIT
	LD	BC,INIT-MODULE	;Offset to init
	LD	H,D		;Relocated
	LD	L,E		;  Entry address
	ADD	HL,BC		;Relocated INIT address
	LD	(IY+1),L	;Store in original @ICNFG vector
	LD	(IY+2),H
	LD	A,0C3H		;JP opcode
	LD	(IY),A
	LD	HL,MODULE	;Get present start address of module
	LD	BC,MODEND$-MODULE	;Length of module
	LDIR			;Move the module
	POP	DE		;Point to relocated TCB
	IF	MODEL1.OR.MODEL3
	LD	A,0		;Task slot 0
SLOT	EQU	$-1
	CALL	@ADTSK
	ENDIF
	IF	MODEL4
	LD	C,0
SLOT	EQU	$-1
	LD	A,@ADTSK
	RST	28H
	ENDIF
	LD	HL,INSTL$	;Installed message
	LD	IX,NOSWP$
NOSWP	EQU	$-3
	LD	IX,MODYNK$
MODYNK	EQU	$-3
	LD	IX,HAVMOD$
HAVMOD	EQU	$-3
	LD	IX,TSKRM$
TSKRM	EQU	$-3
	LD	IX,INUSE$
INUSE	EQU	$-3
	IF	MODEL1.OR.MODEL3
	CALL	@LOGOT
	ENDIF
	IF	MODEL4
	LD	A,@LOGOT
	RST	28H
	ENDIF
	LD	HL,0
	RET
	PAGE	OFF
	IF	MODEL1.OR.MODEL3
;	Routine to locate the address of a module
;	DE => pointer to module name
;	HL <= address of module start if found
;	DE <= address of end-of-module +1 if found
;	Z  <= if found, else NZ & A = 8
GTMOD
	PUSH	BC		;Save this reg pair
	LD	C,0FFH		;Init length counter
	PUSH	DE		;Save name start
GTMOD1	INC	C		;Bump counter
	LD	A,(DE)		;Search for end-of-name
	INC	DE
	CP	' '+1
	JR	NC,GTMOD1
	POP	DE
;
;	Start search at HIGH$ + 1
;
	LD	HL,(HIGH$)
	INC	HL
;
;	Loop through core searching names
;	Does this module have a legal header ?
;
GTMOD2	LD	A,(HL)		;Ck for "JR xx"
	CP	18H
	JR	NZ,GTMOD6		;Exit on non-JR
	PUSH	HL		;Save pointer to start
	INC	HL		;Advance to length/name
	INC	HL
	INC	HL
	INC	HL
	LD	A,(HL)		;P/u length field
	AND	0FH		;Strip flags
	CP	C		;Lengths match?
	JR	NZ,GTMOD5
	INC	HL		;Point to start of name
	LD	B,A		;Set loop counter
	PUSH	DE		;Save user's name pointer
GTMOD3	LD	A,(DE)		;Compare the name strings
	CP	(HL)
	JR	NZ,GTMOD4		;Go if no match
	INC	HL
	INC	DE
	DJNZ	GTMOD3
	EX	DE,HL		;Name+1 to DE
;
;	Found a match - exit with info
;
	POP	HL		;Keep DE to name end+1
	POP	HL		;Module start address
	POP	BC		;Reg restoral
	XOR	A		;Set Z for return
	RET
;
;	No match - loop to next module
;
GTMOD4	POP	DE
GTMOD5	POP	HL
	INC	HL
	INC	HL		;Point to last byte of module
	LD	A,(HL)		;P/u low order
	INC	HL
	LD	H,(HL)		;P/u high order
	LD	L,A
	INC	HL		;Bump to next address
	LD	A,H		;Ck for wrap to zero
	OR	L
	JR	NZ,GTMOD2	;Loop if not through
GTMOD6	POP	BC		;Restore reg
	LD	A,8
	OR	A
	RET
;
;	Routine to check if task slot active
;
CKTSK
	RLCA			;Task number * 2
	ADD	A,TCB$&0FFH+1	;Index into table
	LD	L,A
	LD	H,TCB$<-8
	LD	A,45H
	CP	(HL)
	RET
	PAGE	OFF
	ENDIF
;
CPHLDE
	LD	A,H
	SUB	D
	RET	NZ
	LD	A,L
	SUB	E
	RET
;
BEGIN	DW	0
PRMTBL
;
	DB	'TIME  '
	DW	TIME
	DB	'T     '
	DW	TIME
	DB	'SLOT  '
	DW	SLOT$
	DB	'S     '
	DW	SLOT$
	DB	'YANK  '
	DW	YANK
	DB	'Y     '
	DW	YANK
	DB	0
	PAGE	OFF
;---------------------------------------------------------------------
;
;Get time and date from SmartWatch and set into SYSTEM
;
;---------------------------------------------------------------------
MODULE
	JR	ENTRY
	DW	0		;Space for relocated end of module
	DB	MODTCB-MODNAM	;# bytes in the name field below
	IF	MODEL1
MODNAM	DB	'$SMART1'
	ENDIF
	IF	MODEL3
MODNAM	DB	'$SMART3'
	ENDIF
	IF	MODEL4
MODNAM	DB	'$SMART4'
	ENDIF
MODTCB	DW	ENTRY		;Task control block for module
	DW	MODULE
;
NUM	DB	0
COUNT	DB	0
BASE	DW	0000H
TSKSLOT	DB	0
OPREG$	DB	0
FRACT	DB	0FFH
SECOND	DB	0FFH
MINUTE	DB	0FFH
HOUR	DB	0FFH
DAY	DB	0FFH
DATE	DB	0FFH
MONTH	DB	0FFH
YEAR	DB	0FFH
	IF	MODEL4
TIMBUF$	DB	'hh:mm:ss'
	ENDIF
	DC	10,'S'
STACK$	DB	'SS'
INIT	EQU $			;This routine is linked to @ICNFG
	CALL	UPDATE
TX01	EQU	$-2
LINK	DC	3,0		;Link to next module init
;
ENTRY
	LD	HL,COUNT
TX02	EQU	$-2
	INC	(HL)
	LD	A,(NUM)		;Initialized by Time parameter
TX03	EQU	$-2
	CP	(HL)
	JR	C,UPDATE
	RET
UPDATE
	CALL	GETCLK		;Get time from SmartWatch
TX04	EQU	$-2
	JP	SETDOS		;  and set the system time
TX05	EQU	$-2
;
GETCLK
	PUSH	IY		;Save IY on system stack
	LD	HL,COUNT
TX06	EQU	$-2
	LD	(HL),0		;Zero count
;
;	Bring the ROM into the memory map for access to SmartWatch
;
	IF	MODEL3
	LD	A,(IMAG84)
	LD	(OPREG$),A
TX07	EQU	$-2
	ENDIF
	IF	MODEL4
	LD	A,@FLAGS
	RST	28H
	LD	A,(IY+14)
	LD	(OPREG$),A
TX07	EQU	$-2
	ENDIF
	DI			;Can't be interrupted
	LD	(STACK$),SP	;Save the stack pointer
TX08	EQU	$-2
	LD	SP,STACK$	;Task stack
TX09	EQU	$-2
	IF	MODEL3
	XOR	A
	OUT	(84H),A
	ENDIF
	IF	MODEL4
	LD	A,84H
	OUT	(84H),A
	ENDIF
;
	LD	A,1		;To enable 4P boot rom
	OUT	(9CH),A
;
;	Reset the SmartWatch by clocking through 65 single-bit
;	reads to flush any pending transfers.
;
	LD	HL,(BASE)	;Get Base address of rom
TX10	EQU	$-2
	LD	BC,4		;Point to address
	ADD	HL,BC		;  for bit reads
	LD	B,65
RESET	LD	A,(HL)
	DJNZ	RESET
	PAGE	OFF
;
;	Next, 64 consecutive write cycles are executed.  The 64
;	write cycles are used only to gain access to the SmartWatch.
;
	LD	B,02H		;Make two passes
UNLOCK	PUSH	BC
	LD	A,0C5H		;Begin the unlock sequence.
	CALL	WRTCLK		;The odds of this pattern being
TX11	EQU	$-2
	LD	A,3AH		;accidentally duplicated and
	CALL	WRTCLK		;causing inadvertent entry to
TX12	EQU	$-2
	LD	A,0A3H		;the SmartWatch is less than
	CALL	WRTCLK		;1 in 10^19
TX13	EQU	$-2
	LD	A,5CH
	CALL	WRTCLK
TX14	EQU	$-2
	POP	BC
	DJNZ	UNLOCK
;
;	Read 8 bytes from the SmartWatch
;
	LD	DE,FRACT	;Point to table for watch data
TX15	EQU	$-2
	LD	B,8		;Number of bytes to read
GETLP	PUSH	BC		;Save count on stack
;
;	Read data 1 bit at a time from the SmartWatch,
;	assemble data in A.
;
	PUSH	DE
	LD	HL,(BASE)	;Get Base address of SmartWatch
TX16	EQU	$-2
	LD	BC,4		;Offset to read bit address
	ADD	HL,BC		;HL now points to Read Bit address
	XOR	A		;Set all bits to zero.
	LD	B,08H		;8 bits make one byte
RTCRD	LD	C,(HL)
	BIT	0,C
	JR	Z,RDBITL	;Jump if the bit is
				;already zero.
	SET	0,A		;Set the bit.
RDBITL	RRCA			;Rotate right one bit.
	DJNZ	RTCRD		;Do all of the bits.
	POP	DE
	LD	(DE),A		;Save it in the buffer
	INC	DE		;Advance pointer
	POP	BC		;Get count from stack
	DJNZ	GETLP		;Until done
	PAGE	OFF
;
;	Restore RAM to the memory map for LDOS access
;
	XOR	A		;Zero to disable 4P boot ROM
	OUT	(9CH),A
	IF	MODEL3.OR.MODEL4
	LD	A,(OPREG$)
TX17	EQU	$-2
	OUT	(84H),A
	ENDIF
;
	LD	SP,(STACK$)	; Restore stack
TX18	EQU	$-2
	POP	IY
	EI			;Allow interrupts again
	RET
	PAGE	OFF
;	The following routine will set the time in the LDOS
;	operating system.
;
SETDOS
	PUSH	IY
	IF	MODEL1.OR.MODEL3
	LD	IY,DATE$
	ENDIF
	IF	MODEL4
	LD	HL,TIMBUF$
TX19	EQU	$-2
	LD	A,@DATE
	RST	28H
	PUSH	DE
	POP	IY
	ENDIF
	LD	A,(MONTH)
TX20	EQU	$-2
	CALL	BCD2BIN
TX21	EQU	$-2
	LD	(IY+2),A	;Set new system month
	LD	A,(DATE)
TX22	EQU	$-2
	CALL	BCD2BIN
TX23	EQU	$-2
	LD	(IY+1),A	;Set new system date
	LD	A,(YEAR)
TX24	EQU	$-2
	CALL	BCD2BIN
TX25	EQU	$-2
	LD	(IY),A		;Set new system year
;
	IF	MODEL1.OR.MODEL3
	LD	IY,TIME$
	ENDIF
	IF	MODEL4
	LD	HL,TIMBUF$
TX26	EQU	$-2
	LD	A,@TIME
	RST	28H
	PUSH	DE
	POP	IY
	ENDIF
	LD	A,(HOUR)
TX27	EQU	$-2
	CALL	BCD2BIN
TX28	EQU	$-2
	LD	(IY+2),A	;Set new system hours
	LD	A,(MINUTE)
TX29	EQU	$-2
	CALL	BCD2BIN
TX30	EQU	$-2
	LD	(IY+1),A	;Set new system minutes
	LD	A,(SECOND)
TX31	EQU	$-2
	CALL	BCD2BIN
TX32	EQU	$-2
	LD	(IY),A		;Set new system seconds
	POP	IY
	RET
	PAGE	OFF
;************************************************************************
;
;   Write data in A to the SmartWatch
;
;************************************************************************
WRTCLK
	LD	HL,(BASE)	;Get Base address of SmartWatch
TX33	EQU	$-2
	LD	D,H		;and move it to DE
	LD	E,L
	INC	DE		;Point to location for write ones
	LD	B,08H		;We must deal with 8 bits at a time
	LD	C,A		;Move byte to C
RTCWR	RRC	C		;Is this bit a one or zero?
	JR	C,RTCWR1	;If bit is a 1
	LD	A,(HL)		;Write a zero by reading.
	JR	RTCWRL
;
RTCWR1	LD	A,(DE)		;Write a one by reading.
RTCWRL	DJNZ	RTCWR		;Until all 8 bits are output
	RET
;***********************************************************************
;
;		BCD to binary converter
;
;This routine will convert an 8 bit BCD number (0-99) to binary.
;The routine returns with the binary number in the 'A' register.
;
;***********************************************************************
BCD2BIN	LD	E,A		;Save original byte
	AND	0FH
	LD	D,A		;Save low nibble.
	LD	A,E
	AND	0F0H		;Mask LSN
	RRCA			;x2
	LD	E,A
	RRCA			;x4
	RRCA			;x8
	ADD	A,E		;x10
	ADD	A,D		;Low nibble
	RET
MODEND$	EQU	$
	PAGE	OFF
HELLO$	DB	'This software released as "SHAREWARE"',0AH
	DB	'SmartWatch Background Tasker Copyright 1987 by:',0AH
	DB	'Duane M. Saylor, '
	DB	'854 Eads Court, '
	DB	'Newport News, VA 23602',0AH
	DB	'SYSOP of the VolksBoard BBS (804) 220 0003',0AH,0DH
INSTL$	DB	'SmartWatch driver installed in high memory',0DH
HAVMOD$	DB	'SmartWatch task module resident',0AH
	DB	'Time interval updated',0DH
MODYNK$	DB	'SMART module removed from memory',0DH
TSKRM$	DB	'SMART module is trapped in memory',0AH
	DB	'Background task for clock update is disabled',0DH
NOSWP$	DB	'No SmartWatch present',0DH
INUSE$	DB	'Selected slot in use, installation aborted',0DH
	IF	MODEL1
NAM$	DB	'$SMART1',03H
	ENDIF
	IF	MODEL3
NAM$	DB	'$SMART3',03H
	ENDIF
	IF	MODEL4
NAM$	DB	'$SMART4',03H
	ENDIF
	PAGE	OFF
RELTAB	DW	TX01,TX02,TX03,TX04,TX05,TX06
	DW	TX08,TX09,TX10,TX11,TX12
	DW	TX13,TX14,TX15,TX16,TX18
	DW	TX20,TX21,TX22,TX23,TX24
	DW	TX25,TX27,TX28,TX29,TX30
	DW	TX31,TX32,TX33
	IF	MODEL4
	DW	TX07,TX17,TX19,TX26
	ENDIF
TABLEN	EQU	$-RELTAB/2
	END	START
