TOS8   ; #######################################################
 ; SHORT 8-TRACK OPERATING SYSTEM FOR CONVERTED 8-TRACK
 ; TAPE DECK.  FORMAT:
 ; ON, FAST FORWARD, FIND SPLICE, WRITE ENABLE, WRITE
 ; 256 BYTES OF DIRECTORY ENTRY, LOOP UNTIL 10 ENTRIES ARE
 ; WRITTEN OR NUMBER TRANSFERRED FROM BASIC IS ACHIEVED.
 ; FILL OUT TRACK WITH FF'S, VERIFY WRITE (IF VERIFY FLAG
 ; IS ON), FIND SPLICE, CHANGE TRACKS, REPEAT PROCESS FOR
 ; ALL FOUR TRACKS.
 ; DIRECTORY READ AT HIGH SPEED, ENTRIES ENTERED AT LOW
 ; SPEED IN 256-BYTE PACKETS.  EACH PACKET HAS A NUMBER
 ; WHICH IS STORED IN THE DIRECTORY.  NO DEFAULT ON TRACK
 ; OR DIRECTORY ENTRY IS ALLOWED.  DIRECTORY ENTRY #0 IS
 ; RESERVED FOR FREE PACKETS ON EACH TRACK AND SECTOR.
 ; *** NOTE:  THIS LISTING IS NOT A COMPLETE OPERATING
 ; SYSTEM.  IT CONTAINS A SAMPLE DIRECTORY FORMATTING AREA
 ; AND SAMPLE HIGH-SPEED TAPE READ/WRITE ROUTINES.  A FULL
 ; 8-TRACK OPERATING SYSTEM IS AVAILABLE; WRITE TO:
 ; MSB ELECTRONICS, MR#1 DRAWER 766, BARRE, VERMONT 05641
 ; FOR DETAILS.  THE INFORMATION PRESENTED IN THIS LISTING
 ; IS FOR DEMONSTRATION, ALTHOUGH IT MAY BE ORGANIZED,
 ; TOGETHER WITH OTHER STANDARD SAVE/LOAD PARAMETERS, INTO
 ; A FULL OPERATING SYSTEM.  ***
 ; #######################################################
 ;
 	ORG	7000H
 ;
 RDBYTE	EQU	$	; ***** REASSIGN TO READ BYTE
 WRBYTE	EQU	$	; ***** REASSIGN TO WRITE BYTE
 LEADER	EQU	$	; ***** REASSIGN TO LEADER WRITE
 LEADRD	EQU	$	; ***** REASSIGN TO LEADER READ
 DELAY	EQU	0060H		; DELAY VALUE IN ROM
 HOWMNY	DEFB	10D		; 10 UNLESS BASIC XFER
 VERFLG	DEFB	00H		; TRANSFERRED FROM BASIC
 VERFON	EQU	01H		; STATUS REQUIRED BY TOS
 PORT	EQU	55H		; DEFINED AT 85 DECIMAL
 WRITEN	EQU	01H		; DI0 = HIGH FOR WR ENABL
 WRITEA	EQU	02H		; DI1 = HI/LO FOR WRITE A
 WRITEB	EQU	04H		; DI2 = HI/LO FOR WRITE B
 RESSPL	EQU	08H		; DI3 = HI TO RESET SPLCE
 START	EQU	10H		; DI4 = HIGH FOR MOTOR ON
 FSTFWD	EQU	20H		; DI5 = HIGH FOR FAST FWD
 CHANGE	EQU	40H		; DI6 = HIGH TO CHNGE TRK
 READA	EQU	01H		; DQ0 GOES HI/LO DATA A
 CARTIN	EQU	02H		; DQ1 GOES HIGH AT CARTIN
 SPLICE	EQU	04H		; DQ2 GOES HIGH AT SPLICE
 TRACK0	EQU	08H		; DQ3 GOES HIGH AT TRK 0
 TRACK1	EQU	10H		; DQ4 GOES HIGH AT TRK 1
 TRACK2	EQU	20H		; DQ5 GOES HIGH AT TRK 2
 TRACK3	EQU	40H		; DQ6 GOES HIGH AT TRK 3
 READB	EQU	80H		; DQ7 GOES HI/LO DATA B
 STATUS	DEFB	00H		; COMPOSITE OF ABOVE
 ;
 ; BASIC PATCH HERE -- USE CUSTOM INTERPRETER
 ;
 ; #######################################################
 ; START 8-TRACK DECK MOTOR RUNNING (GIVE IT ENOUGH TIME)
 ; #######################################################
 ;
 AAAAAA	LD	C,PORT		; START VALUE
 	LD	A,START		; BITS SET TO START
 	OR	FSTFWD		; GET INTO HIGH GEAR
 	LD	(STATUS),A	; PUT IT INTO PLACE
 	LD	B,0FFH		; GET LONG LOOPS
 GOING	OUT	(C),A		; START 8 TRACK
 	DJNZ	GOING		; MANY TIMES FOR SURE
 ;
 ; #######################################################
 ; MOVE TO TRACK ZERO, CHECKING STATUS OF TRACK EACH TIME
 ; #######################################################
 ;
 	LD	D,0		; TRACK VALUE TO CHECK
 LOOP1	IN	A,(C)		; CHECK TRACK VALUE
 	CP	D		; AGAINST VALUE WANTED
 	JR	Z,JUMP1		; GO IF TRACK = 0
 	LD	A,CHANGE	; TRACK CHANGE VALUE
 	LD	HL,(STATUS)	; GET CURRENT STATUS
 	OR	H		; CHECK PREVIOUS INFO
 	LD	(STATUS),A	; AND PUT INTO PLACE
 	OUT	(C),A		; CHANGE TRACK VALUE
 	JR	LOOP1		; GO BACK UNTIL TRK = 0
 ;
 ; #######################################################
 ; FIND END-OF-TAPE SPLICE, AND DELAY TO GET PAST SPLICE
 ; #######################################################
 ;
 JUMP1	IN	A,(C)		; GET VALUE FROM PORT
 	AND	SPLICE		; CLEAR ALL OTHER VALUES
 	CP	SPLICE		; CHECK IF SPLICE DET'D
 	JR	NZ,JUMP1	; BACK UNTIL FOUND
 JUMP1A	IN	A,(C)		; GET VALUE FROM PORT
 	AND	SPLICE		; CLEAR ALL OTHER VALUES
 	CP	SPLICE		; CHECK IF STILL SPLICE
 	JR	Z,JUMP1A	; BACK UNTIL SPLICE OVER
 	LD	BC,1000H	; GET DELAY VALUE
 	CALL	DELAY		; DELAY TILL GOOD TAPE
 ;
 ; #######################################################
 ; WRITE LEADER (NOTE:  LEADER WRITE ROUTINE NOT INCLUDED)
 ; #######################################################
 ;
 	CALL	LEADER		; WRITE LEADER
 ;
 ; #######################################################
 ; FORMAT DIRECTORY (NOTE:  THIS METHOD IS FOR EXAMPLE)
 ; #######################################################
 ;
 	LD	HL,HOWMNY	; HOW MANY DIR ENTRIES?
 	XOR	A		; START WITH ENTRY #0
 LOOP3	LD	B,0FFH		; 256 BYTES TO WRITE
 LOOP2	CALL	WRBYTE		; WRITE THEM IN PLACE
 	PUSH	AF		; SAVE ACCUM TEMPORARILY
 	IN	A,(C)		; GET VALUE FROM DEVICE
 	AND	SPLICE		; CLEAR ALL OTHER VALUES
 	CP	SPLICE		; SEE IF SPLICE HIT
 	JR	Z,JMPX		; GO IF SPLICE IS HIT
 	DJNZ	LOOP2		; ELSE ON TO NEXT BYTE
 JMPX	POP	AF		; RESTORE ENTRY VALUE
 	INC	A		; UP TO NEXT ENTRY
 	CP	(HL)		; LAST ENTRY COMPLETED?
 	JR	NC,LOOP3	; OUT IF NOT DONE
 ;
 ; #######################################################
 ; FILL OUT TRACK WITH A SINGLE VALUE (AGAIN, OPTIONAL)
 ; #######################################################
 ;
 LOOP4	LD	A,0FFH		; WHEN DONE GET ALL FF'S
 	CALL	WRBYTE		; WRITE FF BYTE TO TAPE
 	IN	A,(C)		; CHECK CONTENTS OF PORT
 	AND	SPLICE		; MASK OUT OTHER BITS
 	CP	SPLICE		; CHECK IF TO SPLICE
 	JR	NZ,LOOP4	; IF NOT KEEP WRITING
 ;
 ; #######################################################
 ; GET NEXT TRACK VALUE AND GET TRACK FORMATTING READY
 ; #######################################################
 ;
 	INC	D		; GET NEXT TRACK VALUE
 	LD	A,D		; CHECK CURRENT VALUE
 	CP	4		; IS IT FOURTH TRACK?
 	JR	Z,JUMP2		; IF NOT THEN BACK
 ;
 ; #######################################################
 ; FORMAT NEXT TRACK, AND CONTINUE UNTIL PROCESS COMPLETE
 ; #######################################################
 ;
 	LD	A,CHANGE	; GET CHANGE TRACK VALUE
 	LD	HL,(STATUS)	; GET CURRENT STATUS
 	OR	H		; STATUS PLUS CHANGE
 	OUT	(C),A		; AND CHANGE THE TRACK
 	LD	A,CHANGE	; GET CHANGE TRACK AGAIN
 	CPL			; SWITCH THE BITS
 	LD	HL,(STATUS)	; GET THE STATUS
 	AND	H		; STATUS PLUS CHANGE
 	LD	BC,200H		; GET DELAY VALUE
 	CALL	DELAY		; AND INVOKE THE DELAY
 	OUT	(C),A		; AND TURN IT OFF
 	JR	JUMP1		; AND GO BACK FOR MORE
 ;
 ; #######################################################
 ; CHECK IF VERIFY FLAG IS ON (NOTE: ADD AS BASIC COMMAND)
 ; #######################################################
 ;
 JUMP2	LD	A,(VERFLG)	; STATUS OF VERIFY FLAG
 	CP	VERFON		; SEE IF FLAG IS ON
 	JR	NZ,JUMP3	; IF NOT THEN SKIP PAST
 ;
 ; #######################################################
 ; MOVE TO THE FIRST TRACK, CHECK EACH AS IT PROGRESSES
 ; #######################################################
 ;
 	LD	D,0		; SET COUNTER TO ZERO
 JUMP4	IN	A,(C)		; GET STATUS FROM DECK
 	CP	D		; CHECK AGAINST TRK 0
 	JR	Z,JUMP5		; IF AT ZERO, THEN GO
 	LD	A,CHANGE	; ELSE BEGIN TO CHANGE
 	LD	HL,(STATUS)	; GET VALUE FROM STATUS
 	OR	H		; AND CHECK STATUS VAL
 	OUT	(C),A		; AND SEND OUT CHANGE
 	LD	A,CHANGE	; GET VALUE AGAIN
 	CPL			; REVERSE THE BITS
 	LD	HL,(STATUS)	; GET VALUE FROM STATUS
 	AND	H		; GET VALUE FROM STATUS
 	LD	BC,200H		; GET DELAY VALUE
 	CALL	DELAY		; CALL DELAY IN ROM
 	OUT	(C),A		; AND SEND OUT CHANGE
 	JR	JUMP4		; AND GO DO THE REST
 ;
 ; #######################################################
 ; VERIFY THE TAPE FORMATTING AND QUALITY IF FLAG IS ON
 ; #######################################################
 ;
 JUMP5	LD	E,0		; PACKET NUMBER TO START
 LOOP7	LD	B,0FFH		; BYTE TO VERIFY WITH
 	CALL	LEADRD		; GET SYNC AND READ LEADR
 LOOP6	CALL	RDBYTE		; BEGIN READING THE BYTES
 	CP	E		; AND CHECK FORMAT INFO
 	JR	NZ,VERERR	; IF NOT CORRECT, ERROR
 	DJNZ	LOOP6		; AND GO BACK UNTIL DONE
 	INC	E		; GO TO NEXT PACKET
 	LD	A,(HOWMNY)	; CHECK IF FORMAT DONE
 	CP	E		; BY GETTING PACKET #
 	JR	NZ,LOOP7	; BACK IF NOT DONE
 ;
 ; #######################################################
 ; STOP THE TAPE MACHINE AND CLEAR OUT ALL STATUS INFO
 ; #######################################################
 ;
 JUMP3	XOR	A		; CLEAR ACCUM TO ZERO
 	LD	(STATUS),A	; PUT IN STATUS LOCATION
 	OUT	(C),A		; AND SEND IT OUT PORT
 ;
 ; #######################################################
 ; GET AND DISPLAY FORMAT COMPLETE MESSAGE (OR ERROR MSG)
 ; #######################################################
 ;
 	LD	HL,MESG01	; GET THE OKAY MESSAGE
 	CALL	28A7H		; LEVEL II DISPLAY ROUT.
 	JP	1D78H		; BACK TO INTERPRETER
 MESG01	DEFM	'FORMATTING COMPLETE'
 VERERR	LD	HL,MESG02	; VERIFY ERROR MESSAGE
 	CALL	28A7H		; DISPLAY SUBROUTINE
 	JP	06CCH		; BASIC COMMAND LEVEL
 MESG02	DEFM	'FORMAT ERROR'
 ;
 ; #######################################################
 ; THESE ROUTINES MAY BE CALLED WITH THE /LOAD COMMANDS OR
 ; THE /SAVE COMMANDS, AS WELL AS THE FORMATTING ABOVE.
 ; NOTE:  THESE ROUTINES USE AN EXCLUSIVE-OR METHOD OF
 ; RECORDING, WHICH WILL FUNCTION WITH A DIRECT DIGITAL
 ; RECORDING SITUATION SUCH AS THE 8-TRACK DEVICE.  FOR
 ; FURTHER INFORMATION ON ITS OPERATION, ASK FOR THE
 ; OHIO SCIENTIFIC TAPE WAFER INTERFACE, SOLD BY MSB
 ; ELECTRONICS (ADDRESS ABOVE), AND EXAMINE THE CODE.
 ; #######################################################
 ;
 BOTTOM	EQU	40F9H		; BOTTOM OF BASIC PROGRAM
 BASIC	EQU	06CCH		; RETURN TO READY MODE
 ;
 ENTER	DI			; KILL THEM SUCKERS
 	LD	HL,(BOTTOM)	; GET FIRST PROGRAM LOC'N
 	LD	A,(403DH)	; VALUE IN THE MASK
 	AND	0FCH		; SET BIT TO ZERO
 	LD	(403DH),A	; PUT BACK INTO LATCH
 	LD	E,A		; WILL BE USED A LOT
 ; ------------------------------------------------------
 NEXT	LD	A,(HL)		; SPECIAL TEST (EXAMPLE)
 	LD	D,A		; THIS IS THE BIG BUMPER
 	LD	B,8		; NUMBER OF BITS TO WRITE
 	LD	A,1		; THIS IS THE START BIT
 	OR	E		; GET PROPER LATCH MASK
 	OUT	(0FFH),A	; WRITE OUT START LEVEL
 	CALL	DELAY1		; WRITE A START DELAY
 	XOR	A		; SET UP A WITH 0 I/O BIT
 	OR	E		; GET PROPER LATCH MASK
 	OUT	(0FFH),A	; WRITE OUT STARTING EDGE
 ;
 ; #######################################################
 ; ADDING 66 T-STATES HERE TO TOTAL 95 US
 ; #######################################################
 ;
 	PUSH	IX		; 15 T-STATES
 	POP	IX		; 14 T-STATES
 	PUSH	IX		; 15 T-STATES
 	POP	IX		; 14 T-STATES
 	NOP			; 4  T-STATES
 	NOP			; 4  T-STATES
 ; -------------------------------------------------------
 ;
 ; #######################################################
 ; THIS IS SET UP FOR 3300 BAUD
 ; TOTAL LOOP TIME PER BIT SHOULD BE 300 US
 ; TOTAL T-STATES FOR EACH BIT LOOP = 169 = 95 US
 ; TOTAL T-STATES FOR BIT DELAY LOOPS AT 0060 NOTED BELOW
 ; #######################################################
 ;
 LOOP	CALL	DELAY2		; WRITE A NORMAL DELAY
 ; .......................................................
 	XOR	D		; TEST THE FIRST BIT
 	AND	1		; MASK OUT OTHER D BITS
 	PUSH	AF		; SAVE THE VALUE
 	OR	E		; VALUE OF LATCH MASK
 	OUT	(0FFH),A	; WRITE IT
 ; .......................................................
 	POP	AF		; ORIGINAL VALUE BACK
 	CPL			; REVERSE THE BIT
 	AND	1		; MASK OUT ALL BUT ONE
 	CALL	DELAY2		; WRITE A NORMAL DELAY
 	PUSH	AF		; SAVE THE PROPER BIT
 	OR	E		; AGAIN GET THE MASK
 	LD	(0000),HL	; NEED DELAY TIME
 	NOP			; BIT MORE DELAY TIME
 ;
 ; #######################################################
 ; FIRST LOOP FROM LINE 380-430 = 85 T-STATES = 48 US
 ; SECOND LOOP FROM LINE 440-530 = 84 T-STATES = 48 US
 ; #######################################################
 ;
 	OUT	(0FFH),A	; WRITE IT
 ; .......................................................
 	POP	AF		; GET ORIGINAL BITS BACK
 	RRC	D		; ORIENT D TO NEXT BIT
 	DJNZ	LOOP		; WRITE OUT 8 BITS
 ; .......................................................
 ;	XOR	A		; CLEAR ACC. TO ZERO
 ;	OR	E		; GET MASK FROM 403D
 ;	OUT	(0FFH),A	; SEND OUT ZERO BIT
 	CALL	DELAY2		; SPACE OUT LAST BIT TOO
 ;
 	INC	HL		; GET NEXT MEMORY LOC'N
 ;
 ; #######################################################
 ; PUT TESTING FOR MEMTOP HERE
 ; #######################################################
 ;
 ;	LD	A,H		; CURRENT MEMORY STATUS
 ;	CP	40H		; END? (EXAMPLE ONLY!!)
 	JR	NZ,NEXT		; GO BACK IF NOT DONE
 ;	JP	06CC		; READY (USE RETURN!)
 ;
 DELAY1	PUSH	AF		; SAVE AF REGISTERS
 	PUSH	BC		; SAVE BC REGISTERS
 	LD	BC,28H		; GET DELAY VALUE
 ;
 ; #######################################################
 ; LINE ABOVE COMPLETES A TOTAL 1000 US DELAY LOOP
 ; #######################################################
 ;
 	CALL	0060H		; MAKE A DELAY
 	POP	BC		; RESTORE BC REGISTERS
 	POP	AF		; RESTORE AF REGISTERS
 	RET			; BACK TO MAIN ROUTINE
 ;
 DELAY2	PUSH	AF		; SAVE AF REGISTERS
 	PUSH	BC		; SAVE BC REGISTERS
 	LD	BC,03H		; GET SHORTER DELAY VALUE
 ;
 ; #######################################################
 ; LINE ABOVE COMPLETES AT TOTAL 205 US DELAY LOOP
 ; #######################################################
 ;
 	CALL	0060H		; MAKE A DELAY
 	POP	BC		; RESTORE BC REGISTERS
 	POP	AF		; RESTORE AF REGISTERS
 	RET			; BACK TO MAIN ROUTINE
 ;
 ; #######################################################
 	END	ENTER
