DIRSLO ;*************************************
 ;*	      DIRSLOT/CMD	     *
 ;*				     *
 ;*   by Joachim Kelterbaum	     *
 ;*   Frankenstr. 305		     *
 ;*   4300 Essen 1		     *
 ;*   W. Germany 		     *
 ;*				     *
 ;* please , read document file	     *
 ;* DIRSLOT/DOC before you make use   *
 ;* of this program		     *
 ;*************************************
 	ORG	8000H
 FILDIR	DEFM	'DIR/SYS:'   ;Name of Dir-file to be modified
 NBDV	DEFB	0	     ;space for drive number
 	DEFB	0DH
 ;
 DIRBUF	DEFS	7680	     ;buffer to hold directory
 ;
 	ORG	5200H
 			     ;constants
 SNB	DEFB	0	     ;will hold target slot #
 ENR	DEFB	0	     ;low dec. digit of target slot #
 ZNR	DEFB	0	     ;high	   "
 DNR	DEFB	0	     ;target drive #
 GRNNB	DEFB	0	     ;# grans of directory in target disk
 SLTMX	DEFB	0	     ;max. allowable slot #
 FILNAM	DEFS	15	     ;holds name of file to be moved
 SLTTX	DEFS	2	     ;target slot # (string)
 CONFIL	DEFS	11	     ;converted filename (directory format)
 	DEFB	0AH
 	DEFB	0DH
 COUNT	DEFW	0	     ;rel. pos # of target file in DIRBUF
 XPOS	DEFB	0	     ;x-pos	      "
 YPOS	DEFB	0	     ;y-pos	      "
 SORGNB	DEFB	0	     ;slot # of orig. file
 	DEFB	0
 CNTZIL	DEFB	0	     ;rel pos # of orig. file in DIRBUF
 	DEFB	0
 QUAD	DEFW	0	     ;adress of target file in DIRBUF
 ZILAD	DEFW	0	     ;	 "	orig.	    "
 HEORG	DEFW	0	     ;	 "	HIT entry for target
 HEZIL	DEFW	0	     ;	 "	     "	      orig.
 ZILMS	DEFB	0AH
 	DEFM	'Directory Slot # '
 MSINS	DEFS	2
 	DEFM	' currently holds the following entry:'
 	DEFB	0AH
 	DEFB	0DH
 ;
 FCB	DEFS	32	     ;file control block
 FCODE	DEFB	0	     ;will hole error code
 ;
 BUFFER	DEFS	256	     ;file buffer
 ;
 SLTMS1	DEFM	'** File ** '
 	DEFB	3
 SLTMS2	DEFM	'now resides at Slot #'
 	DEFB	3
 ;
 FXDMS	DEFB	0AH
 	DEFM	'required Slot is occupied by an FXDE'
 	DEFB	0DH
 ABOMS	DEFB	0AH
 	DEFM	'Job has been aborted'
 	DEFB	0AH
 	DEFB	0DH
 QUST	DEFM	'exchange Slots (Y/N) ?'
 	DEFB	0DH
 XCHMS	DEFB	0AH
 	DEFM	'** EXCHANGE SELECTED SLOTS **'
 	DEFB	0DH
 ;
 			     ;Start of program *********
 	ORG	5800H
 START	LD	A,(HL)	     ;get 1st char from input buffer
 	CP	0DH	     ;is it enter?
 	JR	Z,ERR1	     ;Y -> error
 	LD	DE,FCB	     ;point to FCB
 	CALL	441CH	     ;extract filespec.
 	JR	OK
 ERR1	CALL	01C9H	     ;print error mssg.
 	LD	HL,MES
 	LD	DE,3C00H
 	LD	BC,15
 	LDIR
 	JP	402DH	     ;-> DOS
 ;
 MES	DEFM	'Parameter Error'
 	DEFB	0
 ;
 OK	LD	A,(HL)	     ;get following 2 dec. digits as target slot #
 	SUB	30H
 	JR	C,ERR1
 	CP	0AH
 	JR	NC,ERR1
 	LD	(ZNR),A
 	INC	HL
 	LD	A,(HL)
 	SUB	30H
 	JR	C,ERR1
 	CP	0AH
 	JR	NC,ERR1
 	LD	(ENR),A
 	LD	A,(ZNR)
 	SLA	A
 	LD	B,A
 	SLA	A
 	SLA	A
 	ADD	A,B
 	LD	B,A
 	LD	A,(ENR)
 	ADD	A,B
 	LD	(SNB),A      ;put slot # ->SNB
 	CALL	SIGNUP	     ;print sign up mssg.
 	LD	A,0	     ;clear FILNAM buffer
 	LD	HL,FILNAM
 	LD	(HL),A
 	LD	DE,FILNAM+1
 	LD	BC,14
 	LDIR
 	LD	HL,4320H     ;point to filename in input buffer
 	LD	DE,FILNAM
 TRANS	LD	A,(HL)	     ;move it to FILNAM
 	CP	','
 	JR	Z,OUT11
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	JR	TRANS
 OUT11	LD	A,0DH	     ;append 0DH
 	LD	(DE),A
 	INC	HL
 	LD	DE,SLTTX     ;move target slot # to SLTTX
 	LD	B,2
 TR2	LD	A,(HL)
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	DJNZ	TR2
 	LD	DE,FCB	     ;open target file to see,
 	LD	HL,BUFFER    ;if it exists and on which
 	LD	B,0	     ;drive it is located
 	CALL	4424H	     ;open file
 	LD	A,(FCB+6)    ;extract drive # from FCB
 	LD	(DNR),A      ; -> DNB
 	SLA	A	     ;calc. adress of DDGA byte in PDRVE table
 	LD	B,A
 	SLA	A
 	SLA	A
 	ADD	A,B
 	ADD	A,9
 	LD	C,A
 	LD	B,0
 	LD	HL,4371H
 	ADD	HL,BC
 	LD	A,(HL)
 	LD	(GRNNB),A    ;put it to GRNNB
 	LD	B,A	     ;calc. max allowable # of slots
 	SLA	A
 	SLA	A
 	ADD	A,B
 	SUB	2
 	SLA	A
 	SLA	A
 	SLA	A
 	LD	(SLTMX),A    ;put it to SLTMX
 	LD	B,A	     ;check for alloable slot # input
 	LD	A,(SNB)
 	SUB	B
 	JR	Z,ERR2
 	JR	C,OK2
 ERR2	CALL	01C9H	     ;error if target slot # not allowable
 	LD	HL,MS2
 	LD	DE,3C00H
 	LD	BC,19
 	LDIR
 	JP	402DH
 MS2	DEFM	'illegal slot number'
 OK2	LD	DE,FCB
 	CALL	4428H	     ;close file again
 	LD	A,(DNR)      ;plug drive # into FILDIR buffer
 	ADD	A,30H
 	LD	(NBDV),A
 	LD	HL,FILDIR    ;prepare to open DIR/SYS on that drive
 	CALL	441CH	     ;extract filespec.
 	LD	HL,BUFFER    ;HL -> file buffer
 	LD	B,0	     ;256 byte records
 	CALL	4420H	     ;open file
 	CALL	443FH	     ;pos. to start of file
 	LD	A,(GRNNB)    ;calc. # of sectors to be moved
 	LD	B,A
 	SLA	A
 	SLA	A
 	ADD	A,B
 	LD	B,A	     ;put result to B
 	LD	DE,DIRBUF    ;read (B) sectors and move to DIRBUF
 TRFDIR	PUSH	BC
 	PUSH	DE
 	LD	DE,FCB
 	CALL	4436H	;READ SECTOR
 	POP	DE
 	LD	HL,BUFFER
 	LD	BC,256
 	LDIR
 	POP	BC
 	DJNZ	TRFDIR
 	LD	DE,FCB
 	CALL	4428H	     ;close file again
 	CALL	NAMCON	     ;convrt. name of target file to DIR format
 	LD	HL,CONFIL    ;search for target file entry in DIRBUF
 	LD	DE,DIRBUF+205H
 	LD	B,11
 	CALL	SEARCH
 	LD	BC,(COUNT)   ;(BC) = rel pos # of file entry
 	JP	C,NFDERR     ;error if not found
 	CALL	01C9H	     ;CLS
 	LD	A,C	     ;calc. slot # of target file
 	LD	B,A
 	SRL	A
 	SRL	A
 	SRL	A
 	LD	(XPOS),A
 	SLA	A
 	SLA	A
 	SLA	A
 	LD	C,A
 	LD	A,B
 	SUB	C
 	LD	(YPOS),A
 	LD	A,(XPOS)
 	SRL	A
 	SRL	A
 	SRL	A
 	SLA	A
 	SLA	A
 	SLA	A
 	LD	C,A
 	LD	A,(XPOS)
 	SUB	C
 	LD	B,A
 	LD	A,C
 	SLA	A
 	SLA	A
 	SLA	A
 	LD	C,A
 	LD	A,(YPOS)
 	SLA	A
 	SLA	A
 	SLA	A
 	ADD	A,C
 	ADD	A,B
 	LD	(SORGNB),A   ;put result -> SORNB
 ;
 	LD	A,2	     ;set NTF to integer
 	LD	(40AFH),A
 	LD	HL,SORGNB
 	CALL	09F7H	     ;copy SORGNB to ACCUM
 	CALL	0FBEH	     ;convt to string
 	PUSH	HL	     ;save adress
 	LD	A,0DH	     ;append 0DH
 	LD	HL,4136H
 	LD	(HL),A
 	LD	HL,SLTMS1    ;messg: target file found at
 	CALL	4467H
 	LD	HL,FILNAM
 	CALL	4467H
 	LD	HL,SLTMS2
 	CALL	4467H
 	POP	HL	     ;slot # SORGNB
 	CALL	4467H
 	LD	A,(SNB)      ;calc. rel. pos of orig. file
 	LD	B,6	     ;entry in DIRBUF
 DV64	SRL	A
 	DJNZ	DV64
 	LD	B,6
 MU64	SLA	A
 	DJNZ	MU64
 	LD	D,A
 	LD	A,(SNB)
 	SUB	D
 	LD	B,A
 	SRL	A
 	SRL	A
 	SRL	A
 	LD	C,A
 	LD	A,B
 	AND	07H
 	SLA	A
 	SLA	A
 	SLA	A
 	ADD	A,C
 	ADD	A,D
 	LD	(CNTZIL),A   ;put result -> CNTZIL
 	LD	HL,SLTTX     ;inset target slot # (as string into MSINS)
 	LD	DE,MSINS
 	LD	BC,2
 	LDIR
 	LD	HL,DIRBUF+200H;search for original file entry at target slot #
 	LD	A,(CNTZIL)
 	LD	B,A
 	LD	DE,32
 FDENTR	ADD	HL,DE
 	DJNZ	FDENTR
 	LD	A,(HL)	     ;get 1st byte of that file entry
 	CP	90H	     ;is it an FXDE ?
 	JR	NZ,NOFX      ;no ->NOFX
 	LD	HL,FXDMS     ;yes: error + abort
 	CALL	4467H
 ABORT	LD	HL,ABOMS
 	CALL	4467H
 	JP	402DH
 NOFX	BIT	4,A	     ;is file active ?
 	JR	Z,XCHFLS     ;no : exchange file entries
 	LD	B,5	     ;yes : display file name
 ADV	INC	HL
 	DJNZ	ADV
 	LD	DE,CONFIL
 	LD	BC,11
 	LDIR
 	LD	HL,ZILMS     ;ask if exchange is to be done
 	CALL	4467H
 	LD	HL,CONFIL
 	CALL	4467H
 	LD	HL,QUST
 	CALL	4467H
 	CALL	0049H	     ;get keybd. entry
 	AND	5FH	     ;convt to upper case
 	CP	'Y'          ;is it Y ?
 	JR	NZ,ABORT     ;no : abort
 XCHFLS	LD	HL,XCHMS     ;yes : exchange entries
 	CALL	4467H
 	LD	HL,(COUNT)   ;get rel pos of target file entry
 	LD	B,5	     ;and calculate adress in DIRBUF
 M32	ADD	HL,HL
 	DJNZ	M32
 	LD	DE,DIRBUF+200H
 	ADD	HL,DE
 	LD	(QUAD),HL    ;result to QUAD
 	LD	DE,FCB	     ;transfer file entry to FCB
 	LD	BC,32
 	LDIR
 	LD	HL,(CNTZIL)  ;calc. adress of original file
 	LD	B,5	     ;in DIRBUF
 MU32	ADD	HL,HL
 	DJNZ	MU32
 	LD	DE,DIRBUF+200H
 	ADD	HL,DE
 	LD	(ZILAD),HL   ;result to ZILAD
 	LD	DE,(QUAD)    ;move that file entry to slot of target file
 	LD	BC,32
 	LDIR
 	LD	HL,FCB	     ;move target file entry to slot of orig. file
 	LD	DE,(ZILAD)
 	LD	BC,32
 	LDIR
 	LD	A,(COUNT)    ;exchange the HIT entries in an
 	CALL	CALC	     ;analogous manner
 	LD	(HEORG),HL
 	LD	A,(CNTZIL)
 	CALL	CALC
 	LD	(HEZIL),HL
 	LD	HL,(HEORG)
 	PUSH	HL
 	LD	A,(HL)
 	LD	B,A
 	LD	HL,(HEZIL)
 	LD	A,(HL)
 	LD	C,A
 	LD	A,B
 	LD	(HL),A
 	POP	HL
 	LD	A,C
 	LD	(HL),A
 	LD	DE,FCB
 	LD	HL,FILDIR
 	CALL	441CH	     ;extract filespec DIR/SYS:X
 	LD	HL,BUFFER
 	LD	DE,FCB
 	LD	B,0
 	CALL	4420H	     ;open file
 	LD	A,(DE)
 	SET	0,A	     ;set write protect state
 	LD	(DE),A
 	CALL	443FH	     ;pos to start of file
 	LD	A,(GRNNB)    ;now move DIRBUF back to file
 	LD	B,A
 	SLA	A
 	SLA	A
 	ADD	A,B
 	LD	B,A
 	LD	HL,DIRBUF
 TRF	PUSH	BC
 	LD	DE,BUFFER
 	LD	BC,256
 	LDIR
 	PUSH	HL
 	LD	DE,FCB
 	CALL	443CH
 	POP	HL
 	POP	BC
 	DJNZ	TRF
 	LD	DE,FCB
 	CALL	4428H
 	JP	402DH
 ;
 ;
 NAMCON	LD	HL,CONFIL    ;convert filename in FILNAM to directory
 	LD	A,20H	     ;format. i.e. 8 chrs. filename padded with blanks
 	LD	(HL),A	     ;plus 3 chars extension (padded)
 	LD	DE,CONFIL+1  ;put result to CONFIL
 	LD	BC,10
 	LDIR
 	LD	HL,FILNAM
 	LD	DE,CONFIL
 	LD	B,9
 TRFN	LD	A,(HL)
 	CP	'/'
 	JR	Z,OUT1
 	CP	':'
 	RET	Z
 	CP	0DH
 	RET	Z
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	DJNZ	TRFN
 	RET
 OUT1	INC	HL
 	LD	DE,CONFIL+8
 	LD	B,3
 TRXT	LD	A,(HL)
 	CP	':'
 	RET	Z
 	CP	0DH
 	RET	Z
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	DJNZ	TRXT
 	RET
 ;
 ;
 ;
 SEARCH	PUSH	BC	     ;search for string pointed to by (HL)
 	PUSH	DE	     ;start search at (DE)
 	PUSH	HL	     ;match string has (B) bytes
 CPIT	LD	A,(DE)	     ;if search fails, increment (DE) by 32
 	CP	(HL)	     ;increment COUNT by 1
 	JR	NZ,FAIL      ;if file entry is not active, go on
 	INC	HL	     ;C set if no match else reset
 	INC	DE
 	LD	A,D
 	OR	E
 	JR	Z,BUFND
 	DJNZ	CPIT
 FOUND	POP	HL
 	POP	DE
 	POP	BC
 	PUSH	HL
 	PUSH	DE
 	EX	DE,HL
 	LD	DE,-5
 	ADD	HL,DE
 	LD	A,(HL)
 	BIT	4,A
 	JR	Z,KILLED
 	POP	DE
 	POP	HL
 	LD	BC,(COUNT)
 	XOR	A
 	RET
 ;
 KILLED	POP	DE
 	POP	HL
 	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 ;
 FAIL	POP	HL
 	POP	DE
 	LD	BC,(COUNT)
 	INC	BC
 	LD	(COUNT),BC
 	POP	BC
 	PUSH	HL
 	LD	HL,32
 	ADD	HL,DE
 	EX	DE,HL
 	POP	HL
 	JR	SEARCH
 ;
 BUFND	POP	HL
 	POP	DE
 	POP	BC
 	XOR	A
 	CCF
 	RET
 ;
 NFDERR	CALL	01C9H
 	LD	HL,NFMES
 	CALL	4467H
 	JP	402DH
 NFMES	DEFM	'file entry could not be found'
 	DEFB	0DH
 ;
 CALC	LD	B,A	     ;calculate adress of HIT entry in DIRBUF
 	SRL	A	     ; (B) = rel pos. of entry in DIRBUF
 	SRL	A	     ; on exit (HL) = desired adress
 	SRL	A
 	LD	C,A
 	LD	A,B
 	AND	07H
 	LD	L,A
 	LD	H,0
 	LD	B,5
 X32	ADD	HL,HL
 	DJNZ	X32
 	LD	B,0
 	ADD	HL,BC
 	LD	BC,DIRBUF+100H
 	ADD	HL,BC
 	RET
 ;
 SIGNUP	CALL	01C9H	     ;present sign-up message
 	LD	HL,SUPMS
 	CALL	4467H
 	CALL	0049H
 	RET
 ;
 SUPMS	DEFM	'                    DIRSLOT'
 	DEFB	0AH
 	DEFB	0AH
 	DEFM	'        (C) Joachim Kelterbaum'
 	DEFB	0AH
 	DEFB	0AH
 	DEFM	'this program may blow your diskettes if used unproperly'
 	DEFB	0AH
 	DEFM	'you are URGED to read the instructions first'
 	DEFB	0AH
 	DEFB	0AH
 	DEFB	0AH
 	DEFM	'press any key to continue'
 	DEFB	0DH
 ;
 	END	START
