6100 ' Packing a Machine Language Routine in a String Variable
6110 '
6120 ' Data must be read as the decimal equivalent of the
6130 ' Machine Language Instructions
6140 '
6150 DATA 205,127,10,69,33,255,255,35,17,64,255,20,213,25,16
6160 DATA 253,229,193,33,193,63,237,66,209,229,25,209,237,176,201
6170 '
6180 ' Function: This program will create a variable-scrolling
6190 '
6200 CLS: CLEAR 200: DEFINT A-Z
6210 CLS: PRINTTAB(15)"Varible-Scroll Program": PRINT: PRINT
6220 PRINT "     Note that the Upper part of the screen will never change
6230 PRINT "as you enter lines of text below. The bottom of the screen will
6240 PRINT "scroll independently of the top of the screen when it is full.
6250 PRINT: PRINT "Enter '&' to exit
6260 '
6270 ' Read in machine language routine
6280 ' P$ before reading routine into P$
6290 ' P$="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"
6300 ' P$ after reading routine into P$
6310   P$="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"
6320 '
6330 ' Locate start of P$
6340 X = PEEK(VARPTR(P$)+2)*256 + PEEK(VARPTR(P$) + 1)
6350 ' Adjust value if > 32767
6360 ' AD = start address routine
6370 AD = X-INT(X/32768)*65536
6380 '
6390 FOR I = 1 TO LEN(P$): READ J: POKE AD+I-1,J: NEXT
6400 '
6410 ' Alternate METHOD
6420 ' You must know the length of the routine, eg., 30
6430 ' P$="": FOR I = 1 TO 30: READ J: P$=P$ + CHR$(J): NEXT
6440 '
6450 PRINT@0,STRING$(64,176);: N=0
6460 PRINT@64,"";: INPUT"# OF LINES TO PROTECT";N$
6470 ' Keep it in bounds
6480 IFVAL(N$)<1ORVAL(N$)>15 THEN 6460
6490 ' OK... I= # of lines to protect
6500 '      SC= Screen posn where protection starts
6510 I=VAL(N$): SC=1024-I*64-64: PRINT@SC,"";
6520 '      A$= User input...& is terminator
6530 ' Routines EXIT
6540 INPUTA$: IF A$=CHR$(38) THEN PRINT@64,CHR$(31);: END
6550 '
6560 ' Test: Is # of lines less than protection?
6570 '       Yes then increment lines counter
6580 IF N<I THEN N=N+1
6590 '
6600 ' If BOTTOM of screen has I lines, then scroll
6610 ' NOTE: LEVEL 2 Users GOSUB 7000 - DISK Users GOSUB 7100
6620 IF N=I THEN GOSUB6730: PRINT@SC+(I-1)*64,CHR$(31);
6630 ' Get more User input
6640 GOTO 6540
6650 '
6660 ' Scroll Routine
6670 ' Routine for Level 2 Users only
6680 ' Set up EPT address
6690 POKE 16526, PEEK(VARPTR(P$)+1)
6700 POKE 16527, PEEK(VARPTR(P$)+2)
6710 J = USR(I): RETURN
6720 ' Routine for Disk Users only
6730 DEF FN ADDRESS(X) = X-INT(X/32768)*65536
6740 DEF FN EPT = FN ADDRESS(PEEK(VARPTR(P$)+1)+PEEK(VARPTR(P$)+2)*256)
6750 DEFUSR0 = FN EPT
6760 J = USR0(I): RETURN
