INTERR 	ORG	5200H
 ;
 ;INTERRPT/CMD
 ;
 ;BY JOACHIM KELTERBAUM
 ;
 ;
 ;This module intercepts the keyboard driver if activated.
 ;By pressing shift-clear any running program can be
 ;interrupted as long as it polls the keyboard via DCB.
 ;When shift-clear is recognized, the whole RAM 3C00H -
 ;FFFFH except DOS overlay area including all registers
 ;and PC is saved to disk.
 ;Then a reboot is executed.
 ;When needed -some later time- enter INTERRPT,* from
 ;DOS. Your interrupted program will be reloaded from
 ;disk and will continue execution where it left off.
 ;The following conditions must be met !!!
 ;The program to be interrupted must poll the keyboard
 ;via DCB from time to time (BASIC does this anyway).
 ;The program must honour HIMEM.
 ;This module relocates itself below HIMEM.
 ;
 ;It is primarily intended to be used when a program
 ;runs over a long period of time.
 ;Be careful, if your program uses disk-files, because
 ;those files must stay in the same locations before
 ;and after interruption unless they have been closed
 ;before interruption.
 ;This is due to the fact that the information of an
 ;(eventually) open FCB is saved in the core-image and
 ;will be reused after restart of the interrupted
 ;program.
 ;If you do not take this precaution, you might destroy
 ;your disk !!!!!!!!!!!!!!!!!!
 ;ATTENTION !!!!
 ;
 ;This program assumes an existing file MEMORY/CIM:0
 ;Create it, if necessary. It will need 39 GRN's of
 ;diskette space.
 ;
 ;
 ;
 RELAD	DEFW	$-$	;put addr. of relocated routine
 			;here
 START	LD	A,(HL)	;get first parameter (*)
 	CP	'*'	;is it * ?
 	JP	Z,STAR	;yes ==> STAR
 	LD	HL,(4016H)	;get KBD driver address
 	LD	(SCALL+1),HL	;plug into SCALL+1
 	LD	HL,END		;last byte of mod. to be
 				;relocated
 	LD	DE,(4049H)	;get HIMEM value
 	LD	BC,END-SCALL+1	; # bytes to move
 	LDDR			; move module
 	LD	(4049H),DE	;update HIMEM
 	INC	DE		;first addr. of relocated
 				;module
 	LD	(RELAD),DE	;plug into RELAD
 	LD	(4016H),DE	;and KBD driver addr.
 	LD	B,0	;record length = 265
 	LD	DE,FCB1	;point to FCB of INTERRPT/CMD
 	LD	HL,BUFF2; buffer for that file
 	CALL	4424H	;open file
 	CALL	4436H	;read first sector
 	LD	HL,RELAD	;plug (RELAD)
 	LD	A,(HL)		;into rel. words
 	LD	(BUFF2+4),A	;4 and 5 of
 	INC	HL		;buffer
 	LD	A,(HL)		;and
 	LD	(BUFF2+5),A	;
 	CALL	443FH		;position to start of file
 	CALL	443CH		;write back first sector
 RLCT	LD	DE,(RELAD)	;relocate code from
 	LD	HL,RELTBL	;SCALL to END using
 NXTLOC	LD	A,(HL)		;RELTBL as relocation
 	LD	B,A		;table
 	INC	HL		;this method of relocation
 	OR	(HL)		;is described in
 	JR	Z,DONE		;TRS-80 ROM ROUTINES DOCUMENTED
 	PUSH	HL		;by Jack Decker
 	LD	H,(HL)
 	LD	L,B
 	ADD	HL,DE
 	LD	C,(HL)
 	INC	HL
 	LD	B,(HL)
 	DEC	HL
 	PUSH	DE
 	EX	DE,HL
 	ADD	HL,BC
 	EX	DE,HL
 	LD	(HL),E
 	INC	HL
 	LD	(HL),D
 	POP	DE
 	POP	HL
 	INC	HL
 	JR	NXTLOC
 DONE	LD	A,(FLAG)	;test if FLAG = 0
 	CP	0	;(means no *-option chosen)
 	JP	NZ,STARNT; if *-option was chosen
 	LD	HL,SGNMS	;display sign-up
 	CALL	4467H		;message on screen
 	JP	402DH		;==> DOS
 ;
 SGNMS	DEFM	'Run-time interrupt routine activated'
 	DEFB	0AH
 	DEFM	'start by pressing shift-clear'
 	DEFB	0AH
 	DEFM	'recall interrupted program by entering'
 	DEFB	0AH
 	DEFM	'INTERRPT,*'
 	DEFB	0DH
 ;
 STAR	LD	HL,3FF0H	;*-option ...
 			;move Stack out of the way
 			;so it won't be bombed by being
 			;overwritten while restoring
 			;the original core-image
 			;Stack temporarily resides
 			;within Video-RAM
 			;This can only work, if lower-
 			;case is installed, so Video-RAM
 			;has all 8 bits accessable
 	LD	SP,HL
 	LD	HL,SCALL	;move module SCALL-END
 	LD	DE,(RELAD)	;to (RELAD)
 	LD	BC,END-SCALL+1	;# bytes to be moved
 	LDIR	; do it
 	LD	A,1	;set FLAG to 1
 	LD	(FLAG),A
 	LD	HL,(4016H)	;get KBD driver addr.
 	EX	DE,HL		; --> DE
 	LD	HL,(RELAD)	;get start of new driver
 	INC	HL		;plug old driver address
 	LD	(HL),E		;into (RELAD+1)
 	INC	HL
 	LD	(HL),D
 	LD	HL,(RELAD)	;get new driver addr.
 	LD	(4016H),HL	;plug into DCB
 	JP	RLCT		;==> RLCT
 STARNT	LD	HL,(RELAD)	;continue after moving
 			;routine SCALL-END
 			;while *-option is selected
 	LD	BC,RESTOR-SCALL	;calculate addr. of RESTOR
 	ADD	HL,BC	;in relocated module
 	LD	(JMP+1),HL	;and
 JMP	JP	$-$	;jump to it
 ;
 RELTBL	DEFW	FCBA+1-SCALL	;relocation table
 	DEFW	MSA+1-SCALL
 	DEFW	FCBB+1-SCALL
 	DEFW	SCA+1-SCALL
 	DEFW	FCBX+2-SCALL
 	DEFW	FCBY+2-SCALL
 	DEFW	0	;end of table
 FLAG	DEFB	0
 FCB1	DEFM	'INTERRPT/CMD'
 	DEFB	0DH
 	DEFS	19	;fill up to 32 bytes
 BUFF2	DEFS	100H	;buffer
 ;
 STACK	EQU	4023H	;unused 2 bytes in RAM used as
 ;			stack-pointer pointer
 SCALL	CALL	$-$	;call original driver
 	CP	31	;was clear pressed ?
 	RET	NZ	;ret if not
 	LD	A,(3880H)	;is it shift-clear
 	BIT	0,A
 	JR	NZ,SHFCLR	;yes -->SHFCLR
 	LD	A,31	;no, so
 	RET		;return
 ;
 SHFCLR	PUSH	AF	;save all registers onto stack
 	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 	PUSH	IX
 	PUSH	IY
 	EX	AF,AF'	;switch register sets
 	EXX
 	PUSH	AF	;and save those, too
 	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 	LD	(STACK),SP	;store actual stack ptr.
 	EXX		;back to old register set
 	EX	AF,AF'
 	LD	B,0	;256-byte records
 FCBX	LD	IX,FCB-SCALL	;points to FCB
 FCBA	LD	DE,FCB-SCALL	;     same
 	LD	HL,3C00H	;first buffer = 3C00
 	CALL	4420H		;open file MEMORY/CIM:0
 CONT	CALL	443CH		;write sector
 	LD	BC,100H		;update pointer
 	ADD	HL,BC		;to next buffer
 	PUSH	HL	;save HL
 	LD	BC,4D00H	;is buffer at overlay-area
 	OR	A
 	SBC	HL,BC
 	POP	HL
 	JR	NZ,OK	;no -> OK
 	LD	HL,5200H	;yes, skip overlay-area
 	LD	(IX+3),L	;update buffer adress
 	LD	(IX+4),H	;in FCB
 	JR	CONT
 OK	LD	A,L	;is end of RAM reached ?
 	OR	H
 	LD	(IX+3),L	;update buffer addr.
 	LD	(IX+4),H	;in FCB
 	JR	NZ,CONT		;if not end of RAM go on
 ENDIT	CALL	4428H		;close file
 	CALL	01C9H		;clear screen
 MSA	LD	HL,MS-SCALL	;display message MS
 	CALL	4467H
 	LD	B,5	;hold it fo a while
 LPP	PUSH	BC
 	LD	BC,0FFFFH
 	CALL	60H
 	POP	BC
 	DJNZ	LPP
 	HALT		;force REBOOT
 ;
 MS	DEFM	'Core-Image has been saved'
 	DEFB	0AH
 	DEFM	'Reboot follows !!!'
 	DEFB	0DH
 ;
 ;
 RESTOR	LD	B,0	;256-byte records
 FCBY	LD	IX,FCB-SCALL	;points to FCB
 FCBB	LD	DE,FCB-SCALL	;same
 	LD	HL,4000H	;first buffer address
 			;you have to start reloading
 			;the old core image at 4000h
 			;because the screen is used
 			;as a temporary stack
 			;it is updated last !!
 	CALL	4420H	;open file
 	LD	BC,4	;record #4 (first after screen)
 	CALL	4442H	;position FCB there
 CONT2	CALL	4436H	;read sector
 	LD	BC,100H	;update buffer adress
 	ADD	HL,BC
 	PUSH	HL
 	LD	BC,4D00H	;is it overlay-area
 	OR	A
 	SBC	HL,BC
 	POP	HL
 	JR	NZ,OK2	;if not -> OK2
 	LD	HL,5200H	;skip overlay-area
 	LD	(IX+3),L	;update buffer address
 	LD	(IX+4),H	;in FCB
 	JR	CONT2
 OK2	LD	A,L	;is end of RAM reached ?
 	OR	H
 	LD	(IX+3),L	;update buffer address
 	LD	(IX+4),H	;in FCB
 	JR	NZ,CONT2	;if not, continue reading
 END2	LD	BC,0	;record #0 (first screen sector)
 	LD	HL,3C00H; buffer addr.
 	LD	(IX+3),L	;update in FCB
 	LD	(IX+4),H
 	CALL	4442H	;position file there
 	LD	HL,(STACK)	;get stack-pointer of
 	LD	SP,HL	;previously saved core image
 	LD	HL,3C00H
 	LD	B,4	;restore 4 sectors of old screen
 SCRLP	PUSH	BC
 	CALL	4436H
 	LD	BC,100H
 	ADD	HL,BC
 	POP	BC
 	LD	(IX+3),L
 	LD	(IX+4),H
 	DJNZ	SCRLP
 	CALL	4448H	;position to EOF
 	CALL	4428H	;close file
 	EX	AF,AF'	;restore all registers
 	EXX
 	POP	HL
 	POP	DE
 	POP	BC
 	POP	AF
 	EXX
 	EX	AF,AF'
 	POP	IY
 	POP	IX
 	POP	HL
 	POP	DE
 	POP	BC
 	POP	AF
 	LD	A,0	;plug 0 into # of cuccently loaded
 	LD	(4317H),A	;DOS overlay
 		;to force DOS to reload the needed
 		;overlay at the next RST 28H
 		;This is neccesscary, because the overlay-
 		;area is used during disk I/O by a
 		;different module than was resident before
 		;saving core-image
 SCA	JP	SCALL-SCALL	;back to KBD driver
 FCB	DEFM	'MEMORY/CIM:0'
 	DEFB	0DH
 	DEFS	19
 END	EQU	$
 	END	START
hͺb!nUb!T6 #ef~:8>0b~#b!nUb!Ttf++ͺbzIf{Ifz(pf{ mf{8	}f
80w#~#|}|z{zxyxy#~A?[~A8
[GA?~:0?!mm!qmNc{g8!umNcf8g8{2Tz(!n ;This program assumes an existing file MEMORY/CIM:0
 ;Create it, if necessary. It will need 39 GRN's of
 ;diskette space.
 ;
 ;
 ;
 RELAD	DEFW	$-$	;put addr. of relocated routine
 			;here
 START	LD	A,(HL)	;get first parameter (*)
 	CP	'*'	;is it * ?
 	JP	Z,STAR	;yes ==> STAR
 	LD	HL,(4016H)	;get KBD driver address
 	LD	(SCALL+1),HL	;plug into SCALL+1
 	LD	HL,END		;last byte of mod. to be
 				;relocated
 	LD	DE,(4049H)	;get HIME