HIRESB ; #######################################################
 ; ROUTINE TO DRAW HORIZONTAL AND VERTICAL LINES FR. BASIC
 ; #######################################################
 ;
 HIRES	EQU	0C000H		; START OF HIRES GRAFIX
 XFER	EQU	0A7FH		; VARIABLE XFER ROUTINE
 ;
 	ORG	7F00H		; SOMEWHERE IN MEMORY
 ;
 ; #######################################################
 ; SUBROUTINE TO DETERMINE THE CORRECT BASIC USR(X) CALL
 ; #######################################################
 ;
 ENTRY	CALL	XFER		; GET VALUE FROM BASIC
 	LD	A,H		; GET MSB INTO ACCUM.
 	ADD	A,L		; ADD LSB FROM HL PAIR
 	AND	A		; TEST IF IT IS ZERO
 	JR	Z,PCLS		; CLEAR SCREEN ROUTINE
 	CP	1		; TEST IF IT IS ONE
 	JR	Z,PHORIZ	; HORIZONTAL LINE ON 1
 	CP	2		; TEST IF IT IS TWO
 	JR	Z,PVERT		; VERTICAL LINE ON 2
 	JP	1997H		; ?SN ERROR IF NOT 1,2,3
 ;
 ; #######################################################
 ; SUBROUTINE TO CLEAR THE SCREEN IN HIGH-RESOLUTION MODE
 ; BASIC FORMAT:  M=USR(A).  A MUST ALWAYS BE ZERO.
 ; #######################################################
 ;
 PCLS	XOR	A		; GET CHARACTER TO WRITE
 	PUSH	AF		; SAVE THAT CHARACTER
 	LD	HL,HIRES	; GET BEGINNING OF HI-RES
 PCLEAR	POP	AF		; RESTORE ZERO CHARACTER
 	LD	(HL),A		; PUT IT IN PLACE IN MEM
 	PUSH	AF		; SAVE CHARACTER AGAIN
 	LD	A,H		; GET MSB OF CURRENT LOC.
 	OR	L		; GET LSB AND TEST PAIR
 	JR	NZ,PCLEAR	; LOOP BACK FOR NEXT
 	POP	AF		; GET STACK BACK IN SHAPE
 	RET			; BACK TO CALLING ROUT.
 ;
 ; #######################################################
 ; SUBROUTINE TO DRAW A HORIZONTAL LINE.  BASIC FORMAT:
 ; POKEN,B:C1=INT(C/6):C2=C-C1*6:POKEN+1,C1:POKEN+2,C2
 ; D1=INT(D/6):D2=D-D1*6:POKEN+3,D1:POKEN+4,D2:M=USR(1)
 ;
 ; B=LINE NUMBER (0-11, 16-27, 32-43, 48-59, 64-75, 80-91,
 ;	96-107, 112-123, 128-139, 144-155, 160-171, 176-
 ;	187, 192-203, 208-219, 224-235, 240-251
 ; C=ORIGINATION POSITION (0-383).
 ; D=DESTINATION POSITION (0-383). C MUST BE LARGER THAN D
 ; #######################################################
 ;
 PHORIZ	LD	IX,N		; POINT TO THE STORAGE
 	CALL	FINDER		; GET STARTING POSITION
 	LD	A,(N+3)		; GET VALUE AT "N+3"
 	LD	C,A		; PLACE IN MSB OF BC
 	XOR	A		; CLEAR ACCUM TO ZERO
 	LD	B,A		; PLACE IN LSB OF BC
 	PUSH	HL		; SAVE START LOC'N
 	PUSH	DE		; READY FOR XFER BACK
 	POP	HL		; TRANSFERRED BACK
 	ADD	HL,BC		; PERFORM THE ADDITION
 	PUSH	HL		; READY FOR TRANSFER
 	POP	DE		; AND GET INTO DESTIN'N
 	POP	HL		; RESTORE ORIGINAL VALUE
 	LD	A,(N+2)		; GET VALUE AT "N+2"
 	OR	(HL)		; ADD TO CURRENT LOC'N
 	LD	(HL),A		; AND PUT INTO PLACE
 	INC	HL		; NEXT SCREEN POSITION
 LOOP1	XOR	A		; CLEAR ACCUM TO ZERO
 	LD	A,(03FH)	; VALUE TO FILL BYTE
 	SBC	HL,DE		; PERFORM SUBTRACTION
 	JR	Z,HOROUT	; OUT OF ROUTINE
 	LD	(HL),A		; PUT BYTE IN PLACE
 	INC	HL		; GET NEXT SCREEN POS'N
 	JR	LOOP1		; GO BACK FOR NEXT FILL
 HOROUT	LD	A,(N+4)		; GET FINAL BYTE VALUE
 	OR	(HL)		; ADD TO VALUE ON SCREEN
 	LD	(HL),A		; PUT IT TO THE SCREEN
 	RET			; AND BACK TO BASIC
 ;
 ; #######################################################
 ; SUBROUTINE TO DRAW A VERTICAL LINE.  48K RAM IN PLACE.
 ; BASIC FORMAT:
 ; POKEN,B:C1=INT(C/6):C2=C-C1*6:POKEN+1,C1:POKEN+2,C2
 ; D1=INT(D/6):D2=D-D1*6:POKEN+3,D1:POKEN+4,D2:M=USR(2)
 ;
 ; E=HORIZONTAL POSITION (0-255)
 ; F=LINE NUMBER (SEE HORIZONTAL LINE, ABOVE)
 ; G=LINE NUMBER (SEE HORIZONTAL LINE, ABOVE)
 ; #######################################################
 ;
 PVERT	LD	IX,N		; POINT TO THE STORAGE
 	CALL	FINDER		; GET SCREEN START BYTE
 	PUSH	HL		; SAVE THE START VALUE
 	LD	IX,N+3		; POINT TO THE TABLE
 	CALL	FINDER		; AND DO THE WORK
 	PUSH	HL		; READY VALUE TO TRANSFER
 	POP	DE		; AND TRANSFER TO DEST'N
 	POP	HL		; RESTORE START POSITION
 	LD	BC,40H		; SCREEN BYTE LINE OFFSET
 	XOR	A		; CLEAR CARRY FLAG
 	LD	A,(N+2)		; GET BYTE FROM STORAGE
 LOOP2	LD	(HL),A		; STASH IT ON SCREEN
 	ADD	HL,BC		; MOVE UP ON SCREEN
 	SBC	HL,DE		; CHECK IF DONE YET
 	JR	NZ,LOOP2	; BACK IF NOT DONE
 	LD	(HL),A		; PUT LAST BYTE IN
 	RET			; BACK TO BASIC
 ;
 ; #######################################################
 ; FINDER SUBROUTINE LOCATES PROPER BYTE WITHIN HIRES AREA
 ; #######################################################
 ;
 FINDER	LD	HL,HIRES	; GET HI-RESOLUTION SCRN
 	LD	A,(IX)		; GET START BYTE OFFSET
 	LD	B,A		; PLACE IN B REGISTER
 	XOR	A		; CLEAR THE CARRY FLAG
 	RR	B		; DIVIDE BY TWO AND ...
 	RR	C		; ... ROTATE IN ORDER ...
 	RR	B		; ... ACTUALLY TO ...
 	RR	C		; ... MULTIPLY BY 64
 	ADD	HL,BC		; MAKE NEW SCREEN POS'N
 	PUSH	HL		; READY IT FOR TRANSFER
 	POP	DE		; TRANSFER TO DESTIN'N
 	LD	A,(IX+1)	; GET START BIT OFFSET
 	LD	C,A		; PLACE IN MSB OF BC
 	XOR	A		; CLEAR ACCUM TO ZERO
 	LD	B,A		; PLACE IN LSB OF BC
 	ADD	HL,BC		; GET NEW START BIT
 	RET			; BACK TO CALLING ROUT.
 ;
 N	EQU	$		; MEMORY STORAGE POS'NS
 ;
 	END	06CCH		; BACK TO BASIC
