RHYTHA ; =======================================================
 ; RHYTHMATRON PROGRAM
 ; DENNIS BATHORY KITSZ
 ; =======================================================
 ;
 ; DESCRIPTION:
 ; ROM IS LOCATED AT $0000 TO $07FF
 ; RAM IS LOCATED AT $1000 TO $1FFF
 ; I/O PORTS ARE LOCATED AT $2000 TO $200F
 ;
 ; KEYBOARD MATRIX IS I/O PORT 1A (OUTPUT), 1B (INPUT)
 ; 8-BIT A/D CONVERTER IS I/O PORT 1C (INPUT)
 ; 8-BIT BAR (BEATS) DISPLAY IS AT I/O PORT 2A (OUTPUT)
 ; TRIGGERS (FILTER PULSES) ARE AT I/O PORT 2B (OUTPUT)
 ; TAPE I/O IS AT I/O PORT 2C (INPUT AND OUTPUT)
 ; BEAT INDICATOR (PULSING LED) IS AT I/O PORT 2C (OUTPUT)
 ; A/D CONVERTER COUNT TRIGGER IS AT I/O PORT 2C (OUTPUT)
 ; 7-SEGMENT DISPLAY VALUES ARE AT I/O PORT 3A (OUTPUT)
 ; 7-SEGMENT DIGIT STROBE IS AT I/O PORT 3B (OUTPUT)
 ; SPARE IS AT I/O PORT 3C
 ;
 ; =======================================================
 ;
 	ORG	0000H		; RST 00H
 	DI			; 1ST ACTION, KILL INTS.
 	XOR	A		; CLEAR ACCUM TO ZERO
 	LD	HL,1000H	; GET START OF RAM AREA
 	JP	ENTRY		; POWER-UP INITIALIZATION
 	ORG	0008H		; RST 08H
 	JP	SCAN1		; MAIN KEYBOARD SCAN
 	ORG	0010H		; RST 10H
 	JP	STOP		; STOP ACTION ROUTINE
 	ORG	0018H		; RST 18H
 	JP	DRMSCN		; DRUM INPUT SCAN ROUTINE
 	ORG	0020H		; RST 20H
 	RET
 	ORG	0028H		; RST 28H
 	RET
 	ORG	0030H		; RST 30H
 	RET
 	ORG	0038H		; RST 38H
 	JP	CLOCK		; INTERRUPT SERVICE ROUT
 	ORG	0100H		; START OF MAIN PROGRAM
 ENTRY	LD	A,(HL)		; GET VALUE FROM RAM
 	LD	D,A		; SAVE TEMPORARILY
 	CPL			; COMPLEMENT WHOLE BYTE
 	LD	(HL),A		; STORE IT IN MEMORY
 	CP	(HL)		; IS IT WHAT WAS STORED?
 	JR	NZ,FAULT	; IF NOT, THEN MEM FAULT
 	LD	A,D		; ELSE GET ORIGINAL VALUE
 	LD	(HL),A		; PUT BACK INTO MEMORY
 	INC	HL		; GET NEXT MEMORY LOC'N
 	LD	A,L		; CHECK LS BYTE
 	CP	00H		; 00? (OF MAXIMUM 2000)
 	JR	NZ,ENTRY	; IF NOT, THEN REPEAT
 	LD	A,H		; CHECK MS BYTE
 	CP	02H		; 20? (OF MAXIMUM 2000)
 	JR	NZ,ENTRY	; IF NOT, THEN REPEAT
 	JR	START		; LEAVE WHEN FINISHED
 FAULT	LD	A,4		; GET ERROR 4 (MEM FAULT)
 	JP	ERROR		; DISPLAY IT AND STOP
 START	LD	A,8BH		; PORT SETUP VALUES
 	LD	(CWORD1),A	; A=OUT, B=IN, C=IN
 	LD	A,88H		; PORT 2 SETUP VALUE
 	LD	(CWORD2),A	; A=OUT, B=OUT, C=IN/OUT
 	LD	A,80H		; PORT 3 SETUP VALUE
 	LD	(CWORD3),A	; A=OUT, B=OUT, C=OUT
 	LD	SP,1FFFH	; TOP OF RAM PUSH-DOWN
 	LD	HL,BLKMOV	; BLOCK OF FIXED DATA
 	LD	DE,NUMBER	; START OF RAM STORAGE
 	LD	BC,0DDH		; NUMBER OF FIXED DATA
 	LDIR			; BLOCK MOVE ROM TO RAM
 	IM	1		; SET INTERRUPT CONDITION
 	EI			; READY TO USE INTERRUPTS
 	JP	MASTER		; INITIALIZATION COMPLETE
 ;
 ; ============ EQUATES FOR I/O PORTS ====================
 ;
 PORT1A	EQU	2000H
 PORT1B	EQU	2001H
 PORT1C	EQU	2002H
 CWORD1	EQU	2003H
 PORT2A	EQU	2004H
 PORT2B	EQU	2005H
 PORT2C	EQU	2006H
 CWORD2	EQU	2007H
 PORT3A	EQU	2008H
 PORT3B	EQU	2009H
 PORT3C	EQU	200AH
 CWORD3	EQU	200BH
 ;
 ; =============== EQUATES FOR WORKING STORAGE ===========
 ;
 NUMBER	EQU	1FA0H		; NUMBER STORAGE 2 BYTES
 SYMBOL	EQU	1FA2H		; SYMBOL STORAGE 2 BYTES
 DIGITV	EQU	1FA4H		; DISPLAY DIGIT 1 BYTE
 SEGMTV	EQU	1FA5H		; DISPLAY SEGMENT 6 BYTES
 SPEEDV	EQU	1FABH		; SPEED VALUE 2 BYTES
 SPEEDW	EQU	1FADH		; WORKING SPEED 2 BYTES
 SPEEDF	EQU	1FAFH		; SPEED=0 FLAG 1 BYTE
 TRIGGR	EQU	1FB0H		; TRIGGER STORAGE 1 BYTE
 DRUMIN	EQU	1FB1H		; DRUM INPUT 1 BYTE
 DRUMXR	EQU	1FB2H		; DRUM XOR VALUE 1 BYTE
 RPTPRT	EQU	1FB3H		; REPEAT POINTER 2 BYTES
 RPTMAX	EQU	1FB5H		; REPEATS WORKING 1 BYTE
 RPTABL	EQU	1FB6H		; REPEAT TABLE 16 BYTES
 FWDREV	EQU	1FC6H		; FWD/REV 1 BYTE (FWD=0)
 ERRCOD	EQU	1FC7H		; ERROR CODE 1 BYTE
 BCINDX	EQU	1FC8H		; CURR'T BEAT INX 2 BYTES
 SCINDX	EQU	1FCAH		; CURR'T SCOR INX 2 BYTES
 WORKNG	EQU	1FCCH		; GENERAL WORK 16 BYTES
 CLOCKN	EQU	1FDCH		; CLOCK ENABLE FLG 1 BYTE
 SPARE	EQU	1FDDH		; END GENERAL WORK AREA
 ;
 ; ================== FIXED POINTERS =====================
 ;
 BLINDX	EQU	1000H		; LOW BEAT STORAGE INDEX
 BHINDX	EQU	1BFFH		; HIGH INDEX (3071 BYTES)
 SLINDX	EQU	1C00H		; LOW SCORE STORAGE INDEX
 SHINDX	EQU	1F9FH		; HIGH INDEX (927 BYTES)
 ;
 ; ============= EQUATES FOR DISPLAY CONVERSION ==========
 ;
 UCA	EQU	77H		; UPPERCASE A
 UCC	EQU	4EH		; UPPERCASE C
 UCE	EQU	4FH		; UPPERCASE E
 UCF	EQU	47H		; UPPERCASE F
 UCG	EQU	5EH		; UPPERCASE G
 UCH	EQU	37H		; UPPERCASE H
 UCI	EQU	30H		; UPPERCASE I
 UCJ	EQU	3CH		; UPPERCASE J
 UCL	EQU	0EH		; UPPERCASE L
 UCO	EQU	7EH		; UPPERCASE O
 UCP	EQU	67H		; UPPERCASE P
 UCS	EQU	5DH		; UPPERCASE S
 UCU	EQU	3EH		; UPPERCASE U
 LCB	EQU	1FH		; LOWERCASE B
 LCC	EQU	0DH		; LOWERCASE C
 LCD	EQU	3DH		; LOWERCASE D
 LCH	EQU	17H		; LOWERCASE H
 LCI	EQU	10H		; LOWERCASE I
 LCL	EQU	0CH		; LOWERCASE L
 LCO	EQU	1DH		; LOWERCASE O
 LCR	EQU	05H		; LOWERCASE R
 LCU	EQU	1CH		; LOWERCASE U
 DASH	EQU	01H		; DASH
 QMARK	EQU	65H		; QUESTION MARK
 ;
 ; ============== DISPLAY CONVERSION TABLES ==============
 ;
 CNVTBL	DEFB	7EH		; 0 DISPLAY
 	DEFB	30H		; 1 DISPLAY
 	DEFB	6DH		; 2 DISPLAY
 	DEFB	79H		; 3 DISPLAY
 	DEFB	33H		; 4 DISPLAY
 	DEFB	5BH		; 5 DISPLAY
 	DEFB	5FH		; 6 DISPLAY
 	DEFB	70H		; 7 DISPLAY
 	DEFB	7FH		; 8 DISPLAY
 	DEFB	7BH		; 9 DISPLAY
 ;
 ; ========= POWER-UP BLOCK DATA MOVE ====================
 ;
 BLKMOV	DEFW	0000H		; NUMBER STORAGE
 	DEFW	0000H		; SYMBOL STORAGE
 	DEFB	01H		; DISPLAY DIGIT
 	DEFW	0000H		; DISPLAY SEGMENT 1,2
 	DEFW	7E7EH		; DISPLAY SEGMENT 3,4
 	DEFW	7E7EH		; DISPLAY SEGMENT 5,6
 	DEFW	0101H		; SPEED VALUE
 	DEFW	0101H		; WORKING SPEED
 	DEFB	01H		; SPEED FLAG
 	DEFB	00H		; TRIGGER STORAGE
 	DEFB	00H		; DRUM INPUT
 	DEFB	00H		; DRUM XOR VALUE
 	DEFW	1FB2H		; REPEAT POINTER
 	DEFB	00H		; REPEATS WORKING
 	DEFW	1000H		; REPEAT TABLE START 1
 	DEFW	1000H		; REPEAT TABLE END 1
 	DEFW	1000H		; REPEAT TABLE START 2
 	DEFW	1000H		; REPEAT TABLE END 2
 	DEFW	1000H		; REPEAT TABLE START 3
 	DEFW	1000H		; REPEAT TABLE END 3
 	DEFW	1000H		; REPEAT TABLE START 4
 	DEFW	1000H		; REPEAT TABLE END 4
 	DEFB	00H		; FWD/REV FLAG
 	DEFB	00H		; ERROR CODE
 	DEFW	1000H		; CURRENT BEAT INDEX
 	DEFW	1C00H		; CURRENT SCORE INDEX
 	DEFW	0000H		; GENERAL WORK AREA 1,2
 	DEFW	0000H		; GENERAL WORK AREA 3,4
 	DEFW	0000H		; GENERAL WORK AREA 5,6
 	DEFW	0000H		; GENERAL WORK AREA 7,8
 	DEFW	0000H		; GENERAL WORK AREA 9,10
 	DEFW	0000H		; GENERAL WORK AREA 11,12
 	DEFW	0000H		; GENERAL WORK AREA 13,14
 	DEFW	0000H		; GENERAL WORK AREA 15,16
 	DEFB	00H		; CLOCK ENABLE FLAG
 
 ;
 SCAN1	EQU	$
 ;	!!!!!!! PUT KEYBOARD SCAN HERE!!!!!!!
 	RET
 DRMSCN	EQU	$
 ;	!!!!!!! PUT SEPARATE DRUM SCAN HERE !!!!!
 	RET
 ; ========== CLOCK DISPLAY UPDATE ROUTINE ===============
 CLOCK	EQU	$
 ;	!!!!!!! PUT CLOCK UPDATE HERE!!!!!!!!!
 	RET
 STOP	EQU	$
 ;	!!!!!!! PUT STOP ACTION ROUTINE HERE !!!!!!!
 ERROR	EQU	$
 ;	!!!!!!! PUT ERROR ROUTINE HERE !!!!!!!!
 	JP	MASTER		; FALLS THROUGH TO MASTER
 MASTER	RST	08H		; CALL KEYBOARD SCAN
 	END	0000H
