REROUT ;REROUTE/ASM by Jack Decker
 
 ;For use with NEWDOS/80 version 2.  Will route printer
 ;output to a disk file.  Assemble program as REROUTE/CMD.
 
 ;When you wish to use this program, from DOS READY type
 ;"REROUTE" to initialize the program in high memory (it
 ;is self-relocating and self-protecting).  Then, when you
 ;wish to route printer output to disk, type:
 
 ;		*PD filespec
 
 ;Where "filespec" is any valid filename with optional
 ;extension and/or drive number.  All printer output that
 ;normally uses the ROM or DOS printer driver (that is,
 ;that does not originate from a program that contains its
 ;own printer driver) will thereafter be routed to the
 ;specified disk file.  When you are finished routing the
 ;printer output to disk, you MUST type:
 
 ;		*PR
 
 ;This will close the output file and from that point on
 ;all printer output will go to the printer as usual.  If
 ;you fail to issue this command, the output file will not
 ;be properly closed and will probably be unreadable.
 
 ;The *PD and *PR commands can be issued as required from
 ;DOS ready, MINIDOS, or by using BASIC's CMD function.
 ;Once you have opened an output file using *PD, you
 ;cannot open a second *PD output file until you have
 ;closed the first by using the *PR command.
 
 ;If you have questions or comments, please write to:
 
 ;		Jack Decker
 ;		1804 West 18th Street  Lot # 155
 ;		Sault Ste. Marie, Michigan  49783
 
 ;If you live in the United States or Canada and wish a
 ;reply, you MUST enclose a Self-Addressed Stamped
 ;Envelope (Canadian postage is O.K.).  NO REPLIES WILL BE
 ;SENT WITHOUT THE SASE!
 
 ;*****  INITIALIZATION & RELOCATION SEGMENT BEGINS  *****
 
 	ORG	7000H
 INTLZE	LD	HL,END		;End of unrelocated pgrm
 	LD	DE,(4049H)	;End of unprotected mem
 	LD	BC,END-OFFSET+1	;Length of main program
 	LDDR			;Move the program
 	PUSH	DE		;Save new memory size
 	INC	DE		;DE=Start relocated prgrm
 	LD	HL,TABLE	;Get start of reloc table
 NXTLOC	LD	A,(HL)		;Get first address byte
 	LD	B,A		;Save first byte in B
 	INC	HL		;Point @ 2nd address byte
 	OR	(HL)		;Do both bytes equal 0?
 	JR	NZ,REPLCE	;No - replace address
 	PUSH	DE		;Save entry address
 	EX	DE,HL		;Put *PR entry addr in HL
 	CALL	4461H		;NEWDOS/80 *NAME routine
 	JR	NZ,ERR		;Display error if any
 	POP	DE		;Restore entry address
 	LD	HL,PD-OFFSET	;Offset for PD routine
 	ADD	HL,DE		;HL = *PD entry address
 	CALL	4461H		;NEWDOS/80 *NAME routine
 	POP	HL		;Restore new memory size
 ERR	JP	NZ,4409H	;Display error if any
 	LD	(4049H),HL	;Save new memory size
 	JP	402DH		;Back to DOS
 REPLCE	PUSH	HL		;Save reloc table pointer
 	LD	H,(HL)		;H=MSB of addr from table
 	LD	L,B		;L=LSB of addr from table
 	ADD	HL,DE		;Get address of label
 	LD	C,(HL)		;Get byte displacement
 	INC	HL		;  from program and
 	LD	B,(HL)		;  put in BC
 	DEC	HL		;HL=address of label
 	PUSH	DE		;Save new START address
 	EX	DE,HL		;HL=new START address
 	ADD	HL,BC		;HL=new address for label
 	EX	DE,HL		;  now put in DE
 	LD	(HL),E		;New address calculated -
 	INC	HL		;  now write it into
 	LD	(HL),D		;  label (address field)
 	POP	DE		;Restore new START addr
 	POP	HL		;Restore reloc table pntr
 	INC	HL		;Bump pointer to nxt addr
 	JR	NXTLOC		;Process next table entry
 
 ;*****  RELOCATION TABLE  *****
 ;Must be located prior to "START" label of main program!
 
 TABLE	DEFW	RELO1+1-OFFSET
 	DEFW	RELO2+1-OFFSET
 	DEFW	RELO3+1-OFFSET
 	DEFW	RELO4+1-OFFSET
 	DEFW	RELO5+1-OFFSET
 	DEFW	RELO6+1-OFFSET
 	DEFW	RELO7+1-OFFSET
 	DEFW	RELO8+1-OFFSET
 	DEFW	RELO9+1-OFFSET
 	DEFW	RELO10+1-OFFSET
 	DEFW	OUTBYT+1-OFFSET
 	DEFW	0
 
 
 ;*****  MAIN PROGRAM (WILL BE RELOCATED) BEGINS  *****
 
 OFFSET	EQU	$		;Used by relocator
 
 ;*PR (Restore printer output to printer)
 	DEFW	0		;Four bytes required
 	DEFW	0		;  for use by DOS
 	DEFM	'PR      '	;8-byte routine name
 RELO1	LD	A,(FLAG-OFFSET)	;Check if file open
 	OR	A		;NZ if file is open
 	LD	A,26H		;"File Not Open" error
 	JR	Z,ERROR		;If file not open
 RELO2	LD	DE,FCB-OFFSET	;Put DE @ DCB
 	CALL	4428H		;Close file
 	JR	NZ,ERROR	;Display error if any
 RELO3	LD	HL,(PDVR-OFFSET);Get original DCB addr
 	JR	CONT		;Store DCB & flag
 
 ;*PD filespec (Route printer output to disk file)
 PD	DEFW	0		;Four bytes required
 	DEFW	0		;  for use by DOS
 	DEFM	'PD      '	;8-byte routine name
 	EX	DE,HL		;Save filename pointer
 RELO4	LD	HL,MSG-OFFSET	;Point to message
 RELO5	LD	A,(FLAG-OFFSET)	;Check if file open
 	OR	A		;NZ if file already open
 	JP	NZ,4467H	;Display message & return
 	EX	DE,HL		;Restore filename pointer
 RELO6	LD	DE,FCB-OFFSET	;Put DE @ DCB
 	CALL	441CH		;Extract filespec
 	JR	NZ,ERROR	;Display error if any
 RELO7	LD	HL,BUFFER-OFFSET;Point HL to buffer
 	LD	B,A		;LRL=256
 	CALL	4420H		;Open file
 	JR	NZ,ERROR	;Display error if any
 	DEC	A		;A = 0FFH
 	LD	HL,(4026H)	;Get current DCB value
 RELO8	LD	(PDVR-OFFSET),HL;Store it for close
 RELO9	LD	HL,OUTBYT-OFFSET;Get output routine addr
 CONT	LD	(4026H),HL	;Put in printer driver
 RELO10	LD	(FLAG-OFFSET),A	;Flag file is open
 	JP	402DH		;Back to DOS READY
 OUTBYT	LD	DE,FCB-OFFSET	;Point DE to DCB
 	LD	A,C		;Get byte to output
 	CALL	001BH		;Output byte to disk
 	RET	Z		;If no error
 ERROR	JP	4409H		;Display error if any
 MSG	DEFM	'*PD File already open'
 	DEFB	0DH
 FLAG	DEFB	0		;File opened/closed flag
 PDVR	DEFS	2		;Printer dvr addr storage
 FCB	DEFS	20H		;File control block
 BUFFER	DEFS	100H		;Output buffer
 
 END	EQU	$-1		;Used by relocator
 
 	END	INTLZE
