VOICER ; *******************************************************
 ; QUICK TEST PROGRAM FOR VOICE INPUT/OUTPUT USING THE MOD
 ; I CASSETTE PORT.  USABLE WITH LEVEL II OR DISK SYSTEMS.
 ; CHANGE LINES MARKED (*) FOR USE WITH DISK BASIC.
 ; *******************************************************
 ;
 	ORG	4300H		; LOW POINT IN MEMORY (*)
 MONITR	EQU	06CCH		; BASIC (CAN BE MONITOR)
 START	DI			; USE IT WITHOUT BOTHER
 	CALL	01C9H		; CLEAR THE SCREEN
 	LD	A,(403DH)	; START BY RESETTING PORT
 	OUT	(0FFH),A	; TO CLEAR INCOMING BITS
 ;
 ; *******************************************************
 ; KEYBOARD ROUTINE FOR ENTER (INPUT), CLEAR (OUTPUT), OR
 ; UP-ARROW (BASIC).  CAN USE UP-ARROW FOR EXIT TO MONITOR
 ; *******************************************************
 ;
 KEYTST	LD	A,(3840H)	; GET ENTER/CLEAR ROW
 	CP	1		; CHECK IF ENTER PRESSED
 	JR	Z,INPUT		; GO TO INPUT ROUTINE
 	CP	2		; CHECK IF CLEAR PRESSED
 	JR	Z,OUTPUT	; GO TO OUTPUT ROUTINE
 	CP	8		; CHECK IF IT'S UP-ARROW
 	JP	Z,MONITR	; OUT TO BASIC OR MONITOR
 	JR	KEYTST		; BACK FOR ONE OR T'OTHER
 ;
 ; *******************************************************
 ; INPUT FROM PORT FF (255 DECIMAL) AND STORAGE IN MEMORY
 ; *******************************************************
 ;
 INPUT	LD	HL,MSG01	; GET THE "INPUT" MESSAGE
 	CALL	28A7H		; AND DISPLAY ON SCREEN
 	LD	A,(403DH)	; GET VALUE FOR PORT MASK
 	LD	C,A		; SAVE MASK IN C REGISTER
 	LD	HL,4400H	; BEGIN VOICE STORAGE (*)
 LOOP1A	LD	D,8		; NUMBER OF BITS IN BYTE
 LOOP2	IN	A,(0FFH)	; GET VALUE AT THE PORT
 	RL	A		; STASH IT IN CARRY BIT
 	RL	E		; BUMP IT INTO E REGISTER
 	LD	A,C		; GET VALUE OF PORT MASK
 	LD	A,(3840H)	; CHECK ENTER/CLEAR ROW
 	CP	80H		; CHECK IF SPACE PRESSED
 	JP	NZ,ESCAPE	; OUT IF KEYBOARD CLEAR
 ;
 ; >>>> NOTE! DELAY VALUE BELOW IN THE B REGISTER    <<<<
 ; >>>> MAY BE INCREASED.  INTELLIGIBILITY WILL BE   <<<<
 ; >>>> LESSENED BUT MEMORY WILL BE CONSERVED.  FOR  <<<<
 ; >>>> EACH INCREASE IN THIS VALUE, ALSO INCREASE   <<<<
 ; >>>> THE VALUE BY THE SAME AMOUNT IN PLAYBACK.    <<<<
 ;
 	LD	B,4		; GET SHORT DELAY VALUE
 DELAY1	DJNZ	DELAY1		; AND DELAY A WHILE
 	OUT	(0FFH),A	; MUST RESET PORT INPUT
 	DEC	D		; DECREMENT TOTAL BITS
 	JP	NZ,LOOP2	; CONTINUE IF MORE TO DO
 	LD	(HL),E		; SAVE FULL BYTE IN MEM.
 	INC	HL		; GO ON TO NEXT BYTE
 	LD	A,H		; GET VALUE OF M.S. BYTE
 	CP	00H		; USE FOR 48K MACHINE
 ;	CP	0C0H		; USE FOR 32K MACHINE
 ;	CP	080H		; USE FOR 16K MACHINE
 	JP	NZ,LOOP1A	; IF NOT DONE THEN MORE
 	LD	HL,MSG02	; GET "INPUT COMPLETE"
 	CALL	28A7H		; AND DISPLAY THE MESSAGE
 	JR	KEYTST		; DONE - BACK TO KEY TEST
 ;
 ; *******************************************************
 ; PAUSE CHECK DURING ENTRY; SPACEBAR = GO, OTHERWISE STOP
 ; *******************************************************
 ;
 ESCAPE	PUSH	HL		; SAVE CURRENT POINTER
 	CALL	0FAFH		; DISPLAY CURRENT MEM.
 	LD	HL,MSG05	; GET "WORD START" MESS.
 	CALL	28A7H		; AND DISPLAY THE MESSAGE
 	POP	HL		; RESTORE MEMORY PTR.
 RECHEK	LD	A,(3840H)	; ENTER/CLEAR KEYBRD ROW
 	CP	80H		; CHECK IF SPACE AGAIN
 	JR	Z,LOOP1A	; BACK TO MAIN LOOP
 	CP	4		; CHECK IF BREAK KEY
 	JR	NZ,RECHEK	; KEEP LOOKING ENT OR BRK
 	LD	HL,MSG02	; GET "INPUT COMPLETE"
 	CALL	28A7H		; AND DISPLAY THE MESSAGE
 	JR	KEYTST		; AND BACK TO KEY MENU
 ;
 ; *******************************************************
 ; OUTPUT FROM MEMORY OF RECORDED VOICE TO CASSETTE PORT
 ; *******************************************************
 ;
 OUTPUT	LD	HL,MSG03	; GET "BEGIN OUTPUT"
 	CALL	28A7H		; AND DISPLAY THE MESSAGE
 	LD	A,(403DH)	; PORT FF OUTPUT MASK
 	LD	C,A		; SAVE OUTPUT MASK IN C
 	LD	HL,4400H	; START VOICE STORAGE (*)
 LOOP3A	LD	D,8		; NUMBER OF BITS IN BYTE
 	LD	A,(HL)		; GET VALUE FROM MEMORY
 	LD	E,A		; SAVE IT IN E REGISTER
 	XOR	A		; CLEAR ACCUMULATOR TO 0
 LOOP4	RL	E		; SEND BIT TO CARRY FLAG
 	RL	A		; AND ROTATE 'ROUND TO A
 	OR	C		; USE THE PORT FF MASK
 	OUT	(0FFH),A	; AND SEND OUT THE VALUE
 ;
 ; >>>> NOTE! BELOW IS THE PLAYBACK VALUE WHICH MUST <<<<
 ; >>>> BE CHANGED IF SAMPLING DELAY IN THE INPUT    <<<<
 ; >>>> AREA IS ALTERED.  THIS VALUE IS ALWAYS TWO   <<<<
 ; >>>> GREATER THAN THAT IN THE INPUT SAMPLING AREA <<<<
 ;
 	LD	B,6		; GET SHORT DELAY VALUE
 DELAY	DJNZ	DELAY		; AND DELAY SHORT WHILE
 	XOR	A		; CLEAR ACCUM. BACK TO 0
 	DEC	D		; BITS = BITS MINUS ONE
 	JP	NZ,LOOP4	; AND BACK FOR SOME MORE
 	INC	HL		; GET NEXT BYTE FROM MEM.
 	LD	A,H		; GET VALUE OF M.S. BYTE
 	CP	00H		; FOR 48K MACHINE
 ;	CP	0C0H		; FOR 32K MACHINE
 ;	CP	080H		; FOR 16K MACHINE
 	JP	NZ,LOOP3A	; AND GO BACK FOR MORE
 	LD	HL,MSG04	; GET "OUTPUT COMPLETE"
 	CALL	28A7H		; AND DISPLAY THE MESSAGE
 	JP	KEYTST		; AND BACK WHEN DONE
 ;
 MSG01	DEFM	'BEGIN SPEAKING.'
 	DEFB	0DH
 	DEFB	00H
 MSG02	DEFM	'INPUT COMPLETE.'
 	DEFB	0DH
 	DEFB	00H
 MSG03	DEFM	'BEGIN PLAYBACK.'
 	DEFB	0DH
 	DEFB	00H
 MSG04	DEFM	'PLAYBACK COMPLETE.'
 	DEFB	0DH
 	DEFB	00H
 MSG05	DEFM	' = WORD START POINT.'
 	DEFB	0DH
 	DEFB	00H
 ;
 ; *******************************************************
 	END	START
