QUIKLI ; #######################################################
 ;           SOURCE PROGRAM FOR QUICK LIFE
 ;           (C) 1981 DENNIS BATHORY KITSZ
 ;              ROXBURY, VERMONT  05669
 ; #######################################################
 ;
 	ORG	4016H		;KEYBOARD INTERCEPT
 	DEFB	0F0H		;LOW BYTE OF LIFE START
 	DEFB	04FH		;HIGH BYTE OF LIFE START
 	ORG	4FF0H		;LIFE PROGRAM STARTS HERE
 	LD	HL,4016H	;KEYBOARD INTERCEPT
 	LD	(HL),0E3H	;RESTORE ORIGINAL VALUE
 	INC	HL		;GET INTERCEPT HIGH BYTE
 	LD	(HL),03H	;RESTORE ORIGINAL VALUE
 ;
 ; #######################################################
 ; CLEAR SCREEN AND PREPARE LIFE BUFFER WITH -1'S
 ; #######################################################
 ;
 	CALL	01C9H		;ROM CLEAR SCREEN ROUTINE
 	LD	HL,7000H	;BEGINNING OF LIFE BUFFER
 	LD	DE,7001H	;TRANSFER DESTINATION 
 	LD	BC,3FFH		;NUMBER OF BYTES TO CLEAR
 	LD	(HL),0FFH	;CLEAR AREA WITH ALL -1'S
 	LDIR			;BLOCK MOVE TO CLEAR
 ;
 ; #######################################################
 ; BEGIN INCREMENTING NEIGHBORS OF LIVE CELLS
 ; #######################################################
 ;
 ONE	LD	HL,3C00H	;GET START OF SCREEN 
 	LD	IX,7000H	;GET START OF LIFE BUFFER
 	LD	BC,400H		;GET TOTAL BUFFER LOC'NS
 TWO	LD	A,(HL)		;GET VALUE AT SCREEN
 	CP	20H		;IS IT A SPACE?
 	JR	Z,THREE		;IF A SPACE, MOVE ONWARD
 	INC	(IX-41H)	;NO SPACE - INC. NEIGHBOR
 	INC	(IX-40H)	;NO SPACE - INC. NEIGHBOR
 	INC	(IX-3FH)	;NO SPACE - INC. NEIGHBOR
 	INC	(IX-1)		;NO SPACE - INC. NEIGHBOR
 	INC	(IX+1)		;NO SPACE - INC. NEIGHBOR
 	INC	(IX+3FH)	;NO SPACE - INC. NEIGHBOR
 	INC	(IX+40H)	;NO SPACE - INC. NEIGHBOR
 	INC	(IX+41H)	;NO SPACE - INC. NEIGHBOR
 THREE	INC	HL		;GET NEXT SCREEN POS'N
 	INC	IX		;GET NEXT LIFE BUFFER POS
 	DEC	C		;DEC. BC REG. (FAST WAY)
 	JR	NZ,TWO		;LOOP IF NOT DONE YET
 	DEC	B		;DEC. BC REG. (FAST WAY)
 	JR	NZ,TWO		;LOOP IF NOT DONE YET
 ;
 ; #######################################################
 ; BEGIN EVALUATING WHETHER NEIGHBORS ARE IN CONWAY'S RULE
 ; #######################################################
 ;
 	LD	HL,3C00H	;GET FIRST SCREEN POS'N
 	LD	IX,7000H	;GET LIFE BUFFER START
 	LD	B,4		;BC=400 (C IS ALREADY 0)
 FOUR	LD	A,(IX)		;GET VALUE IN LIFE BUFFER
 	DEC	A		;DECREMENT FOR TESTING
 	JR	Z,SIX		;IF 0 THEN NEIGHBORS=2
 	DEC	A		;DECREMENT FOR TESTING
 	JR	NZ,FIVE		;IF NOT 0 NEIGHBOR >= 3
 	LD	(HL),40H	;PUT LIVE CELL IN PLACE
 	JR	SIX		;GO OUT TO NEXT CHARACTER
 FIVE	LD	(HL),20H	;PUT DEAD CELL IN PLACE
 SIX	LD	(IX),0FFH	;PUT -1 INTO LIFE BUFFER
 	INC	HL		;GET NEXT SCREEN POS'N
 	INC	IX		;GET NEXT LIFE BUFFER POS
 	DEC	C		;DEC BC (FAST WAY)
 	JR	NZ,FOUR		;REPEAT 400H TIMES TOTAL
 	DEC	B		;DEC BC (FAST WAY)
 	JR	NZ,FOUR		;REPEAT FOR FULL SCREEN
 ;
 ; #######################################################
 ; CHECK FOR THE HUMAN WHO MAY BE PRESSING THE KEYS
 ; #######################################################
 ;
 	LD	A,(3810H)	;GET 0-7 KEYBOARD ROW
 	AND	A		;CHECK IF KEY PRESSED
 	JR	Z,ONE		;NEXT GEN. IF NO KEY
 ;
 ; #######################################################
 ; BEGIN SOMEWHAT RANDOM CHARACTER GENERATION FROM 0 - 7
 ; #######################################################
 ;
 	LD	D,A		;D = KEY VALUE IN A
 	LD	A,R		;GET CURRENT REFRESH VAL.
 	LD	E,A		;SAVE R IN E REGISTER
 	PUSH	BC		;SAVE LIFE LOOP VALUE
 	LD	B,A		;SAVE R IN B REGISTER
 	DJNZ	$-1		;DELAY LOOP R TIMES
 	POP	BC		;RESTORE LIFE LOOP VALUE
 	LD	A,R		;GET ANOTHER R VALUE
 	ADD	A,E		;A = R PLUS E
 	ADD	A,D		;A = R PLUS E PLUS D
 	LD	E,A		;E = R PLUS E PLUS D
 	LD	A,D		;A = D (ORIGINAL KEY VAL)
 	LD	D,3CH		;D = 3C (SCREEN HI BYTE)
 	PUSH	BC		;SAVE LIFE LOOP VALUE
 	LD	C,A		;C = D (ORIGINAL KEY VAL)
 	LD	B,A		;B = D (ORIGINAL KEY VAL)
 SEVEN	LD	A,R		;A = R (PART OF RANDOM)
 	AND	02		;TEST FOR SET BIT
 	JR	NZ,EIGHT	;IF NO BIT SET
 	LD	A,40H		;CREATE CHARACTER IF BIT
 	LD	(DE),A		;PUT CHAR. IN 3C+R+C+D
 	INC	DE		;INCREMENT SCREEN POS'N
 EIGHT	DJNZ	SEVEN		;DO THIS D + D TIMES
 	POP	BC		;RESTORE LIFE LOOP VALUE
 	JR	ONE		;BACK FOR NEXT GENERATION
 ;
 ; #######################################################
 	END	4FF0H		;BEGIN AT LIFE ENTRY
