QUAVER ; QUAVER, A MONOPHONIC MUSIC COMPILER FOR THE TRS-80
 ; (C) 1981 DENNIS BATHORY KITSZ, ROXBURY, VERMONT 05669
 ;
 	ORG	7000H
 ;
 A00000	EQU	$
 ;
 ; KEYWORD TABLE CONTAINS COMMAND ENTRIES FOLLOWING PERIOD
 TABLE1	DEFM	'ACALANCLCOFL'	; KEYWORD TABLE START
 	DEFM	'FOLALELTMFMO'	; KEYWORD TABLE CONT'D
 	DEFM	'MPOBPIPRRART'	; KEYWORD TABLE CONT'D
 	DEFM	'SESOSTTRVI'	; KEYWORD TABLE CONCLUDED
 	DEFB	00		; END OF KEYWORD MARKER
 ;
 ; CALL ADDRESS TABLE FOR ENTRY INTO COMPILER OBJECT CODE
 	DEFW	ACEXEC
 	DEFW	ALEXEC
 	DEFW	ANEXEC
 	DEFW	CLEXEC
 	DEFW	COEXEC
 	DEFW	FLEXEC
 	DEFW	FOEXEC
 	DEFW	LAEXEC
 	DEFW	LEEXEC
 	DEFW	LTEXEC
 	DEFW	MFEXEC
 	DEFW	MOEXEC
 	DEFW	MPEXEC
 	DEFW	OBEXEC
 	DEFW	PIEXEC
 	DEFW	PREXEC
 	DEFW	RAEXEC
 	DEFW	RTEXEC
 	DEFW	SEEXEC
 	DEFW	SOEXEC
 	DEFW	STEXEC
 	DEFW	TREXEC
 	DEFW	VIEXEC
 ;
 ;
 ;
 ;
 ; COMPILER IDENTIFIER ENTERED FROM BASIC COMMAND LEVEL
 TABLE2	DEFM	'COMPILE'
 ;
 ;
 ;
 ;
 ;
 ;
 ;
 ;
 ;
 ;
 ;
 ;
 ; ERROR MESSAGES TO BE PRINTED ON SCREEN DURING COMP'N
 MESG01	DEFM	'QUAVER SYNTAX ERROR IN '
 	DEFB	00
 MESG02	DEFM	'RHYTHM VALUE ERROR IN '
 	DEFB	00
 MESG03	DEFM	'INVALID NOTE OR NOTE OUT OF RANGE IN '
 	DEFB	00
 MESG04	DEFM	'REPEAT NOT COMPLETED; '
 	DEFM	'COMPILE TO END (Y/N)? '
 	DEFB	00
 MESG05	DEFM	'REFRAIN NOT COMPLETE; '
 	DEFM	'COMPILE TO END (Y/N)? '
 	DEFB	00
 MESG06	DEFM	'REFRAIN LABEL NOT FOUND IN '
 	DEFB	00
 MESG07	DEFM	'INVALID OR MISSPELLED KEYWORD IN '
 	DEFB	00
 MESG08	DEFM	'VERSO WITHOUT REFRAIN IN '
 	DEFB	00
 MESG09	DEFM	'OUT OF MEMORY IN '
 	DEFB	00
 MESG10	DEFM	'LOGICAL ERROR IN '
 	DEFB	00
 MESG11	DEFM	'NO DOUBLE BAR '
 	DEFB	00
 ;
 ;
 ;
 ; STORAGE AREAS FOR USE DURING COMPILATION PROCESS
 STORE0	DEFB	00H		; RESERVED !!
 STORE1	DEFW	42EBH		; CURRENT LINE NUMBER
 STORE2	DEFB	00H		; DOUBLE BAR FOUND = 1
 STORE3	DEFB	00H		; COMPILED ERROR FREE = 1
 STORE4	DEFB	43H		; LAST NOTE SOUNDED (C)
 STORE5	DEFB	00H		; RESERVED !!
 STORE6	DEFB	33H		; LAST OCTAVE USED (3)
 STORE7	DEFB	34H		; LAST RHYTHM USED (4)
 STORE8	DEFW	6000H		; LEAVES 4K -- 8000H OKAY
 STORE9	DEFB	00H		; EXT. 0=NONE,1=+,2=++
 STOREA	DEFB	00H		; TRILL 0 = NO, 1 = YES
 STOREB	DEFW	0000H		; RHYTHM LENGTH DELAYWORD
 STOREC	DEFW	0000H		; TOP OF WAVERFORM WORD
 STORED	DEFW	0000H		; BOTTOM OF WAVEFORM WORD
 STOREE	DEFW	0000H		; LOCATION OF REFRAIN
 STOREF	DEFW	0000H		; LOCATION OF REPEAT STRT
 ;
 ;
 ;
 ;
 ;
 ;
 ;
 ;
 ;
 ;
 ;
 ; PATCH INTO INTERPRETER ROUTINE HERE
 ENTRY	LD	HL,START	; GET QUAVER START POINT
 	LD	(4004H),HL	; INTERPRETER PATCH PT.
 	JP	06CCH		; BACK TO BASIC READY
 ;
 ; BASIC COMMAND LEVEL SYNTAX CHECK TAKES PLACE HERE
 START	EX	(SP),HL		; FIND TOP OF STACK
 	LD	A,L		; CHECK LSB FIRST
 	CP	5BH		; IS STACK LSB AT 5B?
 	JR	NZ,NOTRDY	; GO OUT IF NOT READY
 	LD	A,H		; CHECK MSB SECOND
 	CP	1DH		; IS STACK MSB AT 1D?
 NOTRDY	EX	(SP),HL		; SWITCH IT ALL BACK
 	JP	NZ,1D78H	; BACK TO BASIC IF NOT
 ;
 ; BASIC COMMAND LEVEL "COMPILE" COMMAND CHECK DONE HERE
 	LD	IX,TABLE2	; BEGINNING OF WORD CHECK
 	LD	B,7		; TOTAL CHARACTERS
 	INC	HL		; MOVE TO NEXT CHARACTER
 CHECK1	LD	A,(HL)		; LETTER INTO A FOR TEST
 	CP	(IX)		; CHECK AGAINST WORDS
 SYNERR	DEC	HL		; BACK UP IF NO MATCH
 	JP	NZ,1D78H	; AND GO BACK TO INTER.
 	INC	HL		; ELSE MOVE BACK UP AGAIN
 	INC	HL		; AND UP ONE MORE TIME
 	INC	IX		; AND MOVE WORD TABLE UP
 	DJNZ	CHECK1		; AND DO IT FOR "COMPILE"
 ;
 ; MAIN BRANCHING ROUTINE BEGINS HERE (COMPILER COMMANDS)
 CMPILE	LD	HL,6000H	; OBJECT CODE STORAGE
 	LD	(STORE8),HL	; START OF OBJECT CODE
 	LD	HL,STORE2	; GET DOUBLE BAR AREA
 	LD	(HL),0		; STORE DBLBAR NOT FOUND
 	LD	HL,(40F9H)	; BEGINNING OF LISTING
 	LD	DE,(40A4H)	; START OF COMPILED CODE
 	XOR	A		; CLEAR CARRY FLAG
 	SBC	HL,DE		; GET LISTING LENGTH
 	PUSH	HL		; STORE TOTAL LENGTH
 	POP	BC		; AND PUT INTO COUNTER
 	LD	HL,(40A4H)	; BEGINNING OF LISTING
 	LD	DE,(40F9H)	; START OF COMPILED CODE
 LOOP6	LD	A,(HL)		; GET FIRST VALUE
 	CP	3EH		; IS IT A > SIGN?
 	JR	Z,NXTGRT	; CHECK FOR NEXT DBL BAR
 	INC	HL		; GET NEXT LISTING LOC'N
 	DEC	BC		; DROP COUNTER BY ONE
 	LD	A,B		; GET VALUE OF B
 	OR	C		; GET VALUE OF C
 	JP	Z,ERRDBL	; GO TO NO DBL BAR ERROR
 	JR	LOOP6		; LOOP THROUGH WHOLE LIST
 NXTGRT	INC	HL		; GET NEXT LISTING LOC'N
 	LD	A,(HL)		; GET VALUE AT LOCATION
 	CP	3EH		; IS IT A SECOND > SIGN?
 	JR	Z,BEGIN1	; START COMPILING IF OKAY
 	INC	HL		; GET NEXT LIST LOC'N
 	JR	LOOP6		; LOOP BACK IF NOT DBLBAR
 ;
 BEGIN1	LD	HL,STORE2	; GET DBLBAR FOUND AREA
 	LD	(HL),1		; STORE FOUND CODE = 1
 	LD	HL,(40A4H)	; GET BEGINNING OF PROG.
 NULINE	INC	HL		; MOVE PAST ADDRESS BYTE
 	INC	HL		; MOVE PAST ADDRESS BYTE
 	LD	(STORE1),HL	; STORE CURRENT LINE NO.
 NXTCH0	INC	HL		; MOVE PAST LINE NUMBER
 NXTCHR	INC	HL		; MOVE PAST LINE NUMBER
 NXTCH1	LD	A,(HL)		; GET VALUE AT LINE START
 	AND	A		; TEST IF IT IS A ZERO
 	JR	NZ,JUMP7	; GO TO NEXT LINE IF SO
 	INC	HL		; BUMP POINTER PAST ZERO
 	JR	NULINE		; AND RESTART LINE EVAL.
 JUMP7	CP	22H		; IS IT A POINT OR LESS?
 	JR	C,NXTCHR	; LOOP BACK FOR ANOTHER
 	CP	93H		; IS IT A REM STATEMENT?
 	JR	Z,NXTCHR	; LOOP BACK FOR ANOTHER
 	CP	2AH		; IS IT A STAR (*)?
 	JR	NZ,JUMP1	; CONTINUE TESTING IF NOT
 FIND00	INC	HL		; GET NEXT LOCATION
 	LD	A,(HL)		; CHECK THE LOCATION
 	AND	A		; TEST FOR A ZERO BYTE
 	JR	NZ,FIND00	; LOOP TILL NEW LINE
 	INC	HL		; MOVE UP TO NEW LINE
 	JR	NULINE		; GO BACK FOR NEXT CHAR
 JUMP1	CP	2EH		; IS IT A PERIOD (.)?
 	JR	Z,COMMND	; GO TO COMMAND PROCESSOR
 	CP	28H		; IS IT LEFT PAREN (()?
 	JP	Z,NOTES		; GO TO	NOTE PROCESSOR
 	CP	23H		; IS IT A SEGNO (#)?
 	JP	Z,REFSUB	; GO TO REFRAIN LABELER
 	CP	24H		; IS IT A SEGNO ($)?
 	JP	Z,REFPRO	; GO TO REFRAIN PROCESSOR
 	CP	3CH		; IS IT A REPEAT (<:)?
 	JP	Z,REPEAT	; GO TO REPEAT PROCESSOR
 	CP	3AH		; IS IT END REPEAT (:>)?
 	JP	Z,ENDREP	; GO TO END REPEAT PROC.
 	CP	3EH		; IS IT DOUBLE BAR (>>)?
 	JP	Z,DBLBAR	; GO TO DOUBLE BAR PROC.
 	JP	ERRKEY		; SYNTAX ERROR IF NONE
 ;
 ; COMMAND TABLE BRANCHING BEGINS HERE FOR TWO-LETTER ID'S
 COMMND	LD	IX,TABLE1	; POINT TO TABLE START
 	INC	HL		; GET NEXT CHAR IN LINE
 CMDTST	LD	A,(HL)		; GET CHARACTER FOR TEST
 	AND	A		; TEST IF END OF TABLE
 	JP	Z,ERRKEY	; KEYWORD ERROR MESSAGE
 	CP	(IX)		; CHECK AGAINST REGISTER
 	JR	NZ,NXTTST	; GO ON TO NEXT COMMAND
 	INC	HL		; GET NEXT CHARACTER
 	LD	A,(HL)		; GET CHARACTER FOR TEST
 	CP	(IX+1)		; CHECK AGAINST TABLE
 	JR	NZ,NXTCMD	; GO ON TO NEXT COMMAND
 	LD	A,0CDH		; GET CALL VALUE READY
 	LD	(DE),A		; PUT CALL ADDRESS IN
 	INC	DE		; ADVANCE PTR STORAGE
 	LD	A,(IX+2FH)	; GET VALUE AT CALL TABLE
 	LD	(DE),A		; AND PLACE IN COMP CODE
 	INC	DE		; GET NEXT COMP CODE ADDR
 	LD	A,(IX+30H)	; GET VALUE AT CALL TABLE
 	LD	(DE),A		; AND PLACE IN COMP CODE
 	INC	DE		; GET NEXT COMP CODE ADDR
 LOOP4	INC	HL		; GET NEXT CHAR IN LINE
 	LD	A,(HL)		; GET VALUE IN LINE
 	CP	41H		; COMPARE AGAINST ALPHA A
 	JR	C,NXTCH1	; GET NEXT CHAR IF < A
 	CP	5BH		; COMPARE AGAINST ALPHA Z
 	JR	NC,NXTCH1	; GET NEXT CHAR IF > Z
 	JR	LOOP4		; SKIP PAST ALPHA CHARS.
 NXTCMD	DEC	HL		; MOVE POINTER ONE BACK
 NXTTST	INC	IX		; MOVE TABLE AHEAD
 	INC	IX		; MOVE TABLE AHEAD
 	LD	A,(IX)		; GET TABLE VALUE
 	AND	A		; TEST IF IT IS ZERO
 	JP	Z,ERRKEY	; END OF TABLE - ERROR
 	JR	CMDTST		; GO BACK THROUGH TABLE
 ;
 ; THIS SECTION INSERTS A LD HL,STORE8 AS A POINTER
 ; THEN POINTS BC REGISTER TO (STORE8) FOR BLOCK FILL
 NOTES	LD	A,21H		; GET "LD HL" OPCODE 
 	LD	(DE),A		; PUT INTO PLACE
 	INC	DE		; GET NEXT VALUE READY
 	LD	A,(STORE8)	; GET LSB OF MUSIC BLOCK
 	LD	(DE),A		; PUT IN PLACE AS OPERAND
 	INC	DE		; GET NEXT VALUE READY
 	LD	A,(STORE8+1)	; GET MSB OF MUSIC BLOCK
 	LD	(DE),A		; PUT IN PLACE AS OPERAND
 	INC	DE		; GET NEXT COMP LOC'N
 	LD	A,0CDH		; GET "CALL" OPCODE
 	LD	(DE),A		; PUT IN PLACE IN COMP
 	INC	DE		; GET NEXT COMP LOC'N
 	LD	BC,PLAYER	; GET MUSIC BLOCK LOC'N
 	LD	A,C		; GET LOCATION'S LSB
 	LD	(DE),A		; PUT IN PLACE IN COMP
 	INC	DE		; GET NEXT COMP LOC'N
 	LD	A,B		; GET LOCATION'S MSB
 	LD	(DE),A		; PUT IN PLACE IN COMP
 	INC	DE		; GET NEXT COMP LOC'N
 	LD	IX,(STORE8)	; GET CURRENT MUSIC BLOCK
 ;
 ; THIS SECTION STRIPS OUT THE SPACES, THEN CHECKS FOR A
 ; REST, A TRILL, A RIGHT PAREN, OR A SLASH.
 NOTE0	CALL	STRIP		; STRIP CONTROL CODES
 	CP	2FH		; IS IT A SLASH?
 	JP	NZ,SKIPW	; NOT A SLASH; MOVE ON
 	DEC	IX		; MOVE BACK BECAUSE ...
 	DEC	IX		; ... THE PREVIOUS ...
 	DEC	IX		; ... BYTES MUST BE ...
 	DEC	IX		; ... MOVED UP IN PLACE.
 	JP	NOTE8A		; AND GO EXECUTE SLASH
 SKIPW	CP	29H		; IS IT A RIGHT PAREN?
 	JP	Z,EXIT		; EXIT NOTES IF PAREN
 	CP	54H		; IS IT A TRILL (T)?
 	JR	NZ,SKIPY	; GO PAST IF NOT T
 	LD	A,1		; TRILL INDICATOR BYTE
 	LD	(STOREA),A	; PLACE INTO CODE
 	JR	NOTE1		; GO ON TO EVALUATE
 SKIPY	PUSH	AF		; SAVE COMPARED VALUE
 	XOR	A		; CLEAR A TO ZERO
 	LD	(STOREA),A	; SAVE 0 IN TRILL BYTE
 	POP	AF		; GET BACK ORIG VALUE
 	CP	52H		; IS IT A REST (R)?
 	JR	NZ,NOTE1A	; IF NOT THEN GO OUT
 	XOR	A		; ELSE PUT IN A ZERO
 	LD	(IX),A		; HERE'S REST INDICATOR
 	LD	(IX+1),A	; PUT ACCIDENTAL REST IND
 	LD	(IX+2),A	; PUT OCTAVE REST IND.
 	JR	NOTE4		; OUT TO RHYTHM INDIC.
 ;
 ; THIS SECTION FIRST STRIPS OUT THE SPACES, THEN CHECKS
 ; FOR A NOTE.  A PITCH IS REQUIRED TO START ANY ENTRY.
 NOTE1A	DEC	HL		; BACK UP FOR CHARACTER
 NOTE1	CALL	STRIP		; STRIP CONTROL CODES
 	CP	41H		; CHECK AGAINST ALPHA A
 	JP	C,ERRLOG	; LOGICAL ERROR IF < A
 	CP	48H		; CHECK AGAINST ALPHA H
 	JP	NC,ERRLOG	; LOGICAL ERROR IF > G
 	LD	(STORE4),A	; SAVE THE NOTE IN STORE
 	LD	(IX),A		; PUT PITCH IN PLACE
 ;
 ; THIS SECTION STRIPS OFF CONTROL CODES, THEN CHECKS FOR
 ; THE PRESENCE OF +, - OR =.  = IS THE DEFAULT INSERTED.
 	CALL	STRIP		; STRIP CONTROL CODES
 	CP	2BH		; IS IT A PLUS SIGN (+)
 	JR	NZ,JUMP10	; SKIP PAST IF NOT
 	LD	(IX+1),A	; LOAD IF IT IS
 	JR	NOTE3		; AND GET OUT NOW
 JUMP10	CP	2DH		; IS IT A MINUS SIGN (-)
 	JR	NZ,JUMP11	; SKIP PAST IF NOT
 	LD	(IX+1),A	; LOAD IF IT IS
 	JR	NOTE3		; AND GET OUT NOW
 JUMP11	CP	3DH		; IS IT AN EQUAL SIGN (=)
 	JR	NZ,JUMP12	; SKIP PAST IF NOT
 	LD	(IX+1),A	; LOAD IF IT IS
 	JR	NOTE3		; JUMP TO OCTAVE TEST
 JUMP12	LD	A,3DH		; GET NATURAL SIGN
 	LD	(IX+1),A	; PLACE VALUE IN MEM
 	DEC	HL		; BUMP POINTER BACK ONE
 ;
 ; THIS SECTION STRIPS OFF CONTROL CODES, AND SEARCHES FOR
 ; THE OCTAVE WHICH IS TO BE PLAYED (1-4 OR C IN OCTAVE 5)
 NOTE3	CALL	STRIP		; STRIP CONTROL CODES
 	CP	31H		; MUST BE 1 OR GREATER
 	JR	C,JUMP13	; NOT A NUMBER; TEST /
 	CP	3AH		; MUST BE 5 OR LESS
 	JR	NC,JUMP13	; NOT A NUMBER; TEST @
 	CP	36H		; MUST BE 5 OR LESS
 	JP	NC,ERRLOG	; LOGIC ERROR IF >5
 	CP	35H		; TEST IF JUST 5
 	JR	NZ,JMP12A	; GO PAST IF < 5
 	PUSH	AF		; SAVE VALUE IN A
 	LD	A,(STORE4)	; CHECK LAST NOTE SOUNDED
 	CP	43H		; SEE IF IT IS A C
 	JP	NZ,ERRNOT	; OUT OF RANGE ERROR
 	POP	AF		; RESTORE VALUE IN A
 JMP12A	INC	HL		; MOVE LINE POINTER UP
 	JR	JUMP14		; AND MOVE TO STORE IT
 JUMP13	LD	A,(STORE6)	; GET PREVIOUS VALUE
 JUMP14	LD	(IX+2),A	; PUT VALUE IN MUSIC
 	LD	(STORE6),A	; PUT OCTAVE IN STORAGE
 	DEC	HL		; BUMP POINTER BACK
 ;
 ; THIS SECTION STRIPS OFF CONTROL CODES, THEN CHECKS FOR
 ; PRESENCE OF @ SIGN TO DETERMINE THE RHYTHM TO PLAY
 NOTE4	CALL	STRIP		; STRIP CONTROL CODES
 	CP	40H		; IS IT THE @ SIGN?
 	JR	NZ,OUT4		; GO OUT IF NOT (NOTE 4)
 REDO	CALL	STRIP		; STRIP CONTROL CODES
 	CP	31H		; MUST BE 1 OR GREATER
 ERSYN2	JP	C,ERRSYN	; GOTTA BE A NUMBER
 	CP	3AH		; MUST BE 9 OR LESS
 	JP	NC,ERRSYN	; NOT A NUMBER; TEST @
 	CP	37H		; TEST AGAINST ASCII 7
 	JP	NC,ERRRHY	; LOGICAL ERROR IF 5
 	LD	(STORE7),A	; STORE IN RHYTHM AREA
 ;
 ; THIS SECTION STRIPS OFF CONTROL CODES, AND SEARCHES FOR
 ; THE RHYTHM EXTENSION SYMBOL + OR ++.
 	XOR	A		; GET A ZERO READY
 	LD	(STORE9),A	; PUT INTO RHYTHM EXTEN
 	CALL	STRIP		; STRIP CONTROL CODES
 	CP	2BH		; CHECK IF A PLUS SIGN
 	JR	NZ,SKIPX	; PREPARE RHYTHM IF NOT
 	LD	A,1		; INDICATE FIRST PLUS
 	LD	(STORE9),A	; PUT INTO RHYTHM STORE
 	CALL	STRIP		; STRIP CONTROL CODES
 	CP	2BH		; IS IT A PLUS SIGN?
 	JR	NZ,SKIPX	; GO OUT IF NOT +
 	LD	A,2		; GET 2 + SIGN VALUE
 	LD	(STORE9),A	; PUT INTO WORK AREA
 	CALL	STRIP		; STRIP OFF CONTROL CODES
 SKIPX	PUSH	AF		; SAVE CURRENT CHARACTER
 	LD	A,(STORE9)	; GET THE VALUE BACK
 	LD	B,A		; GET THE + OR ++ VALUE
 	LD	A,(STORE7)	; GET THE ORIGINAL RHYTHM
 	SUB	30H		; STRIP OFF ASCII VALUE
 	LD	C,A		; PUT INTO C REG
 	LD	A,1		; PUT SINGLE BIT INTO A
 LOOPX	DEC	C		; C = C-1
 	JR	Z,PAST		; GOT RHYTHM FIRST TRY
 	RL	A		; DOUBLE ACCUMULATOR
 	JR	LOOPX		; AND DO IT AGAIN 
 ;
 ; THE ABOVE GETS A BINARY VALUE OF MULTIPLES IN A 
 ; WHICH CAN BE COMBINED WITH WHATEVER IS IN THE + OR ++
 ; EXTENSIONS FOR A COMPLETE RHYTHM
 PAST	INC	B		; B = B+1 TO GET PAST 0
 	LD	C,A		; SAVE THE ORIGINAL VALUE
 	DEC	B		; GOING TO DO DIVISION 
 	JR	Z,PAST2		; RHYTHM EXTENSION TEST
 	RRCA			; BOUNCE ACCUM BACK (/2)
 	PUSH	AF		; SAVE THE VALUE
 	ADD	A,C		; GET NEW TOTAL VALUE 1.5
 	LD	C,A		; AND SAVE IT AGAIN
 	POP	AF		; GET ORIGINAL VALUE BACK
 	DEC	B		; GOING TO DO DIVISION
 	JR	Z,PAST2		; RHYTHM EXTENSION TEST
 	RRCA			; BOUNCE ACCUM AGAIN (/4)
 	ADD	A,C		; GET NEW TOTAL 1.75
 PAST2	LD	(IX+3),A	; AND PUT TIMING VALUE IN
 ;
 ; THIS SECTION STRIPS OFF CONTROL CODES AND CHECKS FOR
 ; AN AMPERSAND
 	POP	AF		; RESTORE CHARACTER VALUE
 	CP	26H		; IS IT AN AMPERSAND?
 	JR	Z,REDO		; IF IT IS, MORE RHYTHM
 	JR	NOTE8		; OTHERWISE GO ON OUT
 OUT4	LD	A,(STORE7)	; GET PREV. RHYTHM VALUE
 	LD	(IX+3),A	; PUT IT IN MUSIC BLOCK
 	LD	A,(HL)		; GET CHARACTER IN LINE
 ;
 ; THIS SECTION CHECKS FOR A REPEATED CHARACTER AND ACTS
 ; ON IT BY REPEATING THE FOUR BYTES OF INFORMATION
 NOTE8	CP	2FH		; IS IT A SLASH?
 	JR	NZ,OUT6		; GO AWAY IF NOT REPEAT
 NOTE8A	PUSH	HL		; SAVE THIS VALUE
 	PUSH	DE		; SAVE THIS VALUE
 	PUSH	IX		; GET READY TO TRANSFER
 	PUSH	IX		; GET READY TO TRANSFER
 	POP	DE		; XFER MUSIC BLOCK TO HL
 	POP	HL		; XFER MUSIC BLOCK TO HL
 	INC	DE		; GO AHEAD ONE ...
 	INC	DE		; ... TWO ...
 	INC	DE		; ... THREE ...
 	INC	DE		; ... FOUR
 	LD	BC,4		; NUMBER OF VALUES 
 	LDIR			; TRANSFER NOTE DEF'N
 	PUSH	HL		; SAVE THE LINE POINTER
 	POP	IX		; TRANSFER BACK TO BC
 	POP	DE		; GET ORIGINAL VALUE BACK
 	POP	HL		; GET ORIGINAL VALUE BACK
 	CALL	STRIP		; STRIP CONTROL CODES
 ;
 OUT6	CP	29H		; IS IT RIGHT PAREN?
 	DEC	HL		; BACK UP ONE CHARACTER
 	INC	IX		; MOVE THE MUSIC BLOCK
 	INC	IX		; ... UP THROUGH FOUR
 	INC	IX		; ... FULL PLACES UNTIL
 	INC	IX		; ... IT'S IN NEW PLACE
 	JP	NZ,NOTE0	; IF NOT THEN REPEAT
 EXIT	LD	(STORE8),IX	; PUT BACK INTO PLACE
 	JP	NXTCH0		; AND GET MORE MUSIC
 ;
 ; THIS ROUTINE CLEARS OUT CONTROL CODES AND OTHER
 ; CHARACTERS (POINTS AND SPACES) TO PROVIDE ASCII
 STRIP	INC	HL		; GET NEXT CHAR
 	LD	A,(HL)		; GET VALUE THERE
 	CP	21H		; STRIP CONTROL CODES
 	JR	C,STRIP		; GET NEXT CHAR IF C.C.
 	RET			; BACK WITH VALID CHAR
 ;
 ; DOUBLEBAR ROUTINE TERMINATES ONE PASS OF THE COMPILER
 DBLBAR	INC	HL		;
 	LD	A,(HL)		;
 	CP	3CH		;
 	JP	NZ,NXTCH1	;
 	LD	A,0C3H		; GET "JUMP" COMMAND
 	LD	(DE),A		; PUT BYTE INTO PLACE
 	INC	DE		; GO TO NEXT POSITION
 	LD	A,0CCH		; GET LSB OF BASIC LEVEL
 	LD	(DE),A		; PUT BYTE INTO PLACE
 	INC	DE		; GO TO NEXT POSITION
 	LD	A,(06)		; GET MSB OF BASIC LEVEL
 	LD	(DE),A		; PUT BYTE INTO PLACE
 	INC	DE		; GO TO NEXT POSITION
 	LD	HL,STORE3	; GET COMPILED LOCATION
 	LD	(HL),1		; FIRST PASS COMPILED
 	LD	HL,BARMSG	; GET "PASS ONE" MESSAGE
 	CALL	28A7H		; AND DISPLAY MESSAGE
 	JP	06CCH		; BACK TO COMMAND LEVEL
 BARMSG	DEFM	'PASS ONE COMPLETE.'
 	DEFB	00
 ;
 ; REFRAIN CREATION SUBROUTINE
 REFSUB	LD	A,0CDH		; GET "JUMP" COMMAND
 	LD	(DE),A		; PUT JUMP BYTE IN PLACE
 	INC	DE		; GO TO NEXT POSITION
 	PUSH	HL		; SAVE HL FOR A WHILE
 	LD	HL,REFEXC	; REFRAIN EXEC ROUTINE
 	LD	A,L		; LSB OF REFRAIN EXEC
 	LD	(DE),A		; AND PUT IT INTO PLACE
 	INC	DE		; GO TO NEXT POSITION
 	LD	A,H		; MSB OF REFRAIN EXEC
 	LD	(DE),A		; AND PUT IT INTO PLACE
 	INC	DE		; AND READY NEXT POSITION
 	POP	HL		; GET THE REGISTER BACK
 	JP	NXTCHR		; AND GO FOR NEXT CHAR.
 ;
 REFPRO	LD	A,(STORE8)	; GET CURRENT MUSIC POS'N
 	LD	(STOREE),A	; AND PUT IN REFRAINSTORE
 	LD	A,(STORE8+1)	; GET NEXT MUSIC POSITION
 	LD	(STOREE+1),A	; AND PUT IN REFRAINSTORE
 	JP	NXTCHR		; AND GO FOR NEXT CHAR.
 ;
 REPEAT	LD	A,(STORE8)	; GET CURRENT MUSIC POS'N
 	LD	(STOREF),A	; AND PUT IN REPEATSTORE
 	LD	A,(STORE8+1)	; GET NEXT MUSIC POSITION
 	LD	(STOREF+1),A	; AND PUT IN REPEATSTORE
 	JP	NXTCHR		; AND GO FOR NEXT CHAR.
 ;
 ENDREP	LD	A,0CDH		; GET "CALL" COMMAND BYTE
 	LD	(DE),A		; AND PUT BYTE INTO PLACE
 	INC	DE		; GO TO NEXT POSITION
 	PUSH	HL		; SAVE REGISTER A WHILE
 	LD	HL,REPEXC	; GET REPEAT EXEC ROUTINE
 	LD	A,L		; GET LSB OF REPEAT ROUT.
 	LD	(DE),A		; AND PUT BYTE IN PLACE
 	INC	DE		; GO TO NEXT POSITION
 	LD	A,H		; GET MSB OF REPEAT ROUT.
 	LD	(DE),A		; AND PUT BYTE IN PLACE
 	INC	DE		; GO TO NEXT POSITION
 	POP	HL		; RESTORE REGISTER SAVED
 	JP	NXTCHR		; GET THE NEXT CHARACTER
 ;
 ; ERROR MESSAGE DISPLAY ROUTINES 
 ERRSYN	LD	HL,MESG01	; GET SYNTAX ERROR MESS.
 DISJMP	CALL	28A7H		; AND DISPLAY IT
 	LD	IX,(STORE1)	; GET CURRENT LINE PTR.
 	LD	H,(IX+1)	; PUT MSB INTO H REG.
 	LD	L,(IX+0)	; PUT LSB INTO L REG.
 	CALL	0FAFH		; CALL INT-ASCII ROM
 	JP	06CCH		; GO BACK TO BASIC READY
 ERRRHY	LD	HL,MESG02	; GET RHYTHM ERROR MESS.
 	JR	DISJMP		; DISPLAY AND JUMP
 ERRNOT	LD	HL,MESG03	; GET NOTE ERROR MESS.
 	JR	DISJMP		; DISPLAY AND JUMP
 ERRLAB	LD	HL,MESG06	; GET LABEL ERROR MESS.
 	JR	DISJMP		; DISPLAY AND JUMP
 ERRKEY	LD	HL,MESG07	; GET KEYWORD ERROR MESS.
 	JR	DISJMP		; DISPLAY AND JUMP
 ERRVER	LD	HL,MESG08	; GET VERSO ERROR MESS.
 	JR	DISJMP		; DISPLAY AND JUMP
 ERROUT	LD	HL,MESG09	; GET OM ERROR MESS.
 	JR	DISJMP		; DISPLAY AND JUMP
 ERRLOG	LD	HL,MESG10	; GET LOGICAL ERR. MESS.
 	JR	DISJMP		; DISPLAY AND JUMP
 ERRDBL	LD	HL,MESG11	; GET DBLBAR ERROR MESS.
 	JR	DISJMP		; DISPLAY AND JUMP
 ERRREP	LD	HL,MESG04	; GET REPEAT ERROR MESS.
 ;
 ;
 ERRREF	LD	HL,MESG05	; GET REFRAIN ERROR MESS.
 ;
 ;
 ;
 ;
 ;
 ;
 ;
 ;
 ; EXECUTION ROUTINES -- TO BE DEFINED
 ;
 ACEXEC	RET
 ALEXEC	RET
 ANEXEC	RET
 CLEXEC	RET
 COEXEC	RET
 FLEXEC	RET
 FOEXEC	RET
 LAEXEC	RET
 LEEXEC	RET
 LTEXEC	RET
 MFEXEC	RET
 MOEXEC	RET
 MPEXEC	RET
 OBEXEC	RET
 PIEXEC	RET
 PREXEC	RET
 RAEXEC	RET
 RTEXEC	RET
 SEEXEC	RET
 SOEXEC	RET
 STEXEC	RET
 TREXEC	RET
 VIEXEC	RET
 PLAYER	RET
 REFEXC	RET
 REPEXC	RET
 ;
 ;
 ;
 	LD	HL,TEMP
 	CALL	28A7H
 	JP	06CCH
 TEMP	DEFM	'PROGRAM POINT UNDEFINED'
 	DEFB	00
 ;
 ;
 ;
 ; MUSIC PLAY ROUTINE -- HEART OF THE PLAYER ROUTINE
 ; ALL EXECUTION INVOLVES TRANSFERRING INFORMATION FROM
 ; THE MUSIC BLOCK POINTER AREA TO THIS EXECUTION ROUTINE,
 ; WHICH WILL THEN PLAY THE NOTE AND RHYTHM AS DEMANDED,
 ; AND RETURN TO THE CALLING ROUTINE.  ALL NOTES AND 
 ; RHYTHMS USED ARE PART OF A TABLE.
 ;
 ;
 	LD	HL,(STOREB)	; GET RHYTHM VALUE
 LOOP	LD	BC,(STOREC)	; FIRST PITCH WAVE
 	LD	A,2		; VALUE FOR FIRST TOGGLE
 	OUT	(0FFH),A	; ZIP IT OUT THE PORT
 LOOPA	DEC	BC		; DECREMENT FIRST WAVE
 	LD	A,B		; GET WAVE IN FOR TEST
 	OR	C		; TEST AGAINST OTHER BYTE
 	JP	NZ,LOOPA	; AND DELAY FIRST WAVE
 	LD	DE,(STORED)	; SECOND PITCH WAVE
 	LD	A,1		; VALUE FOR SECOND TOGGLE
 	OUT	(0FFH),A	; ZAP IT OUT THE PORT
 LOOPB	DEC	DE		; DECREMENT SECOND WAVE
 	LD	A,D		; GET WAVE IN FOR TEST
 	OR	E		; TEST AGAINST SECOND
 	JP	NZ,LOOPB	; TEST AGAINST OTHER BYTE
 	DEC	HL		; NOTE LENGTH PERIOD
 	LD	A,H		; IT A FOR THE TEST
 	OR	L		; TEST FOR DELAY'S END
 	JP	NZ,LOOP		; DO IT AGAIN IF OKAY
 	RET			; THEN GO BACK TO HOME
 ;
 ;
 ;
 ZZZZZZ	EQU	$
 ;
 	END	ENTRY		;
