QUAVER ;
 	ORG	7000H
 ;
 EXITI	EQU	1D78H		; INTERPRETER EXIT
 BASIC	EQU	06CCH		; LEVEL II EXIT
 SHOW	EQU	28A7H		; SCREEN DISPLAY CALL
 ;
 MESG00	DEFB	8FH
 	DEFM	' QUAVER MUSIC COMPILER 1.0 '
 	DEFB	8FH
 	DEFB	0AH
 	DEFM	'(C) 1981 DENNIS BATHORY KITSZ'
 	DEFB	00
 ;
 ; KEYWORD TABLE COMPILER COMMAND ENTRIES
 ;
 TABLE1	DEFM	'ACALANCLCOFL'	; KEYWORD TABLE START
 	DEFM	'FOLALELTMFMO'	; KEYWORD TABLE CONT'D
 	DEFM	'MPOBPRRARTSE'	; KEYWORD TABLE CONT'D
 	DEFM	'SOSTTRVI'	; KEYWORD TABLE CONCLUDED
 	DEFB	00		; END OF KEYWORD MARKER
 ;
 ; CALL ADDRESS TABLE OBJECT CODE ENTRIES
 ;
 OFFSET	DEFW	ACEXEC		; ACCELERANDO
 	DEFW	ALEXEC		; ALLEGRO
 	DEFW	ANEXEC		; ANDANTE
 	DEFW	CLEXEC		; CLARINET
 	DEFW	COEXEC		; CON (TREM/SORD)
 	DEFW	FLEXEC		; FLUTE
 	DEFW	FOEXEC		; FORTE
 	DEFW	LAEXEC		; LARGO
 	DEFW	LEEXEC		; LEGATO
 	DEFW	LTEXEC		; LEFT CHANNEL
 	DEFW	MFEXEC		; MEZZOFORTE
 	DEFW	MOEXEC		; MODERATO
 	DEFW	MPEXEC		; MEZZOPIANO
 	DEFW	OBEXEC		; OBOE
 	DEFW	PREXEC		; PRESTO
 	DEFW	RAEXEC		; RALLENTANDO
 	DEFW	RTEXEC		; RIGHT CHANNEL
 	DEFW	SEEXEC		; SENZA (SORD/TREM)
 	DEFW	SOEXEC		; SORDINO (WITH CON)
 	DEFW	STEXEC		; STACCATO
 	DEFW	TREXEC		; TREMOLO (WITH CON)
 	DEFW	VIEXEC		; VIOLIN
 ;
 ; QUAVER ENTRY POINTS FROM BASIC
 ;
 TABLE2	DEFM	'COMP'
 	DEFM	'PLAY'
 	DEFM	'DUMP'
 	DEFB	00H
 TABLE3	JP	CMPILE		; TO COMPILER ROUTINE
 	JP	PLAYEX		; TO PLAYBACK ROUTINE
 	JP	TAPEDP		; TO TAPEDUMP ROUTINE
 ;
 ; 12 COMPILATION ERROR MESSAGES
 ;
 MESG01	DEFM	'QUAVER SYNTAX ERROR IN '
 	DEFB	00
 MESG02	DEFM	'RHYTHM VALUE ERROR IN '
 	DEFB	00
 MESG03	DEFM	'NOTE INVALID OR OUT OF RANGE IN '
 	DEFB	00
 MESG04	DEFM	'NESTED REPEAT IN '
 	DEFB	00
 MESG05	DEFM	'REPEAT WITHOUT START IN '
 	DEFB	00
 MESG06	DEFM	'REFRAIN LABEL NOT FOUND IN '
 	DEFB	00
 MESG07	DEFM	'KEYWORD INVALID OR MISSPELLED IN '
 	DEFB	00
 MESG08	DEFM	'VERSO WITHOUT REFRAIN IN '
 	DEFB	00
 MESG09	DEFM	'OUT OF MEMORY IN '
 	DEFB	00
 MESG10	DEFM	'LOGICAL ERROR IN '
 	DEFB	00
 MESG11	DEFM	'NO DOUBLE BAR '
 	DEFB	00
 MESG12	DEFM	'REPEAT NOT COMPLETED AT '
 	DEFB	00
 ;
 ; TIMBRE TABLE OFFSET VALUES
 ;
 CLTIMB	DEFB	2		; 50% DUTY CYCLE
 FLTIMB	DEFB	5		; 20% DUTY CYCLE
 OBTIMB	DEFB	15		; 5% DUTY CYCLE
 VITIMB	DEFB	8		; 10% DUTY CYCLE
 ;
 ; COMPILATION AND PLAYBACK STORAGE AREAS
 ;
 STORE0	DEFB	00H		; PLAYBACK REST FLAG
 STORE1	DEFW	42EBH		; CURRENT LINE NUMBER
 STORE2	DEFB	00H		; DOUBLE BAR FOUND=1
 STORE3	DEFB	00H		; COMP. ERROR FREE=1
 STORE4	DEFB	43H		; LAST NOTE SOUNDED=C
 STORE5	DEFB	00H		; AMPERSAND WORK AREA
 STORE6	DEFB	33H		; LAST OCTAVE USED=3
 STORE7	DEFB	04H		; LAST RHYTHM USED=4
 STORE8	DEFW	ZZZZZZ		; MUSIC STORAGE AREA
 STORE9	DEFB	00H		; RHYTHM EXTEN'S (DOTS)
 STOREA	DEFB	00H		; TRILL BYTE CONDITION
 STOREB	DEFW	1000H		; RHYTHM DELAY WORD
 STOREC	DEFW	0100H		; TOP OF WAVE WORD
 STORED	DEFW	0100H		; RESERVED !!
 STOREE	DEFW	0000H		; LOC'N OF REFRAIN
 STOREF	DEFW	0000H		; LOC'N REPT. STRT.
 STOREG	DEFW	0100H		; BOT OF WAVE WORD
 STOREH	DEFW	0100H		; RESERVED !!
 STOREI	DEFB	00H		; WORKING REPEAT FLAG
 PLAYR0	DEFW	0101H		; WORKING RAW PITCHES
 PLAYR1	DEFW	0101H		; WORKING RAW LOOPS
 PLAYR2	DEFB	10H		; TEMPO MULTIPLIER
 PLAYR3	DEFW	02FFH		; VOLUME/PORT WAVE #1
 PLAYR4	DEFB	00H		; ACCEL/RALL VALUE
 PLAYR5	DEFB	00H		; CASSETTE IN USE
 PLAYR6	DEFW	00FFH		; VOLUME/PORT WAVE #2
 PLAYR7	DEFB	00H		; STACCATO STATUS FLAG
 PLAYR8	DEFW	0010H		; TEMPORARY TIMBRE STORE
 PLAYR9	DEFW	0010H		; TIMBRE MULTIPLIER
 PLAYRA	DEFW	0101H		; WORKING RAW RHYTHM
 PLAYRB	DEFB	00H		; SORDINO STATUS FLAG
 ;
 ; PATCH INTO INTERPRETER ROUTINE
 ;
 ENTRY	LD	HL,START	; QUAVER START POINT
 	LD	(4004H),HL	; INTERPRETER PATCH PT.
 	LD	HL,MESG00	; GET SIGN-ON MESSAGE
 	CALL	SHOW		; AND DISPLAY IT
 	JP	BASIC		; BACK TO BASIC READY
 ;
 ; BASIC COMMAND LEVEL SYNTAX CHECK
 ;
 START	EX	(SP),HL		; FIND TOP OF STACK
 	LD	A,L		; CHECK LSB FIRST
 	CP	5BH		; IS STACK LSB AT 5B?
 	JR	NZ,NOTRDY	; GO OUT IF NOT READY
 	LD	A,H		; CHECK MSB SECOND
 	CP	1DH		; IS STACK MSB AT 1D?
 NOTRDY	EX	(SP),HL		; SWITCH IT ALL BACK
 	JP	NZ,EXITI	; BACK TO BASIC IF NOT
 ;
 ; QUAVER KEYWORD COMMAND TEST
 ;
 	LD	IX,TABLE2	; FIRST WORD TO CHECK
 	LD	DE,0		; COUNTER OF KEYWORDS
 KYWORD	LD	B,4		; TOTAL CHARACTERS
 	PUSH	HL		; AND SAVE POINTER
 	INC	HL		; GET NEXT CHARACTER
 	PUSH	IX		; SAVE TABLE LOCATION
 CHECK1	LD	A,(HL)		; LETTER INTO A FOR TEST
 	CP	(IX)		; CHECK AGAINST WORDS
 	JR	NZ,REFIND	; GO AHEAD FOR NEXT ONE
 	INC	HL		; BUMP ONE MORE TIME
 	INC	IX		; MOVE WORD TABLE UP
 	DJNZ	CHECK1		; DO 4-CHAR WORDS
 	POP	IX		; RESTORE THE TABLE
 	POP	BC		; CLEAR POINTER FROM STK.
 	DEC	HL		; BACK FOR FURTHER INTERP
 	PUSH	HL		; RETURN COMMAND ON STACK
 	LD	IX,TABLE3	; GET JUMP ADDRESS TABLE
 	ADD	IX,DE		; GET CORRECT ADDRESS
 	JP	(IX)		; AND MOVE TO EXECUTION
 REFIND	POP	IX		; RESTORE THE TABLE
 	LD	BC,4		; OFFSET TO NEXT KEYWORD
 	ADD	IX,BC		; MOVE TO NEXT KEYWORD
 	LD	A,(IX)		; GET VALUE AT IX
 	AND	A		; IS IT A ZERO?
 	POP	HL		; HL READY TO SPLIT
 	JP	Z,EXITI		; BACK TO INTERPRETER
 	INC	DE		; OTHERWISE BUMP COUNTER
 	INC	DE		; AND BUMP IT AGAIN
 	INC	DE		; AND BUMP IT AGAIN
 	JR	KYWORD		; BACK FOR NEXT KEYWORD
 ;
 ; MAIN COMPILER COMMAND BRANCHING ROUTINE
 ;
 CMPILE	XOR	A		; CLEAR ACCUM TO ZERO
 	LD	(STORE2),A	; ZERO DBLBAR FLAG
 	LD	(STORE3),A	; ZERO COMPILED FLAG
 	LD	HL,02FFH	; PORT & VOLUME COMP.
 	LD	(PLAYR3),HL	; PUT IN PLACE
 	DEC	H		; HL BECOMES 01FF
 	LD	(PLAYR6),HL	; PUT IN PLACE
 	LD	HL,ZZZZZZ	; OBJECT CODE STORAGE
 	LD	(STORE8),HL	; START OF OBJECT CODE
 ;
 	LD	HL,(40FDH)	; START OF COMPILED CODE
 	LD	DE,(40A4H)	; BEGINNING OF LISTING
 	PUSH	HL		; SAVE CODE START
 	PUSH	DE		; SAVE LISTING START
 	SBC	HL,DE		; GET LISTING LENGTH
 	PUSH	HL		; STORE TOTAL LENGTH
 	POP	BC		; AND PUT INTO COUNTER
 	POP	HL		; GET LISTING START
 	POP	DE		; GET CODE START
 	PUSH	HL		; SAVE LISTING START
 	LD	A,0AFH		; GET "XOR A" OPCODE
 	LD	(DE),A		; FIRST COMPILED BYTE
 	INC	DE		; NEXT COMPILER POS'N
 LOOP6	LD	A,(HL)		; GET FIRST VALUE
 	CP	3EH		; IS IT A > SIGN?
 	JR	Z,NXTGRT	; CHECK FOR NEXT DBL BAR
 	INC	HL		; GET NEXT LISTING LOC'N
 	DEC	BC		; DROP COUNTER BY ONE
 	LD	A,B		; GET VALUE OF B
 	OR	C		; GET VALUE OF C
 	JP	Z,ERRDBL	; TO NO DBLBAR ERROR
 	JR	LOOP6		; LOOP THROUGH WHOLE LIST
 NXTGRT	INC	HL		; GET NEXT LISTING LOC'N
 	LD	A,(HL)		; VALUE AT LOCATION
 	CP	3EH		; IS IT SECOND > SIGN?
 	INC	HL		; GET NEXT LIST LOC'N
 	JR	NZ,LOOP6	; LOOP BACK IF NOT DBLBAR
 ;
 BEGIN1	LD	HL,STORE2	; GET DBLBAR FOUND AREA
 	LD	(HL),1		; STORE FOUND CODE = 1
 	POP	HL		; GET LISTING START
 NULINE	INC	HL		; MOVE PAST ADDRESS LSB
 	INC	HL		; MOVE PAST ADDRESS MSB
 	LD	(STORE1),HL	; STORE CURRENT LINE NO.
 	INC	HL		; MOVE PAST LINE NUMBER
 NXTCHR	INC	HL		; MOVE PAST LINE NUMBER
 NXTCH1	LD	A,(HL)		; VALUE AT LINE START
 	AND	A		; TEST IF IT IS ZERO
 	JR	NZ,JUMP7	; GO TO NEXT LINE IF SO
 	INC	HL		; BUMP POINTER PAST ZERO
 	JR	NULINE		; AND RESTART LINE EVAL.
 JUMP7	CP	22H		; IS IT A POINT OR LESS?
 	JR	C,NXTCHR	; LOOP BACK FOR ANOTHER
 	CP	93H		; IS IT A REM STATEMENT?
 	JR	Z,NXTCHR	; LOOP BACK FOR ANOTHER
 	CP	2AH		; IS IT A STAR (*) "REM"?
 	JR	NZ,JUMP1	; CONTINUE TESTING IF NOT
 FIND00	INC	HL		; GET NEXT LOCATION
 	LD	A,(HL)		; CHECK THE LOCATION
 	AND	A		; TEST FOR A ZERO BYTE
 	JR	NZ,FIND00	; LOOP TILL NEW LINE
 	INC	HL		; MOVE UP TO NEW LINE
 	JR	NULINE		; BACK FOR NEXT CHAR
 JUMP1	CP	2EH		; IS IT A PERIOD (.)?
 	JR	Z,COMMND	; GO TO COMMAND PROCESSOR
 	CP	28H		; IS IT LEFT PAREN (()?
 	JR	Z,NOTES		; GO TO	NOTE PROCESSOR
 	CP	23H		; IS IT A SEGNO (#)?
 	JP	Z,REFSUB	; GO TO REFRAIN LABELER
 	CP	24H		; IS IT A SEGNO ($)?
 	JP	Z,REFPRO	; GO TO REFRAIN PROCESSOR
 	CP	3CH		; IS IT A REPEAT (<:)?
 	JP	Z,REPEAT	; GO TO REPEAT PROCESSOR
 	CP	3AH		; IS IT END REPEAT (:>)?
 	JP	Z,ENDREP	; GO TO END REPEAT PROC.
 	CP	3EH		; IS IT DOUBLE BAR (>>)?
 	JP	Z,DBLBAR	; GO TO DOUBLE BAR PROC.
 ERRKY1	JP	ERRKEY		; SYNTAX ERROR IF NONE
 ;
 ; TWO-LETTER COMMAND TABLE BRANCHING
 ;
 COMMND	LD	IX,TABLE1	; POINT TO TABLE START
 	INC	HL		; GET NEXT CHAR IN LINE
 CMDTST	LD	A,(HL)		; CHARACTER FOR TEST
 	CP	(IX)		; CHECK AGAINST REGISTER
 	JR	NZ,NXTTST	; GO ON TO NEXT COMMAND
 	INC	HL		; GET NEXT CHARACTER
 	LD	A,(HL)		; CHARACTER FOR TEST
 	CP	(IX+1)		; CHECK AGAINST TABLE
 	JR	NZ,NXTCMD	; GO ON TO NEXT COMMAND
 	LD	A,0CDH		; GET CALL VALUE READY
 	LD	(DE),A		; PUT CALL ADDRESS IN
 	INC	DE		; ADVANCE PTR STORAGE
 	LD	A,(IX+OFFSET-TABLE1)	; CALL TABLE VAL.
 	LD	(DE),A		; AND PLACE IN COMP CODE
 	INC	DE		; GET NEXT COMP CODE ADDR
 	LD	A,(IX+OFFSET-TABLE1+1)	; CALL TABLE VAL.
 	LD	(DE),A		; AND PLACE IN COMP CODE
 	INC	DE		; GET NEXT COMP CODE ADDR
 LOOP4	INC	HL		; GET NEXT CHAR IN LINE
 	LD	A,(HL)		; GET VALUE IN LINE
 	CP	41H		; COMPARE AGAINST ALPHA A
 	JR	C,NXTCH1	; GET NEXT CHAR IF < A
 	CP	5BH		; COMPARE AGAINST ALPHA Z
 	JR	NC,NXTCH1	; GET NEXT CHAR IF > Z
 	JR	LOOP4		; SKIP PAST ALPHA CHARS.
 NXTCMD	DEC	HL		; MOVE POINTER ONE BACK
 NXTTST	INC	IX		; MOVE TABLE AHEAD
 	INC	IX		; MOVE TABLE AHEAD
 	LD	A,(IX)		; GET TABLE VALUE
 	AND	A		; TEST IF IT IS ZERO
 	JR	Z,ERRKY1	; END OF TABLE - ERROR
 	JR	CMDTST		; GO BACK THROUGH TABLE
 ;
 ; HL AND BC REGISTERS POINTED TO BLOCK STORAGE AND FILL
 ;
 NOTES	LD	A,11H		; GET "LD DE" OPCODE 
 	LD	(DE),A		; PUT INTO PLACE
 	INC	DE		; GET NEXT VALUE READY
 	LD	A,(STORE8)	; GET LSB OF MUSIC BLOCK
 	LD	(DE),A		; PUT IN PLACE AS OPERAND
 	INC	DE		; GET NEXT VALUE READY
 	LD	A,(STORE8+1)	; GET MSB OF MUSIC BLOCK
 	LD	(DE),A		; PUT IN PLACE AS OPERAND
 	INC	DE		; GET NEXT COMP LOC'N
 	LD	A,21H		; GET "LD HL" OPCODE
 	LD	(DE),A		; PUT IN PLACE AS OPCODE
 	INC	DE		; GET NEXT VALUE READY
 	LD	IX,(STORE8)	; GET CURRENT MUSIC BLOCK
 ;
 ; SPACES STRIPPED; CHECK FOR REST, TRILL, RT PAREN, SLASH
 ;
 	CALL	STRIP		; STRIP CONTROL CODES
 NOTE0A	CP	2FH		; IS IT A SLASH (/) ?
 	JR	NZ,SKIPW	; NOT A SLASH; MOVE ON
 	DEC	IX		; MOVE BACK TO DUPLICATE
 	DEC	IX		; PRESENT NOTE/RHYTHM
 	JP	NOTE8A		; AND GO EXECUTE SLASH
 SKIPW	CP	29H		; IS IT A RIGHT PAREN?
 	JP	Z,EXIT		; EXIT NOTES IF PAREN
 	CP	54H		; IS IT A TRILL (T)?
 	JR	NZ,SKIPY	; GO PAST IF NOT T
 	LD	A,1		; TRILL INDICATOR BYTE
 	LD	(STOREA),A	; PLACE INTO CODE
 	JR	NOTE1		; GO ON TO EVALUATE
 SKIPY	PUSH	AF		; SAVE COMPARED VALUE
 	XOR	A		; CLEAR A TO ZERO
 	LD	(STOREA),A	; SAVE 0 IN TRILL BYTE
 	POP	AF		; GET BACK ORIG VALUE
 	CP	52H		; IS IT A REST (R)?
 	JR	NZ,NOTE1B	; IF NOT THEN GO OUT
 	LD	A,0FFH		; ELSE PUT FF FLAG
 	LD	(IX),A		; HERE'S REST INDICATOR
 	JR	NOTE4		; OUT TO RHYTHM INDIC.
 ;
 ; SPACES STRIPPED; CHECK FOR NOTE.  PITCH IS REQUIRED.
 ;
 NOTE1	CALL	STRIP		; STRIP CONTROL CODES
 NOTE1B	CP	41H		; CHECK AGAINST ALPHA A
 	JP	C,ERRLOG	; LOGICAL ERROR IF < A
 	CP	48H		; CHECK AGAINST ALPHA H
 	JP	NC,ERRLOG	; LOGICAL ERROR IF > G
 	SUB	40H		; STRIP ASCII VALUE
 	RLCA			; MULTIPLY BY TWO
 	LD	(STORE4),A	; SAVE THE NOTE IN STORE
 ;
 ; THIS SECTION STRIPS CONTROL CODES, THEN CHECKS FOR
 ; THE PRESENCE OF +, - OR =.  = IS THE DEFAULT VALUE.
 ;
 	CALL	STRIP		; STRIP CONTROL CODES
 	CP	2BH		; IS IT A PLUS SIGN (+)
 	JR	NZ,JUMP10	; SKIP PAST IF NOT
 	LD	A,1		; GET +1 (SHARP) CODE
 	JR	NOTE3X		; AND GET OUT NOW
 JUMP10	CP	2DH		; IS IT A MINUS SIGN (-)
 	JR	NZ,JUMP11	; SKIP PAST IF NOT
 	LD	A,0FFH		; GET -1 (FLAT) CODE
 	JR	NOTE3X		; AND GET OUT NOW
 JUMP11	CP	3DH		; IS IT AN EQUAL SIGN (=)
 	JR	NZ,JUMP12	; SKIP PAST IF NOT
 	XOR	A		; GET 0 (NATURAL) CODE
 	JR	NOTE3X		; JUMP TO OCTAVE TEST
 JUMP12	XOR	A		; GET 0 (NATURAL) CODE
 	DEC	HL		; BUMP POINTER BACK ONE
 NOTE3X	LD	BC,(STORE4)	; GET ORIGINAL PITCH
 	ADD	A,C		; MAKE COMPLETE PITCH
 	LD	(STORE4),A	; ADD SIGN OFFSET
 ;
 ; THIS SECTION STRIPS CONTROL CODES, AND SEARCHES FOR
 ; OCTAVE WHICH TO BE PLAYED (1-4, UP TO C IN 5)
 ;
 	CALL	STRIP		; STRIP CONTROL CODES
 	CP	31H		; MUST BE 1 OR GREATER
 	JR	C,JUMP13	; NOT A NUMBER; TEST /
 	CP	3AH		; MUST BE 9 OR LESS
 	JR	NC,JUMP13	; NOT A NUMBER; TEST @
 	CP	36H		; MUST BE 5 OR LESS
 	JP	NC,ERRNOT	; OUT OF RANGE ERROR
 	CP	35H		; TEST IF JUST FIVE
 	JR	NZ,JMP12A	; GO PAST IF < 5
 	PUSH	AF		; SAVE VALUE IN A
 	LD	A,(STORE4)	; CHECK LAST NOTE SOUNDED
 	CP	7H		; RELATIONSHIP TO C
 	JP	NC,ERRNOT	; OUT OF RANGE ERROR
 	POP	AF		; RESTORE VALUE IN A
 JMP12A	INC	HL		; MOVE LINE POINTER UP
 	SUB	30H		; STRIP ASCII FROM OCTAVE
 	RLCA			; BUMP OCTAVE INTO...
 	RLCA			; ... HIGH NYBBLE ...
 	RLCA			; ... WHERE PITCH ...
 	RLCA			; ... CAN BE ADDED.
 	LD	(STORE6),A	; AND SAVE OCTAVE ALONE
 JUMP13	LD	A,(STORE6)	; GET OCTAVE VALUE TO A
 	LD	BC,(STORE4)	; GET ORIGINAL PITCH
 	ADD	A,C		; AND CREATE COMPLETE...
 	LD	(IX),A		; ...PITCH, ALL READY.
 	DEC	HL		; BUMP POINTER BACK
 ;
 ; THIS SECTION STRIPS CONTROL CODES, THEN CHECKS FOR
 ; PRESENCE OF @ SIGN TO DETERMINE RHYTHM TO PLAY
 ;
 NOTE4	CALL	STRIP		; STRIP CONTROL CODES
 	CP	40H		; IS IT THE @ SIGN?
 	JR	NZ,OUT4		; GO OUT IF NOT (NOTE 4)
 	PUSH	AF		; SAVE THE VALUE
 	XOR	A		; CLEAR A TO ZERO
 	LD	(STORE5),A	; CLEAR AMPERSAND AREA
 	POP	AF		; RESTORE THE VALUE
 REDO	CALL	STRIP		; STRIP CONTROL CODES
 	CP	31H		; MUST BE 1 OR GREATER
 	JP	C,ERRSYN	; GOTTA BE A NUMBER
 	CP	3AH		; MUST BE 9 OR LESS
 	JP	NC,ERRSYN	; NOT A NUMBER; TEST @
 	CP	39H		; TEST AGAINST ASCII 9
 	JP	NC,ERRRHY	; LOGICAL ERROR IF 10
 	SUB	30H		; STRIP ASCII FROM RHYTHM
 	RLCA			; MULTIPLY RHYTHM OFFSET
 	RLCA			; BY FOUR (NEED DOTS)
 	LD	(STORE7),A	; STORE IN RHYTHM AREA
 ;
 ; THIS SECTION STRIPS CONTROL CODES, AND SEARCHES FOR
 ; RHYTHM EXTENSION SYMBOL + OR ++.
 ;
 	XOR	A		; CLEAR ACCUM TO ZERO
 	LD	(STORE9),A	; CLEAR RHYTHM EXTENS'NS
 	CALL	STRIP		; STRIP CONTROL CODES
 	CP	2BH		; CHECK IF PLUS SIGN
 	JR	NZ,SKIPQ	; PREPARE RHYTHM IF NOT
 	LD	A,(STORE7)	; INDICATE FIRST PLUS
 	SRL	A		; DIVIDE BY TWO
 	LD	(STORE9),A	; PUT INTO RHYTHM STORE
 	CALL	STRIP		; STRIP CONTROL CODES
 	CP	2BH		; IS IT PLUS SIGN?
 	JR	NZ,SKIPQ	; GO OUT IF NOT +
 	INC	HL		; TEMPORARY POINTER BUMP
 	LD	A,(STORE9)	; GET 2 + SIGN VALUE
 	PUSH	AF		; SAVE VALUE TEMP'Y
 	SRL	A		; DIVIDE BY FOUR
 	LD	B,A		; SAVE DIVIDED VALUE
 	POP	AF		; GET THAT VALUE BACK
 	ADD	A,B		; PRODUCE NEW DOTTED VAL
 	LD	(STORE9),A	; PUT INTO WORK AREA
 SKIPQ	LD	A,(STORE7)	; GET ORIGINAL RHYTHM
 	LD	B,A		; SAVE DIVIDED VALUE
 	LD	A,(STORE9)	; GET PREVIOUS CALCS.
 	ADD	A,B		; MAKE COMPOSITE RESULT
 	LD	B,A		; TEMPORARY STORAGE
 	LD	A,(STORE5)	; AMPERSAND STORAGE
 	ADD	A,B		; MAKE COMPOSITE RESULT
 	LD	(IX+1),A	; SAVE IN RHYTHM BLOCK
 	LD	(STORE5),A	; PLACE FOR LATER USE
 	DEC	HL		; BACK UP THE POINTER
 	CALL	STRIP		; STRIP CONTROL CODES
 ;
 ; THIS SECTION STRIPS CONTROL CODES AND CHECKS FOR "&"
 ;
 	CP	26H		; IS IT AN AMPERSAND?
 	JR	Z,REDO		; IF IT IS, MORE RHYTHM
 	JR	NOTE8		; AND GO BACK FOR MORE
 OUT4	LD	A,(STORE7)	; GET PREV. RHYTHM VALUE
 	LD	(IX+1),A	; PUT IN MUSIC BLOCK
 	LD	A,(HL)		; GET CHARACTER IN LINE
 ;
 ; THIS SECTION CHECKS FOR REPEATED CHARACTER AND ACTS
 ; ON IT BY REPEATING THE TWO BYTES OF INFORMATION
 ;
 NOTE8	CP	2FH		; IS IT A SLASH?
 	JR	NZ,OUT6		; GO AWAY IF NOT
 NOTE8A	LD	A,(IX)		; GET CURRENT PITCH
 	LD	(IX+2),A	; SAVE AS NEXT PITCH
 	LD	A,(IX+1)	; GET CURRENT RHYTHM
 	LD	(IX+3),A	; SAVE AS NEXT RHYTHM
 	INC	IX		; UP TO NEXT POSITION...
 	INC	IX		; ...IN STORAGE AREA.
 	CALL	STRIP		; STRIP CONTROL CODES
 ;
 OUT6	CP	29H		; IS IT RIGHT PAREN?
 	INC	IX		; MOVE THE MUSIC BLOCK
 	INC	IX		; ... UP TWO POS'NS
 	JP	NZ,NOTE0A	; IF NOT THEN REPEAT
 EXIT	LD	(STORE8),IX	; PUT BACK INTO PLACE
 	LD	A,(STORE8)	; GET MEMORY POINTER
 	LD	(DE),A		; PUT IN PLACE AS OPERAND
 	INC	DE		; BUMP POINTER
 	LD	A,(STORE8+1)	; GET MSB MEMORY POINTER
 	LD	(DE),A		; PUT IN PLACE AS OPERAND
 	INC	DE		; BUMP POINTER
 	PUSH	HL		; SAVE CODE POINTER
 	LD	HL,BLOCK2	; LOCATION OF BLOCK MOVE
 	LD	BC,3		; BYTES TO MOVE
 	LDIR			; PUT BLOCK IN CODE
 	POP	HL		; RESTORE CODE POINTER
 	JP	NXTCHR		; AND GET MORE MUSIC
 BLOCK2	DEFB	0CDH		; CALL
 	DEFW	PLAYBK		; PLAYBK LSB/MSB
 ;
 ; THIS ROUTINE CLEARS OUT CONTROL CODES AND OTHER
 ; CHARACTERS (POINTS AND SPACES) TO PROVIDE ASCII
 ;
 STRIP	INC	HL		; GET NEXT CHAR
 	LD	A,(HL)		; GET VALUE THERE
 	CP	22H		; STRIP CONTROL CODES
 	JR	C,STRIP		; GET NEXT CHAR IF C.C.
 	RET			; BACK WITH VALID CHAR
 ;
 ; DOUBLEBAR ROUTINE TERMINATES ONE PASS OF THE COMPILER
 ;
 DBLBAR	INC	HL		; GET NEXT BUFFER CHAR.
 	LD	A,(HL)		; READY FOR EVALUATION
 	CP	3EH		; IS IT SECOND ">"?
 	JP	NZ,NXTCH1	; IF NOT THEN BACK AGAIN
 	LD	HL,BLOCK1	; GET EXIT BLOCK MOVE
 	LD	BC,4		; NUMBER OF BYTES
 	LDIR			; MOVE 4 BYTES IN PLACE
 	LD	A,(STOREI)	; CHECK REPEAT STATUS
 	AND	A		; SHOULD BE ZERO
 	PUSH	AF		; SAVE TEST IN FLAGS
 	XOR	A		; CLEAR A TO ZERO
 	LD	(STOREI),A	; MAKE IT 0 FOR NEXT TIME
 	POP	AF		; RESTORE FLAGS TEST
 	JP	NZ,ERRINC	; REPEAT ERROR IF NOT 0
 	LD	HL,STORE3	; GET COMPILED LOC'N
 	LD	(HL),1		; FIRST PASS COMPILED
 	LD	HL,BARMSG	; GET "COMPLETE" MSG.
 	CALL	SHOW		; AND DISPLAY MESSAGE
 	POP	HL		; RESTORE ORIG LINE PTR
 	JP	EXITI		; BACK TO COMMAND LEVEL
 BLOCK1	DEFB	0E1H		; POP HL
 	DEFB	0C3H		; JP
 	DEFW	EXITI		; 1D78
 BARMSG	DEFM	'COMPILATION COMPLETE'
 	DEFB	0DH		; CAR RETN
 	DEFB	00
 ;
 ; MISCELLANEOUS AND SPECIAL COMPILATION SUBROUTINES
 ;
 ; REFRAIN CREATION SUBROUTINE
 ;
 REFSUB	LD	A,0CDH		; GET "CALL" COMMAND
 	LD	(DE),A		; PUT JUMP BYTE IN PLACE
 	INC	DE		; GO TO NEXT POSITION
 	PUSH	HL		; SAVE HL TEMPORARILY
 	LD	HL,REFEXC	; REFRAIN EXEC ROUTINE
 	LD	A,L		; LSB OF REFRAIN EXEC
 	LD	(DE),A		; PUT IT INTO PLACE
 	INC	DE		; GO TO NEXT POSITION
 	LD	A,H		; MSB OF REFRAIN EXEC
 	LD	(DE),A		; PUT IT INTO PLACE
 	INC	DE		; READY NEXT POSITION
 	POP	HL		; GET THE REGISTER BACK
 	JR	ONWARD		; AND GO FOR NEXT CHAR.
 ;
 ; REFRAIN PROCESSOR SUBROUTINE
 ;
 REFPRO	PUSH	HL		; SAVE LINE POINTER
 	LD	HL,(STORE8)	; GET CURRENT POSITION
 	LD	(STOREE),HL	; PUT IN REFRAIN STORE
 	POP	HL		; RESTORE LINE POINTER
 	JR	ONWARD		; GO FOR NEXT CHAR.
 ;
 ; REPEAT START CREATION SUBROUTINE
 ;
 REPEAT	CALL	STRIP		; CHECK NEXT CHAR
 	CP	3AH		; IS IT A COLON?
 	JR	NZ,ERRSYN	; SYNTAX ERROR IF NOT
 	LD	A,(STOREI)	; GET STATUS OF REPEAT
 	AND	A		; TEST A FOR IN-PROGRESS
 	JP	NZ,ERRREP	; NO NESTED REPEATS
 	INC	A		; IN-PROGRESS FLAG ON
 	LD	(STOREI),A	; AND PUT IN PLACE
 	LD	(DE),A		; ALSO "LD BC" OPCODE
 	INC	DE		; NEXT COMPILER POS'N
 	INC	A		; OPERAND LSB VALUE 02
 	LD	(DE),A		; AND PUT IN PLACE
 	INC	DE		; NEXT COMPILER POS'N
 	XOR	A		; OPERAND MSB VALUE 00
 	LD	(DE),A		; AND PUT IN PLACE
 	INC	DE		; NEXT COMPILER POS'N
 	LD	A,0C5H		; "PUSH BC" OPCODE
 	LD	(DE),A		; AND PUT IN PLACE
 	LD	(STOREF),DE	; RETURN ADDRESS TOO
 	INC	DE		; NEXT COMPILER POS'N
 	JR	ONWARD		; GO FOR NEXT CHAR.
 ;
 ; REPEAT COMPLETION PROCESSOR SUBROUTINE
 ;
 ENDREP	CALL	STRIP		; GET NEXT CHARACTER
 	CP	3EH		; IS IT A > SIGN?
 	JR	NZ,ERRSYN	; SYNTAX ERROR IF NOT
 	LD	A,(STOREI)	; REPEAT IN PROG. FLAG
 	AND	A		; TEST IF NOT ZERO
 	JR	Z,ERRRP2	; END-W.OUT-START ERR.
 	XOR	A		; CLEAR A TO ZERO
 	LD	(STOREI),A	; REPEAT END FLAG
 	PUSH	HL		; SAVE CODE POINTER
 	LD	HL,BLOCK3	; BLOCK TO MOVE
 	LD	BC,5		; BYTES TO MOVE
 	LDIR			; MOVE FIVE BYTES
 	POP	HL		; RESTORE CODE POINTER
 	LD	A,(STOREF)	; REPEAT ADDRESS LSB
 	LD	(DE),A		; PUT IN PLACE
 	INC	DE		; NEXT COMPILER POS'N
 	LD	A,(STOREF+1)	; REPEAT ADDRESS MSB
 	LD	(DE),A		; PUT IN PLACE
 	INC	DE		; NEXT COMPILER POS'N
 ONWARD	JP	NXTCHR		; GET NEXT CHARACTER
 BLOCK3	DEFB	0C1H		; POP BC
 	DEFB	00BH		; DEC BC
 	DEFB	078H		; LD A,B
 	DEFB	0B1H		; OR C
 	DEFB	0C2H		; JP NZ
 ;
 ; ERROR MESSAGE DISPLAY ROUTINES 
 ;
 ERRSYN	LD	HL,MESG01	; GET SYNTAX ERROR MESS.
 DISJMP	CALL	SHOW		; AND DISPLAY IT
 	LD	IX,(STORE1)	; GET CURRENT LINE PTR.
 	LD	H,(IX+1)	; PUT MSB INTO H
 	LD	L,(IX+0)	; PUT LSB INTO L
 	CALL	0FAFH		; CALL INT-ASCII ROM
 	XOR	A		; CLEAR A TO ZERO
 	LD	(STORE2),A	; NOT COMPILED
 	LD	(STORE3),A	; NO DOUBLEBAR
 	LD	(STOREI),A	; NO REPEATS
 	LD	(PLAYR4),A	; NO ACCEL/RALL
 	LD	(PLAYR5),A	; CASSETTE #0
 	LD	(PLAYR7),A	; NO STACCATO
 	LD	(PLAYRB),A	; NO SORDINO
 	JP	BASIC		; BACK TO BASIC READY
 ERRRHY	LD	HL,MESG02	; RHYTHM ERROR MESS.
 	JR	DISJMP		; DISPLAY AND JUMP
 ERRNOT	LD	HL,MESG03	; NOTE ERROR MESS.
 	JR	DISJMP		; DISPLAY AND JUMP
 ERRLAB	LD	HL,MESG06	; LABEL ERROR MESS.
 	JR	DISJMP		; DISPLAY AND JUMP
 ERRKEY	LD	HL,MESG07	; KEYWORD ERROR MESS.
 	JR	DISJMP		; DISPLAY AND JUMP
 ERRVER	LD	HL,MESG08	; VERSO ERROR MESS.
 	JR	DISJMP		; DISPLAY AND JUMP
 ERROUT	LD	HL,MESG09	; OM ERROR MESS.
 	JR	DISJMP		; DISPLAY AND JUMP
 ERRLOG	LD	HL,MESG10	; LOGICAL ERR. MESS.
 	JR	DISJMP		; DISPLAY AND JUMP
 ERRDBL	LD	HL,MESG11	; DBLBAR ERROR MESS.
 	JR	DISJMP		; DISPLAY AND JUMP
 ERRREP	LD	HL,MESG04	; REPEAT ERROR MESS.
 	JR	DISJMP		; DISPLAY AND JUMP
 ERRRP2	LD	HL,MESG05	; INCOMPLETE REPEAT ERROR
 	JR	DISJMP		; DISPLAY AND JUMP
 ERRINC	LD	HL,MESG12	; INCOMPLETE REPEAT ERROR
 	JR	DISJMP		; DISPLAY AND JUMP
 ;
 ; EXECUTION ROUTINES -- SOME LEFT TO BE DEFINED
 ;
 ACEXEC	LD	A,0FFH		; ACCEL INDICATOR
 	JR	SPDOUT		; COMPLETE PROCESS
 ALEXEC	LD	A,3		; VALUE FOR ALLEGRO
 	JR	TMPOUT		; COMPLETE PROCESS
 ANEXEC	LD	A,6		; VALUE FOR ANDANTE
 	JR	TMPOUT		; COMPLETE PROCESS
 CLEXEC	LD	A,(CLTIMB)	; CLARINET TIMBRE TABLE
 	JR	TMBOUT		; COMPLETE PROCESS
 COEXEC	RET			; TO BE DEFINED !!
 FLEXEC	LD	A,(FLTIMB)	; FLUTE TIMBRE TABLE
 	JR	TMBOUT		; COMPLETE PROCESS
 FOEXEC	LD	A,2		; FORTE VOLUME VALUE
 	LD	(PLAYR3+1),A	; PUT VALUE IN PLACE
 	DEC	A		; ONE VALUE READY
 	JR	DYNOUT		; COMPLETE PROCESS
 LAEXEC	LD	A,8		; LARGO TEMPO VALUE
 	JR	TMPOUT		; COMPLETE PROCESS
 LEEXEC	XOR	A		; ZERO = LEGATO KEY
 	JR	EMBOUT		; COMPLETE PROCESS
 LTEXEC	XOR	A		; ZERO = LEFT CASSETTE
 	JR	CASOUT		; COMPLETE PROCESS
 MFEXEC	LD	A,1		; MEZZOFORTE VALUE
 	LD	(PLAYR3+1),A	; PUT VALUE IN PLACE
 	XOR	A		; ZERO VALUE READY
 	JR	DYNOUT		; COMPLETE PROCESS
 MOEXEC	LD	A,4		; MODERATO VALUE
 	JR	TMPOUT		; COMPLETE PROCESS
 MPEXEC	LD	A,2		; MEZZOPIANO VALUE
 	LD	(PLAYR3+1),A	; PUT VALUE IN PLACE
 	INC	A		; THREE VALUE
 DYNOUT	LD	(PLAYR6+1),A	; PUT VALUE IN PLACE
 	RET
 OBEXEC	LD	A,(OBTIMB)	; OBOE TIMBRE TABLE
 	JR	TMBOUT		; COMPLETE PROCESS
 PREXEC	LD	A,2		; PRESTO VALUE
 TMPOUT	LD	(PLAYR2),A	; SAVE IN TEMPO MULT'R
 	XOR	A		; CLEAR ACCUM TO ZERO
 	JR	SPDOUT		; COMPLETE PROCESS
 RAEXEC	LD	A,1		; RALLEN VALUE
 SPDOUT	LD	(PLAYR4),A	; RETURN VALUE TO PLACE
 	RET
 RTEXEC	LD	A,1		; RIGHT CASSETTE VALUE
 CASOUT	LD	(37E4H),A	; EXECUTE VALUE
 	LD	(PLAYR5),A	; PUT VALUE IN PLACE
 	RET
 SEEXEC	RET			; TO BE DEFINED !!
 SOEXEC	RET			; TO BE DEFINED !!
 STEXEC	LD	A,1		; STACCATO FLAG
 EMBOUT	LD	(PLAYR7),A	; PUT VALUE IN PLACE
 	RET
 TREXEC	RET			; TO BE DEFINED !!
 VIEXEC	LD	A,(VITIMB)	; VIOLIN TIMBRE TABLE
 TMBOUT	LD	(PLAYR9),A	; PUT TIMBRE IN PLACE
 	RET
 ;
 REFEXC	RET			; TO BE DEFINED !!
 ;
 ; PITCH AND LOOP VALUE TABLES; FROM THESE ARE CREATED
 ; THE FINAL TIMBRES AND VOLUMES TO BE SOUNDED.
 ;
 ;		* COMPLETE WAVEFORM TABLE *
 ;
 WAVTAB	DEFW	708	;A-0
 	DEFW	668	;A=0
 	DEFW	630	;A+0
 	DEFW	594	;B=0
 	DEFW	561	;B+0 DUMMY
 	DEFW	561	;C=0
 	DEFW	529	;C+0
 	DEFW	499	;D=0
 	DEFW	471	;D+0
 	DEFW	444	;E=0
 	DEFW	419	;E+0 DUMMY
 	DEFW	419	;F=0
 	DEFW	395	;F+0
 	DEFW	373	;G=0
 	DEFW	352	;G+0
 	DEFW	00	; BOGUS BYTES
 	DEFW	352	; SAME AS G+0
 	DEFW	332	;A=1
 	DEFW	313	;A+1
 	DEFW	295	;B=1
 	DEFW	278	;B+1 DUMMY
 	DEFW	278	;C=1
 	DEFW	263	;C+1
 	DEFW	248	;D=1
 	DEFW	233	;D+1
 	DEFW	220	;E=1
 	DEFW	209	;E+1 DUMMY
 	DEFW	209	;F=1
 	DEFW	196	;F+1
 	DEFW	184	;G=1
 	DEFW	174	;G+1
 	DEFW	00	; BOGUS BYTES
 	DEFW	174	; SAME AS G+1
 	DEFW	164	;A=2
 	DEFW	154	;A+2
 	DEFW	144	;B=2
 	DEFW	137	;B+2 DUMMY
 	DEFW	137	;C=2
 	DEFW	129	;C+2
 	DEFW	122	;D=2
 	DEFW	115	;D+2
 	DEFW	108	;E=2
 	DEFW	102	;E+2 DUMMY
 	DEFW	102	;F=2
 	DEFW	96	;F+2
 	DEFW	90	;G=2
 	DEFW	85	;G+2
 	DEFW	00	; BOGUS BYTES
 	DEFW	85	; SAME AS G+2
 	DEFW	80	;A=3
 	DEFW	74	;A+3
 	DEFW	70	;B=3
 	DEFW	66	;B+3 DUMMY
 	DEFW	65	;C=3
 	DEFW	61	;C+3
 	DEFW	58	;D=3
 	DEFW	54	;D+3
 	DEFW	51	;E=3
 	DEFW	48	;E+3 DUMMY
 	DEFW	48	;F=3
 	DEFW	45	;F+3
 	DEFW	42	;G=3
 	DEFW	39	;G+3
 	DEFW	00	; BOGUS BYTES
 	DEFW	39	; SAME AS G+3
 	DEFW	37	;A=4
 	DEFW	34	;A+4
 	DEFW	32	;B=4
 	DEFW	30	;B+4 DUMMY
 	DEFW	30	;C=4
 	DEFW	28	;C+4
 ;
 ;		* TOTAL MASTER LOOP TABLE *
 ;
 WVTAB1	DEFB	2	;A-0
 	DEFB	2	;A=0
 	DEFB	2	;A+0
 	DEFB	3	;B=0
 	DEFB	3	;B+0 DUMMY
 	DEFB	3	;C=0
 	DEFB	3	;C+0
 	DEFB	3	;D=0
 	DEFB	3	;D+0
 	DEFB	4	;E=0
 	DEFB	4	;E+0 DUMMY
 	DEFB	4	;F=0
 	DEFB	4	;F+0
 	DEFB	4	;G=0
 	DEFB	4	;G+0
 	DEFB	1	; BOGUS BYTES
 	DEFB	4	; SAME AS G+0
 	DEFB	5	;A=1
 	DEFB	5	;A+1
 	DEFB	5	;B=1
 	DEFB	6	;B+1 DUMMY
 	DEFB	6	;C=1
 	DEFB	6	;C+1
 	DEFB	6	;D=1
 	DEFB	7	;D+1
 	DEFB	7	;E=1
 	DEFB	7	;E+1 DUMMY
 	DEFB	7	;F=1
 	DEFB	8	;F+1
 	DEFB	8	;G=1
 	DEFB	9	;G+1
 	DEFB	1	; BOGUS BYTES
 	DEFB	9	; SAME AS G+1
 	DEFB	9	;A=2
 	DEFB	10	;A+2
 	DEFB	11	;B=2
 	DEFB	11	;B+2 DUMMY
 	DEFB	11	;C=2
 	DEFB	12	;C+2
 	DEFB	13	;D=2
 	DEFB	13	;D+2
 	DEFB	14	;E=2
 	DEFB	15	;E+2
 	DEFB	15	;F=2
 	DEFB	16	;F+2
 	DEFB	17	;G=2
 	DEFB	18	;G+2
 	DEFB	1	; BOGUS BYTES
 	DEFB	18	; SAME AS G+2
 	DEFB	19	;A=3
 	DEFB	20	;A+3
 	DEFB	21	;B=3
 	DEFB	23	;B+3
 	DEFB	23	;C=3
 	DEFB	24	;C+3
 	DEFB	25	;D=3
 	DEFB	27	;D+3
 	DEFB	28	;E=3
 	DEFB	30	;E+3 DUMMY
 	DEFB	30	;F=3
 	DEFB	32	;F+3
 	DEFB	34	;G=3
 	DEFB	36	;G+3
 	DEFB	1	; BOGUS BYTES
 	DEFB	36	; SAME AS G+3
 	DEFB	38	;A=4
 	DEFB	40	;A+4
 	DEFB	43	;B=4
 	DEFB	45	;B+4 DUMMY
 	DEFB	45	;C=4
 	DEFB	48	;C+4
 ;
 ; PLAYBACK EXECUTION ROUTINES ARE ENTERED FROM HERE
 ;
 PLAYEX	LD	A,(STORE3)	; "COMPILED" LOCATION
 	AND	A		; TEST IF COMPILED
 	JR	NZ,PLAYIT	; DO IT IF COMPILED
 NOCOMP	LD	HL,COMMSG	; GET "UNCOMPILED" MSG.
 	CALL	SHOW		; AND DISPLAY IT
 	JP	BASIC		; AND BACK TO BASIC
 PLAYIT	LD	HL,(40FDH)	; FIND BEG. OF COMP. CODE
 	LD	A,(HL)		; INDICATOR BYTE = AF
 	CP	0AFH		; CHECK IF "XOR A" CHAR.
 	JR	NZ,NOCOMP	; IF NOT AF, THEN ERROR
 	JP	(HL)		; AND GO TO ROUTINES
 COMMSG	DEFM	'SOURCE CODE NOT COMPILED'
 	DEFB	00H
 ;
 ; ALL EXECUTION INVOLVES TRANSFERRING INFORMATION FROM
 ; THE MUSIC BLOCK POINTER AREA TO THIS EXECUTION ROUTINE.
 ; THIS ROUTINE PLAYS THE NOTE FROM THE TABLE AND RETURNS.
 ;
 PLAYBK	PUSH	HL		; SAVE END PLAY AREA
 REPLAY	LD	IX,WAVTAB	; GET START OF WAVE TABLE
 	LD	A,(DE)		; GET PITCH VALUE
 	LD	(STORE0),A	; PUT IT FOR SAVING
 	SUB	11H		; STRIP EXTRA OFFSET
 	RLCA			; TIMES 2 ADDR. OFFSET
 	LD	B,0		; SET MSB OF OFFSET TO 0
 	LD	C,A		; MAKE LO OFFSET BYTE
 	ADD	IX,BC		; GET OFFSET POSITION
 	LD	A,(IX)		; GET VALUE AT IX
 	LD	(PLAYR0),A	; AND STASH IT AWAY
 	LD	A,(IX+1)	; GET SECOND TABLE BYTE
 	LD	(PLAYR0+1),A	; PLACE INTO PITCH AREA
 	LD	IX,WVTAB1	; GET LOOP TABLE READY
 	RRC	C		; DIVIDE BY TWO AGAIN
 	ADD	IX,BC		; GET OFFSET POSITION
 	LD	A,(IX)		; GET VALUE AT IX
 	LD	(PLAYR1),A	; AND STASH IT AWAY
 	LD	A,(IX+1)	; GET SECOND TABLE BYTE
 	LD	(PLAYR1+1),A	; AND STASH IT AWAY
 	INC	DE		; BUMP POINTER FORWARD
 	LD	A,(DE)		; GET RHYTHM VALUE
 	LD	(PLAYRA),A	; AND STASH IT AWAY
 	INC	DE		; BUMP DE TO NEXT POS'N
 ;
 ; CALCULATIONS USING TIMBRE TABLE ARE MADE FROM PLAYR0
 ; AREA.  RESULTS ARE TOP OF WAVE SOUND IN STOREC, BOTTOM
 ; OF WAVE SOUND IN STOREG.  CALCULATIONS USING RHYTHM
 ; VALUES ARE MADE FROM PLAYR2 AND PLAYR4.  RESULTS IS
 ; SINGLE VALUE COMBINING TEMPO MULTIPLIER PLAYR2 AND
 ; CURRENT ACCEL/DECEL STATUS (PLAYR4).
 ;
 	PUSH	DE		; SAVE MEMORY POINTER
 	LD	A,(PLAYR9)	; TIMBRE TABLE DIVISOR
 	LD	D,A		; AND SAVE TIMBRE DIV'R
 	LD	E,0		; CLEAR E TO ZERO
 	LD	HL,(PLAYR0)	; GET LOOP VALUE DIVIDEND
 	LD	B,8		; 16X8 BIT DIV COUNTER
 DVLOOP	XOR	A		; CLEAR CARRY FLAG
 	SBC	HL,DE		; BEGIN SUBTRACTIVE DIV.
 	INC	HL		; INCREMENT RESULT
 	JP	P,DVSKIP	; IF POS REMAINDER, AGAIN
 	ADD	HL,DE		; ELSE BRING BACK ABOVE 0
 	DEC	HL		; AND DECREMENT RESULT
 DVSKIP	ADD	HL,HL		; SHIFT BITS TO CONTINUE
 	DJNZ	DVLOOP		; DO IT 8 DIVISOR BITS
 	LD	H,0		; GET RID OF REMAINDER
 	LD	(PLAYR8),HL	; PUT IN TEMP WORKNG AREA
 	LD	(STOREC),HL	; SAVE OUTPUT CYCLE #1
 	PUSH	HL		; READY VALUE TO TRANSFER
 	POP	DE		; TRANSFER FOR SUBTRACT'N
 	LD	HL,(PLAYR0)	; GET LOOP VALUE DIVIDEND
 	SBC	HL,DE		; LOOP MINUS DUTY CYCLE
 	LD	(STOREG),HL	; SAVE SILENCE CYCLE #1
 ;
 ; PITCH DELAY AND REPETITION LOOPS HERE ARE COMPLETE FOR 
 ; SIMPLE TIMBRES.  MORE COMPLICATED ONES CAN BE ACHIEVED
 ; BY USING TWO DUTY CYCLES (TOP AND BOTTOM OF WAVEFORM)
 ; FOR EACH TIMBRE.  BASE RHYTHM IS PRESTO. MULTIPLICATION
 ; PERFORMED BELOW DERIVES THE FINAL TEMPO FROM PRESTO.
 ; TEST FOR ACCEL/DECEL IS DONE FIRST, THEN STACCATO TEST.
 ;
 	LD	A,(PLAYR2)	; GET TEMPO MULTIPLIER
 	LD	D,A		; SAVE IN D REGISTER
 	LD	A,(PLAYR4)	; GET ACCEL/DECEL VALUE
 	ADD	A,D		; GET NEW TOTAL VALUE
 	LD	(PLAYR2),A	; AND SAVE BACK IN MULT'R
 	LD	D,0		; SET D TO ZERO FOR MULT
 	LD	L,0		; SET L TO ZERO FOR MULT
 	LD	A,(PLAYRA)	; GET RAW RHYTHM FOR MULT
 	LD	H,A		; PUT IT IN H FOR 8X8
 	LD	A,(PLAYR2)	; GET TEMPO MULTIPLIER
 	CALL	MULTER		; RHYTHM SUBTOTAL
 	LD	L,0		; SET L TO ZERO FOR MULT
 	LD	A,(PLAYR1)	; GET WAVETABLE VALUE
 	LD	H,A		; PUT IT IN H FOR 8X8
 	LD	A,(STOREB)	; GET COMPOSITE MULTIP'R
 	CALL	MULTER		; CREATE COMP. PRODUCT
 	JR	SKIPB		; AND MOVE PAST SUBR.
 MULTER	LD	E,A		; PUT IT IN E FOR 8X8
 	LD	B,8		; NUMBER OF BITS IN 8X8
 MULTPY	ADD	HL,HL		; SHIFT TO MULTIPLY
 	JR	NC,NXTADD	; NEXT BIT IF FIRST DONE
 	ADD	HL,DE		; PRODUCE PARTIAL PROD
 NXTADD	DJNZ	MULTPY		; AND DO FOR ALL 8X8
 	LD	(STOREB),HL	; CREATE COMPOSITE DELAY
 	RET
 ;
 SKIPB	LD	A,(STORE0)	; GET STATUS OF REST
 	INC	A		; CHECK IF VALUE ZERO
 	JR	NZ,SKIPA	; SKIP PAST SILENT STUFF
 	LD	HL,0004H	; GET DELAY VALUE
 	LD	(STOREC),HL	; AND PUT IN PLACE
 	LD	(STOREG),HL	; AND PUT ANOTHER THERE
 	CALL	SILENT		; PLAY A REST IF ZERO
 	JR	SKIPZ		; OUT IF REST COMPLETE
 SKIPA	LD	A,(PLAYR7)	; GET STACCATO STATUS
 	AND	A		; LEGATO=0, STACCATO=1
 	PUSH	AF		; AND SAVE THEM AGAIN
 	CALL	Z,PLAYER	; PLAY NOTE IF ZERO
 	POP	AF		; RESTORE THE FLAGS
 	JR	Z,SKIPZ		; GO PAST DELAY IF ZERO
 	LD	HL,(STOREB)	; RHYTHMIC VALUE
 	XOR	A		; CLEAR CARRY FLAG
 	RR	H		; DIVIDE H BY TWO
 	RR	L		; DIVIDE L BY TWO
 	LD	(STOREB),HL	; AND SAVE BACK IN PLACE
 	CALL	PLAYER		; OUTPUT THE SOUND
 	CALL	SILENT		; PLAY THE SILENT CAL
 SKIPZ	POP	DE		; GET DE MEM PTR BACK
 	POP	HL		; RESTORE MEMORY AMOUNT
 	PUSH	HL		; AND SAVE IT AGAIN
 	DEC	HL		; BOUNCE IT ONE TEST BACK
 	XOR	A		; CLEAR CARRY FLAG
 	SBC	HL,DE		; CHECK FOR MEMORY LEFT
 	JP	P,REPLAY	; BACK IF STILL MEMORY
 	POP	HL		; ELSE CLEAR STACK OF MEM
 	RET			; AND BACK FOR MORE
 ;
 SILENT	LD	BC,(PLAYR3)	; GET OUTPUT PORT VALUE
 	PUSH	BC		; AND TEMP'Y SAVE IT
 	LD	BC,(PLAYR6)	; GET SECOND OUTPUT VAL.
 	PUSH	BC		; AND TEMP'Y SAVE IT
 	LD	BC,0000		; CLEAR BC TO ZERO
 	LD	(PLAYR3),BC	; SAVE THE SILENCE
 	LD	(PLAYR6),BC	; SAVE THAT SILENCE TOO
 	CALL	PLAYER		; AND PLAY THE SILENCE
 	POP	BC		; RESTORE ORIG PORT & VAL
 	LD	(PLAYR6),BC	; PUT BACK IN PLACE
 	POP	BC		; RESTORE SECOND ORIGINAL
 	LD	(PLAYR3),BC	; AND PUT THAT BACK TOO
 	RET			; BACK TO CALLING PROGRM.
 ;
 ; LOW-LEVEL MUSIC EXECUTION SUBROUTINE IS HERE.  T-STATES
 ; ARE SHOWN FOR EACH INSTRUCTION.  MINOR B-REGISTER LD
 ; ANOMOLY IS ADJUSTED FOR IN WAVEFORM TABLES.
 ;
 PLAYER	LD	HL,(STOREB)	;20 MAIN LOOP VALUE DELAY
 LOOPA	LD	BC,(PLAYR3)	;20 GET PORT AND VOLUME
 	LD	DE,(STOREC)	;20 TOP OF WAVE TO SOUND
 	OUT	(C),B		;12 OUTPUT SOUND VALUE
 LOOPB	DEC	DE		;6  BEGIN WAVEFORM DELAY
 	LD	A,D		;4  GET VALUE TO CHECK
 	OR	E		;4  IS IT FINISHED YET?
 	JP	NZ,LOOPB	;10 BACK UNTIL WAVE DONE
 	LD	BC,(PLAYR6)	;20 GET NEXT OUTPUT VALUE
 	LD	DE,(STOREG)	;20 BOTTOM OF SOUND WAVE
 	OUT	(C),B		;12 OUTPUT SOUND VALUE
 LOOPD	DEC	DE		;6  BEGIN WAVEFORM DELAY
 	LD	A,D		;4  GET VALUE TO CHECK
 	OR	E		;4  IS IT FINISHED YET?
 	JP	NZ,LOOPD	;10 BACK UNTIL WAVE DONE
 	DEC	HL		;6  MAIN LOOP VALUE CHECK
 	LD	A,H		;4  MAIN LOOP TO EVALUATE
 	OR	L		;4  IS NOTE COMPLETE YET?
 	JP	NZ,LOOPA	;10 BACK TO COMPLETE NOTE
 	LD	A,(3840H)	; IN FOR KEYBOARD CHECK
 	AND	A		; SEE IF KEY IS PRESSED
 	RET	Z		; GO ON BACK IF CLEAR
 	JP	BASIC		; ELSE OUT TO BASIC
 ;
 TAPEDP	EQU	$		; TEMPORARY
 	LD	HL,111H		; "LII BASIC" MESSAGE
 	CALL	SHOW		; TEMPORARY DISPLAY
 	JP	BASIC		; TO BASIC READY
 ;
 ZZZZZZ	EQU	$		; MARKER FOR END OF PROG
 ;
 	END	ENTRY		;
