; ptmenu/asm - kjw/bqsd - 10/82
;
	SUBTTL	'<PTMENU/ASM - Menu Selections>'
;
	PAGE
;
MENU	XOR	A		;main menu flag
	CALL	SETUPS		;set everything up
	RST	@08		;display following
;
	DEFB	CLSF		;clear screen
	DEFB	140
	DEFB	183
	DEFM	'  TOOL Selector  '
	DEFB	187
	DEFB	140
	DEFB	LF
;
	DEFB	LF
	DEFM	'Z - ZAP Tools'
	DEFB	TAB
	DEFM	'M - MEMORY Tools'
;
	DEFB	LF
	DEFM	'P - PURGE Tools'
	DEFB	TAB
	DEFM	'F - FILE Tools'
;
	DEFB	LF
	DEFM	'D - DISK FORMAT Tools'
	DEFB	TAB
	DEFM	'C - CONFIGURE System'
;
	DEFB	LF
	DEFM	'B - BACKUP Tool'
	DEFB	TAB
	DEFM	'E - EXIT PowerTOOL'
;
	DEFB	LF
	DEFM	'R - REPAIR Tools'
	DEFB	ETX
;
	LD	DE,MENUWHR	;selection jump table
	JP	GETSEL		;get user selection!
;
;	jump table for menu selections
;
MENUWHR	DEFB	'Z'
	DEFW	ZAP		;disk zap
	DEFB	'1'
	DEFW	ZAP
	DEFB	'P'
	DEFW	PURGE		;disk purge
	DEFB	'2'
	DEFW	PURGE
	DEFB	'D'
	DEFW	FORMAT		;disk format
	DEFB	'3'
	DEFW	FORMAT
	DEFB	'B'
	DEFW	COPY		;disk backup
	DEFB	'4'
	DEFW	COPY
	DEFB	'R'
	DEFW	REPAIR		;disk repair
	DEFB	'5'
	DEFW	REPAIR
	DEFB	'M'
	DEFW	MEMORY		;memory utilities
	DEFB	'7'
	DEFW	MEMORY
	DEFB	'F'
	DEFW	FILES		;file utilities
	DEFB	'8'
	DEFW	FILES
	DEFB	'C'
	DEFW	CONFIG		;configuration
	DEFB	'9'
	DEFW	CONFIG
	DEFB	'E'
	DEFW	EXIT		;exit program
	DEFB	'0'
	DEFW	EXIT
	DEFB	ETBL		;terminator
;
	PAGE
;
;	DISK ZAP Utility
;
ZAP	LD	A,1		;sub-menu flag
	LD	(TYPE),A	;save for $MODIFY
	CALL	SETUPS		;setup for menu action
	RST	@08		;display following
;
	DEFB	CLSF
	DEFB	140
	DEFB	183
	DEFM	'  ZAP Tools  '
	DEFB	187
	DEFB	140
	DEFB	LF
;
	DEFB	LF
	DEFM	'1.  Display Sectors'
	DEFB	TAB
	DEFM	'7.  Reverse Sector Data'
;
	DEFB	LF
	DEFM	'2.  Verify Sectors'
	DEFB	TAB
	DEFM	'8.  Exchange Sectors'
;
	DEFB	LF
	DEFM	'3.  Compare Sectors'
	DEFB	TAB
	DEFM	'9.  String Search'
;
	DEFB	LF
	DEFM	'4.  Copy Sectors'
	DEFB	TAB
	DEFM	'0.  Sector Search'
;
	DEFB	LF
	DEFM	'5.  Copy Sector Data'
	DEFB	TAB
	DEFM	'A.  Read ID Address Marks'
;
	DEFB	LF
	DEFM	'6.  Zero Sectors'
	DEFB	TAB
	DEFM	'B.  Alter DATA Address Marks'
	DEFB	ETX
;
	LD	DE,ZAPWHR	;jump vector table
	JP	GETSEL		;go selection!
;
ZAPWHR	DEFB	'1'
	DEFW	DISDSK		;display sectors
	DEFB	'2'
	DEFW	VERSEC		;verify sectors
	DEFB	'3'
	DEFW	COMSEC		;compare sectors
	DEFB	'4'
	DEFW	COPSEC		;copy sectors
	DEFB	'5'
	DEFW	SECDATA		;copy sector data
	DEFB	'6'
	DEFW	ZERSEC		;zero sectors
	DEFB	'7'
	DEFW	REVSEC		;reverse sectors
	DEFB	'8'
	DEFW	EXCSEC		;exchange sectors
	DEFB	'9'
	DEFW	STRSER		;string search
	DEFB	'0'
	DEFW	SECSER		;sector search
	DEFB	'A'
	DEFW	IDMARKS		;read ID marks
	DEFB	'B'
	DEFW	DAMARKS		;alter DATA marks
	DEFB	ETBL		;table terminator
;
	PAGE
;
;	DISK PURGE Utility
;
PURGE	LD	A,2		;sub-menu return flag
	CALL	SETUPS		;set it up
	RST	@08		;display following
;
	DEFB	CLSF
	DEFB	140
	DEFB	183
	DEFM	'  PURGE Tools  '
	DEFB	187
	DEFB	140
	DEFB	LF
;
	DEFB	LF
	DEFM	'1.  Kill Selected Files'
	DEFB	TAB
	DEFM	'6.  Zero Unused Entries'
;
	DEFB	LF
	DEFM	'2.  Kill by Category'
	DEFB	TAB
	DEFM	'7.  Zero Unused Granules'
;
	DEFB	LF
	DEFM	'3.  Remove System Files'
	DEFB	TAB
	DEFM	'8.  Change Disk Name'
;
	DEFB	LF
	DEFM	'4.  Remove All Passwords'
	DEFB	TAB
	DEFM	'9.  Change File Parameters'
;
	DEFB	LF
	DEFM	'5.  Disk Directory'
	DEFB	TAB
	DEFM	'0.  Check Directory'
	DEFB	ETX
;
	LD	DE,PURWHR	;jump table
	JP	GETSEL		;get choice
;
PURWHR	DEFB	'1'
	DEFW	DSKDIR		;kill selected files
	DEFB	'2'
	DEFW	KILLCAT		;kill by category
	DEFB	'3'
	DEFW	RSYST		;remove system files
	DEFB	'4'
	DEFW	RPASSW		;remove passwords
	DEFB	'5'
	DEFW	DIRLIST		;disk directory
	DEFB	'6'
	DEFW	ZUNUSE		;zero unused entries
	DEFB	'7'
	DEFW	ZUGRNS		;zero unused granules
	DEFB	'8'
	DEFW	CHDNAME		;change disk name
	DEFB	'9'
	DEFW	CHFILE		;change file params
	DEFB	'0'
	DEFW	CHKDIR		;check directory
	DEFB	ETBL
;
	PAGE
;
;	DISK FORMAT Utilities
;
FORMAT	LD	A,3		;for sub-menu return
	CALL	SETUPS		;set it up
	LD	A,2		;for $MODIFY vector
	LD	(TYPE),A	;so it can $UPDATE
	RST	@08		;display menu
;
	DEFB	CLSF
	DEFB	140
	DEFB	183
	DEFM	'  FORMAT Tools  '
	DEFB	187
	DEFB	140
	DEFB	LF
;
	DEFB	LF
	DEFM	'1.  Standard Format'
	DEFB	TAB
	DEFM	'4.  Write Format Track'
;
	DEFB	LF
	DEFM	'2.  Format Without Erase'
	DEFB	TAB
	DEFM	'5.  Software Bulk Erase'
;
	DEFB	LF
	DEFM	'3.  Build Format Track'
	DEFB	ETX
;
	LD	DE,FMTWHR	;jump table
	JP	GETSEL		;get user selection
;
FMTWHR	DEFB	'1'
	DEFW	SFMT		;standard format
	DEFB	'2'
	DEFW	SFMTW		;standard w/o erase
	DEFB	'3'
	DEFW	DOBUILD		;build format track
	DEFB	'4'
	DEFW	WRBUILD		;write format track
	DEFB	'5'
	DEFW	BLKERAS		;bulk erase diskette
	DEFB	ETBL		;term
;
	PAGE
;
;	DISK BACKUP Utilities
;
COPY	LD	A,4		;sub-menu vector
	CALL	SETUPS		;set it up
	RST	@08		;display menu
;
	DEFB	CLSF
	DEFB	140
	DEFB	183
	DEFM	'  BACKUP Tool  '
	DEFB	187
	DEFB	140
	DEFB	LF
	DEFB	LF
	DEFB	ETX
;
	JP	SCOPY		;go standard copy
;
	PAGE
;
;	DISK REPAIR Utilities
;
REPAIR	LD	A,5		;sub-menu vector return
	CALL	SETUPS		;set it up
	RST	@08		;display menu
;
	DEFB	CLSF
	DEFB	140
	DEFB	183
	DEFM	'  REPAIR Tools  '
	DEFB	187
	DEFB	140
	DEFB	LF
;
	DEFB	LF
	DEFM	'1.  Repair GAT Sector'
	DEFB	TAB
	DEFM	'6.  Recover Killed Files'
;
	DEFB	LF
	DEFM	'2.  Repair HIT Sector'
	DEFB	TAB
	DEFM	'7.  Move Directory'
;
	DEFB	LF
	DEFM	'3.  Repair BOOT Sector'
	DEFB	TAB
	DEFM	'8.  Display Directory'
;
	DEFB	LF
	DEFM	'4.  Read-Protect Directory'
	DEFB	TAB
	DEFM	'9.  Check Directory'
;
	DEFB	LF
	DEFM	'5.  Un-Read Protect Directory'
	DEFB	TAB
	DEFM	'0.  Clear Unused Entries'
	DEFB	ETX
;
	LD	DE,REPWHR	;jump table
	JP	GETSEL		;get user choice
;
REPWHR	DEFB	'1'
	DEFW	REPGAT		;repair GAT
	DEFB	'2'
	DEFW	REPHIT		;repair HIT
	DEFB	'3'
	DEFW	REPBOOT		;repair BOOT
	DEFB	'4'
	DEFW	RPDIR		;read protect dir
	DEFB	'5'
	DEFW	URPDIR		;un-read protect dir
	DEFB	'6'
	DEFW	DSKDIR		;recover killed files
	DEFB	'7'
	DEFW	MOVEDIR		;move directory
	DEFB	'8'
	DEFW	DIRLIST		;display directory
	DEFB	'9'
	DEFW	CHKDIR		;check directory
	DEFB	'0'
	DEFW	ZUNUSE		;zero unused entries
	DEFB	ETBL		;term
;
	PAGE
;
;	MEMORY Utilities
;
MEMORY	LD	A,7		;sub-menu vector
	CALL	SETUPS		;set it up
	LD	A,2		;for $MODIFY
	LD	(TYPE),A	;and $UPDATE
	RST	@08		;display menu
;
	DEFB	CLSF
	DEFB	140
	DEFB	183
	DEFM	'  MEMORY Tools  '
	DEFB	187
	DEFB	140
;
	DEFB	LF
	DEFM	'1.  Display Memory'
	DEFB	TAB
	DEFM	'9.  String Search'
;
	DEFB	LF
	DEFM	'2.  Move Memory'
	DEFB	TAB
	DEFM	'0.  Input Byte from Port'
;
	DEFB	LF
	DEFM	'3.  Exchange Memory'
	DEFB	TAB
	DEFM	'A.  Output Byte to Port'
;
	DEFB	LF
	DEFM	'4.  Compare Memory'
	DEFB	TAB
	DEFM	'B.  Memory to Sectors'
;
	DEFB	LF
	DEFM	'5.  Fill Memory'
	DEFB	TAB
	DEFM	'C.  Sectors to Memory'
;
	DEFB	LF
	DEFM	'6.  Reverse Memory'
	DEFB	TAB
	DEFM	'D.  Memory to Track'
;
	DEFB	LF
	DEFM	'7.  Test Memory'
	DEFB	TAB
	DEFM	'E.  Track to Memory'
;
	DEFB	LF
	DEFM	'8.  Jump to Memory'
	DEFB	ETX
;
	LD	DE,MEMWHR	;jump table
	JP	GETSEL		;get user choice
;
MEMWHR	DEFB	'1'
	DEFW	DISMEM		;display memory
	DEFB	'2'
	DEFW	MOVMEM		;move memory
	DEFB	'3'
	DEFW	EXCMEM		;exchange memory
	DEFB	'4'
	DEFW	COMMEM		;compare memory
	DEFB	'5'
	DEFW	FILLMEM		;fill memory
	DEFB	'6'
	DEFW	REVMEM		;reverse memory
	DEFB	'7'
	DEFW	TESTMEM		;test memory
	DEFB	'8'
	DEFW	JUMPMEM		;jump to memory
	DEFB	'9'
	DEFW	MSTRSER		;string search memory
	DEFB	'0'
	DEFW	INPORT		;input from port
	DEFB	'A'
	DEFW	OUTPORT		;output to port
	DEFB	'B'
	DEFW	MEM2SEC		;memory to sectors
	DEFB	'C'
	DEFW	SEC2MEM		;sectors to memory
	DEFB	'D'
	DEFW	MEM2TRK		;memory to track
	DEFB	'E'
	DEFW	TRK2MEM		;track to memory
	DEFB	ETBL
;
	PAGE
;
;	FILE Utilities
;
FILES	LD	A,8		;for sub-menu vector
	CALL	SETUPS		;set it up
	LD	A,3		;for $MODIFY
	LD	(TYPE),A	;in display files
	RST	@08		;display menu
;
	DEFB	CLSF
	DEFB	140
	DEFB	183
	DEFM	'  FILE Tools  '
	DEFB	187
	DEFB	140
	DEFB	LF
;
	DEFB	LF
	DEFM	'1.  Display File Sectors'
	DEFB	TAB
	DEFM	'7.  File Locations'
;
	DEFB	LF
	DEFM	'2.  Compare Files'
	DEFB	TAB
	DEFM	'8.  Drive Status'
;
	DEFB	LF
	DEFM	'3.  Copy Files'
	DEFB	TAB
	DEFM	'9.  Sector Allocation'
;
	DEFB	LF
	DEFM	'4.  Disk Directory'
	DEFB	TAB
	DEFM	'0.  Build File'
;
	DEFB	LF
	DEFM	'5.  Free Space'
	DEFB	TAB
	DEFM	'A.  Clear File'
;
	DEFB	LF
	DEFM	'6.  Offset File'
	DEFB	TAB
	DEFM	'B.  Disk Allocation'
;
	DEFB	ETX
;
	LD	DE,FILWHR	;jump table
	JP	GETSEL		;get user choice
;
FILWHR	DEFB	'1'
	DEFW	DISFILE		;display file sectors
	DEFB	'2'
	DEFW	COMFILE		;compare files
	DEFB	'3'
	DEFW	COPFILE		;copy files
	DEFB	'4'
	DEFW	DIRLIST		;disk directory
	DEFB	'5'
	DEFW	DSKFREE		;free space
	DEFB	'6'
	DEFW	OFSFILE		;offset file
	DEFB	'7'
	DEFW	FILEMAP		;file locations
	DEFB	'8'
	DEFW	DRVSTAT		;drive status
	DEFB	'9'
	DEFW	SECALLO		;sector allocations
	DEFB	'0'
	DEFW	CREATF		;create file
	DEFB	'A'
	DEFW	CLEARFL		;clear file
	DEFB	'B'
	DEFW	DALLOC		;disk allocation
	DEFB	'C'
	DEFW	CHASH		;compute hash code
	DEFB	'D'
	DEFW	CPASSW		;compute password
	DEFB	ETBL		;terminator
;
