; ptld81/asm - kjw/bqsd - 11/82
;
	TITLE	'<PowerTOOL Loader 80 Track I>'
;
;	equates
;
BUFFER	EQU	5000H-500H	;end of buff-length
FDC	EQU	37ECH		;FDC command/status
TRACK	EQU	37EDH		;FDC track register
SECTOR	EQU	37EEH		;FDC sector register
XFER	EQU	37EFH		;FDC transfer register
SELFDC	EQU	37E1H		;FDC select register
;
CLEAR	EQU	0D0H		;fdc reset command
ETX	EQU	000H		;end of text marker
DRIVE	EQU	001H		;drive select code
;
	ORG	4500H		;start loader
;
;	head is over track one, read ID marks
;
ENTRY	CALL	STEPIT		;step 1 track
	CALL	IDMARKS		;read id marks
	AND	8FH		;none of these can be set
	JP	NZ,LERROR	;protection error!
;
	CALL	STEPIN		;move head to track 2
;
;	sectors are protected here, check 'em out
;
	CALL	PROTECT		;check protection
;
	CALL	STEPIN		;move head to track 3
	CALL	IDMARKS		;read ID marks 1 time
	SUB	55H		;lowest possible value
	JP	C,LERROR	;go if error
	CP	23H		;max value now
	JP	NC,LERROR	;go if error!
;
;	begin program load here
;
	LD	HL,0		;init buffer
	LD	IY,0		;init checksum
	EXX			;save here
;
LOAD	CALL	BYTE		;fetch a byte
	LD	B,A		;msb header
	CALL	BYTE		;fetch another
	LD	C,A		;lsb header
;
	CALL	BYTE		;fetch byte
	LD	H,A		;msb address
	CALL	BYTE		;fetch byte
	LD	L,A		;lsb address
;
	LD	A,B		;get bytes
	AND	C		;check for 0000 entry
	JR	NZ,LOAD1	;go if nz
	OR	B		;check for 0000
	OR	C		;any bits at all?
	JP	NZ,LERROR	;go data error
;
;	hl = entry point, verify checksum
;
	PUSH	HL		;save entry
	CALL	BYTE		;fetch a byte
	LD	H,A		;save MSB cksum
	CALL	BYTE		;fetch byte
	LD	L,A		;pass LSB cksum
	PUSH	IY		;IY = checksum
	POP	DE		;DE = checksum
	OR	A		;clear carry flag
	SBC	HL,DE		;test checksum
	JP	NZ,LERROR	;go checksum error
;
	RET			;go program!
;
LOAD1	INC	A		;A=0?
	JP	NZ,LERROR	;data error!
;
	CALL	BYTE		;fetch block length
	LD	B,A		;pass MSB
	CALL	BYTE		;fetch reset
	LD	C,A		;pass LSB
;
	CALL	BYTE		;fetch checksum byte
	LD	(CODE),A	;save code
	LD	IX,0		;init sector checksum
;
LOADIT	CALL	BYTE		;fetch a byte
	XOR	'$'		;de-code it
CODE	EQU	$-1
	LD	E,A		;pass for checksum
	LD	(HL),A		;to buffer
	CP	(HL)		;still there?
	JP	NZ,MERROR	;nope, memory error
	INC	HL		;bump buffer
	LD	D,0		;DE = checksum
	ADD	IX,DE		;add to sector checksum
	ADD	IY,DE		;add to program checksum
	DEC	BC		;less byte count
	LD	A,B		;any more?
	OR	C		;any bits on?
	JR	NZ,LOADIT	;go if more to do
;
;	check block checksum
;
	CALL	BYTE		;fetch a byte
	LD	B,A		;save it
	CALL	BYTE		;fetch another
	LD	C,A		;BC = checksum from disk
	PUSH	IX		;pass checksum to HL
	POP	HL		;HL = computed checksum
	OR	A		;clear carry
	SBC	HL,BC		;compare
	JP	NZ,LERROR	;checksum error!
	JR	LOAD		;else go next block
;
;	fetch byte from disk
;
BYTE	EXX			;swap back
	LD	A,H		;check for read
	OR	L		;anything?
	JR	NZ,BYTEIN	;yes, in memory
;
;	read in all 3 sectors
;
	LD	HL,DERROR	;disk error vector
	PUSH	HL		;save on stack
	LD	HL,BUFFER	;start of buffer
	LD	E,55H		;first sector
	CALL	READ		;read it
	RET	NZ		;error!
	INC	H		;bump buffer
	INC	H		;512 bytes
	LD	E,66H		;second sector
	CALL	READ		;read it
	RET	NZ		;go if error!
	INC	H		;bump buffer
	INC	H		;512 bytes again
	LD	E,77H		;third sector
	CALL	READ		;read it
	RET	NZ		;go if error
	POP	DE		;remove vector
	CALL	STEPIN		;step in a track
	CALL	ADJUST		;adjust buffer order
	LD	HL,BUFFER	;reset buffer
;
BYTEIN	LD	B,(HL)		;get the byte
	INC	HL		;bump buffer
	LD	A,H		;get msb
	CP	50H		;end of buffer?
	JR	C,BYTEOK	;nope, continue
	LD	HL,0		;force read next time
;
BYTEOK	LD	A,B		;get byte
	EXX			;swap back
	RET			;A = byte
;
;	select disk drive
;
SELECT	LD	A,DRIVE		;drive select code
	LD	(SELFDC),A	;select drive
	RET			;else done!
;
;	move head in one track
;
STEPIN	CALL	STEPIT		;step twice
STEPIT	CALL	SELECT		;select drive
	LD	A,50H		;step in command
	CALL	SLOW		;issue and wait
;
STEPWT	CALL	SELECT		;keep drive selected
	LD	A,(FDC)		;read status
	RRCA			;command pending?
	JR	C,STEPWT	;wait for it
	RET			;else done!
;
;	read sector on current track
;
READ	CALL	READ1		;read sector
	RET	Z		;return if no error
;
	LD	A,CLEAR		;reset FDC
	LD	(FDC),A		;reset it
	CALL	READ1		;read again
	RET	Z		;no error
;
READER	LD	A,CLEAR		;reset FDC
	LD	(FDC),A		;reset it
;
READ1	PUSH	HL		;save buffer
	CALL	READ2		;read it
	POP	HL		;restore
	RET			;return with error
;
READ2	CALL	SELECT		;select drive
	LD	A,E		;get track/sector
	LD	(TRACK),A	;to FDC track reg
	LD	(SECTOR),A	;to FDC sector reg
	LD	A,88H		;read command
;
READX	EX	AF,AF'		;save command
	CALL	SELECT		;select drive
	EX	AF,AF'		;get command back
	CALL	SLOW		;issue and wait
	JR	READ4		;continue
;
READ3	RRCA			;command done?
	JR	NC,READ5	;go if done
;
READ4	LD	A,(FDC)		;read status
	BIT	1,A		;byte ready?
	JR	Z,READ3		;wait if not
;
	LD	A,(XFER)	;read byte
	LD	(HL),A		;to buffer
	INC	HL		;bump pointer
	JR	READ4		;continue
;
READ5	LD	A,(FDC)		;read result
	OR	A		;any errors?
	RET			;return with status
;
;	issue disk command and wait
;
SLOW	LD	(FDC),A		;issue disk command
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	RET
;
;	read ID marks from disk
;
IDMARKS	CALL	READID		;read ID mark
	CALL	NZ,READID	;try again
	CALL	NZ,READID	;try again
	JR	NZ,LERROR	;go if error
;
	LD	HL,BUFFER	;init address
	LD	A,(HL)		;get track #
	INC	HL		;bump pointer
	OR	(HL)		;get head #
	INC	HL		;bump buffer
	OR	(HL)		;get sector #
	RET			;return with it
;
READID	LD	HL,BUFFER	;I/O buffer
	LD	A,0C0H		;read ID command
	JR	READX		;read marks
;
;	check protection on diskette
;
PROTECT	LD	HL,BUFFER	;reset buffer
	LD	E,11H		;sector #
	CALL	READER		;read it
	CP	08H		;must be CRC error
	JR	NZ,LERROR	;ident error!
;
	LD	E,22H		;sector #
	CALL	READER		;read it
	CP	18H		;must be NF/CRC errors
	RET	Z		;return if OK
	JR	LERROR		;go id error
;
;	adjust load buffer to correct format
;
ADJUST	LD	HL,BUFFER	;start of buffer
	LD	C,5		;5 pages long
;
ADJLP	PUSH	HL		;save buffer
	CALL	ADJIT		;adjust this page
	POP	HL		;restore buffer
	INC	H		;bump page
	DEC	C		;less this page
	JR	NZ,ADJLP	;go for # pages
	RET			;done!
;
ADJIT	PUSH	HL		;save start
	LD	DE,0FFH		;length -1
	ADD	HL,DE		;HL => end
	POP	DE		;DE => start
	LD	B,80H		;1/2 length
;
SWAP	LD	A,(HL)		;get a byte
	EX	AF,AF'		;save it
	LD	A,(DE)		;get second byte
	LD	(HL),A		;swap with first
	EX	AF,AF'		;get first back
	LD	(DE),A		;swap with second
	DEC	HL		;end -1
	INC	DE		;start +1
	DJNZ	SWAP		;go till end
	RET			;done
;
;	error vectors
;
LERROR	LD	DE,LMSG		;load file format!
	JR	ERROR		;go dummy
;
DERROR	LD	DE,DMSG		;disk error
	JR	ERROR		;go common
;
MERROR	LD	DE,MMSG		;memory error
;
ERROR	LD	HL,3C00H	;start of video
	CALL	PRINT		;display it
	LD	DE,MSG		;error
	CALL	PRINT		;display it
;
HOLD	LD	A,(3840H)	;read keyboard
	RRCA			;enter pressed?
	JR	NC,HOLD		;wait till yes
	HALT			;re-boot I
;
PRINT	LD	A,(DE)		;get string byte
	OR	A		;end of message
	RET	Z		;yes, done!
	INC	DE		;bump message
	LD	(HL),A		;to video
	CP	(HL)		;still there?
	JR	Z,PRTOK		;yes, go!
	SUB	20H		;make upper case
	LD	(HL),A		;back to video
PRTOK	INC	HL		;bump video
	JR	PRINT		;go next char
;
DMSG	DEFM	'Disk',ETX
MMSG	DEFM	'Memory',ETX
LMSG	DEFM	'Data',ETX
MSG	DEFM	' Error',5FH,ETX
;
ZZZZZ	EQU	$
	END	ENTRY
