; ptld43/asm - kjw/bqsd - 11/82
;
	TITLE	'<PowerTOOL Loader 40 Track III>
;
;	equates
;
BUFFER	EQU	5000H-500H	;end of buff-length
NMI	EQU	0E4H		;NMI control port
FDC	EQU	0F0H		;FDC command/status
TRACK	EQU	0F1H		;FDC track register
SECTOR	EQU	0F2H		;FDC sector register
XFER	EQU	0F3H		;FDC transfer register
SELFDC	EQU	0F4H		;FDC select register
;
CLEAR	EQU	0D0H		;fdc reset command
ETX	EQU	000H		;end of text marker
DRIVE	EQU	081H		;drive select code
;
	ORG	4500H		;start loader
;
;	head is over track one, read ID marks
;
ENTRY	CALL	IDMARKS		;read id marks
	AND	8FH		;none of these can be set
	JP	NZ,LERROR	;protection error!
	LD	A,DRIVE		;reset double density
	LD	(DRIV),A	;save drive
;
	CALL	STEPIN		;move head to track 2
;
;	sectors are protected here, check 'em out
;
	CALL	PROTECT		;check protection
;
	CALL	STEPIN		;move head to track 3
	CALL	IDMARKS		;read ID marks 1 time
	SUB	55H		;lowest possible value
	JP	C,LERROR	;go if error
	CP	23H		;max value now
	JP	NC,LERROR	;go if error!
;
;	begin program load here
;
	LD	HL,0		;init buffer
	LD	IY,0		;init checksum
	EXX			;save here
;
LOAD	CALL	BYTE		;fetch a byte
	LD	B,A		;msb header
	CALL	BYTE		;fetch another
	LD	C,A		;lsb header
;
	CALL	BYTE		;fetch byte
	LD	H,A		;msb address
	CALL	BYTE		;fetch byte
	LD	L,A		;lsb address
;
	LD	A,B		;get bytes
	AND	C		;check for 0000 entry
	JR	NZ,LOAD1	;go if nz
	OR	B		;check for 0000
	OR	C		;any bits at all?
	JP	NZ,LERROR	;go data error
;
;	hl = entry point, verify checksum
;
	PUSH	HL		;save entry
	CALL	BYTE		;fetch a byte
	LD	H,A		;save MSB cksum
	CALL	BYTE		;fetch byte
	LD	L,A		;pass LSB cksum
	PUSH	IY		;IY = checksum
	POP	DE		;DE = checksum
	OR	A		;clear carry flag
	SBC	HL,DE		;test checksum
	JP	NZ,LERROR	;go checksum error
;
	RET			;go program!
;
LOAD1	INC	A		;A=0?
	JP	NZ,LERROR	;data error!
;
	CALL	BYTE		;fetch block length
	LD	B,A		;pass MSB
	CALL	BYTE		;fetch reset
	LD	C,A		;pass LSB
;
	CALL	BYTE		;fetch checksum byte
	LD	(CODE),A	;save code
	LD	IX,0		;init sector checksum
;
LOADIT	CALL	BYTE		;fetch a byte
	XOR	'$'		;de-code it
CODE	EQU	$-1
	LD	E,A		;pass for checksum
	LD	(HL),A		;to buffer
	CP	(HL)		;still there?
	JP	NZ,MERROR	;nope, memory error
	INC	HL		;bump buffer
	LD	D,0		;DE = checksum
	ADD	IX,DE		;add to sector checksum
	ADD	IY,DE		;add to program checksum
	DEC	BC		;less byte count
	LD	A,B		;any more?
	OR	C		;any bits on?
	JR	NZ,LOADIT	;go if more to do
;
;	check block checksum
;
	CALL	BYTE		;fetch a byte
	LD	B,A		;save it
	CALL	BYTE		;fetch another
	LD	C,A		;BC = checksum from disk
	PUSH	IX		;pass checksum to HL
	POP	HL		;HL = computed checksum
	OR	A		;clear carry
	SBC	HL,BC		;compare
	JP	NZ,LERROR	;checksum error!
	JR	LOAD		;else go next block
;
;	fetch byte from disk
;
BYTE	EXX			;swap back
	LD	A,H		;check for read
	OR	L		;anything?
	JR	NZ,BYTEIN	;yes, in memory
;
;	read in all 3 sectors
;
	LD	HL,BUFFER	;start of buffer
	LD	E,55H		;first sector
	CALL	READ		;read it
	INC	H		;bump buffer
	INC	H		;512 bytes
	LD	E,66H		;second sector
	CALL	READ		;read it
	INC	H		;bump buffer
	INC	H		;512 bytes again
	LD	E,77H		;third sector
	CALL	READ		;read it
	CALL	STEPIN		;step in a track
	CALL	ADJUST		;adjust buffer order
	LD	HL,BUFFER	;reset buffer
;
BYTEIN	LD	B,(HL)		;get the byte
	INC	HL		;bump buffer
	LD	A,H		;get msb
	CP	50H		;end of buffer?
	JR	C,BYTEOK	;nope, continue
	LD	HL,0		;force read next time
;
BYTEOK	LD	A,B		;get byte
	EXX			;swap back
	RET			;A = byte
;
;	select disk drive
;
SELECT	LD	A,DRIVE.AND.7FH	;single density select
DRIV	EQU	$-1
	OUT	(SELFDC),A	;select drive
	RET			;else done!
;
;	move head in one track
;
STEPIN	CALL	SELECT		;select drive
	LD	A,50H		;step in command
	CALL	SLOW		;issue and wait
;
STEPWT	CALL	SELECT		;keep drive selected
	IN	A,(FDC)		;read status
	RRCA			;command pending?
	JR	C,STEPWT	;wait for it
	RET			;else done!
;
;	read sector on current track
;
SREAD	LD	A,080H		;FDC read command
	JR	SARD		;go common
;
AREAD	LD	A,0C0H		;FDC read id command
;
SARD	LD	(RDTYPE),A	;save type of read
;
	LD	A,10		;10 I/O tries
;
READ	EX	AF,AF'		;save # retries
	PUSH	HL		;save buffer
	CALL	READ1		;read the sector
	POP	HL		;restore
	RET	Z		;return if no error
;
	EX	AF,AF'		;get error counter
	DEC	A		;less this pass
	JR	NZ,READ		;go if more
	JP	DERROR		;go disk error
;
READ1	CALL	SELECT		;select drive
	LD	A,E		;get track/sector
	OUT	(TRACK),A	;to FDC track reg
	OUT	(SECTOR),A	;to FDC sector reg
;
	CALL	SELECT		;select drive
	LD	A,0C0H		;NMI command
	LD	BC,RETNMI	;return command
;
	LD	(SPSAVE),SP	;save stack pointer
	CALL	SETNMI		;setup NMI's
	LD	A,'$'		;fetch read command
RDTYPE	EQU	$-1
	CALL	SLOW		;issue and wait
;
READ3	IN	A,(FDC)		;read status
	AND	2		;bit 1, byte ready?
	JR	Z,READ3		;wait if not
	INI			;read the byte
	LD	A,(DRIV)	;get drive select code
	OR	40H		;set wait states
READ4	OUT	(SELFDC),A	;go wait states
	INI			;read a byte
	JR	READ4		;go next byte
;
RETNMI	XOR	A		;load zero
	LD	BC,NMIRET	;non-disk NMI's
	CALL	SETNMI		;disable NMI
	IN	A,(FDC)		;read status
	OR	A		;any errors?
	PUSH	AF		;save result
	LD	A,CLEAR		;reset FDC
	OUT	(FDC),A		;reset it
	POP	AF		;restore status
	LD	SP,$		;reset stack
SPSAVE	EQU	$-2
	RET			;return to caller
;
NMIRET	RETN			;non-disk NMI
;
SETNMI	LD	(404AH),BC	;save vector
	OUT	(NMI),A		;issue NMI command
	LD	C,XFER		;transfer port
	RET			;done
;
;	issue disk command and wait
;
SLOW	OUT	(FDC),A		;issue disk command
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	RET
;
;	read ID marks from disk
;
IDMARKS	LD	HL,BUFFER	;init address
	CALL	AREAD		;read ID marks
;
	LD	A,(HL)		;get track #
	INC	HL		;bump pointer
	OR	(HL)		;get head #
	INC	HL		;bump buffer
	OR	(HL)		;get sector #
	RET			;return with it
;
;
;	check protection on diskette
;
PROTECT	LD	HL,BUFFER	;reset buffer
	LD	E,33H		;sector #
	CALL	READ1		;read it
	CP	08H		;must be CRC error
	JR	NZ,LERROR	;ident error!
;
	LD	E,44H		;sector #
	CALL	READ1		;read it
	CP	18H		;must be NF/CRC errors
	RET	Z		;return if OK
	JR	LERROR		;go id error
;
;	adjust load buffer to correct format
;
ADJUST	LD	HL,BUFFER	;start of buffer
	LD	C,5		;5 pages long
;
ADJLP	PUSH	HL		;save buffer
	CALL	ADJIT		;adjust this page
	POP	HL		;restore buffer
	INC	H		;bump page
	DEC	C		;less this page
	JR	NZ,ADJLP	;go for # pages
	RET			;done!
;
ADJIT	PUSH	HL		;save start
	LD	DE,0FFH		;length -1
	ADD	HL,DE		;HL => end
	POP	DE		;DE => start
	LD	B,80H		;1/2 length
;
SWAP	LD	A,(HL)		;get a byte
	EX	AF,AF'		;save it
	LD	A,(DE)		;get second byte
	LD	(HL),A		;swap with first
	EX	AF,AF'		;get first back
	LD	(DE),A		;swap with second
	DEC	HL		;end -1
	INC	DE		;start +1
	DJNZ	SWAP		;go till end
	RET			;done
;
;	error vectors
;
LERROR	LD	DE,LMSG		;load file format!
	JR	ERROR		;go dummy
;
DERROR	LD	DE,DMSG		;disk error
	JR	ERROR		;go common
;
MERROR	LD	DE,MMSG		;memory error
;
ERROR	LD	HL,3C00H	;start of video
	CALL	PRINT		;display it
	LD	DE,MSG		;error
	CALL	PRINT		;display it
;
HOLD	LD	A,(3840H)	;read keyboard
	RRCA			;enter pressed?
	JR	NC,HOLD		;wait till yes
	RST	0		;re-boot III
;
PRINT	LD	A,(DE)		;get string byte
	OR	A		;end of message
	RET	Z		;yes, done!
	INC	DE		;bump message
	LD	(HL),A		;to video
	INC	HL		;bump video
	JR	PRINT		;go next char
;
DMSG	DEFM	'Disk',ETX
MMSG	DEFM	'Memory',ETX
LMSG	DEFM	'Data',ETX
MSG	DEFM	' Error',5FH,ETX
;
ZZZZZ	EQU	$
	END	ENTRY
