; ptformc/asm - kjw/bqsd - 10/82
;
	PAGE
;
	SUBTTL	'<PTFORMC/ASM - Disk Format Section C>'
;
LOKGRAN	PUSH	HL		;save it
	PUSH	DE		;save track/sector
	LD	H,GATBUFF<-8	;get MSB gat table
	LD	L,D		;HL => cylinder byte
	LD	A,E		;get sector to lock
	LD	D,1		;set gran 0 bit
;
LOKDL	SUB	(IY+8)		;less sectors/gran
	JP	M,LOKDF		;found it
	SLA	D		;move lock bit
	JR	LOKDL		;continue
;
LOKDF	LD	A,(HL)		;get the byte
	OR	D		;lock the gran
	LD	(HL),A		;put it back
	EX	AF,AF'		;save byte
	LD	DE,60H		;offset to lockout table
	ADD	HL,DE		;HL => lockout byte
	EX	AF,AF'		;get lockout byte back
	LD	(HL),A		;save into table
;
LOKFIN	POP	DE		;get track/sector back
	POP	HL		;this too
	RET
;
	PAGE
;
;	$NEXGRAN - advance DE to start next gran
;
NEXGRAN	PUSH	DE		;save track sector
	LD	A,E		;get sector number
	LD	E,1		;starting gran # +1
;
NEXGLX	SUB	(IY+8)		;less sectors/gran
	JP	M,NEXGLY	;go if found
	INC	E		;bump gran counter
	JR	NEXGLX		;continue
;
NEXGLY	PUSH	DE		;save on stack
	CALL	FIRSTS		;load E with first sector
	LD	A,E		;get first sector
	POP	DE		;gran offset in E
;
NEXGLZ	ADD	A,(IY+8)	;offset to next gran
	DEC	E		;less gran offset
	JR	NZ,NEXGLZ	;go till found
;
	POP	DE		;restore track/sector
	LD	E,A		;E = next gran start
;
;	check if E is beyond track end
;
	LD	A,(IY+6)	;highest sector track 0
	INC	D		;on track 0?
	DEC	D		;yes?
	JR	Z,NEXGLW	;yes, go!
	LD	A,(IY+7)	;highest sector disk
;
NEXGLW	CP	E		;in range?
	RET	NC		;yes, go!
	LD	E,A		;E = highest sector
	JP	NEXSEC		;go to next track & ret.
;
	PAGE
;
;	$BULKGO - begin erasing diskette
;
BULKGO	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	DSTAT		;drive ready?
	RET	NZ		;skip if not!
;
	CALL	RESTORE		;move head to track 0
	RET	NZ		;not in system
;
	LD	HL,BUFFER	;setup buffer
	LD	(FMTBUFF),HL	;for format buffer
	CALL	CLRBUFF		;clear buffer to zeroes
;
;	loop to format with all zeroes
;
BULKLP	LD	BC,(FMTBUFF)	;get I/O buffer
	CALL	SHOFMT		;write track with display
;
	LD	A,(IY+2)	;get current track
	CP	(IY+0)		;at last track now?
	RET	Z		;yes, done with disk!
;
	CALL	STEPIN		;step to next track
	RET	NZ		;error!
	JR	BULKLP		;else do next track
;
;	bulk erase diskettes!
;
BLKERAS	RST	@08		;give warning message
;
	DEFB	LF
	DEFM	'Be CAREFUL !!'
	DEFB	ETX
;
	CALL	GETDRVS		;ask for which drive(s)
	LD	DE,BULKGO	;subroutine vector
	LD	BC,GOBACK	;completion vector
	JP	DRVCOMM		;do all indicated drives
;
	PAGE
;
;	patterns to use when formatting
;	data loaded into all empty sectors
;
SPATTRN	DEFB	0E5H,0E5H,0E5H,0E5H
	DEFB	0E5H,0E5H,0E5H,0E5H
	DEFB	0E5H,0E5H,0E5H,0E5H
	DEFB	0E5H,0E5H,0E5H,0E5H
;
DPATTRN	DEFB	06DH,0B6H,06DH,0B6H
	DEFB	06DH,0B6H,06DH,0B6H
	DEFB	06DH,0B6H,06DH,0B6H
	DEFB	06DH,0B6H,06DH,0B6H
;
	PAGE
;
;	$CLRBUFF - clear out format buffer
;
;	fill buffer with zeroes in perparation for format
;
CLRBUFF	CALL	SAVEREG		;save registers
;
	LD	HL,(FMTBUFF)	;get format buff start
	LD	D,H		;pass start to DE
	LD	E,L		;DE = buffer start
	INC	DE		;DE = start +1
	LD	BC,2000H	;length to fill
	LD	(HL),0		;load one zero
	LDIR			;load all zeroes
	RET			;done, buffer cleared
;
	PAGE
;
;	$COMPCOD - compute differences between
;		   password encoding between dos's
;
COMPCOD	PUSH	AF		;save flag
	LD	A,(IY+5)	;get dos type
	AND	60H		;trsdos double den?
	JR	NZ,COMPCD3	;yes, go!
;
	ADD	HL,HL		;finish it off
	ADD	HL,HL
;
	POP	AF
	RET
;
COMPCD3	SBC	HL,DE		;finish it off
;
	POP	AF
	RET
;
