; ptbt1 - kjw/bqsd - 11/82
;
	TITLE	'<PowerTOOL Boot I>'
;
;	This program will locate at Track 0/Sector 0
;	in single density.  It will read in a rather
;	'unusual' manner the 'true' loader which
;	will reside on track 1, at sectors 20H & 40H
;	The sectors will be have Track/Head/Sector
;	numbers all the same
;
;	equivalences
;
CLS	EQU	01C9H		;ROM cls routine
VIDEO	EQU	3C00H		;start of video
KEYBRD	EQU	3840H		;last row keyboard
DELAY	EQU	0060H		;dec BC till 0
;
FDC	EQU	37ECH		;FDC command/status reg.
TRACK	EQU	37EDH		;FDC track register
SECTOR	EQU	37EEH		;FDC sector register
XFER	EQU	37EFH		;FDC transfer register
SELFDC	EQU	37E1H		;FDC select register
;
DRIVE	EQU	001H		;drive select code
SEEK	EQU	013H		;seek command
SREAD	EQU	088H		;read command
CLEAR	EQU	0D0H		;clear FDC
;
	ORG	4200H		;Mod I loader
;
ENTRY	LD	SP,STACK	;relocate stack
	CALL	CLS		;clear video screen
	DI			;leave off!
;
;	all register data loaded via POP's
;
	CALL	SEEK1		;head to track 1
	POP	HL		;I/O buffer
	POP	DE		;track/sector
	CALL	READ		;read sector
	JR	NZ,GOERR	;go if disk error
	POP	HL		;get next buffer
	POP	DE		;next sector
	CALL	READ		;read next sector
	RET	Z		;go loader if OK
GOERR	JR	ERROR		;go error
;
;	actual read routine
;	return/entry point on stack
;
;	ENT	HL => I/O buffer to use
;		DE = track/sector (from ID field)
;
;	EXT	return made via stack
;		first pass a CALL is on stack
;		second pass, stack overflow fetchs
;		the entry point from init table
;
READ	PUSH	HL		;save buffer address
	CALL	READ1		;try once
	POP	BC		;restore buffer
	RET	Z		;no error, return
	LD	H,B		;pass buffer back to HL
	LD	L,C		;HL => I/O buffer
	LD	A,CLEAR		;reset FDC
	LD	(FDC),A		;clear it
;
READ1	CALL	SELECT		;select drive 0
	LD	A,E		;get sector
	LD	(SECTOR),A	;to FDC sector reg
	LD	A,D		;get track
	LD	(TRACK),A	;to FDC track reg
;
	CALL	SELECT		;select drive
	LD	A,SREAD		;read command
	CALL	SLOW		;issue and delay
;
RDL1	LD	A,(FDC)		;read FDC status
	BIT	1,A		;byte ready?
	JR	NZ,RDL2		;get it if yes
	RRCA			;still in progress?
	JR	C,RDL1		;continue if yes
;
;	command done, fetch status
;
	LD	A,(FDC)		;fetch status
	OR	A		;any error?
	RET			;return with status
;
RDL2	LD	A,(XFER)	;read FDC byte
	RRD			;put into buffer
;
RDL3	LD	A,(FDC)		;read a byte
	BIT	1,A		;byte ready?
	JR	NZ,RDL4		;go if yes
	RRCA			;command pending?
	JR	C,RDL3		;wait if yes
	OR	-1		;else set error!
	RET			;return NZ
;
RDL4	LD	A,(XFER)	;read FDC byte
	RRD			;move into buffer
	DEC	L		;less buffer
	JR	NZ,RDL1		;go next byte
	INC	H		;else bump MSB
	JR	RDL1		;continue
;
;	move head to track 1
;
SEEK1	CALL	SELECT		;select drive
	LD	A,01		;track to seek
	LD	(XFER),A	;set track 1
	LD	A,SEEK		;get seek command
	CALL	SLOW		;issue command
SEEKWT	CALL	SELECT		;select drive
	RRCA			;command done?
	JR	C,SEEKWT	;wait if not
	RET			;else done
;
;	error vector
;
ERROR	LD	DE,MESG		;message
	LD	HL,VIDEO-1	;start of video-1
;
PRINT	LD	(HL),A		;to video
	INC	HL		;bump video
NEXT	LD	A,(DE)		;get a char
	INC	E		;bump buffer
	RRCA			;divide it
	JR	NC,PRINT	;send to video
;
;	wait for a key and re-boot
;
WAIT	LD	A,(KEYBRD)	;read keyboard row
	RRCA			;check bit 0
	JR	NC,WAIT		;wait if not set
	HALT			;re-boot mod I
;
;	issue FDC command and delay for valid status
;
SLOW	LD	(FDC),A		;issue command
;
	EX	(SP),HL		;delay time
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	RET
;
;	select drive and return with FDC status
;
SELECT	LD	A,(FDC)		;read FDC
	BIT	7,A		;motor on?
	PUSH	AF		;save FDC status
	LD	A,DRIVE		;drive select code
	LD	(SELFDC),A	;select reg FDC
	POP	AF		;restore FDC status
	RET	Z		;return if already on
;
	PUSH	BC		;save
	LD	BC,9000H	;motor on delay
	CALL	DELAY		;call rom delay
	POP	BC		;restore
	JR	SELECT		;re-select drive
;
MESG	DEFB	'E'<1
	DEFB	'R'<1
	DEFB	'R'<1
	DEFB	'O'<1
	DEFB	'R'<1
	DEFB	'!'<1
	DEFB	' '<1
	DEFB	5FH<1
	DEFB	-1		;terminator
;
;	following is the real stack area
;
	DEFB	'P'<1,'r'<1,'o'<1,'g'<1,'r'<1,'a'<1,'m'<1
	DEFB	' '<1,'b'<1,'y'<1,' '<1,'K'<1,'i'<1,'m'<1
	DEFB	' '<1,'W'<1,'a'<1,'t'<1,'t'<1,' '<1,'1'<1
	DEFB	'9'<1,'8'<1,'2'<1
;
;	stack area follows, registers popped here
;
STACK	DEFW	4500H		;buffer address
	DEFW	2020H		;track/sector
	DEFW	4600H		;buffer address
	DEFW	4040H		;track sector
	DEFW	4500H		;loader entry point!
;
	END	ENTRY
