; ptboot1s/asm - kjw/bqsd - 10/82
;
	PAGE
;
	SUBTTL	'<PTBOOT1/ASM - Boot Load Mod I SD>'
;
$DIF#	EQU	4200H-$		;offset to actual load
$SECL#	EQU	00		;lowest sector on track
$SECH#	EQU	10		;highest sector +1
;
;	header here
;
	CALL	01C9H		;ROM $CLS routine
	LD	DE,0100H	;track 1, sector 0
	LD	L,-1		;set buffer as empty
	EXX			;save in alt set
;
***LOOP	CALL	***GETB+$DIF#	;fetch a byte
;
;	begin of load block, check which type
;
	DEC	A		;01 header?
	JR	Z,***LOAD	;load it!
	DEC	A		;02 header?
	JR	Z,***STRT	;done!
	CP	1EH		;valid remark? (0-1FH)
	JR	NC,***SER	;data error!
;
;	remark block, remove and re-loop
;
	CALL	***GETB+$DIF#	;fetch a byte
	LD	B,A		;B = block length
;
***LOP2	CALL	***GETB+$DIF#	;fetch a remark byte
	DJNZ	***LOP2		;finish it off
	JR	***LOOP		;go next loop
;
;	entry point marker, fetch address and go!
;
***STRT	CALL	***GETB+$DIF#	;fetch entry length (02)
	CALL	***GETL+$DIF#	;fetch load address
	JP	(HL)		;go program!
;
;	load block marker, get address and load it!
;
***LOAD	CALL	***GETB+$DIF#	;fetch block length
	LD	B,A		;B = length
	CALL	***GETL+$DIF#	;get block address
	DEC	B		;less 2 byte address
	DEC	B
;
***LOP3	CALL	***GETB+$DIF#	;fetch block length
	LD	(HL),A		;to buffer
	CP	(HL)		;memory there for it?
	JR	NZ,***MER	;memory error
	INC	HL		;bump buffer
	DJNZ	***LOP3		;finish off the block
	JR	***LOOP		;go next block
;
;	fetch 2 byte address from file
;
***GETL	CALL	***GETB+$DIF#	;fetch LSB address
	LD	L,A		;pass it
	CALL	***GETB+$DIF#	;fetch MSB address
	LD	H,A		;pass it
	RET			;HL = address
;
;	error vectors
;
;	memory error (attempt to load non-existing mem)
;
***MER	LD	HL,***REM+$DIF#	;memory error text
	JR	***ERR		;go common
;
;	invalid data (file format error)
;
***SER	LD	HL,***RES+$DIF#	;data error text
	JR	***ERR		;go common
;
;	disk I/O error
;
***DER	LD	HL,***RED+$DIF#	;disk error text
;
***ERR	CALL	***DSP+$DIF#	;display message
	LD	HL,***RRE+$DIF#	;'error'
	CALL	***DSP+$DIF#	;display also
;
;	wait for a key then re-boot
;
	CALL	0040H		;wait for ENTER key
	HALT			;re-boot Mod I
;
***DSP	LD	A,(HL)		;get a byte
	OR	A		;high bit on?
	RET	M		;yes, done!
	CALL	0033H		;else display byte
	INC	L		;bump pointer
	JR	***DSP		;continue
;
;	fetch byte from file
;
***GETB	EXX			;get disk set back
	INC	L		;bump LSB buff pointer
	JR	NZ,***HAVB	;go if in buffer
;
;	read another sector
;
	LD	BC,4D00H	;I/O buffer to use
	CALL	***RD+$DIF#	;read the sector
	JR	NZ,***DER	;disk error!
	INC	E		;bump sector
	LD	A,E		;get new sector
	SUB	$SECH#		;highest sector/track
	JR	NZ,***HAVB	;go, not at track end
	LD	E,$SECL#	;lowest sector/track
	INC	D		;bump track
;
;	byte in buffer => by HL
;
***HAVB	LD	A,(HL)		;fetch byte
	EXX			;store registers again
	RET			;done, A = byte
;
;	message text for errors
;	high bit set on word is terminator
;
***REM	DEFM	'Memor','y'+80H
***RES	DEFM	'Dat','a'+80H
***RED	DEFM	'Dis','k'+80H
***RRE	DEFM	' Erro','r'+80H
;
;	short delay for FDC to load valid status byte
;
***SLO	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	RET
;
;	sector read: DE = track/sector, BC = buff address
;
***RD	LD	A,5		;allow 5 retries
;
***RDL	EX	AF,AF'		;swap retries left
	PUSH	BC		;save load address
	CALL	***RD1+$DIF#	;read a sector
	POP	HL		;original load address
	RET	Z		;no error, return
	LD	B,H		;pass buffer back
	LD	C,L		;to BC from original
	EX	AF,AF'		;get counter back
	DEC	A		;less this pass
	JR	NZ,***RDL	;go till out of tries
	EX	AF,AF'		;get NZ error back
	RET			;back NZ
;
;	actual sector I/O - single density Mod I
;
***RD1	LD	HL,37ECH	;Mod I FDC command reg.
	LD	A,1		;select drive 0
	LD	(37E1H),A	;it's on now
	LD	(37EEH),DE	;status/sector registers
	LD	(HL),1BH	;issue seek command
	CALL	***SLO+$DIF#	;wait for valid status
;
***SEK	BIT	0,(HL)		;command done?
	JR	NZ,***SEK	;wait if not
	LD	(HL),88H	;issue read command
	CALL	***SLO+$DIF#	;wait for valid status
	PUSH	DE		;save track/sector
	JR	***RD3		;continue
;
***RD2	RRCA			;command done?
	JR	NC,***RD4	;go if done!
;
***RD3	LD	A,(HL)		;fetch FDC status
	BIT	1,A		;ready for a byte?
	JR	Z,***RD2	;nope, command done?
;
	LD	A,(DE)		;fetch byte from FDC
	LD	(BC),A		;to I/O buffer
	INC	BC		;bump buffer
	JR	***RD3		;go next byte
;
***RD4	LD	A,(HL)		;read resulting status
	POP	DE		;unstack track/sector
	LD	(HL),0D0H	;force interrupt contlr.
	OR	A		;check for any errors
	RET			;Z = OK, NZ = Error
;
