; pttask/asm - kjw/bqsd - 10/82
;
	SUBTTL	'<PTTASK/ASM - Interrupt Task Processor>'
;
	PAGE
;
;	$TASK	- interrupt processor
;
;	interrupts each 'real time clock' beat
;
;	fetch interrupted Program Counter for trace
;	save all registers to be used
;
TASK	EX	(SP),HL		;get current PC
	LD	(TRACADD),HL	;save for TRACE
	EX	(SP),HL		;put it back
	PUSH	AF		;save registers
	PUSH	BC
	PUSH	DE
	PUSH	HL
;
;	check for valid RTC interrupt
;
;i*
	IF	MODI
	LD	A,(37E0H)	;read int latch I
	BIT	6,A		;FDC making roster?
	JP	NZ,FDCROST	;clear it if yes
	BIT	7,A		;valid interrupt?
	JP	Z,TSKNOT	;nothing if not set
	ENDIF
;i*
;
;iii*
	IF	MODIII
	IN	A,(0E0H)	;read int latch III
	BIT	2,A		;valid interrupt?
	JP	NZ,TSKNOT	;nothing if set
	ENDIF
;iii*
;
;	check for BREAK key
;
	LD	A,(3840H)	;check for break key
	AND	4		;bit 2 set?
	JR	Z,TASKDN	;if no, continue
;
;	display BREAK on video and wait for key release
;
	RST	@08		;display
;
	DEFB	CLSF		;clear video
	DEFM	'Break'		;message
	DEFB	ETX
;
	LD	A,(3880H)	;check for shift key
	OR	A		;set flags
	JR	Z,BRKCK2	;go if not shift
	RST	@08		;new message
;
	DEFB	BOL		;beginning of line
	DEFB	EOL		;clear line
	DEFM	'Shift Break'
	DEFB	ETX		;terminator
;
BRKCK1	CALL	IFBREAK		;wait for key release
	JP	MASTER		;go main menu
;
BRKCK2	CALL	IFBREAK		;wait for release
	JP	SUBMENU		;go sub-menu
;
IFBREAK	LD	A,(3840H)	;read keyboard
	AND	4		;still pressed?
	JR	NZ,IFBREAK	;wait if yes
	RET			;else return
;
TASKDN	LD	A,(387FH)	;check for 'special keys'
	CP	81H		;special?
	JP	NZ,TASKCHK	;nope, go!
	LD	A,(387DH)	;check second special
	CP	81H		;special?
	JP	NZ,TASKCHK	;nope, go!
;
;	'special' key combination pressed!
;
	LD	HL,SERSTRT	;encoded message text
SER87X	LD	A,(HL)		;fetch a char
	XOR	75H		;decode it
	LD	(HL),A		;put it back
	INC	HL		;bump pointer
	JR	NZ,SER87X	;finish it
	RST	@08		;display hidden message
;
	DEFB	CLSF		;clear screen
SERSTRT	DEFB	5FH,5FH,5FH,5FH,5FH,5FH,5FH,5FH
	DEFB	5FH,5FH,5FH,5FH,5FH,5FH,5FH,5FH,78H
	DEFB	5FH,55H,55H,25H,07H,1AH,12H,07H
	DEFB	14H,18H,55H,17H,0CH,55H,55H,5FH,78H
	DEFB	5FH,55H,55H,55H,3EH,1CH,18H,55H
	DEFB	22H,14H,01H,01H,55H,55H,55H,5FH,78H
	DEFB	5FH,55H,5DH,16H,5CH,5DH,05H,5CH
	DEFB	55H,55H,44H,4CH,4DH,47H,55H,5FH,78H
	DEFB	5FH,37H,07H,10H,10H,0FH,10H,5AH
	DEFB	24H,26H,31H,59H,3CH,1BH,16H,5FH,78H
	DEFB	5FH,55H,55H,31H,14H,19H,19H,14H
	DEFB	06H,59H,55H,21H,2DH,55H,55H,5FH,78H
	DEFB	5FH,55H,55H,34H,19H,19H,55H,27H
	DEFB	1CH,12H,1DH,01H,06H,55H,55H,5FH,78H
	DEFB	5FH,55H,55H,55H,27H,10H,06H,10H
	DEFB	07H,03H,10H,11H,55H,55H,55H,5FH,78H
;	DEFB	5FH,55H,55H,55H,27H,10H,06H,10H
;	DEFB	77H,68H,10H,11H,55H,55H,55H,5FH,78H
	DEFB	5FH,5FH,5FH,5FH,5FH,5FH,5FH,5FH
	DEFB	5FH,5FH,5FH,5FH,5FH,5FH,5FH,5FH,78H
	DEFB	75H,ETX
;
;	wait for 'special' key release
;	and restore message
;
WTK3	LD	A,(387FH)	;read keyboard
	CP	81H		;pressed?
	JR	Z,WTK3		;wait if yes
	LD	HL,SERSTRT	;start of message
SER085	LD	A,(HL)		;get a char
	OR	A		;check for term
	PUSH	AF		;save flag
	XOR	75H		;restore it
	LD	(HL),A		;put it back
	INC	HL		;bump pointer
	POP	AF		;get flags
	JR	NZ,SER085	;go if more
	JP	SUBMENU		;go last sub-menu
;
TASKCHK	LD	A,(FLAGA)	;check for "alive"
	BIT	1,A		;on?
	JR	NZ,TASKCH	;nope, don't display it
;
;	check if 'trace' is ON
;
	LD	A,(FLAGB)	;get system flag
	BIT	0,A		;is it on?
	CALL	NZ,PERTRC	;yes, display it
;
;	change 'alive' in four video corners
;
;i*
	IF	MODI
	LD	A,4		;counter Mod I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	A,3		;counter Mod III
	ENDIF
;iii*
;
TSKCNTY	EQU	$-1
	DEC	A		;decrement it
	LD	(TSKCNTY),A	;put it back
	JR	NZ,TSKCNTX	;not time yet, continue
;
;i*
	IF	MODI
	LD	A,4		;reset Mod I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	A,3		;reset Mod III
	ENDIF
;iii*
;
	LD	(TSKCNTY),A	;put it back
;
;	change all # to * in top row of display
;
	LD	HL,VIDEO+42H	;start here
	LD	B,60		;row length less edges
	LD	A,(HL)		;fetch a byte
	CP	'*'		;asterisk?
	JR	Z,GOFLS		;yes, go!
	CP	'#'		;pound?
	JR	NZ,TSKCNTX	;skip if neither!
;
GOFLS	CP	(HL)		;same?
	JR	NZ,SKPFLSG	;skip if not
	XOR	9		;change to other
	LD	(HL),A		;to the video
	XOR	9		;put it back
SKPFLSG	INC	HL		;bump video pointer
	DJNZ	GOFLS		;finish the row
;
TSKCNTX	EQU	$
;
;i*
	IF	MODI
	LD	A,3		;alive counter I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	A,2		;alive mod III
	ENDIF
;iii*
;
TSKCNTZ	EQU	$-1
	DEC	A		;less one
	LD	(TSKCNTZ),A	;put it back
	JR	NZ,TASKCH	;go if not time
;
;i*
	IF	MODI
	LD	A,3		;reset I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	A,2		;reset III
	ENDIF
;iii*
;
	LD	(TSKCNTZ),A
;
;	display 'alive' to video
;
	LD	A,0		;get current 'alive'
TSKXX	EQU	$-1
	PUSH	AF		;save current
	LD	HL,ALVTBL	;lookup table
	ADD	A,A		;*2
	ADD	A,A		;*4 (4 byte table)
	ADD	A,L		;add to LSB
	LD	L,A		;put it back
	JR	NC,TSKXY	;go if not carry
	INC	H		;bump MSB
TSKXY	LD	A,(HL)		;get a byte
	LD	(VIDEO+000H),A	;to top left
	INC	HL		;bump table
	LD	A,(HL)		;get a byte
	LD	(VIDEO+03FH),A	;to top right
	INC	HL		;bump table
	LD	A,(HL)		;get a byte
	LD	(VIDEO+3C0H),A	;to lower left
	INC	HL		;bump table
	LD	A,(HL)		;get a byte
	LD	(VIDEO+3FFH),A	;to lower right
;
	POP	AF		;restore counter
	INC	A		;bump it
	CP	6		;0-5?
	JR	C,TSKXZ		;yes, go!
	XOR	A		;reset to start
TSKXZ	LD	(TSKXX),A	;resave new posit
;
;	LD	A,(VIDEO+3FH)	;read video
;	BIT	7,A		;graphics?
;	JR	Z,TSKZXX	;reset it not!
;	ADD	A,A		;shift bits left
;	AND	3FH		;mask lower bits
;	JR	NZ,TSKCNU	;go if in bits on
;TSKZXX	LD	A,1		;reset 'alive'
;TSKCNU	OR	80H		;make it graphics
;	LD	(VIDEO+03FH),A	;upper right corner
;	LD	(VIDEO+000H),A	;upper left corner
;	LD	(VIDEO+3C0H),A	;lower left corner
;	LD	(VIDEO+3FFH),A	;lower right corner
;
;	check to see if a valid serial number is present
;
TASKCH	LD	A,0		;get counter
SERCNT	EQU	$-1		;once about each 8 secs
	DEC	A		;less one
	LD	(SERCNT),A	;put it back
	JR	NZ,TSKDONE	;skip this time around
;
;	check to make sure my name has not been changed
;
	LD	HL,KIM		;my name in the program
	LD	DE,KIMCHK	;'checker' string
	LD	B,8		;length to check
;
TSKCK1	LD	A,(DE)		;fetch check byte
	SRL	A		;adjust it to normal
	CP	(HL)		;same?
	JR	NZ,KILLPGM	;nope, kill the program
;
	INC	DE		;bump checker
	INC	HL		;bump string
	DJNZ	TSKCK1		;go for 8
;
;	check valid serial #
;
	LD	HL,SERSAVE	;serial number area
	LD	BC,1E00H	;B=30 counter, C=cksum
;
TKCKY	LD	A,(HL)		;fetch a byte
	NEG			;reverse it
	ADD	A,C		;add to subtotal
	LD	C,A		;put it back
	INC	HL		;bump pointer
	DJNZ	TKCKY		;do whole length
	LD	A,I		;get interrupt register
	CP	C		;match?
	JR	Z,TSKDONE	;OK, continue
;
;	either my name or the serial name is corrupt
;	destroy the program
;
KILLPGM	LD	HL,VIDEO	;start of writable memory
	LD	DE,VIDEO+1	;start + 1
	LD	BC,0FFFFH-VIDEO	;length of ALL RAM
	LD	(HL),'?'	;put in 'what'
	LDIR			;fill ALL memory
	HALT
	RST	@00		;re-boot
;
;	check if printer ready to accept spooled char
;
TSKDONE	CALL	SPOOL		;printer spooler
;
;	completed, clear interrupt latch and return
;
TSKNOT	EQU	$
;i*
	IF	MODI
	LD	A,(37E0H)	;clear interrupt latch
	ENDIF
;i*
;
;iii*
	IF	MODIII
	IN	A,(0ECH)	;clear latch III
	ENDIF
;iii*
	POP	HL		;unstack
	POP	DE
	POP	BC
	POP	AF		;restore AF
	EI			;re-enable
	RET			;done, return from int
;i*
	IF	MODI
FDCROST	LD	A,(37ECH)	;clear FDC
	JR	TSKNOT		;clear latch and return
	ENDIF
;i*
PERTRC	LD	HL,0		;get program counter
TRACADD	EQU	$-2
	LD	A,H		;get MSB
	RST	@20		;convert to HEX ascii
	LD	(VIDEO+122),BC	;put on the video
	LD	A,L		;get LSB
	RST	@20		;to HEX ascii
	LD	(VIDEO+124),BC	;to the video
	RET			;done!
;
ALVTBL	DEFB	081H,082H,090H,0A0H	;+0
	DEFB	082H,081H,0A0H,090H	;+1
	DEFB	088H,084H,088H,084H	;+2
	DEFB	0A0H,090H,082H,081H	;+3
	DEFB	090H,0A0H,081H,082H	;+4
	DEFB	084H,088H,084H,088H	;+5
;
