; ptmemb - kjw/bqsd - 10/82
;
	PAGE
;
	SUBTTL	'<PTMEMB/ASM - Memory Section B>'
;
;	$TESTMEM - test memory
;
TESTMEM	LD	BC,TESTM1	;can't test this block
	LD	HL,CT1		;string to hold it
	CALL	PUTHEX		;load HEX ascii here
;
	LD	BC,TESTM2	;end of block
	LD	HL,CT2		;string for it
	CALL	PUTHEX		;load ascii to string
;
	RST	@08
;
	DEFB	LF
	DEFM	'DO NOT test between '
CT1	DEFM	'xxxxH and '
CT2	DEFM	'xxxxH !!'
	DEFB	ETX
;
	CALL	INTCNT		;zero the counter
	CALL	GETSE		;get start end
	CALL	BYTECNT		;setup registers
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
;	must disable interrupts in case the interrupt
;	code itself gets tested, also goes much quicker
;
	DI
;
TESTML	LD	DE,RET		;return instruction
	LD	(TESTM3),DE	;save into code
;
;	test each bit one at a time
;	both in on and off positions
;	each pass all non-test bits will
;	be tested as opposite bits
;
	LD	E,(HL)		;get the byte
	LD	A,1		;start with bit 0
	LD	D,0		;bad bit saver
;
TESTM1	LD	(HL),A		;load address
	CP	(HL)		;still there?
	CALL	NZ,BADMEM	;bad memory, catch it
	XOR	-1		;reverse the bits
	LD	(HL),A		;back in
	CP	(HL)		;still there?
	LD	(HL),E		;put byte back
TESTM2	CALL	NZ,BADMEM2	;catch error if bad
	XOR	-1		;restore byte
	ADD	A,A		;shift test bit left
	JR	NC,TESTM1	;do all bits
;
;	all bits this byte tested, display if any error
;
	CALL	0		;display if bad byte
TESTM3	EQU	$-2		;RET if checked out OK
	INC	HL		;bump buffer to next
	CALL	PAUSE		;check if pause
	CALL	IFCLEAR		;check for clear abort
	JR	C,TESTFIN	;yes, go!
;
	DEC	BC		;less count
	LD	A,B		;any more to do
	OR	C		;any bits on?
	JR	Z,TESTFIN	;done, go!
;
;	check if on an even page to display test address
;
	LD	A,L		;on an even page?
	OR	A		;L=0?
	JR	NZ,TESTML	;nope, continue
;
	PUSH	BC		;must save
	PUSH	HL		;this too
	LD	B,H		;pass address to BC
	LD	C,L		;BC = test address
	LD	HL,TMMSGG	;test message
	CALL	PUTHEX		;insert hex ascii
	POP	HL		;unstack
	POP	BC		;counter also
;
	RST	@08
;
	DEFB	BOL
	DEFM	'Testing Block '
TMMSGG	DEFM	'xxxxH'
	DEFB	ETX
;
	JR	TESTML		;continue next address
;
;	test completed, display error count
;
TESTFIN	EI			;can enable now
	CALL	SHOCNT		;display error counter
	RST	@08		;display message
;
	DEFM	'bad bytes'
	DEFB	ETX
;
	JP	GOBACK		;back to sub-menu
;
;	bad memory spotted, catch bad bit
;
BADMEM	OR	D		;add bad bit to mask
	LD	D,A		;re-save result
	PUSH	HL		;save it
	LD	HL,SHOBMEM	;display driver
	LD	(TESTM3),HL	;put into code
	POP	HL		;done
;
	RET			;done
;
;	bad memory, but bits are reversed!
;
BADMEM2	XOR	-1		;restore byte
	CALL	BADMEM		;set bad memory
	XOR	-1		;correct byte
	RET			;done
;
;	display address of bad memory by bits
;
SHOBMEM	PUSH	BC		;save count
	PUSH	HL		;save address
	LD	B,H		;pass to BC
	LD	C,L		;BC = address
	LD	HL,BMM1		;string address
	CALL	PUTHEX		;put hex ascii in string
	POP	HL		;unstack, leave BC
;
	RST	@08		;display message
;
	DEFB	EOL
BMM1	DEFM	'xxxxH, bad bits ='
	DEFB	ETX
;
	LD	A,'7'		;start with bit 7
	LD	B,8		;go for 8 bits
;
BMM2	RLC	D		;check the bit
	JR	NC,BMM3		;OK, continue
	LD	(BMM4),A	;save into text
	RST	@08		;display bit #
;
	DEFM	' '
BMM4	DEFM	'x,'
	DEFB	ETX
;
BMM3	DEC	A		;ascii bit less 1
	DJNZ	BMM2		;continue for all 8
;
	LD	BC,(CURSOR)	;get cursor
	LD	A,'.'		;put period at end
	DEC	BC		;backspace it
	LD	(BC),A		;period at end
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	POP	BC		;restore counter
	JP	ADDCNT		;add to counter
;
	PAGE
;
;	$INPORT - input byte from port entry point
;
INPORT	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
INPORTB	RST	@08		;display prompt
;
	DEFB	EOL
	DEFM	'Port ? '
	DEFB	ETX
;
	LD	B,20		;20 char input?
	RST	@10		;get from keyboard
	CALL	VALUE		;fetch the value
	JR	C,INPORTB	;error, ask again
;
	IN	A,(C)		;get the byte
	RST	@20		;make it hex ascii
	LD	(INP1),BC	;into string
	RST	@08		;display it
;
	DEFB	LF
	DEFM	'Input byte is: '
INP1	DEFM	'xxH'
	DEFB	ETX
;
	JP	GOBACK		;back to sub-menu
;
	PAGE
;
;	$OUTPORT - output byte to port entry point
;
OUTPORT	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
OUTPRTB	RST	@08		;display prompt
;
	DEFB	EOL
	DEFM	'Port, Byte ? '
	DEFB	ETX
;
	LD	B,30		;30 char input
	RST	@10		;get from keyboard
;
;	fetch port value
;
	CALL	VALUE		;fetch numeric value
	JR	C,OUTPRTB	;go if invalid
;
;	fetch data value
;
	PUSH	BC		;save port in C
	CALL	VALUE		;get byte
	LD	A,C		;get LSB value
	POP	BC		;get port back
	JR	C,OUTPRTB	;bad number, ask again
	OUT	(C),A		;send it out
	JP	GOBACK		;done, back to sub-menu
;
	PAGE
;
;	$MEM2SEC - memory to disk sectors entry point
;
MEM2SEC	CALL	INTCNT		;initialize counter
	LD	HL,BUFFER	;default to buffer
	LD	(DEFADDR),HL	;default address
	CALL	GETADDR		;get user address
;
	PUSH	BC		;save it on stack
	CALL	GETDAT		;get drive,track,sector
	CALL	GETCNT		;get sector count
	POP	BC		;address to write from
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	COMPDAT		;get data type write byte
	LD	(WRTYPE),A	;save for sector write
	CALL	DSTAT		;check status
	JP	NZ,SUBMENU	;back sub-menu if bad
;
M2SECL	PUSH	HL		;save count
	RST	@30		;write a sector
	POP	HL		;restore counter
	CALL	NEXSEC		;next sector
	JR	C,M2SECD	;go if beyond disk end
	DEC	HL		;decrement counter
	LD	A,H		;any more
	OR	L		;any bits on either HL?
	JR	NZ,M2SECL	;go if any left
;
M2SECD	CALL	SHOCNT		;display error counter
	RST	@08		;display message
;
	DEFM	'sectors NOT written'
	DEFB	ETX
;
	JP	GOBACK		;back to sub-menu
;
	PAGE
;
;	$SEC2MEM - sectors to memory entry point
;
SEC2MEM	CALL	INTCNT		;clear counter
	CALL	GETDAT		;get drive/track/sector
	CALL	GETCNT		;get sector count
	EXX			;save here
	LD	HL,BUFFER	;default here
	LD	(DEFADDR),HL	;default address
	CALL	GETADDR		;get load address
	PUSH	BC		;pass to other set
	EXX			;swap back
	POP	BC		;have everything
	PUSH	BC		;leave on stack
;
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	DSTAT		;check status
	JP	NZ,SUBMENU	;back sub-menu if bad
	CALL	INTACNT		;clear alt counter
;
S2MEML	PUSH	HL		;save counter
	RST	@28		;read a sector
	POP	HL		;restore counter
	CALL	ADDACNT		;bump alt counter
	CALL	NEXSEC		;advance DE to next sect
	JR	C,S2MEMD	;beyond disk, quit
	CALL	BUFFEND		;end of memory?
	JR	Z,S2MEMD	;yes, go!
	DEC	HL		;less this sector
	LD	A,H		;any more to read?
	OR	L		;any bits on?
	JR	NZ,S2MEML	;go if more to do
;
S2MEMD	CALL	SHOACNT		;display load counter
	RST	@08		;display message
;
	DEFM	'sectors loaded'
	DEFB	LF
	DEFM	'<KEY> to display: '
	DEFB	ETX
;
	CALL	ONEKEY		;wait for a key
	POP	BC		;load address
	JP	DOADDR		;display/modify mode
;
	PAGE
;
;	$WRBUILD - write format track to disk
;
WRBUILD	LD	BC,BUFFER	;default address
	LD	(ADDRESS),BC	;save it
	JR	MEM2PUT		;write it out!
;
	PAGE
;
;	$MEM2TRK - memory to track entry point
;
MEM2TRK	LD	BC,BUFFER	;default buffer
	LD	(ADDRESS),BC	;save it
	CALL	GETADDR		;get user address
;
MEM2PUT	LD	(FMTBUFF),BC	;save address
	CALL	GETDT		;drive track
	CALL	DSTAT		;check status
	JP	NZ,SUBMENU	;back sub-menu if bad
;
;i*
	IF	MODI
	CALL	SELDEN		;select density
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	A,18H		;JR opcode
	LD	(WR3FIX),A	;allow full track
	ENDIF
;iii*
;
	CALL	SEEK		;move head to track
	JR	NZ,MEM2TBD	;go if any error
	CALL	BLDPUT		;write the track
;
;iii*
	IF	MODIII
	LD	A,20H		;put back JR NZ
	LD	(WR3FIX),A	;into code
	ENDIF
;iii*
;
	JP	Z,GOBACK	;OK, back to sub-menu
;
MEM2TBD	RST	@08		;display message
;
	DEFB	LF
	DEFM	'Error on Track Write'
	DEFB	ETX
;
	JP	GOBACK		;back to sub-menu
;
	PAGE
;
;	$TRK2MEM - track to memory entry point
;
TRK2MEM	LD	HL,BUFFER	;default buffer
	LD	(DEFADDR),HL	;save as default
	CALL	GETDT		;get drive track
;
	LD	(TEMP0),DE	;save track
	CALL	GETADDR		;get user address
	LD	(ADDRESS),BC	;save address
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
ASKSYNC	RST	@08		;ask if to sync
;
	DEFB	EOL
	DEFM	'Synchronize to ID ? '
	DEFB	ETX
;
	LD	B,3		;3 char input
	RST	@10		;get from keyboard
	LD	B,0E5H		;default YES
	JR	Z,SYNCHAV	;go if nil input
	CALL	UCASE		;convert to upper case
	CP	'Y'		;yes?
	JR	Z,SYNCHAV	;yes, go!
	CP	'N'		;no?
	JR	NZ,ASKSYNC	;neither, ask again
	LD	B,0E4H		;set NO
;
SYNCHAV	LD	A,B		;fetch command
	LD	(SYNC),A	;save into code
	CALL	DSTAT		;check drive status
	JP	NZ,SUBMENU	;go if not ready
	LD	BC,(ADDRESS)	;get I/O address
	LD	DE,(TEMP0)	;get track
;
;i*
	IF	MODI
	CALL	SELDEN		;select density
	ENDIF
;i*
;
	CALL	SEEK		;seek the track
	JR	NZ,SYNCNO	;go if error!
;
	CALL	READTR		;transfer the data
	AND	9CH		;check for errors
;
SYNCNO	CALL	NZ,TKBD		;display if any errors
;
;iii*
	IF	MODIII
	LD	A,20H		;set JR NZ opcode
	LD	(RD3FIX),A	;allow sector I/O only
	ENDIF
;iii*
;
	LD	BC,(TEMPFF)	;get end address buffer
	DEC	BC		;point to last byte
	LD	HL,TKE		;text to load ascii
	CALL	PUTHEX		;load hex ascii to string
	LD	BC,(ADDRESS)	;get start address
	PUSH	BC		;save it
	LD	HL,TKS		;text for message
	CALL	PUTHEX		;load hex into string
	RST	@08		;display message
;
	DEFB	LF
	DEFM	'Track in buffer from '
TKS	DEFM	'xxxxH to '
TKE	DEFM	'xxxxH'
	DEFB	LF
	DEFM	'<KEY> to display: '
	DEFB	ETX
;
	CALL	ONEKEY		;wait for a key
	POP	BC		;restore buffer address
	JP	DOADDR		;display/modify it
;
;	disk error on track read
;
TKBD	SCF			;set write operation
	CALL	SHOWST		;display error message
	RST	@08		;display message
;
	DEFB	LF
	DEFM	'Track Read Error'
	DEFB	ETX
;
	RET			;done
;
	PAGE
;
;	$GETDT - fetch drive / track from user
;
GETDT	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	XOR	A		;default to drive 0
	CALL	SETDRV		;setup for I/O
	LD	D,0		;default track 0
;
GETDT0	RST	@08		;display prompt
;
	DEFB	EOL
	DEFM	'Drive, Track ? '
	DEFB	ETX
;
	LD	B,30		;30 char input
	RST	@10		;get from keyboard
	CALL	POSHL		;any input?
	RET	Z		;nope, use defaults
;
	CALL	FIGDRV		;setup drive type
	JR	C,GETDT0	;error, ask again
;
	CALL	POSHL		;any more input
	RET	Z		;nope, default track
	CALL	VALUE		;get value
	JR	C,GETDT0	;invalid, ask again
	LD	D,C		;pass value
	RET			;done, D=track
;
;	$BLDPUT - write format track
;
BLDPUT	LD	BC,(FMTBUFF)	;where buffer is
	RST	@08		;linefeed
;
	DEFB	LF
	DEFB	ETX
;
	JP	SHOFMT		;display and write it out
;
