; ptformb/asm - kjw/bqsd - 10/82
;
	PAGE
;
	SUBTTL	'<PTFORMB/ASM - Disk Format Section B>'
;
;	notify of fault drive
;
SKPDRD	CALL	DRVASC		;fetch current drive
	LD	(SKD),A		;to the message
	RST	@08		;display it
;
	DEFM	' on Drive '
SKD	DEFM	'x'
	DEFB	ETX		;terminator
;
	JP	SKPDD		;continue
;
	PAGE
;
;	$BUILD - create format track image in RAM
;
;	compute table to be used to create image
;	locate fill data for emtpy sectors
;
BUILD	LD	BC,SPATTRN	;single density fill data
	LD	HL,SORDER0	;single density table
	LD	A,(IY+2)	;get current track
	OR	A		;on track 0?
	LD	A,(IY+4)	;fetch DCT flags
	JR	NZ,BUILDN0	;nope, check out disk
;
	BIT	7,A		;single track 0?
	JR	Z,BUILDIT	;yes, go!
	RRCA			;move bit 1 => 0
	JR	CKBLD		;check out double density
;
;	allow patch space here for rigid and 8" drives
;
	DEFW	0
	DEFW	0
	DEFW	0
	DEFW	0
	DEFW	0
;
BUILDN0	BIT	6,A		;single den disk?
	JR	Z,BUILDIT	;yes, go!
;
CKBLD	AND	1		;bit 0 only
	LD	BC,DPATTRN	;double fill pattern
	LD	HL,DORDER0	;double den 0-17
	JR	Z,BUILDIT	;have it, go!
	LD	HL,DORDER1	;double den 1-18
	BIT	6,(IY+5)	;trsdos I DD?
	JR	Z,BUILDIT	;nope, go!
	LD	HL,DORDER2	;double den 1-18
;
BUILDIT	LD	(PATTUSE),BC	;save pattern pointer
	LD	C,(HL)		;get sectors/track
	INC	HL		;bump table
	LD	E,(HL)		;get sector order table
	INC	HL		;bump
	LD	D,(HL)		;MSB order table
	INC	HL		;bump to sector data
	CALL	ORDNEW		;track to track skewing
	PUSH	DE		;save sector #'s on stack
;
	LD	DE,(FMTBUFF)	;format buffer
	EX	DE,HL		;hl => buffer, de =>table
;
	CALL	MOVEIN		;post index gap
	CALL	MOVEIN		;post index sync field
	CALL	MOVEIN		;post index sync part 2
	LD	(HL),0FCH	;index mark header
	INC	HL		;bump buffer
	CALL	MOVEIN		;post index gap 2
	LD	(DESVE),DE	;save table for loops
;
SECLP	LD	DE,0		;fetch saved table
DESVE	EQU	$-2
;
	CALL	MOVEIN		;pre-ID sync field
	CALL	MOVEIN		;pre-ID sync part 2
	LD	(HL),0FEH	;ID address header
	INC	HL		;bump buffer
;
;	build ID field
;
	LD	A,(IY+2)	;get current track
	LD	(HL),A		;to the buffer
	INC	HL
	LD	(HL),0		;head
	INC	HL
	EX	(SP),HL		;get sector pointer
	LD	A,(HL)		;get sector number
	INC	HL		;bump sector table
	EX	(SP),HL		;put it back
	LD	(HL),A		;send sector to buffer
	INC	HL		;bump buffer
	LD	(HL),1		;length of sector (256)
	INC	HL
	LD	(HL),0F7H	;CRC generator
	INC	HL		;bump buffer
;
;	gap between ID and DATA fields
;
	CALL	MOVEIN		;data field gap
	CALL	MOVEIN		;data field sync
	CALL	MOVEIN		;data field sync part 2
	LD	A,(IY+4)	;get DCT flags
	AND	4		;bit 2 (reversed DAM's?)
	LD	A,0FBH		;standard address mark
	JR	Z,AO103		;go if normal DAM
	LD	A,0F8H		;user defined mark
AO103	LD	(HL),A		;DATA field header
	INC	HL		;bump buffer
;
;	fill 256 bytes of specified fill information
;
	PUSH	DE
	EX	DE,HL		;DE => buffer
	LD	HL,0		;pattern pointer
PATTUSE	EQU	$-2
	LD	B,16		;16 lines * 16 bytes
PATTPUT	PUSH	BC		;save it
	PUSH	HL		;save pattern
	LD	BC,16		;16 bytes each
	LDIR			;move to buffer
	POP	HL		;back
	POP	BC
	DJNZ	PATTPUT
	EX	DE,HL		;HL back to buffer
	POP	DE
;
	LD	(HL),0F7H	;CRC for data
	INC	HL		;bump buffer
	CALL	MOVEIN		;post-data gap
;
	DEC	C		;sector count -1
	JR	NZ,SECLP	;finish all sectors
	INC	SP		;remove address
	INC	SP		;from stack
;
	CALL	MOVEIN		;pre-index gap
	CALL	MOVEIN		;pre-index gap
	LD	BC,(FMTBUFF)	;point to the buffer
	RET			;done, return to caller
;
;	$MOVEIN - move data into buffer
;
;	ENT	HL => buffer
;		A  = fill character
;		B  = fill length
;
MOVEIN	LD	A,(DE)		;get table byte
	LD	B,A		;# bytes to go
	INC	DE		;bump table
	LD	A,(DE)		;byte to fill with
	INC	DE		;point to next one
;
FILL	LD	(HL),A		;put in buffer
	INC	HL		;bump buffer
	DJNZ	FILL		;go for B loops
	RET			;buffer filled
;
	PAGE
;
;	track image tables
;
SORDER0	DEFB	10		;sectors/track
	DEFW	ORDERS		;sector order table 0-9
;
;	post-index field
;
	DEFB	16,0FFH		;post index gap
	DEFB	03,000H		;post index sync
	DEFB	03,000H		;post index sync part 2
	DEFB	11,0FFH		;post index field gap
;
;	pre-ID field
;
	DEFB	03,000H		;pre-ID sync #1
	DEFB	03,000H		;pre-ID sync #2
;
;	pre-DATA field
;
	DEFB	10,0FFH		;pre-DATA gap
	DEFB	02,000H		;pre-DATA sync #1
	DEFB	02,000H		;pre-DATA sync #2
	DEFB	11,0FFH		;post-data gap
;
;	pre-index field
;
	DEFB	16,0FFH		;pre-index gap
	DEFB	00,0FFH		;pre-index gap
;
DORDER0	DEFB	18		;sectors/track
	DEFW	ORDERD0		;double sector order 0-17
;
;	post-index field
;
	DEFB	32,04EH		;post index gap
	DEFB	12,000H		;post-index sync
	DEFB	03,0F6H		;post-index sync 2
	DEFB	22,04EH		;post-index gap
;
;	pre-ID field
;
	DEFB	12,000H		;pre-ID sync
	DEFB	03,0F5H		;pre-ID sync part 2
;
;	pre-DATA field
;
	DEFB	24,04EH		;pre-DATA gap
	DEFB	08,000H		;pre-DATA sync
	DEFB	03,0F5H		;pre-DATA sync part 2
	DEFB	22,04EH		;post-DATA gap
;
;	pre-INDEX field
;
	DEFB	16,04EH		;pre-index gap
	DEFB	00,04EH		;pre-index gap
;
DORDER1	DEFB	18		;sectors/track
	DEFW	ORDERD1		;double sector order 1-18
;
;	post-INDEX field
;
	DEFB	32,04EH		;post-index gap
	DEFB	12,000H		;post-index sync #1
	DEFB	03,0F6H		;post-index sync #2
	DEFB	22,04EH		;post-index gap
;
;	pre-ID field
;
	DEFB	12,000H		;pre-ID sync #1
	DEFB	03,0F5H		;pre-ID sync #2
;
;	pre-DATA field
;
	DEFB	24,04EH		;pre-DATA gap
	DEFB	08,000H		;pre-DATA sync #1
	DEFB	03,0F5H		;pre-DATA sync #2
	DEFB	22,04EH		;post-DATA gap
;
;	pre-INDEX field
;
	DEFB	16,04EH		;pre-index gap
	DEFB	00,04EH		;pre-index gap
;
;	track data TRSDOS I double density
;
DORDER2	DEFB	18		;sectors / track
	DEFW	ORDERD2		;sector order table
;
;	post index field
;
	DEFB	32,04EH		;gap
	DEFB	12,000H		;sync A
	DEFB	03,0F6H		;sync B
	DEFB	22,4EH		;pre-ID gap
;
;	pre ID field
;
	DEFB	12,000H		;sync A
	DEFB	03,0F5H		;sync B
;
;	pre DATA field
;
	DEFB	24,04EH		;gap
	DEFB	08,000H		;sync A
	DEFB	03,0F5H		;sync B
	DEFB	22,04EH		;gap
;
;	pre index gap
;
	DEFB	16,04EH		;gap
	DEFB	00,04EH		;fill data
;
;	sector order tables (sector to sector skewing)
;
;	single density, sectors 0-9
;
ORDERS	DEFB	00,05,01,06,02,07,03,08,04,09
;
;	double density, sectors 0-17
;
ORDERD0	DEFB	00,06,12,01,07,13,02,08,14
	DEFB	03,09,15,04,10,16,05,11,17
;
;	double density, sectors 1-18
;
ORDERD1	DEFB	01,04,07,10,13,16,02,05,08
	DEFB	11,14,17,03,06,09,12,15,18
;
ORDERD2	DEFB	01,07,13,02,08,14,03,09,15
	DEFB	04,10,16,05,11,17,06,12,18
;
	PAGE
;
;	$HASDATA - check if disk should be formatted
;
HASDATA	CALL	DRVASC		;get ascii drive #
	LD	(NXW1),A	;save in string
	RST	@08		;display message
;
	DEFM	'Drive '
NXW1	DEFM	'x HAS DATA'
	DEFB	LF
	DEFB	ETX
;
	LD	A,0		;if ok to overwrite
HASFLAG	EQU	$-1
	OR	A		;Z = continue
	RET	NZ		;format over anyways
;
;	attempt to read directory GAT for name/date
;
	PUSH	IY		;pass IY to HL
	POP	HL		;HL => DCT
	LD	DE,STRING	;save it here
	LD	BC,10		;length of DCT
	LDIR			;save it
	CALL	DETECT		;auto dos recognize
	JR	NZ,TRYHAVZ	;go if non-standard
	CALL	WHERDIR		;locate directory
	CALL	GETDIR		;load DE with track/sect
	LD	BC,BUFFER	;I/O buffer
	RST	@28		;read it
	JR	Z,TRYHAV	;read it, display data
;
TRYHAVZ	RST	@08		;display message
;
	DEFB	LF
	DEFB	'Non-Standard Format'
	DEFB	ETX
;
	JP	TRYHV6		;see if to continue
;
TRYHAV	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	HL,GATBUFF+0D0H	;new name/date
	LD	BC,16		;length
	LD	DE,BUFFER	;store it here
	LDIR			;save it
	LD	HL,BUFFER+0D0H	;from this disk
	LD	C,16		;length
	LD	DE,GATBUFF+0D0H	;normal location
	LDIR			;move it there
	CALL	NAMDATE		;display name/date
	LD	HL,BUFFER	;stored new data
	LD	DE,GATBUFF+0D0H	;where it goes
	LD	BC,16		;length
	LDIR			;put it all back
;
TRYHV6	RST	@08		;linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	A,(IY+2)	;get current track
	PUSH	IY		;pass DCT to DE
	POP	DE
	LD	HL,STRING	;saved DCT
	LD	BC,10		;length
	LDIR			;put it back
	LD	(IY+2),A	;re-save current track
;
TRYHV7	RST	@08		;prompt for choice
;
	DEFB	EOL
	DEFM	'C>ontinue or Q>uit ? '
	DEFB	ETX
;
	LD	B,2		;two char input
	RST	@10		;get from keyboard
;
	RET	Z		;continue!
	CALL	UCASE		;make it upper case
	CP	'C'		;continue?
	RET	Z		;yes, return
	CP	'Q'		;quit?
	JP	Z,SUBMENU	;yes, go last sub-menu
	JR	TRYHV7		;re-ask, invalid input
;
	PAGE
;
;	$CODE - code string into two byte password
;
;	ENT	HL => input string to code
;		B  =  length of significant chars
;
;	EXT	HL = 2 byte password
;
CODE	LD	A,B		;fetch length
	OR	A		;anything?
	JR	Z,CODDDZ	;nope, use default
;
	PUSH	HL		;save string start
	PUSH	BC		;save length
;
;	convert string to upper case before coding
;
CODDDU	LD	A,(HL)		;fetch a byte
	CALL	UCASE		;make it upper case
	LD	(HL),A		;put it back
	INC	HL		;bump pointer
	DJNZ	CODDDU		;continue
	POP	BC		;restore length
	POP	HL		;restore start
;
;	pad blanks on right of string
;
CODDDZ	EX	DE,HL		;DE => string
	LD	A,B		;get length
	ADD	A,E		;point to end of string
	LD	L,A		;give to L
	LD	A,D		;get MSB
	ADC	A,0		;add carry from LSB
	LD	H,A		;HL => string end
	LD	A,8		;go for 8 chars
	SUB	B		;what was input
	JR	Z,CODDD		;at maximum, no padding
	LD	B,A		;else fill with spaces
CODLP1	LD	(HL),SPACE	;insert space
	INC	HL		;bump pointer
	DJNZ	CODLP1		;fill all spaces
;
CODDD	LD	A,E		;point to last char
	ADD	A,7		;offset to end
	LD	E,A		;put it back
	JR	NC,CODEZZ	;no boundary cross
	INC	D		;DE=> last char.
CODEZZ	LD	HL,0FFFFH	;init password
	LD	B,8		;go for 8 chars
;
CODLP2	LD	A,(DE)		;get byte from string
	PUSH	DE		;save it
	LD	D,A		;'hash it'
	LD	E,H		;coding scheme
	LD	A,L
	AND	7
	RRCA
	RRCA
	RRCA
	XOR	L
	LD	L,A
	LD	H,0
	CALL	COMPCOD		;adjust for TRS I/III DD
	ADD	HL,HL
	ADD	HL,HL
	XOR	H
	XOR	D
	LD	D,A
	LD	A,L
	ADD	HL,HL
	XOR	H
	XOR	E
	LD	E,A
	EX	DE,HL
	POP	DE
	DEC	DE		;move back 1 char.
	DJNZ	CODLP2		;go for 8 chars
	RET			;HL = password
;
	PAGE
;
;	$GET10/$PUT10 - read/write track
;
;	used in format without erase
;
GET10	NOP			;turn off with RET here
	LD	A,(TEMP0)	;get current track
	LD	D,A		;pass to D
	CALL	FIRSTS		;load E with first sector
	LD	L,A		;give # sectors to L
	LD	H,0		;HL = # sectors/track
	LD	BC,BUFFER	;use this buffer
	JP	MREAD		;read multiple
;
PUT10	NOP			;can intercept with RET
	LD	A,(TEMP0)	;get current track
	LD	D,A		;pass to D
	CALL	FIRSTS		;fetch first sector
	LD	L,A		;# sector / track
	LD	H,0		;HL = # sectors
	LD	BC,BUFFER	;I/O buffer
	JP	MWRITE		;write it back
;
;	disable track read/write
;
NOPUT	LD	A,0C9H		;'return' opcode
	LD	(GET10),A
	LD	(PUT10),A	;turn off retrieve
	RET
;
	PAGE
;
;	$ORDNEW - rotate current sector table
;		  to produce track to track 'skewing'
;
ORDNEW	CALL	SAVEREG		;save registers
;
	EX	DE,HL		;HL = order table
	LD	B,3		;3 shifts single density
	DEC	C		;one less than # sectors
	BIT	6,(IY+4)	;disk density
	JR	Z,ORDNEW1	;go if single den
	LD	B,4		;4 shifts double den
;
ORDNEW1	PUSH	BC		;save counters
	LD	A,(HL)		;get table byte
	PUSH	HL		;save table start
	INC	HL		;look at 2nd one
;
ORDNEW2	LD	E,(HL)		;get 2nd byte
	LD	(HL),A		;put 1st one there
	LD	A,E		;get 2nd one
	INC	HL		;go to next table byte
	DEC	C		;continue through table
	JR	NZ,ORDNEW2	;finish all sectors
	POP	HL		;restore table pointer
;
	LD	(HL),A		;put last byte in 1st
	POP	BC		;get counters back
	DJNZ	ORDNEW1		;go again for # 'skews'
	RET			;done, return
;
	PAGE
;
;	$NSBOOT - non-system boot information
;
;	simply displays 'no system'
;
NSBOOT	DEFB	000H,000H,000H,021H,014H,042H,07EH,023H
	DEFB	0B7H,028H,005H,0CDH,033H,000H,018H,0F6H
	DEFB	0CDH,040H,000H,076H,01CH,01FH,017H,04EH
	DEFB	04FH,054H,020H,041H,020H,053H,059H,053H
	DEFB	054H,045H,04DH,020H,044H,049H,053H,04BH
	DEFB	02EH,020H,000H,000H,000H,000H,000H,000H
NSBOOTL	EQU	$-NSBOOT
;
;	directory entry for BOOT/SYS
;
BOOTENT	DEFB	5DH
	DEFW	0,0
	DEFB	'BOOT    SYS'
	DEFW	4296H		;nill password
	DEFW	4296H
	DEFW	5,0
	DEFW	-1,-1,-1,-1
;
;	directory entry for DIR/SYS
;
DIRENT	DEFB	5DH
	DEFW	0,0
	DEFB	'DIR     SYS'
	DEFW	4296H
	DEFW	4296H
	DEFW	0AH
DIRTKK	DEFB	11H
	DEFB	1
	DEFW	-1,-1,-1,-1
;
	PAGE
;
;	$SFMT3 - terminator for format/backup
;		 see if action is to be repeated
;
SFMT3	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
SFMT4	RST	@08		;display prompt
;
	DEFB	EOL
	DEFM	'Repeat ? '
	DEFB	ETX
;
	LD	B,3		;3 char input
	RST	@10		;get from keyboard
	JP	Z,RETURN	;nil input, skip it
	CALL	UCASE		;get first char ucase
	CP	'N'		;no?
	JP	Z,RETURN	;nope, go!
	CP	'Y'		;yes?
	JR	NZ,SFMT4	;neither, ask again
;
	LD	A,(FMTYPE)	;where coming from
	CP	2		;backup?
	JP	Z,ANOBAK	;do backup again
	JP	SFMT2		;do standard format
;
	PAGE
;
;	$LOKIT - error on disk verify, lockout granule
;
LOKIT	LD	A,(FMTYPE)	;backup or w/o erase
	OR	A		;must be zero to cont.
	JR	NZ,LOKITWO	;go if either
;
	RST	@08		;display message
;
	DEFM	'   Gran LOCKED OUT'
	DEFB	LF
	DEFB	ETX
;
	CALL	LOKGRAN		;lockout the gran
	CALL	NEXGRAN		;move DE to next gran
	CALL	RETSEC		;retard 1 sector
	PUSH	AF		;save Z flag
	CALL	ADDCNT		;bump error counter
	POP	AF		;restore flags
	SCF			;set carry
	RET			;done
;
LOKITWO	RST	@08		;display message
;
	DEFM	'   CANNOT VERIFY'
	DEFB	LF
	DEFB	ETX
;
	CALL	ADDACNT		;bump alternate counter
	OR	A		;clear carry
	RET			;done
;
	PAGE
;
;	$SETGAT - prepare empty GAT/LOCKOUT tables
;
SETGAT	LD	A,(IY+5)	;get dos type
	AND	60H		;trsdos double den?
	LD	A,5		;6 granule directory
	JR	NZ,GMT0		;fill it up!
;
	LD	A,1		;single density disk?
	BIT	6,(IY+4)	;single?
	JR	Z,GMT0		;yes, go!
;
	LD	A,2		;3 gran directory ldos
;
GMT0	LD	(DIRTKK+1),A	;save grans in dir entry
	LD	HL,GATBUFF	;start of GAT table
;
;	check for track 0 un-available for I/O
;
	LD	A,(HL)		;get first byte
	BIT	5,(IY+4)	;track 0 available?
	JR	Z,AVAL0		;yes, go!
	OR	3FH		;set as allocated
AVAL0	LD	(HL),A		;put it back
;
;	check for 'special' GAT bytes
;
	LD	A,(IY+5)	;get dos type
	RLCA			;trsdos I SD?
	RET	C		;yes, nothing more
	RLCA			;trsdos I DD?
	JR	C,FT1D		;yes, go!
	RLCA			;trsdos III DD?
	RET	C		;yes, nothing more
;
;	LDOS type disk
;
	LD	B,(IY+9)	;get grans/track
	DEC	B		;less 1
	LD	A,(IY+6)	;get density
	RLCA			;move bit 6 -> 7
	AND	80H		;bit 7 = density
	OR	B		;merge it
	LD	(GATBUFF+0CDH),A
	LD	A,(IY+0)	;get highest track
	INC	A		;A = track count
	SUB	35		;adjust for LDOS
	LD	(GATBUFF+0CCH),A
	RET
;
FT1D	LD	A,(IY+0)	;get highest track
	LD	(GATBUFF+0C0H),A
	RET			;done
;
