; ptdiska/asm - kjw/bqsd - 10/82
;
	SUBTTL	'<PTDISKA/ASM - Disk I/O Section A>'
;
	PAGE
;
;	$XREAD	- sector read / reverse IBM type
;
;	ENT & EXT same as $READ
;
;	track and sector are stuffed into the FDC
;
XREAD	LD	A,(RDTYPE)	;get read type
	XOR	8		;reverse IBM type
	LD	(RDTYPE),A	;put it back
;
;	$READNS	- sector read with NO SEEK
;
;	ENT & EXT same as $READ
;
READNS	LD	HL,READ1S	;entry vector to $READ
	RES	3,(IY+3)	;set READ operation
	JR	RDWTNS		;continue
;
;	$WRITENS - sector write with NO SEEK
;
;	ENT & EXT same as $WRITE
;
;	track and sector stuffed to FDC before write
;
WRITENS	LD	HL,WRITE1S	;vector into $WRITE
	SET	3,(IY+3)	;set WRITE operation
RDWTNS	EQU	$
;i*
	IF	MODI
	LD	(37EEH),DE	;give track/sect to FDC
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	A,D		;get track
	OUT	(0F3H),A	;to FDC
	LD	A,E		;get sector
	OUT	(0F2H),A	;to FDC
	ENDIF
;iii*
	JR	READWRT
;
;	$TREAD	- sector read with density reversal
;
;	ENT & EXT same as $READ
;
TREAD	CALL	FLIPDEN		;change density
;
;	$READ	- sector read
;
;	ENT	D  = track
;		E  = sector
;		BC = load address for data
;		(DRIVE) already setup for drive
;		IY => drive DCT
;
;	EXT	Z = OK
;		BC = load address of NEXT sector
;
;		NZ = ERROR, A = status byte
;		BC = unchanged if NZ
;
;		DE = unchanged
;		HL = destroyed
;
READ	LD	HL,READ1	;where to go
	RES	3,(IY+3)	;set READ operation
	JR	READWRT		;go common routine
;
;	$TWRITE	- sector write with density reversal
;
;	ENT & EXT same as $WRITE
;
TWRITE	CALL	FLIPDEN		;switch density
;
;	$WRITE	- sector write with seek
;
;	ENT	D  = track
;		E  = sector
;		BC = data address
;		(DRIVE) already set
;		IY => drive DCT
;
;	EXT	Z = OK
;		BC = address to load NEXT sector
;
;		NZ = A = error status byte
;		BC = unchanged
;
;		DE = unchanged
;		HL = destroyed
;
WRITE	LD	HL,WRITE1
	SET	3,(IY+3)	;set WRITE operation
;
;	$READWRT - common vector for sector read/write
;
;	ENT	HL => code to call for I/O
;		DE = track/sector
;
;	EXT	Z = OK
;		BC = address of NEXT sector
;
;		NZ = A = error status byte
;		BC = unchanged
;
;		DE = unchanged
;		HL = destroyed
;
;	NOTE	2 attempts made for successful I/O
;	NOTE	if the relative sectoring bit is set
;		the the PHYSICAL track/sector is
;		supplied and it will be adjusted to the
;		RELATIVE track and sector
;
READWRT	LD	(RWTCL1),HL	;put into code
	LD	(RWTCL2),HL	;here too for 2nd attempt
	LD	(RWTCL3),HL	;3rd attempt
;
	PUSH	BC		;save load address
;i*
	IF	MODI
	CALL	SELDEN		;select correct FDC chip
	ENDIF
;i*
	CALL	0		;call read/write
RWTCL1	EQU	$-2
	POP	HL		;get load address
	RET	Z		;return if OK
	LD	B,H		;pass buff back to BC
	LD	C,L		;BC = buffer start
;
	BIT	4,A		;not found type error?
	CALL	NZ,RESTORE	;restore drive
	RET	NZ		;not in system!
;
	PUSH	BC		;save again
	CALL	0		;try again
RWTCL2	EQU	$-2
	POP	HL		;load address
	RET	Z		;OK, return
;
	LD	B,H		;reset BC back to orig
	LD	C,L
	BIT	4,A		;not found?
	CALL	NZ,RESTORE	;restore drive
	RET	NZ		;not in system!
;
	PUSH	BC		;save again
	CALL	0		;try again
RWTCL3	EQU	$-2
	POP	HL		;restore load address
	RET	Z		;no error, return
;
	LD	B,H		;reset buffer address
	LD	C,L		;BC = initial buffer
	RET			;return in error
;
;	$FLIPDEN - reverse density for current drive
;
FLIPDEN	LD	A,(FLAGB)	;get system flag
	BIT	4,A		;double den available?
	JR	Z,FLIPGO	;yes, OK
;
;	force single density if no double available
;
	RES	7,(IY+4)	;single track 0
	RES	6,(IY+4)	;single disk
	RET			;done
;
FLIPGO	LD	A,D		;get track
	OR	A		;check for 0
	LD	A,80H		;track 0 density
	JR	Z,FLPDEN	;go if track 0
	LD	A,40H		;remainder density
FLPDEN	XOR	(IY+4)		;reverse bit in DCT
	LD	(IY+4),A	;put back into table
	RET			;done, back to caller
;
	PAGE
;
;	sector I/O logic for read/write
;
READ1	CALL	SEEK		;move the head to track
	RET	NZ		;bad, return NZ
;i*
	IF	MODI
READ1S	LD	HL,37ECH	;point to FDC cmd reg.
	CALL	SELECT		;select the drive
	RET	NZ		;error, return
	CALL	FIXREAD		;adjust read command
;
	DI			;must disable for xfer
	LD	A,(RDTYPE)	;get read type
	LD	(HL),A		;give read command to FDC
	PUSH	DE		;save track/sector
	LD	DE,37EFH	;data transfer address
	CALL	RXFER		;transfer the data
	POP	DE		;restore track/sector
	ENDIF
;i*
;
;iii*
	IF	MODIII
READ1S	CALL	SELECT		;activate drive
	RET	NZ		;error, return
	CALL	FIXREAD		;adjust read command
	CALL	SETNMI		;setup NMI vectors
	LD	A,(RDTYPE)	;get type of read
	OUT	(0F0H),A	;issue to FDC
	CALL	RXFER		;transfer the bytes
	ENDIF
;iii*
;
;	common exit vector for Mod I & III
;
	PUSH	AF		;save result
	RRCA			;align data address
	RRCA			;mark bits to low bits
	RRCA
	RRCA
	RRCA
	AND	3		;4 types of marks
	OR	0A0H		;make it a write command
	LD	L,A		;save it here
	LD	A,(RDTYPE)	;get type of read
	AND	8		;IBM or not?
	OR	L		;now have a write command
	LD	(WRTYPE),A	;that will produce the
	EX	AF,AF'		;same as this read.
	POP	AF		;put write byte in af'
;
	AND	9FH		;check for error
	RET			;no error on DAMS
;
;	read new track from FDC and put into DCT
;
IOCOMM	PUSH	AF		;save I/O result
;i*
	IF	MODI
	LD	A,(37EDH)	;get track
	ENDIF
;i*
;
;iii*
	IF	MODIII
	IN	A,(0F1H)	;III track register
	ENDIF
;iii*
	LD	(IY+2),A	;put into table
	POP	AF		;restore result
	RET			;done
;
;	sector write logic
;
WRITE1	CALL	SEEK		;move head
	RET	NZ		;error occured
;
WRITE1S	LD	A,(IY+3)	;get DCT flags
	AND	40H		;software WP?
	RET	NZ		;yes, return ERROR
	CALL	FIXWRIT		;adjust command
;i*
	IF	MODI
	LD	HL,37ECH	;point to FDC cmd reg.
	ENDIF
;i*
	CALL	SELECT		;select the drive
	RET	NZ		;error, return
;i*
	IF	MODI
	DI			;must disable for xfer
	LD	A,(WRTYPE)	;get type of write
	LD	(HL),A		;issue write command
	PUSH	DE		;save track/sector
	LD	DE,37EFH	;data transfer address
	CALL	WXFER		;write data to the disk
	POP	DE		;restore track/sector
	ENDIF
;i*
;
;iii*
	IF	MODIII
	CALL	SETNMI		;setup NMI return
	LD	A,(WRTYPE)	;write type
	OUT	(0F0H),A	;give to FDC
	CALL	WXFER		;transfer the bytes
	ENDIF
;iii*
	AND	0FFH		;any errors?
	RET			;return the status
;
	PAGE
;
;	$SEEK	- move head on drive to desired track
;
;	ENT	D  = track to seek
;
;	EXT	Z = OK
;		NZ = A = FDC status byte
;
;		FDC sector register also loaded
;
SEEK	EQU	$		;same for I/III
;i*
	IF	MODI
	LD	HL,37ECH	;point to FDC
	ENDIF
;i*
	CALL	SELECT		;select the drive
	RET	NZ		;error, return
;
	LD	A,(IY+2)	;get current track
	OR	A		;on track 0?
	JR	NZ,SEKCNT	;continue if not
;
	CALL	RESTORE		;restore drive to trk 0
	RET	NZ		;not in system
	XOR	A		;set track 0
;i*
	IF	MODI
SEKCNT	LD	(37EDH),A	;give to FDC track reg
	LD	A,D		;desired track
	CALL	SEEKWHT		;adjust for double step
	LD	(37EFH),A	;desired relative track
;
	LD	A,E		;get desired sector
	LD	(37EEH),A	;give to FDC sect reg
	ENDIF
;i*
;
;iii*
	IF	MODIII
SEKCNT	OUT	(0F1H),A	;give to FDC track reg
	LD	A,D		;get track desired
	CALL	SEEKWHT		;check if double step on
	OUT	(0F3H),A	;desired relative track
	LD	A,E		;get sector
	OUT	(0F2H),A	;set sector
	ENDIF
;iii*
	JP	DOSEEK		;move the head!
;
	PAGE
;
;	$SELECT	- select a disk drive
;
;	ENT	(DRIVE)
;
;	EXT	Z = drive on and ready to go
;		NZ = don't access, A = error status
;
SELECT	LD	A,(IY+3)	;get drive flag
	AND	80H		;active ?
	RET	NZ		;software inactive
;
SELLOOP	EQU	$
;i*
	IF	MODI
	LD	A,(37ECH)	;read FDC status
	ENDIF
;i*
;
;iii*
	IF	MODIII
	IN	A,(0F0H)	;FDC status III
	ENDIF
;iii*
	AND	80H		;check for motor on
	CALL	RESELEC		;select drive
	RET	Z		;return if motor on
;
;	motor was not on at beginning of command
;	check for motor speed delay
;
	LD	A,(IY+3)	;get flag byte
	BIT	3,A		;read or write?
	JR	NZ,SELWRT	;write, go!
;
;	operation is READ, check for delay
;
	BIT	4,A		;read delay?
	JR	Z,SELLOOP	;don't bother
	LD	A,80H		;1/2 second delay
	JR	SELDLY		;continue
;
;	operation is WRITE or READ WITH DELAY
;	wait for drive to come up to speed
;
SELWRT	RLCA			;move bit 5 => 7
	RLCA
	CPL			;reverse bits
	AND	80H		;mask all the others
;
SELDLY	PUSH	BC		;save it
	LD	B,A		;give to B for count
	LD	C,0		;BC = 1/2 or 1 second
	CALL	DELAY		;countdown till BC=0
	POP	BC		;restore
	JR	SELLOOP		;see if ready now
;
;	short wait for FDC to place valid status
;	on the bus after a command has been
;	issued to it
;
DSKSLO	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	RET
;
	PAGE
;
;	$DELAY	- countdown BC till zero
;
;	ENT	BC = value to decrement
;
;	EXT	BC = 0
;
;	NOTE	if high speed clock set, then the
;		delay is actually doubled to adjust
;
;	A is preserved
;
DELAY	PUSH	AF		;save it
;
	PUSH	BC		;save count
	LD	A,(FLAGA)	;get system flag A
	BIT	6,A		;highspeed ON?
	CALL	NZ,DELAYX	;yes, delay once
	POP	BC		;restore original
;
	CALL	DELAYX		;delay again (or first)
;
	POP	AF		;restore AF
	RET			;done, return
;
DELAYX	DEC	BC		;decrement once
	LD	A,B		;check for zero
	OR	C		;any bits on?
	JR	NZ,DELAYX	;if yes, go more
	RET			;else done
;
	PAGE
;
;	$GETDIR	- fetch directory data
;
;	ENT	none
;
;	EXT	DE => first sector in directory
;		A = number of sectors in directory
;
GETDIR	LD	D,(IY+1)	;fetch directory track
	CALL	FIRSTS		;get first sect on track
;
	LD	A,10		;number sectors/track
	BIT	6,(IY+4)	;single density?
	RET	Z		;yes, must be 10
;
	LD	A,18		;18 sectors double den
	RET
;
	PAGE
;
;	$RESTORE - move a drive head to track 0
;
;	ENT	(DRIVE) setup
;
;	EXT	Z = drive ready, head at track 0
;		NZ = A = error status
;
RESTORE	XOR	A		;fast restore command
	CALL	MOVCOMM		;common head mover
	RET	NZ		;error, return NZ
;i*
	IF	MODI
	LD	A,(37ECH)	;fetch the FDC status
	ENDIF
;i*
;
;iii*
	IF	MODIII
	IN	A,(0F0H)	;FDC status III
	ENDIF
;iii*
	CPL			;reverse the bits
	RRCA			;align for special code
	AND	2		;check for head over 00
	RET	Z		;return if OK
	SET	7,(IY+3)	;set soft 'not in system'
	RET			;return NZ
;
;	common head move subroutine, A = command
;
MOVCOMM	LD	(SAVMOV),A	;save for later mask
;i*
	IF	MODI
	LD	HL,37ECH	;point to FDC
	ENDIF
;i*
	CALL	SELECT		;turn on drive
	RET	NZ		;error now, return
;
;	compute step rate for drive
;
	LD	A,(IY+3)	;get drive flag
	AND	3		;set step speed
	OR	0		;or with command mask
SAVMOV	EQU	$-1
	CALL	MOVHEAD		;move the head to track
	JP	Z,IOCOMM	;no error, update track
;
;	seek error, force a $RESTORE next access
;
SKERR	LD	(IY+2),0	;set curr track to 0
	RET			;ret NZ flag
;
;	issue head motion command to FDC and wait
;
MOVHEAD	EQU	$
;i*
	IF	MODI
	LD	(HL),A		;give to FDC I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	OUT	(0F0H),A	;give to FDC III
	ENDIF
;iii*
	CALL	DSKSLO		;wait for valid status
;
MOVWT	CALL	SELECT		;prevent time-out
	RET	NZ		;quit if drops ready
;i*
	IF	MODI
	LD	A,(HL)		;fetch status byte I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	IN	A,(0F0H)	;fetch status III
	ENDIF
;iii*
	AND	1		;command finished?
	JR	NZ,MOVWT	;wait some more if not
;
	RET			;done, NZ = error
;
	PAGE
;
;	$STEPIN	- step in the head one track
;
;	if double step is on, head moved 2 tracks
;
STEPIN	BIT	2,(IY+3)	;double step?
	CALL	NZ,GOSTPIN	;step twice if set
;
GOSTPIN	LD	A,58H		;fast step in command
	JR	MOVCOMM		;go common sub
;
;	$STEPOUT - step track out one track
;
;	step twice if double-step flag on
;
STEPOUT	BIT	2,(IY+3)	;flag on?
	CALL	NZ,GOSTPOT	;step out if yes
;
GOSTPOT	LD	A,78H		;fast step out command
	JR	MOVCOMM		;go common!
;
;	execute actual seek command here
;
DOSEEK	LD	A,18H		;fast seek command
	CALL	MOVCOMM		;move the head
	RET	NZ		;error, return
;
	LD	A,D		;fetch track
;i*
	IF	MODI
	LD	(37EDH),A	;give to FDC track reg
	ENDIF
;i*
;
;iii*
	IF	MODIII
	OUT	(0F1H),A	;FDC track reg III
	ENDIF
;
	RET			;done, FDC updated
;
	PAGE
;
;	$SETDRV	- setup a drive for disk I/O
;
;	ENT	A = binary drive number (0-7)
;
;	EXT	(DRIVE) bit pattern set for $SELECT
;		IY => drives DCT
;		A = drive number in ASCII
;
SETDRV	AND	DRIVES-1	;drives 0-7 valid only
	LD	(DRIV),A	;save binary drive
;
	PUSH	BC		;save this
	LD	C,1		;start with bit 0
;
	JR	Z,SETDDN	;have bit if yes
SETDLP	SLA	C		;move drive bit left
	DEC	A		;binary -1
	JR	NZ,SETDLP	;go again if more
;
SETDDN	LD	A,C		;get bit pattern
	LD	(DRIVE),A	;save for $SELECT
;
;	fetch DCT address
;
	LD	A,(DRIV)	;get binary back
	ADD	A,A		;times 2 for table
	LD	BC,DCTTBL	;table of DCT's
	ADD	A,C		;add offset to LSB
	LD	C,A		;put it back
	JR	NC,DCTFF	;did not cross page
	INC	B		;else bump the page
;
DCTFF	PUSH	BC		;pass it to IY
	POP	IY		;DCT entry
	LD	C,(IY+0)	;get indirect address
	LD	B,(IY+1)
	PUSH	BC		;pass to IY
	POP	IY		;IY => DCT
;
	POP	BC		;restore it
;
;	$DRVASC	- fetch drive number in ascii
;
;	ENT	(DRIV) = binary drive number
;
;	EXT	A = ascii for drive number
;
DRVASC	LD	A,(DRIV)	;get binary drive
	ADD	A,'0'		;make it ascii
	RET			;that's all
;
	PAGE
;
;	$SETNMI	- setup for non-maskable disk interrupts
;
;	ENT	BC = disk buffer
;		DE = track sector
;
;	EXT	NMI set for I/O
;		HL = buffer address
;
;	NOTE	this if for the Mod III ONLY!
;
;iii*
	IF	MODIII
SETNMI	LD	(BUFPAS),BC	;save buffer pointer
	LD	(SECPAS),DE	;save track/sector
;
	LD	HL,NMIRET	;non-maskable return
	LD	(404AH),HL	;set NMI vector
;
	LD	H,B		;pass buffer to HL
	LD	L,C
;
	LD	A,(DRIVE)	;get drive bits
	AND	0FH		;mask low bits
	LD	C,A		;save it here
;
;	check for double density
;
	LD	A,(FLAGB)	;get system flag B
	BIT	4,A		;double den available?
	JR	NZ,GETNMIB	;go if none
;
	BIT	6,(IY+4)	;double den disk?
	JR	Z,GETNMIB	;go if not
;
	LD	A,D		;get track
	OR	A		;on track 0?
	JR	NZ,SETNMIP	;set double den
;
;	double density track 0?
;
	BIT	7,(IY+4)	;double den 0?
	JR	Z,GETNMIB	;go if not
;
;	set double density bit
;
SETNMIP	SET	7,C		;double den bit
;
;	check for write pre-comp
;
GETNMIB	LD	A,D		;check track?
	CP	16H		;for write pre-comp
	JR	C,GETNMIC	;go if below
;
	SET	5,C		;set write pre-comp
;
;	save resulting byte
;
GETNMIC	LD	A,C		;get result
	LD	(DRIVE),A	;setup for drive select
	OUT	(0F4H),A	;give to FDC select
;
;	setup registers for I/O
;
	OR	40H		;set wait states
	LD	D,A		;pass here
	LD	BC,00F3H	;B=counter, C=xfer port
	LD	E,2		;for bit 1 test on I/O
;
	LD	A,0C0H		;activate nmi
	OUT	(0E4H),A	;ON!
;
	IN	A,(0F0H)	;clear FDC status reg.
	DI			;disable for transfer
	RET			;done!
;
;	return vector for NMI interrupt on disk I/O
;
NMIRET	XOR	A		;disable NMI
	OUT	(0E4H),A	;OFF!
	LD	(TEMPFF),HL	;save last byte address+1
	LD	HL,RETNMI	;point to RETN
	LD	(404AH),HL	;for non-disk NMI's
;
	POP	HL		;dummy to restore stack
	LD	BC,(BUFPAS)	;restore buffer
	LD	DE,(SECPAS)	;restore track/sector
	INC	B		;bump buffer pointer
;
	IN	A,(0F0H)	;read status
	LD	(RESULT),A	;save the direct result
;
	CALL	RESFDC		;reset FDC
	EI			;can enable now
	RET			;done, A = I/O status
	ENDIF
;iii*
;
RESELEC	LD	A,(DRIVE)	;get bit pattern
;i*
	IF	MODI
	LD	(37E1H),A	;FDC select reg I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	OUT	(0F4H),A	;FDC select reg III
	ENDIF
;iii*
	RET			;done
;
;	assure fdc READ/WRITE command is in range
;
FIXREAD	PUSH	BC		;save
	CALL	FIXSET		;get IBM flag in B
	LD	A,B		;get result
	OR	80H		;create command
	LD	(RDTYPE),A	;save it
	POP	BC		;unstack
	RET			;done
;
FIXWRIT	PUSH	BC		;save
	CALL	FIXSET		;get IBM flag in B
	LD	A,(WRTYPE)	;get write type
	AND	3		;low 2 bits
	AND	C		;set bit 1/0
	OR	B		;adjust it
	OR	0A0H		;create command
	LD	(WRTYPE),A	;save it
	POP	BC		;unstack
	RET			;done
;
FIXSET	EQU	$
;i*
	IF	MODI
	LD	BC,0803H	;B=IBM bit, C=AM bits
	BIT	6,(IY+4)	;double density disk?
	RET	Z		;nope, return
	BIT	7,(IY+4)	;double track 0?
	JR	NZ,FIXSETD	;yes, go!
	INC	D		;on track 0?
	DEC	D
	RET	Z		;yes, have flags
	ENDIF
;i*
;
FIXSETD	LD	BC,0001H	;B=IBM bit, C=AM bit
	RET			;done
