MAIL4  ;mail4/asm
 @OPEN	EQU	4424H
 @INIT	EQU	4420H
 @RUN	EQU	4433H
 @READ	EQU	4436H
 @POSN	EQU	4442H
 @WRITE	EQU	4439H
 @DATE1	EQU	4470H
 @DATE3	EQU	3033H
 @DSP	EQU	33H
 @CLOSE	EQU	4428H
 @ERROR	EQU	4409H
 @FSPEC	EQU	441CH
 @KBD	EQU	2BH
 FCB1	EQU	5200H
 FCB2	EQU	5220H
 FCB3	EQU	5240H
 SYSTEM	EQU	5260H
 RUNNER	EQU	52A0H
 STRING	EQU	52C0H
 FLAGNAMES EQU	5300H
 WORK1	EQU	53C0H
 WORK2	EQU	53E0H
 BUFF1	EQU	5400H
 BUFF2	EQU	5500H
 BUFF3	EQU	5600H
 	ORG	5700H
 ENTRY	LD	IY,SYSTEM
 	BIT	3,(IY)
 	JP	NZ,RECOVER
 	LD	(IY+1),0
 	LD	A,(4)
 	CP	30H
 	LD	HL,4412H
 	JR	Z,GTOP
 	LD	HL,404AH
 GTOP	LD	H,(HL)
 	LD	L,0
 	DEC	H
 	DEC	H
 	LD	(TOPMEM),HL
 	LD	L,(IY+4)
 	LD	H,(IY+5)
 	LD	IX,MSG0A
 	CALL	WRLNO
 	LD	L,(IY+6)
 	LD	H,(IY+7)
 	LD	IX,MSG0B
 	CALL	WRLNO
 	CALL	CLS
 	LD	HL,MSG0
 	CALL	DISPLAY
 	BIT	0,(IY)
 	LD	HL,MSG3
 	JR	NZ,ENTRY0
 	LD	HL,MSG2
 	CALL	DISPLAY
 	LD	A,(IY+12)
 	CALL	GETSORT
 	LD	A,(IY+13)
 	INC	A
 	JR	Z,ENTRY00
 	CALL	DISPLAY
 	LD	A,'/'
 	CALL	VOUT
 	LD	A,(IY+13)
 	CALL	GETSORT
 ENTRY00	CALL	DISPLAY
 	LD	HL,MSG2A
 	CALL	DISPLAY
 	LD	DE,FCB1
 	LD	BC,0
 	CALL	@POSN
 	JR	NZ,ERROR
 	CALL	@READ
 	JR	NZ,ERROR
 	LD	HL,BUFF1+20H
 	LD	DE,MSG6
 	PUSH	DE
 	LD	BC,8
 	LDIR
 	POP	HL
 ENTRY0	CALL	DISPLAY
 	JR	START
 ERROR	PUSH	AF
 	CALL	CLS
 	POP	AF
 	OR	0C0H
 	CALL	@ERROR
 	LD	HL,MSG1
 	CALL	DISPLAY
 	LD	B,1
 	CALL	GETSTR
 START	LD	IY,SYSTEM
 	LD	L,(IY+14)
 	LD	H,(IY+15)
 	LD	SP,HL
 	LD	HL,MSG5
 	CALL	DISPLAY
 	LD	B,1
 	CALL	GETSTR
 	JP	C,EXIT
 	JP	Z,SORT
 	LD	HL,TABLE0
 	CALL	GOTABLE
 	JR	START
 COMPSEC	SRL	B
 	RR	C
 	LD	A,0
 	RET	NC
 	LD	A,80H
 	RET
 GETRECORD
 	LD	BC,(ARECORD)
 	CALL	COMPSEC
 	LD	(IY+16),A
 	INC	BC
 	BIT	7,(IY+1)
 	JR	Z,ANOT
 	LD	HL,0
 ADDIN	EQU	$-2
 	OR	A
 	SBC	HL,BC
 	JR	Z,AIN
 	RES	7,(IY+1)
 ANOT	LD	(ADDIN),BC
 	LD	DE,FCB3
 	CALL	@POSN
 	JP	NZ,ERROR
 	CALL	@READ
 	JP	NZ,ERROR
 	SET	7,(IY+1)
 AIN	RET
 ADDRECORD
 	LD	BC,(DRECORD)
 	CALL	COMPSEC
 	LD	(IY+17),A
 	BIT	6,(IY+1)
 	JR	Z,DNOT
 	LD	HL,0
 DATIN	EQU	$-2
 	OR	A
 	SBC	HL,BC
 	JR	Z,DIN
 	RES	6,(IY+1)
 DNOT	LD	(DATIN),BC
 	LD	DE,FCB2
 	CALL	@POSN
 	JP	NZ,ERROR
 	CALL	@READ
 	JP	NZ,ERROR
 	SET	6,(IY+1)
 DIN	LD	HL,BUFF3
 	LD	L,(IY+16)
 	LD	DE,BUFF2
 	LD	E,(IY+17)
 	LD	BC,80H
 	LDIR
 	LD	BC,(DATIN)
 	LD	DE,FCB2
 	CALL	@POSN
 	JP	NZ,ERROR
 	CALL	@WRITE
 	JP	NZ,ERROR
 	RET
 MERGE	LD	L,(IY+6)
 	LD	H,(IY+7)
 	LD	A,H
 	OR	L
 	JR	NZ,MERGE0
 	LD	HL,MSG10
 MERGE00	CALL	DISPLAY
 	LD	B,1
 	CALL	GETSTR
 	JP	ENTRY
 MERGE0	LD	(LOOPS),HL
 	LD	HL,MSG9
 	CALL	DISPLAY
 	LD	L,(IY+4)
 	LD	H,(IY+5)
 	LD	DE,(LOOPS)
 	ADD	HL,DE
 	EX	DE,HL
 	LD	L,(IY+2)
 	LD	H,(IY+3)
 	OR	A
 	SBC	HL,DE
 	JR	NC,MERGE1
 	LD	HL,MSG7
 	JR	MERGE00
 MERGE1	LD	L,(IY+4)
 	LD	H,(IY+5)
 	LD	(DRECORD),HL
 	LD	HL,0
 	LD	(ARECORD),HL
 	SET	0,(IY)
 MERGE2	CALL	GETRECORD
 	CALL	ADDRECORD
 	LD	HL,0
 DRECORD	EQU	$-2
 	INC	HL
 	LD	(DRECORD),HL
 	LD	HL,0
 ARECORD	EQU	$-2
 	INC	HL
 	LD	(ARECORD),HL
 	LD	HL,0
 LOOPS	EQU	$-2
 	DEC	HL
 	LD	(LOOPS),HL
 	LD	A,H
 	OR	L
 	JR	NZ,MERGE2	;do 'em all
 	LD	HL,(DRECORD)
 	LD	(IY+4),L
 	LD	(IY+5),H
 	LD	(IY+6),0	;set 0 in adder
 	LD	(IY+7),0
 	LD	DE,FCB1		;update table
 	LD	BC,0
 	CALL	@POSN
 	JP	NZ,ERROR
 	CALL	@READ		;read the sector
 	JP	NZ,ERROR
 	LD	L,(IY+4)
 	LD	H,(IY+5)
 	LD	(BUFF1+2),HL
 	LD	HL,BUFF1+18H
 	CALL	DATE
 	LD	BC,0
 	CALL	@POSN
 	JP	NZ,ERROR
 	CALL	@WRITE
 	JP	NZ,ERROR
 	LD	DE,FCB3
 	LD	BC,0
 	CALL	@POSN
 	JP	NZ,ERROR
 	LD	HL,BUFF3
 	LD	DE,BUFF3+1
 	LD	BC,0FFH
 	LD	(HL),0
 	LDIR
 	LD	HL,BUFF3+18H
 	CALL	DATE
 	LD	DE,FCB3
 	CALL	@WRITE
 	JP	NZ,ERROR
 	LD	HL,MSG8
 	CALL	DISPLAY
 	LD	B,1
 	CALL	GETSTR
 	JP	ENTRY
 SORT	CALL	NUMSON
 	LD	(IY+1),0
 	RES	2,(IY)
 	LD	HL,0
 	LD	(KILLED),HL
 SORT00	LD	HL,MSG11
 	CALL	DISPLAY
 	LD	B,2
 	CALL	GETSTR
 	JP	C,ENTRY
 	JR	Z,SORT00
 	CALL	UCASE
 	CP	'X'
 	JP	Z,ENTRY
 	SUB	30H
 	JR	C,SORT00
 	CP	10
 	JR	NC,SORT00
 	LD	(IY+12),A
 	LD	(IY+13),-1
 	LD	(IY+25),20
 	SET	0,(IY)
 SORTXX	LD	HL,MSG11A
 	CALL	DISPLAY
 	LD	B,2
 	CALL	GETSTR
 	JP	C,ENTRY
 	JR	Z,SORTYY
 	CALL	UCASE
 	CP	'X'
 	JP	Z,ENTRY
 	SUB	30H
 	JR	C,SORTXX
 	CP	10
 	JR	NC,SORTXX
 	LD	(IY+13),A
 	LD	(IY+25),38
 SORTQQ	LD	HL,MSG25
 	CALL	DISPLAY
 	LD	B,2
 	CALL	GETSTR
 	JP	C,ENTRY
 	JR	Z,SORTYY
 	CALL	UCASE
 	CP	'X'
 	JP	Z,ENTRY
 	CP	'N'
 	JR	Z,SORTYY
 	CP	'Y'
 	JR	NZ,SORTQQ
 	SET	2,(IY)
 SORTYY	CALL	NUMSOFF
 SORT11	LD	HL,MSG12
 	CALL	DISPLAY
 	LD	B,1
 	CALL	GETSTR
 	JP	C,ENTRY
 	JR	Z,SORT11
 	CALL	UCASE
 	CP	'X'
 	JP	Z,ENTRY
 	CP	30H
 	JR	C,SORT11
 	CP	38H
 	JR	NC,SORT11
 	LD	(IY+22),A
 	LD	(IY+23),0
 	LD	A,(IY+13)
 	INC	A
 	JR	Z,STXX
 	DEC	A
 	SLA	A
 	LD	C,A
 	LD	B,0
 	LD	HL,TABLE2
 	ADD	HL,BC
 	LD	A,(HL)
 	LD	(IY+30),A
 	INC	HL
 	LD	A,(HL)
 	LD	(IY+31),A
 STXX	LD	A,(IY+12)
 	SLA	A
 	LD	C,A
 	LD	B,0
 	LD	HL,TABLE2
 	ADD	HL,BC
 	LD	A,(HL)
 	LD	(IY+20),A	;field length
 	INC	HL
 	LD	A,(HL)
 	LD	(IY+21),A	;data offset
 	LD	L,(IY+4)	;get # records
 	LD	H,(IY+5)
 	LD	(LOOPS),HL	;save counter
 	LD	HL,-1
 	LD	(RECORD),HL
 SORTER	LD	HL,MSG13
 	CALL	DISPLAY
 	LD	HL,BUFFER
 	LD	(POSIT),HL
 	LD	HL,0
 	LD	(COUNT),HL
 SORTLP	CALL	LOADREC		;read a record
 	LD	HL,(COUNT)
 	INC	HL
 	LD	(COUNT),HL
 	LD	HL,(LOOPS)	;see if done
 	DEC	HL
 	LD	(LOOPS),HL
 	LD	A,H
 	OR	L
 	JR	Z,DONEREAD	;done loading
 	CALL	IFTOP		;at top of memory?
 	JR	NC,SORTLP	;read more if not
 	LD	HL,MSG14
 	CALL	DISPLAY
 	CALL	SORTDATA
 	CALL	SAVETEMP	;save in temp file
 	JR	SORTER		;do more
 DONEREAD LD	A,(IY+23)	;see if any temps
 	OR	A
 	JP	NZ,MERGESORT	;merge the sorted files
 	LD	HL,MSG14
 	CALL	DISPLAY
 	CALL	SORTDATA	;sort the data
 	LD	HL,MSG15
 	CALL	DISPLAY
 	CALL	WRITEINDEX	;write index back to disk
 SORTCOMP LD	BC,0		;update sorted date
 	LD	DE,FCB1
 	CALL	@POSN
 	JP	NZ,ERROR
 	CALL	@READ
 	JP	NZ,ERROR
 	LD	HL,BUFF1+20H
 	CALL	DATE
 	LD	A,-1
 	LD	(BUFF1+8),A
 	LD	A,(IY+12)
 	LD	(BUFF1+9),A
 	LD	A,(IY+13)
 	LD	(BUFF1+10),A
 	LD	BC,0
 	CALL	@POSN
 	JP	NZ,ERROR
 	CALL	@WRITE
 	JP	NZ,ERROR
 	RES	0,(IY)
 	LD	HL,MSG16
 	CALL	DISPLAY
 	BIT	2,(IY)
 	JR	Z,DONEN
 	LD	HL,(KILLED)
 	LD	IX,MSG16A
 	CALL	WRLNO
 	LD	HL,MSG16A
 	CALL	DISPLAY
 DONEN	LD	HL,MSG16B
 	CALL	DISPLAY
 	LD	B,1
 	CALL	GETSTR
 	JP	ENTRY
 MERGESORT
 	LD	HL,MSG14
 	CALL	DISPLAY
 	CALL	SORTDATA
 	CALL	SAVETEMP	;save this file
 	LD	HL,MSG18
 	CALL	DISPLAY
 	RES	2,(IY)
 	CALL	NEWCODE
 	JP	SORTCOMP
 SAVETEMP INC	(IY+23)
 	LD	A,(IY+23)	;get file #
 	CALL	ASCII
 	LD	(FILE4A),A	;to the name
 	LD	(FILE4A+1),BC
 	LD	A,(IY+22)
 	LD	(FILE4B),A
 	LD	HL,FILE4
 	LD	DE,FCB4
 	LD	BC,15
 	LDIR
 	LD	HL,MSG17
 	CALL	DISPLAY
 	LD	DE,FCB4
 	LD	HL,BUFF4
 	LD	B,0
 	CALL	@INIT
 	JP	NZ,ERROR
 	LD	HL,BUFF4
 	LD	DE,BUFF4+1
 	LD	BC,0FFH
 	LD	(HL),0
 	LDIR
 	LD	DE,FCB4
 	LD	HL,0
 COUNT	EQU	$-2
 	LD	(BUFF4),HL
 	CALL	@WRITE
 	JP	NZ,ERROR
 	LD	HL,BUFFER
 	LD	(POSIT),HL
 SAVOLP	LD	HL,0
 	EXX
 	LD	DE,BUFF4
 	LD	HL,(POSIT)
 SAVILP	LD	C,(IY+25)
 	LD	B,0
 	LDIR
 	EXX
 	INC	HL
 	EXX
 	LD	A,E
 	ADD	A,(IY+25)
 	JR	NC,SAVILP
 	LD	(POSIT),HL
 	LD	DE,FCB4
 	CALL	@WRITE
 	JP	NZ,ERROR
 	EXX
 	PUSH	HL
 	EXX
 	POP	DE
 	LD	HL,(COUNT)
 	OR	A
 	SBC	HL,DE
 	LD	(COUNT),HL
 	JR	NC,SAVOLP
 	LD	DE,FCB4
 	CALL	@CLOSE
 	JP	NZ,ERROR
 	RET
 EXIT	CALL	CLS
 	LD	HL,PGM1
 	LD	DE,RUNNER
 	PUSH	DE
 	LD	BC,13
 	LDIR
 	POP	DE
 	JP	@RUN
 RECOVER	LD	HL,MSG23A
 	CALL	DISPLAY
 	LD	C,(IY+2)
 	LD	B,(IY+3)
 	SET	0,(IY)
 	LD	(IY+4),C
 	LD	(IY+5),B	;set max size for files
 	JR	PACKKK
 REPACK	LD	HL,MSG23
 	CALL	DISPLAY
 PACKKK	LD	(IY+1),0
 	LD	HL,0
 	LD	(RECORD),HL
 	LD	(COUNT),HL
 	LD	(REALS),HL
 	SET	0,(IY)
 PACKLP	CALL	GETPACK
 	LD	A,(HL)
 	INC	A
 	LD	DE,(RECORD)
 	PUSH	DE
 	CALL	NZ,ADDREAL
 	CALL	Z,NEWPACK
 	POP	DE
 	INC	DE
 	LD	(RECORD),DE
 	LD	L,(IY+4)
 	LD	H,(IY+5)
 	DEC	HL
 	OR	A
 	SBC	HL,DE
 	JR	NC,PACKLP
 	BIT	3,(IY)		;recovery
 	JR	NZ,RECEND
 	LD	HL,(COUNT)
 	LD	IX,MSG24A
 	CALL	WRLNO
 	LD	HL,MSG24
 RECCONT	CALL	DISPLAY
 	LD	B,1
 	CALL	GETSTR
 	LD	HL,(COUNT)
 	LD	A,H
 	OR	L
 	JP	NZ,ENTRY
 	RES	0,(IY)
 	JP	ENTRY
 RECEND	LD	HL,(REALS)
 	LD	(IY+4),L
 	LD	(IY+5),H
 	LD	IX,MSG99A
 	CALL	WRLNO
 	LD	HL,MSG99
 	RES	3,(IY)
 	JR	RECCONT
 ADDREAL	PUSH	HL
 	LD	HL,0
 REALS	EQU	$-2
 	INC	HL
 	LD	(REALS),HL
 	POP	HL
 	RET
 ;**
 ASCII	LD	B,'0'
 ASC1	SUB	100
 	JR	C,ASC2
 	INC	B
 	JR	ASC1
 ASC2	PUSH	BC
 	ADD	A,100
 	LD	C,'0'
 ASC3	SUB	10
 	JR	C,ASC4
 	INC	C
 	JR	ASC3
 ASC4	ADD	A,3AH
 	LD	B,A
 	POP	AF
 	RET
 GETPACK	LD	BC,(RECORD)
 	CALL	COMPSEC
 	LD	(IY+17),A
 	BIT	5,(IY+1)
 	JR	Z,GETPN
 	LD	HL,(DATIN)
 	OR	A
 	SBC	HL,BC
 	JR	Z,GETPI
 	RES	5,(IY+1)
 GETPN	LD	(DATIN),BC
 	LD	DE,FCB2
 	CALL	@POSN
 	JP	NZ,ERROR
 	CALL	@READ
 	JP	NZ,ERROR
 	SET	5,(IY+1)
 GETPI	LD	HL,BUFF2
 	LD	L,(IY+17)
 	RET
 AGAPAK	LD	HL,(COUNT)
 	INC	HL
 	LD	(COUNT),HL
 NEWPACK	LD	HL,(RECORD)
 	LD	(TEMP),HL
 	LD	L,(IY+4)
 	LD	H,(IY+5)
 	DEC	HL
 	LD	(IY+4),L
 	LD	(IY+5),H
 	LD	(RECORD),HL
 	CALL	GETPACK
 	LD	A,(HL)
 	INC	A
 	JR	Z,AGAPAK
 	LD	DE,DATA
 	LD	BC,80H
 	PUSH	HL
 	LDIR
 	POP	HL
 	LD	(HL),-1
 	LD	D,H
 	LD	E,L
 	INC	DE
 	LD	BC,7FH
 	LDIR
 	LD	BC,(DATIN)
 	LD	DE,FCB2
 	CALL	@POSN
 	JP	NZ,ERROR
 	CALL	@WRITE
 	JP	NZ,ERROR
 	LD	BC,(TEMP)
 	LD	(RECORD),BC
 	CALL	GETPACK
 	EX	DE,HL
 	LD	HL,DATA
 	LD	BC,80H
 	LDIR
 	LD	BC,(DATIN)
 	LD	DE,FCB2
 	CALL	@POSN
 	JP	NZ,ERROR
 	CALL	@WRITE
 	JP	NZ,ERROR
 	LD	HL,(COUNT)
 	INC	HL
 	LD	(COUNT),HL
 	RET
 FETCH	LD	(IY+26),0
 	LD	HL,(POSIT)
 	LD	(TEMP),HL
 	LD	(IY+27),0
 FETLP	INC	(IY+26)
 	CALL	TEMPREC
 	LD	HL,(TOPMEM)
 	LD	DE,(TEMP)
 	OR	A
 	SBC	HL,DE
 	LD	B,-1
 	JP	C,MEMOUT
 	LD	A,(IY+26)
 	CP	(IY+24)
 	JR	C,FETLP
 	LD	A,(IY+27)
 	OR	A
 	RET	Z
 	LD	B,A
 	LD	HL,(POSIT)
 	LD	D,H
 	LD	E,L
 	LD	(BASE),HL
 S1	CALL	COMPARE
 	JR	NC,S2
 	LD	(BASE),DE
 S2	PUSH	HL
 	LD	L,(IY+25)
 	LD	H,0
 	INC	HL
 	ADD	HL,DE
 	EX	DE,HL
 	POP	HL
 	DJNZ	S1
 	LD	HL,(BASE)
 	LD	E,(IY+25)
 	LD	D,0
 	ADD	HL,DE
 	LD	A,(HL)
 	DEC	A
 	LD	L,A
 	LD	H,0
 	ADD	HL,HL
 	ADD	HL,HL
 	ADD	HL,HL
 	LD	DE,FCB4
 	ADD	HL,DE
 	PUSH	HL
 	POP	IX
 	LD	E,(IX+4)
 	LD	D,(IX+5)
 	LD	L,(IY+25)
 	LD	H,0
 	ADD	HL,DE
 	LD	(IX+4),L
 	LD	(IX+5),H
 	LD	L,(IX+6)
 	LD	H,(IX+7)
 	DEC	HL
 	LD	(IX+6),L
 	LD	(IX+7),H
 	RET
 TEMPREC	LD	A,(IY+26)
 	DEC	A
 	LD	L,A
 	LD	H,0
 	ADD	HL,HL
 	ADD	HL,HL
 	ADD	HL,HL
 	LD	DE,FCB4
 	ADD	HL,DE
 	PUSH	HL
 	POP	IX
 	LD	A,(IX+6)
 	OR	(IX+7)
 	RET	Z
 	LD	L,(IX+2)
 	LD	H,(IX+3)
 	LD	E,(IX+4)
 	LD	D,(IX+5)
 	INC	H
 	PUSH	HL
 	LD	L,(IY+25)
 	LD	H,0
 	ADD	HL,DE
 	EX	DE,HL
 	POP	HL
 	OR	A
 	SBC	HL,DE
 	JR	NC,TPO
 TP0	PUSH	IX
 	LD	E,(IX)
 	LD	D,(IX+1)
 	CALL	@READ
 	POP	IX
 	JR	NZ,TPX
 	LD	A,(IX+2)
 	LD	(IX+4),A
 	LD	A,(IX+3)
 	LD	(IX+5),A
 TPO	LD	DE,0
 TEMP	EQU	$-2
 	LD	L,(IX+4)
 	LD	H,(IX+5)
 	LD	C,(IY+25)
 	LD	B,0
 	LDIR
 	LD	A,(IY+26)
 	LD	(DE),A
 	INC	DE
 	LD	(TEMP),DE
 	INC	(IY+27)
 	RET
 TPX	LD	(IX+6),0
 	LD	(IX+7),0
 	RET
 OPENEM	LD	B,(IY+24)
 	LD	IX,FCB4
 	LD	DE,BUFFER+200H
 	LD	C,1
 OPENLP	PUSH	BC
 	CALL	OPENIT
 	POP	BC
 	LD	HL,(TOPMEM)
 	OR	A
 	SBC	HL,DE
 	JR	C,MEMOUT
 	INC	C
 	PUSH	DE
 	LD	DE,8
 	ADD	IX,DE
 	POP	DE
 	DJNZ	OPENLP
 OUTMEM	LD	(POSIT),DE
 	RET
 MEMOUT	DEC	B
 	JR	Z,OUTMEM
 	LD	HL,MSGM
 	CALL	DISPLAY
 	LD	B,1
 	CALL	GETSTR
 	JP	ENTRY
 OPENIT	LD	(IX),E
 	LD	(IX+1),D
 	LD	HL,32
 	ADD	HL,DE
 	LD	(IX+2),L
 	LD	(IX+3),H
 	LD	(IX+4),L
 	LD	(IX+5),H
 	LD	A,C
 	CALL	ASCII
 	LD	(FILE4A),A
 	LD	(FILE4A+1),BC
 	PUSH	DE
 	PUSH	HL
 	LD	HL,FILE4
 	LD	BC,32
 	LDIR
 	POP	HL
 	POP	DE
 	LD	B,0
 	PUSH	IX
 	CALL	@OPEN
 	POP	IX
 	JP	NZ,ERROR
 	PUSH	IX
 	CALL	@READ
 	POP	IX
 	JP	NZ,ERROR
 	LD	L,(IX+2)
 	LD	H,(IX+3)
 	PUSH	HL
 	LD	DE,100H
 	ADD	HL,DE
 	EX	DE,HL
 	POP	HL
 	LD	A,(HL)
 	LD	(IX+6),A
 	INC	HL
 	LD	A,(HL)
 	LD	(IX+7),A
 	PUSH	DE
 	LD	E,(IX)
 	LD	D,(IX+1)
 	PUSH	IX
 	CALL	@READ
 	POP	IX
 	POP	DE
 	JP	NZ,ERROR
 	RET
 COMP	PUSH	HL
 	PUSH	DE
 	PUSH	BC
 	LD	B,18
 COMPL	LD	A,(DE)
 	CP	(HL)
 	JR	NZ,COMPD
 	INC	HL
 	INC	DE
 	DJNZ	COMPL
 COMPD	POP	BC
 	POP	DE
 	POP	HL
 	RET
 NEWCODE	LD	A,(IY+23)
 	LD	(IY+24),A
 	CALL	OPENEM
 	LD	HL,BUFF1
 	LD	(POS),HL
 NEWCLP	CALL	FETCH
 	LD	A,(IY+27)
 	OR	A
 	JR	Z,NEWFL
 	CALL	STASH
 	JR	NEWCLP
 STASH	LD	HL,(BASE)
 	LD	DE,0
 POS	EQU	$-2
 	LD	A,E
 	ADD	A,20
 	JR	NC,STS0
 	LD	DE,FCB1
 	PUSH	HL
 	CALL	@WRITE
 	POP	HL
 	JP	NZ,ERROR
 	LD	DE,BUFF1
 STS0	LD	BC,20
 	LDIR
 	LD	(POS),DE
 	RET
 NEWFL	LD	DE,FCB1
 	CALL	@WRITE
 	JP	NZ,ERROR
 	RET
 FLICKER	PUSH	AF
 	LD	A,(4)
 	CP	30H
 	JR	Z,FLICK3
 	LD	A,(37E0H)
 	BIT	6,A
 	JR	NZ,RESETFDC
 	BIT	7,A
 	JR	Z,TASKDONE
 	JR	FLICK
 FLICK3	IN	A,(0E0H)
 	AND	4
 	JR	NZ,TASKDONE
 FLICK	LD	A,3
 TSKCNT	EQU	$-1
 	DEC	A
 	LD	(TSKCNT),A
 	JR	NZ,TASKDONE
 	LD	A,3
 	LD	(TSKCNT),A
 	PUSH	HL
 	LD	HL,(4020H)
 	INC	HL
 	INC	HL
 	LD	A,(HL)
 	SLA	A
 	JR	NC,NEWTSK
 	AND	3FH
 	JR	NZ,PUTTSK
 NEWTSK	LD	A,1
 PUTTSK	OR	80H
 	LD	(HL),A
 	POP	HL
 TASKDONE LD	A,(4)
 	CP	30H
 	JR	Z,DONE3
 DONE1	LD	A,(37E0H)
 	JR	DONEALL
 DONE3	IN	A,(0ECH)
 DONEALL	POP	AF
 	EI
 	RET
 RESETFDC LD	A,(37ECH)
 	JR	DONE1
 SPENAME	LD	A,(HL)
 	CP	','
 	JR	Z,SPEFIRST
 	LD	DE,DATA
 	LD	B,15
 SPE1	LD	A,(HL)
 	CP	5FH
 	RET	Z
 	CP	','
 	JR	Z,SPE2
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	DJNZ	SPE1
 	RET
 SPE2	INC	HL
 	LD	DE,DATA+15
 	LD	B,12
 SPE3	LD	A,(HL)
 	CP	5FH
 	RET	Z
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	DJNZ	SPE3
 	RET
 SPEFIRST INC	HL
 	LD	DE,DATA+15
 	LD	B,12
 SPE4	LD	A,(HL)
 	CP	20H
 	JR	Z,SPE5
 	CP	5FH
 	RET	Z
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	DJNZ	SPE4
 	RET
 SPE5	INC	HL
 	LD	DE,DATA
 	LD	B,15
 SPE6	LD	A,(HL)
 	CP	5FH
 	RET	Z
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	DJNZ	SPE6
 	RET
 NULL	LD	HL,DATA
 	LD	DE,DATA+1
 	LD	BC,125
 	LD	(HL),20H
 	LDIR
 	LD	(HL),0
 	LD	BC,2
 	LDIR
 	RET
 GPOST	LD	BC,(RECORD)
 	LD	A,B
 	OR	C
 	JR	NZ,GPOSTGO
 	LD	BC,(BUFF4+8)
 	DEC	BC
 	LD	(RECORD),BC
 POSTNO	POP	BC
 	JP	LDREC
 GPOSTGO	LD	A,(HL)
 	OR	A
 	JR	NZ,GPOSTOK
 	INC	HL
 	LD	A,(HL)
 	DEC	HL
 	CP	0FFH
 	JR	Z,POSTNO
 GPOSTOK	LD	BC,10
 	LD	DE,DATA
 	LD	A,15
 	CALL	PLACE
 	LD	BC,25
 	LD	DE,DATA+15
 	LD	A,12
 	CALL	PLACE
 	LD	BC,40
 	LD	DE,DATA+27
 	LD	A,18
 	CALL	PLACE
 	LD	BC,66
 	LD	DE,DATA+45
 	LD	A,24
 	CALL	PLACE
 	LD	BC,92
 	LD	DE,DATA+79
 	LD	A,15
 	CALL	PLACE
 	LD	BC,107
 	LD	DE,DATA+95
 	LD	A,5
 	CALL	PLACE
 	LD	BC,112
 	LD	DE,DATA+103
 	LD	A,9
 	CALL	PLACE
 	LD	BC,121
 	LD	DE,DATA+113
 	LD	A,2
 	CALL	PLACE
 	LD	BC,123
 	LD	DE,DATA+119
 	LD	A,5
 	JP	PLACE
 GGALA	LD	BC,0
 	LD	DE,DATA
 	LD	A,15
 	CALL	PLACE
 	LD	BC,27
 	LD	DE,DATA+15
 	LD	A,12
 	CALL	PLACE
 	LD	BC,54
 	LD	DE,DATA+45
 	LD	A,24
 	CALL	PLACE
 	LD	BC,81
 	LD	DE,DATA+79
 	LD	A,15
 	CALL	PLACE
 	LD	BC,96
 	LD	DE,DATA+95
 	LD	A,3
 	CALL	PLACE
 	LD	BC,99
 	LD	DE,DATA+103
 	LD	A,10
 	CALL	PLACE
 	LD	BC,122
 	LD	DE,DATA+113
 	LD	A,6
 	JP	PLACE
 GMINE	LD	DE,DATA
 	LD	BC,128
 	LDIR
 	DEC	DE
 	LD	A,80H
 	LD	(DE),A
 	RET
 GSPE	PUSH	HL
 	CALL	SPENAME
 	POP	HL
 	LD	BC,25
 	LD	DE,DATA+27
 	LD	A,18
 	CALL	PLACE
 	LD	BC,50
 	LD	DE,DATA+45
 	LD	A,24
 	CALL	PLACE
 	LD	BC,75
 	LD	DE,DATA+79
 	LD	A,16
 	CALL	PLACE
 	LD	BC,93
 	LD	DE,DATA+95
 	LD	B,2
 	CALL	PLACE
 	LD	BC,95
 	LD	DE,DATA+103
 	LD	A,5
 	CALL	PLACE
 	LD	BC,100
 	LD	DE,DATA+69
 	LD	A,10
 	CALL	PLACE
 	LD	BC,114
 	LD	DE,DATA+113
 	LD	A,12
 PLACE	PUSH	HL
 	ADD	HL,BC
 	LD	B,A
 PLCLP	LD	A,(HL)
 	CP	5FH
 	JR	Z,PLCDN
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	DJNZ	PLCLP
 PLCDN	POP	HL
 	RET
 PTREC	LD	C,(IY+6)
 	LD	B,(IY+7)
 	CALL	COMPSEC
 	LD	(IY+16),A
 	INC	BC
 	BIT	7,(IY+1)
 	JR	Z,PTNOT
 	LD	HL,(ADDIN)
 	OR	A
 	SBC	HL,BC
 	JR	Z,PTIN
 	RES	7,(IY+1)
 PTNOT	LD	(ADDIN),BC
 	LD	DE,FCB3
 	CALL	@POSN
 	JR	Z,PTOK1
 	CP	1CH
 	JR	Z,PTOK2
 	CP	1DH
 	JP	NZ,ERROR
 	JR	PTOK2
 PTOK1	CALL	@READ
 	JP	NZ,ERROR
 PTOK2	SET	7,(IY+1)
 PTIN	LD	DE,BUFF3
 	LD	E,(IY+16)
 	LD	HL,DATA
 	LD	BC,128
 	LDIR
 	LD	BC,(ADDIN)
 	LD	DE,FCB3
 	CALL	@POSN
 	JR	Z,PTOK
 	CP	1CH
 	JR	Z,PTOK
 	CP	1DH
 	JP	NZ,ERROR
 PTOK	CALL	@WRITE
 	JP	NZ,ERROR
 	LD	L,(IY+6)
 	LD	H,(IY+7)
 	INC	HL
 	LD	(IY+6),L
 	LD	(IY+7),H
 	RET
 LDREC	LD	BC,(RECORD)
 	INC	BC
 	LD	(RECORD),BC
 	CALL	COMPSEC
 	LD	(IY+17),A
 	BIT	6,(IY+1)
 	JR	Z,LDNOT
 	LD	HL,(DATIN)
 	OR	A
 	SBC	HL,BC
 	JR	Z,LDIN
 	RES	6,(IY+1)
 LDNOT	LD	(DATIN),BC
 	LD	DE,FCB4
 	CALL	@POSN
 	RET	NZ
 	CALL	@READ
 	RET	NZ
 	SET	6,(IY+1)
 LDIN	CALL	NULL
 	LD	HL,BUFF4
 	LD	L,(IY+17)
 	CALL	0
 CONVCALL EQU	$-2
 	XOR	A
 	RET
 CONVERT	CALL	CLS
 	LD	(IY+1),0
 	LD	HL,MSG19
 	CALL	DISPLAY
 	LD	B,1
 	CALL	GETSTR
 	JP	C,ENTRY
 	JR	Z,CONVERT
 	CALL	UCASE
 	CP	'X'
 	JP	Z,ENTRY
 	LD	HL,TABLE19
 	CALL	GOTABLE
 	JR	CONVERT
 POSTMAN	LD	HL,GPOST
 	JR	CONVERT0
 GALACTIC LD	HL,GGALA
 	JR	CONVERT0
 SPECIAL	LD	HL,GSPE
 	JR	CONVERT0
 CONVMINE	LD	HL,GMINE
 CONVERT0 LD	(CONVCALL),HL
 	CALL	CLS
 	JR	CONVERT1
 CONVBAD	OR	0C0H
 	LD	HL,3C00H+768
 	LD	(4020H),HL
 	CALL	@ERROR
 CONVERT1 LD	HL,MSG20
 	CALL	DISPLAY
 	LD	B,25
 	CALL	GETSTR
 	JP	C,ENTRY
 	JP	Z,ENTRY
 	BIT	1,(IY)	;ldos?
 	JR	Z,NOTL
 	LD	DE,FCB4
 	CALL	@FSPEC
 	JR	NZ,CONVBAD
 	JR	LNOT
 NOTL	LD	DE,FCB4
 	LD	C,B
 	LD	B,0
 	INC	BC
 	LDIR
 LNOT	CALL	CLS
 	LD	DE,FCB4
 	LD	B,0
 	LD	HL,BUFF4
 	CALL	@OPEN
 	JR	NZ,CONVBAD
 	LD	HL,MSG21
 	CALL	DISPLAY
 	LD	HL,0
 	LD	(LOOPS),HL
 	DEC	HL
 	LD	(RECORD),HL
 CONVLP	CALL	LDREC
 	JR	NZ,CONVDONE
 	CALL	PTREC
 	LD	HL,(LOOPS)
 	INC	HL
 	LD	(LOOPS),HL
 	JR	CONVLP
 CONVDONE
 	LD	BC,0
 	LD	DE,FCB3
 	CALL	@POSN
 	JR	NZ,CONVERR
 	CALL	@READ
 	JR	NZ,CONVERR
 	LD	BC,0
 	CALL	@POSN
 	JR	NZ,CONVERR
 	LD	L,(IY+6)
 	LD	H,(IY+7)
 	LD	(BUFF3),HL
 	CALL	@WRITE
 	JR	NZ,CONVERR
 CONVBK	LD	HL,(LOOPS)
 	LD	IX,MSG22A
 	CALL	WRLNO
 	LD	HL,MSG22
 	CALL	DISPLAY
 	LD	B,1
 	CALL	GETSTR
 	JP	ENTRY
 CONVERR	PUSH	AF
 	CALL	CLS
 	POP	AF
 	OR	0C0H
 	CALL	@ERROR
 	JR	CONVBK
 SORTDATA
 	DI
 	LD	A,(4012H)
 	LD	(TASK0),A
 	LD	HL,(4013H)
 	LD	(TASK),HL
 	LD	HL,FLICKER
 	LD	(4013H),HL
 	LD	A,0C3H
 	LD	(4012H),A
 	EI
 	LD	HL,BUFFER
 	LD	BC,(COUNT)
 SORT0	LD	(BASE),HL
 	LD	D,H
 	LD	E,L
 	PUSH	BC
 	JR	SORT2
 SORT1	CALL	COMPARE
 	JR	NC,SORT2
 	LD	(BASE),DE
 SORT2	PUSH	HL
 	LD	L,(IY+25)
 	LD	H,0
 	ADD	HL,DE
 	EX	DE,HL
 	POP	HL
 	DEC	BC
 	LD	A,B
 	OR	C
 	JR	NZ,SORT1
 	LD	BC,0
 BASE	EQU	$-2
 	PUSH	HL
 	OR	A
 	SBC	HL,BC
 	POP	HL
 	JR	Z,SORT3
 	CALL	SWAP
 SORT3	LD	B,0
 	LD	C,(IY+25)
 	ADD	HL,BC
 	POP	BC
 	DEC	BC
 	LD	A,B
 	OR	C
 	JR	NZ,SORT0
 	DI
 	LD	HL,0
 TASK	EQU	$-2
 	LD	(4013H),HL
 	LD	A,0
 TASK0	EQU	$-1
 	LD	(4012H),A
 	EI
 	RET
 COMPARE	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 	LD	B,18
 	LD	HL,(BASE)
 COMPLP	LD	A,(DE)
 	CP	(HL)
 	JR	NZ,COMPRET
 	INC	DE
 	INC	HL
 	DJNZ	COMPLP
 COMPRET	POP	HL
 	POP	DE
 	POP	BC
 	RET	NZ
 	LD	A,(IY+13)
 	INC	A
 	SCF
 	CCF
 	RET	Z
 	PUSH	HL
 	PUSH	DE
 	PUSH	BC
 	LD	HL,(BASE)
 	LD	BC,20
 	ADD	HL,BC
 	EX	DE,HL
 	ADD	HL,BC
 	EX	DE,HL
 	LD	B,18
 COMPP	LD	A,(DE)
 	CP	(HL)
 	JR	NZ,COMPBAK
 	INC	HL
 	INC	DE
 	DJNZ	COMPP
 COMPBAK	POP	BC
 	POP	DE
 	POP	HL
 	RET	NZ
 	BIT	2,(IY)
 	RET	Z
 	LD	A,(DE)
 	INC	A
 	SCF
 	CCF
 	RET	Z
 	PUSH	HL
 	PUSH	DE
 	PUSH	BC
 	LD	HL,18
 	ADD	HL,DE
 	LD	BC,(RECORD)
 	PUSH	BC
 	LD	C,(HL)
 	INC	HL
 	LD	B,(HL)
 	LD	(RECORD),BC
 	CALL	GETPACK
 	PUSH	HL
 	LD	DE,13
 	ADD	HL,DE
 	LD	D,H
 	LD	E,L
 	INC	DE
 	LD	BC,14
 	LDDR
 	POP	HL
 	LD	(HL),-1
 	LD	BC,(DATIN)
 	LD	DE,FCB2
 	CALL	@POSN
 	POP	BC
 	LD	(RECORD),BC
 	JP	NZ,ERROR
 	CALL	@WRITE
 	JP	NZ,ERROR
 	LD	HL,0
 KILLED	EQU	$-2
 	INC	HL
 	LD	(KILLED),HL
 	POP	BC
 	POP	DE
 	POP	HL
 	LD	A,-1
 	LD	(DE),A
 	XOR	A
 	RET
 SWAP	PUSH	HL
 	PUSH	DE
 	PUSH	BC
 	LD	DE,(BASE)
 	LD	B,(IY+25)
 SWAPLP	LD	A,(HL)
 	EX	AF,AF'
 	LD	A,(DE)
 	LD	(HL),A
 	EX	AF,AF'
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	DJNZ	SWAPLP
 	POP	BC
 	POP	DE
 	POP	HL
 	RET
 LOADREC
 	LD	BC,0
 RECORD	EQU	$-2
 	INC	BC
 	LD	(RECORD),BC
 	CALL	GETPACK
 	LD	DE,0
 POSIT	EQU	$-2
 	LD	A,(IY+21)
 	ADD	A,L
 	LD	L,A
 	LD	C,(IY+20)
 	LD	B,0
 	CALL	LDIR
 	LD	A,18
 	SUB	(IY+20)
 	EX	DE,HL
 	JR	Z,RINI
 RINO	LD	(HL),20H
 	INC	HL
 	DEC	A
 	JR	NZ,RINO
 RINI	LD	DE,(RECORD)
 	LD	(HL),E
 	INC	HL
 	LD	(HL),D
 	INC	HL
 	LD	(POSIT),HL
 	LD	A,(IY+13)
 	INC	A
 	RET	Z
 	EX	DE,HL
 	LD	HL,BUFF2
 	LD	L,(IY+17)
 	LD	A,(IY+31)
 	ADD	A,L
 	LD	L,A
 	LD	C,(IY+30)
 	LD	B,0
 	CALL	LDIR
 	LD	A,18
 	SUB	(IY+30)
 	EX	DE,HL
 	JR	Z,RN1
 RN0	LD	(HL),20H
 	INC	HL
 	DEC	A
 	JR	NZ,RN0
 RN1	LD	(POSIT),HL
 	RET
 LDIR	LD	A,(HL)
 	CALL	UCASE
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	DEC	BC
 	LD	A,B
 	OR	C
 	JR	NZ,LDIR
 	RET
 WRITEINDEX
 	LD	HL,BUFFER
 	LD	(POSIT),HL
 	LD	DE,FCB1
 	LD	BC,1
 	CALL	@POSN
 	JP	NZ,ERROR
 WOLP	LD	HL,BUFF1
 	PUSH	HL
 	LD	DE,BUFF1+1
 	LD	BC,0FFH
 	LD	(HL),0
 	LDIR
 	POP	DE
 	LD	HL,(POSIT)
 	LD	A,12
 WILP	LD	BC,20
 	LDIR
 	CALL	CKSVI
 	DEC	A
 	JR	NZ,WILP
 	LD	(POSIT),HL
 	LD	DE,FCB1
 	CALL	@WRITE
 	JP	NZ,ERROR
 	LD	HL,(COUNT)
 	LD	DE,12
 	OR	A
 	SBC	HL,DE
 	LD	(COUNT),HL
 	JR	NC,WOLP
 	RET
 CKSVI	PUSH	AF
 	LD	A,(IY+13)
 	INC	A
 	JR	Z,SKVI
 	PUSH	DE
 	LD	DE,0
 	LD	BC,18
 	LDIR
 	POP	DE
 SKVI	POP	AF
 	RET
 NUMSON	LD	IX,TABLE3
 	LD	BC,0A30H
 NUMOLP	LD	L,(IX)
 	LD	H,(IX+1)
 	LD	(HL),'-'
 	INC	HL
 	INC	HL
 	LD	(HL),C
 	INC	HL
 	INC	HL
 	LD	(HL),'-'
 	INC	IX
 	INC	IX
 	INC	C
 	DJNZ	NUMOLP
 	RET
 NUMSOFF LD	IX,TABLE3
 	LD	B,10
 NUMFLP	LD	L,(IX)
 	LD	H,(IX+1)
 	LD	(HL),20H
 	INC	HL
 	INC	HL
 	LD	(HL),20H
 	INC	HL
 	INC	HL
 	LD	(HL),20H
 	INC	IX
 	INC	IX
 	DJNZ	NUMFLP
 	RET
 IFTOP	LD	HL,0
 TOPMEM	EQU	$-2
 	LD	DE,(POSIT)
 	OR	A
 	SBC	HL,DE
 	RET
 GETSORT	PUSH	DE
 	SLA	A
 	LD	E,A
 	LD	D,0
 	LD	HL,TABLE1
 	ADD	HL,DE
 	LD	A,(HL)
 	INC	HL
 	LD	H,(HL)
 	LD	L,A
 	POP	DE
 	RET
 UCASE	CP	60H
 	RET	C
 	CP	80H
 	RET	NC
 	AND	5FH
 	RET
 DATE	PUSH	IY
 	PUSH	DE
 	LD	A,(4)
 	CP	30H
 	LD	DE,@DATE3
 	JR	Z,GDATE
 	LD	DE,@DATE1
 GDATE	LD	(DCALL),DE
 	CALL	0
 DCALL	EQU	$-2
 	POP	DE
 	POP	IY
 	RET
 PGM1	DB	'PMAIL0/CMD:0',3
 GOTABLE	INC	(HL)	;check for terminator
 	DEC	(HL)
 	RET	Z	;not in table
 	CP	(HL)	;same as entry?
 	JR	Z,GOTBL	;go it if yes
 	INC	HL	;else go to next entry
 	INC	HL
 	INC	HL
 	JR	GOTABLE
 GOTBL	INC	HL	;point to lsb
 	LD	A,(HL)	;get it
 	INC	HL	;point to msb
 	LD	H,(HL)	;get it
 	LD	L,A	;pass lsb
 	EX	(SP),HL	;put there for return
 	RET		;go to it
 CLS	LD	HL,3C00H+768
 	LD	(4020H),HL
 	LD	A,1FH
 VOUT	PUSH	IY
 	PUSH	DE
 	CALL	@DSP
 	POP	DE
 	POP	IY
 	RET
 TENTBL	DW	-10000,-1000,-100,-10,-1
 WRLNO	PUSH	IX
 	LD	DE,TENTBL
 WRL1	LD	A,(DE)
 	LD	C,A
 	INC	DE
 	LD	A,(DE)
 	LD	B,A
 	INC	DE
 	PUSH	DE
 	LD	A,2FH
 WRL2	INC	A
 	LD	D,H
 	LD	E,L
 	ADD	HL,BC
 	JR	C,WRL2
 	EX	DE,HL
 	POP	DE
 	LD	(IX),A
 	INC	IX
 	INC	C
 	JR	NZ,WRL1
 	POP	IX
 	LD	B,4
 WRL3	LD	A,(IX)
 	CP	30H
 	RET	NZ
 	LD	(IX),20H
 	INC	IX
 	DJNZ	WRL3
 	RET
 DISPLAY	PUSH	HL	;save pointer
 DISPLP	LD	A,(HL)	;get a byte
 	INC	HL
 	CP	3
 	JR	Z,DISPDN
 	CP	2
 	JR	Z,NEWADD
 	PUSH	AF
 	CALL	VOUT
 	POP	AF
 	CP	13
 	JR	NZ,DISPLP
 DISPDN	POP	HL
 	RET
 NEWADD	LD	A,(HL)	;get lsb
 	LD	(4020H),A
 	INC	HL
 	LD	A,(HL)
 	LD	(4021H),A
 	INC	HL
 	JR	DISPLP
 GETSTR	LD	C,B	;max length to C
 	LD	HL,(4020H)	;get cursor
 	XOR	A
 	LD	(CARRY),A
 	INC	B
 PUTPER	LD	(HL),95	;prompt
 	INC	HL
 	DJNZ	PUTPER	;do 'em all
 	LD	HL,STRING	;where to put data
 	LD	A,14
 	CALL	VOUT
 SCAN	PUSH	IY
 	CALL	@KBD
 	POP	IY
 	OR	A
 	JR	Z,SCAN
 	CP	1
 	JR	Z,BREAKER
 	CP	18H	;shift left?
 	JR	Z,NEWST
 	CP	8	;backspace?
 	JR	Z,BAKSPA
 	CP	13
 	JR	Z,SCDON
 	CP	20H	;must be data
 	JR	C,SCAN	;ignore
 	CP	80H	;graphic?
 	JR	NC,SCAN
 	LD	(HL),A	;to the buffer
 	LD	A,B
 	CP	C
 	JR	Z,SCAN
 	LD	A,(HL)
 	INC	HL
 	LD	DE,(4020H)
 	LD	(DE),A
 	INC	DE
 	LD	(4020H),DE
 	INC	B
 	LD	A,C
 	CP	1
 	JR	NZ,SCAN	;get more
 	JR	SCDON
 BREAKER	LD	A,37H
 	LD	(CARRY),A
 SCDON	LD	A,C
 	INC	A
 	SUB	B
 	LD	(HL),13
 	JR	Z,SCDON1
 	LD	HL,(4020H)
 SCDON2	LD	(HL),20H
 	INC	HL
 	DEC	A
 	JR	NZ,SCDON2
 SCDON1	LD	A,15
 	CALL	VOUT
 	LD	HL,(4020H)
 	LD	(HL),20H
 	LD	HL,STRING
 	LD	A,B
 	OR	A
 	LD	A,(HL)
 CARRY	NOP
 	RET
 BAKSPA	LD	DE,(4020H)
 	LD	A,B
 	OR	A
 	JR	Z,SCAN
 	LD	A,95
 	LD	(DE),A
 	DEC	DE
 	LD	(DE),A
 	DEC	HL
 	LD	(4020H),DE
 	DEC	B
 	JR	SCAN
 NEWST	LD	DE,(4020H)
 	LD	A,B
 	OR	A
 	JR	Z,SCAN
 	LD	A,95
 NEWSTL	LD	(DE),A
 	DEC	DE
 	DEC	HL
 	LD	(DE),A
 	DJNZ	NEWSTL
 	LD	(4020H),DE
 	JP	SCAN
 ;##
 MSGM	DB	2
 	DW	3C00H+768
 	DB	1FH
 	DB	'Out of Memory, <KEY>:',1FH,3
 MSG0	DB	2
 	DW	3C00H+768
 MSG0A	DB	'xxxxx Data Records - '
 MSG0B	DB	'xxxxx Adder Records',3
 MSG1	DB	2
 	DW	3C00H+960
 	DB	'<KEY> to continue:',1FH,3
 MSG2	DB	2
 	DW	3C00H+832
 	DB	'Sorted by: ',3
 MSG2A	DB	' on: ',3
 MSG3	DB	2
 	DW	3C00H+832
 	DB	'File Not Sorted',3
 MSG7	DB	2
 	DW	3C00H+896
 	DB	1FH
 	DB	'Insufficient Data Space to Add, '
 	DB	'<KEY>:',3
 MSG8	DB	2
 	DW	3C00H+960
 	DB	'Files Merged, <KEY>:',1FH,3
 MSG9	DB	2
 	DW	3C00H+896
 	DB	'Merging DATA and ADDER Files ...',1FH,3
 MSG10	DB	2
 	DW	3C00H+896
 	DB	1FH
 	DB	'Adder File is Empty, <KEY>:',1FH,3
 MSG11	DB	2
 	DW	3C00H+896
 	DB	'Primary Sort Field ? ',1FH,3
 MSG11A	DB	2
 	DW	3C00H+896
 	DB	'Secondary Sort Field ? ',1FH,3
 MSG25	DB	2
 	DW	3C00H+896
 	DB	'Purge Duplicates ? ',1FH,3
 MSG12	DB	2
 	DW	3C00H+896
 	DB	'Drive for Temporary Sort Files ? ',1EH,3
 MSG13	DB	2
 	DW	3C00H+896
 	DB	'Loading ...',1EH,3
 MSG14	DB	2
 	DW	3C00H+896
 	DB	'Sorting ...',1EH,3
 MSG15	DB	2
 	DW	3C00H+896
 	DB	'Writing Index ...',1FH,3
 MSG16	DB	2
 	DW	3C00H+896
 	DB	'Sort Complete, ',3
 MSG16A	DB	'xxxxx Records Purged, ',3
 MSG16B	DB	'<KEY>:',1FH,3
 MSG17	DB	2
 	DW	3C00H+896
 	DB	'Saving Temporary File ...',1EH,3
 MSG18	DB	2
 	DW	3C00H+896
 	DB	'Merging Sorted Temp Files ...',1EH,3
 MSG5	DB	2
 	DW	3C00H+896
 	DB	1FH
 	DB	'1.  Sort',2
 	DW	3C00H+896+20
 	DB	'2.  Merge',2
 	DW	3C00H+896+40
 	DB	'3.  Convert File',2
 	DW	3C00H+960
 	DB	'4.  Re-Pack Data',2
 	DW	3C00H+960+20
 	DB	'5.  Return to Menu',2
 	DW	3C00H+960+40
 	DB	'Choice ? ',3
 MSG6	DB	'xxxxxxxx',3
 MSG4A	DB	'Last Name',3
 MSG4B	DB	'First Name',3
 MSG4C	DB	'Company',3
 MSG4D	DB	'Address1',3
 MSG4E	DB	'Address2',3
 MSG4F	DB	'City',3
 MSG4G	DB	'State',3
 MSG4H	DB	'Zip',3
 MSG4I	DB	'Data1',3
 MSG4J	DB	'Data2',3
 MSG19	DB	2
 	DW	3C00H+832
 	DB	'1.  Postman',2
 	DW	3C00H+832+20
 	DB	'2.  Galactic',2
 	DW	3C00H+832+40
 	DB	'3.  Special Delivery',2
 	DW	3C00H+896
 	DB	'Choice ? ',3
 MSG20	DB	2
 	DW	3C00H+832
 	DB	'Filespec to Convert ? ',1FH,3
 MSG21	DB	2
 	DW	3C00H+832
 	DB	'Converting File to Adder ...',1FH,3
 MSG22	DB	2
 	DW	3C00H+832
 MSG22A	DB	'xxxxx Records Added, <KEY>:',1FH,3
 MSG23	DB	2
 	DW	3C00H+896
 	DB	'Repacking ...',1FH,3
 MSG23A	DB	2
 	DW	3C00H+896
 	DB	'Recovering Data ...',1FH,3
 MSG24	DB	' Complete.',10
 MSG24A	DB	'xxxxx Records Removed, <KEY>:',3
 TABLE19	DB	'1'
 	DW	POSTMAN
 	DB	'2'
 	DW	GALACTIC
 	DB	'3'
 	DW	SPECIAL
 	DB	'P'
 	DW	CONVMINE
 	DB	0
 MSG99	DB	2
 	DW	3C00H+832
 	DB	'Recovery Complete, '
 MSG99A	DB	'xxxxx Records Available.',10
 	DB	'<KEY> to continue:',3
 ;$$
 TABLE0	DB	'1'
 	DW	SORT
 	DB	'2'
 	DW	MERGE
 	DB	'3'
 	DW	CONVERT
 	DB	'4'
 	DW	REPACK
 	DB	'5'
 	DW	EXIT
 	DB	0
 TABLE1	DW	MSG4A
 	DW	MSG4B
 	DW	MSG4C
 	DW	MSG4D
 	DW	MSG4E
 	DW	MSG4F
 	DW	MSG4G
 	DW	MSG4H
 	DW	MSG4I
 	DW	MSG4J
 TABLE2	DB	15,0
 	DB	12,15
 	DB	18,27
 	DB	18,45
 	DB	10,69
 	DB	16,79
 	DB	8,95
 	DB	10,103
 	DB	6,113
 	DB	6,119
 TABLE3	DW	3C00H+192+8
 	DW	3C00H+192+32
 	DW	3C00H+256+11
 	DW	3C00H+320+12
 	DW	3C00H+320+48
 	DW	3C00H+384+8
 	DW	3C00H+384+33
 	DW	3C00H+384+48
 	DW	3C00H+192+52
 	DW	3C00H+256+52
 ;&&
 FILE4	DB	'SORT'
 FILE4A	DB	'XXX/ML:'
 FILE4B	DB	'X',3,0,0,0
 FCB4	DS	32
 DBUFF	EQU	$&0FF00H
 DATA	EQU	DBUFF+100H
 BUFF4	EQU	DATA+100H
 BUFFER	EQU	BUFF4+100H
 	END	ENTRY
