SYS0   ;	sys0/asm
 MODI	EQU	0
 MODII	EQU	0
 MODIII	EQU	-1
 	ORG	4000H
 	JP	0		;rst 8
 	JP	0		;rst 10H
 	JP	0		;rst 18H
 	JP	0		;rst 20H
 	JP	@OVERLAY	;rst 28H
 	JP	0		;rst 30H
 	JP	@TASK		;rst 28h
 	JP	@SETDRV		;setup drive bits
 	JP	@KEYIN		;4018
 	JP	@VIDOUT		;401B
 	JP	@PRTOUT		;401E
 	JP	@DSKIN		;4021
 	JP	@DSKOUT		;4024
 	JP	@ERROR		;error and return
 	JP	@ABORT		;error and exit
 	LD	A,11H		;cmd 1, sys1
 	RST	28H
 	JP	@PRINT		;line to video
 	JP	@PRINTER	;line to printer
 	JP	@GETSTR		;keyboard input
 	JP	@FLASH		;flashing prompt
 	JP	@STAT		;check drive status
 	JP	@UCASE
 	JP	@COMPARE	;string compare
 	JP	GETTKS
 	NOP			;fill byte
 	JP	NMIRET		;nmi vector Mod III
 	NOP
 	JP	DTYPE
 	JP	@RESTORE
 	JP	STEPIN
 	JP	@SELECT
 	JP	NMIRET
 	JP	SETDEN
 	JP	GETTRK
 	JP	@LOAD		;load a file
 	JP	@HEADING
 	JP	FLIPDEN
 	JP	STRNGUC		;string to upper case
 	JP	ASCII		;A => ACB ascii decimal
 	JP	HEXCV		;A => CB ascii hex
 	JP	SYSET		;set stack and IY
 	JP	VALUE
 CTRACK	DB	0,0,0,0		;current track
 TYPE	DB	80H,80H,0,0	;drive type
 TRACKS	DB	40,40,80,80	;track counts
 SYSTEM	DB	3		;+0, int counter
 	DB	0		;+1, inkey counter
 	DW	0		;+2,+3, printer counter
 	DW	0		;+4,+5, rs232in counter
 	DW	0		;+6,+7, rs232out counter
 	DB	0		;+8, sys mod in memory
 	DB	0		;+9, last command
 	DW	0		;+10,+11, entry overlay
 	DB	0		;+12, error code
 	DB	5		;+13, retry counter
 	DB	1		;+14, drive bit set
 	DB	0		;+15, binary drive
 	DB	0		;+16, system flag1
 	DB	0		;+17, disk I/O result
 	DB	0		;+18, system drive #
 	DW	3C00H		;+19,+20, cursor address
 	DB	0		;+21, char displayed
 	DB	0		;+22, char printed
 	DW	3C00H		;+23,+24, split vid top
 	DB	20H		;+25 cursor off char
 	DB	140		;+26 cursor on char
 	DB	10		;+27 flash counter
 	DB	10		;+28 initial count
 	DW	STACK		;+29,+30 stack ptr ptr
 	DB	0		;+31, sys mods here
 	DB	0		;+32, sys mods here
 	DW	0		;+33,34 topmemory
 	DB	0		;+35 source drive
 	DB	0		;+36 dest drive
 	DB	0		;+37 current track
 	DB	136		;+38 prompt character
 	DW	0		;+39,40 temp
 	DB	0,0,0		;+41,42,43 A/R cust #
 	DB	0		;+44 olay calling olay
 	DB	0,0,0		;+45,46,47 INV posit
 	DB	0,0,0		;+48,49,50 curr date
 	DS	8		;for string use
 STRING	DS	64		;key input buffer
 	DS	54		;stack area
 STACK	EQU	$		;works downwards
 	DS	6
 SYSET	DI
 	POP	HL		;get caller
 	LD	SP,STACK	;set it up
 	LD	IY,SYSTEM	;must point here
 	EI			;enable
 	JP	(HL)		;return
 @TASK	PUSH	AF
 	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 	IF	MODI
 	LD	A,(37E0H)	;read FDC latch
 	BIT	6,A
 	JR	NZ,DOFDCINT
 	BIT	7,A		;valid interrupt?
 	ENDIF
 	IF	MODIII
 	IN	A,(0E0H)	;Mod III latch
 	CPL			;bits reversed here
 	BIT	2,A		;valid?
 	ENDIF
 	JR	Z,TASKDONE	;not a RTC interrupt
 	CALL	INKEY		;keyboard input?
 	CALL	OUTP		;printer spooler?
 	DEC	(IY)		;alive counter
 	JR	NZ,TASKDONE	;not time yet
 	LD	(IY),9		;reset counter
 	LD	A,(3C00H)
 	CP	'*'
 	JR	Z,LIV1
 	CP	'#'
 	JR	NZ,TASKDONE
 	LD	C,'*'
 	JR	LIV2
 LIV1	LD	C,'#'
 LIV2	LD	HL,3C00H
 	LD	B,64
 LIV3	CP	(HL)	;this byte?
 	JR	NZ,LIV4	;skip if not
 	LD	(HL),C	;put new one
 LIV4	INC	HL
 	DJNZ	LIV3	;do 'em all
 TASKDONE
 	IF	MODI
 	LD	A,(37E0H)	;clear latch
 	ENDIF
 	IF	MODIII
 	IN	A,(0ECH)	;clear latch
 	ENDIF
 	POP	HL		;restore registers
 	POP	DE
 	POP	BC
 	POP	AF
 	EI			;enable interrupts
 	RET			;done
 	IF	MODI
 DOFDCINT	LD	A,(37ECH)
 	JR	TASKDONE
 	ENDIF
 INKEY	LD	A,(IY+1)	;check key counter
 	CP	80		;80 key max
 	RET	NC		;can't add any more
 	LD	HL,KIMASK	;keyboard mask area
 	LD	BC,3801H	;first row keyboard
 	LD	D,0		;row counter
 INKEY1	LD	A,(BC)		;get a key byte
 	LD	E,A		;save here
 	XOR	(HL)		;mask with table
 	LD	(HL),E		;save new key
 	AND	E		;new key?
 	JR	NZ,INKEY2	;have a new one
 	INC	D		;bump row
 	INC	HL		;bump mask byte
 	RLC	C		;new keyboard row
 	JP	P,INKEY1	;go till all done
 	RET			;nothing
 INKEY2	LD	E,A		;save bit here
 	LD	A,D		;get row
 	RLCA			;*2
 	RLCA			;*4
 	RLCA			;*8
 	LD	D,A		;put row back
 	LD	C,1		;bit mask for column
 INKEY3	LD	A,C		;get mask bit
 	AND	E		;one we have?
 	JR	NZ,INKEY4	;have the right one
 	INC	D		;bump row
 	RLC	C		;shift mask bit
 	JR	INKEY3		;go till bit found
 INKEY4	LD	C,D		;D = keyboard posit.
 	LD	B,0		;for table add
 	LD	HL,KEYS2	;shifted key table
 	LD	A,(3880H)	;check for shift key
 	OR	A
 	JR	NZ,INKEY5	;have the table
 	LD	HL,KEYS1	;non-shifted keys
 INKEY5	ADD	HL,BC		;point to the byte
 	LD	A,(HL)		;fetch the byte
 	CP	4		;shift clear?
 	JR	NZ,INKEY5Z	;skip if not pressed
 	LD	(IY+1),0	;clear key buffer
 	RET
 INKEY5Z	CP	5
 	JR	NZ,INKEY6
 	LD	(IY+2),0
 	LD	(IY+3),0
 	RET
 INKEY6	LD	HL,KEYBUFF-1	;keyboard buffer
 	INC	(IY+1)		;bump key count
 	LD	C,(IY+1)	;get lsb
 	LD	B,0		;80 keys allowed
 	ADD	HL,BC		;where the key goes
 	LD	(HL),A		;put in the buffer
 	RET
 STRNGUC	PUSH	HL		;save these
 	PUSH	BC
 STRNLP	LD	A,(HL)
 	CALL	403FH		;to upper case
 	LD	(HL),A		;put it back
 	INC	HL
 	DJNZ	STRNLP
 	POP	BC
 	POP	HL
 	RET
 KIMASK	DB	0,0,0,0,0,0,0	;keyboard work area
 KEYBUFF	DS	80		;type-ahead buffer
 PRBUFF	DS	400H
 KEYS1	DB	'@abcdefg'
 	DB	'hijklmno'
 	DB	'pqrstuvw'
 	DB	'xyz',0,0,0,0,0
 	DB	'01234567'
 	DB	'89:;,-./'
 	DB	13,4,1,5BH,5CH,5DH,5EH,20H
 KEYS2	DB	'`ABCDEFG'
 	DB	'HIJKLMNO'
 	DB	'PQRSTUVW'
 	DB	'XYZ',0,0,0,0,0
 	DB	5FH,'!"#$%&',27H
 	DB	'()*+<=>?'
 	DB	14,5,2,1BH,1AH,18H,19H,143
 OUTP	LD	A,(IY+2)	;any chars in buffer?
 	OR	(IY+3)
 	RET	Z		;nothing here
 	LD	A,(37E8H)	;get printer status
 	AND	0F0H		;high 4 bits only
 	CP	30H		;ready for a byte?
 	RET	NZ		;skip if not
 	LD	C,(IY+2)	;get position
 	LD	B,(IY+3)
 	LD	HL,PRBUFF	;printer buffer
 	ADD	HL,BC		;point to byte
 	LD	A,(HL)		;get the byte
 	IF	MODI
 	LD	(37E8H),A	;print Mod I
 	ENDIF
 	IF	MODIII
 	OUT	(0F8H),A	;print Mod III
 	ENDIF
 	DEC	BC		;reduce counter
 	LD	(IY+2),C	;update table
 	LD	(IY+3),B
 	JR	OUTP		;time for another?
 @KEYIN	DI			;disable temp
 	LD	A,(IY+1)	;any keys?
 	OR	A
 	JR	Z,DONEKEY	;nothing here
 	LD	A,(KEYBUFF)	;get a key
 	PUSH	HL
 	PUSH	DE
 	PUSH	BC
 	LD	HL,KEYBUFF+1	;block move buffer
 	LD	DE,KEYBUFF
 	LD	BC,79
 	LDIR
 	POP	BC
 	POP	DE
 	POP	HL
 	DEC	(IY+1)		;reduce counter
 DONEKEY	EI			;can enable now
 	PUSH	BC		;save BC
 	LD	BC,800H		;debounce delay
 	CALL	@DELAY		;decrementer
 	POP	BC
 	OR	A		;anything?
 	RET	Z		;nope
 	CP	2		;set C flag for break
 	JP	Z,402DH		;main menu
 	RET			;C = break
 @DELAY	PUSH	AF		;save this
 	DEC	BC		;decrement BC till 0
 	LD	A,B
 	OR	C
 	JR	NZ,@DELAY+1
 	POP	AF
 	RET
 @PRTOUT	PUSH	BC		;save this
 	PUSH	AF		;save character
 PRTWT	LD	C,(IY+2)	;wait till room
 	LD	B,(IY+3)
 	INC	BC
 	LD	A,B
 	CP	4
 	JR	NC,PRTWT	;wait for int. drain
 	DI			;disable a sec
 	LD	C,(IY+2)	;get adjusted counter
 	LD	B,(IY+3)
 	INC	BC		;bump counter
 	LD	(IY+2),C
 	LD	(IY+3),B
 	PUSH	HL
 	PUSH	DE
 	LD	HL,PRBUFF+3FEH
 	LD	DE,PRBUFF+3FFH
 	LD	BC,3FFH
 	LDIR
 	POP	DE
 	POP	HL
 	POP	AF
 	LD	(PRBUFF),A	;store new char
 	POP	BC
 	EI
 	RET			;done with insert
 @OVERLAY
 	PUSH	AF		;save command
 	LD	A,(IY+18)	;get system drive
 	CALL	@SETDRV		;setup drive
 	POP	AF		;get command back
 	LD	(IY+9),A	;save command
 	AND	0FH		;low 4 bits
 	CP	(IY+8)		;in memory now?
 	JR	Z,OVERLAYGO	;jump to it
 	PUSH	HL		;save registers
 	PUSH	DE
 	PUSH	BC
 	LD	HL,SYSTABLE	;where system is
 	DEC	A		;sys # -1
 	SLA	A		;* 2 for table
 	LD	C,A
 	LD	B,0		;BC = sys# *2
 	ADD	HL,BC		;get byte
 	LD	A,(HL)		;check if there
 	CP	-1		;-1 = not active
 	LD	A,39		;system not avail.
 	JP	Z,@ABORT	;abort in error
 	LD	D,(HL)		;get start track
 	INC	HL
 	LD	E,(HL)		;get start sector
 	BIT	6,(IY+16)	;ask for mounts?
 	CALL	NZ,@MOUNT
 	RES	6,(IY+16)
 	CALL	@LOAD		;load the file
 	LD	(IY+8),0	;set no-system
 	JR	NZ,SYSERR	;system error
 	LD	(IY+10),L	;save entry point
 	LD	(IY+11),H
 	LD	A,(IY+9)	;get system
 	AND	0FH
 	LD	(IY+8),A	;save current overlay
 	POP	BC		;restore stack
 	POP	DE
 	POP	HL
 OVERLAYGO
 	PUSH	HL		;save this
 	LD	L,(IY+10)	;get address
 	LD	H,(IY+11)	;of entry point
 	EX	(SP),HL		;restore HL
 	LD	A,(IY+9)	;get command back
 	RET			;go overlay
 SYSERR	POP	BC		;restore stack
 	POP	DE
 	POP	HL		;fix everything
 	SET	6,(IY+16)	;system disk mount
 	LD	A,(IY+9)
 	LD	(IY+8),0
 	JP	@OVERLAY
 @MOUNT	LD	A,10
 	CALL	401BH
 	LD	HL,MNTMSG	;mount system disk
 	LD	A,(IY+18)	;get system drive
 	ADD	A,30H		;make it ascii
 	LD	(SYSDRV),A
 	JP	4039H		;display it
 SYSTABLE
 	DB	2,0		;sys1
 	DB	2,6		;sys2
 	DB	8,0		;sys3
 	DB	5,6		;sys4
 	DB	11,0		;sys5
 	DB	14,0		;sys6
 	DB	-1,-1		;sys7
 	DB	-1,-1		;sys8
 	DB	-1,-1		;sys9
 	DB	6,6		;sys10
 	DB	-1,-1		;sys11
 	DB	-1,-1		;sys12
 	DB	-1,-1		;sys13
 	DB	-1,-1		;sys14
 	DB	-1,-1		;sys15
 	DB	-1,-1		;sys16
 	DB	-1,-1		;sys17
 	DB	-1,-1		;sys18
 	DB	-1,-1		;sys19
 	DB	-1,-1		;sys20
 @ABORT	CALL	SYSET		;initialize
 	AND	3FH
 	OR	40H
 	RES	5,(IY+16)
 @ERROR	LD	(IY+12),A	;save error code
 	LD	A,14H		;#1, sys4
 	RST	28H		;display error
 @LOAD	LD	BC,4EFFH	;I/O buffer
 	EXX			;use alt set
 LOAD1	CALL	GETB		;get a byte
 	DEC	A		;load mark
 	JR	Z,LOAD2
 	DEC	A		;entry point?
 	JR	Z,LOAD3
 	CP	1EH		;remark
 	JR	C,LOAD8
 	LD	A,34		;load file fmt err
 	OR	A
 	RET
 LOAD8	CALL	GETB
 	LD	B,A		;remark count
 LOAD4	CALL	GETB
 	DJNZ	LOAD4
 	JR	LOAD1
 LOAD3	CALL	GETB
 	CALL	GETLOAD		;get entry point
 	XOR	A		;set Z flag for OK
 	RET			;done, HL= entry
 GETLOAD	CALL	GETB		;get load address
 	LD	L,A
 	CALL	GETB
 	LD	H,A
 	RET
 LOAD2	CALL	GETB
 	LD	B,A
 	CALL	GETLOAD
 	DEC	B
 	DEC	B
 LOAD5	LD	A,H		;check for RAM memory
 	CP	3CH
 	JR	NC,LOAD6
 	LD	A,36		;tried to load ROM
 	OR	A
 	RET
 LOAD6	CALL	GETB
 	LD	(HL),A		;put in buffer
 	CP	(HL)		;still there?
 	JR	Z,LOAD7
 	LD	A,35		;memory error
 	OR	A
 	RET
 LOAD7	INC	HL
 	DJNZ	LOAD5
 	JR	LOAD1
 GETB	EXX			;alt set disk data
 	INC	C		;bump buffer pointer
 	JR	NZ,HAVEB	;not at buffer end
 	CALL	@SYSIN
 	JR	NZ,HAVEBB	;disk error
 	LD	A,(IY+17)	;get non-masked byte
 	AND	60H		;system sector?
 	JR	NZ,HAVEOK	;ok
 	LD	A,41		;system not found
 	OR	A
 	JR	HAVEBB
 HAVEOK	INC	E		;bump sector
 	CALL	DTYPE		;get drive type
 	BIT	7,(HL)		;single/double den?
 	LD	A,10		;10 sector/track single
 	JR	Z,HAVEE
 	LD	A,18		;18 / track double
 HAVEE	SUB	E		;at end of track?
 	JR	NZ,HAVEB	;not at track end
 	LD	E,A		;sector 0
 	INC	D		;bump track
 HAVEB	LD	A,(BC)		;get the byte
 	EXX
 	RET
 HAVEBB	POP	HL		;adjust stack
 	RET			;ret NZ flag
 @SYSIN	LD	A,9CH		;error mask system
 	JR	@DSKIN+2
 @DSKIN	LD	A,0FCH
 	LD	HL,READ
 	RES	7,(IY+16)	;set READ operation
 	JR	IOCOMM
 @DSKOUT	LD	HL,WRITE	;write sector
 	LD	A,0FCH		;error mask
 	SET	7,(IY+16)	;set WRITE operation
 IOCOMM	LD	(IOCALL),HL	;save call in code
 	LD	(IOMASK),A	;save mask byte
 	LD	(IY+13),4	;start re-try counter
 	CALL	GETTKS		;get track count
 	LD	A,D		;get track to read
 	CP	(HL)		;within disk bounds?
 	JR	C,IOLOOP	;go if yes
 	LD	A,46
 	BIT	7,(IY+16)
 	RET	NZ
 	LD	A,42		;error message
 	OR	A		;set NZ
 	RET
 IOLOOP	PUSH	BC		;save load address
 	CALL	SETDEN		;setup density
 	CALL	0		;call I/O
 IOCALL	EQU	$-2
 	POP	BC		;restore address
 	RET	Z
 	EX	AF,AF'
 	BIT	4,(IY+17)	;not found?
 	CALL	NZ,FLIPDEN	;reverse density
 	CALL	RESETFDC	;clear FDC latch
 	DEC	(IY+13)		;decrement counter
 	JR	NZ,IOLOOP	;try again
 	EX	AF,AF'		;get error back
 	RET			;ret NZ
 FLIPDEN	PUSH	AF		;save code
 	PUSH	HL
 	CALL	DTYPE		;get drive type
 	LD	A,(HL)		;get the byte
 	XOR	80H		;reverse density
 	LD	(HL),A		;done
 	POP	HL		;restore regs
 	POP	AF
 	RET
 RESETFDC
 	LD	A,0D0H		;force interrupt command
 	IF	MODI
 	LD	(37ECH),A	;Mod I
 	ENDIF
 	IF	MODIII
 	OUT	(0F0H),A	;Mod III
 	ENDIF
 	RET
 @DSKSLO	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	RET
 @SELECT
 	IF	MODI
 	LD	A,(37ECH)
 	ENDIF
 	IF	MODIII
 	IN	A,(0F0H)
 	ENDIF
 	AND	80H		;check bit 7
 	LD	A,(IY+14)	;which drive
 	IF	MODI
 	LD	(37E1H),A
 	ENDIF
 	IF	MODIII
 	OUT	(0F4H),A
 	ENDIF
 	RET	Z		;drive already on
 	PUSH	BC
 	LD	BC,0		;else wait 1 sec
 	CALL	@DELAY		;wait a bit
 	POP	BC
 	LD	A,(IY+14)
 	IF	MODI
 	LD	(37E1H),A
 	LD	A,(37ECH)	;check again
 	ENDIF
 	IF	MODIII
 	OUT	(0F4H),A
 	IN	A,(0F0H)
 	ENDIF
 	AND	80H
 	RET	Z
 	LD	(IY+17),A	;save non-masked
 	LD	A,8		;device not avail
 	OR	A		;set NZ
 	RET
 @SEEK	CALL	@SELECT		;turn on drive
 	JR	NZ,SEEKBD	;no good
 	CALL	GETTRK		;point to track byte
 	LD	A,(HL)		;get the byte
 	OR	A		;track 0?
 	JR	NZ,DOSEEK	;do the seek
 	CALL	@RESTORE	;restore the drive
 	JR	NZ,SEEKBD	;no good
 	XOR	A
 DOSEEK	PUSH	AF		;save track
 	LD	A,D		;get desired track
 	IF	MODI
 	LD	(37EFH),A
 	ENDIF
 	IF	MODIII
 	OUT	(0F3H),A
 	ENDIF
 	LD	A,E		;get desired sector
 	IF	MODI
 	LD	(37EEH),A
 	ENDIF
 	IF	MODIII
 	OUT	(0F2H),A
 	ENDIF
 	POP	AF		;get current track
 	IF	MODI
 	LD	(37EDH),A
 	ENDIF
 	IF	MODIII
 	OUT	(0F1H),A
 	ENDIF
 	CP	D		;already there?
 	RET	Z		;no need to seek
 	CALL	DTYPE		;drive type
 	LD	A,(HL)		;get the byte
 	AND	3		;get speed
 	OR	18H		;seek command
 	CALL	MOVEHEAD	;move drive head
 	JR	NZ,SEEKBD
 SKERR	AND	18H		;any errors
 	JR	Z,SEEKOK
 SEEKBD	PUSH	AF		;save code
 	CALL	GETTRK		;get current track
 	LD	(HL),0		;force restore next time
 	POP	AF
 	LD	(IY+17),A
 	LD	A,10		;seek error write
 	BIT	7,(IY+16)	;write I/O?
 	RET	NZ
 	LD	A,2		;seek error read
 	OR	A		;set NZ
 	RET
 SEEKOK	CALL	GETTRK
 	IF	MODI
 	LD	A,(37EDH)
 	ENDIF
 	IF	MODIII
 	IN	A,(0F1H)
 	ENDIF
 	LD	(HL),A		;save track
 	XOR	A
 	RET
 @RESTORE
 	CALL	@SELECT		;select drive
 	RET	NZ
 	CALL	DTYPE		;get drive type
 	LD	A,(HL)		;get the byte
 	AND	3		;get speed
 	OR	8		;set RESTORE command
 	CALL	MOVEHEAD
 	JR	NZ,SKERR+2
 	BIT	4,A		;not found?
 	JR	NZ,SKERR
 	BIT	3,A
 	JR	NZ,SKERR
 	CPL			;bit 2 MUST be set
 	AND	4
 	RET	Z		;OK
 	LD	(IY+17),A
 	LD	A,40		;not in system
 	RET
 STEPIN	CALL	@SELECT
 	RET	NZ
 	CALL	DTYPE
 	LD	A,(HL)
 	AND	3
 	OR	58H		;stepin byte
 	CALL	MOVEHEAD	;move the head
 	RET	NZ
 	AND	18H
 	RET	Z
 	LD	(IY+17),A
 	LD	A,10		;seek error
 	RET
 MOVEHEAD
 	IF	MODI
 	LD	(37ECH),A
 	ENDIF
 	IF	MODIII
 	OUT	(0F0H),A
 	ENDIF
 	CALL	@DSKSLO
 SKWT	CALL	@SELECT		;keep motor on
 	RET	NZ		;dropped ready
 	IF	MODI
 	LD	A,(37ECH)
 	ENDIF
 	IF	MODIII
 	IN	A,(0F0H)
 	ENDIF
 	BIT	0,A
 	JR	NZ,SKWT
 	RET
 GETTRK	LD	HL,CTRACK	;current track
 	JR	GETCOMM		;go
 GETTKS	LD	HL,TRACKS	;total tracks
 	JR	GETCOMM
 DTYPE	LD	HL,TYPE
 GETCOMM	LD	A,(IY+15)	;binary drive
 	ADD	A,L		;add to table
 	LD	L,A		;HL => byte for drive
 	RET
 @COMPARE
 	LD	A,(DE)
 	CP	(HL)
 	RET	NZ
 	INC	DE
 	INC	HL
 	DJNZ	@COMPARE
 	RET
 SETDEN	LD	A,(IY+14)	;get bit set for drive
 	AND	0FH		;low 4 bits only
 	LD	(IY+14),A	;put it back
 	CALL	DTYPE		;get drive type
 	BIT	7,(HL)		;check density
 	IF	MODIII
 	JR	Z,SNGDEN
 	SET	7,(IY+14)	;set double den
 	ENDIF
 	IF	MODI
 	LD	A,0FEH
 	JR	Z,GOTDEN
 	INC	A
 GOTDEN	EX	AF,AF'		;save byte
 	LD	A,(37EDH)	;get track register
 	EX	AF,AF'		;get byte back
 	LD	(37ECH),A	;give to FDC
 	LD	A,0D0H		;force interrupt
 	LD	(37ECH),A
 	EX	AF,AF'		;get track back
 	LD	(37EDH),A
 	ENDIF
 SNGDEN	BIT	6,(HL)		;double side?
 	JR	Z,CHPCOMP	;check pre-comp
 	BIT	5,(HL)		;side 2 active?
 	JR	Z,CHPCOMP	;check for pre-comp
 	IF	MODIII
 	SET	4,(IY+14)	;set side 2
 	ENDIF
 	IF	MODI
 	SET	3,(IY+14)	;set side 2
 	ENDIF
 CHPCOMP
 	IF	MODI
 	RET
 	ENDIF
 	IF	MODIII
 	LD	A,D
 	CP	16H
 	RET	C
 	SET	5,(IY+14)	;set pre-comp
 	RET			;done
 	ENDIF
 @LOKOUT	LD	A,25		;access denied
 	OR	80H		;setup for return
 	CALL	4027H		;error and return
 DEAD	JR	DEAD		;halt here
 @SETDRV	PUSH	BC		;save BC
 	LD	C,1		;bit mask
 	AND	3		;must be 0-3
 	LD	(IY+15),A	;save binary drive
 SETDV	JR	Z,GOTDRV	;have it
 	SLA	C		;shift drive bit
 	DEC	A		;check next one
 	JR	SETDV		;continue
 GOTDRV	LD	A,C		;get drive bit
 	LD	(IY+14),A	;save it
 	POP	BC		;restore stack
 	RET
 READ	CALL	@SELECT		;turn it on
 	RET	NZ
 	CALL	@SEEK		;move to right track
 	RET	NZ
 	JP	PERREAD
 	IF	MODI
 PERREAD	LD	HL,37ECH	;FDC address
 	PUSH	DE		;save track/sector
 	LD	DE,37EFH	;transfer address
 	DI
 	LD	(HL),88H	;issue read command
 	CALL	@DSKSLO		;wait for ready
 RX0	LD	A,(HL)		;get status
 	AND	87H
 	JP	PO,RX0		;not ready yet
 RX1	LD	A,(DE)		;get the byte
 	LD	(BC),A		;put in buffer
 	INC	BC		;bump buffer
 RX2	BIT	1,(HL)		;ready now?
 	JR	NZ,RX1		;get it if yes
 	BIT	1,(HL)		;now?
 	JR	NZ,RX1
 	BIT	7,(HL)		;drive still on?
 	JR	NZ,RX3		;quit if not
 	BIT	1,(HL)		;now?
 	JR	NZ,RX2
 	BIT	0,(HL)		;command done?
 	JR	NZ,RX2		;if not, keep it up
 RX3	LD	A,(HL)		;get status
 	LD	(HL),0D0H	;force interrupt
 	EI
 	POP	DE		;restore stack
 	ENDIF
 RETURNIO
 	LD	(IY+17),A	;non-masked result
 	AND	0		;check for error
 IOMASK	EQU	$-1
 	RET	Z		;no errors
 	LD	L,A		;save error here
 	BIT	7,(IY+16)	;write ?
 	JR	NZ,FIGWRT	;figure it out
 	LD	A,8		;dropped ready
 	BIT	7,L
 	RET	NZ		;got it
 	LD	A,6
 	BIT	6,L
 	RET	NZ
 	BIT	5,L
 	RET	NZ
 	LD	A,5		;data record not found
 	BIT	4,L
 	RET	NZ
 	LD	A,4		;parity error
 	BIT	3,L
 	RET	NZ
 	LD	A,3		;lost data
 	BIT	2,L
 	RET	NZ
 	LD	A,48		;unknown error
 	OR	A
 	RET
 FIGWRT	LD	A,15		;write protected
 	BIT	6,L
 	RET	NZ
 	LD	A,14		;drive write fault
 	BIT	5,L
 	RET	NZ
 	LD	A,13
 	BIT	4,L
 	RET	NZ
 	LD	A,12		;parity error
 	BIT	3,L
 	RET	NZ
 	LD	A,11		;lost data
 	BIT	2,L
 	RET	NZ
 	LD	A,48		;unknown error
 	OR	A
 	RET
 	IF	MODIII
 PERREAD	CALL	SETNMI		;setup NMI return
 	LD	A,80H		;read operation
 	OUT	(0F0H),A	;issue it
 	CALL	@DSKSLO		;wait a bit
 RX1	IN	A,(0F0H)	;check status
 	AND	E		;ready?
 	JR	Z,RX1		;wait if not
 	INI			;get the byte
 	LD	A,D		;set wait states
 RX2	OUT	(0F4H),A	;issue to FDC
 	INI			;get a byte
 	JR	NZ,RX2		;get full buffer
 	LD	HL,0		;prevent overrun
 	JR	RX2		;load into ROM
 	ENDIF
 	IF	MODIII
 SETNMI	LD	(SECSAVE),DE	;save track/sector
 	LD	H,B		;pass buffer along
 	LD	L,C		;to HL for transfer
 	IN	A,(0F0H)	;clear FDC
 	DI
 	LD	A,0C0H
 	OUT	(0E4H),A
 	LD	BC,RETNMI	;where to come back to
 	LD	(404AH),BC	;return vector
 	LD	D,(IY+14)
 	SET	6,D		;wait states switch
 	LD	E,2		;mask for bit 1
 	LD	BC,0F3H		;port/counter
 	RET			;done
 RETNMI	POP	HL		;restore stack
 	XOR	A		;turn off NMI
 	OUT	(0E4H),A
 	LD	DE,0		;get track/sector back
 SECSAVE	EQU	$-2
 	LD	HL,NMIRET	;non-maskable return
 	LD	(404AH),HL
 	IN	A,(0F0H)	;read status
 	PUSH	AF
 	CALL	RESETFDC	;clear interrupt latch
 	POP	AF		;status byte in A
 	EI
 	JP	RETURNIO	;I/O common exit
 	ENDIF
 NMIRET	RETN
 WRITE	CALL	@SELECT		;turn it on
 	RET	NZ
 	CALL	@SEEK
 	RET	NZ
 	IF	MODI
 	LD	A,(37ECH)	;check write protect
 	ENDIF
 	IF	MODIII
 	IN	A,(0F0H)
 	ENDIF
 	AND	40H		;check bit 6
 	JR	Z,GOWRITE
 	LD	A,15		;write protect
 	OR	A		;set NZ
 	RET
 GOWRITE
 	IF	MODI
 	LD	HL,37ECH	;FDC
 	PUSH	DE		;save track/sector
 	LD	DE,37EFH	;transfer address
 	DI
 	LD	(HL),0A8H	;data write
 	CALL	@DSKSLO		;wait for ready
 	LD	A,(BC)		;get data byte
 WX1	BIT	7,(HL)		;dropped ready?
 	JR	NZ,WX5		;terminate now
 	BIT	1,(HL)		;ready for byte
 	JR	Z,WX1		;wait if not
 	LD	(DE),A		;stuff into FDC
 	INC	BC		;next byte
 	LD	A,(BC)		;get it
 WX2	BIT	1,(HL)		;ready
 	JR	Z,WX2		;wait here, 2'nd crucial
 WX3	LD	(DE),A		;give to FDC
 	INC	BC
 	LD	A,(BC)		;get next
 WX4	BIT	1,(HL)		;funny loop, but need it
 	JR	NZ,WX3
 	BIT	1,(HL)
 	JR	NZ,WX3
 	BIT	1,(HL)
 	JR	NZ,WX3
 	BIT	1,(HL)
 	JR	NZ,WX3
 	BIT	1,(HL)
 	JR	NZ,WX3
 	BIT	1,(HL)
 	JR	NZ,WX3
 	BIT	0,(HL)		;command done?
 	JR	NZ,WX4
 WX5	JP	RX3		;get result of I/O
 	ENDIF
 	IF	MODIII
 	CALL	SETNMI		;setup NMI return
 	LD	A,0A0H		;data write
 	OUT	(0F0H),A	;give to FDC
 	CALL	@DSKSLO		;wait for ready
 WX1	IN	A,(0F0H)	;check status
 	AND	E		;bit 1 NZ?
 	JR	Z,WX1
 	OUTI			;give byte to FDC
 	LD	B,60H		;short delay between
 	DJNZ	$
 	LD	A,D		;get drive byte
 WX2	OUT	(0F4H),A	;set wait state
 	OUTI			;now send byte
 	JR	WX2		;continue
 	ENDIF
 @VIDOUT	PUSH	HL		;save HL,DE,BC
 	PUSH	DE
 	PUSH	BC
 	LD	(IY+21),A	;save character
 	LD	L,(IY+19)	;get cursor address
 	LD	H,(IY+20)
 	CP	20H		;control byte?
 	JR	C,DOCTL		;go if yes
 	CP	0C0H
 	JR	NC,TAB
 	LD	(HL),A		;display it
 	CP	(HL)		;still there?
 	JR	Z,VIDOK		;lowercase there
 	SUB	20H		;make it uppercase
 	LD	(HL),A		;put it back
 VIDOK	INC	HL		;new cursor position
 VIDBACK	LD	A,H		;check cursor
 	CP	3CH		;on video
 	JR	NC,VIDOK1	;not below
 	LD	L,(IY+23)	;top of video
 	LD	H,(IY+24)
 	JR	VIDOK2		;continue
 VIDOK1	CP	40H		;past it
 	JR	C,VIDOK2	;continue if not
 	LD	L,(IY+23)	;get top of video
 	LD	H,(IY+24)
 	LD	D,H
 	LD	E,L
 	LD	BC,40H
 	ADD	HL,BC		;HL => top line+1
 	PUSH	HL		;save from subtract
 	LD	B,H
 	LD	C,L
 	OR	A		;clear carry flag
 	LD	HL,4000H	;end of video
 	SBC	HL,BC		;compute length
 	LD	B,H		;give to BC
 	LD	C,L
 	POP	HL		;have params
 	DI
 	LDIR
 	EI
 	LD	HL,3FC0H	;clear bottom line
 	PUSH	HL
 	LD	DE,3FC1H
 	LD	BC,63
 	LD	(HL),20H
 	LDIR
 	POP	HL
 VIDOK2	LD	(IY+19),L	;update cursor
 	LD	(IY+20),H
 	POP	BC
 	POP	DE
 	POP	HL		;restore stack
 	LD	A,(IY+21)	;get char back
 	RET			;done
 TAB	SUB	0C0H
 TABLP	JP	Z,VIDBACK
 	INC	HL
 	LD	(HL),20H
 	DEC	A
 	JR	TABLP
 DOCTL	CP	8		;backspace?
 	JR	Z,BKSPA		;do it
 	CP	9
 	JR	Z,SCRCTR
 	CP	10		;linefeed
 	JR	Z,LINFEED
 	CP	13		;linefeed
 	JR	Z,LINFEED
 	CP	11		;up linefeed?
 	JR	Z,UPFEED
 	CP	1DH		;BOL
 	JR	Z,BOL
 	CP	1EH		;EOL
 	JR	Z,EOL
 	CP	1CH		;home
 	JR	Z,HOME
 	CP	1FH		;EOF
 	JR	Z,EOF
 	JR	VIDBACK		;done
 SCRCTR	LD	A,L
 	AND	0C0H
 	ADD	A,20H
 	LD	L,A
 	JP	VIDBACK
 BKSPA	DEC	HL		;move back
 	JP	VIDBACK		;done
 LINFEED	LD	A,L		;get LSB
 	AND	0C0H		;BOL
 	LD	L,A
 	LD	DE,40H		;next line
 	ADD	HL,DE
 	JR	VIDBAK		;return
 UPFEED	LD	A,L
 	AND	0C0H
 	LD	L,A
 	LD	DE,40H
 	OR	A		;clear carry
 	SBC	HL,DE
 VIDBAK	JP	VIDBACK
 BOL	LD	A,L
 	AND	0C0H
 	LD	L,A
 	JR	VIDBAK
 HOME	LD	L,(IY+23)
 	LD	H,(IY+24)
 	JR	VIDBAK		;cursor homed
 EOL	LD	A,L		;there now?
 	AND	3FH
 	CP	3FH
 	JR	Z,VIDBAK
 	LD	B,A		;save for subtract
 	LD	A,3FH		;end of line
 	SUB	B		;compute length
 	LD	C,A		;save for ldir
 	LD	B,0
 	PUSH	HL		;save cursor
 	LD	D,H		;give to DE
 	LD	E,L
 EOFDO	INC	DE
 	LD	(HL),20H
 	LDIR
 EOFDONE	POP	HL		;restore cursor
 	JR	VIDBAK
 EOF	PUSH	HL		;save it
 	EX	DE,HL		;store here
 	LD	HL,3FFFH	;end of video
 	OR	A		;clear carry
 	SBC	HL,DE		;compute length
 	JR	Z,EOFDONE	;end already
 	LD	B,H		;pass length
 	LD	C,L
 	LD	H,D		;get start back
 	LD	L,E
 	JR	EOFDO
 @PRINT	PUSH	DE		;save this
 	LD	DE,401BH	;print routine
 	JR	PRINTDO		;continue
 @PRINTER	PUSH	DE	;save
 	LD	DE,401EH	;printer routine
 PRINTDO	LD	(PRTCAL),DE	;pass call
 	PUSH	HL		;save data
 PRITLP	LD	A,(HL)		;get a byte
 	INC	HL		;point to next
 	CP	3
 	JR	Z,PRTDN		;finished
 	CALL	0		;make the call
 PRTCAL	EQU	$-2
 	CP	13		;terminator?
 	JR	NZ,PRITLP
 PRTDN	POP	HL		;get start
 	POP	DE		;restore this
 	RET			;done
 @GETSTR	LD	C,B		;save max length
 	PUSH	DE		;don't use this
 	LD	L,(IY+19)	;get cursor
 	LD	H,(IY+20)
 	PUSH	HL		;save start
 	INC	B		;length +1
 	LD	A,(IY+38)	;get prompt character
 PUTPER	LD	(HL),A		;periods for prompt
 	INC	HL
 	DJNZ	PUTPER		;do whole length
 	POP	HL		;get cursor back
 	LD	DE,STRING	;input buffer
 CURCUR	LD	A,(IY+25)	;cursor off
 	JR	CUROFF		;continue
 BLANK	LD	(HL),95
 	JR	CURFLS
 CURON	LD	A,(IY+26)	;cursor on
 CUROFF	LD	(HL),A		;put on video
 CURFLS	LD	A,(IY+28)	;flash count
 	LD	(IY+27),A	;put in counter
 SCAN	DEC	(IY+27)		;decrement counter
 	JR	NZ,SCAN2	;not time for change
 	LD	A,(IY+25)	;check for cursor off
 	CP	(HL)		;is it off
 	JR	NZ,CURCUR	;turn it off
 	JR	CURON		;turn it on
 SCAN2	CALL	4018H		;get a key
 	JR	Z,SCAN		;wait if not there
 	JR	C,SCDON		;break key
 	CP	13		;enter
 	JR	Z,SCDON
 	CP	14		;shift enter
 	JR	Z,SCDON
 	CP	5DH		;backspace
 	JR	Z,DOBAKSP
 	CP	18H		;shift backspace
 	JR	Z,NEWST
 	CP	4		;clear
 	JR	Z,NEWST
 	CP	20H		;control code?
 	JR	C,SCAN		;invalid here
 	LD	(IY+21),A	;save character
 	LD	A,B		;get length
 	CP	C		;compare to max
 	JR	NC,SCAN		;max reached, no more
 	LD	A,(IY+21)	;get char back
 	LD	(DE),A		;put in buffer
 	LD	(HL),'!'
 	BIT	4,(IY+16)	;'half duplex' ?
 	JR	NZ,CHROK	;don't display char
 	LD	(HL),A		;put on video
 	CP	(HL)		;there?
 	JR	Z,CHROK
 	SUB	20H
 	LD	(HL),A
 CHROK	INC	HL
 	INC	DE
 	INC	B		;bump length
 	JR	BLANK
 SCDON	LD	A,13		;force C/R
 	LD	(DE),A		;into buffer
 	LD	A,0
 	LD	(SCODE),A	;NOP opcode
 	JR	NC,SCDONX	;continue NC
 	LD	A,37H		;SCF opcode
 	LD	(SCODE),A
 SCDONX	LD	A,C		;get max length
 	SUB	B		;sub what we got
 	INC	A		;+1 for terminator
 SCDONY	LD	(HL),20H	;dots off
 	INC	HL
 	DEC	A
 	JR	NZ,SCDONY	;turn 'em all off
 	POP	DE		;restore stack
 	LD	A,B		;get length
 	OR	A		;set Z flag
 SCODE	NOP			;set C flag if BREAK
 	LD	HL,STRING	;point to input
 	LD	A,(HL)		;return first char
 	RES	4,(IY+16)	;'half duplex' off
 	RET			;done
 DOBAKSP	LD	A,B		;get length
 	OR	A
 	JR	Z,SCAN
 	LD	A,(IY+38)
 	LD	(HL),A		;backspace
 	DEC	B		;length -1
 	DEC	HL		;cursor back
 	DEC	DE		;buffer back
 	JP	BLANK
 NEWST	LD	A,B		;get length
 	OR	A
 	JP	Z,SCAN		;quit
 	LD	A,(IY+38)
 NEWST2	LD	(HL),A		;period prompt
 	DEC	HL
 	DEC	DE		;buffers back
 	DJNZ	NEWST2		;do it all
 	JP	BLANK
 MNTMSG	DB	1DH,1EH,'Mount SYSTEM disk on drive '
 SYSDRV	DB	'x.',3
 EOLMSG	DB	1DH,1EH,3
 @FLASH	EXX			;save string
 	LD	HL,EOLMSG	;clear line message
 FLASHLP	EXX			;swap
 	CALL	4030H		;display it
 	LD	B,8		;flash counter
 FLASH1	DEC	B		;decrement counter
 	JR	Z,FLASHLP	;other one
 	CALL	4018H		;get a key
 	JR	Z,FLASH1	;wait some more
 	PUSH	AF		;save key
 	LD	HL,EOLMSG	;clear the line
 	CALL	4030H
 	POP	AF		;restore key
 	RET			;done
 @STAT	CALL	@SELECT		;turn on drive
 	RET	NZ		;not available
 	PUSH	BC		;must save
 	LD	BC,200H
 STAT1	DEC	BC		;decrement counter
 	LD	A,B
 	OR	C
 	LD	A,43		;no diskette
 	JR	Z,STAT0		;error
 	IF	MODI
 	LD	A,(37ECH)
 	ENDIF
 	IF	MODIII
 	IN	A,(0F0H)
 	ENDIF
 	AND	2
 	JR	NZ,STAT1	;wait till mark gone
 	LD	BC,4000H
 STAT2	DEC	BC
 	LD	A,B
 	OR	C
 	LD	A,44		;open door
 	JR	Z,STAT0
 	IF	MODI
 	LD	A,(37ECH)
 	ENDIF
 	IF	MODIII
 	IN	A,(0F0H)
 	ENDIF
 	AND	2
 	JR	Z,STAT2		;wait till ID mark
 	LD	BC,200H
 STAT3	DEC	BC
 	LD	A,B
 	OR	C
 	LD	A,43
 	JR	Z,STAT0
 	IF	MODI
 	LD	A,(37ECH)
 	ENDIF
 	IF	MODIII
 	IN	A,(0F0H)
 	ENDIF
 	AND	2
 	JR	NZ,STAT3
 	XOR	A		;set Z flag for OK
 	POP	BC
 	RET
 STAT0	OR	A		;set NZ flag for BAD
 	POP	BC
 	RET			;done, A = error code
 @UCASE	CP	60H
 	RET	C
 	CP	80H
 	RET	NC
 	AND	5FH
 	RET
 @HEADING	LD	HL,TITLE
 	JP	4030H
 TITLE	DB	1CH,1FH
 	DB	'** POWER-TECH ** by Kim Watt * Breeze/QSD, Inc. * '
 MONTH	DB	'00/'
 DAY	DB	'00/'
 YEAR	DB	'00 *',13
 ASCII	PUSH	HL
 	CALL	ASCI
 	LD	H,B
 	PUSH	HL
 	LD	A,C
 	SUB	30H
 	CALL	ASCI
 	LD	A,C
 	CP	'0'
 	JR	NZ,ASCIG01
 	LD	A,20H
 ASCIG01	POP	HL
 	LD	C,B
 	LD	B,H
 	POP	HL
 	RET
 ASCI	LD	C,'0'
 ASCII1	SUB	10
 	JR	C,ASCII2
 	INC	C
 	JR	ASCII1
 ASCII2	ADD	A,3AH
 	LD	B,A
 	RET
 HEXCV	LD	B,A
 	SRL	A
 	SRL	A
 	SRL	A
 	SRL	A
 	CALL	HEXTST
 	LD	C,A
 	LD	A,B
 	AND	0FH
 	CALL	HEXTST
 	LD	B,A
 	RET
 HEXTST	ADD	A,30H
 	CP	3AH
 	RET	M
 	ADD	A,7
 	RET
 VALUE	EX	DE,HL		;DE => string
 	LD	BC,0		;value
 VALLP	LD	A,(DE)		;get a byte
 	CP	'/'
 	JR	Z,DOVAL
 	CP	','
 	JR	Z,DOVAL
 	CP	20H
 	JR	Z,DOVAL
 	CP	13
 	JR	Z,DOVAL+1	;done
 	CALL	VALNUM		;get number
 	RET	C		;invalid
 	LD	H,B		;get number
 	LD	L,C
 	ADD	HL,HL		;*2
 	ADD	HL,HL		;*4
 	ADD	HL,BC		;*5
 	ADD	HL,HL		;*10
 	LD	C,A		;new number
 	LD	B,0		;add it
 	ADD	HL,BC
 	LD	B,H		;update new
 	LD	C,L
 	INC	DE		;next char
 	JR	VALLP
 DOVAL	INC	DE		;next position
 	EX	DE,HL		;pointer back
 	RET			;BC = number
 VALNUM	SUB	30H
 	RET	C
 	CP	10
 	CCF
 	RET
 ENTRY	LD	SP,STACK	;initialize stack
 	LD	IY,SYSTEM	;system table
 	IF	MODI
 	LD	A,0D0H
 	LD	(37ECH),A
 	ENDIF
 	IF	MODIII
 	LD	A,0D0H
 	OUT	(0F0H),A
 	LD	A,4
 	OUT	(0E0H),A	;enable RTC
 	LD	A,28H
 	OUT	(0ECH),A	;enable video waits
 	XOR	A
 	OUT	(0E4H),A	;disable NMI
 	ENDIF
 	IM	1		;RST 38H = interrupts
 	EI			;can enable now
 DOPASS	CALL	4065H		;heading
 	LD	HL,PASSPMT	;password prompt
 	CALL	4030H		;display it
 	SET	4,(IY+16)	;'half duplex' input
 	LD	B,8		;8 chars
 	CALL	4036H		;get input
 	JR	C,DOPASS	;go
 	JR	Z,DOPASS	;nothing
 	LD	DE,PASS1	;password 1
 	PUSH	HL		;save from compare
 	CALL	406BH		;string to upper case
 	CALL	CHKPAS
 	POP	HL		;is it this?
 	RES	3,(IY+16)	;'slave' password
 	JR	Z,DODATE	;password OK
 	LD	DE,PASS2	;password 2
 	CALL	CHKPAS
 	SET	3,(IY+16)	;'master' password
 	JR	Z,DODATE	;go, OK
 	JP	@LOKOUT		;lock out the user
 CHKPAS	LD	A,(DE)
 	SRL	A
 	CP	(HL)
 	RET	NZ
 	INC	DE
 	INC	HL
 	DJNZ	CHKPAS
 	RET
 DODATE	CALL	4065H		;display it
 	LD	HL,DATEPMT	;date prompt
 	CALL	4030H		;display it
 	LD	B,8		;get date
 	CALL	4036H		;get key input
 	JR	C,DODATE
 	JR	Z,DODATE
 	CALL	VALUE		;get value
 	JR	C,DODATE
 	LD	A,C
 	CP	13
 	JR	NC,DODATE	;bad month
 	LD	(IY+48),C	;month
 	CALL	ASCII
 	LD	(MONTH),BC
 	CALL	VALUE
 	JR	C,DODATE
 	LD	A,C
 	CP	32
 	JR	NC,DODATE
 	LD	(IY+49),C	;day
 	CALL	ASCII
 	LD	(DAY),BC
 	CALL	VALUE
 	JR	C,DODATE
 	LD	(IY+50),C	;year
 	CALL	ASCII
 	LD	(YEAR),BC
 	JP	402DH		;go entry point
 DATEPMT	DB	10,10,'Today',27H,'s Date ? ',3
 PASSPMT	DB	10,10,'Sign in ? ',3
 PASS1	DB	'M'<1,'A'<1,'S'<1,'T'<1,'E'<1,'R'<1
 PASS2	DB	'A'<1,'C'<1,'C'<1,'E'<1,'S'<1,'S'<1
 	END	ENTRY
