;
;*******************
;
;	Conversion subroutines
;
;*******************
;
;	Decimal to binary subroutine
DECBIN	LD	HL,DATA 	;Point to DATA
	SVC	@DECHEX 	;Convert
; The BC register pair now holds the binary results of the
; @DECHEX SVC.
	RET			;Return to caller
;
;
;	Binary to decimal subroutine
;  (The binary is in the HL register pair)
BINDEC	LD	DE,DATA 	;Point to where the DECIMAL
				; answer will be
	SVC	@HEXDEC 	;BINARY to DECIMAL Conv.
	EX	DE,HL		;Put the address in the HL
; register pair so we can properly terminate the data
	LD	(HL),ETX	;Terminate the data
	RET			;Return to caller
;
;
;	Binary to hexadecimal subroutine
;   (DE must contain the binary to be converted)
BINHEX	LD	HL,HEXBUF	;Point HL to the HEX buffer
	SVC	@HEX16		;Convert to ASCII HEX
	LD	(HL),ETX	;Terminate
	RET
;
;
;	Hexadecimal to binary subroutine
; The Hex number to convert is stored in the DATA buffer.
; Each digit, starting with the most significant digit will
; be converted to Binary and the result will be placed in
; the HL register pair.
;
HEXBIN	LD	IX,DATA 	;Point to DATA buffer
	LD	A,(IX)		;Get digit
	CP	'F'		;Is it 'F'?
	JR	NZ,HB		;No - check for lower value
	SET	7,H		;Bit 7 in register H is 1
	SET	6,H		;Bit 6 in register H is 1
	SET	5,H		;Bit 5 in register H is 1
	SET	4,H		;Bit 4 in register H is 1
	INC	IX		;Next byte
	JP	DIGIT2		;Next digit
HB	CP	'E'		;Is the digit 'E'?
	JR	NZ,HB1		;No - check for lower value
	SET	7,H		;Bit 7 in register H is 1
	SET	6,H		;Bit 6 in register H is 1
	SET	5,H		;Bit 5 in register H is 1
	RES	4,H		;Bit 4 in register H is 0
	INC	IX		;Next byte
	JP	DIGIT2		;Next digit
HB1	CP	'D'		;Is the digit 'D'?
	JR	NZ,HB2		;No - check for lower value
	SET	7,H		;Bit 7 in register H is 1
	SET	6,H		;Bit 6 in register H is 1
	RES	5,H		;Bit 5 in register H is 0
	SET	4,H		;Bit 4 in register H is 1
	INC	IX		;Next byte
	JP	DIGIT2		;Next digit
HB2	CP	'C'		;Is the digit 'C'?
	JR	NZ,HB3		;No - check for lower value
	SET	7,H		;Bit 7 in register H is 1
	SET	6,H		;Bit 6 in register H is 1
	RES	5,H		;Bit 5 in register H is 0
	RES	4,H		;Bit 4 in register H is 0
	INC	IX		;Next byte
	JP	DIGIT2		;Next digit
HB3	CP	'B'		;Is the digit 'B'?
	JR	NZ,HB4		;No - check for lower value
	SET	7,H		;Bit 7 in register H is 1
	RES	6,H		;Bit 6 in register H is 0
	SET	5,H		;Bit 5 in register H is 1
	SET	4,H		;Bit 4 in register H is 1
	INC	IX		;Next byte
	JP	DIGIT2		;Next digit
HB4	CP	'A'		;Is the digit 'A'?
	JR	NZ,HB5		;No - check for lower value
	SET	7,H		;Bit 7 in register H is 1
	RES	6,H		;Bit 6 in register H is 0
	SET	5,H		;Bit 5 in register H is 1
	RES	4,H		;Bit 4 in register H is 0
	INC	IX		;Next byte
	JP	DIGIT2		;Next digit
HB5	CP	'9'		;Is the digit '9'?
	JR	NZ,HB6		;No - check for lower value
	SET	7,H		;Bit 7 in register H is 1
	RES	6,H		;Bit 6 in register H is 0
	RES	5,H		;Bit 5 in register H is 0
	SET	4,H		;Bit 4 in register H is 1
	INC	IX		;Next byte
	JP	DIGIT2		;Next digit
HB6	CP	'8'		;Is the digit '8'?
	JR	NZ,HB7		;No - check for lower value
	SET	7,H		;Bit 7 in register H is 1
	RES	6,H		;Bit 6 in register H is 0
	RES	5,H		;Bit 5 in register H is 0
	RES	4,H		;Bit 4 in register H is 0
	INC	IX		;Next byte
	JP	DIGIT2		;Next digit
HB7	CP	'7'		;Is the digit '7'?
	JR	NZ,HB8		;No - check for lower value
	RES	7,H		;Bit 7 in register H is 0
	SET	6,H		;Bit 6 in register H is 1
	SET	5,H		;Bit 5 in register H is 1
	SET	4,H		;Bit 4 in register H is 1
	INC	IX		;Next byte
	JP	DIGIT2		;Next digit
HB8	CP	'6'		;Is the digit '6'?
	JR	NZ,HB9		;No - check for lower value
	RES	7,H		;Bit 7 in register H is 0
	SET	6,H		;Bit 6 in register H is 1
	SET	5,H		;Bit 5 in register H is 1
	RES	4,H		;Bit 4 in register H is 0
	INC	IX		;Next byte
	JP	DIGIT2		;Next digit
HB9	CP	'5'		;Is the digit '5'?
	JR	NZ,HB10 	;No - check for lower value
	RES	7,H		;Bit 7 in register H is 0
	SET	6,H		;Bit 6 in register H is 1
	RES	5,H		;Bit 5 in register H is 0
	SET	4,H		;Bit 4 in register H is 1
	INC	IX		;Next byte
	JP	DIGIT2		;Next digit
HB10	CP	'4'		;Is the digit '4'?
	JR	NZ,HB11 	;No - check for lower value
	RES	7,H		;Bit 7 in register H is 0
	SET	6,H		;Bit 6 in register H is 1
	RES	5,H		;Bit 5 in register H is 0
	RES	4,H		;Bit 4 in register H is 0
	INC	IX		;Next byte
	JP	DIGIT2		;Next digit
HB11	CP	'3'		;Is the digit '3'?
	JR	NZ,HB12 	;No - check for lower value
	RES	7,H		;Bit 7 in register H is 0
	RES	6,H		;Bit 6 in register H is 0
	SET	5,H		;Bit 5 in register H is 1
	SET	4,H		;Bit 4 in register H is 1
	INC	IX		;Next byte
	JP	DIGIT2		;Next digit
HB12	CP	'2'		;Is the digit '2'?
	JR	NZ,HB13 	;No - check for lower value
	RES	7,H		;Bit 7 in register H is 0
	RES	6,H		;Bit 6 in register H is 0
	SET	5,H		;Bit 5 in register H is 1
	RES	4,H		;Bit 4 in register H is 0
	INC	IX		;Next byte
	JP	DIGIT2		;Next digit
HB13	CP	'1'		;Is the digit '1'?
	JR	NZ,HB14 	;No - check for lower value
	RES	7,H		;Bit 7 in register H is 0
	RES	6,H		;Bit 6 in register H is 0
	RES	5,H		;Bit 5 in register H is 0
	SET	4,H		;Bit 4 in register H is 1
	INC	IX		;Next byte
	JP	DIGIT2		;Next digit
HB14	RES	7,H		;Bit 7 in register H is 0
	RES	6,H		;Bit 6 in register H is 0
	RES	5,H		;Bit 5 in register H is 0
	RES	4,H		;Bit 4 in register H is 0
	INC	IX		;Next byte
DIGIT2	LD	A,(IX)		;Get digit
	CP	'F'		;Is the digit 'F'?
	JR	NZ,HB15 	;No - check for lower value
	SET	3,H		;Bit 3 in register H is 1
	SET	2,H		;Bit 2 in register H is 1
	SET	1,H		;Bit 1 in register H is 1
	SET	0,H		;Bit 0 in register H is 1
	INC	IX		;Next byte
	JP	DIGIT3		;Next digit
HB15	CP	'E'		;Is the digit 'E'?
	JR	NZ,HB16 	;No - check for lower value
	SET	3,H		;Bit 3 in register H is 1
	SET	2,H		;Bit 2 in register H is 1
	SET	1,H		;Bit 1 in register H is 1
	RES	0,H		;Bit 0 in register H is 0
	INC	IX		;Next byte
	JP	DIGIT3		;Next digit
HB16	CP	'D'		;Is the digit 'D'?
	JR	NZ,HB17 	;No - check for lower value
	SET	3,H		;Bit 3 in register H is 1
	SET	2,H		;Bit 2 in register H is 1
	RES	1,H		;Bit 1 in register H is 0
	SET	0,H		;Bit 0 in register H is 1
	INC	IX		;Next byte
	JP	DIGIT3		;Next digit
HB17	CP	'C'		;Is the digit 'C'?
	JR	NZ,HB18 	;No - check for lower value
	SET	3,H		;Bit 3 in register H is 1
	SET	2,H		;Bit 2 in register H is 1
	RES	1,H		;Bit 1 in register H is 0
	RES	0,H		;Bit 0 in register H is 0
	INC	IX		;Next byte
	JP	DIGIT3		;Next digit
HB18	CP	'B'		;Is the digit 'B'?
	JR	NZ,HB19 	;No - check for lower value
	SET	3,H		;Bit 3 in register H is 1
	RES	2,H		;Bit 2 in register H is 0
	SET	1,H		;Bit 1 in register H is 1
	SET	0,H		;Bit 0 in register H is 1
	INC	IX		;Next byte
	JP	DIGIT3		;Next digit
HB19	CP	'A'		;Is the digit 'A'?
	JR	NZ,HB20 	;No - check for lower value
	SET	3,H		;Bit 3 in register H is 1
	RES	2,H		;Bit 2 in register H is 0
	SET	1,H		;Bit 1 in register H is 1
	RES	0,H		;Bit 0 in register H is 0
	INC	IX		;Next byte
	JP	DIGIT3		;Next digit
HB20	CP	'9'		;Is the digit '9'?
	JR	NZ,HB21 	;No - check for lower value
	SET	3,H		;Bit 3 in register H is 1
	RES	2,H		;Bit 2 in register H is 0
	RES	1,H		;Bit 1 in register H is 0
	SET	0,H		;Bit 0 in register H is 1
	INC	IX		;Next byte
	JP	DIGIT3		;Next digit
HB21	CP	'8'		;Is the digit '8'?
	JR	NZ,HB22 	;No - check for lower value
	SET	3,H		;Bit 3 in register H is 1
	RES	2,H		;Bit 2 in register H is 0
	RES	1,H		;Bit 1 in register H is 0
	RES	0,H		;Bit 0 in register H is 0
	INC	IX		;Next byte
	JP	DIGIT3		;Next digit
HB22	CP	'7'		;Is the digit '7'?
	JR	NZ,HB23 	;No - check for lower value
	RES	3,H		;Bit 3 in register H is 0
	SET	2,H		;Bit 2 in register H is 1
	SET	1,H		;Bit 1 in register H is 1
	SET	0,H		;Bit 0 in register H is 1
	INC	IX		;Next byte
	JP	DIGIT3		;Next digit
HB23	CP	'6'		;Is the digit '6'?
	JR	NZ,HB24 	;No - check for lower value
	RES	3,H		;Bit 3 in register H is 0
	SET	2,H		;Bit 2 in register H is 1
	SET	1,H		;Bit 1 in register H is 1
	RES	0,H		;Bit 0 in register H is 0
	INC	IX		;Next byte
	JP	DIGIT3		;Next digit
HB24	CP	'5'		;Is the digit '5'?
	JR	NZ,HB25 	;No - check for lower value
	RES	3,H		;Bit 3 in register H is 0
	SET	2,H		;Bit 2 in register H is 1
	RES	1,H		;Bit 1 in register H is 0
	SET	0,H		;Bit 0 in register H is 1
	INC	IX		;Next byte
	JP	DIGIT3		;Next digit
HB25	CP	'4'		;Is the digit '4'?
	JR	NZ,HB26 	;No - check for lower value
	RES	3,H		;Bit 3 in register H is 0
	SET	2,H		;Bit 2 in register H is 1
	RES	1,H		;Bit 1 in register H is 0
	RES	0,H		;Bit 0 in register H is 0
	INC	IX		;Next byte
	JP	DIGIT3		;Next digit
HB26	CP	'3'		;Is the digit '3'?
	JR	NZ,HB27 	;No - check for lower value
	RES	3,H		;Bit 3 in register H is 0
	RES	2,H		;Bit 2 in register H is 0
	SET	1,H		;Bit 1 in register H is 1
	SET	0,H		;Bit 0 in register H is 1
	INC	IX		;Next byte
	JP	DIGIT3		;Next digit
HB27	CP	'2'		;Is the digit '2'?
	JR	NZ,HB28 	;No - check for lower value
	RES	3,H		;Bit 3 in register H is 0
	RES	2,H		;Bit 2 in register H is 0
	SET	1,H		;Bit 1 in register H is 1
	RES	0,H		;Bit 0 in register H is 0
	INC	IX		;Next byte
	JP	DIGIT3		;Next digit
HB28	CP	'1'		;Is the digit '1'?
	JR	NZ,HB29 	;No - check for lower value
	RES	3,H		;Bit 3 in register H is 0
	RES	2,H		;Bit 2 in register H is 0
	RES	1,H		;Bit 1 in register H is 0
	SET	0,H		;Bit 0 in register H is 1
	INC	IX		;Next byte
	JP	DIGIT3		;Next digit
HB29	RES	3,H		;Bit 3 in register H is 0
	RES	2,H		;Bit 2 in register H is 0
	RES	1,H		;Bit 1 in register H is 0
	RES	0,H		;Bit 0 in register H is 0
	INC	IX		;Next byte
DIGIT3	LD	A,(IX)		;Get digit
	CP	'F'		;Is the digit 'F'?
	JR	NZ,HB30 	;No - check for lower value
	SET	7,L		;Bit 7 in register L is 1
	SET	6,L		;Bit 6 in register L is 1
	SET	5,L		;Bit 5 in register L is 1
	SET	4,L		;Bit 4 in register L is 1
	INC	IX		;Next byte
	JP	DIGIT4		;Next digit
HB30	CP	'E'		;Is the digit 'E'?
	JR	NZ,HB31 	;No - check for lower value
	SET	7,L		;Bit 7 in register L is 1
	SET	6,L		;Bit 6 in register L is 1
	SET	5,L		;Bit 5 in register L is 1
	RES	4,L		;Bit 4 in register L is 0
	INC	IX		;Next byte
	JP	DIGIT4		;Next digit
HB31	CP	'D'		;Is the digit 'D'?
	JR	NZ,HB32 	;No - check for lower value
	SET	7,L		;Bit 7 in register L is 1
	SET	6,L		;Bit 6 in register L is 1
	RES	5,L		;Bit 5 in register L is 0
	SET	4,L		;Bit 4 in register L is 1
	INC	IX		;Next byte
	JP	DIGIT4		;Next digit
HB32	CP	'C'		;Is the digit 'C'?
	JR	NZ,HB33 	;No - check for lower value
	SET	7,L		;Bit 7 in register L is 1
	SET	6,L		;Bit 6 in register L is 1
	RES	5,L		;Bit 5 in register L is 0
	RES	4,L		;Bit 4 in register L is 0
	INC	IX		;Next byte
	JP	DIGIT4		;Next digit
HB33	CP	'B'		;Is the digit 'B'?
	JR	NZ,HB34 	;No - check for lower value
	SET	7,L		;Bit 7 in register L is 1
	RES	6,L		;Bit 6 in register L is 0
	SET	5,L		;Bit 5 in register L is 1
	SET	4,L		;Bit 4 in register L is 1
	INC	IX		;Next byte
	JP	DIGIT4		;Next digit
HB34	CP	'A'		;Is the digit 'A'?
	JR	NZ,HB35 	;No - check for lower value
	SET	7,L		;Bit 7 in register L is 1
	RES	6,L		;Bit 6 in register L is 0
	SET	5,L		;Bit 5 in register L is 1
	RES	4,L		;Bit 4 in register L is 0
	INC	IX		;Next byte
	JP	DIGIT4		;Next digit
HB35	CP	'9'		;Is the digit '9'?
	JR	NZ,HB36 	;No - check for lower value
	SET	7,L		;Bit 7 in register L is 1
	RES	6,L		;Bit 6 in register L is 0
	RES	5,L		;Bit 5 in register L is 0
	SET	4,L		;Bit 4 in register L is 1
	INC	IX		;Next byte
	JP	DIGIT4		;Next digit
HB36	CP	'8'		;Is the digit '8'?
	JR	NZ,HB37 	;No - check for lower value
	SET	7,L		;Bit 7 in register L is 1
	RES	6,L		;Bit 6 in register L is 0
	RES	5,L		;Bit 5 in register L is 0
	RES	4,L		;Bit 4 in register L is 0
	INC	IX		;Next byte
	JP	DIGIT4		;Next digit
HB37	CP	'7'		;Is the digit '7'?
	JR	NZ,HB38 	;No - check for lower value
	RES	7,L		;Bit 7 in register L is 0
	SET	6,L		;Bit 6 in register L is 1
	SET	5,L		;Bit 5 in register L is 1
	SET	4,L		;Bit 4 in register L is 1
	INC	IX		;Next byte
	JP	DIGIT4		;Next digit
HB38	CP	'6'		;Is the digit '6'?
	JR	NZ,HB39 	;No - check for lower value
	RES	7,L		;Bit 7 in register L is 0
	SET	6,L		;Bit 6 in register L is 1
	SET	5,L		;Bit 5 in register L is 1
	RES	4,L		;Bit 4 in register L is 0
	INC	IX		;Next byte
	JP	DIGIT4		;Next digit
HB39	CP	'5'		;Is the digit '5'?
	JR	NZ,HB40 	;No - check for lower value
	RES	7,L		;Bit 7 in register L is 0
	SET	6,L		;Bit 6 in register L is 1
	RES	5,L		;Bit 5 in register L is 0
	SET	4,L		;Bit 4 in register L is 1
	INC	IX		;Next byte
	JP	DIGIT4		;Next digit
HB40	CP	'4'		;Is the digit '4'?
	JR	NZ,HB41 	;No - check for lower value
	RES	7,L		;Bit 7 in register L is 0
	SET	6,L		;Bit 6 in register L is 1
	RES	5,L		;Bit 5 in register L is 0
	RES	4,L		;Bit 4 in register L is 0
	INC	IX		;Next byte
	JP	DIGIT4		;Next digit
HB41	CP	'3'		;Is the digit '3'?
	JR	NZ,HB42 	;No - check for lower value
	RES	7,L		;Bit 7 in register L is 0
	RES	6,L		;Bit 6 in register L is 0
	SET	5,L		;Bit 5 in register L is 1
	SET	4,L		;Bit 4 in register L is 1
	INC	IX		;Next byte
	JP	DIGIT4		;Next digit
HB42	CP	'2'		;Is the digit '2'?
	JR	NZ,HB43 	;No - check for lower value
	RES	7,L		;Bit 7 in register L is 0
	RES	6,L		;Bit 6 in register L is 0
	SET	5,L		;Bit 5 in register L is 1
	RES	4,L		;Bit 4 in register L is 0
	INC	IX		;Next byte
	JP	DIGIT4		;Next digit
HB43	CP	'1'		;Is the digit '1'?
	JR	NZ,HB44 	;No - check for lower value
	RES	7,L		;Bit 7 in register L is 0
	RES	6,L		;Bit 6 in register L is 0
	RES	5,L		;Bit 5 in register L is 0
	SET	4,L		;Bit 4 in register L is 1
	INC	IX		;Next byte
	JP	DIGIT4		;Next digit
HB44	RES	7,L		;Bit 7 in register L is 0
	RES	6,L		;Bit 6 in register L is 0
	RES	5,L		;Bit 5 in register L is 0
	RES	4,L		;Bit 4 in register L is 0
	INC	IX		;Next byte
DIGIT4	LD	A,(IX)		;Get digit
	CP	'F'		;Is the digit 'F'?
	JR	NZ,HB45 	;No - check for lower value
	SET	3,L		;Bit 3 in register L is 1
	SET	2,L		;Bit 2 in register L is 1
	SET	1,L		;Bit 1 in register L is 1
	SET	0,L		;Bit 0 in register L is 1
	RET
HB45	CP	'E'		;Is the digit 'E'?
	JR	NZ,HB46 	;No - check for lower value
	SET	3,L		;Bit 3 in register L is 1
	SET	2,L		;Bit 2 in register L is 1
	SET	1,L		;Bit 1 in register L is 1
	RES	0,L		;Bit 0 in register L is 0
	RET
HB46	CP	'D'		;Is the digit 'D'?
	JR	NZ,HB47 	;No - check for lower value
	SET	3,L		;Bit 3 in register L is 1
	SET	2,L		;Bit 2 in register L is 1
	RES	1,L		;Bit 1 in register L is 0
	SET	0,L		;Bit 0 in register L is 1
	RET
HB47	CP	'C'		;Is the digit 'C'?
	JR	NZ,HB48 	;No - check for lower value
	SET	3,L		;Bit 3 in register L is 1
	SET	2,L		;Bit 2 in register L is 1
	RES	1,L		;Bit 1 in register L is 0
	RES	0,L		;Bit 0 in register L is 0
	RET
HB48	CP	'B'		;Is the digit 'B'?
	JR	NZ,HB49 	;No - check for lower value
	SET	3,L		;Bit 3 in register L is 1
	RES	2,L		;Bit 2 in register L is 0
	SET	1,L		;Bit 1 in register L is 1
	SET	0,L		;Bit 0 in register L is 1
	RET
HB49	CP	'A'		;Is the digit 'A'?
	JR	NZ,HB50 	;No - check for lower value
	SET	3,L		;Bit 3 in register L is 1
	RES	2,L		;Bit 2 in register L is 0
	SET	1,L		;Bit 1 in register L is 1
	RES	0,L		;Bit 0 in register L is 0
	RET
HB50	CP	'9'		;Is the digit '9'?
	JR	NZ,HB51 	;No - check for lower value
	SET	3,L		;Bit 3 in register L is 1
	RES	2,L		;Bit 2 in register L is 0
	RES	1,L		;Bit 1 in register L is 0
	SET	0,L		;Bit 0 in register L is 1
	RET
HB51	CP	'8'		;Is the digit '8'?
	JR	NZ,HB52 	;No - check for lower value
	SET	3,L		;Bit 3 in register L is 1
	RES	2,L		;Bit 2 in register L is 0
	RES	1,L		;Bit 1 in register L is 0
	RES	0,L		;Bit 0 in register L is 0
	RET
HB52	CP	'7'		;Is the digit '7'?
	JR	NZ,HB53 	;No - check for lower value
	RES	3,L		;Bit 3 in register L is 0
	SET	2,L		;Bit 2 in register L is 1
	SET	1,L		;Bit 1 in register L is 1
	SET	0,L		;Bit 0 in register L is 1
	RET
HB53	CP	'6'		;Is the digit '6'?
	JR	NZ,HB54 	;No - check for lower value
	RES	3,L		;Bit 3 in register L is 0
	SET	2,L		;Bit 2 in register L is 1
	SET	1,L		;Bit 1 in register L is 1
	RES	0,L		;Bit 0 in register L is 0
	RET
HB54	CP	'5'		;Is the digit '5'?
	JR	NZ,HB55 	;No - check for lower value
	RES	3,L		;Bit 3 in register L is 0
	SET	2,L		;Bit 2 in register L is 1
	RES	1,L		;Bit 1 in register L is 0
	SET	0,L		;Bit 0 in register L is 1
	RET
HB55	CP	'4'		;Is the digit '4'?
	JR	NZ,HB56 	;No - check for lower value
	RES	3,L		;Bit 3 in register L is 0
	SET	2,L		;Bit 2 in register L is 1
	RES	1,L		;Bit 1 in register L is 0
	RES	0,L		;Bit 0 in register L is 0
	RET
HB56	CP	'3'		;Is the digit '3'?
	JR	NZ,HB57 	;No - check for lower value
	RES	3,L		;Bit 3 in register L is 0
	RES	2,L		;Bit 2 in register L is 0
	SET	1,L		;Bit 1 in register L is 1
	SET	0,L		;Bit 0 in register L is 1
	RET
HB57	CP	'2'		;Is the digit '2'?
	JR	NZ,HB58 	;No - check for lower value
	RES	3,L		;Bit 3 in register L is 0
	RES	2,L		;Bit 2 in register L is 0
	SET	1,L		;Bit 1 in register L is 1
	RES	0,L		;Bit 0 in register L is 0
	RET
HB58	CP	'1'		;Is the digit '1'?
	JR	NZ,HB59 	;No - check for lower value
	RES	3,L		;Bit 3 in register L is 0
	RES	2,L		;Bit 2 in register L is 0
	RES	1,L		;Bit 1 in register L is 0
	SET	0,L		;Bit 0 in register L is 1
	RET
HB59	RES	3,L		;Bit 3 in register L is 0
	RES	2,L		;Bit 2 in register L is 0
	RES	1,L		;Bit 1 in register L is 0
	RES	0,L		;Bit 0 in register L is 0
	RET
;
; The binary representation of the input is now in the HL
; register pair.
