NEWSCA ;
 ; #######################################################
 ; FULL-FEATURED KEY/SCREEN DRIVER - DENNIS BATHORY KITSZ
 ; THIS ROUTINE IS A LEVEL II KEYBOARD REPLACEMENT ROUTINE
 ; CAPABLE OF PROVIDING:  AUTOREPEAT AFTER SELECTED DELAY
 ; (FOUND IN B REGISTER IN DELAY SECTION); BEEP WITH ANY
 ; CHOICE OF PITCH; RESULTANT DEBOUNCE; CORRECTED SHIFT-
 ; DOWN ARROW CONTROL CODE FOR EARLIER LEVEL II ROMS; A
 ; SHIFT-0 SELECTABLE UPPER/LOWER CASE DRIVER AND DISPLAY.
 ; NOTE THAT THIS ROUTINE IS SET UP FOR USE AT 3039 HEX
 ; (12345 DECIMAL) FOR ENTRY IN THE MEMORY SIDECAR WHICH
 ; IS ADDRESSED FROM 3000 TO 37D0 HEX.  IT MAY BE SET TO
 ; ANY ORIGIN OF THE USER'S CHOICE, SUCH AS USUAL HIGH MEM
 ; #######################################################
 ;
 INKEYS	EQU	4099H	;INKEY$ BYTE STORAGE AREA
 PORTFF	EQU	403DH	;CASSETTE OUTPUT PORT
 KPLACE	EQU	401AH	;1-BYTE KEYSTROKE STORE
 SHIFTR	EQU	4019H	;STORAGE FOR LC DRIVER
 ;
 ; #######################################################
 ; PATCH KEYBOARD ROUTINE INTO 4016 AND DISPLAY INTO 401E
 ; #######################################################
 ;
 	ORG	4016H		; START OF KEYBOARD SCAN
 	DEFW	KBPFIX		; PATCH KEYBOARD ROUTINE
 	ORG	401EH		; START OF DISPLAY SWEEP
 	DEFW	LOWER		; PATCH UPPR/LOWR ROUTINE
 ;
 	ORG	3039H		; START AT MEMORY SIDECAR
 ;
 ; #######################################################
 ; SET STORAGE #1, ROW #1, COUNTER #0 PARAMETERS FOR SCAN
 ; #######################################################
 ;
 KBPFIX	LD	HL,4036H	; STORAGE FOR KEYSTROKE
 	LD	BC,3801H	; FIRST ROW OF KEYS
 	LD	D,0		; COUNTER FOR COLUMS
 ;
 ; #######################################################
 ; CHECK EACH ROW OF KEYS IN SEARCH OF ONE THAT IS PRESSED
 ; #######################################################
 ;
 KEYPRS	LD	A,(BC)		; RETRIEVE ROW CONTENTS
 	LD	E,A		; SAVE IT TEMPORARILY
 	AND	E		; SET FLAGS FOR TEST
 	JR	NZ,STROKE	; NOT ZERO IF KEY PRESSED
 	LD	(HL),A		; SAVE CURRENT VALUE
 ;
 ; #######################################################
 ; INCREMENT AND ROTATE PATTERN CHECKS EACH ROW IN TURN
 ; #######################################################
 ;
 RECHEK	INC	D		; INCREMENT ROW COUNTER
 	INC	L		; INCREMENT STORAGE AREA
 	RLC	C		; GET NEXT KEYBRD COLUMN
 	LD	A,C		; GET VALUE INTO ACCUM.
 ;
 ; #######################################################
 ; CHECK IF LAST VALID ROW (I.E., NOT INCLUDING SHIFT KEY)
 ; #######################################################
 ;
 	SUB	80H		; LAST ROW IS 3880 HEX
 	JR	NZ,KEYPRS	; NEXT CHECK IF NOT DONE
 ;
 ; #######################################################
 ; AUTOREPEAT STATUS TEST ... CHECK IF KEYBOARD IS CLEAR
 ; #######################################################
 ;
 	LD	B,7		; COUNTER OF KBRD ROWS
 CLRMEM	DEC	L		; START COUNTING BACK
 	ADD	A,(HL)		; AND ADD IT UP IN ACCUM
 	DJNZ	CLRMEM		; AND DO IT FOR 7 ROWS
 	AND	A		; TEST FOR ANY KEY DOWN
 	LD	A,0		; A=0, FLAGS ARE INTACT
 	RET	NZ		; BACK IF KEYS IN USE
 ;
 ; #######################################################
 ; RESET AUTOREPEAT DELAY TO ZERO IF THE KEYBOARD IS CLEAR
 ; #######################################################
 ;
 	LD	(KPLACE),A	; ELSE DELAY GETS RESET
 	RET			; AND GO BACK ANYWAY
 ;
 ; #######################################################
 ; IF KEYSTROKE IS FOUND, CHECK STATUS OF AUTOREPEAT LOOP
 ; #######################################################
 ;
 STROKE	AND	(HL)		; CHECK KEYSTROKE STORAGE
 	JR	Z,FOUND		; NEW KEY IF NOT SAME
 	LD	A,(INKEYS)	; CHECK STATUS OF INKEY$
 	AND	A		; TEST IF SOMETHING THERE
 	JR	NZ,RECHEK	; IF THERE IS, LOOP BACK
 	LD	A,(KPLACE)	; NOW CHECK SPECIAL STORE
 	INC	A		; LET STORE = STORE + 1
 	LD	(KPLACE),A	; AND PUT IT BACK THERE
 	CP	0FFH		; CHECK IF IT IS AT END
 	JR	Z,DECA		; IF SO, THEN HOLD THERE
 	PUSH	BC		; SAVE ROW COUNTER REG.
 	LD	B,0FFH		; GET DELAY VALUE INTO B
 TMWSTE	DJNZ	TMWSTE		; AND DELAY JUST A BIT
 	POP	BC		; AND RESTORE ROW COUNTER
 	JR	RECHEK		; AND BACK TO CHECK NEXT
 DECA	DEC	A		; LET A = A - 1 (STORAGE)
 	LD	(KPLACE),A	; AND PUT IT IN STORAGE
 ;
 ; #######################################################
 ; GET KEYBOARD BYTE BACK, STORE AND PREPARE TO MANIPULATE
 ; #######################################################
 ; FIRST CONVERT D FROM COUNTER TO PSEUDO ASCII EQUIVALENT
 ; #######################################################
 ;
 	LD	A,E		; GET KEYBOARD BYTE BACK
 FOUND	LD	(HL),E		; STORE IT IN STROKE AREA
 	LD	A,D		; GET ROW COUNTER FROM D
 	RLCA			; AND BEGIN A PROCESS...
 	RLCA			; ...OF CONVERTING IT...
 	RLCA			; ...TO AN OFFSET VALUE.
 	LD	D,A		; AND PUT IT BACK IN D
 ;
 ; #######################################################
 ; NOW PREPARE ROW COUNTER C TO COMPLETE ASCII CONVERSION
 ; #######################################################
 ;
 	LD	C,1		; GET NUMBER ONE READY
 BACKUP	LD	A,C		; ACCUM. HAS C FOR MATH
 	AND	E		; TEST IF C = KEYSTROKE
 	JR	NZ,AROUND	; IF NOT, THEN GO AROUND
 	INC	D		; ELSE D = ROW + COLUMN
 	RLC	C		; C SET TO NEXT COLUMN
 	JR	BACKUP		; GO BACK AND TEST AGAIN
 ;
 ; #######################################################
 ; SHIFT ROW IS TESTED TO DETERMINE UPPER/LOWER STATUS
 ; #######################################################
 ;
 AROUND	LD	A,(3880H)	; GET SHIFT ROW FOR TEST
 	LD	B,A		; AND SAVE IT IN B 
 	LD	A,D		; GET ROW COUNTER BACK
 	ADD	A,40H		; AND CONVERT TO ASCII
 	CP	60H		; IS IT UP/LW/GRAFIX/ETC
 	JR	NC,Z0429H	; GO OUT IF GRAPHICS MODE
 	LD	D,A		; SAVE PARTLY CONVERTED
 ;
 ; #######################################################
 ; SHIFT/DOWN ARROW CHECKED FOR CONVERSION TO CONTROL CODE
 ; #######################################################
 ;
 	LD	A,(3840H)	; GET VALUE FOUND 7TH ROW
 	AND	10H		; CHECK IF DOWN ARROW
 	JR	NZ,CNTROL	; IF SO, PRODUCE CONTROL
 	LD	A,D		; ELSE GET VALUE BACK 
 	RRC	B		; B BUMPS INTO CARRY FLAG
 	JR	C,GOAWAY	; IF CARRY, THEN SHIFT
 ;
 ; #######################################################
 ; LOWER CASE CONVERSION, MASK STRIPPING, FINAL TOUCHES
 ; #######################################################
 ;
 	ADD	A,20H		; IF NOT THEN LOWER CASE
 	JR	GOAWAY		; AND GET OUT OF ROUTINE
 CNTROL	LD	A,D		; IF CONTROL CODE, GET IT
 	SUB	40H		; GET RID OF ASCII MASK
 	JR	GOAWAY		; AND GET OUT OF ROUTINE
 Z0429H	SUB	70H		; THE BALANCE OF THE
 	JR	NC,Z043DH	;    ROUTINE BELOW UP TO
 	ADD	A,40H		;    THE BEEP SECTION IS
 	CP	3CH		;    VIRTUALLY IDENTICAL
 	JR	C,Z0435H	;    TO THE KEYBOARD
 	XOR	10H		;    DETERMINATION SUB-
 Z0435H	RRC	B		;    ROUTINE FOUND IN
 	JR	NC,GOAWAY	;    ROM.  A COMPLETE
 	XOR	10H		;    DESCRIPTION OF THIS
 	JR	GOAWAY		;    SECTION OF THE KEY-
 Z043DH	RLCA			;    BOARD SCAN IS FOUND
 	RRC	B		;    IN THE CHAPTER
 	JR	NC,Z0443H	;    SUPPLEMENT ON THE
 	INC	A		;    ROM KEYBOARD SCAN.
 Z0443H	LD	HL,TABLET	; THIS TABLE IS CHANGED
 	LD	C,A		;    FROM THE ONE FOUND
 	LD	B,0		;    IN EARLIER ROMS, BUT
 	ADD	HL,BC		;    THE ROUTINE USED TO
 	LD	A,(HL)		;    ACCESS IT IS THE
 	JR	GOAWAY		;    SAME.
 ;
 ; #######################################################
 ; TABLE BELOW DETERMINES TRS-80 (NOT ASCII) CONTROL CODES
 ; SEE SUPPLEMENT ON KEYBOARD SCAN FOR DETAILS ON CODES
 ; #######################################################
 ;
 TABLET	DEFW	0D0DH		; CARR. RET. / CARR. RET.
 	DEFW	1F1FH		; CLEAR SCRN / CLEAR SCRN
 	DEFW	0101H		; BREAK KEY / BREAK KEY
 	DEFW	1B5BH		; EDIT ESCAPE / UP ARROW
 	DEFW	000AH		; NOP (CHANGE) / LINEFEED
 	DEFW	1808H		; BACKSP. LINE / BACKSP.
 	DEFW	1909H		; 32-CHAR MODE / HOR. TAB
 	DEFW	2020H		; SPACE / SPACE
 ;
 ; #######################################################
 ; FINAL VALUE IS SAVED IN D; STATUS OF SHIFT-0 TESTED
 ; #######################################################
 ;
 GOAWAY	LD	D,A		; SAVE VALUE IN D REG.
 BEEEEP	LD	A,(3810H)	; GET 0 KEYBOARD ROW
 	CP	1		; SEE IF IT IS ZERO (0)
 	JR	NZ,BLEEEP	; GO OUT IF NOT ZERO
 	LD	A,(3880H)	; IF 0, CHECK SHIFT ROW
 	CP	1		; CHECK IF SHIFT KEY
 	JR	NZ,BLEEEP	; IF NOT GO OUT TO BEEP
 	LD	A,(SHIFTR)	; ELSE GET SHIFTLOCK 
 	XOR	1		; AND SWITCH 1-0 OR 0-1
 	LD	(SHIFTR),A	; AND PUT IN SHIFTLOCK
 	LD	BC,500H		; GET LONGER DELAY
 	CALL	0060H		; CALL ROM DELAY SUBR.
 	RET			; AND GO BACK, NO BEEP
 ;
 ; #######################################################
 ; DEBOUNCE IS ADDED; ALTERNATE: BEEP MAY BE LENGTHENED
 ; #######################################################
 ;
 BLEEEP	LD	BC,180H		; DEBOUNCE VALUE AND
 	CALL	0060H		;    DELAY CALL TO ROM
 	LD	A,D		; GET STORED VALUE BACK
 	PUSH	BC		; SAVE BC REGISTER
 	PUSH	AF		; SAVE ACCUM AND FLAGS
 	LD	B,40H		; GET NOTE LENGTH VALUE
 	LD	A,(PORTFF)	; GET STATUS OF SCREEN
 	AND	0FDH		; MASK SCREEN CHANGE OUT
 	LD	H,A		; STORE MSB IN H REG.
 	OR	2		; SET BIT 1 TO BE ON
 	LD	L,A		; STORE ALT. MSB IN L REG
 BEEPER	LD	A,L		; GET ALT. MSB TO OUTPUT
 	OUT	(0FFH),A	; AND OUTPUT RISING WAVE
 	LD	A,H		; NOW GET NORMAL MSB
 	OUT	(0FFH),A	; AND OUTPUT FALLING WAVE
 	PUSH	BC		; SAVE NOTE LENGTH REG.
 	LD	B,40H		; GET FREQUENCY DELAY
 FREQCY	DJNZ	FREQCY		; AND WAIT A LITTLE WHILE
 	POP	BC		; NOW RESTORE LENGTH VAL.
 	DJNZ	BEEPER		; AND GO BACK THAT LENGTH
 	POP	AF		; RESTORE ORIGINAL CHAR.
 	POP	BC		; AND RESTORE ORIGINAL BC
 	JP	0452H		; BACK TO ROM IN PROGRESS
 ;
 ; #######################################################
 ; THIS IS LOWER CASE DETERMINATION FROM STORED INFO
 ; #######################################################
 ;
 LOWER	PUSH	AF		; SAVE NEEDED REGISTER
 	LD	A,(SHIFTR)	; GET STATUS OF SHIFTLOCK
 	CP	1		; CHECK IF STATUS = 1
 	JR	Z,LOWER1	; IF SO THEN GO TO L.C.
 	POP	AF		; ELSE GET ORIGINAL VALUE
 	JP	0458H		; LEAVE TO NORMAL DISPLAY
 LOWER1	POP	AF		; ELSE GET ORIGINAL VALUE
 	LD	L,(IX+3)	; GET CURSOR LSB INTO L
 	LD	H,(IX+4)	; GET CURSOR MSB INTO H
 	JP	C,049AH		; BACK TO ROM IF CARRY
 	LD	A,(IX+5)	; GET CURSOR CHARACTER
 	OR	A		; TEST IF CURSOR IS ON
 	JR	Z,GETCHR	; IF NOT THEN GO DO IT
 	LD	(HL),A		; ELSE PUT IT BACK
 GETCHR	LD	A,C		; GET VALUE TO DISPLAY
 	CP	20H		; IS IT A SPACE OR CNTRL?
 	JP	C,0506H		; OUT IF SPACE OR CONTROL
 	CP	80H		; IS IT GRAPHICS OR TAB?
 	JP	NC,04A6H	; OUT IF GRAPHICS OR TAB
 	JP	047DH		; DO UNCONVERTED DISPLAY
 ;
 ; #######################################################
 	END	06CCH		; BACK TO BASIC READY
 ; #######################################################
 ;
