S      	ORG	5500H
 ; S2/ASM
 START	JR	ENTRY
 SPEED	DB	3
 BYTE	DB	0
 CURSOR	EQU	4020H
 RESULT	DB	0
 SGRANS	DB	0
 DGRANS	DB	0
 SFILES	DB	0
 DFILES	DB	0
 GRANS	DB	0
 STRSPC	DB	0,0,0,0,0,0,0
 CTRACK	DB	0,0,0,0
 ENTRY	PUSH	HL
 	LD	HL,(4049H)
 	LD	A,H
 	SUB	5
 	LD	(TOPMEM),A
 RESTART	LD	HL,MSG1
 	CALL	PRINT
 	XOR	A
 	SBC	HL,HL
 	LD	(SGRANS),HL
 	LD	(SFILES),HL
 	LD	(PMT),A
 	POP	HL
 	CALL	POSHL
 	JR	C,ASKSRC
 	CP	':'
 	JR	NZ,ASKSRC0
 	INC	HL
 	LD	A,(HL)
 ASKSRC0	SUB	30H
 	JR	C,ASKSRC-3
 	CP	4
 	JR	NC,ASKSRC-3
 	LD	(SOURCE),A
 	INC	HL
 	JR	HAVSRC
 	CALL	PARERR
 ASKSRC	CALL	SETPMT
 	LD	HL,MSG29
 	CALL	PRINT
 	CALL	INKEY
 	JR	ASKSRC0
 HAVSRC	LD	A,0
 PROMPT	EQU	$-1
 	DEC	A
 	JR	Z,ASKDES
 	CALL	POSHL
 	JR	C,ASKDES
 	CP	':'
 	JR	NZ,ASKDES0
 	INC	HL
 	LD	A,(HL)
 ASKDES0	SUB	30H
 	JR	C,ASKDES-3
 	CP	4
 	JR	NC,ASKDES-3
 	LD	(DEST),A
 	INC	HL
 	JR	HAVDES
 	CALL	PARERR
 ASKDES	LD	HL,MSG30
 	CALL	PRINT
 	CALL	INKEY
 	JR	ASKDES0
 HAVDES	LD	A,(PROMPT)
 	DEC	A
 	JR	Z,ASKPAR
 	CALL	POSHL
 	JP	C,HAVEALL
 HAVDES0	CP	'V'
 	JR	Z,HAVEVIS
 	CP	'I'
 	JR	Z,HAVEINV
 	CP	'S'
 	JR	Z,HAVESYS
 	CP	'P'
 	JR	Z,HAVPMT
 	CP	'X'
 	JP	Z,GOAGAIN
 	CP	'A'
 	JR	Z,CPYALL
 	CP	'O'
 	JR	Z,OVERWRT
 	CP	'W'
 	JR	Z,STRTWT
 	CP	'H'
 	JR	Z,HELP
 	SUB	30H
 	JR	C,PARB1
 	CP	4
 	JR	NC,PARB1
 	LD	(SPEED),A
 	JR	HAVEV
 PARB1	CALL	PARERR
 	XOR	A
 	LD	(INVIS),A
 	LD	(SYS),A
 	LD	(PMT),A
 	LD	(AFLAG),A
 	LD	(BFLAG),A
 	INC	A
 	LD	(VIS),A
 ASKPAR	LD	HL,MSG32
 	CALL	PRINT
 	CALL	INKEY
 	CP	13
 	JR	Z,HAVEALL
 	JR	HAVDES0
 HAVEVIS	LD	A,1
 	LD	(VIS),A
 HAVEV	INC	HL
 	JR	HAVDES
 HELP	PUSH	HL
 	LD	HL,MSG35
 	CALL	PRINT
 	POP	HL
 	JR	HAVEV
 STRTWT	LD	A,1
 	LD	(PROMPT),A
 	JR	HAVEV
 CPYALL	LD	A,1
 	LD	(AFLAG),A
 	JR	HAVEV
 OVERWRT	LD	A,1
 	LD	(BFLAG),A
 	JR	HAVEV
 HAVEINV	LD	A,1
 	LD	(INVIS),A
 	JR	HAVEV
 HAVESYS	LD	A,1
 	LD	(SYS),A
 	JR	HAVEV
 HAVPMT	LD	A,1
 	LD	(PMT),A
 	JR	HAVEV
 HAVEALL	LD	HL,MSG00
 	CALL	PRINT
 	CALL	SMOUNT
 	LD	DE,0
 	LD	BC,SDIRBUFF
 	CALL	READ
 	JR	NZ,HAVBAD
 	LD	A,(SDIRBUFF+2)
 	AND	7FH
 	LD	D,A
 	LD	E,0
 	LD	A,10
 	LD	BC,SDIRBUFF
 	CALL	MREAD
 HAVBAD	LD	HL,MSG7
 	JP	NZ,ERROR
 	LD	HL,SDIRBUFF+0D0H
 	CALL	PUTNAMEDATE
 	LD	HL,PRINTFILE
 	CALL	FILECOMM
 	LD	A,(SGRANS)
 	CALL	ASCII
 	LD	(SGRANSA),A
 	LD	(SGRANSA+1),BC
 	LD	A,(SFILES)
 	CALL	ASCII
 	LD	(SFILESA),A
 	LD	(SFILESA+1),BC
 	LD	HL,FILMSG
 	CALL	PRINT
 	CALL	DMOUNT
 	LD	DE,0
 	LD	BC,DDIRBUFF
 	CALL	READ
 	LD	HL,MSG8
 	JP	NZ,ERROR
 	LD	A,(DDIRBUFF+2)
 	AND	7FH
 	LD	(DESDIR),A
 	LD	D,A
 	LD	E,0
 	LD	A,10
 	LD	BC,DDIRBUFF
 	CALL	MREAD
 	LD	HL,MSG8
 	JP	NZ,ERROR
 	LD	A,(RESULT)
 	BIT	5,A
 	LD	HL,MSG11
 	JP	Z,ERROR
 	LD	HL,DDIRBUFF
 	LD	BC,5000H
 GRNLOOP	LD	A,(HL)
 	CPL
 	AND	3
 	RRA
 	ADC	A,0
 	ADD	A,C		;add to total
 	LD	C,A		;save total
 	INC	HL		;bump pointer
 	DJNZ	GRNLOOP		;keep counting
 	LD	(DGRANS),A	;save the count
 	CALL	ASCII		;make it ascii
 	LD	(MSG18),A	;put in string
 	LD	(MSG18+1),BC
 	LD	HL,DDIRBUFF+0D0H
 	CALL	PUTNAMEDATE
 	LD	HL,MSG18
 	CALL	PRINT		;display it
 	LD	A,(DGRANS)
 	LD	C,A
 	LD	A,(SGRANS)
 	CP	C
 	JR	Z,DOLOOP
 	JR	C,DOLOOP	;continue
 	LD	HL,MSG28	;turning on prompting
 	CALL	PRINT
 	LD	A,(SOURCE)
 	ADD	A,30H
 	LD	(M231),A
 	LD	A,(DEST)
 	ADD	A,30H
 	LD	(M232),A
 	LD	HL,MSG23
 	CALL	PRINT
 DOLOOP	LD	HL,MSG19	;want to continue?
 	CALL	FLASH		;wait for answer
 	JP	COPYALL		;do the copy
 ;**  SUBROUTINES  **
 BREAK	LD	A,(3840H)	;read keyboard
 	BIT	2,A
 	RET	Z
 	CALL	2BH		;clear the break key
 	LD	HL,MSG34	;aborted
 	CALL	PRINT
 	JP	402DH
 POSHL	LD	A,(HL)		;get a byte
 	INC	HL		;look at next one
 	CP	20H		;space ?
 	JR	Z,POSHL
 	CP	','		;comma ?
 	JR	Z,POSHL
 	DEC	HL
 	CP	13		;terminator ?
 	SCF
 	RET	Z		;done
 	CCF
 	RET
 PARERR	LD	HL,MSG31	;par error
 	CALL	PRINT		;display it
 SETPMT	LD	A,1
 	LD	(PROMPT),A	;turn on prompting
 	RET			;done
 TMEM	LD	A,(HL)		;read 1 byte
 	CPL			;reverse bytes
 	LD	(HL),A
 	CP	(HL)		;test for same
 	RET
 KEY	PUSH	DE
 	PUSH	IY
 	CALL	2BH		;get a key
 	POP	IY
 	POP	DE
 	OR	A
 	RET
 ASCII	PUSH	HL		;save from this
 	CALL	ASCI		;convert to ascii
 	LD	H,B		;save lsb here
 	PUSH	HL
 	LD	A,C		;get msb
 	SUB	30H		;remove ascii
 	CALL	ASCI
 	LD	A,C		;get msb
 	CP	'0'		;leading 0 ?
 	JR	NZ,ASCIGO1
 	LD	A,20H
 ASCIGO1	POP	HL		;restore hl
 	LD	C,B
 	LD	B,H		;ACB = ascii
 	POP	HL
 	RET
 ASCI	LD	C,'0'		;start with 0
 ASCII1	SUB	10		;repeat 10 subtract
 	JR	C,ASCII2
 	INC	C		;bump msb
 	JR	ASCII1
 ASCII2	ADD	A,3AH		;make this ascii
 	LD	B,A		;BC = ascii
 	RET
 FILECOMM	LD	(COMMADDR),HL	;comman looper
 FILELOOP	LD	IX,SDIRBUFF+200H
 	LD	B,64		;64 files possible
 FILELP	BIT	4,(IX)		;active file
 	JR	Z,NEXFILE	;skip dead ones
 	BIT	7,(IX)		;extension?
 	JR	NZ,NEXFILE	;skip those too
 	LD	A,0
 SYS	EQU	$-1
 	DEC	A
 	JR	NZ,XX1
 	BIT	6,(IX)		;system file?
 	JR	NZ,DOCMD
 XX1	LD	A,0
 INVIS	EQU	$-1
 	DEC	A
 	JR	NZ,XX2
 	BIT	6,(IX)
 	JR	NZ,XX2
 	BIT	3,(IX)		;invisible ?
 	JR	NZ,DOCMD
 XX2	LD	A,1
 VIS	EQU	$-1
 	DEC	A
 	JR	NZ,NEXFILE	;next command
 	BIT	3,(IX)
 	JR	Z,DOCMD
 	JR	NEXFILE
 DOCMD	PUSH	BC
 	CALL	0		;set from calling routine
 COMMADDR	EQU	$-2
 	POP	BC
 NEXFILE	LD	DE,20H		;displacement to next
 	ADD	IX,DE
 	DJNZ	FILELP
 	RET			;done
 PRINTFILE	PUSH	BC	;save loop counter
 	LD	HL,SFILES	;bump source file count
 	INC	(HL)
 	LD	B,8		;8 chars in name
 	PUSH	IX		;IX => IY
 	POP	IY
 	LD	HL,FILENAME	;name string
 	PUSH	HL		;save on stack
 PF1	LD	B,8		;8 chars in name
 	CALL	PFPUT		;put in string
 	LD	A,(IY+5)	;get next byte
 	CP	20H		;space ?
 	JR	Z,PF2
 	LD	(HL),'/'	;for extension
 	INC	HL
 	LD	B,3		;3 char extension
 	CALL	PFPUT
 PF2	LD	(HL),0		;terminate message
 	POP	HL		;filename message
 	CALL	PRINT		;display it
 	CALL	MANYGRANS	;how many grans this file
 	LD	A,(HL)		;get file gran count
 	CALL	ASCII
 	LD	(GRANMSG),A
 	LD	(GRANMSG+1),BC	;to the string
 	LD	HL,GRANMSG-3
 	CALL	PRINT		;display it
 	POP	BC		;restore counter
 	RET			;done
 MANYGRANS	PUSH	IX	;IX => IY
 	POP	IY
 	LD	HL,GRANS	;how many grans
 	LD	(HL),0		;start with 0
 MGRLP	LD	A,(IY+22)	;get extent element
 	CP	0FFH		;terminator?
 	RET	Z
 	CP	0FEH		;extension?
 	JR	Z,MGREXT
 	LD	A,(IY+23)	;get # grans
 	AND	1FH		;low 5 bits only
 	INC	A		;actual # of grans assign
 	LD	B,A		;give here for count
 	CALL	ADDCOUNT	;bump counter B times
 	PUSH	HL		;save counter pointer
 	LD	HL,SGRANS	;add to total
 	CALL	ADDCOUNT	;bump this one
 	POP	HL
 	INC	IY		;bump position
 	INC	IY		;to next extry pair
 	JR	MGRLP		;continue
 MGREXT	LD	A,(IY+23)	;get DEC of extension
 	LD	IY,SDIRBUFF+200H	;start of names
 	LD	C,A		;save here a sec
 	AND	7		;low 3 bits only
 	LD	B,A		;give to BC
 	LD	A,C		;get original back
 	AND	0E0H		;high 3 bits only
 	LD	C,A		;position within sector
 	ADD	IY,BC		;point to next entry
 	JR	MGRLP		;continue in loop
 ADDCOUNT	LD	C,B	;save the count
 ADDCLOOP	INC	(HL)	;bump the counter
 	DJNZ	ADDCLOOP	;till B = 0
 	LD	B,C		;get count back
 	RET			;done
 INITCOUNT	LD	(HL),20H
 	INC	HL
 	LD	(HL),20H
 	INC	HL
 	LD	(HL),'0'
 	RET
 PFPUT	LD	A,(IY+5)	;get name byte
 	CP	20H		;space ?
 	JR	Z,PFPUTX	;skip them
 	LD	(HL),A		;else put in string
 	INC	HL		;bump string pointer
 PFPUTX	INC	IY		;get next byte
 	DJNZ	PFPUT		;go some more
 	RET
 GETTRK	PUSH	HL		;save HL
 	PUSH	AF		;save C flag
 	LD	HL,CTRACK	;current track table
 	LD	A,0		;binary drive
 DRIVE	EQU	$-1
 	ADD	A,L		;point to right byte
 	LD	L,A
 	POP	AF		;restore C flag
 	JR	C,PUTIN		;C = put in table
 	LD	A,(HL)		;get the byte
 PUTIN	LD	(HL),A		;put byte in table
 	POP	HL		;restore HL
 	OR	A		;set flags this byte
 	RET			;done
 INKEY	LD	HL,(CURSOR)	;get cursor
 	LD	(HL),95		;cursor on
 	LD	A,14		;cursor on
 	CALL	DOPRT
 INWAIT	CALL	KEY
 	PUSH	AF
 	CALL	BREAK
 	POP	AF
 	JR	Z,INWAIT	;wait some more
 	PUSH	AF
 	LD	A,15
 	CALL	DOPRT
 	POP	AF
 	CP	60H		;lowecase input
 	JR	C,INKEYOK	;nope
 	AND	5FH		;make it uppercase
 INKEYOK	CP	20H		;enter key?
 	JR	NC,INKEYO
 	LD	(HL),20H
 	RET
 INKEYO	LD	(HL),A
 	RET			;done
 ERROR	CALL	PRINT		;display error message
 	LD	HL,MSG10	;termination
 	CALL	PRINT
 	CALL	INKEY
 GOAGAIN	LD	HL,BYTE		;one byte
 	LD	(HL),0DH	;terminator
 	PUSH	HL		;save this for restart
 	LD	A,1
 	LD	(PROMPT),A	;turn on prompting
 	JP	RESTART
 MDWRITE	LD	HL,DWRITE	;directory write
 	JR	MWRITE+3	;go common
 MREAD	LD	HL,READ		;read routine
 	JR	MWRITE+3	;go common routine
 MWRITE	LD	HL,WRITE
 	LD	(RDWRT),HL	;save in code
 	LD	L,A		;L = counter
 MLOOP	PUSH	HL		;save counter
 	CALL	0		;do the command
 RDWRT	EQU	$-2
 	POP	HL		;restore count
 	RET	NZ		;bad I/O
 	INC	E		;bump sector
 	LD	A,E		;check for end of track
 	SUB	10		;10 sectors/track
 	JR	NZ,XLOOP	;go loop
 	LD	E,A		;E = 0
 	INC	D		;bump track
 XLOOP	DEC	L		;reduce counter
 	RET	Z		;all done
 	JR	MLOOP		;now continue
 PUTNAMEDATE	LD	DE,MSG2	;use this message string
 	LD	BC,8		;8 chars in name & date
 	PUSH	BC		;save 8
 	LDIR
 	INC	DE
 	LD	A,'-'
 	LD	(DE),A
 	INC	DE
 	INC	DE
 	POP	BC		;get 8 back
 	LDIR
 	LD	HL,MSG2AA
 	JP	PRINT		;display/return
 DWRITE	LD	A,0ABH		;directory write
 	JR	WRITE+2		;use common routine
 WRITE	LD	A,0A8H		;data write
 	EX	AF,AF'
 	LD	HL,120AH	;transfer direction
 	LD	A,0FCH		;error mask byte
 	JR	IOCOMM		;go common
 READ	LD	A,88H		;IBM read command
 	EX	AF,AF'		;pass here
 	LD	A,9CH		;error mask
 	LD	HL,021AH	;direction
 IOCOMM	LD	(WAY),HL	;save direction
 	LD	(MASK),A	;save error mask
 	EX	AF,AF'		;get operation byte
 	LD	(IOTYPE),A	;save this
 	PUSH	BC		;save load address
 	CALL	TRYONE		;try it once
 	POP	HL		;HL = address
 	RET	Z		;OK first time
 	LD	B,H		;HL => BC
 	LD	C,L
 TRYONE	LD	HL,37ECH	;FDC address
 	CALL	SELECT		;turn on drive
 	RET	NZ		;bad already
 	CALL	SEEK		;move head to track
 	RET	NZ		;bad seek
 	DI
 	LD	(HL),0		;issue the command
 IOTYPE	EQU	$-1
 	PUSH	DE		;save track/sector
 	LD	DE,37EFH	;FDC transfer address
 	CALL	DSKSLO		;wait for valid status
 	JR	XFER2		;transfer the bytes
 XFER1	RRCA			;command done ?
 	JR	NC,XFER3	;finished if bit 0 off
 XFER2	LD	A,(HL)		;read the FDC register
 	BIT	1,A		;ready for transfer?
 	JR	Z,XFER1		;wait if not
 WAY	LD	A,(DE)		;set from above
 	LD	(BC),A
 	INC	BC		;bump buffer pointer
 	JR	XFER2		;same way next byte
 XFER3	LD	A,(HL)		;read result of I/O
 	LD	(RESULT),A	;save the result
 	POP	DE		;restore track/sector
 	AND	0		;check status bits
 MASK	EQU	$-1
 	EI
 	RET	Z		;done OK
 	LD	(HL),0D0H	;force interrupt the FDC
 	RET			;now return
 DRVASC	LD	A,(DRIVE)	;get binary drive
 	ADD	A,30H		;add ascii
 	RET			;that's all
 DSKSLO	EX	(SP),HL		;wait for valid FDC
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	RET
 SEEK	OR	A		;clear carry
 	CALL	GETTRK		;get current track
 	JR	NZ,SEEK1	;continue if not 0
 	CALL	RESTORE		;restore to track 0
 	RET	NZ		;bad one
 SEEK1	LD	(37EDH),A	;give track to FDC
 	LD	(37EEH),DE	;desired track to 37EFH
 	CP	D		;already on the track?
 	JR	Z,SEEK2		;don't bother with it
 	LD	A,(SPEED)
 	AND	3
 	OR	18H
 	CALL	MOVE		;move the head
 	RET	NZ		;error in move
 SEEK2	LD	A,(37EDH)	;get current track
 	SCF			;carry = put in table
 	CALL	GETTRK		;put it in
 	XOR	A		;set Z flag
 	RET			;done OK
 RESTORE	LD	A,(SPEED)
 	AND	3
 	OR	8
 	CALL	MOVE		;move the head
 	RET	NZ		;bad
 	LD	A,(HL)		;get the status byte
 	CPL			;reverse the bits
 	BIT	2,A		;head over track 0 ?
 	LD	A,0		;set track 0
 	RET			;Z = OK
 MOVE	LD	(HL),A		;give command to FDC
 MOVEWT	CALL	SELECT		;select the drive
 	RET	NZ		;dropped ready
 	BIT	0,(HL)		;command done?
 	RET	Z		;return if yes
 	JR	MOVEWT		;else wait some more
 DRIVESET	LD	(DRIVE),A	;save binary driv
 	LD	B,1		;which bit to set
 	OR	A		;set flags
 	JR	DRVCK		;have it
 DRVSET	SLA	B		;move drive bit left
 	DEC	A		;binary - 1
 DRVCK	JR	NZ,DRVSET	;continue loop
 	LD	A,B		;get bit
 	LD	(DRIV),A	;save for drive select
 	RET			;done
 PRINT	LD	A,(HL)		;get data byte
 	INC	HL		;bump pointer
 	OR	A		;check for terminator
 	RET	Z		;done if yes
 	CP	11		;special tab ?
 	JR	Z,CONTRL	;do it here
 PRINTRET	CALL	DOPRT
 	JR	PRINT
 DOPRT	PUSH	IY
 	PUSH	DE
 	CALL	33H		;display it
 	POP	DE
 	POP	IY
 	RET
 CONTRL	PUSH	HL		;save data pointer
 	LD	HL,(CURSOR)	;get cursor address
 	LD	A,L		;get lsb
 	AND	0E0H		;set to begin/middle line
 	LD	L,A
 	PUSH	DE
 	LD	DE,20H		;move to next position
 	ADD	HL,DE
 	POP	DE
 OFFVID	LD	A,H		;check for boundrys
 	CP	3CH		;less than video?
 	JR	NC,OFFAOK	;test one ok
 	LD	HL,3C00H	;top of vid
 OFFBACK	LD	(CURSOR),HL	;update the cursor
 	POP	HL
 	JR	PRINT		;do some more
 OFFAOK	CP	40H		;more than top?
 	JR	C,OFFBACK
 	LD	HL,3FFFH	;put cursor at end
 	LD	(CURSOR),HL
 	POP	HL		;restore pointer
 	LD	A,13		;print a CR
 	JR	PRINTRET	;go back
 FLASH	EXX
 	LD	HL,MSG0
 	EXX
 	JR	WAIT2
 XMOUNT	LD	A,(DEST)	;force a prompt
 	PUSH	AF
 	LD	A,(SOURCE)
 	LD	(DEST),A
 	CALL	AMOUNT		;mount source
 	POP	AF
 	LD	(DEST),A	;put it back
 	RET
 YMOUNT	LD	A,(SOURCE)
 	PUSH	AF
 	LD	A,(DEST)
 	LD	(SOURCE),A
 	CALL	BMOUNT
 	POP	AF
 	LD	(SOURCE),A
 	RET
 SMOUNT	LD	A,0
 PMT	EQU	$-1
 	DEC	A
 	JR	Z,XMOUNT	;force a prompt
 AMOUNT	LD	HL,MSG4
 	LD	A,(SOURCE)	;source drive
 	JR	MOUNT		;go common routine
 DMOUNT	LD	A,(PMT)
 	DEC	A
 	JR	Z,YMOUNT
 BMOUNT	LD	HL,MSG5
 	LD	A,(DEST)	;dest drive
 MOUNT	CALL	DRIVESET	;set up for select
 	EXX			;alternate HL
 	LD	HL,MSG0		;clear line code
 	EXX			;back to this
 	LD	A,0		;get source drive
 SOURCE	EQU	$-1
 	CP	0		;same as destination ?
 DEST	EQU	$-1
 	JR	NZ,MOUNTDONE	;check status
 WAIT2	PUSH	HL		;save message pointer
 	CALL	PRINT		;print it
 	POP	HL
 LOOP2	CALL	KEY
 	PUSH	AF
 	CALL	BREAK
 	POP	AF
 	CP	13		;yes ?
 	JR	Z,MOUNTDONE	;terminate
 	CP	'N'		;no more prompting?
 	JR	Z,MOUNTNO	;turn it off
 	LD	A,0		;get counter
 COUNT1	EQU	$-1
 	DEC	A		;less 1
 	LD	(COUNT1),A	;put updated one back
 	JR	NZ,LOOP2
 	EXX			;other message
 	JR	WAIT2		;print this message/wait
 MOUNTNO	XOR	A
 	LD	(PMT),A		;set flag as off
 MOUNTDONE	LD	HL,MSG0
 	JP	PRINT		;print it
 SELECT	BIT	7,(HL)		;read drive status
 	LD	A,0		;get drive bit
 DRIV	EQU	$-1
 	LD	(37E1H),A	;select the drive
 	RET	Z		;already was on
 	PUSH	BC		;save this
 	LD	BC,0		;1 second delay time
 	CALL	60H		;decrement BC till 0
 	POP	BC		;restore it
 	BIT	7,(HL)		;read status now
 	RET			;Z = OK
 COPYALL	LD	HL,CREATE
 	CALL	FILECOMM
 	LD	HL,DOCOPY	;file copy routine
 	CALL	FILECOMM	;do all files
 	CALL	MAKEHIT		;rebuild HIT table
 	LD	HL,MSG27	;updating directory
 	CALL	PRINT
 	LD	A,10		;write 10 sectors
 	LD	BC,DDIRBUFF	;destination directory
 	LD	DE,1700H	;directory track
 DESDIR	EQU	$-1
 	CALL	MDWRITE		;multiple directory write
 	LD	HL,MSG21	;bad directory update
 	JP	NZ,ERROR	;messed it up
 	LD	HL,MSG20	;completed
 	CALL	PRINT
 	LD	A,(SOURCE)	;get source drive
 	OR	A		;zero ?
 	JR	Z,WAITDOS	;mount system disk
 	LD	A,(DEST)	;dest 0 ?
 	OR	A
 	JP	NZ,402DH
 WAITDOS	LD	HL,MSG33
 	CALL	FLASH
 	JP	402DH
 IFMATCH	PUSH	HL		;save pointers
 	PUSH	DE
 	LD	B,11		;must match 11 chars
 IFMATCH1	LD	A,(DE)	;get a byte
 	CP	(HL)		;same ?
 	JR	NZ,IFMATCH2
 	INC	DE		;bump pointers
 	INC	HL
 	DJNZ	IFMATCH1	;continue for 11
 IFMATCH2	POP	DE	;restore pointers
 	POP	HL
 	RET
 KILLIT	BIT	4,(IX)		;dead already?
 	RET	Z		;yep
 	PUSH	IX		;pass to IY for kill
 	POP	IY
 KILLLP	RES	4,(IY)		;de-activate the file
 KILLLP1	LD	A,(IY+16H)	;get extension entry
 	CP	0FFH		;terminator?
 	RET	Z		;yep
 	CP	0FEH		;extension?
 	JR	Z,EXTENDKL	;kill that too
 	LD	H,A		;start track of kill
 	LD	A,(IY+17H)	;get gran offset/count
 	LD	L,0		;offset from track start
 	BIT	5,A		;2'nd gran?
 	JR	Z,PASTAA
 	LD	L,5		;else 2'nd gran
 PASTAA	AND	1FH		;get gran counter
 	INC	A		;actual gran count
 	LD	C,A		;here for count
 	CALL	RELEASE		;de-allocate the grans
 	INC	IY		;point to next extent
 	INC	IY
 	JR	KILLLP1		;do it
 EXTENDKL	LD	A,(IY+17H)	;get next DEC
 	LD	C,A
 	AND	7		;rel sector offset
 	LD	H,A
 	LD	A,C		;get byte back
 	AND	0E0H		;within sector displ.
 	LD	L,A
 	ADD	HL,DE		;point to next entry
 	PUSH	HL		;pass to IY
 	POP	IY
 	JR	KILLLP		;do the next one too
 RELEASE	PUSH	DE		;save HIT table pointer
 	EX	DE,HL		;DE => start track/sector
 	DEC	H		;HL points to GAT table
 	DEC	H
 	LD	L,D		;point to GAT track
 	LD	A,E		;see if start on sec 0
 	OR	A
 	JR	NZ,SECOND
 RELLP	RES	0,(HL)		;release the gran
 	DEC	C
 	JR	NZ,SECOND
 	JR	RELDONE		;done with this entry
 SECOND	RES	1,(HL)		;release the gran
 	INC	L		;point to next track
 	DEC	C
 	JR	NZ,RELLP
 RELDONE	POP	DE		;restore DE
 	RET			;HIT done separately
 CREATE2	LD	A,L		;get lsb
 	AND	0E0H		;set to begin of extent
 	LD	L,A
 	BIT	4,(HL)		;alive ?
 	JR	Z,CREATE2B	;skip it, dead already
 CREATE2A	LD	A,0
 BFLAG	EQU	$-1
 	DEC	A
 	JR	Z,DOCRE
 	PUSH	HL		;save pointer
 	CALL	PRINTFILE	;print the filename
 	LD	HL,MSG25	;ask if to be replaced
 	CALL	PRINT
 	CALL	INKEY		;wait for answer
 	PUSH	AF		;save key
 	LD	HL,MSG00	;linefeed
 	CALL	PRINT
 	POP	AF
 	POP	HL
 	LD	DE,SDIRBUFF+200H
 	CP	'N'		;no ?
 	JP	Z,KILLIT	;cancel this file
 	CP	13
 	JP	Z,KILLIT
 	CP	'Y'		;yes ?
 	JR	NZ,CREATE2A	;try again
 DOCRE	PUSH	IX		;save pointer
 	PUSH	HL
 	POP	IX
 	LD	DE,DDIRBUFF+200H
 	CALL	KILLIT		;kill dest file
 	POP	IX		;restore pointer
 	JR	CREATE3
 CREATE2B	LD	A,L
 	ADD	A,5		;put it back
 	LD	L,A
 	JR	CREATE2C	;continue with dir
 CREATE	LD	A,0
 AFLAG	EQU	$-1
 	DEC	A
 	JR	Z,DOYES
 	CALL	PRINTFILE
 	LD	HL,MSG12	;copy it?
 	CALL	PRINT
 	CALL	INKEY		;get a key
 	PUSH	AF
 	LD	HL,MSG00
 	CALL	PRINT
 	POP	AF
 	LD	DE,SDIRBUFF+200H
 	CP	'N'		;nope ?
 	JP	Z,KILLIT	;kill from source file
 	CP	13
 	JP	Z,KILLIT
 	CP	'Y'
 	JR	NZ,CREATE	;ask again if wrong
 DOYES	PUSH	IX		;pass file data start
 	POP	DE
 	LD	A,E
 	ADD	A,5		;point to name
 	LD	E,A
 	LD	HL,DDIRBUFF+205H	;destination name
 	LD	C,64		;see if file is there
 CREATE1	CALL	IFMATCH		;see if files match
 	JP	Z,CREATE2	;see if to be overwritten
 CREATE2C	PUSH	BC	;save this
 	LD	BC,20H		;displacement between
 	ADD	HL,BC		;add to dest pointer
 	POP	BC		;get counter back
 	DEC	C
 	JR	NZ,CREATE1	;go some more
 CREATE3	CALL	FINDSPOT	;locate an entry
 	PUSH	HL		;pass to IY for allocate
 	POP	IY
 	EX	DE,HL		;DE => dest spot
 	PUSH	IX
 	POP	HL		;HL => source spot
 	LD	BC,22		;move the entry here
 	LDIR			;exact duplication
 	LD	H,D
 	LD	L,E
 	INC	DE		;clear the extents
 	LD	BC,9		;5 2 byte pairs
 	LD	(HL),0FFH	;set no extents
 	LDIR
 	PUSH	IY		;save from manygrans
 	CALL	MANYGRANS	;how many grans we need?
 	POP	IY
 	LD	B,(HL)		;get the count
 ALLOCLP0	LD	A,4	;allow 4 extents/entry
 	PUSH	IY		;save pointer
 ALLOCLP	PUSH	AF		;save extent counter
 	CALL	CHUNK		;allocate chunk of grans
 	LD	HL,MSG26	;disk space full
 	JP	C,ERROR		;no good
 	LD	(IY+16H),D	;save start track
 	LD	A,C		;get gran count
 	DEC	A		;less 1 for directory
 	OR	E		;or with sector start
 	LD	(IY+17H),A	;save this too
 	INC	IY		;look at next entry
 	INC	IY
 	LD	A,B		;get needed count
 	SUB	C		;less this entry
 	LD	B,A		;re-save it
 	JR	Z,ALLOCDN	;finished
 	POP	AF		;get 4 counter back
 	DEC	A		;only 4 spots available
 	JR	NZ,ALLOCLP	;do them all
 	POP	IY
 	CALL	NEWENTRY	;create an extension
 	JR	ALLOCLP0	;do this one now
 ALLOCDN	POP	AF		;restore stack
 	POP	IY
 	RET			;done with this entry
 NEWENTRY	LD	A,(IY)	;get this from primary
 	PUSH	AF		;save on stack
 	CALL	FINDSPOT	;locate an entry
 	LD	DE,DDIRBUFF+200H	;start of names
 	PUSH	HL		;save start of entry
 	OR	A
 	SBC	HL,DE		;get new DEC
 	LD	A,H		;get displacement
 	OR	L		;have DEC code now
 	LD	(IY+30),0FEH	;mark as extension
 	LD	(IY+31),A	;put DEC of extension
 	PUSH	IY		;get this DEC
 	POP	HL		;get this
 	LD	DE,DDIRBUFF+200H
 	OR	A
 	SBC	HL,DE
 	LD	A,H
 	OR	L
 	POP	HL		;get start of area
 	PUSH	HL		;save again
 	LD	D,H
 	LD	E,L
 	INC	DE
 	PUSH	BC
 	LD	BC,21
 	LD	(HL),0		;clear start
 	LDIR
 	INC	HL
 	INC	DE
 	LD	(HL),0FFH	;extents
 	LD	BC,9
 	LDIR
 	POP	BC
 	POP	IY		;get this back
 	LD	(IY+1),A	;put backward DEC
 	POP	AF		;get activation
 	OR	80H		;set high bit
 	LD	(IY),A
 	RET
 FINDSPOT	LD	HL,DDIRBUFF+200H
 	PUSH	DE
 	PUSH	BC
 	LD	B,64		;64 entries/dir
 	LD	DE,20H
 CREATE4	BIT	4,(HL)		;available?
 	JR	Z,CREATE5	;check it out
 CREATE6	ADD	HL,DE		;next one
 	DJNZ	CREATE4		;continue
 	LD	HL,MSG13	;out of filespace
 	JP	ERROR		;terminate
 CREATE5	LD	A,L		;get lsb
 	CP	40H		;don't use system area
 	JR	C,CREATE6	;continue if yes
 	POP	BC
 	POP	DE
 	RET			;HL => entry area
 CHUNK	LD	HL,DDIRBUFF	;dest gat table
 	LD	C,0		;how many allocated
 CHUNK1	BIT	0,(HL)		;gran 0 available?
 	LD	D,L		;get track we're on
 	LD	E,0
 	JR	Z,CHUNK2	;yes, set E at 0
 	BIT	1,(HL)		;gran 1 available ?
 	LD	E,20H
 	JR	Z,CHUNK3	;yes, set E at 20H
 	INC	L		;next one
 	LD	A,L
 	CP	50H		;end of table?
 	JR	C,CHUNK1	;continue
 	SCF			;C = error
 	RET			;done
 CHUNK2	BIT	0,(HL)		;allocation test
 	JR	NZ,CHUNK4	;finished
 	SET	0,(HL)		;allocate it
 	INC	C		;bump counter
 	LD	A,B		;get needed count
 	CP	C		;enough ?
 	RET	Z		;done
 CHUNK3	BIT	1,(HL)		;allocation test
 	JR	NZ,CHUNK4	;done
 	SET	1,(HL)
 	INC	C
 	LD	A,B
 	CP	C
 	RET	Z
 	INC	L		;next track
 	JR	CHUNK2
 CHUNK4	OR	A		;clear carry
 	RET
 DOCOPY	LD	HL,MSG22	;copying file....
 	CALL	PRINT		;display it
 	CALL	PRINTFILE	;print filename
 	CALL	POSITIY		;position IY to file
 	LD	HL,1		;position in file
 DOCOPY0	XOR	A		;use this as a counter
 	LD	(COUNTER),A	;save it
 	LD	(DESPOS),HL	;dest start position
 	PUSH	HL		;save this
 	CALL	SMOUNT		;mount source disk
 	POP	HL
 	LD	BC,DATABUFF
 DOCOPY1	PUSH	BC		;save buffer
 	PUSH	HL		;save position
 	CALL	POSITS
 	POP	HL
 	POP	BC
 	JR	C,EMPTYBUFF	;write the buffer back
 	PUSH	HL		;save position
 	LD	A,5		;1 gran read
 	CALL	MREAD		;read it
 	POP	HL		;restore it
 	JR	NZ,DOCOPYN	;bad read on source
 	INC	HL		;bump position in file
 	LD	A,0
 COUNTER	EQU	$-1
 	INC	A
 	LD	(COUNTER),A
 	LD	A,B		;get page in memory
 	CP	0		;at top of memory?
 TOPMEM	EQU	$-1
 	JR	C,DOCOPY1
 	OR	A		;clear carry for not done
 EMPTYBUFF	PUSH	AF	;save carry flag for loop
 	PUSH	HL
 	CALL	DMOUNT		;mount destination disk
 	LD	A,(COUNTER)	;sector counter
 	LD	BC,DATABUFF	;where data is
 	LD	HL,0		;get start position
 DESPOS	EQU	$-2		;saved from above
 	CALL	CREATWRITE	;write the grans back
 	POP	HL		;restore position
 	POP	AF		;get result back
 	RET	C		;done with this file
 	JR	DOCOPY0		;do the rest
 DOCOPYN	LD	HL,MSG7
 	JP	ERROR		;source read error
 MAKEHIT	LD	HL,DDIRBUFF+100H	;dest HIT table
 	LD	DE,DDIRBUFF+101H
 	LD	BC,0FFH
 	LD	(HL),0		;zero it out
 	LDIR
 	LD	IX,DDIRBUFF+200H	;start of names
 	LD	B,64		;64 entries
 HITLP	BIT	4,(IX)		;active entry
 	PUSH	BC		;save count
 	CALL	NZ,PUTHIT	;insert HIT byte
 	LD	BC,20H		;next entry
 	ADD	IX,BC
 	POP	BC
 	DJNZ	HITLP		;do all 64
 	RET			;done
 HASH	PUSH	IX		;save position
 	PUSH	BC
 	LD	BC,0B00H	;B = char count, C = hash
 HASHLP	LD	A,(IX+5)	;get a name byte
 	INC	IX		;point to next one
 	XOR	C		;hash it
 	RLCA
 	LD	C,A
 	DJNZ	HASHLP
 	OR	A		;check for 0 hash
 	JR	NZ,HASHOK	;ok if not
 	INC	A		;else make it 1
 HASHOK	POP	BC
 	POP	IX
 	RET			;done
 PUTHIT	BIT	7,(IX)		;extension entry ?
 	RET	NZ		;don't do those YET
 	PUSH	IX		;pass to HL for breakdown
 	POP	HL
 	LD	DE,DDIRBUFF+200H
 	OR	A		;clear carry
 	LD	A,L
 	SBC	HL,DE
 	AND	0E0H
 	OR	H		;compute HIT location
 	LD	HL,DDIRBUFF+100H
 	LD	L,A
 	CALL	HASH		;compute hash byte
 	LD	(HL),A		;put in table
 	EX	AF,AF'		;save hash byte here
 	PUSH	IX		;pass to IY
 	POP	IY
 PUTHITX1	LD	A,(IY+30)
 	CP	0FEH		;any extensions ?
 	RET	NZ		;nope, all done
 PUTHITX	LD	L,(IY+31)	;get DEC for next one
 	EX	AF,AF'
 	LD	(HL),A		;save this byte too
 	EX	AF,AF'		;resave it
 	PUSH	HL
 	LD	A,L
 	AND	1FH		;get track displacement
 	LD	H,A
 	LD	A,L
 	AND	0E0H		;get sector position
 	LD	L,A
 	LD	BC,DDIRBUFF+200H	;entries
 	ADD	HL,BC		;have next one
 	PUSH	HL		;pass to IY
 	POP	IY
 	POP	HL
 	JR	PUTHITX1	;next entry
 POSITIY	PUSH	IX		;pass to HL for compare
 	POP	DE
 	LD	A,E
 	ADD	A,5
 	LD	E,A		;point to name
 	LD	HL,DDIRBUFF+205H
 	LD	C,64
 POSITIY1	CALL	IFMATCH	;compare names
 	JR	Z,POSIYG	;go if match
 	PUSH	BC		;save count
 	LD	BC,20H		;point to next entries
 	ADD	HL,BC
 	POP	BC		;restore count
 	DEC	C
 	JR	NZ,POSITIY1	;continue
 	LD	HL,MSG24	;program error
 	JP	ERROR
 POSIYG	LD	A,L		;get dest LSB
 	AND	0E0H		;point to begin of entry
 	LD	L,A
 	PUSH	HL
 	POP	IY
 	RET			;IY => filename (dest)
 POSITS	PUSH	IY		;must save IY from use
 	PUSH	IX		;pass to IY
 	POP	IY
 	LD	DE,SDIRBUFF+200H
 	LD	(SAVEDIR),DE	;save for postion use
 	CALL	POSIT		;position to IY file
 	POP	IY		;restore IY
 	RET
 POSITD	PUSH	IY		;save IY
 	LD	DE,DDIRBUFF+200H
 	LD	(SAVEDIR),DE	;save it
 	CALL	POSIT		;position the file
 	POP	IY		;restore it
 	RET
 POSIT	LD	A,(IY+16H)	;get extent
 	CP	0FFH		;terminator?
 	SCF			;C = EOF
 	RET	Z		;return if end
 	CP	0FEH		;extension ?
 	JR	Z,POSEXT	;get the extent
 	LD	D,A		;else start track
 	LD	A,(IY+17H)	;get offset/grans
 	LD	E,0		;start with sector 0
 	BIT	5,A
 	JR	Z,POSIT2
 	LD	E,5		;else sector 5
 POSIT2	AND	1FH		;get gran counter
 	INC	A
 POSIT2A	LD	(CNTSAV),A	;save the counter
 	DEC	HL		;reduce posit count
 	LD	A,H
 	OR	L		;any bits left ?
 	RET	Z
 	CALL	NEXTGRAN
 	LD	A,0		;get count back
 CNTSAV	EQU	$-1
 	DEC	A		;reduce it
 	JR	NZ,POSIT2A
 	INC	IY		;next extent
 	INC	IY
 	JR	POSIT
 POSEXT	LD	A,(IY+17H)
 	PUSH	HL		;save position
 	LD	L,A
 	AND	7
 	LD	H,A		;relative to HIT table
 	LD	A,L
 	AND	0E0H
 	LD	L,A
 	LD	DE,0		;saved directory position
 SAVEDIR	EQU	$-2		;set from POSITS/POSITD
 	ADD	HL,DE		;point to the right byte
 	PUSH	HL
 	POP	IY
 	POP	HL		;restore count
 	JR	POSIT		;go some more
 NEXTGRAN	LD	A,E	;get sector
 	CP	5		;on the 2'nd gran?
 	JR	Z,NTRKGRN	;go to next track
 	LD	E,5		;else go to 5
 	RET
 NTRKGRN	LD	E,0
 	INC	D		;bump track
 	RET
 CREATWRITE	PUSH	HL
 	PUSH	BC		;save buffer
 	CALL	POSITD
 	POP	BC
 	LD	A,5		;5 sectors/gran
 	CALL	MWRITE		;multiple write
 	LD	HL,MSG9		;dest write error
 	JP	NZ,ERROR	;terminate
 	POP	HL		;restore position
 	INC	HL
 	LD	A,(COUNTER)
 	DEC	A		;reduce it
 	RET	Z		;done with this bunch
 	LD	(COUNTER),A
 	JR	CREATWRITE	;continue
 ;  **  MESSAGE TEXT  **
 FILMSG	DB	10
 SFILESA	DB	'xxx Files, '
 SGRANSA	DB	'xxx Grans to be copied.',10,0
 FILENAME	DB	'            ',0
 	DB	' / '
 GRANMSG	DB	'xxx Grans',11,0
 MSG00	DB	10,0		;linefeed
 MSG0	DB	1DH,1EH,0
 MSG1	DB	1CH,1FH,'**  Multiple File Transfer Utility  **',10
 	DB	'by Kim Watt - Version 1.0',10
 	DB	'(C)(P) 1981 Breeze Computing Inc. ',10
 	DB	'Distributed by Quality Software - Dallas, Texas',10,0
 MSG2AA	DB	10,'Disk Name/Date:  '
 MSG2	DB	'         -         ',10,0
 MSG3	DB	'                ',10,0
 MSG4	DB	1DH,'Mount SOURCE disk, key <ENTER>. ',0
 MSG5	DB	1DH,'Mount DESTINATION disk, key <ENTER>. ',0
 MSG6	DB	1DH,1EH,'Destination Drive ? ',0
 MSG7	DB	10,'SOURCE Disk READ ERROR !',10,0
 MSG8	DB	10,'DESTINATION Disk READ ERROR !',10,0
 MSG9	DB	10,'DESTINATION Disk WRITE ERROR !',10,0
 MSG10	DB	10,'Program TERMINATED in ERROR.',10
 	DB	'Key <ENTER> to restart. ',0
 MSG11	DB	10,'CANNOT LOCATE Destination Directory.',10,0
 MSG12	DB	'<<==  Copy it ? ',0
 MSG13	DB	10,'FILE SPACE FULL !',10,0
 MSG18	DB	'xxx Grans available on destination disk.',10,0
 MSG19	DB	'Key <ENTER> to proceed with copy. ',0
 MSG20	DB	10,'** Copy Completed **',10,0
 MSG21	DB	10,'Destination Directory Update WRITE ERROR ! ',10,0
 MSG22	DB	'Copying File  ==>> ',0
 MSG23	DB	'Source Drive = '
 M231	DB	'x, Destination Drive = '
 M232	DB	'x.',10,0
 MSG24	DB	10,'Internal Error !',10,0
 MSG25	DB	'<<==  EXISTS, Replace it ? ',0
 MSG26	DB	10,'DISK SPACE FULL !',10,0
 MSG27	DB	'Updating Destination Directory.',10,0
 MSG28	DB	'Not enough grans on Destination Disk for all files.',10,0
 MSG29	DB	10,'Source Drive ? ',0
 MSG30	DB	10,'Destination Drive ? ',0
 MSG31	DB	10,'Parameter Error !',0
 MSG32	DB	10,'Parameters (H,V,I,S,P,A,O,X,0-3) ? ',0
 MSG33	DB	1DH,'Mount SYSTEM disk, key <ENTER>. ',0
 MSG34	DB	10,'**  Aborted  **',0
 MSG35	DB	10,10,'<H>elp, print this text.'
 	DB	10,'<V>isible files.'
 	DB	10,'<I>nvisible files.'
 	DB	10,'<S>ystem files.'
 	DB	10,'<P>rompt for disk mounts.'
 	DB	10,'<A>ll, copy all files indicated, no prompting.'
 	DB	10,'<O>verwrite files if found on destination disk, no prompting.'
 	DB	10,'<X> Cancel and restart program.'
 	DB	10,'<0-3> set step speed to 6, 12, 20, or 40 milliseconds.',10,0
 ;**  BUFFERS  **
 LOWEND	EQU	$&0FF00H	;get even page of memory
 SDIRBUFF	EQU	LOWEND+100H
 DDIRBUFF	EQU	SDIRBUFF+0A00H	;room for 10 secs
 DATABUFF	EQU	DDIRBUFF+0A00H	;for data I/O
 	END	START
2, 20, or 40 milliseconds.',10,0
 ;**  BUFFERS  **
 LOWEND	EQU	$&0FF00H	;get even page of memory
 SDIRBUFF	EQU	LOWEND+100H
 DDIRBUFF	EQU	SDIRBUFF+0A00H	;room for 10 secs
 DAT