;Machine code for MULTIKEY editor
;
;
;Print String R$(I+1)
;
	ORG	67F8H
USR3	CALL	0A7FH
	CALL	PRINT		;PRINT STRING
	JP	0A9AH		;BACK TO BASIC
PRINT	INC	L
	PUSH	HL
	LD	B,H		;ZERO MSB
	LD	C,5		;LENGTH OF MSG
	LD	A,L		;GET "I"
	LD	HL,MSG+1
	CP	44
	JR	NC,JM1		;GO IF F-KEY
	ADD	A,47		;CONVERT TO ASCII
	LD	(HL),A		;STORE KEY NUMBER
	LD	A,20H		;SPACE
	CALL	033H		;PRINT IT
JM3	CALL	4467H		;PRINT KEY NUM
	LD	HL,STRING	;POINT TO R$ NAME
	CALL	260DH		;GET ADDRESS OF VARIABLE
	POP	HL		;"I" IN HL
	EX	DE,HL
	ADD	HL,DE		;VARPTR(R$(0))+I
	ADD	HL,DE		;		+2I
	ADD	HL,DE		;		+3I
	LD	A,(HL)		;GET STRING LENGTH
	OR	A		;IS IT ZERO?
	JR	NZ,JM2		;GO IF NOT
	LD	A,0DH
	JP	033H		;SKIP ONE LINE
JM2	LD	B,A		;STORE STRING LENGTH
	INC	HL		;BUMP VAR POINTER
	LD	A,(HL)		;LSB
	INC	HL
	LD	H,(HL)		;MSB
	LD	L,A
LOOPA	LD	A,(HL)		;FETCH CHAR FROM STRING
	CP	03H		;IS IT EOM?
	JR	NZ,JM5
	LD	A,2DH		;ASCII "-"
	JR	JM6
JM5	CP	0DH		;IS IT CR?
	JR	NZ,JM7
	LD	A,2FH
JM6	CALL	033H		;PRINT "-" OR "/"
	LD	A,0DH
JM7	CALL	033H
	INC	HL		;BUMP POINTER
	DEC	B		;DEC COUNT
	RET	Z		;IF Z LAST CHAR DISPLAYED
	CP	0FH		;IS IT TERMINATOR?
	JR	NC,LOOPA	;NO, PRINT NEXT CHAR
	LD	A,197		;5 SPACES CODE
	CALL	33H		;PRINT IT
	JR	LOOPA		;PRINT BASIC CMD
JM1	ADD	A,C		;F-KEY NUMBER
	LD	(HL),A		;STORE IT
	DEC	HL		;POINT TO 'F'
	JR	JM3
MSG	DEFM	'F '
	DEFB	138
	DEFW	2020H
	DEFB	03H
STRING	DEFM	'R$(0)'
	DEFW	00H
;
;IF THEN LOGIC
;
USR2	CALL	0A7FH		;GET I INDEX
	JR	EXITL		;PRINT KEY
JMP6	EX	DE,HL		;"I" IN HL
	CALL	CTRL		;CHECK ARROWS
	JR	Z,JMP1		;GO GET NEXT KEY
EXITL	PUSH	HL
	CALL	PRINT		;PRINT KEY
	POP	HL
JMP1	CALL	49H		;SCAN KEYBOARD
	EX	DE,HL		;SAVE "I"
	LD	HL,LINE		;POINT TO LINE INDEX
	CP	08H		;BACKSPACE?
	LD	(HL),04H	;DO NOT NEED MODS
	JR	Z,EXITL2
	CP	44		;ASCII "," - EDIT
	LD	(HL),03H
	JR	Z,EXITL2
	CP	64		;ASCII "@" DISPAY KEYS
	JR	NZ,JMP7	
	LD	A,50
	CP	E		;IS IT LAST KEY?
	JR	Z,JMP6		;YES
	LD	(HL),05H
	JR	EXITL2
JMP7	CP	69		;ASCII "E"
	LD	(HL),02H
	JR	NZ,JMP6
EXITL2	EX	DE,HL		;RESTORE "I" IN HL
	JP	0A9AH		;GO BACK TO BASIC
CTRL	CP	10		;DOWN ARROW
	JR	NZ,JMP2
	LD	A,50		;LAST KEY CODE
	CP	L		;IS IT LAST KEY?
	RET	Z		;YES, DO NOTHING
	INC	L		;BUMP	I
	LD	A,16
	CP	L		;IS IT "@" KEY?
	RET	NZ		;NO
	INC	L		;SKIP "@"
	RET
JMP2	CP	26		;SHIFT DOWN ARROW?
	JR	NZ,JMP3		;NO
	LD	A,50
	CP	L		;LAST KEY?
	RET	Z
	LD	L,50		;I = 50
	RET
JMP3	CP	27		;SHIFT UP ARROW?
	JR	NZ,JMP4
	XOR	A		;CLEAR A
	OR	L		;I=0?
	RET	Z
	LD	L,H		;I=0
	RET
JMP4	CP	91		;UP ARROW?
	JR	Z,JMP5
	XOR	A
	RET
JMP5	XOR	A
	OR	L		;I=0?
	RET	Z
	DEC	L		;I-1
	LD	A,16
	CP	L		;IF I=16 THEN
	RET	NZ
	DEC	L		;I=15
	RET
LINE	DEFB	00H		;LINE INDEX
;
;Calculate length of program
;
USR5	CALL	0A7FH		;VARPTR(R$(0))
	LD	DE,0FFFDH	;CLEAR DE
	LD	B,52		;50 KEYS + PROGRAM
	LD	A,9		;FIRST F-KEY
ITER1	CP	B
	JR	NZ,SKIP1
	LD	(FTBL),DE
SKIP1	INC	HL		;POINT TO NEXT ELMENT
	INC	HL
	INC	HL
	PUSH	HL		;SAVE POINTER
	LD	L,(HL)		;GET LENGTH
	INC	L
	DEC	L
	JR	Z,SKIP
	LD	H,0H
	INC	HL
	ADD	HL,DE		;LENGTH IN HL
	EX	DE,HL		;PUT IT IN DE
SKIP	POP	HL		;RESTORE POINTER
	DJNZ	ITER1		;LOOP
	EX	DE,HL		;GET LENGTH
	LD	(LLOAD),HL
EXIT1	JP	0A9AH		;BACK TO BASIC
;
;EDITOR, execute control characters
;
	ORG	6925H
USR4	CALL	0A7FH		;GET "I"
	LD	A,(LINE)	;GET INKEY$ CHAR
	CALL	CTRL		;CHECK/DO CONTROL CHAR
	JR	Z,EXIT1		;WAS NOT CONTROL CHAR
	PUSH	HL		;SAVE "I"
	LD	DE,3C80H	;PLACE CURSOR
	LD	(4020H),DE	;IN DCB
	LD	A,1FH
	CALL	33H		;CLEAR TO THE END OF LINE
	CALL	PRINT		;PRINT CURRENT KEY
	POP	HL		;RESTORE "I"
	JR	EXIT1		;GO BACK TO BASIC
;
;
;TRANSFER DISK SECTOR TO BASIC STRING
;
USR0	CALL	0A7FH		;GET R$(0) ADDRESS
	CALL	READSC		;GET FIRST SECTOR
	LD	DE,0A000H	;BUFFER
	LD	B,17
	CALL	STOREA		;STORE ADDRESS
	CALL	JP9		;MOVE 17 CHARS
	LD	C,80H		;FIRST KEY MARKER
LOOP2	CALL	READSC		;GET NEXT CHAR
LOOP1	CALL	LDCODE
	OR	A		;ZERO?
	JR	Z,JP2		;KEY TERMINATOR?
	CP	C		;WRIGHT MARKER?
	JR	Z,JP3
	BIT	7,A		;MARKER?
	JR	NZ,JP1
	LD	(DE),A
	INC	DE
	INC	(HL)		;BUMP STRING COUNT
	JR	LOOP2
JP3	CALL	READSC		;SKIP MARKER
JP1	CALL	NEXTR
	INC	C		;BUMP MARKER
ZERO	JR	LOOP1
	LD	C,(IY)
	INC	IY
	JR	LOOP1
JP2	LD	A,0
FKEY	EQU	$-1
	OR	A
	JR	NZ,JP5		;ALL KEYS DONE
	LD	(ZERO),A	;MODIFY CODE
	LD	(ZERO+1),A	;FOR FUNCTION KEYS
	INC	A
	LD	(FKEY),A	;FUNCTION KEYS
	LD	IY,TBL+1
	LD	C,(IY-1)
	JR	LOOP2		;SKIP TERMINATOR
JP5	CALL	NEXTR		;STORE ADDR OF R$(51)
LOOP5	CALL	READSC		;SKIP TERMINATOR
	CALL	LDCODE
	LD	(DE),A
	INC	(HL)
	INC	DE
	JR	LOOP5
;
NEXTR	INC	HL
	INC	HL
	INC	HL
STOREA	INC	HL
	LD	(HL),E		;STORE ADDRESS
	INC	HL
	LD	(HL),D
	DEC	HL
	DEC	HL
	RET
;
;CHECK FOR LOADER CODE
;
LDCODE	LD	B,A		;CHECK IF LOADER
	LD	A,(LDLEN)
	CP	1
	LD	A,B
	RET	NZ
	CP	2		;TRANSFER CODE
	JR	Z,JP8
	LD	B,4
LOOP3	CALL	READSC
	DJNZ	LOOP3
	RET
JP8	POP	BC		;REMOVE RET ADDRESS
	LD	B,4
	JR	JP9
LOOP4	CALL	READSC
JP9	LD	(DE),A
	INC	DE
	INC	(HL)
	DJNZ	LOOP4
	RET			;BACK TO BASIC
;
READSC	PUSH	BC
	PUSH	DE
	PUSH	HL
	LD	BC,0FFH		;256 BYTES
RCOUNT	EQU	$-2		;SAVE COUNT IN C
	LD	DE,66CBH	;FCB
	LD	HL,66EBH	;READ BUFFER
	INC	C		;BUMP COUNT
	LD	A,C
	LD	(RCOUNT),A
	JR	NZ,RDJP2
	CALL	4436H		;GET NEW SECTOR
RDJP4	JP	NZ,4409H
RDJP2	ADD	HL,BC		;POINT TO CURRENT BYTE
	LD	A,2H		;NO OF CHARS +4
LDLEN	EQU	$-1
	CP	2		;NEXT LOADER CODE?
	JR	NZ,RDJP3
	CP	(HL)
	JR	Z,RDJP3		;02 CODE, NO ERROR
	DEC	A
	CP	(HL)		;01 CODE, NO ERROR
	LD	A,2
	JR	Z,RDJP3
	LD	A,22H		;ERROR CODE
	JR	RDJP4
RDJP3	DEC	A
	LD	(LDLEN),A	;SAVE NEW COUNT
	LD	A,(HL)		;GET CHAR
	JR	NZ,RDJP1
	ADD	A,2		;NO OF CHARS + 3
	LD	(LDLEN),A
	LD	A,(HL)		;RECOVER CHAR
RDJP1	POP	HL
	POP	DE
	POP	BC
	RET
;
;
	ORG	6A16H
TBL	DB	0F0H,0F1H,80H,81H,90H,91H,0B0H,0B1H,10H
LOAD	DEFB	145		;LOAD POINT IN BUFFER
LLOAD	DEFW	596		;PROG LENGTH
FTBL	DEFW	0000H		;LOAD ADDRESS
MARKER	DEFB	7FH		;MARKER (KEY CODE)
STACK	DEFW	0000H		;STACK POINTER (USR6)
;
;USR6 Subroutine
;
WRITE	LD	DE,67F8H
	CALL	443CH		;WRITE AND VERIFY SECTOR
	LD	DE,6818H	;POINT TO OTOP OF BUFFER
	RET	Z		;NO DISK ERRORS
	LD	SP,(STACK)	;GET STACK ADDRESS
	LD	H,0
	LD	L,A		;ERROR CODE
	JP	0A9AH		;RET TO BASIC
;
;Write modified Program to Disk
;
USR6	CALL	0A7FH		;VARPTR(R$(0))
	LD	(STACK),SP	;SAVE STACK POINTER
	PUSH	HL
	POP	IX
	LD	L,(IX+1)
	LD	H,(IX+2)
	LD	BC,17		;17 CHARS IN R$(0)
	PUSH	HL
	PUSH	BC
	LD	DE,66EBH	;TRANSFER R$(0) TO BUFF 1
	LDIR
	LD	DE,(66FAH)	;ATBL ADDRESS
	LD	(66F6H),DE	;SAVE IT
	DEC	HL		;POINT TO ATBL ADDRESS
	POP	BC
	POP	HL
	LD	DE,6818H	;DISK BUFFER 2
	LD	A,145
	LD	(LOAD),A
	LD	A,7FH
	LD	(MARKER),A
	LD	A,C		;17 CHARC WILL BE IN BUFF
	EX	AF,AF'		;SAVE CHAR COUNT
	LDIR			;TRANS 17 CHARS
LP1	INC	IX
	INC	IX
	INC	IX		;POINT TO NEXT ELEMENT
	LD	C,(IX)		;CHAR COUNT
	LD	A,(MARKER)	;GET MARKER
	INC	A		;BUMP COUNT
	LD	(MARKER),A	;SAVE MARKER
	CP	0ABH		;IS IT F-KEY?
	JR	NZ,AA1
	XOR	A		;CLEAR A
	LD	(DE),A		;PLACE '0' IN BUFFER
	INC	DE		;BUMP POINTER
	CALL	CHECK
	LD	A,0ABH
AA1	JR	C,AA2
	PUSH	BC
	LD	HL,TBL		;F-KEY MARKERS
	SUB	0ABH		;AND
	LD	C,A
	ADD	HL,BC
	LD	A,(HL)
	POP	BC
	CP	10H		;IS IT LAST F-KEY?
	JR	NZ,AA2
	XOR	A
	LD	(DE),A		;PLACE SEPARATOR IN BUFF
	INC	DE		;BUMP POINTER
	CALL	CHECK
	DEC	BC
	DEC	BC
	DEC	BC
	DEC	BC		;SKIP ENTRY CODE/ADDRESS
	LD	L,(IX+1)
	LD	H,(IX+2)
	PUSH	HL
	POP	IX
	PUSH	DE
	LD	DE,(FTBL)	;GET FTBL ADDRESS
	LD	(IX+18),E
	LD	(IX+19),D
	LD	DE,(66F6H)
	LD	(IX+57),E
	LD	(IX+58),D	;ADDRESS OF TBL
	CALL	NEWADD
	POP	DE
LP2	LDI			;TRANSFER CHAR
	JP	PO,AA4
	CALL	CHECK
	JR	LP2
AA4	LD	C,5		;ADD ENTRY CODE & ADDRESS
LP2A	LDI
	JP	PO,AA3
	CALL	WCHECK
	JR	LP2A
AA3	EX	AF,AF'		;GET CHAR COUNT
	INC	A
	LD	(67FDH),A	;FCB+5
	LD	A,48H		;UPDATE EOF AFTER NEXT
	LD	(67F9H),A	;DISK WRITE
	CALL	WRITE
	LD	H,1H
	JP	0A9AH
AA2	INC	C		;CHECK FOR ZERO
	DEC	C		;STRING
	JP	Z,LP1
	LD	(DE),A
	INC	DE
	CALL	CHECK
	LD	L,(IX+1)
	LD	H,(IX+2)
LP3	LDI			;TRANSFER CHAR TO BUFF
	CALL	CHECK
	JP	PO,LP1		;LOOP
	JR	LP3
WCHECK	EX	AF,AF'
	INC	A
	PUSH	AF
	CALL	Z,WRITE
	POP	AF
	EX	AF,AF'
	RET
CHECK	PUSH	AF
	PUSH	HL
	CALL	WCHECK
	LD	HL,LOAD		;CURRENT LOADER POINT
	EX	AF,AF'
	CP	(HL)
	JR	NZ,LP4
	PUSH	AF
	ADD	A,84H		;NEXT LOADER CODE
	LD	(HL),A
	POP	AF
	PUSH	BC
	LD	C,80H		;AND ADD
	LD	HL,(66FAH)	;LOAD ADDRESS
	ADD	HL,BC		;128 BYTES (EDTASM FORM)
	LD	(66FAH),HL
	LD	HL,(LLOAD)	;CHARS TO BE LOADED
	SBC	HL,BC
	LD	(LLOAD),HL
	PUSH	AF
	PUSH	DE
	PUSH	BC
	POP	DE
	RST	18H
	LD	A,L
	POP	DE
	LD	HL,66F9H
	JR	NC,LP5
	ADD	A,2H		;OFFSET BY (2) LOAD BYTES
	LD	(HL),A
LP5	POP	AF
	DEC	HL
	LD	C,4		;4 CHAR LOADER CODE
	EX	AF,AF'
LOAD1	LDI			;TRANSFER
	CALL	WCHECK
	JP	PE,LOAD1	;LOADER CODE
	POP	BC
	EX	AF,AF'
LP4	EX	AF,AF'
	POP	HL
	POP	AF
	RET
;
;INPUT character and check for <CR>, <DEL> etc.
;
	ORG	6B70H
LEN	DEFB	58
USR1	CALL	0A7FH		;GET STRING ADDRESS
	PUSH	HL
	POP	IX		;TRANSFER TO IX
	LD	DE,66EBH	;NEW STRING ADDRESS
	LD	L,(IX+1)	;GET OLD STRING
	LD	H,(IX+2)	;ADDRESS
	LD	(IX+1),E	;POKE NEW ADDR TO VARPTR
	LD	(IX+2),D
	LD	C,(IX)		;CURRENT STRING LENGTH
	LD	B,0H		;CLEAR MSB
	LDIR			;TRANS STRING TO NEW ADDR
	PUSH	DE		;SAVE NEW ADDRESS
	LD	A,14
	CALL	33H		;CURSOR ON
	CALL	49H
	PUSH	AF
	LD	A,1FH		;CLEAR TO THE
	CALL	33H		;END OF FRAME
	POP	AF
	POP	DE
	JR	GO7
CHAR	PUSH	DE
	CALL	49H
	POP	DE
GO7	CP	13		;<CR>?
	JR	NZ,GO1
	LD	L,1		;STORE CODE 1
OUT	LD	H,B		;ZERO MSB
	JP	0A9AH		;BACK TO BASIC
GO1	CP	8		;ERASE?
	JR	NZ,GO2
	CALL	33AH
	LD	A,(IX)		;STRING LENGTH
	DEC	A		;IS IT 1?
	JR	Z,GO6		;YES,SO GO
	DEC	(IX)		;DEC STRING LENGTH
	DEC	DE
	JR	CHAR
GO6	LD	L,2		;CODE
	JR	OUT
GO2	LD	C,A		;SAVE CHAR
	LD	A,(LEN)		;IF BASIC LEN=58
	CP	(IX)		;LEN CHARS IN STRING?
	JR	NZ,GO5
	LD	L,3
	JR	OUT
GO5	LD	A,C		;RESTORE CHAR
	CP	129		;IS IT LEGAL CHAR?
	JR	C,GO3
GO4	LD	(LINE),A
	LD	L,4
	JR	OUT
GO3	CP	14		;LEGAL CHAR?
	JR	C,GO4
	LD	(DE),A		;PUT CHAR IN STRING
	INC	DE
	INC	(IX)		;BUMP STRING LENGTH
	CALL	33AH		;DISPAY CHAR
	JR	CHAR		;LOOP
;Calculate and insert Position of TBLADR and CONT
NEWADD	PUSH	HL
	LD	HL,(6C40H)	;GET TOTAL LENGTH
	DEC	HL		;ADDR OF TBLADR
	LD	(IX+79H),L	;CHANGE ADDRESS
	LD	(IX+7AH),H	; OF TBLADR
	LD	DE,70H
	ADD	IX,DE		;OFFSET POINTER
	LD	(IX+0ADH-70H),L	;PLACE NEW ADDRESS
	LD	(IX+0AEH-70H),H	; OF TBLADR
	LD	E,5
	SBC	HL,DE		;ADDR OF CONT
	LD	(IX+58H-70H),L	;CHANGE ADDR
	LD	(IX+59H-70H),H	; OF CONT
	POP	HL
	RET
	END
                                                                                                             