       ;Program to generate Morse code from ASCII text.
 ;Uses the Cassette port on a Model 3 or 1
 ;Works to a maximum speed of about 25 words per minute
 ;<c>1983 by Mel Patrick
 	ORG	6000H		;start for routine
 START	LD	HL,TBUFF	;point to buffer
 	LD	(MARKER),HL	;reset end of file
 MORSE	CALL	01C9H		;clear the video
 	LD	HL,INS		;point to instructions
 	CALL	DISPLY		;show them
 	LD	A,0EH		;turn on the cursor
 	CALL	33H		;in ROM
 MENU	CALL	49H		;wait for selection
 	CALL	33H		;display the character
 	CP	'C'		;for adjust sound
 	JR	Z,ADJUST	;go if wanted.
 	CP	'E'		;for exit to DOS
 	JP	Z,402DH		;back to dos if yes
 	CP	'A'		;for test on alphabet?
 	JP	Z,ALPHA		;go if yes
 	CP	'L'		;for load ASCII file
 	JP	Z,LOAD		;go if yes
 	CP	'S'		;send file in buffer?
 	JP	Z,SEND		;yes, then go
 	CP	'P'		;Lineprint buffer?
 	JP	Z,PRINT		;yes then go
 	CP	'I'		;input your own text?
 	JP	Z,INPUT		;go if yes
 	LD	A,08H		;back space it
 	CALL	33H		;on the video
 	JR	MENU		;else not available
 ADJUST	CALL	01C9H		;clear the video
 	LD	HL,INS1		;point to options
 	CALL	DISPLY		;show them
 	LD	A,0EH		;turn on cursor
 	CALL	33H		;do it
 MENU1	CALL	49H		;get option
 	CALL	33H		;display it
 	CP	'F'		;adjust frequency?
 	JR	Z,ADFREQ	;go if yes
 	CP	'S'		;else change speed?
 	JR	Z,ADSPD		;go if yes
 	CP	'E'		;else back to main menu
 	JP	Z,MORSE		;go if yes
 	CP	' '		;else make a sound
 	CALL	Z,TEST1		;go if wanted
 	LD	A,08H		;back space
 	CALL	33H		;do it on video
 	JR	MENU1		;else not valid
 ADFREQ	LD	HL,INS2		;point to instructions
 	CALL	DISPLY		;show them
 MENU2	CALL	49H		;wait for inkey
 	CP	01H		;break key?
 	JR	Z,ADJUST	;other menu then
 	CP	5BH		;else up arrow
 	JR	Z,RAISE		;go raise it
 	CP	10		;else down arrow?
 	JR	Z,LOWER		;go lower it then
 	CP	' '		;else want a sound?
 	CALL	Z,TEST1		;go if yes
 	JR	MENU2		;back to routine
 RAISE	LD	(3C3EH),A	;show up arrow
 	LD	A,(NOTE)	;get note
 	INC	A		;add one to it
 SVNOTE	LD	(NOTE),A	;save note
 	LD	(NOTE1),A	;again
 	LD	(NOTE2),A	;in space routine now
 	LD	(NOTE3),A	;again
 	LD	HL,0000H	;reset hl to zero
 	LD	L,A		;get lsb for display
 	CALL	BINASC		;show number
 	JR	MENU2		;back to menu
 LOWER	LD	A,5CH		;show down arrow
 	LD	(3C3EH),A	;on the video
 	LD	A,(NOTE)	;get note
 	DEC	A		;minus one from it
 	JR	SVNOTE		;and save new value
 TEST1	LD	A,2		;set up for dit
 	LD	(COUNT),A	;1 dit
 	CALL	DIT		;sound a dit
 	LD	A,2		;set time
 	LD	(COUNT),A	;save value
 	CALL	WAIT		;wait between dits
 	LD	A,6		;dah = 3 dits
 	LD	(COUNT),A	;save it
 	CALL	DIT		;sound a dash
 	LD	A,8		;reset wait time
 	LD	(COUNT),A	;wait 1 dit
 	CALL	WAIT		;wait a bit
 	LD	A,(3840H)	;look for space bar
 	CP	80H		;pressed
 	RET	Z		;back if pressed
 	JR	TEST1		;else loop til done
 ADSPD	LD	HL,INS2		;point to instructions
 	CALL	DISPLY		;show them
 MENU3	CALL	49H		;wait for inkey
 	CP	5BH		;increase speed?
 	JR	Z,FAST		;yes then go faster
 	CP	10		;else slow it down?
 	JR	Z,SLOW		;yes then go
 	CP	' '		;else a test
 	CALL	Z,TEST1		;yes then do it
 	CP	01H		;else break
 	JP	Z,ADJUST	;back to adjust
 	JR	MENU3		;back if no match
 FAST	LD	HL,(SPEED)	;get speed value
 	DEC	HL		;minus one from it
 	LD	A,H		;test for zero
 	OR	L		;0=no go
 	JR	Z,MENU3		;go if too low
 FASTSV	LD	(SPEED),HL	;save new value
 	CALL	BINASC		;show new value speed
 	JR	MENU3		;and back to menu
 SLOW	LD	HL,(SPEED)	;get speed
 	INC	HL		;add one to value
 	JR	FASTSV		;and save and return
 DIT	LD	A,(COUNT)	;get count
 	LD	C,A		;get number times
 DIT1	LD	DE,(SPEED)	;get speed value
 SUB	DEFB	06H		;start of LD B
 NOTE	DEFB	42		;note value
 	LD	A,01H		;toggle bit
 	OUT	(0FFH),A	;send it
 TONE	DJNZ	TONE		;wait
 	DEFB	06H		;LD B again
 NOTE1	DEFB	42		;note value
 	INC	A		;add one to it
 	OUT	(0FFH),A	;send it out
 TONE1	DJNZ	TONE1		;delay
 	DEC	DE		;get speed
 	LD	A,D		;test for done
 	OR	E		;0 = done
 	JR	NZ,SUB		;loop for speed
 	DEC	C		;get dot times
 	JR	NZ,DIT1		;loop til done
 	RET			;and back to caller
 WAIT	LD	A,(COUNT)	;get dot times
 	LD	C,A		;move for routine
 DIT2	LD	DE,(SPEED)	;get speed value
 SUB1	DEFB	06H		;LD B op
 NOTE2	DEFB	42		;value
 	LD	A,1		;toggle byte
 	OUT	(1),A		;dummy send
 TONE2	DJNZ	TONE2		;settle time
 	DEFB	06H		;LD B again
 NOTE3	DEFB	42		;note value
 	INC	A		;add one to it
 	OUT	(1),A		;dummy send
 TONE3	DJNZ	TONE3		;loop til done
 	DEC	DE		;get speed -1
 	LD	A,D		;test for 0
 	OR	E		;0=done
 	JR	NZ,SUB1		;loop for speed
 	DEC	C		;minus 1 from count
 	JR	NZ,DIT2		;loop for count
 	RET			;back to routine
 DISPLY	LD	A,(HL)		;get a byte
 	CP	03H		;end of msg
 	RET	Z		;back if yes
 	CALL	33H		;else display it
 	INC	HL		;point to next
 	JR	DISPLY		;loop til done
 BINASC	PUSH	HL		;save value
 	LD	DE,NBUFF	;point to number
 	LD	HL,(4020H)	;get cursor address
 	LD	(VIDEO),HL	;save it
 	POP	HL		;restore value
 	LD	BC,-10000	;10 to 4th
 	CALL	CALC		;go calculate it
 	LD	BC,-1000	;10 to 3rd
 	CALL	CALC		;count them
 	LD	BC,-100		;10 to 2nd
 	CALL	CALC		;count then
 	LD	BC,-10		;10's units
 	CALL	CALC		;count them
 	LD	BC,-1		;and finally units
 	CALL	CALC		;and count them
 	LD	HL,NBUFF	;point to buffer
 	LD	B,5		;digits to display
 SHLP	LD	A,(HL)		;get a number
 	CALL	33H		;show it on video
 	INC	HL		;point to next
 	DJNZ	SHLP		;loop til five shown
 	LD	HL,(VIDEO)	;get video address
 	LD	(4020H),HL	;reset video
 	RET			;back to caller
 CALC	LD	A,0FFH		;start at -1
 CAL1	INC	A		;and add 1 to zero
 	ADD	HL,BC		;do a subtract to 10's
 	JR	C,CAL1		;loop til out of range
 	OR	A		;clear the flags for add
 	SBC	HL,BC		;back to previous value
 	ADD	A,30H		;convert to ASCII
 	LD	(DE),A		;store in the buffer
 	INC	DE		;point to next
 	RET			;back to routine
 ALPHA	CALL	01C9H		;clear the video
 	LD	HL,HEAD		;point to title
 	CALL	DISPLY		;show it
 	LD	IX,TABLE	;point to alphabet
 ALPHA1	LD	HL,(4020H)	;get video location
 	LD	DE,16		;set next zone
 	ADD	HL,DE		;get the address
 	LD	(VIDEO),HL	;and save it
 	LD	A,(3840H)	;get a key
 	CP	04H		;look at break key
 	JR	Z,END		;go if break pressed
 	LD	A,(IX)		;get the character
 	CALL	33H		;display it
 	PUSH	HL		;save hl
 	LD	HL,TEXT		;point to -
 	CALL	DISPLY		;show it on video
 	POP	HL		;continue now
 CHLP	INC	IX		;point to .-.
 	LD	A,(IX)		;get a byte
 	CP	':'		;is it a dit
 	JR	Z,FNDDIT	;go if yes
 	CP	'-'		;else is it a dah?
 	JR	Z,FNDDAH	;go if yes
 	CP	0FFH		;else end of table?
 	JR	Z,END		;go if end
 	LD	HL,(VIDEO)	;get next address
 	LD	(4020H),HL	;reset screen now
 	LD	A,8		;set delay tween letters
 	LD	(COUNT),A	;set it up
 	CALL	WAIT		;and delay
 	JR	ALPHA1		;loop til done
 END	LD	HL,MSG		;point to message
 	CALL	DISPLY		;show it
 AGAIN	CALL	49H		;wait for inkey
 	CP	01H		;break still pressed?
 	JR	Z,AGAIN		;wait then
 	JP	MORSE		;and restart
 FNDDIT	LD	A,'.'		;get a period
 	CALL	33H		;show the .
 	LD	A,2		;set count to 1
 	LD	(COUNT),A	;save value
 	CALL	DIT		;go send a dit
 	JR	CONTIN		;and continue
 FNDDAH	CALL	33H		;show it
 	LD	A,6		;set for 3 dits
 	LD	(COUNT),A	;set it up
 	CALL	DIT		;send the dah
 CONTIN	LD	A,2		;wait one character
 	LD	(COUNT),A	;set i tup
 	CALL	WAIT		;and wait
 	JR	CHLP		;loop back for another
 ERROR	SET	7,A		;show error
 	CALL	4409H		;display error on video
 	CALL	49H		;and read it
 	JP	MORSE		;back to menu
 LOAD	LD	HL,PROMPT	;point to prompt
 	CALL	DISPLY		;show it
 	LD	HL,NAME		;point to buffer
 	LD	B,20		;characters for input
 	CALL	40H		;get the input
 	JP	C,MORSE		;back on break
 	LD	HL,DUMMY	;else point to I/O
 	LD	DE,NAME		;point to name
 	LD	B,00H		;set LRL=256
 	CALL	4424H		;open don't create
 	JP	NZ,ERROR	;go if error
 	LD	HL,TBUFF	;point to text buffer
 READ	LD	DE,NAME		;point to DCB
 	CALL	13H		;read a byte
 	JR	NZ,EOF		;go if end of file
 	LD	(HL),A		;else save the character
 	INC	HL		;point to next
 	LD	A,(3C3EH)	;get video char
 	XOR	0AH		;toggle a *
 	LD	(3C3EH),A	;put back original
 	JR	READ		;loop til all read
 EOF	LD	(MARKER),HL	;save end address
 	LD	HL,CODE		;point to message
 	CALL	DISPLY		;show it
 	LD	IX,TBUFF	;point to buffer
 	LD	HL,TBUFF	;point to buffer
 CONV	LD	A,(3C3FH)	;get screen byte
 	XOR	0AH		;toggle a *
 	LD	(3C3FH),A	;put it back now
 	LD	A,(HL)		;get a byte
 	CP	'?'		;is it a ?
 	JR	Z,OK		;yes then ok
 	CP	'/'		;else a /
 	JR	Z,OK		;go if yes
 	CP	'.'		;else a period
 	JR	Z,OK		;go if ok
 	CP	','		;else is it a comma?
 	JR	Z,OK		;go if ok
 	CP	'0'		;check for lower <0
 	JR	C,MAKESP	;go make it a space
 	CP	':'		;check for a number
 	JR	C,OK		;leave if yes
 	CP	'A'		;check for punctuation
 	JR	C,MAKESP	;go make it a space
 	CP	'Z'		;check for upper case
 	JR	C,OK		;go if ok
 	CP	'a'		;check for lower case
 	JR	C,MAKESP	;go make it a space
 	CP	'z'		;check for lower case
 	JR	C,UPPER		;move it upper now
 MAKESP	DEC	IX		;back up one
 	LD	A,(IX)		;get the character
 	CP	' '		;is it a space now?
 	JR	Z,FORGET	;forget it if yes
 	INC	IX		;else point to orginal
 	LD	(IX),20H	;and put in a space
 FORGET	INC	IX		;point to next
 TOOLOW	INC	HL		;else point to next
 	LD	DE,(MARKER)	;get end address
 	RST	18H		;end of file?
 	JR	NZ,CONV		;back if not done
 	PUSH	IX		;move IX to hl
 	POP	HL		;and then
 	LD	(MARKER),HL	;save address
 	JP	MORSE		;and we are done
 OK	LD	(IX),A		;move to new location
 	INC	IX		;point to next
 	JR	TOOLOW		;and continue
 UPPER	SUB	20H		;make it upper case
 	JR	OK		;and continue
 SEND	LD	HL,TBUFF	;get start of buffer
 	LD	DE,(MARKER)	;get end of buffer
 	RST	18H		;check for same
 	JP	Z,MORSE		;back if no file
 	CALL	01C9H		;clear the video
 	LD	HL,TBUFF	;else point to text
 CON	LD	IX,TABLE	;point to table
 	LD	A,(HL)		;get a byte
 	CALL	33H		;display it
 	CP	' '		;end of word?
 	JR	Z,ENDWRD	;go then to next
 MATCH	LD	A,(IX)		;get a byte
 	CP	0FFH		;end of table
 	JR	Z,NEXTBT	;goto the next char
 	CP	(HL)		;else same as text?
 	JR	Z,GOTMAT	;go if match
 	INC	IX		;else point to next
 	JR	MATCH		;loop til match
 NEXTBT	INC	HL		;point to next char
 	LD	A,8		;set delay
 	LD	(COUNT),A	;set it up
 	CALL	WAIT		;tween characters.
 	LD	A,(3840H)	;check for break key
 	CP	04H		;pressed?
 	JP	Z,END		;go if yes
 	LD	DE,(MARKER)	;get end of file
 	RST	18H		;compare the two
 	JR	NZ,CON		;go if not done yet
 	LD	HL,ENDMSG	;point to done msg
 	CALL	DISPLY		;show it
 	CALL	49H		;wait for inkey
 	JP	MORSE		;anc back to menu
 ENDWRD	LD	A,8		;set delay count
 	LD	(COUNT),A	;set it up
 	CALL	WAIT		;and do it
 	JR	NEXTBT		;and continue
 GOTMAT	INC	IX		;point to dits dahs
 	LD	A,(IX)		;get byte
 	CP	':'		;is it a dit?
 	JR	Z,FNDIT		;go if dit
 	CP	'-'		;else is it dah
 	JR	NZ,NEXTBT	;go if not : or -
 	LD	A,6		;set it up dah
 	LD	(COUNT),A	;save value
 	JR	GO		;keep going now
 FNDIT	LD	A,2		;set it up
 	LD	(COUNT),A	;save value
 GO	CALL	DIT		;send it out
 	LD	A,2		;set spacing
 	LD	(COUNT),A	;now
 	CALL	WAIT		;wait for spacing
 	JR	GOTMAT		;loop til done
 PRINT	LD	HL,TBUFF	;point to buffer
 PRLP1	LD	DE,(MARKER)	;check for size
 	RST	18H		;same?
 	JP	Z,ENDPRT	;go if end
 	LD	A,(3840H)	;look at keyboard
 	CP	04H		;check for BREAK key
 	JR	Z,ENDPRT	;end routine if pressed
 PRLP	LD	A,(HL)		;else get a byte
 	CALL	3BH		;lprint it
 	INC	HL		;point to next
 	JR	PRLP1		;loop back and check
 ENDPRT	LD	A,0DH		;do a C/R
 	CALL	3BH		;lprint it for end
 	JP	MORSE		;back to menu
 INPUT	CALL	01C9H		;clear the screen
 	LD	HL,INS3		;point to instructions
 	CALL	DISPLY		;show it
 	LD	HL,TBUFF	;point to text buffer
 INLP	CALL	49H		;wait for inkey
 	CP	01H		;BREAK?
 	JP	Z,EOF		;convert now to morse
 	CP	08H		;backspace key
 	JR	Z,PASS		;yes, then don't load it
 	LD	(HL),A		;load it into memory
 	CALL	33H		;show it on video
 	INC	HL		;point to next
 	JR	INLP		;loop til break
 PASS	PUSH	AF		;save the characer
 	LD	DE,TBUFF	;point to start
 	RST	18H		;compare the two
 	JR	Z,ATST		;go if at start
 	POP	AF		;restore char
 	CALL	33H		;display it
 	DEC	HL		;back up one
 	JR	INLP		;and back
 ATST	POP	AF		;fix the stack
 	JR	INLP		;and forget backspace
 MARKER	DEFW 	0000H
 NBUFF	DEFS	6		;for number storage
 VIDEO	DEFW	0000H		;storage for address
 SPEED	DEFW	002BH		;starting value
 COUNT	DEFB	01H		;dit counts
 INS	DEFM	'        Morse Code Program Version 1.0'
 	DEFB	0DH
 	DEFM	'           <c> 1983 by Mel Patrick'
 	DEFW	0D0DH
 	DEFM	'<C>hange Parameters (Frequency, Speed)'
 	DEFB	0DH
 	DEFM	'<A>lphabet Test Cycle'
 	DEFB	0DH
 	DEFM	'<S>end Code in Buffer'
 	DEFB	0DH
 	DEFM	'<L>oad ASCII Text File'
 	DEFB	0DH
 	DEFM	'<P>rint Buffer on Line Printer'
 	DEFB	0DH
 	DEFM	'<I>nput text to buffer from keyboard'
 	DEFB	0DH
 	DEFM	'<E>xit to Dos Ready'
 	DEFW	0D0DH
 	DEFM	'Selection :'
 	DEFB	03H
 INS1	DEFM	'          Change Parameter Option'
 	DEFW	0D0DH
 	DEFM	'<F>requency Up/Down (use arrow keys)'
 	DEFB	0DH
 	DEFM	'<S>peed Fast/Slow (use arrow keys)'
 	DEFB	0DH
 	DEFM	'<SPACE BAR> to test changes'
 	DEFB	0DH
 	DEFM	'<E>xit to main menu'
 	DEFW	0D0DH
 	DEFM	'Selection :'
 	DEFB	03H
 INS2	DEFW	0D0DH
 	DEFM	'Use the Up-Arrow to increase value.'
 	DEFB	0DH
 	DEFM	'Use the Down-Arrow to decrease value.'
 	DEFB	0DH
 	DEFM	'Press <BREAK> to exit.'
 	DEFB	0DH
 	DEFM	'New Parameter Value : '
 	DEFB	03H
 INS3	DEFM	'Use the <S> command from the main menu to send text'
 	DEFB	0DH
 	DEFM	'   Enter any text, press the <BREAK> key to exit'
 	DEFW	0D0DH
 	DEFW	0D0DH
 	DEFB	03H
 PROMPT	DEFB	0DH
 	DEFM	'Filespec : '
 	DEFB	03H
 CODE	DEFW	0D0DH
 	DEFM	'Converting Buffer to Code...'
 	DEFB	03H
 NAME	DEFS	21H
 ENDMSG	DEFW	0D0DH
 	DEFM	'End of text file, press any key...'
 	DEFB	03H
 TABLE	DEFM	'A:-B-:::C-:-:D-::'
 	DEFM	'E:F::-:G--:H::::'
 	DEFM	'I::J:---K-:-L:-::'
 	DEFM	'M--N-:O---P:--:'
 	DEFM	'Q--:-R:-:S:::T-'
 	DEFM	'U::-V:::-W:--X-::-'
 	DEFM	'Y-:--Z--::0-----1:----'
 	DEFM	'2::---3:::--4::::-5:::::'
 	DEFM	'6-::::7--:::8---::9----:'
 	DEFM	'.:-:-:-,--::--?::--::/-::-:'
 	DEFB	0FFH
 TEXT	DEFM	' = '
 	DEFB	03H
 HEAD	DEFM	'          International Morse Code Table'
 	DEFW	0D0DH
 	DEFB	15		;turn off cursor
 	DEFB	03H
 MSG	DEFW	0D0DH
 	DEFM	'End of Function, press <ENTER>...'
 	DEFB	03H
 DUMMY	DEFS	256
 TBUFF	DEFB	00H		;start of text buffer
 	END	START
